<?php
  /*                                Congshan.net
   * ============================================================================
   * 项目:CongMVC
   * 文件:error.php
   * 网址:http://www.congshan.net
   * 作者:<lei@congshan.net> Created on 2014-4-14 1:49:53
   * $time:$
   * $md5:$
   * ============================================================================
   */

  /*
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * 使用Apache License, Version 2.0 开源许可协议
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * Licensed under the Apache License, Version 2.0
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   */
  if (!defined('IN_CONG'))
      die('Waring:Access Denied');

  /**
   *
   * @author Administrator
   */
  class cong_error {

      /*
       * @var int $httpCode  
       */

      public $httpCode = 404;

      /**
       *
       * @var string $tplFile 
       */
      public $tpl;
      /*
       * @var $htmlPage ClassName 
       */
      public $htmlPage = '';
      /*
       * @var string $errstr
       */
      public $errno = '';

      /**
       *
       * @var type 
       */
      public $errstr = '';

      /**
       *
       * @var type 
       */
      public $errfile = '';

      /**
       *
       * @var type 
       */
      public $errline = '';

      /**
       *
       * @var type 
       */
      public $content = '';

      /**
       *
       * @var type 
       */
      public $_log = '';

      /**
       *
       * @var type 
       */
      public $_log_file;

      /**
       *
       * @var type 
       */
      public $_CFG;

      /**
       * 
       * @param array $errorData
       */
      function __construct($errorData) {

          /**
           * 
           */
          //print_r($GLOBALS);
          //require_once CONG_CONFIG . "config.php";
          $this->_CFG = $GLOBALS["CONG"]->_CFG;
          /**
           * 
           */
          date_default_timezone_set($this->_CFG['date']['timezone']);


          if ($this->_CFG['LOG']['DIR'] == 'CONG') {

              $this->_log_file = CONG_LOG . $this->_CFG['LOG']['FILE']['ERROR'] . $this->_CFG['LOG']['FILE']['SUFFIX'];
          }
          else {

              $this->_log_file = MYAPP_LOG . $this->_CFG['LOG']['FILE']['ERROR'] . $this->_CFG['LOG']['FILE']['SUFFIX'];
          }
          /**
           * 
           */
          $this->httpCode = isset($errorData['httpCode']) ? $errorData['httpCode'] : 404;

          $this->errno = isset($errorData['errno']) ? $errorData['errno'] : '';

          $this->errstr = isset($errorData['errstr']) ? $errorData['errstr'] : '';

          $this->errfile = isset($errorData['errfile']) ? $errorData['errfile'] : '';

          $this->errline = isset($errorData['errline']) ? $errorData['errline'] : '';

          /**
           * 
           */
          $this->tpl = MYAPP_TPL . $this->_CFG['TPL'][$this->httpCode];
          /**
           * 
           */
          $this->process_log();

      }

      /**
       * 
       */
      protected function process_log() {
          /**
           * 
           */
          if (file_exists($this->tpl)) {

              $this->htmlPage = file_get_contents($this->tpl);
          }
          else {
              $this->htmlPage = "<p>NOT FOUND ERROR PAGE:$this->tpl</p>CONG_ERROR";
          }
          /**
           * 
           */
          $this->_log = "";
          $this->_log .= "[" . $this->httpCode . "]";

          $this->_log .= "[" . $this->errno . "]";

          $this->_log.="[" . date($this->_CFG['date']['format']) . "]";

          $this->_log.=" " . $this->errstr . " ";

          $this->_log .= "[" . "GET \"" . $_SERVER["REQUEST_URI"] . "\"" . "]";

          $this->_log.="[File:" . $this->errfile . "]";

          $this->_log.="[Line:" . $this->errline . "]";

          $this->_log .= "[" . "IP \"" . $_SERVER["REMOTE_ADDR"] . "\"" . "]";

          $this->_log.="\r\n";
          /**
           * 
           */
          cong_log::W($this->_log_file, $this->_log, $this->_CFG['LOG']['FILE']['SIZE']);

      }

      /**
       * 
       */
      function show() {
          /**
           * 
           */
          cong_header::_header_code($this->httpCode);

          $this->content.="<p>ERROR:" . $this->errno . "</p>";
          $this->content.="<p>Message:" . $this->errstr . "</p>";
          /**
           * 
           */
          if ($this->_show("FILE")) {
              $this->content.="<p>File:" . $this->errfile . "</p>";
          }
          /**
           * 
           */
          if ($this->_show("LINE")) {
              $this->content.="<p>Line:" . $this->errline . "</p>";
          }

          $this->content.="<b>IP:" . $_SERVER["REMOTE_ADDR"] . "</b>";
          /**
           * 
           */
          echo str_replace("CONG_ERROR", $this->content, $this->htmlPage);
          /*
           * 
           */
          $buffer = ob_get_contents();
          ob_end_clean();
          echo $buffer;
          exit();

      }

      /**
       * 
       * @param type $type
       * @return boolean
       */
      protected function _show($type = "FILE") {
          $_SHOW = explode(",", $this->_CFG['LOG']['SHOW']);
          foreach ($_SHOW as $value) {
              if ($type == $value) {
                  return TRUE;
              }
          }

      }

  }  