<?php
  /*                                Congshan.net
   * ============================================================================
   * 项目:CongMVC
   * 文件:cong_file.php
   * 网址:http://www.congshan.net
   * 作者:<lei@congshan.net> Created on 2014-4-18 22:24:51
   * $time:$
   * $md5:$
   * ============================================================================
   */

  /*
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * 使用Apache License, Version 2.0 开源许可协议
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * Licensed under the Apache License, Version 2.0
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   */
  if (!defined('IN_CONG'))
      die('Waring:Access Denied');

  /**
   * @since 1.2.0
   * 文件操作类
   * 使用方法：
   * 1、使用 setPath 或openPath  设定目录
   * 2、以后的操作以设定的目录为基本目录。
   * 3、close 返回LIMITBASE目录
   */
  class cong_file {

      /**
       *
       * @var type 
       */
      private $_CFG_FILE;

      /**
       * 基本操作目录
       * @var type 
       */
      private $limitpath;

      /**
       * 基本上传目录
       * @var type 
       */
      private $limitpath_upload;

      /**
       * 需要上传的文件数量
       * @var type 
       */
      public $count_upload = 0;

      /**
       * 成功上传的文件数量
       * @var type 
       */
      public $count_moved = 0;

      /**
       * 需要保存文件的路径,绝对路径！
       * @var type 
       */
      private $path_upload = "";

      /**
       * 提交的文件域
       * @var type 
       */
      public $_FILES;

      /**
       * 需要移动胡文件
       * @var type 
       */
      private $_NEED_MOVED;

      /**
       * 允许的文件后缀
       * @var type 
       */
      public $limit_upload_suffix = array();

      /**
       * 允许的文件大小
       * @var type 
       */
      public $limit_upload_size = 10;

      /**
       * 文件权限
       * @var type 
       */
      public $umask = 0644;

      /**
       * 错误码
       * @var type 
       */
      public $_code;

      /**
       * 错误消息
       * @var type 
       * 0=>null
       * 1=>success
       * 2=>info
       * 4=>warning
       * 8=>error
       * @var int 
       */
      public $message;

      /**
       * 错误消息数组
       */
      public $message_s;

      /**
       * 目录确认
       * @var bool
       */
      private $path_checked = false;

      /**
       * 上传目录确认
       * @var type 
       */
      private $path_upload_checked = false;

      /**
       * 文件句柄
       */
      public $file;
      public $handle;
      public $content;

      /**
       * 初始设置
       */
      function __construct() {

          $this->_CFG_FILE = loadConfig("file.config", "CONG:", "file");

          $this->limitpath = LIMITPATH;
          $this->limitpath_upload = $this->_CFG_FILE["upload"]["path"];

          /**
           * 切换到基本操作目录。
           */
          $this->chdir($this->limitpath);

          /**
           * 处理上传配置信息。
           */
          $this->limit_upload_suffix = explode(".", $this->_CFG_FILE["upload"]["limit"]["suffix"]);
          $this->limit_upload_size = $this->_CFG_FILE["upload"]["limit"]["size"];
          $this->umask = $this->_CFG_FILE["upload"]["umask"];

      }

      /**
       * 重载系统函数CHDIR()
       * @param string $directory
       */
      function chdir($directory = null) {

          if (!$directory) {
              return false;
          }
          if (!is_dir($directory)) {
              return FALSE;
          }
          if ($this->checkLimit($directory)) {
              return FALSE;
          }
          $this->path_checked = TRUE;
          return chdir($directory);

      }

      /**
       * 
       * @param type $path
       */
      function setPath($path) {

          return $this->chdir($path);

      }

      /**
       * 
       * @param string $path
       * @return boolean
       */
      function setUploadPath($path = null) {

          $path = $this->limitpath_upload . DS . $path . DS;

          if (!file_exists($path)) {
              $this->mkdir($path);
          }
          $this->path_upload = LIMITPATH . $path;
          $this->path_upload_checked = TRUE;
          $this->processUploadFiles();
          return TRUE;

      }

      function open($file, $mode = 'r') {
          if (!file_exists($file) || !is_readable($file) || !is_file($file)) {
              return FALSE;
          }
          if ($this->checkLimit($file)) {
              return FALSE;
          }
          $this->handle = @fopen($file, $mode);
          if ($this->handle) {
              $this->file = $file;
              return TRUE;
          }
          return FALSE;

      }

      /**
       * 
       */
      function close() {

          @fclose($this->handle);
          $this->handle = null;
          $this->chdir($this->limitpath);

      }

      function checkLimit($file) {

          if ($this->checkDirLimit($file)) {
              return TRUE;
          }
          if ($this->checkFileLimit($file)) {
              return TRUE;
          }
          return FALSE;

      }

      /**
       * @since 1.2.0
       * 检查操作目录是否在限定目录。
       * @param type $path
       */
      function checkDirLimit($path = ".", $limit = null) {

          /**
           * 是否在基本限定目录
           */
          if (is_file($path)) {
              $path = dirname($path);
          }
          if (!is_dir($limit)) {
              $limit = dirname($limit);
          }
          $path = realpath($path);

          $limit_base = realpath($this->limitpath);
          $_pos = stripos($path, $limit_base);
          $_len = strlen($limit_base);

          if ($_pos === FALSE || $_pos > $_len) {
              $this->_code = 8;
              $this->message = "禁止访问基本限定目录以外目录";
              return TRUE;
          }
          /**
           * 
           *
            if (empty($limit)) {
            return FALSE;
            }
            $limit = realpath($limit);
            $_pos = stripos($path, $limit);
            if ($_pos === FALSE) {
            $this->_code = 4;
            $this->message = "禁止访问的目录";
            return TRUE;
            }
           * 
           */
          return FALSE;

      }

      /**
       * 限制访问的文件
       * @return boolean
       */
      function checkFileLimit($file) {

          $file = basename($file);
          $_limit = array(
                "cong.file.php",
                "file.config.php",
                "db.config.php"
          );
          if (in_array($file, $_limit)) {
              $this->_code = 8;
              $this->message = "禁止访问的文件.";
              return true;
          }
          return FALSE;

      }

      function read($start, $len = null) {
          if (!$this->handle) {
              $this->_code = 8;
              $this->message = "没有可用的打开句柄";
              return FALSE;
          }
          $_size = filesize($this->file);
          $this->content = '';
          if ($start == 0 && $len >= $_size) {
              $this->content = file_get_contents($this->file);
              return TRUE;
          }
          if ($start >= 0 && ($len > 0 || $len == null)) {
              fseek($this->handle, $start);
          }
          elseif ($start >= 0 && $len < 0) {
              fseek($this->handle, $start + $len);
          }
          elseif ($start < 0 && ($len > 0 || $len == null)) {
              fseek($this->handle, $_size + $start);
          }
          elseif ($len < 0 && $start < 0) {
              fseek($this->handle, $_size + $start + $len);
          }

          $this->content = '';
          while (!feof($this->handle)) {
              if ($len == null) {
                  $this->content.=fgetc($this->handle);
              }
              else {
                  $len = abs($len);
                  $this->content.=fgetc($this->handle);
                  if (strlen($this->content) > $len) {
                      break;
                  }
              }
              if ($this->content == FALSE) {
                  break;
              }
          }
          rewind($this->handle);

      }

      /**
       * 写文件内容
       * @param type $content
       * @param type $start
       * @param type $len
       * @return boolean
       */
      function write($content, $start = 0, $len = null) {

          if (!$this->handle) {
              $this->_code = 8;
              $this->message = "没有可用的打开句柄";
              return FALSE;
          }
          if ($start >= 0) {
              fseek($this->handle, $start);
          }
          elseif ($start < 0) {
              $_size = filesize($this->file);
              fseek($this->handle, $_size + $start);
          }
          if ($len > 0) {
              fwrite($this->handle, $content, $len);
          }
          else {
              fwrite($this->handle, $content);
          }

      }

      /**
       * rm 删除操作,可选参数 -r -f 
       * @param string $file
       * @param string $opt -f-r可选。
       */
      function rm($file, $opt = null) {

          if (!empty($opt)) {
              $opt = explode('-', $opt);
          }
          else {
              $opt = array();
          }
          if (!file_exists($file)) {
              $this->_code = 4;
              $this->message = "删除失败,文件不存在";
              return FALSE;
          }
          /**
           * 是否为目录外目录。
           */
          if ($this->checkLimit($file)) {

              return false;
          }
          if (is_file($file)) {
              if (!is_writable($file) && !in_array('f', $opt)) {
                  $this->_code = 4;
                  $this->message = "删除失败,只读文件。";
                  return FALSE;
              }
              else {
                  chmod($file, 0777);
                  @unlink($file);
              }
              return TRUE;
          }
          if (is_dir($file)) {
              $handle = opendir($file);
              $_empty = TRUE;
              while (false !== ( $item = readdir($handle) )) {
                  if ($item != "." && $item != "..") {
                      if (!is_dir("$file/$item") && !in_array('r', $opt)) {

                          $this->rm("$file/$item", $opt);
                      }
                      else {

                          $_empty = FALSE;
                      }
                  }
              }
              closedir($handle);
              if ($_empty) {
                  @rmdir($file);
                  return TRUE;
              }
              else {
                  $this->_code = 2;
                  $this->message = "有二级目录，已删除目录下文件。删除目录树请使用 -r 参数";
                  return FALSE;
              }
          }

      }

      /**
       * 建立目录树
       * @param type $path
       * @param type $mode
       * @return boolean
       */
      function mkdir($path = null, $mode = 0755) {

          if (!$path || !$this->checkPathName($path)) {

              return FALSE;
          }
          if (is_dir($path)) {
              $this->_code = 2;
              $this->message = "目录已经存在";
              return FALSE;
          }
          $path = preg_replace('/\\\+/', '/', $path);
          $path_array = explode("/", $path);
          $_path_array = array();
          for ($i = 0; $i <= count($path_array); $i++) {
              if (!empty($path_array[$i])) {
                  $_path_array[] = $path_array[$i];
              }
          }
          $_now = "";
          for ($i = 0; !empty($_path_array[$i]); $i++) {
              $_now.= $_path_array[$i] . DS;
              if (is_dir($_now)) {
                  continue;
              }
              else {
                  mkdir($_now, $mode);
              }
          }

      }

      /**
       * 目录删除
       * @param type $path
       * @param type $opt
       * @return boolean
       */
      function rmdir($path = null, $opt = null) {
          if (!$path) {
              return FALSE;
          }
          if (!is_dir($path)) {
              $this->_code = 4;
              $this->message = "目录不存在";
              return false;
          }
          $this->rm($path, $opt);

      }

      /**
       * 文件删除
       * @param type $path
       * @param type $opt
       * @return boolean
       */
      function unlink($path = null, $opt = null) {
          if (!$path) {
              return FALSE;
          }
          if (!is_file($path)) {
              $this->_code = 4;
              $this->message = "文件不存在";
              return false;
          }
          $this->rm($path, $opt);

      }

      function checkFileName($path) {
          if (preg_match('/[\/\|\?\*\:\<\>\'\"\\\]+/', $path)) {
              $this->_code = 8;
              $this->message = "文件名不符合规则，不能包含 \ / ? * > < : | ' \" ";
              return FALSE;
          }
          return true;

      }

      function checkPathName($path) {
          if (preg_match('/[\|\?\*\:\<\>\'\"]+/', $path)) {
              $this->_code = 8;
              $this->message = "目录名不符合规则，不能包含 ? * > < : | ' \" ";
              return FALSE;
          }
          return true;

      }

      /**
       * 
       * @param type $file
       * @param type $umask
       */
      function chmod($file, $umask) {

          chmod($file, $umask);

      }

      /**
       * 转换上传文件
       * @return boolean
       */
      function processUploadFiles() {
          if (!isset($_FILES)) {
              return FALSE;
          }
          $this->_FILES = $_FILES;
          foreach ($this->_FILES as $key => $file) {
              if (is_array($file["name"])) {

                  foreach ($file["name"] as $_key => $_name) {
                      $this->_FILES[$key][$_key]["name"] = $_name;
                      $this->_FILES[$key][$_key]["type"] = $file["type"][$_key];
                      $this->_FILES[$key][$_key]["tmp_name"] = $file["tmp_name"][$_key];
                      $this->_FILES[$key][$_key]["error"] = $file["error"][$_key];
                      $this->_FILES[$key][$_key]["size"] = $file["size"][$_key];
                      $this->_FILES[$key][$_key]["ext"] = $this->fileEXT($_name);
                  }
                  unset($this->_FILES[$key]["name"]);
                  unset($this->_FILES[$key]["type"]);
                  unset($this->_FILES[$key]["tmp_name"]);
                  unset($this->_FILES[$key]["error"]);
                  unset($this->_FILES[$key]["size"]);
                  $this->count_upload++;
              }
              else {
                  $this->_FILES[$key]['ext'] = $this->fileEXT($this->_FILES[$key]['name']);
              }

              $this->count_upload++;
          }

      }

      /**
       * 
       * @param type $input
       */
      function processNeedMoved($input) {

          /**
           * 指定的FILE FROM
           */
          if ($input && !empty($this->_FILES[$input])) {

              if (!isset($this->_FILES[$input]["name"])) {
                  foreach ($this->_FILES[$input] as $key => $file) {
                      $file["input"] = $input;
                      /**
                       * 检查文件是否符合规则
                       */
                      if ($this->checkUploadLimit($file)) {
                          $this->_NEED_MOVED[] = $file;
                      }
                      else {
                          $this->_code = 4;
                          $this->message_s[] = array(
                                "file" => $file["name"],
                                "message" => $this->message
                          );
                      }
                  }
                  //unset($this->_FILES[$input]);
              }
              else {
                  /**
                   * 指定的文件
                   */
                  $this->_FILES[$input]["input"] = $input;
                  if ($this->checkUploadLimit($this->_FILES[$input])) {
                      $this->_NEED_MOVED = $this->_FILES[$input];
                  }
                  else {
                      $this->_code = 4;
                      $this->message_s[] = array(
                            "file" => $this->_FILES[$input]["name"],
                            "message" => $this->message
                      );
                  }
              }
          }
          else {
              /**
               * 全部的上传文件
               */
              foreach ($this->_FILES as $key => $file) {
                  if (!isset($file["name"])) {
                      foreach ($file as $_key => $_file) {

                          /**
                           * 检查文件是否符合规则
                           */
                          if ($this->checkUploadLimit($_file)) {
                              $_file["input"] = $key;
                              $this->_NEED_MOVED[] = $_file;
                          }
                          else {
                              $this->_code = 4;
                              $this->message_s[] = array(
                                    "file" => $_file["name"],
                                    "message" => $this->message
                              );
                          }
                      }
                      //unset($this->_FILES[$key]);
                  }
                  else {

                      /**
                       * 检查文件是否符合规则
                       */
                      if ($this->checkUploadLimit($file)) {
                          $file["input"] = $key;
                          $this->_NEED_MOVED[] = $file;
                      }
                      else {
                          $this->_code = 4;
                          $this->message_s[] = array(
                                "file" => $file["name"],
                                "message" => $this->message
                          );
                      }
                  }
              }
          }

      }

      /**
       * 移动上传文件至指定目录
       * @param type $input_name
       */
      function uploadFile($input_name = null, $name_prefix = null, $cover = false) {
          if (!$this->path_upload_checked) {
              $this->_code = 8;
              $this->message = "上传错误，上传目录没有CHECKED确认.";
              return FALSE;
          }
          /**
           * 处理需要移动的文件
           */
          $this->processNeedMoved($input_name);

          /**
           * move begin
           */
          for ($i = 0; !empty($this->_NEED_MOVED[$i]); $i++) {

              /**
               * 如果文件名存在则则随即重命名。
               * 如果要修改请修改 RANDNAME（）。
               */
              while (file_exists($this->path_upload . $this->_NEED_MOVED[$i]["name"])) {
                  if ($cover) {
                      unlink($this->path_upload . $this->_NEED_MOVED[$i]["name"]);
                      break;
                  }
                  else {
                      $rand_name = $this->randName();
                      $this->_NEED_MOVED[$i]["r_name"] = $this->_NEED_MOVED[$i]["name"];
                      $this->_NEED_MOVED[$i]["name"] = $rand_name . "_" . $this->_NEED_MOVED[$i]["name"];
                  }
              }
              /**
               * 移动临时文件。
               */
              move_uploaded_file($this->_NEED_MOVED[$i]["tmp_name"], $this->path_upload . $name_prefix . $this->_NEED_MOVED[$i]["name"]);

              /**
               * 返回成功上传文件的路径。
               */
              $this->Uploaded[$i]["name"] = $this->_NEED_MOVED[$i]["name"];
              $this->Uploaded[$i]["input"] = $this->_NEED_MOVED[$i]["input"];
              $this->Uploaded[$i]["r_name"] = $this->_NEED_MOVED[$i]["r_name"];
              $this->chmod($this->path_upload . $this->_NEED_MOVED[$i]["name"], $this->umask);
              $this->count_moved++;
          }

      }

      /**
       * 文件重名随机生成函数。
       * @return type
       */
      function randName() {
          /**
           * 文件重名随机生成函数。
           */
          return rand(0, 1000);

      }

      /**
       * 简单问文件扩展名获取。
       * @param type $file
       * @return string
       */
      static function fileEXT($file) {
          $pathinfo = pathinfo($file);
          if (empty($pathinfo['extension'])) {
              return 'unknown';
          }
          return $pathinfo['extension'];

      }

      function checkUploadLimit($fileInfo) {
          /**
           * MB
           */
          $this->_code = 0;
          $this->message = "";
          $max = $this->limit_upload_size * 1024 * 1024;
          $systemCode = array(
                '1' => '文件大小超出 upload_max_filesize 限制',
                '2' => '文件大小超出 MAX_FILE_SIZE 限制',
                '3' => '文件未被完整上传',
                '4' => '没有文件被上传',
                '5' => '上传文件为空',
                '6' => '缺少临时文件夹',
                '7' => '写文件失败',
                '8' => '上传被其它扩展中断');
          if (!empty($systemCode[$fileInfo['error']])) {
              $this->_code = 8;
              $this->message = $systemCode[$fileInfo['error']];
              return FALSE;
          }
          if ($fileInfo['size'] > $max) {
              $this->_code = 8;
              $this->message = "文件大小超过限制:{$this->limit_upload_size}MB";
              return FALSE;
          }
          if (!$this->checkFileName($fileInfo['name'])) {
              $this->_code = 8;
              $this->message = "文件名不符合规则。";
              return FALSE;
          }
          if (!in_array($fileInfo['ext'], $this->limit_upload_suffix)) {
              $this->_code = 8;
              $this->message = "不能接受的文件类型！";
              return FALSE;
          }

          if ($fileInfo['error'] == 0) {
              return TRUE;
          }

      }

  }
//END