<?php
  /*                                Congshan.net
   * ============================================================================
   * 项目:CongMVC
   * 文件:cong_hook.php
   * 网址:http://www.congshan.net
   * 作者:<lei@congshan.net> Created on 2014-4-14 17:31:04
   * $time:$
   * $md5:$
   * ============================================================================
   */

  /*
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * 使用Apache License, Version 2.0 开源许可协议
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * Licensed under the Apache License, Version 2.0
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   */
  if (!defined('IN_CONG'))
      die('Waring:Access Denied');

  /**
   * Description of cong_hook
   *
   * @author Administrator
   */
  class cong_hook {

      private $CONG;
      private $hook_points = array();
      public $hook_point = '';
      public $hook_class = '';
      public $hook_instance = '';
      public $hook_function = '';
      public $hook_file = '';
      public $hook_path = '';
      public $hook_param = array();
      public $hook_return = '';
      public $_CFG_HOOKS;

      function __construct() {
          $this->CONG = CONG::CONG();
          $this->_CFG_HOOKS = isset($this->CONG->_CFG["HOOK"]) ? $this->CONG->_CFG["HOOK"] : NULL;

      }

      function setHook($hook_point) {
          if (in_array($hook_point, $this->hook_points)) {
              echo "Hook point $hook_point has defined!<br/>";
          }
          else {
              $this->hook_points[] = $hook_point;
              $this->hook_point = $hook_point;

              if (is_array($this->_CFG_HOOKS)) {
                  $this->execHook();
              }
          }

      }

      /**
       * 执行HOOK FUNCTION
       */
      protected function execHook() {

          if (array_key_exists($this->hook_point, $this->_CFG_HOOKS)) {

              /**
               * 获取HOOK 配置
               */
              $this->hook_file = $this->_CFG_HOOKS[$this->hook_point]['file'];
              $this->hook_function = $this->_CFG_HOOKS[$this->hook_point]['function'];
              $this->hook_path = $this->_CFG_HOOKS[$this->hook_point]['path'];
              $this->hook_param = $this->_CFG_HOOKS[$this->hook_point]['param'];

              if (!empty($this->hook_file)) {

                  $type = substr($this->hook_path, 0, 5);
                  if ($type == "CONG:") {
                      $path = substr($this->hook_path, 6) . DS;
                      $_hook_file = CONG_HOOK . $path . $this->hook_file . EXT;
                  }
                  else {
                      $path = $path . DS;
                      $_hook_file = MYAPP_HOOK . $path . $this->hook_file . EXT;
                  }

                  if (file_exists($_hook_file)) {
                      require_once $_hook_file;
                  }
                  if (function_exists($this->hook_function)) {
                      $func = $this->hook_function;
                      $this->hook_return = $func($this->hook_param);
                  }
              }
          }

      }

  }  