<?php
  /*                                Congshan.net
   * ============================================================================
   * 项目:CongMVC
   * 文件:cong_load.php
   * 网址:http://www.congshan.net
   * 作者:<lei@congshan.net> Created on 2014-4-14 13:46:37
   * $time:$
   * $md5:$
   * ============================================================================
   */

  /*
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * 使用Apache License, Version 2.0 开源许可协议
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * Licensed under the Apache License, Version 2.0
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   */
  if (!defined('IN_CONG'))
      die('Waring:Access Denied');

  /**
   * Description of cong_load
   *
   * @author Administrator
   */
  class cong_load {

      /**
       *
       * @var instance of app
       */
      private $theApp;

      function __construct() {
          $this->theApp = cong_myapp::myapp_instance();

      }

      /**
       * 自动加载
       */

      /**
       * autoload
       */
      function autoLoad() {
          if (!$this->theApp->_CFG['autoload']['active']) {
              return;
          }
          /**
           * 加载函数
           */
          if (!empty($this->theApp->_CFG['autoload']['script'])) {

              $_detect_ = array();

              foreach ($this->theApp->_CFG['autoload']['script'] as $script) {

                  if (!empty($script)) {

                      $params = explode(",", $script);

                      foreach ($params as $value) {

                          $_params = explode("=", $value);
                          $_detect_[$_params[0]] = $_params[1];
                      }

                      if (empty($_detect_["path"])) {

                          $_detect_["path"] = null;
                      }

                      $this->theApp->LOAD->script($_detect_["file"], $_detect_["path"]);
                  }
              }
          }


          /*
           * 自动加载 模型
           */
          if (!empty($this->theApp->_CFG['autoload']['model'])) {
              /**
               * 
               */
              $_detect_ = array();

              foreach ($this->theApp->_CFG['autoload']['model'] as $value) {

                  $params = explode(",", $value);

                  foreach ($params as $value) {

                      $_params = explode("=", $value);
                      $_detect_[$_params[0]] = isset($_params[1]) ? $_params[1] : null;
                  }

                  if (!empty($_detect_["model"])) {

                      if (empty($_detect_["name"])) {

                          $_detect_["name"] = $_detect_["model"];
                      }

                      if (empty($_detect_["path"])) {

                          $_detect_["path"] = null;
                      }

                      $this->theApp->LOAD->model($_detect_["model"], $_detect_["name"], $_detect_["path"]);

                      if (!empty($_detect_["action"])) {

                          $this->theApp->$_detect_["name"]->$_detect_["action"]();
                      }
                  }

                  $_detect_["name"] = "";
              }
          }


          /**
           * @since 1.1.3
           */
          if (!empty($this->theApp->_CFG['autoload']['lang'])) {
              $_detect_ = array();
              $params = explode(",", $this->theApp->_CFG['autoload']['lang']);

              foreach ($params as $value) {

                  $_params = explode("=", $value);
                  $_detect_[$_params[0]] = isset($_params[1]) ? $_params[1] : null;
              }

              if (!empty($_detect_["lang"])) {

                  if (empty($_detect_["path"])) {

                      $_detect_["path"] = null;
                  }

                  $this->theApp->LOAD->lang($_detect_['lang'], $_detect_['path']);
              }
          }

      }

      function model($model, $name = null, $path = "") {

          /**
           * path= CONG:mymodel/a => CONG_MODEL/mymodel/a 
           * 
           * path= mymodel/a => MYAPP_MODEL/mymodel/a 
           *
           */
          $type = substr($path, 0, 5);
          if ($type == "CONG:") {

              $path = substr($path, 6) . DS;
              $model_file = CONG_MODEL . $path . "model_" . $model . EXT;
          }
          else {

              $path = $path . DS;
              $model_file = MYAPP_MODEL . $path . "model_" . $model . EXT;
          }
          /**
           * 
           */
          $model_class = "model_" . $model;
          if (file_exists($model_file)) {

              require_once $model_file;
          }
          else {
              throw new Exception("Model: {$model_file} not found!");
          }
          if (empty($name) || $name == null) {
              $name = $model;
          }
          if (isset($this->theApp->$name) && !@is_object($this->theApp->$name)) {
              throw new Exception("Model name $name has used in other properties");
          }
          if (!@is_object($this->theApp->$name)) {
              $this->theApp->$name = new $model_class;
          }
          $this->theApp->CONG->_BENCHMARK->mark("load_model_" . $model . "_end");

      }

      /**
       * 
       * @param array $script
       * @throws Exception
       */
      function script($script, $path = "") {

          /**
           * path= CONG:mymodel/a => CONG_MODEL/mymodel/a 
           * 
           * path= mymodel/a => MYAPP_MODEL/mymodel/a 
           *
           */
          $type = substr($path, 0, 5);
          if ($type == "CONG:") {

              $path = substr($path, 6) . DS;
              $script_file = CONG_SCRIPT . $path . $script . EXT;
          }
          else {
              $path = $path . DS;
              $script_file = MYAPP_SCRIPT . $path . $script . EXT;
          }
          if (file_exists($script_file)) {
              require_once($script_file);
          }
          else {
              throw new Exception("Script {{$script_file}} not found!");
          }
          $this->theApp->CONG->_BENCHMARK->mark("load_script_" . $script . "_end");

      }

      /**
       * @since 1.0.3
       * @param type $name
       * @param type $path
       * @return boolean
       */
      function lang($name, $path = '') {

          $type = substr($path, 0, 5);
          if ($type == "CONG:") {

              $path = substr($path, 6) . DS;
              $lang_file = CONG_LANG . $path . "lang_" . $name . EXT;
          }
          else {
              $path = $path . DS;
              $lang_file = MYAPP_LANG . $path . "lang_" . $name . EXT;
          }
          if (file_exists($lang_file)) {
              require $lang_file;
              $this->theApp->LANG = isset($lang) ? $lang : null;
              return true;
          }
          return FALSE;

      }

      /**
       * @since 1.0.5
       * 
       * @param type $name
       * @param type $path
       * @param type $call
       * @return false if falier
       * @return value if success
       */
      function config($name, $path = "", $call = null) {

          /**
           * 
           */
          return loadConfig($name, $path, $call);

      }

  }  