<?php
  /*                                Congshan.net
   * ============================================================================
   * 项目:CongMVC
   * 文件:cong_log.php
   * 网址:http://www.congshan.net
   * 作者:<lei@congshan.net> Created on 2014-4-14 15:05:18
   * $time:$
   * $md5:$
   * ============================================================================
   */

  /*
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * 使用Apache License, Version 2.0 开源许可协议
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * Licensed under the Apache License, Version 2.0
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   */
  if (!defined('IN_CONG'))
      die('Waring:Access Denied');

  /**
   * Description of cong_log
   *
   * @author Administrator
   */
  class cong_log {

      private $CONG;

      /**
       *
       * @var type 
       */
      private $_CFG_LOG;

      /**
       * 
       * @param type $config
       */
      function __construct() {
          $this->CONG = CONG::CONG();
          $this->_CFG_LOG = $this->CONG->_CFG['LOG'];

      }

      /**
       * @since 1.0.1
       * 记录SQL查询。
       * @param type $_sql
       */
      function _SQL($_sql = null) {

          if ($this->_CFG_LOG['DIR'] == 'CONG') {

              $file = CONG_LOG . $this->_CFG_LOG['FILE']['SQL'] . $this->_CFG_LOG['FILE']['SUFFIX'];
          }
          else {

              $file = MYAPP_LOG . $this->_CFG_LOG['FILE']['SQL'] . $this->_CFG_LOG['FILE']['SUFFIX'];
          }
          if (!$this->_CFG_LOG['SQL']) {

              self::D($file);
              return FALSE;
          }
          $max = $this->_CFG_LOG['FILE']['SIZE'];
          $_temp_content = "";
          if (!empty($_sql)) {
              foreach ($_sql as $value) {
                  /**
                   * LOG IP
                   */
                  $_temp_content.='[' . $_SERVER["REMOTE_ADDR"] . ']';
                  foreach ($value as $_value) {
                      $_temp_content.='[' . $_value . ']';
                  }
                  $_temp_content.="\r\n";
              }
              self::W($file, $_temp_content, $max);
          }

      }

      /**
       * 记录GET方法。
       * @param type $_get_
       */
      function _GET($_get_ = null) {

          if ($this->_CFG_LOG['DIR'] == 'CONG') {

              $file = CONG_LOG . $this->_CFG_LOG['FILE']['GET'] . $this->_CFG_LOG['FILE']['SUFFIX'];
          }
          else {

              $file = MYAPP_LOG . $this->_CFG_LOG['FILE']['GET'] . $this->_CFG_LOG['FILE']['SUFFIX'];
          }
          if (!$this->_CFG_LOG['GET']) {

              self::D($file);
              return FALSE;
          }

          $max = $this->_CFG_LOG['FILE']['SIZE'];
          $_temp_content = "";
          $_temp_content.="[" . date("Y/m/d H:i:s") . "]";
          $_temp_content.="[" . $_SERVER["REMOTE_ADDR"] . "]";
          if ($_get_) {
              $_temp_content .= $_get_;
          }
          else {
              $_temp_content .= $_SERVER["REQUEST_URI"];
          }
          $_temp_content.="\r\n";
          self::W($file, $_temp_content, $max);

      }

      /**
       * @since 1.2.0
       * LOG文件大小限制，最小10MB最大100MB
       * @param type $file
       * @param type $content
       * @param type $max
       */
      static function W($file, $content, $max = 10) {
          /**
           * @since 1.2.0
           * LOG文件大小限制，最小10MB最大100MB
           */
          $_suffix = substr(strtoupper($max), -2, 2);
          $_max = (int) preg_replace("/[^0-9]+/", "", $max);

          if ($_max < 10 || $_max > 100) {
              $_max = 10;
          }
          $_max = $_max * 1024 * 1024;

          if (file_exists($file)) {
              if (filesize($file) > $_max) {
                  self::D($file);
              }
          }

          /**
           * 参数 AB 追加写
           */
          $fp = fopen($file, "ab");
          fwrite($fp, $content);
          fclose($fp);

      }

      /**
       * 删除LOG文件操作
       * @param string $file delete log file
       */
      static function D($file) {

          /**
           * 
           */
          if (is_writable($file)) {
              unlink($file);
              return TRUE;
          }
          return FALSE;

      }

  }
//