<?php
  /*                                Congshan.net
   * ============================================================================
   * 项目:CongMVC
   * 文件:cong_route.php
   * 网址:http://www.congshan.net
   * 作者:<lei@congshan.net> Created on 2014-4-14 15:46:58
   * $time:$
   * $md5:$
   * ============================================================================
   */

  /*
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * 使用Apache License, Version 2.0 开源许可协议
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * Licensed under the Apache License, Version 2.0
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   */
  if (!defined('IN_CONG'))
      die('Waring:Access Denied');

  /**
   * Description of cong_route
   *
   * @author Administrator
   */
  class cong_route {

      private $CONG;
      public $APP;
      public $ACTION;
      public $MYAPP_APPS_TRUE_PATH;
      public $URL_ROOT;
      public $URL;
      public $PATH_INFO;
      private $SEGMENTS;

      /**
       *
       * @var global array $_CFG_ROUTE 
       */
      private $_CFG_ROUTE;

      /**
       * global CFG
       * @param array $_CFG 
       */
      function __construct() {
          $this->CONG = CONG::CONG();

          $this->_CFG_ROUTE = $this->CONG->_CFG["route"];

          $this->_get_uri();
          $this->_route_();
          $this->_v_app_();
          $this->_set_get();
          $this->_end();
          $this->APP = $this->_safe_request($this->APP);
          $this->ACTION = $this->_safe_request($this->ACTION);

      }

      /**
       * 
       * @param type $uri
       * @return type
       */
      private function _safe_uri($uri) {
          $uri = str_replace("//", "/", $uri);
          $uri = str_replace("../", "", $uri);
          /**
           * 参考自CodeIgniter
           */
          $bad = array('$', '(', ')', '%28', '%29');
          $good = array('&#36;', '&#40;', '&#41;', '&#40;', '&#41;');

          return str_replace($bad, $good, $uri);

      }

      private function _end() {
          if (!empty($_GET["action"])) {
              $this->ACTION = $_GET["action"];
          }
          if (!empty($_GET["application"])) {
              $this->APP = $_GET["application"];
          }

      }

      /**
       * 
       */
      private function _get_uri() {
          $this->PATH_INFO = !empty($_SERVER['PATH_INFO']) ? substr($_SERVER['PATH_INFO'], 1) : substr($_SERVER['QUERY_STRING'], 1);
          $this->URL = !empty($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : $_SERVER['SCRIPT_NAME'];
          $this->URL_ROOT = $this->URL_ROOT = dirname($_SERVER["SCRIPT_NAME"]) . "/";
          $this->PATH_INFO = $this->_safe_uri($this->PATH_INFO);
          $this->URL = $this->_safe_uri($this->URL);

      }

      private function _route_() {
          if (!empty($this->_CFG_ROUTE['rule'])) {
              foreach ($this->_CFG_ROUTE['rule'] as $rule) {
                  if ($rule["search"]) {
                      $this->PATH_INFO = preg_replace("#" . $rule["search"] . "#", $rule["replace"], $this->PATH_INFO);
                      $this->URL = preg_replace("#" . $rule["search"] . "#", $rule["replace"], $this->URL);
                  }
              }
          }

      }

      /**
       * 
       */
      private function _set_get() {
          preg_match_all("/[?|&]([A-Za-z0-9\_\-]+)=([A-Za-z0-9\_\%\.\-]+)/", $this->URL, $OUT, PREG_SET_ORDER);
          for ($i = 0; !empty($OUT[$i]); $i++) {
              $_GET[$OUT[$i][1]] = urldecode($OUT[$i][2]);
          }
          for ($i = 0; !empty($this->SEGMENTS[$i]); $i++) {
              $i == 0 ? $_GET["_var_"] = $this->SEGMENTS[$i] : $_GET["var_" . $this->SEGMENTS[$i]] = $this->SEGMENTS[$i];
              $_GET["val_" . $this->SEGMENTS[$i]] = !empty($this->SEGMENTS[$i + 1]) ? $this->SEGMENTS[$i + 1] : NULL;
              /*
               * 处理系统URL后缀。
               */
              if (!empty($this->_CFG_ROUTE['EXT'])) {
                  preg_match_all("/(.*)\." . $this->_CFG_ROUTE['EXT'] . "$/", $_GET["val_" . $this->SEGMENTS[$i]], $OUT, PREG_SET_ORDER);
                  $_GET["val_" . $this->SEGMENTS[$i]] = isset($OUT[0][1]) ? $OUT[0][1] : $_GET["val_" . $this->SEGMENTS[$i]];
              }
          }

      }

      private function _v_app_() {
          //$this->PATH_INFO = substr($this->PATH_INFO, 0, strpos($this->PATH_INFO, '?') + 1);
          $this->SEGMENTS = explode("/", $this->PATH_INFO);
          /**
           * eg: /a
           * =>
           * a.file a.action
           */
          $this->MYAPP_APPS_TRUE_PATH = '';
          if (count($this->SEGMENTS) < 2) {
              if (empty($this->SEGMENTS[0])) {
                  $this->APP = $this->ACTION = "index";
                  return;
              }
              $this->APP = $this->ACTION = $this->SEGMENTS[0];
              return;
          }
          /**
           * eg /index/hello
           * =>
           * index.file hello.action
           */
          $this->APP = $this->ACTION = $this->SEGMENTS[0];
          if (file_exists(MYAPP_APPS . $this->APP . EXT)) {
              $this->ACTION = isset($this->SEGMENTS[1]) ? $this->SEGMENTS[1] : null;
              return;
          }
          /**
           * eg /a-b/c/
           * =>
           * /a/b.file c.action
           */
          $app_route_array = explode("-", $this->APP);
          if (count($app_route_array) >= 2) {
              for ($i = 0; !empty($app_route_array[$i]); $i++) {
                  $this->MYAPP_APPS_TRUE_PATH.=!empty($app_route_array[$i - 1]) ? $app_route_array[$i - 1] . DS : "";
                  $this->APP = $app_route_array[$i];
              }
              $this->ACTION = isset($this->SEGMENTS[1]) ? $this->SEGMENTS[1] : null;
          }
          if (file_exists(MYAPP_APPS . $this->MYAPP_APPS_TRUE_PATH . $this->APP)) {
              return;
          }
          /*
           * 
           * 
           */
          $this->MYAPP_APPS_TRUE_PATH = '';
          $_path = '';
          for ($i = 0; !empty($this->SEGMENTS[$i]); $i++) {
              $_path.=$this->SEGMENTS[$i] . DS;
              /*
               * 
               */
              if (!is_dir(MYAPP_APPS . $_path)) {
                  return;
              }
              isset($this->SEGMENTS[$i + 1]) ? $this->SEGMENTS[$i + 1] : "index";
              if (file_exists(MYAPP_APPS . $_path . $this->SEGMENTS[$i + 1])) {
                  $this->APP = $this->SEGMENTS[$i + 1];
                  $this->ACTION = isset($this->SEGMENTS[$i + 2]) ? $this->SEGMENTS[$i + 2] : null;
                  $this->MYAPP_APPS_TRUE_PATH = $_path;
                  return;
              }
          }

      }

      private function _safe_request($var) {
          $var = preg_replace("/[\*\|\?\=\>\<\.\-]+/", "_", $var);
          return $var;

      }

  }  