<?php
  /*                                Congshan.net
   * ============================================================================
   * 项目:CongMVC
   * 文件:cong_views.php
   * 网址:http://www.congshan.net
   * 作者:<lei@congshan.net> Created on 2014-4-15 21:13:40
   * $time:$
   * $md5:$
   * ============================================================================
   */

  /*
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * 使用Apache License, Version 2.0 开源许可协议
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   * Copyright (c) 2014 CongShan.net.
   *
   * Licensed under the Apache License, Version 2.0
   * you may not use this file except in compliance with the License.
   * You may obtain a copy of the License at
   *
   *      http://www.apache.org/licenses/LICENSE-2.0
   *
   * ============================================================================
   */

  /**
   * 
   * 
   */
  class cong_views {

      private $_CFG;

      /**
       *
       * @var type 
       */
      private $theApp;

      /**
       *
       * @var object
       */
      private $engine;

      /**
       *
       * @var string
       */
      private $_engine_path;

      /**
       *
       * @var string
       */
      private $_engine_file;

      /**
       *
       * @var string
       */
      private $_engine_class;

      /**
       * 
       * @param type $instance
       */
      function __construct() {

          $this->theApp = cong_myapp::myapp_instance();
          $this->_CFG = $this->theApp->_CFG;

          /**
           * 
           */
          $this->_engine_path = $this->_CFG['TPL']['Drive']['path'];
          $this->_engine_file = $this->_CFG['TPL']['Drive']['file'];
          $this->_engine_class = $this->_CFG['TPL']['Drive']['class'];
          $this->_engine();

      }

      /**
       * 
       * @return type
       */
      private function _engine() {

          $_f = CONG_DRIVE . $this->_engine_path . DS . $this->_engine_file;
          if (file_exists($_f)) {
              require_once $_f;
              $this->engine = new $this->_engine_class;
              return;
          }
          $_f = MYAPP_DRIVE . $this->_engine_path . DS . $this->_engine_file;
          if (file_exists($_f)) {
              require_once $_f;
              $this->engine = new $this->_engine_class;
              return;
          }
          die("请配置一个正确的显示引擎");

      }

      /**
       * 
       * @param type $tpl_var
       * @param type $value
       * @return type
       */
      function assign($tpl_var, $value = null) {

          /**
           * 
           */
          if (isset($this->engine)) {
              $this->engine->assign($tpl_var, $value);
              return;
          }

      }

      /**
       * 
       * @param type $resource_name
       * @param type $template_default
       */
      function display($resource_name, $template_default = "default") {

          /**
           * 
           */
          $this->theApp->CONG->_BENCHMARK->mark("display");
          if (isset($this->engine)) {
              $this->engine->display($resource_name, $template_default);
          }
          $this->theApp->CONG->_BENCHMARK->mark("display_end");

      }

      /**
       * 
       * @param type $name
       * @param type $arguments
       */
      function __call($name, $arguments) {

          if (isset($this->engine)) {
              $this->engine->$name($arguments);
          }

      }

      function __get($name) {

          return $this->engine->$name;

      }

      /**
       * 
       * @param type $name
       * @param type $value
       */
      function __set($name, $value) {

          $this->engine->$property = $value;

      }

  }  