<%
Response.Buffer = EW_RESPONSE_BUFFER
%>
<!--#include file="ewcfg11.asp"-->
<!--#include file="websetinfo.asp"-->
<!--#include file="zlogininfo.asp"-->
<!--#include file="aspfn11.asp"-->
<!--#include file="md5.asp"-->
<!--#include file="userfn11.asp"-->
<% Session.Timeout = 900 %>
<% Call ew_Header(False, EW_CHARSET) %>
<%

' Define page object
Dim webset_list
Set webset_list = New cwebset_list
Set Page = webset_list

' Page init processing
webset_list.Page_Init()

' Page main processing
webset_list.Page_Main()

' Global Page Rendering event (in userfn*.asp)
Page_Rendering()

' Page Rendering event
webset_list.Page_Render()
%>
<!--#include file="header.asp"-->
<% If webset.Export = "" Then %>
<script type="text/javascript">
// Page object
var webset_list = new ew_Page("webset_list");
webset_list.PageID = "list"; // Page ID
var EW_PAGE_ID = webset_list.PageID; // For backward compatibility
// Form object
var fwebsetlist = new ew_Form("fwebsetlist");
fwebsetlist.FormKeyCountName = '<%= webset_list.FormKeyCountName %>';
// Form_CustomValidate event
fwebsetlist.Form_CustomValidate = 
 function(fobj) { // DO NOT CHANGE THIS LINE!
 	// Your custom validation code here, return false if invalid. 
 	return true;
 }
// Use JavaScript validation or not
<% If EW_CLIENT_VALIDATE Then %>
fwebsetlist.ValidateRequired = true; // Use JavaScript validation
<% Else %>
fwebsetlist.ValidateRequired = false; // No JavaScript validation
<% End If %>
// Dynamic selection lists
// Form object for search
</script>
<script type="text/javascript">
// Write your client script here, no need to add script tags.
</script>
<% End If %>
<% If webset.Export = "" Then %>
<% Breadcrumb.Render() %>
<% End If %>
<% If webset_list.ExportOptions.Visible Then %>
<div class="ewListExportOptions"><% webset_list.ExportOptions.Render "body", "", "", "", "", "" %></div>
<% End If %>
<% If (webset.Export = "") Or (EW_EXPORT_MASTER_RECORD And webset.Export = "print") Then %>
<% End If %>
<%

' Load recordset
Set webset_list.Recordset = webset_list.LoadRecordset()
	webset_list.TotalRecs = webset_list.Recordset.RecordCount
	webset_list.StartRec = 1
	If webset_list.DisplayRecs <= 0 Then ' Display all records
		webset_list.DisplayRecs = webset_list.TotalRecs
	End If
	If Not (webset.ExportAll And webset.Export <> "") Then
		webset_list.SetUpStartRec() ' Set up start record position
	End If
webset_list.RenderOtherOptions()
%>
<% webset_list.ShowPageHeader() %>
<% webset_list.ShowMessage %>
<table class="ewGrid"><tr><td class="ewGridContent">
<% If webset.Export = "" Then %>
<div class="ewGridUpperPanel">
<% If webset.CurrentAction <> "gridadd" And webset.CurrentAction <> "gridedit" Then %>
<form name="ewPagerForm" class="ewForm form-inline" action="<%= ew_CurrentPage %>">
<table class="ewPager">
<tr><td>
<% If Not IsObject(webset_list.Pager) Then Set webset_list.Pager = ew_NewPrevNextPager(webset_list.StartRec, webset_list.DisplayRecs, webset_list.TotalRecs) %>
<% If webset_list.Pager.RecordCount > 0 Then %>
<table class="ewStdTable"><tbody><tr><td>
	<%= Language.Phrase("Page") %>&nbsp;
<div class="input-prepend input-append">
<!--first page button-->
	<% If webset_list.Pager.FirstButton.Enabled Then %>
	<a class="btn btn-small" href="<%= webset_list.PageUrl %>start=<%= webset_list.Pager.FirstButton.Start %>"><i class="icon-step-backward"></i></a>
	<% Else %>
	<a class="btn btn-small disabled"><i class="icon-step-backward"></i></a>
	<% End If %>
<!--previous page button-->
	<% If webset_list.Pager.PrevButton.Enabled Then %>
	<a class="btn btn-small" href="<%= webset_list.PageUrl %>start=<%= webset_list.Pager.PrevButton.Start %>"><i class="icon-prev"></i></a>
	<% Else %>
	<a class="btn btn-small disabled"><i class="icon-prev"></i></a>
	<% End If %>
<!--current page number-->
	<input class="input-mini" type="text" name="<%= EW_TABLE_PAGE_NO %>" value="<%= webset_list.Pager.CurrentPage %>">
<!--next page button-->
	<% If webset_list.Pager.NextButton.Enabled Then %>
	<a class="btn btn-small" href="<%= webset_list.PageUrl %>start=<%= webset_list.Pager.NextButton.Start %>"><i class="icon-play"></i></a>
	<% Else %>
	<a class="btn btn-small disabled"><i class="icon-play"></i></a>
	<% End If %>
<!--last page button-->
	<% If webset_list.Pager.LastButton.Enabled Then %>
	<a class="btn btn-small" href="<%= webset_list.PageUrl %>start=<%= webset_list.Pager.LastButton.Start %>"><i class="icon-step-forward"></i></a>
	<% Else %>
	<a class="btn btn-small disabled"><i class="icon-step-forward"></i></a>
	<% End If %>
</div>
	&nbsp;<%= Language.Phrase("of") %>&nbsp;<%= webset_list.Pager.PageCount %>
</td>
<td>
	&nbsp;&nbsp;&nbsp;&nbsp;
	<%= Language.Phrase("Record") %>&nbsp;<%= webset_list.Pager.FromIndex %>&nbsp;<%= Language.Phrase("To") %>&nbsp;<%= webset_list.Pager.ToIndex %>&nbsp;<%= Language.Phrase("Of") %>&nbsp;<%= webset_list.Pager.RecordCount %>
</td>
</tr></tbody></table>
<% Else %>
	<% If Security.CanList Then %>
	<% If webset_list.SearchWhere = "0=101" Then %>
	<p><%= Language.Phrase("EnterSearchCriteria") %></p>
	<% Else %>
	<p><%= Language.Phrase("NoRecord") %></p>
	<% End If %>
	<% Else %>
	<p><%= Language.Phrase("NoPermission") %></p>
	<% End If %>
<% End If %>
</td>
<% If webset_list.TotalRecs > 0 Then %>
<td>
	&nbsp;&nbsp;&nbsp;&nbsp;
<input type="hidden" name="t" value="webset">
<select name="<%= EW_TABLE_REC_PER_PAGE %>" class="input-small" onchange="this.form.submit();">
<option value="20"<% If webset_list.DisplayRecs = 20 Then %> selected="selected"<% End If %>>20</option>
<option value="30"<% If webset_list.DisplayRecs = 30 Then %> selected="selected"<% End If %>>30</option>
<option value="40"<% If webset_list.DisplayRecs = 40 Then %> selected="selected"<% End If %>>40</option>
<option value="ALL"<% If webset.RecordsPerPage = -1 Then %> selected="selected"<% End If %>><%= Language.Phrase("AllRecords") %></option>
</select>
</td>
<% End If %>
</tr></table>
</form>
<% End If %>
<div class="ewListOtherOptions">
<%
	webset_list.AddEditOptions.Render "body", "", "", "", "", ""
	webset_list.DetailOptions.Render "body", "", "", "", "", ""
	webset_list.ActionOptions.Render "body", "", "", "", "", ""
%>
</div>
</div>
<% End If %>
<form name="fwebsetlist" id="fwebsetlist" class="ewForm form-inline" action="<%= ew_CurrentPage %>" method="post">
<input type="hidden" name="t" value="webset">
<div id="gmp_webset" class="ewGridMiddlePanel">
<% If webset_list.TotalRecs > 0 Then %>
<table id="tbl_websetlist" class="ewTable ewTableSeparate">
<%= webset.TableCustomInnerHtml %>
<thead><!-- Table header -->
	<tr class="ewTableHeader">
<%
Call webset_list.RenderListOptions()

' Render list options (header, left)
webset_list.ListOptions.Render "header", "left", "", "", "", ""
%>
<% If webset.id.Visible Then ' id %>
	<% If webset.SortUrl(webset.id) = "" Then %>
		<td><div id="elh_webset_id" class="webset_id"><div class="ewTableHeaderCaption"><%= webset.id.FldCaption %></div></div></td>
	<% Else %>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<%= webset.SortUrl(webset.id) %>',1);"><div id="elh_webset_id" class="webset_id">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><%= webset.id.FldCaption %></span><span class="ewTableHeaderSort"><% If webset.id.Sort = "ASC" Then %><span class="caret ewSortUp"></span><% ElseIf webset.id.Sort = "DESC" Then %><span class="caret"></span><% End If %></span></div>
        </div></div></td>
	<% End If %>
<% End If %>		
<% If webset.webname.Visible Then ' webname %>
	<% If webset.SortUrl(webset.webname) = "" Then %>
		<td><div id="elh_webset_webname" class="webset_webname"><div class="ewTableHeaderCaption"><%= webset.webname.FldCaption %></div></div></td>
	<% Else %>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<%= webset.SortUrl(webset.webname) %>',1);"><div id="elh_webset_webname" class="webset_webname">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><%= webset.webname.FldCaption %></span><span class="ewTableHeaderSort"><% If webset.webname.Sort = "ASC" Then %><span class="caret ewSortUp"></span><% ElseIf webset.webname.Sort = "DESC" Then %><span class="caret"></span><% End If %></span></div>
        </div></div></td>
	<% End If %>
<% End If %>		
<% If webset.lxr.Visible Then ' lxr %>
	<% If webset.SortUrl(webset.lxr) = "" Then %>
		<td><div id="elh_webset_lxr" class="webset_lxr"><div class="ewTableHeaderCaption"><%= webset.lxr.FldCaption %></div></div></td>
	<% Else %>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<%= webset.SortUrl(webset.lxr) %>',1);"><div id="elh_webset_lxr" class="webset_lxr">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><%= webset.lxr.FldCaption %></span><span class="ewTableHeaderSort"><% If webset.lxr.Sort = "ASC" Then %><span class="caret ewSortUp"></span><% ElseIf webset.lxr.Sort = "DESC" Then %><span class="caret"></span><% End If %></span></div>
        </div></div></td>
	<% End If %>
<% End If %>		
<% If webset.sj.Visible Then ' sj %>
	<% If webset.SortUrl(webset.sj) = "" Then %>
		<td><div id="elh_webset_sj" class="webset_sj"><div class="ewTableHeaderCaption"><%= webset.sj.FldCaption %></div></div></td>
	<% Else %>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<%= webset.SortUrl(webset.sj) %>',1);"><div id="elh_webset_sj" class="webset_sj">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><%= webset.sj.FldCaption %></span><span class="ewTableHeaderSort"><% If webset.sj.Sort = "ASC" Then %><span class="caret ewSortUp"></span><% ElseIf webset.sj.Sort = "DESC" Then %><span class="caret"></span><% End If %></span></div>
        </div></div></td>
	<% End If %>
<% End If %>		
<% If webset.ishtml.Visible Then ' ishtml %>
	<% If webset.SortUrl(webset.ishtml) = "" Then %>
		<td><div id="elh_webset_ishtml" class="webset_ishtml"><div class="ewTableHeaderCaption"><%= webset.ishtml.FldCaption %></div></div></td>
	<% Else %>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<%= webset.SortUrl(webset.ishtml) %>',1);"><div id="elh_webset_ishtml" class="webset_ishtml">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><%= webset.ishtml.FldCaption %></span><span class="ewTableHeaderSort"><% If webset.ishtml.Sort = "ASC" Then %><span class="caret ewSortUp"></span><% ElseIf webset.ishtml.Sort = "DESC" Then %><span class="caret"></span><% End If %></span></div>
        </div></div></td>
	<% End If %>
<% End If %>		
<% If webset.isqq.Visible Then ' isqq %>
	<% If webset.SortUrl(webset.isqq) = "" Then %>
		<td><div id="elh_webset_isqq" class="webset_isqq"><div class="ewTableHeaderCaption"><%= webset.isqq.FldCaption %></div></div></td>
	<% Else %>
		<td><div class="ewPointer" onclick="ew_Sort(event,'<%= webset.SortUrl(webset.isqq) %>',1);"><div id="elh_webset_isqq" class="webset_isqq">
			<div class="ewTableHeaderBtn"><span class="ewTableHeaderCaption"><%= webset.isqq.FldCaption %></span><span class="ewTableHeaderSort"><% If webset.isqq.Sort = "ASC" Then %><span class="caret ewSortUp"></span><% ElseIf webset.isqq.Sort = "DESC" Then %><span class="caret"></span><% End If %></span></div>
        </div></div></td>
	<% End If %>
<% End If %>		
<%

' Render list options (header, right)
webset_list.ListOptions.Render "header", "right", "", "", "", ""
%>
	</tr>
</thead>
<tbody><!-- Table body -->
<%
If (webset.ExportAll And webset.Export <> "") Then
	webset_list.StopRec = webset_list.TotalRecs
Else

	' Set the last record to display
	If webset_list.TotalRecs > webset_list.StartRec + webset_list.DisplayRecs - 1 Then
		webset_list.StopRec = webset_list.StartRec + webset_list.DisplayRecs - 1
	Else
		webset_list.StopRec = webset_list.TotalRecs
	End If
End If

' Move to first record
webset_list.RecCnt = webset_list.StartRec - 1
If Not webset_list.Recordset.Eof Then
	webset_list.Recordset.MoveFirst
	If webset_list.StartRec > 1 Then webset_list.Recordset.Move webset_list.StartRec - 1
ElseIf Not webset.AllowAddDeleteRow And webset_list.StopRec = 0 Then
	webset_list.StopRec = webset.GridAddRowCount
End If

' Initialize Aggregate
webset.RowType = EW_ROWTYPE_AGGREGATEINIT
Call webset.ResetAttrs()
Call webset_list.RenderRow()
webset_list.RowCnt = 0

' Output date rows
Do While CLng(webset_list.RecCnt) < CLng(webset_list.StopRec)
	webset_list.RecCnt = webset_list.RecCnt + 1
	If CLng(webset_list.RecCnt) >= CLng(webset_list.StartRec) Then
		webset_list.RowCnt = webset_list.RowCnt + 1

	' Set up key count
	webset_list.KeyCount = webset_list.RowIndex
	Call webset.ResetAttrs()
	webset.CssClass = ""
	If webset.CurrentAction = "gridadd" Then
	Else
		Call webset_list.LoadRowValues(webset_list.Recordset) ' Load row values
	End If
	webset.RowType = EW_ROWTYPE_VIEW ' Render view

	' Set up row id / data-rowindex
	webset.RowAttrs.AddAttributes Array(Array("data-rowindex", webset_list.RowCnt), Array("id", "r" & webset_list.RowCnt & "_webset"), Array("data-rowtype", webset.RowType))

	' Render row
	Call webset_list.RenderRow()

	' Render list options
	Call webset_list.RenderListOptions()
%>
	<tr<%= webset.RowAttributes %>>
<%

' Render list options (body, left)
webset_list.ListOptions.Render "body", "left", webset_list.RowCnt, "", "", ""
%>
	<% If webset.id.Visible Then ' id %>
		<td<%= webset.id.CellAttributes %>>
<span<%= webset.id.ViewAttributes %>>
<%= webset.id.ListViewValue %>
</span>
<a id="<%= webset_list.PageObjName & "_row_" & webset_list.RowCnt %>"></a></td>
	<% End If %>
	<% If webset.webname.Visible Then ' webname %>
		<td<%= webset.webname.CellAttributes %>>
<span<%= webset.webname.ViewAttributes %>>
<%= webset.webname.ListViewValue %>
</span>
</td>
	<% End If %>
	<% If webset.lxr.Visible Then ' lxr %>
		<td<%= webset.lxr.CellAttributes %>>
<span<%= webset.lxr.ViewAttributes %>>
<%= webset.lxr.ListViewValue %>
</span>
</td>
	<% End If %>
	<% If webset.sj.Visible Then ' sj %>
		<td<%= webset.sj.CellAttributes %>>
<span<%= webset.sj.ViewAttributes %>>
<%= webset.sj.ListViewValue %>
</span>
</td>
	<% End If %>
	<% If webset.ishtml.Visible Then ' ishtml %>
		<td<%= webset.ishtml.CellAttributes %>>
<span<%= webset.ishtml.ViewAttributes %>>
<%= webset.ishtml.ListViewValue %>
</span>
</td>
	<% End If %>
	<% If webset.isqq.Visible Then ' isqq %>
		<td<%= webset.isqq.CellAttributes %>>
<span<%= webset.isqq.ViewAttributes %>>
<%= webset.isqq.ListViewValue %>
</span>
</td>
	<% End If %>
<%

' Render list options (body, right)
webset_list.ListOptions.Render "body", "right", webset_list.RowCnt, "", "", ""
%>
	</tr>
<%
	End If
	If webset.CurrentAction <> "gridadd" Then
		webset_list.Recordset.MoveNext()
	End If
Loop
%>
</tbody>
</table>
<% End If %>
<% If webset.CurrentAction = "" Then %>
<input type="hidden" name="a_list" id="a_list" value="">
<% End If %>
</div>
</form>
<%

' Close recordset and connection
webset_list.Recordset.Close
Set webset_list.Recordset = Nothing
%>
<% If webset_list.TotalRecs > 0 Then %>
<% If webset.Export = "" Then %>
<div class="ewGridLowerPanel">
<% If webset.CurrentAction <> "gridadd" And webset.CurrentAction <> "gridedit" Then %>
<form name="ewPagerForm" class="ewForm form-inline" action="<%= ew_CurrentPage %>">
<table class="ewPager">
<tr><td>
<% If Not IsObject(webset_list.Pager) Then Set webset_list.Pager = ew_NewPrevNextPager(webset_list.StartRec, webset_list.DisplayRecs, webset_list.TotalRecs) %>
<% If webset_list.Pager.RecordCount > 0 Then %>
<table class="ewStdTable"><tbody><tr><td>
	<%= Language.Phrase("Page") %>&nbsp;
<div class="input-prepend input-append">
<!--first page button-->
	<% If webset_list.Pager.FirstButton.Enabled Then %>
	<a class="btn btn-small" href="<%= webset_list.PageUrl %>start=<%= webset_list.Pager.FirstButton.Start %>"><i class="icon-step-backward"></i></a>
	<% Else %>
	<a class="btn btn-small disabled"><i class="icon-step-backward"></i></a>
	<% End If %>
<!--previous page button-->
	<% If webset_list.Pager.PrevButton.Enabled Then %>
	<a class="btn btn-small" href="<%= webset_list.PageUrl %>start=<%= webset_list.Pager.PrevButton.Start %>"><i class="icon-prev"></i></a>
	<% Else %>
	<a class="btn btn-small disabled"><i class="icon-prev"></i></a>
	<% End If %>
<!--current page number-->
	<input class="input-mini" type="text" name="<%= EW_TABLE_PAGE_NO %>" value="<%= webset_list.Pager.CurrentPage %>">
<!--next page button-->
	<% If webset_list.Pager.NextButton.Enabled Then %>
	<a class="btn btn-small" href="<%= webset_list.PageUrl %>start=<%= webset_list.Pager.NextButton.Start %>"><i class="icon-play"></i></a>
	<% Else %>
	<a class="btn btn-small disabled"><i class="icon-play"></i></a>
	<% End If %>
<!--last page button-->
	<% If webset_list.Pager.LastButton.Enabled Then %>
	<a class="btn btn-small" href="<%= webset_list.PageUrl %>start=<%= webset_list.Pager.LastButton.Start %>"><i class="icon-step-forward"></i></a>
	<% Else %>
	<a class="btn btn-small disabled"><i class="icon-step-forward"></i></a>
	<% End If %>
</div>
	&nbsp;<%= Language.Phrase("of") %>&nbsp;<%= webset_list.Pager.PageCount %>
</td>
<td>
	&nbsp;&nbsp;&nbsp;&nbsp;
	<%= Language.Phrase("Record") %>&nbsp;<%= webset_list.Pager.FromIndex %>&nbsp;<%= Language.Phrase("To") %>&nbsp;<%= webset_list.Pager.ToIndex %>&nbsp;<%= Language.Phrase("Of") %>&nbsp;<%= webset_list.Pager.RecordCount %>
</td>
</tr></tbody></table>
<% Else %>
	<% If Security.CanList Then %>
	<% If webset_list.SearchWhere = "0=101" Then %>
	<p><%= Language.Phrase("EnterSearchCriteria") %></p>
	<% Else %>
	<p><%= Language.Phrase("NoRecord") %></p>
	<% End If %>
	<% Else %>
	<p><%= Language.Phrase("NoPermission") %></p>
	<% End If %>
<% End If %>
</td>
<% If webset_list.TotalRecs > 0 Then %>
<td>
	&nbsp;&nbsp;&nbsp;&nbsp;
<input type="hidden" name="t" value="webset">
<select name="<%= EW_TABLE_REC_PER_PAGE %>" class="input-small" onchange="this.form.submit();">
<option value="20"<% If webset_list.DisplayRecs = 20 Then %> selected="selected"<% End If %>>20</option>
<option value="30"<% If webset_list.DisplayRecs = 30 Then %> selected="selected"<% End If %>>30</option>
<option value="40"<% If webset_list.DisplayRecs = 40 Then %> selected="selected"<% End If %>>40</option>
<option value="ALL"<% If webset.RecordsPerPage = -1 Then %> selected="selected"<% End If %>><%= Language.Phrase("AllRecords") %></option>
</select>
</td>
<% End If %>
</tr></table>
</form>
<% End If %>
<div class="ewListOtherOptions">
<%
	webset_list.AddEditOptions.Render "body", "bottom", "", "", "", ""
	webset_list.DetailOptions.Render "body", "bottom", "", "", "", ""
	webset_list.ActionOptions.Render "body", "bottom", "", "", "", ""
%>
</div>
</div>
<% End If %>
<% End If %>
</td></tr></table>
<% If webset.Export = "" Then %>
<script type="text/javascript">
fwebsetlist.Init();
<% If EW_MOBILE_REFLOW And ew_IsMobile() Then %>
ew_Reflow();
<% End If %>
</script>
<% End If %>
<%
webset_list.ShowPageFooter()
If EW_DEBUG_ENABLED Then Response.Write ew_DebugMsg()
%>
<% If webset.Export = "" Then %>
<script type="text/javascript">
// Write your table-specific startup script here
// document.write("page loaded");
</script>
<% End If %>
<!--#include file="footer.asp"-->
<%

' Drop page object
Set webset_list = Nothing
%>
<%

' -----------------------------------------------------------------
' Page Class
'
Class cwebset_list

	' Page ID
	Public Property Get PageID()
		PageID = "list"
	End Property

	' Project ID
	Public Property Get ProjectID()
		ProjectID = "{9AC218D3-4571-402E-9408-D679EC504540}"
	End Property

	' Table Name
	Public Property Get TableName()
		TableName = "webset"
	End Property

	' Page Object Name
	Public Property Get PageObjName()
		PageObjName = "webset_list"
	End Property

	' Grid form hidden field names
	Dim FormName
	Dim FormActionName
	Dim FormKeyName
	Dim FormOldKeyName
	Dim FormBlankRowName
	Dim FormKeyCountName

	' Page Name
	Public Property Get PageName()
		PageName = ew_CurrentPage()
	End Property

	' Page Url
	Public Property Get PageUrl()
		PageUrl = ew_CurrentPage() & "?"
		If webset.UseTokenInUrl Then PageUrl = PageUrl & "t=" & webset.TableVar & "&" ' add page token
	End Property

	' Common urls
	Dim AddUrl
	Dim EditUrl
	Dim CopyUrl
	Dim DeleteUrl
	Dim ViewUrl
	Dim ListUrl

	' Export urls
	Dim ExportPrintUrl
	Dim ExportHtmlUrl
	Dim ExportExcelUrl
	Dim ExportWordUrl
	Dim ExportXmlUrl
	Dim ExportCsvUrl
	Dim ExportPdfUrl

	' Inline urls
	Dim InlineAddUrl
	Dim InlineCopyUrl
	Dim InlineEditUrl
	Dim GridAddUrl
	Dim GridEditUrl
	Dim MultiDeleteUrl
	Dim MultiUpdateUrl

	' Message
	Public Property Get Message()
		Message = Session(EW_SESSION_MESSAGE)
	End Property

	Public Property Let Message(v)
		Dim msg
		msg = Session(EW_SESSION_MESSAGE)
		Call ew_AddMessage(msg, v)
		Session(EW_SESSION_MESSAGE) = msg
	End Property

	Public Property Get FailureMessage()
		FailureMessage = Session(EW_SESSION_FAILURE_MESSAGE)
	End Property

	Public Property Let FailureMessage(v)
		Dim msg
		msg = Session(EW_SESSION_FAILURE_MESSAGE)
		Call ew_AddMessage(msg, v)
		Session(EW_SESSION_FAILURE_MESSAGE) = msg
	End Property

	Public Property Get SuccessMessage()
		SuccessMessage = Session(EW_SESSION_SUCCESS_MESSAGE)
	End Property

	Public Property Let SuccessMessage(v)
		Dim msg
		msg = Session(EW_SESSION_SUCCESS_MESSAGE)
		Call ew_AddMessage(msg, v)
		Session(EW_SESSION_SUCCESS_MESSAGE) = msg
	End Property

	Public Property Get WarningMessage()
		WarningMessage = Session(EW_SESSION_WARNING_MESSAGE)
	End Property

	Public Property Let WarningMessage(v)
		Dim msg
		msg = Session(EW_SESSION_WARNING_MESSAGE)
		Call ew_AddMessage(msg, v)
		Session(EW_SESSION_WARNING_MESSAGE) = msg
	End Property

	' Show Message
	Public Sub ShowMessage()
		Dim hidden, html, sMessage
		hidden = False
		html = ""

		' Message
		sMessage = Message
		Call Message_Showing(sMessage, "")
		If sMessage <> "" Then ' Message in Session, display
			If Not hidden Then sMessage = "<button type=""button"" class=""close"" data-dismiss=""alert"">&times;</button>" & sMessage
			html = html & "<div class=""alert alert-success ewSuccess"">" & sMessage & "</div>"
			Session(EW_SESSION_MESSAGE) = "" ' Clear message in Session
		End If

		' Warning message
		Dim sWarningMessage
		sWarningMessage = WarningMessage
		Call Message_Showing(sWarningMessage, "warning")
		If sWarningMessage <> "" Then ' Message in Session, display
			If Not hidden Then sWarningMessage = "<button type=""button"" class=""close"" data-dismiss=""alert"">&times;</button>" & sWarningMessage
			html = html & "<div class=""alert alert-warning ewWarning"">" & sWarningMessage & "</div>"
			Session(EW_SESSION_WARNING_MESSAGE) = "" ' Clear message in Session
		End If

		' Success message
		Dim sSuccessMessage
		sSuccessMessage = SuccessMessage
		Call Message_Showing(sSuccessMessage, "success")
		If sSuccessMessage <> "" Then ' Message in Session, display
			If Not hidden Then sSuccessMessage = "<button type=""button"" class=""close"" data-dismiss=""alert"">&times;</button>" & sSuccessMessage
			html = html & "<div class=""alert alert-success ewSuccess"">" & sSuccessMessage & "</div>"
			Session(EW_SESSION_SUCCESS_MESSAGE) = "" ' Clear message in Session
		End If

		' Failure message
		Dim sErrorMessage
		sErrorMessage = FailureMessage
		Call Message_Showing(sErrorMessage, "failure")
		If sErrorMessage <> "" Then ' Message in Session, display
			If Not hidden Then sErrorMessage = "<button type=""button"" class=""close"" data-dismiss=""alert"">&times;</button>" & sErrorMessage
			html = html & "<div class=""alert alert-error ewError"">" & sErrorMessage & "</div>"
			Session(EW_SESSION_FAILURE_MESSAGE) = "" ' Clear message in Session
		End If
		Response.Write "<table class=""ewStdTable""><tr><td><div class=""ewMessageDialog""" & ew_IIf(hidden, " style=""display: none;""", "") & ">" & html & "</div></td></tr></table>"
	End Sub
	Dim PageHeader
	Dim PageFooter

	' Show Page Header
	Public Sub ShowPageHeader()
		Dim sHeader
		sHeader = PageHeader
		Call Page_DataRendering(sHeader)
		If sHeader <> "" Then ' Header exists, display
			Response.Write "<p>" & sHeader & "</p>"
		End If
	End Sub

	' Show Page Footer
	Public Sub ShowPageFooter()
		Dim sFooter
		sFooter = PageFooter
		Call Page_DataRendered(sFooter)
		If sFooter <> "" Then ' Footer exists, display
			Response.Write "<p>" & sFooter & "</p>"
		End If
	End Sub

	' -----------------------
	'  Validate Page request
	'
	Public Function IsPageRequest()
		If webset.UseTokenInUrl Then
			IsPageRequest = False
			If Not (ObjForm Is Nothing) Then
				IsPageRequest = (webset.TableVar = ObjForm.GetValue("t"))
			End If
			If Request.QueryString("t").Count > 0 Then
				IsPageRequest = (webset.TableVar = Request.QueryString("t"))
			End If
		Else
			IsPageRequest = True
		End If
	End Function

	' -----------------------------------------------------------------
	'  Class initialize
	'  - init objects
	'  - open ADO connection
	'
	Private Sub Class_Initialize()
		If IsEmpty(StartTimer) Then StartTimer = Timer ' Init start time

		' Grid form hidden field names
		FormName = "fwebsetlist"
		FormActionName = "k_action"
		FormKeyName = "k_key"
		FormOldKeyName = "k_oldkey"
		FormBlankRowName = "k_blankrow"
		FormKeyCountName = "key_count"

		' Initialize language object
		If IsEmpty(Language) Then
			Set Language = New cLanguage
			Call Language.LoadPhrases()
		End If

		' Initialize table object
		If IsEmpty(webset) Then Set webset = New cwebset
		Set Table = webset

		' Initialize urls
		ExportPrintUrl = PageUrl & "export=print"
		ExportExcelUrl = PageUrl & "export=excel"
		ExportWordUrl = PageUrl & "export=word"
		ExportHtmlUrl = PageUrl & "export=html"
		ExportXmlUrl = PageUrl & "export=xml"
		ExportCsvUrl = PageUrl & "export=csv"
		ExportPdfUrl = PageUrl & "export=pdf"
		AddUrl = "websetadd.asp"
		InlineAddUrl = PageUrl & "a=add"
		GridAddUrl = PageUrl & "a=gridadd"
		GridEditUrl = PageUrl & "a=gridedit"
		MultiDeleteUrl = "websetdelete.asp"
		MultiUpdateUrl = "websetupdate.asp"

		' Initialize other table object
		If IsEmpty(zlogin) Then Set zlogin = New czlogin

		' Initialize form object
		Set ObjForm = Nothing

		' Intialize page id (for backward compatibility)
		EW_PAGE_ID = "list"

		' Initialize table name (for backward compatibility)
		EW_TABLE_NAME = "webset"

		' Open connection to the database
		If IsEmpty(Conn) Then Call ew_Connect()

		' List options
		Set ListOptions = New cListOptions
		ListOptions.TableVar = webset.TableVar

		' Export options
		Set ExportOptions = New cListOptions
		ExportOptions.TableVar = webset.TableVar
		ExportOptions.Tag = "div"
		ExportOptions.TagClassName = "ewExportOption"

		' Other options
		Set AddEditOptions = New cListOptions
		AddEditOptions.Tag = "div"
		AddEditOptions.TagClassName = "ewAddEditOption"
		Set DetailOptions = New cListOptions
		DetailOptions.Tag = "div"
		DetailOptions.TagClassName = "ewDetailOption"
		Set ActionOptions = New cListOptions
		ActionOptions.Tag = "div"
		ActionOptions.TagClassName = "ewActionOption"
	End Sub

	' -----------------------------------------------------------------
	'  Subroutine Page_Init
	'  - called before page main
	'  - check Security
	'  - set up response header
	'  - call page load events
	'
	Sub Page_Init()
		Set Security = New cAdvancedSecurity
		If Not Security.IsLoggedIn() Then Call Security.AutoLogin()
		If Not Security.IsLoggedIn() Then
			Call Security.SaveLastUrl()
			Call Page_Terminate("login.asp")
		End If

		' Table Permission loading event
		Call Security.TablePermission_Loading()
		Call Security.LoadCurrentUserLevel(ProjectID & TableName)

		' Table Permission loaded event
		Call Security.TablePermission_Loaded()
		If Not Security.IsLoggedIn() Then
			Call Security.SaveLastUrl()
			Call Page_Terminate("login.asp")
		End If
		If Not Security.CanList Then
			Call Security.SaveLastUrl()
			Call Page_Terminate("login.asp")
		End If

		' Get export parameters
		If Request.QueryString("export").Count > 0 Then
			webset.Export = Request.QueryString("export")
		ElseIf Request.ServerVariables("HTTP_CONTENT_TYPE") = "application/x-www-form-urlencoded" Then
			If Request.Form("exporttype").Count > 0 Then
				webset.Export = Request.Form("exporttype")
			End If
		Else
			webset.ExportReturnUrl = ew_CurrentUrl()
		End If
		gsExport = webset.Export ' Get export parameter, used in header
		gsExportFile = webset.TableVar ' Get export file, used in header
		Dim Charset ' Charset used in header
		If EW_CHARSET <> "" Then
			Charset = ";charset=" & EW_CHARSET
		Else
			Charset = ""
		End If
		If webset.Export = "excel" Then
			Response.ContentType = "application/vnd.ms-excel" & Charset
			Response.AddHeader "Content-Disposition", "attachment; filename=" & gsExportFile & ".xls"
		End If
		If webset.Export = "word" Then
			Response.ContentType = "application/vnd.ms-word" & Charset
			Response.AddHeader "Content-Disposition", "attachment; filename=" & gsExportFile & ".doc"
		End If

		' Get grid add count
		Dim gridaddcnt
		gridaddcnt = Request.QueryString(EW_TABLE_GRID_ADD_ROW_COUNT)
		If IsNumeric(gridaddcnt) Then
			If gridaddcnt > 0 Then
				webset.GridAddRowCount = gridaddcnt
			End If
		End If

		' Set up list options
		SetupListOptions()

		' Setup export options
		SetupExportOptions()

		' Global page loading event (in userfn7.asp)
		Page_Loading()

		' Page load event, used in current page
		Page_Load()

		' Setup other options
		SetupOtherOptions()

		' Set "checkbox" visible
		If UBound(webset.CustomActions.CustomArray) >= 0 Then
			ListOptions.GetItem("checkbox").Visible = True
		End If

		'??? Update url if printer friendly for Pdf
		'???if ($this->PrinterFriendlyForPdf)
		'???	$this->ExportOptions->Items["pdf"]->Body = str_replace($this->ExportPdfUrl, $this->ExportPrintUrl . "&pdf=1", $this->ExportOptions->Items["pdf"]->Body);

	End Sub

	' -----------------------------------------------------------------
	'  Class terminate
	'  - clean up page object
	'
	Private Sub Class_Terminate()
		Call Page_Terminate("")
	End Sub

	' -----------------------------------------------------------------
	'  Subroutine Page_Terminate
	'  - called when exit page
	'  - clean up ADO connection and objects
	'  - if url specified, redirect to url
	'
	Sub Page_Terminate(url)

		' Page unload event, used in current page
		Call Page_Unload()

		'???if ($this->Export == "print" && @$_GET["pdf"] == "1") { // Printer friendly version and with pdf=1 in URL parameters
		'???	$pdf = new cExportPdf($GLOBALS["Table"]);
		'???	$pdf->Text = ob_get_contents(); // Set the content as the HTML of current page (printer friendly version)
		'???	ob_end_clean();
		'???	$pdf->Export();
		'???}
		' Global page unloaded event (in userfn60.asp)

		Call Page_Unloaded()
		Dim sRedirectUrl
		sReDirectUrl = url
		Call Page_Redirecting(sReDirectUrl)
		If Not (Conn Is Nothing) Then Conn.Close ' Close Connection
		Set Conn = Nothing
		Set Security = Nothing
		Set webset = Nothing
		Set ListOptions = Nothing
		Set ObjForm = Nothing

		' Go to url if specified
		If sReDirectUrl <> "" Then
			If Response.Buffer Then Response.Clear
			Response.Redirect sReDirectUrl
		End If
	End Sub

	'
	'  Subroutine Page_Terminate (End)
	' ----------------------------------------

	Dim ListOptions ' List options
	Dim ExportOptions ' Export options
	Dim AddEditOptions ' Other options (add edit)
	Dim DetailOptions ' Other options (detail)
	Dim ActionOptions ' Other options (action)
	Dim DisplayRecs ' Number of display records
	Dim StartRec, StopRec, TotalRecs, RecRange
	Dim SearchWhere
	Dim RecCnt
	Dim EditRowCnt
	Dim StartRowCnt
	Dim RowCnt, RowIndex
	Dim Attrs
	Dim RecPerRow, ColCnt
	Dim KeyCount
	Dim RowAction
	Dim RowOldKey ' Row old key (for copy)
	Dim DbMasterFilter, DbDetailFilter
	Dim MasterRecordExists
	Dim MultiSelectKey
	Dim Command
	Dim RestoreSearch
	Dim Recordset, OldRecordset

	' -----------------------------------------------------------------
	' Page main processing
	'
	Sub Page_Main()
		DisplayRecs = 20
		RecRange = 10
		RecCnt = 0 ' Record count
		KeyCount = 0 ' Key count
		StartRowCnt = 1

		' Search filters
		Dim sSrchAdvanced, sSrchBasic, sFilter
		sSrchAdvanced = "" ' Advanced search filter
		sSrchBasic = "" ' Basic search filter
		SearchWhere = "" ' Search where clause
		sFilter = ""

		' Restore search
		RestoreSearch = False

		' Get command
		Command = LCase(Request.QueryString("cmd")&"")

		' Master/Detail
		DbMasterFilter = "" ' Master filter
		DbDetailFilter = "" ' Detail filter
		If IsPageRequest Then ' Validate request

			' Process custom action first
			ProcessCustomAction()

			' Set up records per page dynamically
			SetUpDisplayRecs()

			' Handle reset command
			ResetCmd()

			' Set up Breadcrumb
			SetupBreadcrumb()

			' Hide list options
			If webset.Export <> "" Then
				Call ListOptions.HideAllOptions(Array("sequence"))
				ListOptions.UseDropDownButton = False ' Disable drop down button
				ListOptions.UseButtonGroup = False ' Disable button group
			ElseIf webset.CurrentAction = "gridadd" Or webset.CurrentAction = "gridedit" Then
				Call ListOptions.HideAllOptions(Array())
				ListOptions.UseDropDownButton = False ' Disable drop down button
				ListOptions.UseButtonGroup = False ' Disable button group
			End If

			' Hide export options
			If webset.Export <> "" Or webset.CurrentAction <> "" Then
				ExportOptions.HideAllOptions(Array())
			End If

			' Hide other options
			If webset.Export <> "" Then
				AddEditOptions.HideAllOptions(Array())
				DetailOptions.HideAllOptions(Array())
				ActionOptions.HideAllOptions(Array())
			End If

			' Set Up Sorting Order
			SetUpSortOrder()
		End If ' End Validate Request

		' Restore display records
		If webset.RecordsPerPage <> "" Then
			DisplayRecs = webset.RecordsPerPage ' Restore from Session
		Else
			DisplayRecs = 20 ' Load default
		End If

		' Load Sorting Order
		LoadSortOrder()
		sFilter = ""
		If Not Security.CanList Then
			sFilter = "(0=1)" ' Filter all records
		End If
		Call ew_AddFilter(sFilter, DbDetailFilter)
		Call ew_AddFilter(sFilter, SearchWhere)

		' Set up filter in Session
		webset.SessionWhere = sFilter
		webset.CurrentFilter = ""

		' Export Data only
		If ew_InArray(webset.Export, Array("html","word","excel","xml","csv","email","pdf")) Then
			ExportData()
			Call Page_Terminate("") ' Terminate response
			Response.End
		End If
	End Sub

	' -----------------------------------------------------------------
	' Set up number of records displayed per page
	'
	Sub SetUpDisplayRecs()
		Dim sWrk
		sWrk = Request.QueryString(EW_TABLE_REC_PER_PAGE)
		If sWrk <> "" Then
			If IsNumeric(sWrk) Then
				DisplayRecs = CInt(sWrk)
			Else
				If LCase(sWrk) = "all" Then ' Display all records
					DisplayRecs = -1
				Else
					DisplayRecs = 20 ' Non-numeric, load default
				End If
			End If
			webset.RecordsPerPage = DisplayRecs ' Save to Session

			' Reset start position
			StartRec = 1
			webset.StartRecordNumber = StartRec
		End If
	End Sub

	' -----------------------------------------------------------------
	'  Build filter for all keys
	'
	Function BuildKeyFilter()
		Dim rowindex, sThisKey
		Dim sKey
		Dim sWrkFilter, sFilter
		sWrkFilter = ""

		' Update row index and get row key
		rowindex = 1
		ObjForm.Index = rowindex
		sThisKey = ObjForm.GetValue("k_key") & ""
		Do While (sThisKey <> "")
			If SetupKeyValues(sThisKey) Then
				sFilter = webset.KeyFilter
				If sWrkFilter <> "" Then sWrkFilter = sWrkFilter & " OR "
				sWrkFilter = sWrkFilter & sFilter
			Else
				sWrkFilter = "0=1"
				Exit Do
			End If

			' Update row index and get row key
			rowindex = rowindex + 1 ' Next row
			ObjForm.Index = rowindex
			sThisKey = ObjForm.GetValue("k_key") & ""
		Loop
		BuildKeyFilter = sWrkFilter
	End Function

	' -----------------------------------------------------------------
	' Set up key values
	'
	Function SetupKeyValues(key)
		Dim arrKeyFlds
		arrKeyFlds = Split(key&"", EW_COMPOSITE_KEY_SEPARATOR)
		If UBound(arrKeyFlds) >= 0 Then
			webset.id.FormValue = arrKeyFlds(0)
			If Not IsNumeric(webset.id.FormValue) Then
				SetupKeyValues = False
				Exit Function
			End If
		End If
		SetupKeyValues = True
	End Function

	' -----------------------------------------------------------------
	' Set up Sort parameters based on Sort Links clicked
	'
	Sub SetUpSortOrder()
		Dim sOrderBy
		Dim sSortField, sLastSort, sThisSort
		Dim bCtrl

		' Check for an Order parameter
		If Request.QueryString("order").Count > 0 Then
			webset.CurrentOrder = Request.QueryString("order")
			webset.CurrentOrderType = Request.QueryString("ordertype")

			' Field id
			Call webset.UpdateSort(webset.id)

			' Field webname
			Call webset.UpdateSort(webset.webname)

			' Field lxr
			Call webset.UpdateSort(webset.lxr)

			' Field sj
			Call webset.UpdateSort(webset.sj)

			' Field ishtml
			Call webset.UpdateSort(webset.ishtml)

			' Field isqq
			Call webset.UpdateSort(webset.isqq)
			webset.StartRecordNumber = 1 ' Reset start position
		End If
	End Sub

	' -----------------------------------------------------------------
	' Load Sort Order parameters
	'
	Sub LoadSortOrder()
		Dim sOrderBy
		sOrderBy = webset.SessionOrderBy ' Get order by from Session
		If sOrderBy = "" Then
			If webset.SqlOrderBy <> "" Then
				sOrderBy = webset.SqlOrderBy
				webset.SessionOrderBy = sOrderBy
			End If
		End If
	End Sub

	' -----------------------------------------------------------------
	' Reset command based on querystring parameter cmd=
	' - RESET: reset search parameters
	' - RESETALL: reset search & master/detail parameters
	' - RESETSORT: reset sort parameters
	'
	Sub ResetCmd()

		' Check if reset command
		If Left(Command,5) = "reset" Then

			' Reset Sort Criteria
			If Command = "resetsort" Then
				Dim sOrderBy
				sOrderBy = ""
				webset.SessionOrderBy = sOrderBy
				webset.id.Sort = ""
				webset.webname.Sort = ""
				webset.lxr.Sort = ""
				webset.sj.Sort = ""
				webset.ishtml.Sort = ""
				webset.isqq.Sort = ""
			End If

			' Reset start position
			StartRec = 1
			webset.StartRecordNumber = StartRec
		End If
	End Sub

	' Set up list options
	Sub SetupListOptions()
		Dim item

		' Add group option item
		ListOptions.Add(ListOptions.GroupOptionName)
		Set item = ListOptions.GetItem(ListOptions.GroupOptionName)
		item.Body = ""
		item.OnLeft = False
		item.Visible = False

		' View
		ListOptions.Add("view")
		Set item = ListOptions.GetItem("view")
		item.CssStyle = "white-space: nowrap;"
		item.Visible = Security.CanView
		item.OnLeft = False

		' Edit
		ListOptions.Add("edit")
		Set item = ListOptions.GetItem("edit")
		item.CssStyle = "white-space: nowrap;"
		item.Visible = Security.CanEdit
		item.OnLeft = False

		' Copy
		ListOptions.Add("copy")
		Set item = ListOptions.GetItem("copy")
		item.CssStyle = "white-space: nowrap;"
		item.Visible = Security.CanAdd
		item.OnLeft = False

		' Checkbox
		ListOptions.Add("checkbox")
		Set item = ListOptions.GetItem("checkbox")
		item.Visible = Security.CanDelete
		item.OnLeft = False
		item.Header = "<label class=""checkbox""><input type=""checkbox"" name=""key"" id=""key"" onclick=""ew_SelectAllKey(this);""></label>"
		item.ShowInDropDown = False
		item.ShowInButtonGroup = False

		' Drop down button for ListOptions
		ListOptions.UseDropDownButton = False
		ListOptions.DropDownButtonPhrase = Language.Phrase("ButtonListOptions")
		ListOptions.UseButtonGroup = False
		ListOptions.ButtonClass = "btn-small" ' Class for button group
		Call ListOptions_Load()

		' Set up group item visibility
		ListOptions.GetItem(ListOptions.GroupOptionName).Visible = ListOptions.GroupOptionVisible
	End Sub

	' Render list options
	Sub RenderListOptions()
		Dim item, links
		ListOptions.LoadDefault()
		If Security.CanView Then
			ListOptions.GetItem("view").Body = "<a class=""ewRowLink ewView"" data-caption=""" & ew_HtmlTitle(Language.Phrase("ViewLink")) & """ href=""" & ew_HtmlEncode(ViewUrl) & """>" & Language.Phrase("ViewLink") & "</a>"
		Else
			ListOptions.GetItem("view").Body = ""
		End If
		Set item = ListOptions.GetItem("edit")
		If Security.CanEdit Then
			item.Body = "<a class=""ewRowLink ewEdit"" data-caption=""" & ew_HtmlTitle(Language.Phrase("EditLink")) & """ href=""" & ew_HtmlEncode(EditUrl) & """>" & Language.Phrase("EditLink") & "</a>"
		Else
			item.Body = ""
		End If
		Set item = ListOptions.GetItem("copy")
		If Security.CanAdd Then
			item.Body = "<a class=""ewRowLink ewCopy"" data-caption=""" & ew_HtmlTitle(Language.Phrase("CopyLink")) & """ href=""" & ew_HtmlEncode(CopyUrl) & """>" & Language.Phrase("CopyLink") & "</a>"
		Else
			item.Body = ""
		End If
		ListOptions.GetItem("checkbox").Body = "<label class=""checkbox""><input type=""checkbox"" name=""key_m"" value=""" & ew_HtmlEncode(webset.id.CurrentValue) & """ onclick='ew_ClickMultiCheckbox(event, this);'></label>"
		Call RenderListOptionsExt()
		Call ListOptions_Rendered()
	End Sub

	' Set up other options
	Sub SetupOtherOptions()
		Dim opt, item, DetailTableLink, ar, i
		Set opt = AddEditOptions

		' Add
		Call opt.Add("add")
		Set item = opt.GetItem("add")
		item.Body = "<a class=""ewAddEdit ewAdd"" href=""" & ew_HtmlEncode(AddUrl) & """>" & Language.Phrase("AddLink") & "</a>"
		item.Visible = (AddUrl <> "" And Security.CanAdd)
		Set opt = ActionOptions

		' Add multi delete
		Call opt.Add("multidelete")
		Set item = opt.GetItem("multidelete")
		item.Body = "<a class=""ewAction ewMultiDelete"" href="""" onclick=""ew_SubmitSelected(document.fwebsetlist, '" & MultiDeleteUrl & "', ewLanguage.Phrase('DeleteMultiConfirmMsg'));return false;"">" & Language.Phrase("DeleteSelectedLink") & "</a>"
		item.Visible = (Security.CanDelete)

		' Set up options default
		Set opt = AddEditOptions
		opt.DropDownButtonPhrase = Language.Phrase("ButtonAddEdit")
		opt.UseDropDownButton = False
		opt.UseButtonGroup = True
		opt.ButtonClass = "btn-small" ' Class for button group
		Call opt.Add(opt.GroupOptionName)
		Set item = opt.GetItem(opt.GroupOptionName)
		item.Body = ""
		item.Visible = False
		Set opt = DetailOptions
		opt.DropDownButtonPhrase = Language.Phrase("ButtonDetails")
		opt.UseDropDownButton = False
		opt.UseButtonGroup = True
		opt.ButtonClass = "btn-small" ' Class for button group
		Call opt.Add(opt.GroupOptionName)
		Set item = opt.GetItem(opt.GroupOptionName)
		item.Body = ""
		item.Visible = False
		Set opt = ActionOptions
		opt.DropDownButtonPhrase = Language.Phrase("ButtonActions")
		opt.UseDropDownButton = False
		opt.UseButtonGroup = True
		opt.ButtonClass = "btn-small" ' Class for button group
		Call opt.Add(opt.GroupOptionName)
		Set item = opt.GetItem(opt.GroupOptionName)
		item.Body = ""
		item.Visible = False
	End Sub

	' Render other options
	Sub RenderOtherOptions()
		Dim opt, item, i, Action, Name
			Set opt = ActionOptions
			For i = 0 to UBound(webset.CustomActions.CustomArray)
				Action = webset.CustomActions.CustomArray(i)(0)
				Name = webset.CustomActions.CustomArray(i)(1)

				' Add custom action
				Call opt.Add("custom_" & Action)
				Set item = opt.GetItem("custom_" & Action)
				item.Body = "<a class=""ewAction ewCustomAction"" href="""" onclick=""ew_SubmitSelected(document.fwebsetlist, '" & ew_CurrentUrl & "', null, '" & Action & "');return false;"">" & Name & "</a>"
			Next

			' Hide grid edit, multi-delete and multi-update
			If TotalRecs <= 0 Then
				Set opt = AddEditOptions
				Set item = opt.GetItem("gridedit")
				If (Not item Is Nothing) Then item.Visible = False
				Set opt = ActionOptions
				Set item = opt.GetItem("multidelete")
				If (Not item Is Nothing) Then item.Visible = False
				Set item = opt.GetItem("multiupdate")
				If (Not item Is Nothing) Then item.Visible = False
			End If
	End Sub

	' Process custom action
	Sub ProcessCustomAction()
		Dim sFilter, sSql, UserAction, Processed
		sFilter = webset.GetKeyFilter
		UserAction = Request.Form("useraction") & ""
		Processed = False
		If sFilter <> "" And UserAction <> "" Then
			webset.CurrentFilter = sFilter
			sSql = webset.SQL
			Conn.BeginTrans

			' Load recordset
			Dim Rs
			Set Rs = ew_LoadRecordset(sSql)
			If Not Rs.Eof Then Rs.MoveFirst

			' Call row custom action event
			Do While Not Rs.Eof
				Processed = Row_CustomAction(UserAction, Rs)
				If Not Processed Then
					Exit Do
				Else
					Rs.MoveNext
				End If
			Loop
			Rs.Close
			Set Rs = Nothing
			If Processed Then
				Conn.CommitTrans ' Commit the changes
				If SuccessMessage = "" Then
					SuccessMessage = Replace(Language.Phrase("CustomActionCompleted"), "%s", UserAction) ' Set up success message
				End If
			Else
				Conn.RollbackTrans ' Rollback transaction

				' Set up error message
				If SuccessMessage <> "" Or FailureMessage <> "" Then

					' Use the message, do nothing
				ElseIf webset.CancelMessage <> "" Then
					FailureMessage = webset.CancelMessage
					webset.CancelMessage = ""
				Else
					FailureMessage = Replace(Language.Phrase("CustomActionCancelled"), "%s", UserAction)
				End If
			End If
		End If
	End Sub

	Function RenderListOptionsExt()
	End Function
	Dim Pager

	' -----------------------------------------------------------------
	' Set up Starting Record parameters based on Pager Navigation
	'
	Sub SetUpStartRec()
		Dim PageNo

		' Exit if DisplayRecs = 0
		If DisplayRecs = 0 Then Exit Sub
		If IsPageRequest Then ' Validate request

			' Check for a START parameter
			If Request.QueryString(EW_TABLE_START_REC).Count > 0 Then
				StartRec = Request.QueryString(EW_TABLE_START_REC)
				webset.StartRecordNumber = StartRec
			ElseIf Request.QueryString(EW_TABLE_PAGE_NO).Count > 0 Then
				PageNo = Request.QueryString(EW_TABLE_PAGE_NO)
				If IsNumeric(PageNo) Then
					StartRec = (PageNo-1)*DisplayRecs+1
					If StartRec <= 0 Then
						StartRec = 1
					ElseIf StartRec >= ((TotalRecs-1)\DisplayRecs)*DisplayRecs+1 Then
						StartRec = ((TotalRecs-1)\DisplayRecs)*DisplayRecs+1
					End If
					webset.StartRecordNumber = StartRec
				End If
			End If
		End If
		StartRec = webset.StartRecordNumber

		' Check if correct start record counter
		If Not IsNumeric(StartRec) Or StartRec = "" Then ' Avoid invalid start record counter
			StartRec = 1 ' Reset start record counter
			webset.StartRecordNumber = StartRec
		ElseIf CLng(StartRec) > CLng(TotalRecs) Then ' Avoid starting record > total records
			StartRec = ((TotalRecs-1)\DisplayRecs)*DisplayRecs+1 ' Point to last page first record
			webset.StartRecordNumber = StartRec
		ElseIf (StartRec-1) Mod DisplayRecs <> 0 Then
			StartRec = ((StartRec-1)\DisplayRecs)*DisplayRecs+1 ' Point to page boundary
			webset.StartRecordNumber = StartRec
		End If
	End Sub

	' -----------------------------------------------------------------
	' Load recordset
	'
	Function LoadRecordset()

		' Call Recordset Selecting event
		Dim sFilter
		sFilter = webset.CurrentFilter
		Call webset.Recordset_Selecting(sFilter)
		webset.CurrentFilter = sFilter

		' Load list page sql
		Dim sSql
		sSql = webset.ListSQL
		Call ew_SetDebugMsg("LoadRecordset: " & sSql) ' Show SQL for debugging

		' Load recordset
		Dim RsRecordset
		Set RsRecordset = ew_LoadRecordset(sSql)

		' Call Recordset Selected event
		Call webset.Recordset_Selected(RsRecordset)
		Set LoadRecordset = RsRecordset
	End Function

	' -----------------------------------------------------------------
	' Load row based on key values
	'
	Function LoadRow()
		Dim RsRow, sSql, sFilter
		sFilter = webset.KeyFilter

		' Call Row Selecting event
		Call webset.Row_Selecting(sFilter)

		' Load sql based on filter
		webset.CurrentFilter = sFilter
		sSql = webset.SQL
		Call ew_SetDebugMsg("LoadRow: " & sSql) ' Show SQL for debugging
		Set RsRow = ew_LoadRow(sSql)
		If RsRow.Eof Then
			LoadRow = False
		Else
			LoadRow = True
			RsRow.MoveFirst
			Call LoadRowValues(RsRow) ' Load row values
		End If
		RsRow.Close
		Set RsRow = Nothing
	End Function

	' -----------------------------------------------------------------
	' Load row values from recordset
	'
	Sub LoadRowValues(RsRow)
		Dim sDetailFilter
		If Not EW_DEBUG_ENABLED Then On Error Resume Next
		If RsRow.Eof Then Exit Sub

		' Call Row Selected event
		Call webset.Row_Selected(RsRow)
		webset.id.DbValue = RsRow("id")
		webset.webname.DbValue = RsRow("webname")
		webset.icp.DbValue = RsRow("icp")
		webset.lxr.DbValue = RsRow("lxr")
		webset.sj.DbValue = RsRow("sj")
		webset.zj.DbValue = RsRow("zj")
		webset.cz.DbValue = RsRow("cz")
		webset.dz.DbValue = RsRow("dz")
		webset.yx.DbValue = RsRow("yx")
		webset.phone400.DbValue = RsRow("phone400")
		webset.qq1.DbValue = RsRow("qq1")
		webset.qq2.DbValue = RsRow("qq2")
		webset.qq3.DbValue = RsRow("qq3")
		webset.qq4.DbValue = RsRow("qq4")
		webset.ww1.DbValue = RsRow("ww1")
		webset.ww2.DbValue = RsRow("ww2")
		webset.ww3.DbValue = RsRow("ww3")
		webset.tongji.DbValue = RsRow("tongji")
		webset.ishtml.DbValue = RsRow("ishtml")
		webset.isqq.DbValue = RsRow("isqq")
		webset.logo.DbValue = RsRow("logo")
	End Sub

	' Load DbValue from recordset
	Sub LoadDbValues(Rs)
		If Not EW_DEBUG_ENABLED Then On Error Resume Next
		If Rs.Eof Then Exit Sub
		webset.id.m_DbValue = Rs("id")
		webset.webname.m_DbValue = Rs("webname")
		webset.icp.m_DbValue = Rs("icp")
		webset.lxr.m_DbValue = Rs("lxr")
		webset.sj.m_DbValue = Rs("sj")
		webset.zj.m_DbValue = Rs("zj")
		webset.cz.m_DbValue = Rs("cz")
		webset.dz.m_DbValue = Rs("dz")
		webset.yx.m_DbValue = Rs("yx")
		webset.phone400.m_DbValue = Rs("phone400")
		webset.qq1.m_DbValue = Rs("qq1")
		webset.qq2.m_DbValue = Rs("qq2")
		webset.qq3.m_DbValue = Rs("qq3")
		webset.qq4.m_DbValue = Rs("qq4")
		webset.ww1.m_DbValue = Rs("ww1")
		webset.ww2.m_DbValue = Rs("ww2")
		webset.ww3.m_DbValue = Rs("ww3")
		webset.tongji.m_DbValue = Rs("tongji")
		webset.ishtml.m_DbValue = Rs("ishtml")
		webset.isqq.m_DbValue = Rs("isqq")
		webset.logo.m_DbValue = Rs("logo")
	End Sub

	' Load old record
	Function LoadOldRecord()

		' Load key values from Session
		Dim bValidKey
		bValidKey = True
		If webset.GetKey("id")&"" <> "" Then
			webset.id.CurrentValue = webset.GetKey("id") ' id
		Else
			bValidKey = False
		End If

		' Load old recordset
		If bValidKey Then
			webset.CurrentFilter = webset.KeyFilter
			Dim sSql
			sSql = webset.SQL
			Set OldRecordset = ew_LoadRecordset(sSql)
			Call LoadRowValues(OldRecordset) ' Load row values
		Else
			OldRecordset = Null
		End If
		LoadOldRecord = bValidKey
	End Function

	' -----------------------------------------------------------------
	' Render row values based on field settings
	'
	Sub RenderRow()

		' Initialize urls
		ViewUrl = webset.ViewUrl("")
		EditUrl = webset.EditUrl("")
		InlineEditUrl = webset.InlineEditUrl
		CopyUrl = webset.CopyUrl("")
		InlineCopyUrl = webset.InlineCopyUrl
		DeleteUrl = webset.DeleteUrl

		' Call Row Rendering event
		Call webset.Row_Rendering()

		' ---------------------------------------
		'  Common render codes for all row types
		' ---------------------------------------
		' id
		' webname
		' icp
		' lxr
		' sj
		' zj
		' cz
		' dz
		' yx
		' phone400
		' qq1
		' qq2
		' qq3
		' qq4
		' ww1
		' ww2
		' ww3
		' tongji
		' ishtml
		' isqq
		' logo
		' -----------
		'  View  Row
		' -----------

		If webset.RowType = EW_ROWTYPE_VIEW Then ' View row

			' id
			webset.id.ViewValue = webset.id.CurrentValue
			webset.id.ViewCustomAttributes = ""

			' webname
			webset.webname.ViewValue = webset.webname.CurrentValue
			webset.webname.ViewCustomAttributes = ""

			' icp
			webset.icp.ViewValue = webset.icp.CurrentValue
			webset.icp.ViewCustomAttributes = ""

			' lxr
			webset.lxr.ViewValue = webset.lxr.CurrentValue
			webset.lxr.ViewCustomAttributes = ""

			' sj
			webset.sj.ViewValue = webset.sj.CurrentValue
			webset.sj.ViewCustomAttributes = ""

			' zj
			webset.zj.ViewValue = webset.zj.CurrentValue
			webset.zj.ViewCustomAttributes = ""

			' cz
			webset.cz.ViewValue = webset.cz.CurrentValue
			webset.cz.ViewCustomAttributes = ""

			' dz
			webset.dz.ViewValue = webset.dz.CurrentValue
			webset.dz.ViewCustomAttributes = ""

			' yx
			webset.yx.ViewValue = webset.yx.CurrentValue
			webset.yx.ViewCustomAttributes = ""

			' phone400
			webset.phone400.ViewValue = webset.phone400.CurrentValue
			webset.phone400.ViewCustomAttributes = ""

			' qq1
			webset.qq1.ViewValue = webset.qq1.CurrentValue
			webset.qq1.ViewCustomAttributes = ""

			' qq2
			webset.qq2.ViewValue = webset.qq2.CurrentValue
			webset.qq2.ViewCustomAttributes = ""

			' qq3
			webset.qq3.ViewValue = webset.qq3.CurrentValue
			webset.qq3.ViewCustomAttributes = ""

			' qq4
			webset.qq4.ViewValue = webset.qq4.CurrentValue
			webset.qq4.ViewCustomAttributes = ""

			' ww1
			webset.ww1.ViewValue = webset.ww1.CurrentValue
			webset.ww1.ViewCustomAttributes = ""

			' ww2
			webset.ww2.ViewValue = webset.ww2.CurrentValue
			webset.ww2.ViewCustomAttributes = ""

			' ww3
			webset.ww3.ViewValue = webset.ww3.CurrentValue
			webset.ww3.ViewCustomAttributes = ""

			' ishtml
			If Not IsNull(webset.ishtml.CurrentValue) Then
				Select Case webset.ishtml.CurrentValue & ""
					Case webset.ishtml.FldTagValue(1)
						webset.ishtml.ViewValue = ew_IIf(webset.ishtml.FldTagCaption(1) <> "", webset.ishtml.FldTagCaption(1), webset.ishtml.CurrentValue)
					Case webset.ishtml.FldTagValue(2)
						webset.ishtml.ViewValue = ew_IIf(webset.ishtml.FldTagCaption(2) <> "", webset.ishtml.FldTagCaption(2), webset.ishtml.CurrentValue)
					Case Else
						webset.ishtml.ViewValue = webset.ishtml.CurrentValue
				End Select
			Else
				webset.ishtml.ViewValue = Null
			End If
			webset.ishtml.ViewCustomAttributes = ""

			' isqq
			If Not IsNull(webset.isqq.CurrentValue) Then
				Select Case webset.isqq.CurrentValue & ""
					Case webset.isqq.FldTagValue(1)
						webset.isqq.ViewValue = ew_IIf(webset.isqq.FldTagCaption(1) <> "", webset.isqq.FldTagCaption(1), webset.isqq.CurrentValue)
					Case webset.isqq.FldTagValue(2)
						webset.isqq.ViewValue = ew_IIf(webset.isqq.FldTagCaption(2) <> "", webset.isqq.FldTagCaption(2), webset.isqq.CurrentValue)
					Case Else
						webset.isqq.ViewValue = webset.isqq.CurrentValue
				End Select
			Else
				webset.isqq.ViewValue = Null
			End If
			webset.isqq.ViewCustomAttributes = ""

			' View refer script
			' id

			webset.id.LinkCustomAttributes = ""
			webset.id.HrefValue = ""
			webset.id.TooltipValue = ""

			' webname
			webset.webname.LinkCustomAttributes = ""
			webset.webname.HrefValue = ""
			webset.webname.TooltipValue = ""

			' lxr
			webset.lxr.LinkCustomAttributes = ""
			webset.lxr.HrefValue = ""
			webset.lxr.TooltipValue = ""

			' sj
			webset.sj.LinkCustomAttributes = ""
			webset.sj.HrefValue = ""
			webset.sj.TooltipValue = ""

			' ishtml
			webset.ishtml.LinkCustomAttributes = ""
			webset.ishtml.HrefValue = ""
			webset.ishtml.TooltipValue = ""

			' isqq
			webset.isqq.LinkCustomAttributes = ""
			webset.isqq.HrefValue = ""
			webset.isqq.TooltipValue = ""
		End If

		' Call Row Rendered event
		If webset.RowType <> EW_ROWTYPE_AGGREGATEINIT Then
			Call webset.Row_Rendered()
		End If
	End Sub

	' Set up export options
	Sub SetupExportOptions()
		Dim item

		' Printer friendly
		ExportOptions.Add("print")
		Set item = ExportOptions.GetItem("print")
		item.Body = "<a href=""" & ExportPrintUrl & """ class=""ewExportLink ewPrint"" data-caption=""" & ew_HtmlEncode(Language.Phrase("PrinterFriendlyText")) & """>" & Language.Phrase("PrinterFriendly") & "</a>"
		item.Visible = True

		' Export to Excel
		ExportOptions.Add("excel")
		Set item = ExportOptions.GetItem("excel")
		item.Body = "<a href=""" & ExportExcelUrl & """ class=""ewExportLink ewExcel"" data-caption=""" & ew_HtmlEncode(Language.Phrase("ExportToExcelText")) & """>" & Language.Phrase("ExportToExcel") & "</a>"
		item.Visible = True

		' Export to Word
		ExportOptions.Add("word")
		Set item = ExportOptions.GetItem("word")
		item.Body = "<a href=""" & ExportWordUrl & """ class=""ewExportLink ewWord"" data-caption=""" & ew_HtmlEncode(Language.Phrase("ExportToWordText")) & """>" & Language.Phrase("ExportToWord") & "</a>"
		item.Visible = True

		' Export to Html
		ExportOptions.Add("html")
		Set item = ExportOptions.GetItem("html")
		item.Body = "<a href=""" & ExportHtmlUrl & """ class=""ewExportLink ewHtml"" data-caption=""" & ew_HtmlEncode(Language.Phrase("ExportToHtmlText")) & """>" & Language.Phrase("ExportToHtml") & "</a>"
		item.Visible = False

		' Export to Xml
		ExportOptions.Add("xml")
		Set item = ExportOptions.GetItem("xml")
		item.Body = "<a href=""" & ExportXmlUrl & """ class=""ewExportLink ewXml"" data-caption=""" & ew_HtmlEncode(Language.Phrase("ExportToXmlText")) & """>" & Language.Phrase("ExportToXml") & "</a>"
		item.Visible = False

		' Export to Csv
		ExportOptions.Add("csv")
		Set item = ExportOptions.GetItem("csv")
		item.Body = "<a href=""" & ExportCsvUrl & """ class=""ewExportLink ewCsv"" data-caption=""" & ew_HtmlEncode(Language.Phrase("ExportToCsvText")) & """>" & Language.Phrase("ExportToCsv") & "</a>"
		item.Visible = False

		' Export to Pdf
		ExportOptions.Add("pdf")
		Set item = ExportOptions.GetItem("pdf")
		item.Body = "<a href=""" & ExportPdfUrl & """ class=""ewExportLink ewPdf"" data-caption=""" & ew_HtmlEncode(Language.Phrase("ExportToPDFText")) & """>" & Language.Phrase("ExportToPDF") & "</a>"
		item.Visible = False

		' Export to Email
		ExportOptions.Add("email")
		Set item = ExportOptions.GetItem("email")
		item.Body = "<a id=""emf_webset"" href=""javascript:void(0);"" class=""ewExportLink ewEmail"" data-caption=""" & Language.Phrase("ExportToEmailText") & """  onclick=""ew_EmailDialogShow({lnk:'emf_webset',hdr:ewLanguage.Phrase('ExportToEmail'),f:document.fwebsetlist,sel:false});"">" & Language.Phrase("ExportToEmail") & "</a>"
		item.Visible = False

		' Drop down button for export
		ExportOptions.UseDropDownButton = False
		ExportOptions.DropDownButtonPhrase = Language.Phrase("ButtonExport")

		' Add group option item
		ExportOptions.Add(ExportOptions.GroupOptionName)
		Set item = ExportOptions.GetItem(ExportOptions.GroupOptionName)
		item.Body = ""
		item.Visible = False
	End Sub

	' -----------------------------------------------------------------
	' Export data in HTML/CSV/Word/Excel/XML/Email format
	'
	Sub ExportData()
		Dim XmlDoc
		Dim ExportDoc
		Dim ExportStyle

		' Default export style
		ExportStyle = "h"

		' Load recordset
		Set Rs = LoadRecordset()
		TotalRecs = Rs.RecordCount
		StartRec = 1

		' Export all
		If webset.ExportAll Then
			StopRec = TotalRecs

			' Set script timeout
			If EW_EXPORT_ALL_TIME_LIMIT > 0 Then
				Server.ScriptTimeout = EW_EXPORT_ALL_TIME_LIMIT
			End If

		' Export 1 page only
		Else
			SetUpStartRec() ' Set Up Start Record Position

			' Set the last record to display
			If DisplayRecs <= 0 Then
				StopRec = TotalRecs
			Else
				StopRec = StartRec + DisplayRecs - 1
			End If
		End If
		If webset.Export = "xml" Then
			Set XmlDoc = New cXMLDocument
		Else
			Set ExportDoc = New cExportDocument
			Set ExportDoc.Table = webset
			Call ExportDoc.ChangeStyle("h")
		End If
		Dim ParentTable
		ParentTable = ""
		If webset.Export = "xml" Then
			Call webset.ExportXmlDocument(XmlDoc, (ParentTable <> ""), rs, StartRec, StopRec, "")
		Else
			Dim sHeader
			sHeader = PageHeader
			Call Page_DataRendering(sHeader)
			ExportDoc.Text = ExportDoc.Text & sHeader
			Call webset.ExportDocument(ExportDoc, rs, StartRec, StopRec, "")
			Dim sFooter
			sFooter = PageFooter
			Call Page_DataRendered(sFooter)
			ExportDoc.Text = ExportDoc.Text & sFooter
		End If

		' Close recordset and connection
		Rs.Close
		Set Rs = Nothing

		' Export header and footer
		If webset.Export <> "xml" Then
			Call ExportDoc.ExportHeaderAndFooter()
		End If
		If webset.Export = "xml" Then
			XmlDoc.Output
			Set XmlDoc = Nothing
		Else
			If webset.Export = "email" Then
				Response.Write ExportEmail(ExportDoc.Text)
			ElseIf webset.Export = "pdf" Then
				Call ExportPdf(ExportDoc.Text)
			Else
				Response.Write ExportDoc.Text
			End If
			Set ExportDoc = Nothing
		End If
	End Sub

	' Set up Breadcrumb
	Sub SetupBreadcrumb()
		Dim PageId, url
		Set Breadcrumb = New cBreadcrumb
		url = ew_CurrentUrl
		url = ew_RegExReplace("\?cmd=reset(all){0,1}$", url, "") ' Remove cmd=reset / cmd=resetall
		Call Breadcrumb.Add("list", webset.TableVar, url, webset.TableVar, True)
	End Sub

	Sub ExportPdf(html)
		Response.Write html
	End Sub

	' Page Load event
	Sub Page_Load()

		'Response.Write "Page Load"
	End Sub

	' Page Unload event
	Sub Page_Unload()

		'Response.Write "Page Unload"
	End Sub

	' Page Redirecting event
	Sub Page_Redirecting(url)

		'url = newurl
	End Sub

	' Message Showing event
	' typ = ""|"success"|"failure"|"warning"
	Sub Message_Showing(msg, typ)

		' Example:
		'If typ = "success" Then
		'	msg = "your success message"
		'ElseIf typ = "failure" Then
		'	msg = "your failure message"
		'ElseIf typ = "warning" Then
		'	msg = "your warning message"
		'Else
		'	msg = "your message"
		'End If

	End Sub

	' Page Render event
	Sub Page_Render()

		'Response.Write "Page Render"
	End Sub

	' Page Data Rendering event
	Sub Page_DataRendering(header)

		' Example:
		'header = "your header"

	End Sub

	' Page Data Rendered event
	Sub Page_DataRendered(footer)

		' Example:
		'footer = "your footer"

	End Sub

	' Form Custom Validate event
	Function Form_CustomValidate(CustomError)

		'Return error message in CustomError
		Form_CustomValidate = True
	End Function

	' ListOptions Load event
	Sub ListOptions_Load()

		'Example: 
		' Dim opt
		' Set opt = ListOptions.Add("new")
		' opt.OnLeft = True ' Link on left
		' opt.MoveTo 0 ' Move to first column

	End Sub

	' ListOptions Rendered event
	Sub ListOptions_Rendered()

		'Example: 
		'ListOptions.GetItem("new").Body = "xxx"

	End Sub

	' Row Custom Action event
	Function Row_CustomAction(action, rs)

		' Return False to abort
		Row_CustomAction = True
	End Function
End Class
%>
