<%
Response.Buffer = EW_RESPONSE_BUFFER
%>
<!--#include file="ewcfg11.asp"-->
<!--#include file="xwlminfo.asp"-->
<!--#include file="bhlminfo.asp"-->
<!--#include file="zlogininfo.asp"-->
<!--#include file="aspfn11.asp"-->
<!--#include file="md5.asp"-->
<!--#include file="userfn11.asp"-->
<% Session.Timeout = 900 %>
<% If ew_IsHttps() Then Call ew_Header(True, EW_CHARSET) Else Call ew_Header(False, EW_CHARSET) %>
<%

' Define page object
Dim xwlm_pic_blobview
Set xwlm_pic_blobview = New cxwlm_pic_blobview
Set Page = xwlm_pic_blobview

' Page init processing
xwlm_pic_blobview.Page_Init()

' Page main processing
xwlm_pic_blobview.Page_Main()
%>
<%

' Drop page object
Set xwlm_pic_blobview = Nothing
%>
<%

' -----------------------------------------------------------------
' Page Class
'
Class cxwlm_pic_blobview

	' Page ID
	Public Property Get PageID()
		PageID = "blobview"
	End Property

	' Project ID
	Public Property Get ProjectID()
		ProjectID = "{9AC218D3-4571-402E-9408-D679EC504540}"
	End Property

	' Page Object Name
	Public Property Get PageObjName()
		PageObjName = "xwlm_pic_blobview"
	End Property

	' Page Name
	Public Property Get PageName()
		PageName = ew_CurrentPage()
	End Property

	' Page Url
	Public Property Get PageUrl()
		PageUrl = ew_CurrentPage() & "?"
	End Property

	' Message
	Public Property Get Message()
		Message = Session(EW_SESSION_MESSAGE)
	End Property

	Public Property Let Message(v)
		Dim msg
		msg = Session(EW_SESSION_MESSAGE)
		Call ew_AddMessage(msg, v)
		Session(EW_SESSION_MESSAGE) = msg
	End Property

	Public Property Get FailureMessage()
		FailureMessage = Session(EW_SESSION_FAILURE_MESSAGE)
	End Property

	Public Property Let FailureMessage(v)
		Dim msg
		msg = Session(EW_SESSION_FAILURE_MESSAGE)
		Call ew_AddMessage(msg, v)
		Session(EW_SESSION_FAILURE_MESSAGE) = msg
	End Property

	Public Property Get SuccessMessage()
		SuccessMessage = Session(EW_SESSION_SUCCESS_MESSAGE)
	End Property

	Public Property Let SuccessMessage(v)
		Dim msg
		msg = Session(EW_SESSION_SUCCESS_MESSAGE)
		Call ew_AddMessage(msg, v)
		Session(EW_SESSION_SUCCESS_MESSAGE) = msg
	End Property

	Public Property Get WarningMessage()
		WarningMessage = Session(EW_SESSION_WARNING_MESSAGE)
	End Property

	Public Property Let WarningMessage(v)
		Dim msg
		msg = Session(EW_SESSION_WARNING_MESSAGE)
		Call ew_AddMessage(msg, v)
		Session(EW_SESSION_WARNING_MESSAGE) = msg
	End Property

	' Show Message
	Public Sub ShowMessage()
		Dim hidden, html, sMessage
		hidden = False
		html = ""

		' Message
		sMessage = Message
		Call Message_Showing(sMessage, "")
		If sMessage <> "" Then ' Message in Session, display
			If Not hidden Then sMessage = "<button type=""button"" class=""close"" data-dismiss=""alert"">&times;</button>" & sMessage
			html = html & "<div class=""alert alert-success ewSuccess"">" & sMessage & "</div>"
			Session(EW_SESSION_MESSAGE) = "" ' Clear message in Session
		End If

		' Warning message
		Dim sWarningMessage
		sWarningMessage = WarningMessage
		Call Message_Showing(sWarningMessage, "warning")
		If sWarningMessage <> "" Then ' Message in Session, display
			If Not hidden Then sWarningMessage = "<button type=""button"" class=""close"" data-dismiss=""alert"">&times;</button>" & sWarningMessage
			html = html & "<div class=""alert alert-warning ewWarning"">" & sWarningMessage & "</div>"
			Session(EW_SESSION_WARNING_MESSAGE) = "" ' Clear message in Session
		End If

		' Success message
		Dim sSuccessMessage
		sSuccessMessage = SuccessMessage
		Call Message_Showing(sSuccessMessage, "success")
		If sSuccessMessage <> "" Then ' Message in Session, display
			If Not hidden Then sSuccessMessage = "<button type=""button"" class=""close"" data-dismiss=""alert"">&times;</button>" & sSuccessMessage
			html = html & "<div class=""alert alert-success ewSuccess"">" & sSuccessMessage & "</div>"
			Session(EW_SESSION_SUCCESS_MESSAGE) = "" ' Clear message in Session
		End If

		' Failure message
		Dim sErrorMessage
		sErrorMessage = FailureMessage
		Call Message_Showing(sErrorMessage, "failure")
		If sErrorMessage <> "" Then ' Message in Session, display
			If Not hidden Then sErrorMessage = "<button type=""button"" class=""close"" data-dismiss=""alert"">&times;</button>" & sErrorMessage
			html = html & "<div class=""alert alert-error ewError"">" & sErrorMessage & "</div>"
			Session(EW_SESSION_FAILURE_MESSAGE) = "" ' Clear message in Session
		End If
		Response.Write "<table class=""ewStdTable""><tr><td><div class=""ewMessageDialog""" & ew_IIf(hidden, " style=""display: none;""", "") & ">" & html & "</div></td></tr></table>"
	End Sub

	' -----------------------------------------------------------------
	'  Class initialize
	'  - init objects
	'  - open ADO connection
	'
	Private Sub Class_Initialize()
		If IsEmpty(StartTimer) Then StartTimer = Timer ' Init start time

		' Initialize language object
		If IsEmpty(Language) Then
			Set Language = New cLanguage
			Call Language.LoadPhrases()
		End If

		' Initialize table object
		If IsEmpty(xwlm) Then Set xwlm = New cxwlm
		Set Table = xwlm

		' Initialize urls
		' Initialize other table object

		If IsEmpty(bhlm) Then Set bhlm = New cbhlm

		' Initialize other table object
		If IsEmpty(zlogin) Then Set zlogin = New czlogin

		' Initialize form object
		Set ObjForm = Nothing

		' Intialize page id (for backward compatibility)
		EW_PAGE_ID = "blobview"

		' Initialize table name (for backward compatibility)
		EW_TABLE_NAME = "xwlm"

		' Open connection to the database
		If IsEmpty(Conn) Then Call ew_Connect()
	End Sub

	' -----------------------------------------------------------------
	'  Subroutine Page_Init
	'  - called before page main
	'  - check Security
	'  - set up response header
	'  - call page load events
	'
	Sub Page_Init()
		Set Security = New cAdvancedSecurity
		If Not Security.IsLoggedIn() Then Call Security.AutoLogin()
		If Not Security.IsLoggedIn() Then
			Call Security.SaveLastUrl()
			Call Page_Terminate("login.asp")
		End If

		' Table Permission loading event
		Call Security.TablePermission_Loading()
		Call Security.LoadCurrentUserLevel(CurrentProjectID & "xwlm")

		' Table Permission loaded event
		Call Security.TablePermission_Loaded()
		If Not Security.IsLoggedIn() Then
			Call Security.SaveLastUrl()
			Call Page_Terminate("login.asp")
		End If
		If Not Security.CanList Then
			Call Page_Terminate("")
			Response.End
		End If

		' Page load event, used in current page
		Page_Load()
	End Sub

	' -----------------------------------------------------------------
	'  Class terminate
	'  - clean up page object
	'
	Private Sub Class_Terminate()
		Call Page_Terminate("")
	End Sub

	' -----------------------------------------------------------------
	'  Subroutine Page_Terminate
	'  - called when exit page
	'  - clean up ADO connection and objects
	'  - if url specified, redirect to url
	'
	Sub Page_Terminate(url)

		' Page unload event, used in current page
		Call Page_Unload()
		Dim sRedirectUrl
		sReDirectUrl = url
		Call Page_Redirecting(sReDirectUrl)
		If Not (Conn Is Nothing) Then Conn.Close ' Close Connection
		Set Conn = Nothing
		Set Security = Nothing
		Set xwlm = Nothing
		Set ObjForm = Nothing

		' Go to url if specified
		If sReDirectUrl <> "" Then
			If Response.Buffer Then Response.Clear
			Response.Redirect sReDirectUrl
		End If
	End Sub

	'
	'  Subroutine Page_Terminate (End)
	' ----------------------------------------
	' -----------------------------------------------------------------
	' Page main processing
	'
	Sub Page_Main()
		Dim sFilter, objBinary

		' Get key
		If Request.QueryString("lmid").Count > 0 Then
			xwlm.lmid.QueryStringValue = Request.QueryString("lmid")
		Else
			Call Page_Terminate("") ' Clean up
			Response.End ' Exit
		End If
		Set objBinary = New cUpload

		' Show thumbnail
		Dim bShowThumbnail, iThumbnailWidth, iThumbnailHeight, iInterpolation
		bShowThumbnail = (Request.QueryString("showthumbnail") = "1")
		If Request.QueryString("thumbnailwidth").Count <= 0 And Request.QueryString("thumbnailheight").Count <= 0 Then
			iThumbnailWidth = EW_THUMBNAIL_DEFAULT_WIDTH ' Set default width
			iThumbnailHeight = EW_THUMBNAIL_DEFAULT_HEIGHT ' Set default height
		Else
			If Request.QueryString("thumbnailwidth").Count > 0 Then
				iThumbnailWidth = Request.QueryString("thumbnailwidth")
				If Not IsNumeric(iThumbnailWidth) Or iThumbnailWidth < 0 Then iThumbnailWidth = 0
			End If
			If Request.QueryString("thumbnailheight").Count > 0 Then
				iThumbnailHeight = Request.QueryString("thumbnailheight")
				If Not IsNumeric(iThumbnailHeight) Or iThumbnailHeight < 0 Then iThumbnailHeight = 0
			End If
		End If
		If Request.QueryString("interpolation").Count > 0 Then
			iInterpolation = Request.QueryString("interpolation")
			If Not IsNumeric(iInterpolation) Or iInterpolation < 0 Or iInterpolation > 2 Then iInterpolation = EW_THUMBNAIL_DEFAULT_INTERPOLATION ' Set Default
		Else
			iInterpolation = EW_THUMBNAIL_DEFAULT_INTERPOLATION
		End If
		sFilter = xwlm.KeyFilter

		' Set up filter (Sql Where Clause) and get Return Sql
		' Sql constructor in xwlm class, xwlminfo.asp

		Dim sSql, Recordset
		xwlm.CurrentFilter = sFilter
		sSql = xwlm.SQL
		Set Recordset = Server.CreateObject("ADODB.Recordset")
		Recordset.Open sSql, Conn
		If Not Recordset.Eof Then
			If Response.Buffer Then Response.Clear
			Dim filesize, filetype, filename
			filename = Recordset("pic")
			objBinary.Value = Recordset("pic").Value
			If bShowThumbnail Then
				Call objBinary.Resize(iThumbnailWidth, iThumbnailHeight, iInterpolation)
			End If

			'Response.ContentType = "image/bmp"
			Response.ContentType = ew_ContentType(LeftB(objBinary.Value,11), "")
			If filename&"" <> "" Then
				Response.AddHeader "Content-Disposition", "attachment; filename=""" & filename & """"
			End If
			Response.BinaryWrite objBinary.Value
		End If
		Recordset.Close
		Set Recordset = Nothing
		Set objBinary = Nothing
	End Sub

	' Page Load event
	Sub Page_Load()

		'Response.Write "Page Load"
	End Sub

	' Page Unload event
	Sub Page_Unload()

		'Response.Write "Page Unload"
	End Sub

	' Page Redirecting event
	Sub Page_Redirecting(url)

		'url = newurl
	End Sub

	' Message Showing event
	' typ = ""|"success"|"failure"
	Sub Message_Showing(msg, typ)

		' Example:
		'If typ = "success" Then msg = "your success message"

	End Sub
End Class
%>
