#include "stdafx.h"
#include "SmsApi.h"
#include "CXml/Xml.h"
#include "WebAccess.h"
#include "md5.h"
#include <vector>
#include <sstream>
char * urlencode(char const *s, int len, int *new_length)
{
	std::cout<<s<<len;
	char const *from, *end;
	from = s;
	end = s + len;
	char *to;
	char *start = to = (char *) malloc(3 * len + 1);

	unsigned char hexchars[] = "0123456789ABCDEF";

	while (from < end) {
		unsigned char c = *from++;

		if (c == ' ') {
			*to++ = '+';
		} else if ((c < '0' && c != '-' && c != '.') ||
			(c < 'A' && c > '9') ||
			(c > 'Z' && c < 'a' && c != '_') ||
			(c > 'z')) {
				to[0] = '%';
				to[1] = hexchars[c >> 4];
				to[2] = hexchars[c & 15];
				to += 3;
		} else {
			*to++ = c;
		}
	}
	*to = 0;
	if (new_length) {
		*new_length = to - start;
	}
	return (char *) start;

}

char* urldecode(const char *str1, int len)
{
	char* str=new char[len+1];
	memcpy(str,str1,len);
	char *dest = str;
	char *data = str;

	int value;
	int c;

	while (len--) {
		if (*data == '+') {
			*dest = ' ';
		}
		else if (*data == '%' && len >= 2 && isxdigit((int) *(data + 1))
			&& isxdigit((int) *(data + 2)))
		{

			c = ((unsigned char *)(data+1))[0];
			if (isupper(c))
				c = tolower(c);
			value = (c >= '0' && c <= '9' ? c - '0' : c - 'a' + 10) * 16;
			c = ((unsigned char *)(data+1))[1];
			if (isupper(c))
				c = tolower(c);
			value += c >= '0' && c <= '9' ? c - '0' : c - 'a' + 10;

			*dest = (char)value ;
			data += 2;
			len -= 2;
		} else {
			*dest = *data;
		}
		data++;
		dest++;
	}
	*dest = '\0';
	//iLen=dest - str;

	return str;
}
std::string  urlDeCode(const std::string source)
{
	char* ret= urldecode(source.c_str(),source.length());
	std::string strRet=ret;
	return strRet;
}
std::string Md5HashString(const std::string source)
{
	MD5::CMessageDigestV MD;
	std::string dest;
	MD.Digest(source,dest);
	return dest;
}
std::string  urlEnCode(const std::string source)
{
	int newLen;
	char* buff=urlencode(source.c_str(),source.length(),&newLen);
	std::string ret=buff;
	return ret;
}
std::vector<std::string> split(const std::string& str, const std::string& delims = "\t\n ", unsigned int maxSplits = 0)
{
	std::vector<std::string> ret;
	// Pre-allocate some space for performance
	ret.reserve(maxSplits ? maxSplits+1 : 10);    // 10 is guessed capacity for most case

	unsigned int numSplits = 0;

	// Use STL methods 
	size_t start, pos;
	start = 0;
	do 
	{
		pos = str.find_first_of(delims, start);
		if (pos == start)
		{
			// Do nothing
			start = pos + 1;
		}
		else if (pos == std::string::npos || (maxSplits && numSplits == maxSplits))
		{
			// Copy the rest of the string
			ret.push_back( str.substr(start) );
			break;
		}
		else
		{
			// Copy up to delimiter
			ret.push_back( str.substr(start, pos - start) );
			start = pos + 1;
		}
		// parse up to next real data
		start = str.find_first_not_of(delims, start);
		++numSplits;

	} while (pos != std::string::npos);
	return ret;
}
 int  SendSms(const std::string& userName,const std::string& password,const SendData& data,std::string& errorMsg,int& msgCount)
 {
	 CString retData;
	 CString reQuestData;
	 CTime time(data.mTimerValue);
	 reQuestData.Format("uid=%s&pwd=%s&mobile=%s&content=%s",userName.c_str(),Md5HashString(password+userName).c_str(),data.mMobiles.c_str(),data.mMessage.c_str());
	 //CString reQuestData="uid="+userName+"&pwd=" + Md5HashString(password+userName) + "&mobile="++"&content=" + content
	 DWORD ret=web.Post("http://api.sms.cn/mt/",reQuestData,retData);
	return ret;
 }
 int ParseIntValue(const std::string& strValue)
 {
	 int ret;
	 if (strValue.empty())
	 {
		 return 0;
	 }
	 std::stringstream con;
	 con<<strValue;
	 con>>ret;
	 return ret;
 }
 time_t ParseDateTime(const std::string& strTime)
 {
	 std::vector<std::string> retVec=split(strTime,"- :");
	 if(retVec.size()!=6)
	 {
		 return time(NULL);
	 }
	 CTime timeValue(ParseIntValue(retVec[0]),
ParseIntValue(retVec[1]),
ParseIntValue(retVec[2]),
ParseIntValue(retVec[3]),
ParseIntValue(retVec[4]),
ParseIntValue(retVec[5]));
	return timeValue.GetTime();
 }