var net = new Object();
net.READY_STATE_UNINITATLIZED=0;
net.READY_STATE_LOADING=1;
net.READY_STATE_LOADED=2;
net.READY_STATE_INTERACTIVE=3;
net.READY_STATE_COMPLETE=4;

net.ContentLoader=function(url,onload,onerror,method,params,contentType){
    this.url=url;
    this.req=null;
    this.onload=onload;
	if(!params)
	{
		params=null;
	}
	if(!method)
	{
		method="GET";
	}
	if(!contentType)
	{
		contentType=null;
	}
	this.params=params;
	this.method=method;
	this.contentType=contentType;
    this.onerror=(onerror) ? onerror : this.defaultError;
    this.loadXMLDoc(url);
}

net.ContentLoader.prototype={
	loadXMLDoc:function(url)
	{
		if(!this.contentType && this.method=="POST")
		{
			this.contentType="application/x-www-form-urlencoded";
		}
		if (window.XMLHttpRequest){
			this.req=new XMLHttpRequest();
		}
		else if(window.ActiveXObject)
		{
			this.req=new ActiveXObject("Microsoft.XMLHTTP");
		}
		if(this.req)
		{
			try{
				var loader=this;
				this.req.onreadystatechange=function(){
					loader.onReadyState.call(loader);
				}
				this.req.open(this.method,url,true);
				if(this.contentType){
					this.req.setRequestHeader("Content-Type",this.contentType);
				}
				this.req.send(this.params);
			}
			catch(err){
				this.onerror.call(this);
			}
		}
	},
	onReadyState:function()
	{
		var req=this.req;
		var ready=req.readyState;
		if(ready==net.READY_STATE_COMPLETE){
			var httpStatus=req.status;
			if(httpStatus== 200 || httpStatus == 0){
				this.onload.call(this);
			}
			else{
				this.onerror.call(this);
			}
		}
	},
	defaultError:function()
	{
	    window.status="JavaScript Error:"+this.req.status;
	}
}