/**
 * Usage: 文件操作模块
 * Author: Spikef < Spikef@Foxmail.com >
 * Copyright: Envirs Team < http://envirs.com >
 */

var fs = {};

var util = require('util');
var fso = require('./lib/fso.js');

fs.existsSync = function(path) {
    return fso.DriveExists(path) || fso.FolderExists(path) || fso.FileExists(path);
};

fs.mkdirSync = function(path, mode) {
    try {
        fso.CreateFolder(path);
    } catch(e) {};

    return fso.FolderExists(path);
};

fs.rmdirSync = function(path) {
    if (fso.FolderExists(path)) {
        fso.DeleteFolder(path, true)
    }
};

fs.renameSync = function(oldPath, newPath) {
    var path = require('path');
    if ( !newPath.contains(':') ) {
        newPath = path.resolve(fso.GetParentFolderName(oldPath), newPath);
    };

    if ( fso.FolderExists(oldPath) ) {
        fso.MoveFolder(oldPath, newPath);
    } else if ( fso.FileExists(oldPath) ) {
        fso.MoveFile(oldPath, newPath);
    }
};

fs.readdirSync = function(path) {
    var fullPath = path.contains(':') ? path : require('path').resolve(path);

    if ( fso.FolderExists(fullPath) ) {
        var folder = fso.GetFolder(fullPath);
        return folder.Files.concat(folder.SubFolders);
    } else {
        return [];
    }
};

fs.unlinkSync = function(path) {
    var fullPath = path.contains(':') ? path : require('path').resolve(path);

    if ( fso.FileExists(path) ) {
        fso.DeleteFile(path, true);
    } else if ( fso.FolderExists(path) ) {
        fso.DeleteFolder(path, true);
    }
};

fs.Stats = function(
    mode, size, type, path, sname, spath, ctime, atime, mtime
) {
    this.mode = mode;
    this.size = size;
    this.type = type;
    this.path = path;
    this.sname = sname;
    this.spath = spath;
    this.ctime = ctime;
    this.atime = atime;
    this.mtime = mtime;
};

fs.Stats.prototype.isFile = function () {
    return fso.FileExists(this.path);
};

fs.Stats.prototype.isDirectory = function() {
    return fso.FolderExists(this.path);
};

fs.Stats.prototype.isDrive = function() {
    return fso.DriveExists(this.path);
};

fs.statSync = function(path) {
    var Stats = new this.Stats(0, 0, 'null', '', '', '', '', '', '');
    if ( fso.FileExists(path) ) {
        var F = fso.GetFile(path);
        Stats = new this.Stats(
            F.Attributes,
            F.Size,
            F.Type,
            F.Path,
            F.ShortName,
            F.ShortPath,
            F.DateCreated,
            F.DateLastAccessed,
            F.DateLastModified
        )
    } else if ( fso.FolderExists(path) ) {
        var F = fso.GetFolder(path);
        Stats = new this.Stats(
            F.Attributes,
            F.Size,
            F.Type,
            F.Path,
            F.ShortName,
            F.ShortPath,
            F.DateCreated,
            F.DateLastAccessed,
            F.DateLastModified
        )
    }
    return Stats;
};

fs.readFileSync = function(filename, options) {
    filename = filename.contains(':') ? filename : require('path').resolve(filename);

    var opt = {
        encoding: Response.Charset
    };

    if ( util.isString(options) ) {
        opt.encoding = options
    } else if ( util.isNullOrUndefined(options) ) {
        opt.encoding = 'binary'
    } else if ( util.isObject(options) ) {
        for (var i in options) {
            opt[i] = options[i]
        }
    }

    opt.encoding = opt.encoding.replace(/utf(\d+)/gi, 'utf-$1');

    try{
        var stream = new ActiveXObject('Adodb.Stream'),
            data;

        stream.Type = opt.encoding === 'binary' ? 1 : 2;
        stream.Mode = 3;
        stream.Open();
        if (opt.encoding === 'binary') {
            stream.Position = stream.Size;
            stream.LoadFromFile(filename);
            data = stream.Read;
        }else{
            stream.Charset = opt.encoding;
            stream.Position = stream.Size;
            stream.LoadFromFile(filename);
            data = stream.ReadText;
        }
        stream.Close();

        return data;
    }catch(e){
        console.error('读取文件出错: [' + filename + ']\n => ' + e.message);
    }
};

fs.writeFileSync = function(filename, data, options) {
    filename = filename.contains(':') ? filename : require('path').resolve(filename);

    var opt = {
        encoding: Response.Charset
    };

    if ( util.isString(options) ) {
        opt.encoding = options
    } else if ( util.isNullOrUndefined(options) ) {
        opt.encoding = 'utf8'
    } else if ( util.isObject(options) ) {
        for (var i in options) {
            opt[i] = options[i]
        }
    }

    opt.encoding = opt.encoding.replace(/utf(\d+)/gi, 'utf-$1');

    try{
        var isStr = util.isString(data);	// 判断传入的是String还是Buffer
        var dType = isStr ? 2 : 1;
        var stream = new ActiveXObject('Adodb.Stream');
        stream.Type = dType;
        stream.Mode = 3;
        stream.Open();
        if (isStr) {
            stream.Charset = opt.encoding;
            stream.WriteText(data);
        }else{
            stream.Write(data);
        }
        if (isStr && opt.encoding.toLowerCase() === 'utf-8') {
            // 去除utf-8的BOM
            stream.Position = 0;
            stream.Type = 1;
            stream.Position = 3;
            var bs = stream.Read();
            stream.Position = 0;
            stream.Write(bs);
            stream.SetEOS();
        }

        stream.SaveToFile(filename, 2);
        stream.Close();
    }catch(e){
        console.error('写入文件出错: [' + filename + ']\n => ' + e.message);
    }
};

fs.appendFileSync = function(filename, data, options) {
    filename = filename.contains(':') ? filename : require('path').resolve(filename);

    // 如果目标文件不存在，则直接写入文件，防止出错
    if ( !fso.FileExists(filename) ) this.writeFileSync(filename, data, options);

    var opt = {
        encoding: Response.Charset
    };

    if ( util.isString(options) ) {
        opt.encoding = options
    } else if ( util.isNullOrUndefined(options) ) {
        opt.encoding = 'utf8'
    } else if ( util.isObject(options) ) {
        for (var i in options) {
            opt[i] = options[i]
        }
    }

    opt.encoding = opt.encoding.replace(/utf(\d+)/gi, 'utf-$1');

    try{
        if ( util.isString(data) ) {
            // 将String转为Buffer
            var object = new ActiveXObject('Adodb.Stream');
            object.Type = 2;
            object.Mode = 3;
            object.Open();
            object.Charset = opt.encoding;
            object.WriteText(data);
            object.Position = 0;
            object.Type = 1;
            if (opt.encoding.toLowerCase() === 'utf-8') {
                object.Position = 3;	// 去除utf-8的BOM
            }
            data = object.Read();
            object.Close();
        }

        var stream = new ActiveXObject('Adodb.Stream');
        stream.Type = 1;
        stream.Mode = 3;
        stream.Open();
        stream.LoadFromFile(filename);
        stream.Position = stream.Size;
        stream.Write(data);
        stream.SaveToFile(filename, 2);
        stream.Close();
    }catch(e){
        console.error('追加文件出错: [' + filename + ']\n => ' + e.message);
    }
};

fs.fso = fso;

module.exports = fs;