/**
 * Usage: 文件夹操作方法，用于IDE的智能提示
 * Author: Spikef < Spikef@Foxmail.com >
 * Copyright: Envirs Team < http://envirs.com >
 */

var obj = new ActiveXObject('Scripting.FileSystemObject');

var folder = function(fullPath) {
    var fo = obj.GetFolder(fullPath);

    var Files = [];
    var fc = new Enumerator(fo.Files);
    for (; !fc.atEnd(); fc.moveNext())
    {
        Files.push(fc.item().Name);
    }

    var SubFds = [];
    var dc = new Enumerator(fo.SubFolders);
    for (; !dc.atEnd(); dc.moveNext())
    {
        SubFds.push(dc.item().Name);
    }

    return {
        // Collections
        Files: Files,               // 返回指定文件夹中所有文件的集合(数组)。
        SubFolders: SubFds,         // 返回指定文件夹中所有子文件夹的集合(数组)。

        // Properties
        Attributes: fo.Attributes,                      // 设置或返回指定文件的属性。
        DateCreated: fo.DateCreated,                    // 返回指定文件创建的日期和时间。
        DateLastAccessed: fo.DateLastAccessed,	        // 返回指定文件最后被访问的日期和时间。
        DateLastModified: fo.DateLastModified,	        // 返回指定文件最后被修改的日期和时间。
        Drive: fo.Drive,         	                    // 返回指定文件或文件夹所在的驱动器的驱动器字母。
        IsRootFolder: fo.IsRootFolder,                  // 假如文件夹是根文件夹，则返回 ture，否则返回 false。
        Name: fo.Name,                                  // 设置或返回指定文件的名称。
        ParentFolder: fo.ParentFolder,	                // 返回指定文件或文件夹的父文件夹对象。
        Path: fo.Path,	                                // 返回指定文件的路径。
        ShortName: fo.ShortName,	                    // 返回指定文件的短名称（8.3 命名约定）。
        ShortPath: fo.ShortPath,	                    // 返回指定文件的短路径（8.3 命名约定）。
        Size: fo.Size,	                                // 返回指定文件的尺寸（字节）。
        Type: fo.Type,	                                // 返回指定文件的类型。

        // Methods
        SetAttr: function(value) {
            fo.Attributes = value;
        },
        Rename: function(value) {
            fo.Name = value;
        },

        /**
         * 把指定文件从一个位置拷贝到另一个位置。
         * @param destination: 必需的。复制文件或文件夹的目的地。不允许使用通配符。
         * @param overwrite: 可选的。指示是否可覆盖已有的文件或文件夹的布尔值。True 表示文件/文件夹可被覆盖，false 表示文件/文件夹不可以被覆盖。默认是 true。
         */
        Copy: function(destination, overwrite) {
            overwrite = overwrite === false ? false : true;

            fo.Copy(destination, overwrite);
        },

        /**
         * 把指定文件从一个位置移动到另一个位置。
         * @param destination: 必需的。移动文件或文件夹的目的地。
         */
        Move: function(destination) {
            fo.Move(destination);
        },

        /**
         * 删除指定文件。
         * @param force: 可选的。指示是否可删除只读文件或文件夹的布尔值。True 指示只读文件/文件夹可被删除，false 指示文件/文件夹不可被删除。默认是 false。
         * @throws 若指定文件或文件夹不存在，错误发生。
         */
        Delete: function(force) {
            force = force === true ? true : false;

            fo.Delete(force);
        }
    }
};

module.exports = folder;