/**
 * Usage: FSO操作方法，用于IDE的智能提示
 * Author: Spikef < Spikef@Foxmail.com >
 * Copyright: Envirs Team < http://envirs.com >
 */

var fso = {};
var obj = new ActiveXObject('Scripting.FileSystemObject');

/**
 * 返回本地计算机上所有驱动器对象的集合。
 */
fso.Drives = obj.Drives;

/**
 * 将一个名称追加到已有的路径后。
 * @param path: 必需的。要追加名称的路径。
 * @param name: 必需的。追加到路径的名称。
 * @returns {String} 新的路径。
 */
fso.BuildPath = function(path, name) {
    return obj.BuildPath(path, name)
};

/**
 * 从一个位置向另一个位置拷贝一个或多个文件。
 * @param source: 必需的。要拷贝的文件（可使用通配符）。
 * @param destination: 必需的。拷贝文件的目的地（不能使用通配符）。
 * @param overwrite: 可选的。规定是否可覆盖已有的文件。True 允许覆盖已有文件，False 可防止已有文件被覆盖。默认为 True 。
 */
fso.CopyFile = function(source, destination, overwrite) {
    overwrite = overwrite === false ? false : true;

    obj.CopyFile(source, destination, overwrite);
};

/**
 * 从一个位置向另一个位置拷贝一个或多个文件夹。
 * @param source: 必需的。要拷贝的文件夹（可使用通配符）。
 * @param destination: 必需的。拷贝文件夹的目的地（不能使用通配符）。
 * @param overwrite: 可选的。规定是否可覆盖已有的文件夹。True 允许覆盖已有文件夹，False 可防止已有文件夹被覆盖。默认为 True 。
 */
fso.CopyFolder = function(source, destination, overwrite) {
    overwrite = overwrite === false ? false : true;

    obj.CopyFolder(source, destination, overwrite);
};

/**
 * 创建新文件夹。
 * @param name: 必需的。需创建的文件夹名称。
 */
fso.CreateFolder = function(name) {
    obj.CreateFolder(name);
};

/**
 * 创建文本文件，并返回一个 TextStream 对象。
 * @param filename: 必需的。需创建文件的名称。
 * @param overwrite: 可选的。指示能否覆盖已有文件的布尔值。True 指示可覆盖文件，False 指示不能覆盖文件。默认是 True 。
 * @param unicode: 可选的。指示文件是作为 Unicode 还是 ASCII 文件来创建的布尔值。True 指示文件作为 Unicode 文件创建，而 False 指示文件被作为 ASCII 文件创建。默认是 False。
 * @returns {TextStream}
 */
fso.CreateTextFile = function(filename, overwrite, unicode) {
    overwrite = overwrite === false ? false : true;
    unicode = unicode === true ? true : false;

    return obj.CreateTextFile(filename, overwrite, unicode);
};

/**
 * 删除一个或者多个指定的文件。
 * @param filename: 必需的。需删除文件的名称（可使用通配符）。
 * @param force: 可选的。指示是否可删除只读文件的布尔值。True 指示可删除只读文件，而 False 指示不可删除只读文件。默认是 False。
 * @throws 假如您试图删除不存在的文件，会引发错误。
 */
fso.DeleteFile = function(filename, force) {
    force = force === true ? true : false;

    obj.DeleteFile(filename, force);
};

/**
 * 删除一个或者多个指定的文件夹。
 * @param foldername: 必需的。需删除文件夹的名称（可使用通配符）。
 * @param force: 可选的。指示是否可删除只读文件夹的布尔值。True 指示删除只读文件夹，而 False 指示不删除只读文件夹。默认的 False。
 * @throws 假如您试图删除不存在的文件夹，会引发错误。
 */
fso.DeleteFolder = function(foldername, force) {
    force = force === true ? true : false;

    obj.DeleteFolder(foldername, force);
};

/**
 * 检查指定的驱动器是否存在。
 * @param drive: 必需的。驱动器字母或者完整的路径规定。
 * @returns {Boolean}
 */
fso.DriveExists = function(drive) {
    return obj.DriveExists(drive);
};

/**
 * 检查指定的文件是否存在。
 * @param filename: 必需的。需检测是否存在的文件的名称。
 * @returns {Boolean}
 */
fso.FileExists = function(filename) {
    return obj.FileExists(filename);
};

/**
 * 检查某个文件夹是否存在。
 * @param foldername: 必需的。需检测是否存在的文件夹的名称。
 * @returns {Boolean}
 */
fso.FolderExists = function(foldername) {
    return obj.FolderExists(foldername);
};

/**
 * 针对指定的路径返回从驱动器根部起始的完整路径。
 * @param path: 必需的。需修改为完整路径的路径。
 * @returns {String}
 */
fso.GetAbsolutePathName = function(path) {
    return obj.GetAbsolutePathName(path);
};

/**
 * 返回指定文件或者文件夹的基名称。
 * @param path: 必需的。其基准名称需被返回的文件或文件夹的路径。
 * @returns {String}
 */
fso.GetBaseName = function(path) {
    return obj.GetBaseName(path);
};

/**
 * 返回指定路径中所对应的驱动器的 Drive 对象。
 * @param drivespec: 必需的。可以是驱动器字母 (c)，或者带有冒号的驱动器字母，或者带有冒号和路径分隔符的驱动器字母，或者任何网络共享规范 (\\computer2\share1)。
 * @returns {Drive}
 */
fso.GetDrive = function(drivespec) {
    return require('./drive.js')(drivespec);
};

/**
 * 返回指定的路径的驱动器名称。
 * @param path: 必需的。可返回驱动器名称的路径。
 * @returns {String}
 */
fso.GetDriveName = function(path) {
    return obj.GetDriveName(path);
};

/**
 * 返回在指定的路径中最后一个成分的文件扩展名。
 * @param path: 必需的。需返回文件扩展名的文件的路径。
 * @returns {String}
 */
fso.GetExtensionName = function(path) {
    return obj.GetExtensionName(path);
};

/**
 * 返回一个针对指定路径的 File 对象。
 * @param path: 必需的。指向具体文件的路径。
 * @returns {File}
 */
fso.GetFile = function(path) {
    return require('./file.js')(path);
};

/**
 * 返回在指定的路径中最后一个成分的文件名。
 * @param path: 必需的。指向具体文件或文件夹的路径。
 * @returns {String}
 */
fso.GetFileName = function(path) {
    return obj.GetFileName(path);
};

/**
 * 返回一个针对指定路径的 Folder 对象。
 * @param path: 必需的。指向具体文件或文件夹的路径。
 * @returns {String}
 */
fso.GetFolder = function(path) {
    return require('./folder.js')(path);
};

/**
 * 返回在指定的路径中最后一个成分的父文件夹完整路径。
 * @param path: 必需的。需返回其父文件夹的文件或文件夹的路径。
 * @returns {String}
 */
fso.GetParentFolderName = function(path) {
    return obj.GetParentFolderName(path);
};

/**
 * 返回某些 Windows 的特殊文件夹的路径。
 * @param foldername: 必需的。要返回的文件夹。
 *   0 = WindowsFolder - 包含由 Windows 操作系统安装的文件。
 *   1 = SystemFolder - 包含库、字体和设备驱动。
 *   2 = TemporaryFolder - 用于存储临时文件。
 * @returns {String}
 */
fso.GetSpecialFolder = function(foldername) {
    return obj.GetSpecialFolder(foldername);
};

/**
 * 返回一个随机生成的文件或文件夹。
 * @returns {String}
 */
fso.GetTempName = function() {
    return obj.GetTempName();
};

/**
 * 从一个位置向另一个位置移动一个或多个文件。
 * @param source: 必需的。指向要移动的文件的路径。可在最后的成分中包含通配符。
 * @param destination: 必需的。移动文件的目的地。不能包含通配符。
 */
fso.MoveFile = function(source, destination) {
    obj.MoveFile(source, destination);
};

/**
 * 从一个位置向另一个位置移动一个或多个文件夹。
 * @param source: 必需的。指向需被移动的文件夹的路径。可在最后的成分中包含通配符。
 * @param destination: 必需的。移动文件夹的目的地。不能包含通配符。
 */
fso.MoveFolder = function(source, destination) {
    obj.MoveFolder(source, destination);
};

/**
 * 打开文件，并返回一个用于访问此文件的 TextStream 对象。
 * @param fname: 必需的。要打开的文件的名称。
 * @param mode: 可选的。如何打开文件。1=ForReading 2=ForWriting 8=ForAppending
 * @param create: 可选的。设置如果文件名不存在，是否创建新文件。True 指示可创建新文件，而 False 指示新文件不会被创建。False 是默认的。
 * @param format: 可选的。文件的格式。0=ASCII -1=Unicode -2=ANSI
 * @returns {TextStream}
 */
fso.OpenTextFile = function(fname, mode, create, format) {
    mode = mode || 1;
    create = create === false ? false : true;
    format = format || 0;

    return obj.OpenTextFile(fname, mode, create, format);
};

module.exports = fso;