# fs文件操作模块 #

提供基本的文件操作功能。所有操作均为同步操作，所以方法名中都包含Sync后缀。

## Methods ##

### existsSync(path) ###

判断指定路径是否存在。

> path: 可以是盘符、文件夹或者文件名，从盘符开始算起的绝对路径。

Example:

```javascript
var fs = require('fs');
console.log(fs.existsSync('C:\\windows'));
// prints: true
```

### mkdirSync(path) ###

创建文件夹，创建前必须确保父目录存在。创建成功将返回true。

> path: 必须是绝对路径。

### renameSync(oldPath, newPath) ###

重命名文件或者文件夹。

> oldPath: 必须是绝对路径。
> newPath: 可以是绝对路径或者相对于newPath的相对路径。

### readdirSync(path) ###

列出目录下所有文件和文件夹名称（<code>不是绝对路径</code>）。返回一个数组。

> path: 可以是绝对路径或者相对于当前文件的相对路径。

### readFileSync(filename, options) ###

读取一个文件内容。

> filename: 可以是绝对路径或者相对于当前文件的相对路径。
> options: Object | String，如果省略，则以二进制方式读取。

Example:

```javascript
var fs = require('fs');
var txt = fs.readFileSync('a.txt', 'utf8');
var img = fs.readFileSync('a.png', {encoding: 'binary'};
```

### writeFileSync(filename, data, options) ###

写入内容到文件。

### appendFileSync(filename, data, options) ###

追加内容到文件。

### unlinkSync(path) ###

删除一个文件或者文件夹。

> path: 可以是绝对路径或者相对于当前文件的相对路径。

### fs.statSync(path) ###

获取一个文件或者文件夹的属性。返回的是一个fs.Stats对象。

> path: 必须是绝对路径。

## Objects ##

### fs.Stats ###

fs.stat()方法返回的对象。

+ stats.isFile()
+ stats.isDirectory()

使用util.inspect(stats)将返回类似下面的字符串。

```javascript
{
  mode: 0,      // 返回指定文件的属性。
  size: 527,    // 返回指定文件的尺寸（字节）。
  type: 'folder',           // 返回指定文件的类型。
  path:  'C:\test\a.txt',   // 返回指定文件的路径。
  sname: 'C:\test\a.txt',   // 返回指定文件的短名称（8.3 命名约定）。
  spath: 'C:\test\a.txt',   // 返回指定文件的短路径（8.3 命名约定）。
  atime: Mon, 10 Oct 2011 23:24:11 GMT, // 返回指定文件最后被访问的日期和时间。
  mtime: Mon, 10 Oct 2011 23:24:11 GMT, // 返回指定文件最后被修改的日期和时间。
  ctime: Mon, 10 Oct 2011 23:24:11 GMT  // 返回指定文件创建的日期和时间。
}
```