nodeAsp-http
======================

# Install #

> $ npm install --save nodeasp-http

# Usage #

nodeAsp的HTTP请求模块，主要是用于创建服务和发送请求。

``` javascript
var http = require('nodeasp-http');
```

# API #

### Create HTTP Server ###

创建一个HTTP应用服务

``` javascript
var _http = new http();
_http.createServer(function(request, response){
    // request: 输入对象
    // response: 输出对象
});
```

### request:property ###

  * `protocol` 协议
  * `port` 端口
  * `query` 参数对象
  * `pathname` 请求地址
  * `path` 请求路径
  * `host` 请求主机域名
  * `hostname` 主机名
  * `search` search字符串
  * `href` 链接字符串
  * `method` 请求方法

### response:property ###

  * `statusCode` 状态码
  * `statusMessage` 状态信息
  * `finished` Boolean value that indicates whether the response has completed. Starts as false. After response.end() executes, the value will be true.

### response:mothod ###

  * `charset(encoding)` 将字符集的名称追加到 Response 对象中的 content-type 报头。
  * `contentType(str)` 设置 Response 对象的 HTTP 内容类型。
  * `expires(time)` 设置页面在失效前的浏览器缓存时间（分钟）。
  * `expiresAbsolute(time)` 设置浏览器上页面缓存失效的日期和时间。
  * `pics(value)` 向 response 报头的 PICS 标志追加值。
  * `setHeader(key, value)` 设置头部信息
  * `getHeader(key)` 获取头部信息
  * `removeHeader(key)` 删除头部某信息
  * `write(str)` 向页面输出信息
  * `end(value)` 指示页面完成了操作并输出内容
  * `appendToLog(text)` 向服务器记录项目（server log entry）的末端添加字符串。
  * `binaryWrite(binary)` 在没有任何字符转换的情况下直接向输出写数据。
  * `clear()` 清除已缓存的 HTML 输出。
  * `flush()` 立即发送已缓存的 HTML 输出。
  * `redirect(url)` 把用户重定向到另一个 URL。
  * `json(value)` 输出JSON数据串并结束
  * `writeHead(stauscode, headers)` 写入头部状态码，写入头部信息集合。

### Create HTTP Request ###

创建一个后端发送请求的对象

``` javascript
var req = new http.request(options)
```

### Request:options ###

  * `host` 链接地址
  * `data` 参数
  * `method` 方法
  * `async` 是否异步

``` javascript
var http = require('nodeasp-http');
var req = new http.request({
    host: 'http://api.webkits.cn',
    data: {
        a:1,
        b:2
    },
    method: 'GET'
});
req.on('success', function(xhr){
    var binary = xhr.responseBody;
    Response.BinaryWrite(binary);
});
req.send();
 ```

 ### Request:event ###

 请求事件

 #### Request:event:connect ####

 连接开始事件

 #### Request:event:change ####

 连接预处理事件

 #### Request:event:change ####

 连接接受事件

 ### Request:event:success ####

 连接成功事件

 ### Request:event:failed ####

 连接失败事件

 ### Request:event:close ####

 连接关闭事件

 ### Request:event:invoke ###

 我们对事件如何调用

 ``` javascript
 req.on('success', RequestSuccessHandler);
 req.on('failed', RequestFailureHandler);
 ```

 ### Request.fetch ###

 请求简化模式， 参数如下

   * `url` 链接地址
   * `data` 参数（json）
   * `method` 方法
   * `charset` 编码

 ``` javascript
 var content = http.fetch('http://api.webkits.cn, {}, 'POST', 'utf-8');
 console.log(content);
 ```

 ### Request.get & Request.post ###

 `GET`与`POST`请求的简化版。继承自`Request.fetch`

 ``` javascript
 var content = http.get('http://api.webkits.cn');
 console.log(content);
 ```

 # License #

 (The MIT License)

 Copyright (c) 2011 Tom Gallacher

 Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the 'Software'), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.