<%
'**
'站点管理
'**
class AP_ADMIN_CLASS

	private aArr,oRs,iI,sString,bResult
	private bAuxSQLValid,sMemberTable,sMemberDetailTable,sMemberDepositTable,sMemberGroupTable,sMemberGroupSitesTable,sUCenterMemberTable
	
	private sub class_initialize()
		sMemberTable           = DB_PRE &"member"
		sMemberDetailTable     = DB_PRE &"member_detail"
		sMemberDepositTable    = DB_PRE &"member_deposit"
		sMemberGroupTable      = DB_PRE &"member_group"
		sMemberGroupSitesTable = DB_PRE &"member_group_sites"
		sUCenterMemberTable    = DB_PRE &"ucenter_member"
	end sub
	
	public sub init()
		if CTL="admin" then
			select case ACT
			case "list"
				call list()
			case "add"
				call add(SAVE)
			case "edit"
				if SUBACT = "status_edit" then
					if SAVE then
						V("uid") = ID
						if V("uid")>1 then
							bAuxSQLValid = false
							call Admin.statusEdit(sMemberTable,"uid",auxSQLValid,array("成功更改管理员状态","无法更新数据库，管理员状态更改失败！"))
						end if
					end if
				else
					call edit(SAVE)
				end if
			case "delete"
				call delete()
			end select
		end if
	end sub
	
	private sub class_terminate()
	end sub
	
	private function getInfo()
		V("uid") = ID
		set oRs = OW.DB.getRecordBySQL("SELECT * FROM ["& sMemberTable &"] WHERE site_id="& V("site_id") &"")
		if not(oRs.eof) then
			V("site_sname") = oRs("site_sname")
			
		end if
		OW.DB.closeRs oRs
	end function
	
	private function add(byval isSave)
		if isSave then
			call doingSave()
		end if
	end function
	
	private function edit(byval isSave)
		if isSave then
			call doingSave()
		else
			call getInfo()
			call doing()
		end if
	end function
	
	private function delete()
		dim check,s,id,result,isSkip
		check = true
		'**接收数据
		V("ids") = OW.regReplace(OW.getForm("post","ids"),"[^0-9,]","")
		'**数据处理
		aArr = split(V("ids"),",")
		'**数据合法性校验
		if V("ids")="" then check = false : Admin.errorSetting("用户id值传递不正确")
		'**从数据库删除记录
		if check then
			'**delete
			for iI=0 to ubound(aArr)
				V("uid") = OW.clng(aArr(iI))
				if V("uid")>1 then
					V("username") = OW.DB.getFieldValueBySQL("SELECT username FROM "& sMemberTable &" WHERE uid="& V("uid") &"")
					isSkip = false
					if not(isSkip) then
						bResult =OW.DB.execute("UPDATE ["& sMemberTable &"] SET [utype]=0,[admin_group_id]=0 WHERE uid="& V("uid") &"")
						if bResult then
							s = s &"成功解除管理员职务(uid:"& V("uid") &", username:"& V("username") &");<br>"
						else
							s = s &"解除管理员职务失败(uid:"& V("uid") &", username:"& V("username") &");<br>"
						end if
					end if
				end if
			next
			'**输出操作结果信息
			Admin.actionFinishSuccess = bResult
			Admin.actionFinishSuccessText = array(s,"")
			Admin.actionFinishFailText = array(s,"")
			Admin.actionFinishRun()
		end if
	end function
	
	private function doingSave()
		dim check,result,s : check = true
		'**接收数据
		V("uids")           = OW.getForm("post","uids")
		V("admin_group_id") = OW.int(OW.getForm("post","admin_group_id"))
		'**数据合法性判断
		if OW.reps(V("uids"),",","") = "" then
			check = false : Admin.errorSetting("请选择要设置为管理员的会员！")
		end if
		if not OW.DB.isRecordExistsBySQL("SELECT * FROM "& sMemberGroupTable &" WHERE group_type=1 AND group_id="& V("admin_group_id") &"") then
			check = false : Admin.errorSetting("请选择正确的管理员组！")
		end if
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			if ACT="add" then
				bResult = false 
				aArr    = split(V("uids"),",")
				for iI=0 to ubound(aArr)
					V("uid") = OW.clng(aArr(iI))
					if V("uid")>0 then
						V("username") = OW.DB.getFieldValueBySQL("SELECT username FROM "& sMemberTable &" WHERE uid="& V("uid") &"")
						result        = OW.DB.execute("UPDATE ["& sMemberTable &"] SET [utype]=1,[admin_group_id]="& V("admin_group_id") &" WHERE uid="& V("uid") &"")
						if result then
							bResult = true
							s = s &"成功赋予管理员职务(uid:"& V("uid") &", username:"& V("username") &");<br>"
						else
							s = s &"赋予管理员职务失败(uid:"& V("uid") &", username:"& V("username") &");<br>"
						end if
					end if
				next
				'**
				Admin.actionFinishSuccess     = bResult
				Admin.actionFinishSuccessText = array(s,"")
				Admin.actionFinishFailText    = array(s,"")
				Admin.actionFinishRun()
			end if
		end if
	end function
	
	private function list()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <div class="top-area">
            <table cellspacing="0" cellpadding="0" border="0">
              <tbody>
              <tr>
              <td class="do-cell">
                  <div class="do-cell-name">添加操作区</div>
                  <div class="do-cell-btn"><a class="btn btn-primary" id="add_new" href="javascript:;">添加管理员</a></div>
              </td>
              <td class="do-cell">
                  <div class="do-cell-name">删除操作区</div>
                  <div class="do-cell-btn"><button class="btn" id="delete_selected">解除管理员职务</button></div>
              </td>
              </tr>
              </tbody>
            </table>
        </div>
        <div class="list-area" id="data_list_area">
            <table border="0" cellpadding="0" cellspacing="0" width="100%" class="listTable">
              <thead>
                  <tr class="thead">
                      <th><input type="checkbox" name="select_all" id="select_all"></th>
                      <th>uid</th>
                      <th>用户名</th>
                      <th>email</th>
                      <th>头像</th>
                      <th>昵称</th>
                      <th>预存款</th>
                      <th>管理员组</th>
                      <th>最后登录时间</th>
                      <th>最后登录ip</th>
                      <th>所属站点</th>
                      <th>用户状态</th>
                      <th>操作</th>
                  </tr>
              </thead>
              <tbody>
              <%=listing()%>
              </tbody>
            </table>
        </div>
    </div>
    <script type="text/javascript">
    $(window).ready(function(){
		Admin.dataListTableInit({
			ctl:"<%=CTL%>",
			act_edit:"edit",
			field_name:"username",
			status_validValue:"正常",
			status_validTitle:"点击可设置为冻结状态",
			status_invalidValue:'冻结',
			status_invalidTitle:'点击可设置为正常状态',
			delete_confirm:"您确定要解除所选择用户的管理员职务吗？",
			delete_confirm2:"您确定要解除{tpl:name}的管理员职务吗？",
			delete_doing:"正在删除管理员...",
			delete_success:"删除成功",
			delete_failed:"删除操作失败",
			delete_tip:"请先选择您要解除管理员职务的管理员"
		});
		//**
		$("#data_list_area td[field='uid'][value='1']").parent().find("input").attr("disabled",true).hide();
		$("#data_list_area td[field='uid'][value='1']").parent().find("a[name='delete']").remove();
		$("#data_list_area td[field='uid'][value='1']").parent().find("td[field='status']").html("");
		//**头像
		$("#data_list_area td[field='avatar']").each(function(){
			var url = $(this).attr("value");
			if(url!=""){
				$(this).html('<img src="'+url+'" height="32" />');
			};
		});
		//**添加管理员
		var addAdminTpl = '<div class="inbox" style="width:520px;">'+
							'<table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">'+
							  '<tbody>'+
								'<tr><td class="titletd"><i class="important">*</i>会员</td>'+
									'<td class="infotd">'+
									'<input type="hidden" class="text" readonly name="uid" value="" style="width:80px;"/><input type="text" class="text text-short disabled" readonly name="username" value=""/><button class="btn ml5" name="select_member">选择</button>'+
									'<span class="t-normal ml5" name="t_uid"></span>'+
									'</td>'+
								'</tr>'+
								'<tr><td class="titletd auto"><i class="important">*</i>管理员组</td>'+
									'<td class="infotd">'+
									'<%=adminGroupOptions("admin_group","选择 ... ",V("admin_id"))%>'+
									'<span class="t-normal ml5" name="t_admin_group"></span>'+
									'</td>'+
								'</tr>'+
							  '</tbody>'+
							'</table>'+
						'</div>';
		$("#add_new").click(function(){
			var $dialog = new OWDialog({
				id:'add_admin',
				title:'添加管理员',
				content:addAdminTpl,
				padding:"10px 10px 5px 10px",
				ok:function(){
					var check   = true,
					$addWindow  = $("#add_admin"),
					$uid        = $addWindow.find("input[name='uid']"),
					$username   = $addWindow.find("input[name='username']"),
					$adminGroup = $addWindow.find("select[name='admin_group']"),
					$uidTip        = $addWindow.find("span[name='t_uid']"),
					$adminGroupTip = $addWindow.find("span[name='t_admin_group']"),
					uid          = $.trim($uid.val()),
					username     = $.trim($username.val()),
					adminGroupId = parseInt($adminGroup.val());
					if(uid==""){
						check = false;
						$uidTip.removeClass("t-ok").addClass("t-err").html("请先选择会员！");
						$("button[name='select_member']").focus();
					}else{
						$uidTip.removeClass("t-err").addClass("t-ok").html("正确");
					};
					if(check){
						if(!adminGroupId>0){
							check = false;
							$adminGroupTip.removeClass("t-ok").addClass("t-err").html("请先选择管理员组！");
							$adminGroup.focus();
						}else{
							$adminGroupTip.removeClass("t-err").addClass("t-ok").html("正确");
						};
					};
					if(check){
						$dialog.content('<div class="loading">正在向服务器提交数据...</div>').button({id:'ok',remove:true},{id:'cancel',disabled:true}).padding("20px 40px");
						Admin.ajax({
							me:$addWindow,
							url:"index.asp?ctl=<%=CTL%>&act=add&save=true",
							data:"uids="+escape(uid)+"&admin_group_id="+escape(adminGroupId),
							success:function(){
								$dialog.success('设置管理员成功').button({id:'cancel',value:'关闭',disabled:false,focus:true}).timeout(4);
								OW.refresh();
							},
							failed:function(msg){
								$dialog.error('亲，很抱歉，设置管理员失败！',msg).button({id:'cancel',remove:true}).timeout(2);
							}
						});
					};
					return false;
				},
				cancel:true,
				close:false,
				follow:$(this),
				initialize:function(){
					var $uid      = $("input[name='uid']"),
					$selectMember = $("button[name='select_member']");
					$selectMember.focus().click(function(){getMemberList($selectMember);});
				}
			});
		});
		function getMemberList($follow){
			var dialog = new OWDialog({
				id:'d_member_list',
				title:'选择会员(选择要赋予管理员职务的会员)',
				iframe:"index.asp?ctl=member&act=list&utype=0",
				padding:"0px",
				height:OW.dialogBigHeight(),
				width:OW.dialogBigWidth(),
				ok:function(){
					var $iframe       = this.dom.iframe;
					var $dataListArea = $($iframe.contentWindow.document.getElementById("data_list_area"));
					var $checkboxs    = $dataListArea.find("input[name='data-checkbox']:checked");
					var $uid          = $("input[name='uid']");
					var $username     = $("input[name='username']");
					var uid           = "";
					var temp,username      = "";
					$checkboxs.each(function(){
						temp = $(this).parent().parent().find("td[field='username']").attr("value");
						username = username=="" ? temp : username +","+ temp;
						uid      = uid==""      ? $(this).val() : uid +","+ $(this).val();
					});
					$uid.val(uid);
					$username.val(username);
				},
				cancel:true
			});
		};
	});
    </script>
	<%
		call Admin.echoFooter()
	end function
	
	private function listing()
		Admin.list("fields") = "uid,username,email,avatar,nickname,(select deposit from ["& sMemberDepositTable &"] where uid=a.uid) as deposit,(select top 1 group_name from ["& sMemberGroupTable &"] b where b.group_id=a.admin_group_id) as group_name,last_login_time,last_login_ip,(select top 1 site_sname from ["& DB_PRE &"sites] d where d.site_id=a.site_id) as site_sname,status"
		Admin.list("sql") = "SELECT "& Admin.list("fields") &" FROM ["& sMemberTable &"] a WHERE utype=1 ORDER BY uid ASC"
		Admin.list("pagesize") = Admin.getPageSise(ACTION_ID)
		Admin.list("checkboxExists") = true
		Admin.list("opeations") = "<a class=""btn btn-small"" name=""delete"" href=""javascript:;"">解除管理员职务</a>"
		Admin.list("auxURLPara") = ""
		Admin.list("returnType") = "html"
		listing = Admin.getDataList()
	end function
	
	public function adminGroupOptions(byval name,byval default,byval groupId)
		dim s,rs,ds
		set rs = OW.DB.getRecordBySQL("SELECT group_id,group_type,group_name FROM ["& DB_PRE &"member_group] WHERE group_type=1 AND status=0 AND group_rank<"& ADMIN_GROUP_RANK &" ORDER BY group_rank DESC")
		do while not rs.eof
			if rs("group_id") = groupId then
				s = s &"<option selected=""selected"" value="""& rs("group_id") &""">"& rs("group_name") &"</option>"
			else
				s = s &"<option value="""& rs("group_id") &""">"& rs("group_name") &"</option>"
			end if
			rs.movenext
		loop
		OW.DB.closeRs rs
		if not isNull(default) then ds = "<option value=""0"">"& default &"</option>"
		if name = "" then
			name = "member_group"
		end if
		adminGroupOptions = "<select name="""& name &""">"& ds & s &"</select>"
	end function

end class
%>