<%
'**
'站点管理
'**
dim AP_ADMIN_GROUP
class AP_ADMIN_GROUP_CLASS

	private aArr,oRs,sCols,sSQL,iI,sString,bResult
	private bAuxSQLValid,sGroupType
	
	private sub class_initialize()
		bAuxSQLValid = false
		sGroupType   = 1
	end sub
	
	public sub init()
		if CTL="admin_group" then
			select case ACT
			case "list"
				call list()
			case "add"
				call add(SAVE)
			case "edit"
				if SUBACT = "status_edit" then
					if SAVE then
						bAuxSQLValid = false
						call Admin.statusEdit(DB_PRE &"member_group","group_id",bAuxSQLValid,array("成功更改管理员组状态","无法更新数据库，管理员组状态更改失败！"))
					end if
				else
					call edit(SAVE)
				end if
			case "edit_admin_action"
				call editAdminAction(SAVE)
			case "edit_category_auth"
				call editCategoryAuth(SAVE)
			case "edit_plugin_auth"
				call editPluginAuth(SAVE)
			case "delete"
				call delete()
			end select
		end if
	end sub
	
	private sub class_terminate()
	end sub
	
	private function add(byval isSave)
		if isSave then
			call doingSave()
		else
			call doing()
		end if
	end function
	
	private function edit(byval isSave)
		if isSave then
			call doingSave()
		else
			call getInfo()
			call doing()
		end if
	end function
	
	private function editCategoryAuth(byval isSave)
		dim check
		check = true
		V("group_id") = OW.int(OW.getForm("get","group_id"))
		V("site_id")  = OW.int(OW.getForm("get","site_id"))
		if V("group_id")<1 then check = false : call Admin.errorSetting("管理员组id传递不正确")
		if V("group_id")=1 then check = false : call Admin.errorSetting("不能修改创始人组的栏目管理权限")
		if V("site_id")<1 then check = false : call Admin.errorSetting("站点id传递不正确")
		if check then
			if isSave then
				call editCategoryAuthSave()
			else
				call editCategoryAuthHtml()
			end if
		end if
	end function
	
	private function editCategoryAuthHtml()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
		dim i,rs,rs2,pms,s,ctl_act,havsPms,isFounder
		if V("group_id")=1 then
			isFounder = true
		else
			isFounder = false
		end if
		dim allNodes,cateNodes,shopNodes
		cateNodes = categoryNodes(0,0)
		shopNodes = categoryNodes(1,0)
		if cateNodes<>"" then allNodes = cateNodes
		if shopNodes<>"" then
			if allNodes="" then
				allNodes = shopNodes
			else
				allNodes = allNodes &","& shopNodes
			end if
		end if
	%>
    <script type="text/javascript" src="js/ow.tree.js"></script>
    <div class="mbody">
        <div class="permissions" id="permissions">
            <% if SITE_ID=1 then %>
            <div class="heading">
                <table border="0" cellpadding="0" cellspacing="0"><tr>
                <td style="padding-left:10px;">
                <%=Admin.sitesOptions(V("site_id"),"选择站点 ... ")%>
                <input type="hidden" id="group_id" value="<%=V("group_id")%>" />
                </td>
                <td style="padding-left:6px;">选择要设置权限的站点</td>
                <td style=" color:#aaa; padding-left:8px;">切换到其他站点前请务必先保存当前的设置</td>
                </tr>
                </table>
            </div>
            <% end if %>
            <div class="category-pms">
                <div class="category-pms-list">
                    <table border="0" cellpadding="0" cellspacing="0" class="thead"><tr>
                    <th class="th-01">
                    <label><input type="checkbox" name="select_all" id="select_all" <%=OW.iif(isFounder,"disabled=""disabled""","")%> value="1" /><b>全选</b></label>
                    <span class="ml10">栏目内容</span>
                    </th>
                    <th class="list"><label><input type="checkbox" id="list_all" />列表</label></th>
                    <th class="add"><label><input type="checkbox" id="add_all" />添加</label></th>
                    <th class="edit"><label><input type="checkbox" id="edit_all" />编辑(推荐/状态/排序)</label></th>
                    <th class="delete"><label><input type="checkbox" id="delete_all" />删除</label></th>
                    </tr></table>
                    <ul id="otree" class="ctree"></ul>
                </div>
            </div>     
        </div>
    </div>
    <script type="text/javascript">
    $(window).ready(function(){
		var oNodes  = [<%=allNodes%>];
		var oTree   = OWTree({
			treeId:"otree",
			root:$("#otree"),
			data:oNodes,
			checkbox:true,
			icon:true
		});
		oTree.parseRootTop();
		
		var i,j,$li,$ul
		var id,act,acts,arr
		var json = oNodes;
		var $treeRoot = oTree.dom.root;
		var treeId    = oTree.config.treeId;
		var defAct    = new Array("list","add","edit","delete");
		var defName   = new Array("列表","添加","编辑(推荐/状态/排序)","删除");
		for(i=0;i<json.length;i++){
			id        = json[i].id;
			modelType = json[i].model_type;
			acts      = json[i].acts || "";
			arr       = acts.split(",");
			$li       = $("li#"+treeId+"_"+id);
			$span     = $(document.createElement("span")).addClass("node-aux");
			$li.find("a:first").after($span);
			for(j=0;j<defAct.length;j++){
				act       = defAct[j];
				$checkbox = $(document.createElement("input")).attr({type:"checkbox",name:"cate_act",act:defAct[j],checked:true}).val(id+":"+defAct[j]);
				$label    = $(document.createElement("label")).addClass(defAct[j]).append($checkbox).append(defName[j]);
				if(OW.isInArray(arr,act)){
					$checkbox.attr("checked",false);
				};
				$span.append($label);
			};
			$li.attr("model_type",modelType);
			if(modelType==1){
				$li.find("input[act='list'],input[act='add'],input[act='delete']").parent().empty();
			};
		};
		parseCheckbox();
		function parseCheckbox(){
			var $root         = oTree.dom.root;
			var $nodeCheckbox = $root.find("span.node-checkbox").find("input:checkbox");
			var $actCheckbox  = $root.find("input[name='cate_act']:checkbox");
			$nodeCheckbox.click(function(){
				var $li = $(this).parent().parent();
				if($(this).attr("checked")==true){
					$li.find("input:checkbox").attr("checked",true);
				}else{
					$li.find("input:checkbox").attr("checked",false);
				};
			});
			$actCheckbox.click(function(){
				var $nodeAux      = $(this).parent().parent();
				var $li           = $(this).parent().parent().parent();
				var $nodeCheckbox = $li.find("span.node-checkbox:first").find("input:checkbox");
				if($nodeAux.find("input:checked").length==0){
					$nodeCheckbox.attr("checked",false);
				}else{
					if($nodeAux.find("input:checkbox[checked=false]").length==0){
						$nodeCheckbox.attr("checked",true);
					}else{
						$nodeCheckbox.attr("checked",false);
					};
				};
			});
		};
		//**切换站点
		$("#site").change(function(){
			var site_id = parseInt($(this).val());
			if(site_id>0){
				OWDialog("正在加载页面 ... ");
				window.location.href = 'index.asp?ctl=<%=CTL%>&act=<%=ACT%>&group_id=<%=V("group_id")%>&site_id='+site_id+"&r="+OW.random();
			};
		});
		//**全选
		$("#select_all").click(function(){
			if($(this).attr("checked")==true){
				$treeRoot.find("input:checkbox").attr("checked",true);
			}else{
				$treeRoot.find("input:checkbox").attr("checked",false);
			};
		});
		$("#list_all").click(function(){
			if($(this).attr("checked")==true){
				$treeRoot.find("input:checkbox[act='list']").attr("checked",true);
			}else{
				$treeRoot.find("input:checkbox[act='list']").attr("checked",false);
			};
		});
		$("#add_all").click(function(){
			if($(this).attr("checked")==true){
				$treeRoot.find("input:checkbox[act='add']").attr("checked",true);
			}else{
				$treeRoot.find("input:checkbox[act='add']").attr("checked",false);
			};
		});
		$("#edit_all").click(function(){
			if($(this).attr("checked")==true){
				$treeRoot.find("input:checkbox[act='edit']").attr("checked",true);
			}else{
				$treeRoot.find("input:checkbox[act='edit']").attr("checked",false);
			};
		});
		$("#delete_all").click(function(){
			if($(this).attr("checked")==true){
				$treeRoot.find("input:checkbox[act='delete']").attr("checked",true);
			}else{
				$treeRoot.find("input:checkbox[act='delete']").attr("checked",false);
			};
		});
	});
    </script>
    <%
		call Admin.echoFooter()
	end function
	
	private function editCategoryAuthSave()
		dim check,arr,a
		'**数据初始化
		check = true
		'**接收数据
		V("cate_act") = OW.getForm("post","cate_act")
		'**数据处理
		arr = split(V("cate_act"),",")
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			'**获取管理员组名
			V("group_name") = OW.DB.getFieldValueBySQL("SELECT group_name FROM "& DB_PRE &"member_group WHERE group_id="& V("group_id") &"")
			'**清空当前管理员组的权限
			call OW.DB.execute("DELETE FROM "& DB_PRE &"category_admin_auth WHERE site_id="& V("site_id") &" AND group_id="& V("group_id") &"")
			for iI=0 to ubound(arr)
				a            = split(arr(iI),":")
				V("cate_id") = a(0)
				V("act")     = a(1)
				'**添加已被禁止的权限
				call OW.DB.addRecord(DB_PRE &"category_admin_auth",array("site_id:"& V("site_id"),"cate_id:"& V("cate_id"),"group_id:"& V("group_id"),"act:"& V("act"),"forbid:1"))
			next
			'**输出操作结果信息
			Admin.actionFinishSuccess = true
			Admin.actionFinishSuccessText = array("成功编辑管理员组栏目权限："& V("group_name"),"")
			Admin.actionFinishFailText = array("编辑管理员组栏目权限失败："& V("group_name"),"")
			Admin.actionFinishRun()
		end if
	end function
	
	private function editPluginAuth(byval isSave)
		dim check
		check = true
		V("group_id") = OW.int(OW.getForm("get","group_id"))
		V("site_id")  = OW.int(OW.getForm("get","site_id"))
		if V("group_id")<1 then check = false : call Admin.errorSetting("管理员组id传递不正确")
		if V("group_id")=1 then check = false : call Admin.errorSetting("不能修改创始人组的栏目管理权限")
		if V("site_id")<1 then check = false : call Admin.errorSetting("站点id传递不正确")
		if check then
			if isSave then
				call editPluginAuthSave()
			else
				call editPluginAuthHtml()
			end if
		end if
	end function
	
	private function editPluginAuthHtml()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
		dim i,rs,rs2,pms,s,ctl_act,havsPms,isFounder
		if V("group_id")=1 then
			isFounder = true
		else
			isFounder = false
		end if
	%>
    <div class="mbody">
        <div class="permissions" id="permissions">
            <% if SITE_ID=1 then %>
            <div class="heading">
                <table border="0" cellpadding="0" cellspacing="0"><tr>
                <td><div class="select-all"><input type="checkbox" name="select_all" id="select_all" <%=OW.iif(isFounder,"disabled=""disabled""","")%> value="1" /><label for="select_all"><b>全选</b></label></div></td>
                <td style="padding-left:10px;">
                <%=Admin.sitesOptions(V("site_id"),"选择站点 ... ")%>
                <input type="hidden" id="group_id" value="<%=V("group_id")%>" />
                </td>
                <td style="padding-left:6px;">选择要设置权限的站点</td>
                <td style=" color:#aaa; padding-left:8px;">切换到其他站点前请务必先保存当前的设置</td>
                </tr>
                </table>
            </div>
            <% end if %>
            <div class="plugin-pms" name="plugins">
                <ul>
                    <%=pluginAuthList()%>
                </ul>
            </div>     
        </div>
    </div>
    <script type="text/javascript">
    $(window).ready(function(){
		//**切换站点
		$("#site").change(function(){
			var site_id = parseInt($(this).val());
			if(site_id>0){
				OWDialog("正在加载页面 ... ");
				window.location.href = 'index.asp?ctl=<%=CTL%>&act=<%=ACT%>&group_id=<%=V("group_id")%>&site_id='+site_id+"&r="+OW.random();
			};
		});
		//**全选
		$("#select_all").click(function(){
			if($(this).attr("checked")==true){
				$("div[name='plugins']").find("input:checkbox").attr("checked",true);
			}else{
				$("div[name='plugins']").find("input:checkbox").attr("checked",false);
			};
		});
	});
    </script>
    <%
		call Admin.echoFooter()
	end function
	
	private function pluginAuthList()
		dim havsPms,rs,s
		set rs = OW.DB.getRecordBySQL("SELECT plugin_code,plugin_name FROM ["& DB_PRE &"plugins] WHERE status=0 ORDER BY sequence")
		do while not rs.eof
			if OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"admin_action WHERE site_id="& V("site_id") &" AND group_id="& V("group_id") &" AND ctl='"& rs("plugin_code") &"' AND is_plugin=1 AND allow=1") then
				havsPms = true
			else
				havsPms = false
			end if
			s = s &"<li><label><input type=""checkbox"" name=""plugin"" "& OW.IIF(havsPms,"checked=""checked""","") &" value="""& rs("plugin_code") &""" />"& rs("plugin_name") &"</a></label></li>"
			rs.movenext
		loop
		OW.DB.closeRs rs
		pluginAuthList = s
	end function
	
	private function editPluginAuthSave()
		dim check,arr,plugin
		'**数据初始化
		check = true
		'**接收数据
		V("plugin") = OW.getForm("post","plugin")
		'**数据处理
		arr = split(V("plugin"),",")
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			'**获取管理员组名
			V("group_name") = OW.DB.getFieldValueBySQL("SELECT group_name FROM "& DB_PRE &"member_group WHERE group_id="& V("group_id") &"")
			'**清空当前管理员组的权限
			call OW.DB.execute("DELETE FROM "& DB_PRE &"admin_action WHERE site_id="& V("site_id") &" AND group_id="& V("group_id") &" AND is_plugin=1")
			for iI=0 to ubound(arr)
				plugin = OW.left(OW.regReplace(arr(iI),"[^0-9a-zA-Z_]",""),30)
				if OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"plugins WHERE plugin_code='"& plugin &"'") then
					call OW.DB.addRecord(DB_PRE &"admin_action",array("site_id:"& V("site_id"),"group_id:"& V("group_id"),"ctl:"& plugin,"act:","is_plugin:1","allow:1"))
				end if
			next
			'**输出操作结果信息
			Admin.actionFinishSuccess = true
			Admin.actionFinishSuccessText = array("成功编辑管理员组插件使用权限："& V("group_name"),"")
			Admin.actionFinishFailText = array("编辑管理员组插件使用权限失败："& V("group_name"),"")
			Admin.actionFinishRun()
		end if
	end function
	
	private function editAdminAction(byval isSave)
		dim check
		check = true
		V("group_id") = OW.int(OW.getForm("get","group_id"))
		V("site_id") = OW.int(OW.getForm("get","site_id"))
		if V("group_id")<1 then check = false : call Admin.errorSetting("管理员组id传递不正确")
		if V("group_id")=1 then check = false : call Admin.errorSetting("不能修改创始人组的系统管理权限")
		if V("site_id")<1 then check = false : call Admin.errorSetting("站点id传递不正确")
		if check then
			if isSave then
				call editAdminActionSave()
			else
				call editAdminActionHtml()
			end if
		end if
	end function
	
	private function editAdminActionHtml()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
		dim i,rs,rs2,pms,s,ctl_act,havsPms,isFounder
		if V("group_id")=1 then
			isFounder = true
		else
			isFounder = false
		end if
	%>
    <div class="mbody">
        <div class="permissions" id="permissions">
            <div class="heading">
                <table border="0" cellpadding="0" cellspacing="0"><tr>
                <td><div class="select-all"><input type="checkbox" name="select_all" id="select_all" <%=OW.iif(isFounder,"disabled=""disabled""","")%> value="1" /><label for="select_all"><b>全选</b></label></div></td>
                <% if SITE_ID=1 then %>
                <td style="padding-left:10px;">
                <%=Admin.sitesOptions(V("site_id"),"选择站点 ... ")%>
                <input type="hidden" id="group_id" value="<%=V("group_id")%>" />
                </td>
                <td style="padding-left:6px;">选择要设置权限的站点</td>
                <td style=" color:#aaa; padding-left:8px;">切换到其他站点前请务必先保存当前的设置</td>
                <% end if %>
                </tr>
                </table>
            </div>
            <div class="permissions_list">
			<%
			set pms = server.createObject(OW.dictName)
			set rs = OW.DB.getRecordBySQL("SELECT ctl,act,allow FROM ["& DB_PRE &"admin_action] WHERE group_id="& V("group_id") &" AND site_id="& V("site_id") &"")
			do while not(rs.eof)
				ctl_act = trim(rs("ctl"))&":"&trim(rs("act"))
				pms(ctl_act) = OW.int(rs("allow"))
				rs.movenext()
			loop
			OW.DB.closeRs rs
            %>
            <%
            set rs = OW.DB.getRecordBySQL("SELECT ctl,ctl_name FROM ["& DB_PRE &"action] GROUP BY sys_id,ctl_id,ctl,ctl_name ORDER BY sys_id,ctl_id ASC")
            do while not(rs.Eof)
				i = i + 1
            %>
            <div class="permission">
                <div class="heading">
                <input type="checkbox" class="ml5" name="ctl" id="<%=trim(rs("ctl"))%>" <%=OW.iif(isFounder,"disabled=""disabled""","")%> value="<%=trim(rs("ctl"))%>" /><%=trim(rs(1))%>
                <span class="order"><%="<span>#"& i &"</span>"%></span>
                </div>
                <ul>
                 <%
				 s = ""
                 set rs2 = OW.DB.getRecordBySQL("SELECT act,act_name FROM ["& DB_PRE &"action] WHERE ctl='"& trim(rs(0)) &"' ORDER BY act_id ASC")
                 do while not(rs2.Eof)
                     ctl_act = trim(rs("ctl")) &":"& trim(rs2("act"))
                     if OW.int(pms(ctl_act))=1 then
						 havsPms = true
					 else
						 havsPms = false
					 end if
                     s = s &"<li>"
                     s = s &"<input type=""checkbox"" name=""act"" ctl="""& trim(trim(rs("ctl"))) &""" act="""& trim(rs2("act")) &""" "& OW.IIF(havsPms,"checked=""checked""","") &" "& OW.IIF(isFounder,"disabled=""disabled""","") &" value="""& ctl_act &""" />"& trim(rs2("act_name")) &""
                     s = s &"</li>"
                 rs2.movenext()
                 loop
                 OW.DB.CloseRs rs2
				 echo s
                 %>
                 </ul>
            </div>
            <%
            rs.movenext()
            loop
            OW.DB.CloseRs rs 
            set pms = nothing
            %>
            </div>           
        </div>
    </div>
    <script type="text/javascript">
    $(window).ready(function(){
		var $selectAll = $("#select_all");
		//**全选
		$selectAll.click(function(){
			if($(this).attr("checked")==true){
				$("input[name='ctl']").attr("checked",true);
				$("input[name='act']").attr("checked",true);
				$("input[name='act']").parent().addClass("selected");
			}else{
				$("input[name='ctl']").attr("checked",false);
				$("input[name='act']").attr("checked",false);
				$("input[name='act']").parent().removeClass("selected");
			};
		});
		//**ctl
		$("input[name='ctl']").click(function(){
			var $li = $(this).parent().next("ul").find("li");
			var $checkbox = $(this).parent().next("ul").find(":checkbox");
			if($(this).attr("checked")==true){
				$li.addClass("selected");
				$checkbox.attr("checked",true);
			}else{
				$li.removeClass("selected");
				$checkbox.attr("checked",false);
			};
		});
		//**act
		$("input[name='act']").each(function(){
			if($(this).attr("checked")==true){
				$(this).parent().addClass("selected");
			};
		}).click(function(){
			var $li = $(this).parent();
			if($(this).attr("checked")==true){
				$li.addClass("selected");
			}else{
				$li.removeClass("selected");
			};
		});
		//**切换站点
		$("#site").change(function(){
			var site_id = parseInt($(this).val());
			if(site_id>0){
				OWDialog("正在加载页面 ... ");
				window.location.href = 'index.asp?ctl=<%=CTL%>&act=<%=ACT%>&group_id=<%=V("group_id")%>&site_id='+site_id+"&r="+OW.random();
			};
		});
		
	});
    </script>
    <%
		call Admin.echoFooter()
	end function
	
	private function editAdminActionSave()
		dim check,arr,a,tmp
		'**数据初始化
		check = true
		'**接收数据
		V("ctlact") = OW.getForm("post","ctlact")
		'**数据处理
		arr = split(V("ctlact"),",")
		'**数据合法性校验
		'**
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			'**获取管理员组名
			V("group_name") = OW.DB.getFieldValueBySQL("SELECT group_name FROM "& DB_PRE &"member_group WHERE group_id="& V("group_id") &"")
			'**
			OW.DB.auxSQLValid = false
			bResult = OW.DB.updateRecord(DB_PRE &"admin_action",array("allow:0"),array("group_id:"& V("group_id"),"site_id:"& V("site_id"),"is_plugin:0"))
			'**
			for iI=0 to ubound(arr)
				tmp = arr(iI)
				a = split(tmp,":")
				V("ctl") = a(0)
				V("act") = a(1)
				if OW.DB.isRecordExists(DB_PRE &"admin_action",array("group_id:"& V("group_id"),"site_id:"& V("site_id"),"ctl:"& V("ctl"),"act:"& V("act"),"is_plugin:0"),"") then
					call OW.DB.updateRecord(DB_PRE &"admin_action",array("allow:1"),array("group_id:"& V("group_id"),"site_id:"& V("site_id"),"ctl:"& V("ctl"),"act:"& V("act"),"is_plugin:0"))
				else
					call OW.DB.addRecord(DB_PRE &"admin_action",array("site_id:"& V("site_id"),"group_id:"& V("group_id"),"ctl:"& V("ctl"),"act:"& V("act"),"is_plugin:0","allow:1"))
				end if
			next
			'**
			OW.DB.auxSQLValid = true
			
			'**输出操作结果信息
			Admin.actionFinishSuccess = bResult
			Admin.actionFinishSuccessText = array("成功编辑管理员组权限："& V("group_name"),"")
			Admin.actionFinishFailText = array("编辑管理员组权限失败："& V("group_name"),"")
			Admin.actionFinishRun()
		end if
	end function
	
	function delete()
		dim check,s,id,result
		check = true
		'**接收数据
		V("ids") = OW.regReplace(OW.getForm("post","ids"),"[^0-9,]","")
		'**数据处理
		aArr = split(V("ids"),",")
		'**数据合法性校验
		if V("ids")="" then check = false : Admin.errorSetting("id值传递不正确")
		if V("ids")=1 then check = false : Admin.errorSetting("创始人组不能删除")
		
		'**从数据库删除记录
		if check then
			'**delete
			for iI=0 to ubound(aArr)
				V("group_id") = OW.clng(aArr(iI))
				if V("group_id")>1 then
					V("group_name") = OW.DB.getFieldValueBySQL("SELECT group_name FROM "& DB_PRE &"member_group WHERE group_id="& V("group_id") &"")
					result = OW.DB.execute("DELETE FROM ["& DB_PRE &"member_group] WHERE group_id="& V("group_id") &"")
					if result then
						bResult = result
						call OW.DB.execute("DELETE FROM ["& DB_PRE &"member_group_sites] WHERE group_id="& V("group_id") &"")
						call OW.DB.execute("DELETE FROM ["& DB_PRE &"admin_action] WHERE group_id="& V("group_id") &"")
						s = s &"成功删除管理员组("& V("group_name") &");<br>"
					else
						s = s &"从数据库中删除管理员组("& V("group_name") &")失败;<br>"
					end if
				end if
			next
			'**输出操作结果信息
			Admin.actionFinishSuccess = bResult
			Admin.actionFinishSuccessText = array(s,"")
			Admin.actionFinishFailText = array(s,"")
			Admin.actionFinishRun()
		end if
	end function

	function doing()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <script language="javascript" type="text/javascript" src="js/colorpicker.js"></script>
    <div class="mbody">
        <form name="save_form" id="save_form" action="?ctl=<%=CTL%>&act=<%=ACT%>&id=<%=V("group_id")%>&save=true" method="post">
        <div class="wbox">
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                <tr><td class="titletd"><i class="important">*</i>管理员组名</td>
                    <td class="infotd">
                    <input type="text" class="text" name="group_name" maxlength="64" value="<%=V("group_name")%>"/>
                    <span class="t-normal ml5" name="t_group_name">填写管理员组名称</span>
                    </td>
                </tr>
                <tr><td class="titletd"><i class="important">*</i>级别值</td>
                    <td class="infotd">
                    <input type="text" class="text" name="group_rank" maxlength="5" value="<%=V("group_rank")%>" onblur="OW.onblur(this,{rep:'/[^0-9]*/g',length:5})" style="width:100px;"/>
                    <span class="t-normal ml5" name="t_group_rank">填写数字，越大级别越高</span>
                    </td>
                </tr>
                <tr><td class="titletd">组名颜色</td>
                    <td class="infotd">
                    <input type="text" class="text text-short-mini fl" name="group_color" id="group_color" maxlength="7" value="<%=V("group_color")%>" onblur="OW.onblur(this,{rep:'/[^#0-9a-zA-Z]*/g',length:7})"/>
                    <span id="select_color"></span>
                    <span class="t-normal ml5" name="t_site_sname">可不用填写</span>
                    <script type="text/javascript">
                    var groupColor = OWColor({
						container:$("#select_color"),
						defaultColor:"<%=V("group_color")%>",
						getColor:function(){
							$("input[name='group_name']").css('color',groupColor.color);
							$("input[name='group_color']").css('color',groupColor.color).val(groupColor.color);
						},
						clear:function(){
							$("input[name='group_color']").css('color','').val('');
						},
						clearValue:"清除"
					});
					if(groupColor.config.defaultColor!=""){
						$("input[name='group_name']").css('color',groupColor.config.defaultColor);
						$("input[name='group_color']").css('color',groupColor.config.defaultColor);
					};
                    </script>
                    </td>
                </tr>
                <tr><td class="titletd">图标</td>
                    <td class="infotd">
                    <%=Admin.createImageSelectGrid("group_icon",V("group_icon"),"","")%>
                    </td>
                </tr>
                </table>
            </div>
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                <tr><td class="titletd">备注</td>
                    <td class="infotd">
                    <textarea class="textarea" name="description" onblur="OW.onblur(this,{length:255})"><%=V("description")%></textarea>
                    <span class="t-normal ml5" name="t_description"></span>
                    </td>
                </tr>
                </table>
            </div>
        </div>
        <div class="button-container">
            <button type="submit" class="btn btn-large btn-primary" name="submit">确定保存</button>
            <button type="reset" class="btn btn-large" name="reset">重置</button>
            <button type="button" class="btn btn-large" name="close" onClick="OW.goBack();">关闭</button>
        </div>
        </form>
    </div>
    <script type="text/javascript">
	$(document).ready(function(){
		var $form = $("#save_form");
		//提交保存数据
		$form.submit(function(){
			var check = true;
			if(!V.input({me:$("input[name='group_rank']"),tip:$("span[name='t_group_rank']"),okValue:'',errorValue:'请先填写管理员组的级别值'})){check=false;};
			if(!V.input({me:$("input[name='group_name']"),tip:$("span[name='t_group_name']"),okValue:'',errorValue:'请先填写管理员组名'})){check=false;};
			if(check){OWDialog('<div class="loading">正在提交并保存数据，请稍候...</div>');};
			return check;
		});
	});
    </script>
    <%
		call Admin.echoFooter()
	end function
	
	function doingSave()
		dim check
		'**数据初始化
		check = true
		'**接收数据
		V("group_id")    = ID
		V("group_name")  = OW.validDBData(OW.getForm("post","group_name"),50)
		V("group_rank")  = OW.int(OW.getForm("post","group_rank"))
		V("group_color") = OW.getForm("post","group_color")
		V("group_icon")  = OW.validDBData(OW.getForm("post","group_icon"),255)
		V("description") = OW.validDBData(OW.getForm("post","description"),255)
		'**数据处理
		if right(V("site_folder"),1) <> "/" then V("site_folder") = V("site_folder") & "/"
		if V("group_color")<>"" then V("group_color") = OW.parseColor(V("group_color"))
		'**数据合法性校验
		if not Admin.validate("s",V("group_name"),"minLength:1,maxLength:0","请先填写管理员组名") then check = false
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			if ACT = "add" then
				OW.DB.auxSQLValid = false
				V("group_id")   = OW.DB.maxID(DB_PRE &"member_group","group_id") + 1
				'**add管理员组名记录
				bResult = OW.DB.addRecord(DB_PRE &"member_group",array("group_id:"& V("group_id"),"group_type:"& sGroupType,"group_name:"& V("group_name"),"group_rank:"& V("group_rank"),"group_point:0","group_color:"& V("group_color"),"group_icon:"& V("group_icon"),"discount:"& V("discount"),"description:"& V("description"),"status:0","site_id:"& SITE_ID))
				if bResult then
					'**add此站的管理员组名
					call OW.DB.addRecord(DB_PRE &"member_group_sites",array("group_id:"& V("group_id"),"group_name:"& V("group_name"),"site_id:"& SITE_ID))
				end if
				OW.DB.auxSQLValid = true
				'输出操作结果信息
				Admin.actionFinishSuccess = bResult
				Admin.actionFinishSuccessText = array("成功添加新管理员组："& V("group_name"),"?ctl="& CTL &"&act=list")
				Admin.actionFinishFailText = array("添加管理员组失败："& V("group_name"),"?ctl="& CTL &"&act=add")
				Admin.actionFinishRun()
			elseif ACT = "edit" then
				OW.DB.auxSQLValid = false
				'**edit管理员组名记录
				bResult = OW.DB.updateRecord(DB_PRE &"member_group",array("group_rank:"& V("group_rank"),"group_color:"& V("group_color"),"group_icon:"& V("group_icon"),"discount:"& V("discount"),"description:"& V("description")),array("group_id:"& V("group_id")))
				
				if bResult then
					if SITE_ID=1 then
						call OW.DB.updateRecord(DB_PRE &"member_group",array("group_name:"& V("group_name")),array("group_id:"& V("group_id"),"group_type:"& sGroupType))
					end if
					'**edit此站的管理员组名
					if OW.DB.isRecordExists(DB_PRE &"member_group_sites",array("group_id:"& V("group_id"),"site_id:"& SITE_ID),"") then
						call OW.DB.updateRecord(DB_PRE &"member_group_sites",array("group_name:"& V("group_name")),array("group_id:"& V("group_id"),"site_id:"& SITE_ID))
					else
						call OW.DB.addRecord(DB_PRE &"member_group_sites",array("group_id:"& V("group_id"),"group_name:"& V("group_name"),"site_id:"& SITE_ID))
					end if
				end if
				OW.DB.auxSQLValid = true
				'**输出操作结果信息
				Admin.actionFinishSuccess = bResult
				Admin.actionFinishSuccessText = array("成功编辑管理员组："& V("group_name"),"?ctl="& CTL &"&act=list")
				Admin.actionFinishFailText = array("编辑管理员组失败："& V("group_name"),"?ctl="& CTL &"&act="& ACT &"&id="& V("group_id") &"")
				Admin.actionFinishRun()
			end if
		end if
	end function
	
	private function getInfo()
		V("group_id") = ID
		set oRs = OW.DB.getRecordBySQL("SELECT * FROM ["& DB_PRE &"member_group] WHERE group_type="& sGroupType &" and group_id="& V("group_id") &"")
		if not(oRs.eof) then
			V("group_name")  = OW.DB.getFieldValue(DB_PRE &"member_group_sites","group_name",array("group_id:"& ID,"site_id:"& SITE_ID),"")
			V("group_rank")  = oRs("group_rank")
			V("group_color") = oRs("group_color")
			V("group_icon")  = oRs("group_icon")
			V("description") = oRs("description")
			V("status")      = oRs("status")
		end if
		OW.DB.closeRs oRs
	end function
	
	private function list()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <% if SITE_ID=1 then %>
        <div class="top-area">
            <table cellspacing="0" cellpadding="0" border="0">
              <tbody><tr>
              <td class="do-cell">
                  <div class="do-cell-name">添加操作区</div>
                  <div class="do-cell-btn"><a class="btn btn-primary" id="add_new" href="index.asp?ctl=<%=CTL%>&act=add">添加管理员组</a></div>
              </td>
              <td class="do-cell">
                  <div class="do-cell-name">删除操作区</div>
                  <div class="do-cell-btn"><button class="btn" id="delete_selected">批量删除</button></div>
              </td>
              </tr></tbody>
            </table>
        </div>
        <% end if %>
        <div class="list-area" id="data_list_area">
            <table border="0" cellpadding="0" cellspacing="0" width="100%" class="listTable">
              <thead>
                  <tr class="thead">
                      <th><input type="checkbox" name="select_all" id="select_all"></th>
                      <th>管理员组id</th>
                      <th>管理员组名（站点）</th>
                      <th>管理员组名（默认）</th>
                      <th>级别值</th>
                      <th>图标</th>
                      <th>状态</th>
                      <th>操作</th>
                  </tr>
              </thead>
              <tbody>
              <%=listing()%>
              </tbody>
            </table>
        </div>
    </div>
    <script type="text/javascript">
    $(window).ready(function(){
		Admin.dataListTableInit({
			ctl:"<%=CTL%>",
			act_edit:"edit",
			field_name:"group_name",
			status_validValue:"正常",
			status_validTitle:"点击可设置为无效状态",
			status_invalidValue:'无效',
			status_invalidTitle:'点击可设置为正常状态',
			delete_confirm:"删除后管理员组将无法恢复，您确定要删除吗？",
			delete_confirm2:"删除后管理员组{tpl:name}将无法恢复，您确定要删除吗？",
			delete_doing:"正在删除管理员组...",
			delete_success:"删除成功",
			delete_failed:"删除操作失败",
			delete_tip:"请先选择您要删除的管理员组"
		});	
		//**创始人不可点击/删除
		$("#data_list_area input[value='1']").attr("disabled",true).hide();
		$("#data_list_area tr[value='1']").find("a[name='edit_admin_action']").remove();
		$("#data_list_area tr[value='1']").find("a[name='edit_category_auth']").remove();
		$("#data_list_area tr[value='1']").find("a[name='edit_plugin_auth']").remove();
		$("#data_list_area tr[value='1']").find("a[name='delete']").remove();
		//**创始人状态不允许修改
		$("#data_list_area td[field='status']").each(function(){
			if($(this).parent().attr("value")==1){
				$(this).find("a").unbind("click").click(function(){
					OWDialog({content:"对不起，不允许修改创始人的状态！",follow:$(this),shadow:false,timeout:2});
					return false;
				});
			};
		});
		//**组名颜色
		$("#data_list_area td[field='group_color']").each(function(){
			var c = $(this).attr("value");
			if(c!=""){
				$(this).parent().find("td[field='group_name']").css("color",c);
				$(this).parent().find("td[field='group_name_sites']").css("color",c);
			};
			$(this).remove();
		});
		//**图标
		$("#data_list_area td[field='group_icon']").each(function(){
			var url = $(this).attr("value");
			if(url!=""){
				$(this).html('<img src="'+url+'" height="32" />');
			};
		});
		//**管理权限设置
		$("#data_list_area a[name='edit_admin_action']").click(function(){
			var $dialog = OWDialog({
				id:'d_edit_admin_action',
				title:''+$(this).parent().parent().find("td[field='group_name']").attr("value")+' - 管理权限设置',
				iframe:'index.asp?ctl=<%=CTL%>&act=edit_admin_action&group_id='+$(this).parent().parent().attr("value")+"&site_id=<%=SITE_ID%>&r="+OW.random(),
				padding:'0px',
				height:OW.dialogBigHeight(),
				width:OW.webScreenWidth()-60,
				ok:function(){
					var $diaLoading = OWDialog('<span class="loading">正在提交数据 ... </span>');
					var $iframe = this.dom.iframe;
					var $pms = $($iframe.contentWindow.document.getElementById("permissions"));
					var groupId = $iframe.contentWindow.document.getElementById("group_id").value;
					var siteId = $iframe.contentWindow.document.getElementById("site").value;
					var $checkboxs = $pms.find("input[name='act']:checked");
					var data = "";
					$checkboxs.each(function(){
						data = data=="" ? $(this).val() : data +","+ $(this).val();
					});
					Admin.ajax({
						me:"",data:'ctlact='+data,
						url:"index.asp?ctl=<%=CTL%>&act=edit_admin_action&save=true&group_id="+groupId+"&site_id="+siteId+"&r="+OW.random(),
						success:function(){
							$diaLoading.success("保存成功").timeout(1);
						},
						failed:function(msg){
							$diaLoading.error("保存失败",msg).timeout(1);
						}
					});
					return false;
				},
				okValue:'保存当前设置',
				cancel:true,
				cancelValue:'关闭'
			});
		});
		//**栏目权限设置
		$("#data_list_area a[name='edit_category_auth']").click(function(){
			var $dialog = OWDialog({
				id:'d_edit_category_auth',
				title:''+$(this).parent().parent().find("td[field='group_name']").attr("value")+' - 栏目权限设置',
				iframe:'index.asp?ctl=<%=CTL%>&act=edit_category_auth&group_id='+$(this).parent().parent().attr("value")+"&site_id=<%=SITE_ID%>&r="+OW.random(),
				padding:'0px',
				height:OW.dialogBigHeight(),
				width:OW.dialogBigWidth(),
				ok:function(){
					var $diaLoading = OWDialog('<span class="loading">正在提交数据 ... </span>');
					var $iframe    = this.dom.iframe;
					var $pms       = $($iframe.contentWindow.document.getElementById("permissions"));
					var groupId    = $iframe.contentWindow.document.getElementById("group_id").value;
					var siteId     = $iframe.contentWindow.document.getElementById("site").value;
					var $checkboxs = $pms.find("input[name='cate_act']:not(:checked)");
					var data       = "";
					$checkboxs.each(function(){
						data = data=="" ? $(this).val() : data +","+ $(this).val();
					});
					Admin.ajax({
						me:"",data:'cate_act='+data,
						url:"index.asp?ctl=<%=CTL%>&act=edit_category_auth&save=true&group_id="+groupId+"&site_id="+siteId+"&r="+OW.random(),
						success:function(){
							$diaLoading.success("保存成功").timeout(1);
						},
						failed:function(msg){
							$diaLoading.error("保存失败",msg).timeout(1);
						}
					});
					return false;
				},
				okValue:'保存当前设置',
				cancel:true,
				cancelValue:'关闭'
			});
		});
		//**插件权限设置
		$("#data_list_area a[name='edit_plugin_auth']").click(function(){
			var $dialog = OWDialog({
				id:'d_edit_plugin_auth',
				title:''+$(this).parent().parent().find("td[field='group_name']").attr("value")+' - 插件权限设置',
				iframe:'index.asp?ctl=<%=CTL%>&act=edit_plugin_auth&group_id='+$(this).parent().parent().attr("value")+"&site_id=<%=SITE_ID%>&r="+OW.random(),
				padding:'0px',
				height:OW.dialogBigHeight(),
				width:OW.dialogBigWidth(),
				ok:function(){
					var $diaLoading = OWDialog('<span class="loading">正在提交数据 ... </span>');
					var $iframe    = this.dom.iframe;
					var $pms       = $($iframe.contentWindow.document.getElementById("permissions"));
					var groupId    = $iframe.contentWindow.document.getElementById("group_id").value;
					var siteId     = $iframe.contentWindow.document.getElementById("site").value;
					var $checkboxs = $pms.find("input[name='plugin']:checked");
					var data       = "";
					$checkboxs.each(function(){
						data = data=="" ? $(this).val() : data +","+ $(this).val();
					});
					Admin.ajax({
						me:"",data:'plugin='+data,
						url:"index.asp?ctl=<%=CTL%>&act=edit_plugin_auth&save=true&group_id="+groupId+"&site_id="+siteId+"&r="+OW.random(),
						success:function(){
							$diaLoading.success("保存成功").timeout(1);
						},
						failed:function(msg){
							$diaLoading.error("保存失败",msg).timeout(1);
						}
					});
					return false;
				},
				okValue:'保存当前设置',
				cancel:true,
				cancelValue:'关闭'
			});
		});
		//**
	});
    </script>
	<%
		call Admin.echoFooter()
	end function
	
	private function listing()
		Admin.list("fields") = "a.group_id,(select top 1 group_name from [ow_member_group_sites] where group_id=a.group_id and site_id="& SITE_ID &") as group_name_sites,a.group_name,a.group_rank,a.group_color,a.group_icon,a.status"
		Admin.list("sql") = "SELECT "& Admin.list("fields") &" FROM ["& DB_PRE &"member_group] a WHERE a.group_type="& sGroupType &" ORDER BY a.group_rank DESC"
		Admin.list("pagesize") = Admin.getPageSise(ACTION_ID)
		Admin.list("checkboxExists") = true
		Admin.list("opeations") = "<a class=""btn btn-small btn-primary mr5"" name=""edit"" href=""javascript:;"">编辑</a><a class=""btn btn-small mr5"" name=""edit_admin_action"" href=""javascript:;"">系统权限设置</a><a class=""btn btn-small mr5"" name=""edit_category_auth"" href=""javascript:;"">栏目权限设置</a><a class=""btn btn-small mr5"" name=""edit_plugin_auth"" href=""javascript:;"">插件权限设置</a>"
		if SITE_ID=1 then
		Admin.list("opeations") = Admin.list("opeations") &"<a class=""btn btn-small"" name=""delete"" href=""javascript:;"">删除</a>"
		end if
		Admin.list("auxURLPara") = ""
		Admin.list("returnType") = "html"
		listing = Admin.getDataList()
	end function
	
	private function categoryNodes(byval isShop,byval parentId)
		dim rs,s,ss,cateId,children,pId,checked
		dim i,arr,modelType
		set rs = OW.DB.getRecordBySQL("SELECT cate_id,model_type,parent_id,depth,children,name FROM "& DB_PRE &"category WHERE parent_id="& parentId &" AND is_shop="& isShop &" AND site_id="& V("site_id") &"")
		do while not rs.eof
			cateId   = OW.int(rs("cate_id"))
			children = OW.int(rs("children"))
			modelType= OW.int(rs("model_type"))
			arr      = OW.DB.getFieldValueBySQL("SELECT act FROM "& DB_PRE &"category_admin_auth WHERE site_id="& V("site_id") &" AND cate_id="& cateId &" AND group_id="& V("group_id") &" AND forbid=1")
			
			s = "{id:"& rs("cate_id") &",pId:"& rs("parent_id") &",depth:"& rs("depth") &",name:"""& rs("name") &""",model_type:"& modelType &",acts:"""& OW.join(arr,",") &""",open:false}"
			if children>0 then s = s &","& categoryNodes(isShop,rs("cate_id"))
			if ss="" then
				ss = s
			else
				ss = ss &","& s
			end if
			rs.movenext
		loop
		OW.DB.closeRs rs
		categoryNodes = ss
	end function
	
end class
%>