﻿<%
'**
'栏目管理
'**
dim AP_CATEGORY
class AP_CATEGORY_CLASS
	
	private aArr,oRs,sCols,sSQL,iI,iPageSize,sString,sOpeation,sURL,bResult,sTable
	private bAuxSQLValid,bShowAdvGrid,bShowPicSet,bCategoryExist,sCategoryTable,sContentModelTable
	private iIsShop
	
	private sub class_initialize()
		bAuxSQLValid   = false
		bShowAdvGrid   = false
		bShowPicSet    = false
		bCategoryExist = true
		iIsShop        = 0
		sCategoryTable = DB_PRE &"category"
	end sub
	
	public sub init()
		if CTL="category" or CTL="shop_category" then
			select case ACT
			case "list"
				call list()
			case "add"
				call add(SAVE)
			case "edit"
				if SUBACT = "status_edit" then
					if SAVE then
						bAuxSQLValid = true
						call Admin.statusEdit(sCategoryTable,"cate_id",auxSQLValid,array("成功更改栏目状态","无法更新数据库，栏目状态更改失败！"))
					end if
				elseif SUBACT = "sequence_edit" then
					if SAVE then
						bAuxSQLValid = true
						call Admin.sequenceEdit(sCategoryTable,"cate_id",bAuxSQLValid,array("成功进行栏目排序","无法更新数据库，栏目排序失败！"))
					end if
				else
					call edit(SAVE)
				end if
			case "delete"
				call delete()
			end select
		end if
	end sub
	
	private sub class_terminate()
	end sub
	
	private function getInfo()
		set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& sCategoryTable &" WHERE is_shop="& iIsShop &" AND cate_id="& V("cate_id") &" AND "& OW.DB.auxSQL &"")
		if not(oRs.eof) then
			bCategoryExist    = true
			V("model_id")     = OW.int(oRs("model_id"))
			V("model_type")   = OW.int(oRs("model_type"))
			V("parent_id")    = OW.int(oRs("parent_id"))
			V("cate_type")    = oRs("cate_type")
			V("name")         = oRs("name")
			V("subname")      = oRs("subname")
			V("root_id")      = oRs("root_id")
			V("rootpath")     = oRs("rootpath")
			V("urlpath")      = oRs("urlpath")
			V("type_cate_id") = oRs("type_cate_id")
			V("icon")         = oRs("icon")
			V("image")        = oRs("image")
			V("tpl_inherit")  = oRs("tpl_inherit")
			V("tpl_page")     = oRs("tpl_page")
			V("tpl_index")    = oRs("tpl_index")
			V("tpl_category") = oRs("tpl_category")
			V("tpl_content")  = oRs("tpl_content")
			V("seo_title")    = oRs("seo_title")
			V("keywords")     = oRs("keywords")
			V("description")  = oRs("description")
		else
			bCategoryExist = false
		end if
		OW.DB.closeRs oRs
	end function
	
	private function add(byval isSave)
		if isSave then
			call doingSave()
		else
			V("tpl_inherit") = 1
			V("parent_id")   = OW.int(OW.getForm("get","cate_id"))
			V("model_id")    = OW.int(OW.DB.getFieldValueBySQL("SELECT model_id FROM "& sCategoryTable &" WHERE cate_id="& V("parent_id") &" AND "& OW.DB.auxSQL &""))
			V("model_type")  = OW.int(OW.DB.getFieldValueBySQL("SELECT model_type FROM "& DB_PRE &"model WHERE model_id="& V("model_id") &" AND "& OW.DB.auxSQL &""))
			if not(V("parent_id")>0) then bShowAdvGrid = true
			call doing()
		end if
	end function
	
	private function edit(byval isSave)
		dim check
		check = true
		V("cate_id") = ID
		'**传递id是否正确
		if V("cate_id")<1 then check = false : call Admin.errorSetting("栏目id传递不正确")
		'**判断栏目是否存在
		if check then
			call getInfo()
			if bCategoryExist then
				V("old_parent_id") = OW.int(V("parent_id"))
			else
				check = false
				call Admin.errorSetting("对不起，内容栏目不存在")
			end if
		end if
		'**
		if check then
			if isSave then
				call doingSave()
			else
				if V("subname")<>"" then bShowAdvGrid = true
				if V("icon")<>"" or V("image")<>"" then bShowPicSet = true
				call doing()
			end if
		end if
	end function
	
	private function delete()
		dim check,i,s,id,arr,result,isSkip
		check = true
		'**接收数据
		V("ids") = OW.regReplace(OW.getForm("post","ids"),"[^0-9,]","")
		'**数据合法性校验
		if V("ids")="" then check = false : Admin.errorSetting("内容栏目id值传递不正确")
		'**从数据库删除记录
		if check then
			'**数据处理
			arr = split(V("ids"),",")
			'**delete
			for i=0 to ubound(arr)
				V("cate_id") = OW.clng(arr(i))
				if V("cate_id")>0 then
					isSkip = false
					if not(OW.DB.isRecordExistsBySQL("SELECT * FROM "& sCategoryTable &" WHERE cate_id="& V("cate_id") &" AND is_shop="& iIsShop &" AND "& OW.DB.auxSQL &"")) then
						isSkip = true
						s = s &"内容栏目不存在或已被删除，请刷新页面！(cate_id:"& V("cate_id") &");<br>"
					end if
					if not(isSkip) then
						V("name") = OW.DB.getFieldValueBySQL("SELECT name FROM "& sCategoryTable &" WHERE cate_id="& V("cate_id") &" AND is_shop="& iIsShop &" AND "& OW.DB.auxSQL &"")
						result    = deleteCategory(V("cate_id"))
						if result then
							s = s &"(cate_id:"& V("cate_id") &",name:"& V("name") &")成功内容栏目;<br>"
						else
							s = s &"(cate_id:"& V("cate_id") &",name:"& V("name") &")从数据库中删除内容栏目失败;<br>"
						end if
					end if
				end if
			next
			'**输出操作结果信息
			Admin.actionFinishSuccess     = result
			Admin.actionFinishSuccessText = array(s,"")
			Admin.actionFinishFailText    = array(s,"")
			Admin.actionFinishRun()
		end if
	end function
	
	private function deleteCategory(byval id)
		dim i,sql,path,parentId,result,isSuccess,modelTables,cateIds,cids
		result   = false
		arr      = OW.DB.getFieldValueBySQL("SELECT parent_id,path FROM "& sCategoryTable &" WHERE cate_id="& id &" AND "& OW.DB.auxSQL &"")
		parentId = OW.int(arr(0))
		path     = OW.trim(arr(1))
		if path<>"" then
			'**取得栏目及子栏目所属模型表
			sql = "SELECT (SELECT model_table FROM "& DB_PRE &"model WHERE model_id=a.model_id AND "& OW.DB.auxSQL &") as model_table FROM "& sCategoryTable &" a WHERE path like '"& path &"%' AND "& OW.DB.auxSQL &" GROUP BY model_id"
			modelTables = OW.DB.getFieldValueBySQL(sql)
			if isArray(modelTables) then modelTables = OW.join(modelTables,",")
			'**取得栏目及子栏目集合
			sql     = "SELECT cate_id FROM "& sCategoryTable &" WHERE path like '"& path &"%' AND "& OW.DB.auxSQL &""
			cateIds = OW.DB.getFieldValueBySQL(sql)
			if isArray(cateIds) then cateIds = OW.join(cateIds,",")
			result  = OW.DB.execute("DELETE FROM "& sCategoryTable &" WHERE cate_id IN ("& cateIds &") AND "& OW.DB.auxSQL &"")
			if not(result) then
			result  = OW.DB.execute("DELETE FROM "& sCategoryTable &" WHERE cate_id IN ("& cateIds &") AND "& OW.DB.auxSQL &"")
			end if
			if result then
				'**更新父栏目的子栏目数
				if parentId>0 then
					call OW.DB.execute("UPDATE "& sCategoryTable &" SET children=children-1 WHERE cate_id="& parentId &" AND "& OW.DB.auxSQL &"")
				end if
				'**
				cids = "SELECT cid FROM "& OW.DB.Table.content &" WHERE cate_id IN ("& cateIds &")"
				'**[删除]内容模型数据
				modelTables = split(modelTables,",")
				for i=0 to ubound(modelTables)
					if not(OW.isNul(modelTables(i))) then
						sContentModelTable = OW.DB.Table.content &"_"& modelTables(i)
						call OW.DB.execute("DELETE FROM "& sContentModelTable &" WHERE cid IN ("& cids &")")
					end if
				next
				call OW.DB.execute("DELETE FROM ["& DB_PRE &"attachment] WHERE cid IN ("& cids &") AND "& OW.DB.auxSQL &"")
				call OW.DB.execute("DELETE FROM ["& DB_PRE &"content_related] WHERE (cid IN ("& cids &") OR related_cid IN ("& cids &")) AND "& OW.DB.auxSQL &"")
				call OW.DB.execute("DELETE FROM ["& DB_PRE &"position_data] WHERE cid IN ("& cids &") AND "& OW.DB.auxSQL &"")
				call OW.DB.execute("DELETE FROM ["& DB_PRE &"tags_data] WHERE cid IN ("& cids &") AND "& OW.DB.auxSQL &"")
				call OW.DB.execute("DELETE FROM "& OW.DB.Table.comment &" WHERE cid IN ("& cids &") AND "& OW.DB.auxSQL &"")
				call OW.DB.execute("DELETE FROM "& OW.DB.Table.contentData &" WHERE cid IN ("& cids &")")
				call OW.DB.execute("DELETE FROM "& OW.DB.Table.content &" WHERE cate_id IN ("& cateIds &")")
			end if
		else
			result = true
		end if
		deleteCategory = result
	end function

	private function doing()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <form name="save_form" id="save_form" action="?ctl=<%=CTL%>&act=<%=ACT%>&id=<%=V("cate_id")%>&save=true" method="post">
        <div class="wbox">
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                <tr><td class="titletd">类型</td>
                    <td class="infotd">
                    <div class="labels">
                    <label><input type="radio" name="cate_type" id="cate_type_1" value="0" <%=OW.iif(V("cate_type")=0,"checked","")%> <%=OW.iif(ACT="edit","disabled","")%> />正常栏目</label>
                    <label><input type="radio" name="cate_type" id="cate_type_2" value="1" <%=OW.iif(V("cate_type")=1,"checked","")%> <%=OW.iif(ACT="edit","disabled","")%> />文件夹栏目</label>
                    <span class="t-normal ml5" name="t_cate_type">文件夹栏目是没有内容的，也不在前台栏目显示，仅作归类用。</span>
                    </div>
                    </td>
                </tr>
                <tr><td class="titletd">上级栏目</td>
                    <td class="infotd">
                    <input type="hidden" name="old_parent_id" value="<%=V("parent_id")%>" />
					<%=Admin.categoryOptions(iIsShop,"=作为一级栏目=","parent_id",V("parent_id"))%>
                    <span class="t-normal ml5" name="t_parent_id"></span>
                    </td>
                </tr>
                <tr><td class="titletd top"><i class="important">*</i>栏目名称</td>
                    <td class="infotd">
                    <input type="text" class="text text-long" name="name" maxlength="100" placeholder="输入栏目名称" value="<%=V("name")%>"/>
                    <span class="t-normal ml5" name="t_name"></span>
                    <a href="javascript:;" id="adv_btn"><%=OW.iif(bShowAdvGrid,"- 收起","+ 高级")%></a>
                    <div class="mt5" id="adv_grid" <%=OW.iif(bShowAdvGrid,"","style=""display:none;""")%>>
                        <input type="text" class="text" name="subname" maxlength="100" placeholder="栏目副名" value="<%=V("subname")%>"/>
                        <span class="t-normal ml5" name="t_subname">栏目副名可用作栏目英文名、副标题等用途，若不用可不必填写</span>
                        <div class="mt5">
                            <%=Admin.modelOptions(iIsShop,"model_id","选择内容模型 ...",V("model_id"))%>
                            <span class="t-normal ml5" name="t_model_id"></span>
                        </div>
                    </div>
                    </td>
                </tr>
                <tr name="urlpath"><td class="titletd"><i class="important">*</i>URL路径</td>
                    <td class="infotd">
                    <input type="text" class="text text-short disabled" name="url_pre" readonly="readonly" style="width:160px;" value="<%=SITE_HURL%><%=OW.iif(V("rootpath")="","",V("rootpath") &"/")%>"/><input type="text" class="text" name="urlpath" maxlength="64" style="width:192px;" placeholder="输入url路径" value="<%=V("urlpath")%>"/><input type="text" class="text text-short-mini disabled" name="url_suffix" readonly="readonly" style="width:34px;" value="<%=SITE_HTML_FILE_SUFFIX%>"/><button type="button" class="btn btn-font-normal ml5" name="create_urlpath">点击生成</button>
                    <span class="t-normal ml5" name="t_urlpath">此设置对于seo优化很有帮助</span>
                    </td>
                </tr>
                <tr><td class="titletd top">网页模板设置</td>
                    <td class="infotd">
                    <label class="mr5"><input type="checkbox" name="tpl_inherit" value="1" <%=OW.iif(V("tpl_inherit")=1,"checked","")%>/>继承上级模板设置</label><span class="t-normal ml5" name="t_model_table"></span>
                    <div class="inbox mt5" id="tpl_inherit" <%=OW.iif(V("tpl_inherit")=1,"style=""display:none;""","")%>>
                        <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                        <tbody model_type="1">
                           <tr><td class="titletd">单页模板</td>
                               <td class="infotd">
                               <%=Admin.tplOptions("tpl_page","webpage.html",V("tpl_page"))%>
                               <span class="t-normal ml5" name="t_tpl_page"></span>
                               </td>
                           </tr>
                        </tbody>
                        <tbody model_type="0">
                           <tr><td class="titletd">此栏目模板</td>
                               <td class="infotd">
                               <%=Admin.tplOptions("tpl_index","news_index.html",V("tpl_index"))%>
                               <span class="t-normal ml5" name="t_tpl_index"></span>
                               </td>
                           </tr>
                           <tr><td class="titletd">子栏目模板</td>
                               <td class="infotd">
                               <%=Admin.tplOptions("tpl_category","news_category.html",V("tpl_category"))%>
                               <span class="t-normal ml5" name="t_tpl_category"></span>
                               </td>
                           </tr>
                           <tr><td class="titletd">内容页模板</td>
                               <td class="infotd">
                               <%=Admin.tplOptions("tpl_content","news_content.html",V("tpl_content"))%>
                               <span class="t-normal ml5" name="t_tpl_content"></span>
                               </td>
                           </tr>
                        </tbody>
                        </table>
                    </div>
                    </td>
                </tr>
                <tr><td class="titletd top">图片设置</td>
                    <td class="infotd">
                    <a href="javascript:;" id="pic_set_btn"><%=OW.iif(bShowPicSet,"- 收起","+ 展开设置")%></a>
                    <div class="inbox mt5" id="pic-set" <%=OW.iif(bShowPicSet,"","style=""display:none;""")%>>
                        <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                        <tbody>
                           <tr><td class="titletd top">icon 图标</td>
                               <td class="infotd">
                               <%=Admin.createImageSelectGrid("icon",V("icon"),"","")%>
                               </td>
                           </tr>
                           <tr><td class="titletd top">栏目图片</td>
                               <td class="infotd">
                               <%=Admin.createImageSelectGrid("image",V("image"),"","")%>
                               </td>
                           </tr>
                         </tbody>
                        </table>
                    </div>
                    </td>
                </tr>
                <tr><td class="titletd top">内容类型筛选</td>
                    <td class="infotd">
                    <select name="type_cate_id">
                    <%=Admin.typeCateOptions(0,V("type_cate_id"),"请选择...")%>
                    </select>
                    <span class="t-normal ml5" name="t_type_cate_id">不选择则继承上级栏目的设置</span>
                    </td>
                </tr>
                </table>
            </div>
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                <tr><td class="titletd">SEO标题</td>
                    <td class="infotd">
                    <input type="text" class="text text-long" name="seo_title" maxlength="250" value="<%=V("seo_title")%>"/>
                    <span class="t-normal ml5" name="t_seo_title">页面的标题(title)</span>
                    </td>
                </tr>
                <tr><td class="titletd">SEO关键词<div class="font-w-normal">keywords</div></td>
                    <td class="infotd">
                    <input type="text" class="text text-long" name="keywords" maxlength="250" value="<%=V("keywords")%>"/>
                    <span class="t-normal ml5" name="t_keywords">页面的meta标签关键字</span>
                    </td>
                </tr>
                <tr><td class="titletd top">SEO描述<div class="font-w-normal">description</div></td>
                    <td class="infotd">
                    <textarea class="textarea" name="description" maxlength="250"><%=V("description")%></textarea>
                    <span class="t-normal ml5" name="t_description">页面的meta标签描述</span>
                    </td>
                </tr>
                </table>
            </div>
        </div>
        <div class="button-container">
            <button type="submit" class="btn btn-large btn-primary" name="submit">确定保存</button>
            <button type="reset" class="btn btn-large" name="reset">重置</button>
            <button type="button" class="btn btn-large" name="close" onClick="OW.goBack();">关闭</button>
        </div>
        </form>
    </div>
    <script type="text/javascript">
	$(document).ready(function(){
		//提交保存数据
		var $saveForm = $("#save_form");
		$saveForm.submit(function(){
			var check = true;
			OW.parseFormInputValue({form:$saveForm});
			if(!V.select({me:$("select[name='model_id']"),tip:$("span[name='t_model_id']"),okValue:'',errorValue:'请先选择内容模型'})){
				check=false;
				if($("#adv_grid").css("display")=="none"){
					$("#adv_grid").show("fast");$("#adv_btn").html("- 收起");
				};
			};
			if(!$("input[name='cate_type']:checked").val()!="0"){
				if(!V.input({me:$("input[name='urlpath']"),tip:$("span[name='t_urlpath']"),okValue:'',errorValue:'请先填写URL路径'})){check=false;};
			};
			if(!V.input({me:$("input[name='name']"),tip:$("span[name='t_name']"),okValue:'',errorValue:'请先填写栏目表名'})){check=false;};
			if(check){Admin.dialogPosting();};
			return check;
		});
		//**
		var $advBtn      = $("#adv_btn");
		var $advGrid     = $("#adv_grid");
		var $modelSelect = $("select[name='model_id']");
		var modelType    = "<%=V("model_type")%>";
		var parentId     = "<%=V("parent_id")%>";
		var $parentId    = $("select[name='parent_id']");
		//**
		$("input[name='cate_type']").click(function(){
			if(parseInt($(this).val())==1){
				$("tr[name='urlpath']").hide("fast");
			}else{
				$("tr[name='urlpath']").show("fast");
			};
		});
		$parentId.change(function(){
			var siteUrl = "<%=SITE_URL%>",
			cateType    = parseInt($(this).find("option:selected").attr("cate_type")),
			modelType   = parseInt($(this).find("option:selected").attr("model_type")),
			urlpath     = $(this).find("option:selected").attr("urlpath"),
			rootpath    = $(this).find("option:selected").attr("rootpath"),
			$urlPre     = $("input[name='url_pre']"),
			parentId    = parseInt($(this).find("option:selected").val()),
			modelId     = parseInt($(this).find("option:selected").attr("model_id"));
			//alert(rootpath);
			if($advGrid.css("display")=="none"){
				$advGrid.show("fast");
				$advBtn.html("- 收起");
			};
			if(ACT=="add"){
				$modelSelect.find("option[value='"+ modelId +"']").attr("selected",true);
				modelChange(parseInt($modelSelect.find("option:selected").attr("model_type")));
			};
			if(OW.isNull(rootpath)){
				if(cateType==0 && modelType==0){
					$urlPre.val(siteUrl + urlpath +"/");
				}else{
					$urlPre.val(siteUrl);
				};
			}else{
				$urlPre.val(siteUrl + rootpath +"/");
			};
		});
		//**模型显示
		function modelChange(model_type){
			if(!(model_type>=0)){model_type=0};
			if(model_type==1){
				$("tbody[model_type='1']").show();
				$("tbody[model_type='0']").hide();
				$("input[name='url_suffix']").show();
			}else{
				$("tbody[model_type='0']").show();
				$("tbody[model_type='1']").hide();
				$("input[name='url_suffix']").hide();
			};
		};
		modelChange(parseInt(modelType));
		//**
		if(ACT=="add"){
			$modelSelect.change(function(){
				var model_type = parseInt($(this).find("option:selected").attr("model_type"));
				modelChange(model_type);
			});
		};
		if(ACT=="edit"){
			$modelSelect.attr("disabled",true).addClass("disabled");
		};
		//**高级
		$advBtn.click(function(){
			if($advGrid.css("display")=="none"){
				$advGrid.show("fast");$(this).html("- 收起");
			}else{
				$advGrid.hide("fast");$(this).html("+ 高级");
			};
		});
		//**模板设置
		$("input[name='tpl_inherit']").click(function(){
			if($(this).attr("checked")==true){
				$("#tpl_inherit").hide("fast");
			}else{
				$("#tpl_inherit").show("fast");
			}
		});
		//**图片设置
		var $picSet = $("#pic-set");
		$("#pic_set_btn").click(function(){
			if($picSet.css("display")=="none"){
				$picSet.show("fast");$(this).html("- 收起");
			}else{
				$picSet.hide("fast");$(this).html("+ 展开设置");
			};
		});
		//**点击生成URL路径
		$("button[name='create_urlpath']").click(function(){
			Admin.createUrlPath({
				urlpath:$("input[name='urlpath']"),
				string:$("input[name='name']").val()
			});
		});
	});
    </script>
    <%
		call Admin.echoFooter()
	end function
	
	private function doingSave()
		dim rs,check,result
		'**数据库初始化
		check = true
		'**接收数据
		V("model_id")    = OW.int(OW.getForm("post","model_id"))
		V("parent_id")   = OW.int(OW.getForm("post","parent_id"))
		V("cate_type")   = OW.int(OW.getForm("post","cate_type"))
		V("name")        = OW.validDBData(OW.getForm("post","name"),250)
		V("subname")     = OW.validDBData(OW.getForm("post","subname"),250)
		V("urlpath")     = OW.validDBData(Admin.urlpath(),50)
		V("type_cate_id")= OW.int(OW.getForm("post","type_cate_id"))
		V("tpl_page")    = OW.validDBData(OW.getForm("post","tpl_page"),50)
		V("tpl_index")   = OW.validDBData(OW.getForm("post","tpl_index"),50)
		V("tpl_category")= OW.validDBData(OW.getForm("post","tpl_category"),50)
		V("tpl_content") = OW.validDBData(OW.getForm("post","tpl_content"),50)
		V("icon")        = OW.validDBData(OW.getForm("post","icon"),255)
		V("image")       = OW.validDBData(OW.getForm("post","image"),255)
		V("tpl_inherit") = OW.int(OW.getForm("post","tpl_inherit"))
		V("seo_title")   = OW.validDBData(OW.getForm("post","seo_title"),250)
		V("keywords")    = OW.validDBData(OW.getForm("post","keywords"),250)
		V("description") = OW.validDBData(OW.getForm("post","description"),250)
		'**数据处理
		'**数据合法性校验
		if ACT="add" then
			if V("model_id")>0 then
				if not OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"model WHERE model_id="& V("model_id") &" AND "& OW.DB.auxSQL &"") then
				check = false : Admin.errorSetting("模型id值不正确")
				end if
			else
				check = false : Admin.errorSetting("模型id值不正确")
			end if
			if check then
			V("model_type") = OW.int(OW.DB.getFieldValueBySQL("SELECT model_type FROM "& DB_PRE &"model WHERE model_id="& V("model_id") &" AND "& OW.DB.auxSQL &""))
			end if
		end if
		'**不允许移动到自身的子栏目下
		if ACT="edit" and V("parent_id")<>V("old_parent_id") AND V("parent_id")>0 then
			if moveCategoryCheck(V("cate_id"),V("parent_id"))=false then check = false : Admin.errorSetting("不允许选择自身的子栏目为上级栏目")
		end if
		if V("parent_id")>0 then
			if not OW.DB.isRecordExistsBySQL("SELECT * FROM "& sCategoryTable &" WHERE cate_id="& V("parent_id") &" AND is_shop="& iIsShop &" AND "& OW.DB.auxSQL &"") then check = false : Admin.errorSetting("上级栏目id值不正确")
		end if
		'**判断其他必填项
		if not Admin.validate("s",V("name"),"minLength:1,maxLength:0","必须填写栏目名称") then check = false
		if ACT = "edit" then
			V("cate_type") = OW.int(OW.DB.getFieldValueBySQL("SELECT cate_type FROM "& sCategoryTable &" WHERE cate_id="& V("cate_id") &" AND "& OW.DB.auxSQL &""))
		end if
		if V("cate_type")=0 then
			if not Admin.validate("s",V("urlpath"),"minLength:1,maxLength:0","必须填写URL路径") then check = false
		else
			V("urlpath") = ""
		end if
		'**判断URL路径是否正确
		if V("urlpath")<>"" then
			V("root_id") = OW.int(OW.DB.getFieldValueBySQL("SELECT root_id FROM "& sCategoryTable &" WHERE parent_id="& V("parent_id") &" AND "& OW.DB.auxSQL &""))
			if ACT = "add" then
				if OW.DB.isRecordExistsBySQL("SELECT * FROM "& sCategoryTable &" WHERE root_id="& V("root_id") &" AND urlpath='"& V("urlpath") &"' AND "& OW.DB.auxSQL &"") then check = false : Admin.errorSetting(replace("URL路径 {$urlpath} 已被其他栏目使用，请返回修改","{$urlpath}",V("urlpath")))
			elseif ACT = "edit" then
				if OW.DB.isRecordExistsBySQL("SELECT * FROM "& sCategoryTable &" WHERE root_id="& V("root_id") &" AND cate_id<>"& V("parent_id") &" AND cate_id<>"& V("cate_id") &" AND urlpath='"& V("urlpath") &"' AND "& OW.DB.auxSQL &"") then check = false : Admin.errorSetting(replace("URL路径 {$urlpath} 已被其他栏目使用，请返回修改","{$urlpath}",V("urlpath")))
			end if
		end if
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			if ACT = "add" then
				'**add
				V("cate_id")  = OW.DB.maxID(sCategoryTable,"cate_id") + 1
				V("sequence") = OW.int(OW.DB.getFieldValueBySQL("SELECT max(sequence) FROM "& sCategoryTable &" WHERE parent_id="& V("parent_id") &" AND is_shop="& iIsShop &" AND "& OW.DB.auxSQL &"")) + 1
				if V("parent_id")>0 then
					V("path") = OW.DB.getFieldValueBySQL("SELECT path FROM "& sCategoryTable &" WHERE cate_id="& V("parent_id") &" AND "& OW.DB.auxSQL &"")
					V("path") = V("path") & V("cate_id") &","
				else
					V("path") = ","& V("cate_id") &","
				end if
				V("depth") = ubound(split(V("path"),",")) - 1
				'**
				bResult = categoryDataAdd()
				'**
				Admin.actionFinishSuccess     = bResult
				Admin.actionFinishSuccessText = array("成功添加内容栏目："& V("name"),array("返回列表>index.asp?ctl="& CTL &"&act=list","继续添加>index.asp?ctl="& CTL &"&act="& ACT &"&cate_id="& V("parent_id") &""))
				Admin.actionFinishFailText    = array("添加内容栏目失败："& V("name"),array("返回列表>index.asp?ctl="& CTL &"&act=list","继续添加>index.asp?ctl="& CTL &"&act="& ACT &"&cate_id="& V("parent_id") &""))
				Admin.actionFinishAuxHtml     = "<script type=""text/javascript"">$(document).ready(function(){parent.getLeftpannelHtml();});</script>"
				Admin.actionFinishRun()
			elseif ACT = "edit" then
				'**
				V("old_root_id") = OW.int(Admin.getCategoryRoot(V("cate_id"))(0))
				'**edit
				if V("old_parent_id")<>V("parent_id") then
					if V("parent_id")>0 then
						V("path")  = OW.DB.getFieldValueBySQL("SELECT path FROM "& sCategoryTable &" WHERE cate_id="& V("parent_id") &" AND "& OW.DB.auxSQL &"")
						V("path")  = V("path") & V("cate_id") &","
					else
						V("path")  = ","& V("cate_id") &","
					end if
					V("depth") = ubound(split(V("path"),",")) - 1
				end if
				'**
				bResult = categoryDataUpdate()
				'**
				Admin.actionFinishSuccess     = bResult
				Admin.actionFinishSuccessText = array("成功编辑内容栏目(栏目id:"& V("cate_id") &",栏目名称:"& V("name") &")","?ctl="& CTL &"&act=list")
				Admin.actionFinishFailText    = array("编辑内容栏目失败(栏目id:"& V("cate_id") &",栏目名称:"& V("name") &")","")
				Admin.actionFinishAuxHtml     = "<script type=""text/javascript"">$(document).ready(function(){parent.getLeftpannelHtml();});</script>"
				Admin.actionFinishRun()
			end if
		end if
		
	end function
	
	private function categoryDataAdd()
		dim arr
		arr = array("site_id:"& SITE_ID,"cate_id:"& V("cate_id"),"model_id:"& V("model_id"),"model_type:"& V("model_type"),"is_shop:"& iIsShop,"sequence:"& V("sequence"),"status:0","parent_id:"& V("parent_id"),"path:"& V("path"),"depth:"& V("depth"),"children:0","cate_type:"& V("cate_type"),"name:"& V("name"),"subname:"& V("subname"),"urlpath:"& V("urlpath"),"type_cate_id:"& V("type_cate_id"),"icon:"& V("icon"),"image:"& V("image"),"tpl_inherit:"& V("tpl_inherit"),"tpl_page:"& V("tpl_page"),"tpl_index:"& V("tpl_index"),"tpl_category:"& V("tpl_category"),"tpl_content:"& V("tpl_content"),"seo_title:"& V("seo_title"),"keywords:"& V("keywords"),"description:"& V("description"))
		bResult = OW.DB.addRecord(sCategoryTable,arr)
		if bResult then
			'**更新上级栏目的children
			if V("parent_id")>0 then
				call OW.DB.execute("UPDATE "& sCategoryTable &" SET children=children+1 WHERE cate_id="& V("parent_id") &" AND "& OW.DB.auxSQL &"")
			end if
			'**如果是单页栏目则更新单页内容
			if V("model_type")=1 then
				call categoryContentUpdate()
			end if
			'**
			call categoryRootpathUpdate(V("cate_id"))
			call theSameUrlpathUpdate(V("cate_id"))
		end if
		categoryDataAdd = bResult
	end function
	
	private function categoryDataUpdate()
		dim arr
		arr = array("parent_id:"& V("parent_id"),"name:"& V("name"),"subname:"& V("subname"),"urlpath:"& V("urlpath"),"type_cate_id:"& V("type_cate_id"),"icon:"& V("icon"),"image:"& V("image"),"tpl_inherit:"& V("tpl_inherit"),"tpl_page:"& V("tpl_page"),"tpl_index:"& V("tpl_index"),"tpl_category:"& V("tpl_category"),"tpl_content:"& V("tpl_content"),"seo_title:"& V("seo_title"),"keywords:"& V("keywords"),"description:"& V("description"))
		bResult =  OW.DB.updateRecord(sCategoryTable,arr,array("cate_id:"& V("cate_id")))
		if bResult then
			'**
			if V("old_parent_id")<>V("parent_id") then
				call OW.DB.updateRecord(sCategoryTable,array("path:"& V("path"),"depth:"& V("depth")),array("cate_id:"& V("cate_id")))
				'**更新原上级的数据
				if V("old_parent_id")>0 then
					call OW.DB.execute("UPDATE "& sCategoryTable &" SET children=children-1 WHERE cate_id="& V("old_parent_id") &" AND "& OW.DB.auxSQL &"")
				end if
				'**更新上级的数据
				if V("parent_id")>0 then
					call OW.DB.execute("UPDATE "& sCategoryTable &" SET children=children+1 WHERE cate_id="& V("parent_id") &" AND "& OW.DB.auxSQL &"")
				end if
				'**更新子栏目的数据
				call subCategoryPathDepthEdit(V("cate_id"),V("path"))
			end if
			'**如果是单页栏目则更新单页内容
			if V("model_type")=1 then
				call categoryContentUpdate()
			end if
			'**
			call categoryRootpathUpdate(V("cate_id"))
			call theSameUrlpathUpdate(V("cate_id"))
			call contentRootpathUpdate(V("cate_id"))
			'**导航与栏目同步
			call Admin.navigatorSyncDoing(V("cate_id"))
		end if
		categoryDataUpdate = bResult
	end function
	
	private function categoryContentUpdate()
		dim arr1,arr2
		if OW.int(OW.DB.getFieldValueBySQL("SELECT count(*) FROM "& OW.DB.Table.content &" WHERE cate_id="& V("cate_id") &""))<1 then
			'**[增加]内容主表
			arr1 = array("cate_id:"& V("cate_id"),"sequence:0","status:0","title:"& V("name"),"subtitle:"& V("subname"),"urlpath:"& V("urlpath"),"views:0","post_time:"& SYS_TIME,"update_time:"& SYS_TIME,"recommend:0")
			call OW.DB.addRecord(OW.DB.Table.content,arr1)
			V("cid") = OW.DB.maxCID()
			'**[增加]内容详细表
			arr2 = array("cid:"& V("cid"),"seo_title:"& V("seo_title"),"keywords:"& V("keywords"),"description:"& V("description"),"content:")
			call OW.DB.addRecord(OW.DB.Table.contentData,arr2)
			'**[增加]内容模型数据表
			sContentModelTable = Admin.getModelTable(V("cate_id"),"content")
			call OW.DB.addRecord(sContentModelTable,array("cid:"& V("cid")))
		else
			V("cid") = OW.DB.getFieldValueBySQL("SELECT cid FROM "& OW.DB.Table.content &" WHERE cate_id="& V("cate_id") &"")
			'**[更新]内容主表
			arr1 = array("title:"& V("name"),"subtitle:"& V("subname"),"urlpath:"& V("urlpath"),"update_time:"& SYS_TIME)
			OW.DB.auxSQLValid = false
			call OW.DB.updateRecord(OW.DB.Table.content,arr1,array("cid:"& V("cid")))
			OW.DB.auxSQLValid = true
			'**[更新]内容详细表
			arr2 = array("seo_title:"& V("seo_title"),"keywords:"& V("keywords"),"description:"& V("description"))
			OW.DB.auxSQLValid = false
			call OW.DB.updateRecord(OW.DB.Table.contentData,arr2,array("cid:"& V("cid")))
			OW.DB.auxSQLValid = true
		end if
	end function
	
	private function moveCategoryCheck(byval cate_id,byval parent_id)
		dim i,id,arr,rs,sql,ok,errCheck
		errCheck  = false
		cate_id   = OW.int(cate_id)
		parent_id = Ow.int(parent_id)
		if cate_id=parent_id then
			errCheck = true
		else
			sql = "SELECT path FROM "& sCategoryTable &" WHERE path like '%,"& cate_id &",%' AND cate_id<>"& cate_id &" AND "& OW.DB.auxSQL &""
			set rs = OW.DB.getRecordBySQL(sql)
			do while not rs.eof
				arr = split(rs("path"),",")
				if errCheck=false then
					for i=0 to ubound(arr)
						id = OW.int(arr(i))
						if id>0 then
							if cate_id = id then ok = true
							if ok=true then
								if parent_id = id then
									errCheck = true
									exit for
								end if
							end if
						end if
					next
				end if
				rs.movenext
			loop
			OW.DB.closeRs rs
		end if
		if errCheck then
			moveCategoryCheck = false
		else
			moveCategoryCheck = true
		end if
	end function
	
	private function subCategoryPathDepthEdit(byval cate_id,byval path)
		dim i,id,arr,rs,sql,ok,tmpPath,tmpDepth
		sql = "SELECT cate_id,path,depth FROM "& sCategoryTable &" WHERE path like '%,"& cate_id &",%' AND cate_id<>"& cate_id &" AND "& OW.DB.auxSQL &""
		set rs = OW.DB.getRecordBySQL(sql)
		do while not rs.eof
			id      = rs("cate_id")
			arr     = split(rs("path"),",")
			ok      = false
			tmpPath = path
			for i=0 to ubound(arr)
				if trim(arr(i))<>"" then
					if ok=true then tmpPath = tmpPath & arr(i) &","
					if OW.int(cate_id)=OW.int(arr(i)) then ok = true
				end if
			next
			tmpDepth = ubound(split(tmpPath,",")) - 1
			call OW.DB.execute("UPDATE ["& sCategoryTable &"] SET path='"& tmpPath &"',depth="& tmpDepth &" WHERE cate_id="& id &" AND "& OW.DB.auxSQL &"")
			rs.movenext
		loop
		OW.DB.closeRs rs
	end function
	
	private function categoryRootpathUpdate(byval cateId)
		dim a,arr,i,rootId,rootpath,rs,sql,modelType,cateType,catePath
		dim path
		path     = OW.DB.getFieldValueBySQL("SELECT path FROM "& sCategoryTable &" WHERE cate_id="& cateId &" AND "& OW.DB.auxSQL &"")
		sql      = "SELECT cate_id,model_type,cate_type,path FROM "& sCategoryTable &" WHERE path like '%"& path &"%' AND "& OW.DB.auxSQL &""
		rootId   = 0
		rootpath = ""
		set rs = OW.DB.getRecordBySQL(sql)
		do while not rs.eof
			cateId    = OW.int(rs("cate_id"))
			modelType = OW.int(rs("model_type"))
			cateType  = OW.int(rs("cate_type"))
			catePath  = OW.rs(rs("path"))
			if modelType=1 then
				call OW.DB.execute("UPDATE ["& sCategoryTable &"] SET root_id=0,rootpath='' WHERE cate_id="& cateId &" AND "& OW.DB.auxSQL &"")
			else
				if rootId=0 then
					arr = split(catePath,",")
					for i=0 to ubound(arr)
						if OW.int(arr(i))>0 then
							a = OW.DB.getFieldValueBySQL("SELECT model_type,cate_type,cate_id,urlpath FROM "& sCategoryTable &" WHERE cate_id="& arr(i) &" AND "& OW.DB.auxSQL &"")
							if OW.int(a(0))=0 and OW.int(a(1))=0 then
								rootId   = OW.int(a(2))
								rootpath = a(3)
								exit for
							end if
						end if
					next
				end if
				if cateId=rootId then
					call OW.DB.execute("UPDATE ["& sCategoryTable &"] SET root_id=0,rootpath='' WHERE cate_id="& cateId &" AND "& OW.DB.auxSQL &"")
				else
					call OW.DB.execute("UPDATE ["& sCategoryTable &"] SET root_id="& rootId &",rootpath='"& rootpath &"' WHERE cate_id="& cateId &" AND "& OW.DB.auxSQL &"")
				end if
			end if
			rs.movenext
		loop
		OW.DB.closeRs rs
		if ubound(split(path,","))=2 then
			call OW.DB.execute("UPDATE ["& sCategoryTable &"] SET root_id=0,rootpath='' WHERE path='"& path &"' AND "& OW.DB.auxSQL &"")
		end if
	end function
	
	private function theSameUrlpathUpdate(byval cateId)
		dim a,arr,i,rootId,rootpath,rs,sql
		dim path
		path     = OW.DB.getFieldValueBySQL("SELECT path FROM "& sCategoryTable &" WHERE cate_id="& cateId &" AND "& OW.DB.auxSQL &"")
		rootId   = 0
		rootpath = ""
		if rootId=0 then
			arr = split(path,",")
			for i=0 to ubound(arr)
				if OW.int(arr(i))>0 then
					a = OW.DB.getFieldValueBySQL("SELECT model_type,cate_type,cate_id,urlpath FROM "& sCategoryTable &" WHERE cate_id="& arr(i) &" AND "& OW.DB.auxSQL &"")
					if OW.int(a(0))=0 and OW.int(a(1))=0 then
						rootId   = OW.int(a(2))
						rootpath = a(3)
						exit for
					end if
				end if
			next
		end if
		if rootId>0 then
			sql = "SELECT cate_id,model_type,path,urlpath FROM "& sCategoryTable &" WHERE root_id="& rootId &" AND "& OW.DB.auxSQL &""
			set rs = OW.DB.getRecordBySQL(sql)
			do while not rs.eof
				cateId = rs("cate_id")
				if OW.int(rs("model_type"))=0 then
					if OW.DB.isRecordExistsBySQL("SELECT * FROM "& sCategoryTable &" WHERE root_id="& rootId &" AND cate_id<>"& rs("cate_id") &" AND urlpath='"& rs("urlpath") &"' AND "& OW.DB.auxSQL &"") then
						call OW.DB.execute("UPDATE ["& sCategoryTable &"] SET urlpath='"& rs("urlpath") &"-"& rs("cate_id") &"' WHERE cate_id="& rs("cate_id")&" AND "& OW.DB.auxSQL &"")
					end if
				end if
				rs.movenext
			loop
			OW.DB.closeRs rs
		end if
	end function
	
	private function contentRootpathUpdate(byval cateId)
		dim arr,rootId,rootpath
		arr      = Admin.getCategoryRoot(cateId)
		rootId   = OW.int(arr(0))
		rootpath = arr(1)
		if V("old_root_id")>0 then
			call OW.DB.execute("UPDATE ["& OW.DB.Table.content &"] SET root_id="& rootId &",rootpath='"& rootpath &"' WHERE root_id="& V("old_root_id") &"")
			call OW.DB.execute("UPDATE ["& OW.DB.Table.content &"] SET root_id="& rootId &",rootpath='"& rootpath &"' WHERE cate_id IN(SELECT cate_id FROM "& sCategoryTable &" WHERE path like '%,"& cateId &",%' AND "& OW.DB.auxSQL &") AND root_id IS NULL")
			call OW.DB.execute("UPDATE ["& OW.DB.Table.content &"] SET urlpath=cid WHERE urlpath IS NULL")
		end if
	end function
	
	private function list()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <style type="text/css">
	table.listTable tr.data td{
		border-left:1px solid #f2f2f2;
		border-top:1px solid #f2f2f2;
	}
    </style>
    <div class="mbody">
        <div class="top-area">
            <table cellspacing="0" cellpadding="0" border="0">
              <tbody>
              <tr>
              <td class="do-cell">
                  <div class="do-cell-name">添加操作区</div>
                  <div class="do-cell-btn"><a class="btn btn-primary" id="add_new" href="index.asp?ctl=<%=CTL%>&act=add">添加栏目</a></div>
              </td>
              <td class="do-cell">
                  <div class="do-cell-name">删除操作区</div>
                  <div class="do-cell-btn"><button class="btn" id="delete_selected">批量删除</button></div>
              </td>
              <td class="do-cell">
                  <div class="do-cell-name text-left">系统提示</div>
                  <div class="do-cell-btn">排序只在同一父类下的同级间比较，数字越小越靠前。</div>
              </td>
              </tr>
              </tbody>
            </table>
        </div>
        <div class="category-list">
        <div class="list-area" id="data_list_area">
            <table border="0" cellpadding="0" cellspacing="0" width="100%" class="listTable">
              <thead>
                  <tr class="thead">
                      <th><input type="checkbox" name="select_all" id="select_all"></th>
                      <th>栏目id</th>
                      <th>栏目</th>
                      <th>根URL路径</th>
                      <th>URL路径</th>
                      <th>内容模型</th>
                      <th>类型</th>
                      <th>模板设置</th>
                      <th>状态</th>
                      <th>排序</th>
                      <th>操作</th>
                  </tr>
              </thead>
              <%=listing(0)%>
            </table>
        </div>
        </div>
    </div>
    <script type="text/javascript">
    $(window).ready(function(){
		Admin.categoryDeleting = true;
		Admin.dataListTableInit({
			ctl:"<%=CTL%>",
			act_edit:"edit",
			field_name:"name",
			status_validValue:"正常",
			status_validTitle:"点击可设置为隐藏状态",
			status_invalidValue:'隐藏',
			status_invalidTitle:'点击可设置为正常状态',
			delete_confirm:"删除后栏目及其下的所有内容数据将被删除，无法恢复，您确定要删除吗？",
			delete_confirm2:"删除后栏目{tpl:name}及其下的所有内容数据将被删除，无法恢复，您确定要删除吗？",
			delete_doing:"正在删除栏目...",
			delete_success:"删除成功",
			delete_failed:"删除操作失败",
			delete_tip:"请先选择您要删除的栏目",
			delete_success_callback:function(id){
				$("tr.data[root_id="+id+"]").remove();
				parent.getLeftpannelHtml();
			},
		});
		OW.cookie.setCookie('leftmenutype','1');
		parent.getLeftpannelHtml();
		//**点击展开/收起
		$("span[name='node-switch'][children_count=0]").addClass("none-children");
		$("span[name='node-switch']").click(function(){
			var cate_id = $(this).attr("cate_id"); 
			var $tr     = $("tr[root_id='"+cate_id+"']:not([pid=0])");
			if($(this).attr("type")=="close"){
				$tr.show();
				$(this).removeClass("close").addClass("open").attr("type","open");
			}else{
				$tr.hide();
				$(this).removeClass("open").addClass("close").attr("type","close");
			};
		});
		//**
		$("span[name='node-switch']").click();
		//**链接
		$("#data_list_area td[field='name']").each(function(){
			var $rootpath = $(this).parent().find("td[field='rootpath']"),
			     rootpath = $rootpath.attr("value"),
			    $urlpath  = $(this).parent().find("td[field='urlpath']"),
				modelType = $(this).parent().find("td[field='model_name']").attr("model_type"),
				$span     = $(this).find("span.name"),
				suffix    = "<%=SITE_HTML_FILE_SUFFIX%>";
			if($urlpath.attr("value")!=""){
				if(modelType=="0"){
					if(rootpath==""){
						url = "<%=OW.urlRewrite("c1")%>";
					}else{
						url = "<%=OW.urlRewrite("c3")%>";
						url = url.replace("{$rootpath}",$rootpath.attr("value"));
					};
				}else{
					url = "<%=OW.urlRewrite("c5")%>";
				};
				url = url.replace("{$urlpath}",$urlpath.attr("value"));
				$span.html('<a href="'+url+'" target="_blank">'+$span.html()+'</a>');
			};
		});
		//**内容模型
		$("#data_list_area td[field='model_name']").each(function(){
			if($(this).attr("value")=="单页模型"){
				$(this).html('<font class="model-type-1">'+$(this).attr("value")+'<font>');
			}else{
				$(this).html('<font class="model-type-0">'+$(this).attr("value")+'<font>');
			};
		});
		//**
		//**栏目类型
		$("#data_list_area td[field='cate_type']").each(function(){
			if($(this).attr("value")==0){
				$(this).html('<font class="cate-type-0">普通栏目<font>');
			}else{
				$(this).html('<font class="cate-type-1">文件夹<font>');
			};
		});
		//**
		//**模板设置
		$("#data_list_area td[field='tpl_inherit']").each(function(){
			if($(this).attr("value")==0){
				$(this).html('<font class="tpl-inherit-0">自定<font>');
			}else{
				$(this).html('<font class="tpl-inherit-1">继承<font>');
			};
		});
		//**
		//**添加子栏目
		$("#data_list_area a[name='add_subcate']").click(function(){
			$(this).attr("href","?ctl="+CTL+"&act=add&cate_id="+$(this).parent().parent().attr("value"));
		});
		//**
	});
    </script>
	<%
		call Admin.echoFooter()
	end function
	
	private function listing(byval parentId)
		dim cols,sql,ope
		dim cateId,path,depth,children,cateName
		dim i,s,rs,html,htmls,colspan
		'**
		cols = "cate_id,name,subname,cate_type,rootpath,urlpath,status,sequence,children,parent_id,path,depth,model_type,(SELECT model_name FROM "& DB_PRE &"model WHERE model_id=a.model_id AND "& OW.DB.auxSQL &") as model_name,tpl_inherit"
		sql  = "SELECT "& cols &" FROM "& sCategoryTable &" a WHERE is_shop="& iIsShop &" AND parent_id="& parentId &" AND "& OW.DB.auxSQL &" ORDER BY sequence ASC"
		'**
		ope = "<a class=""btn btn-small btn-primary mr5"" name=""edit"" href=""javascript:;"">编辑</a><a class=""btn btn-small mr5"" name=""add_subcate"" href=""javascript:;"">添加子栏目</a><a class=""btn btn-small"" name=""delete"" href=""javascript:;"">删除</a>"
		
		'**
		colspan = ubound(split(cols,","))+1
		'**
		set rs = OW.DB.GetRecordBySQL(sql)
		if rs.bof and rs.eof then
			html = "<tr><td colspan="""& colspan &""">暂无数据 ...</td></tr>"
		else
			do while not rs.eof
				s        = ""
				cateId   = rs("cate_id")
				path     = rs("path")
				depth    = OW.int(rs("depth"))
				children = OW.int(rs("children"))
				cateName = rs("name")
				'**
				s = s &"<td><input type=""checkbox"" name=""data-checkbox""></td>"
				s = s &"<td field=""cate_id"" value="""& cateId &""">"& cateId &"</td>"
				s = s &"<td field=""name"" value="""& cateName &""">"
				
				if depth=1 then
					s = s &"<span class=""node-switch open"" name=""node-switch"" cate_id="""& cateId &""" children_count="""& children &"""></span>"
				else
					for i=2 to depth
						if i=2 then
							s = s &""
						else
							s = s &"<span class=""blank-space""></span>"
						end if
					next
					s = s &"<span class=""node-sub-indent""></span>"
				end if
				
				s = s &"<span class=""name"">"& OW.iif(depth=1,"<b>"& cateName &"</b>",cateName) &"</span><span class=""subname"">"& rs("subname") &"</span>"
				
				s = s &"</td>"
				s = s &"<td field=""rootpath"" value="""& rs("rootpath") &""">"& rs("rootpath") &"</td>"
				s = s &"<td field=""urlpath"" value="""& rs("urlpath") &""">"& rs("urlpath") &"</td>"
				s = s &"<td field=""model_name"" model_type="""& rs("model_type") &""" value="""& rs("model_name") &""">"& rs("model_name") &"</td>"
				s = s &"<td field=""cate_type"" value="""& rs("cate_type") &""">"& rs("cate_type") &"</td>"
				s = s &"<td field=""tpl_inherit"" value="""& rs("tpl_inherit") &""">"& rs("tpl_inherit") &"</td>"
				s = s &"<td field=""status"" value="""& rs("status") &""">"& rs("status") &"</td>"
				s = s &"<td field=""sequence"" value="""& rs("sequence") &""">"& rs("sequence") &"</td>"
				s = s &"<td name=""opeation"">"& ope &"</td>"
				'**
				html = html &"<tr class=""data"" root_id="""& split(path,",")(1) &""" pid="""& parentId &""">"& s &"</tr>"
				'**
				if children>0 then
					html = html & listing(cateId)
				end if
				rs.movenext
			loop
		end if
		set rs = nothing
		'**
		listing = html
	end function

end class
%>