<%
'**
'站点管理
'**
dim AP_FEEDBACK
class AP_FEEDBACK_CLASS
	
	private aArr,oRs,iI,sString,bResult
	private linksTable
	
	private sub class_initialize()
		linksTable = DB_PRE &"links"
	end sub
	
	public sub init()
		if CTL="links" then
			select case ACT
			case "list"
				call list()
			case "add"
				call add(SAVE)
			case "edit"
				if SUBACT = "status_edit" then
					if SAVE then
						bAuxSQLValid = true
						call Admin.statusEdit(linksTable,"link_id",auxSQLValid,array("成功更改友情链接状态","无法更新数据库，友情链接状态更改失败！"))
					end if
				elseif SUBACT = "sequence_edit" then
					if SAVE then
						bAuxSQLValid = true
						call Admin.sequenceEdit(linksTable,"link_id",bAuxSQLValid,array("成功进行友情链接排序","无法更新数据库，友情链接排序失败！"))
					end if
				else
					call edit(SAVE)
				end if
			case "delete"
				call delete()
			end select
		end if
	end sub
	
	private sub class_terminate()
	end sub
	
	private function getLinkDetail()
		arr = OW.DB.getRecordBySQL("SELECT cate_id,name,logo,url FROM "& linksTable &" WHERE link_id="& V("link_id") &" AND "& OW.DB.auxSQL &"")
		V("cate_id") = OW.int(arr(0))
		V("name")    = arr(1)
		V("logo")    = arr(2)
		V("url")     = arr(3)
	end function
	
	private function add(byval isSave)
		if isSave then
			call doingSave()
		else
			call doing()
		end if
	end function
	
	private function edit(byval isSave)
		V("link_id") = ID
		'**传递id是否正确
		if V("link_id")<1 then
			call Admin.errorSetting("link_id传递不正确"&"(link_id: "& V("link_id") &")"&"<br>")
			exit function
		end if
		'**判断记录是否存在
		if not(OW.DB.isRecordExistsBySQL("SELECT * FROM "& linksTable &" WHERE link_id="& V("link_id") &" AND "& OW.DB.auxSQL &"")) then
			Admin.errorSetting("友情链接不存在"&"(link_id: "& V("link_id") &")"&"<br>")
			exit function
		end if
		'**
		if isSave then
			call doingSave()
		else
			call getLinkDetail()
			call doing()
		end if
	end function
	
	private function delete()
		dim check : check = true
		'**接收数据
		V("ids") = OW.regReplace(OW.getForm("post","ids"),"[^0-9,]","")
		aArr     = split(V("ids"),",")
		'**
		if V("ids")="" then check = false : Admin.errorSetting("link_id传递不正确")
		'**从数据库删除记录
		if check then
			for iI=0 to ubound(aArr)
				call deleteLinkData(OW.int(aArr(iI)))
			next
			'**输出操作结果信息
			Admin.actionFinishSuccess     = true
			Admin.actionFinishSuccessText = array(V("delete_action_text"),"")
			Admin.actionFinishFailText    = array(V("delete_action_text"),"")
			Admin.actionFinishRun()
		end if
	end function
	
	private function deleteLinkData(byval id)
		dim result : result = true
		if id<=0 then
			deleteLinkData = false
			exit function
		end if
		'**
		if not(OW.DB.isRecordExistsBySQL("SELECT * FROM "& linksTable &" WHERE link_id="& id &" AND "& OW.DB.auxSQL &"")) then
			V("delete_action_text") = V("delete_action_text") &"友情链接不存在或已被删除"&"(link_id: "& id &")"&"<br>"
			deleteLinkData = false
			exit function
		end if
		'**
		V("name") = OW.DB.getFieldValueBySQL("SELECT [name] FROM "& linksTable &" WHERE link_id="& id &" AND "& OW.DB.auxSQL &"")
		result    = OW.DB.execute("DELETE FROM "& linksTable &" WHERE link_id="& id &" AND "& OW.DB.auxSQL &"")
		if result then
			V("delete_action_text") = V("delete_action_text") &"友情链接删除成功"&"(link_id: "& id &", name: "& V("name") &")"&"<br>"
		else
			V("delete_action_text") = V("delete_action_text") &"友情链接删除失败"&"(link_id: "& id &", name: "& V("name") &")"&"<br>"
		end if
		deleteLinkData = result
	end function

	function doing()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <form name="save_form" id="save_form" action="?ctl=<%=CTL%>&act=<%=ACT%>&id=<%=V("link_id")%>&save=true" method="post">
        <div class="wbox">
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                <tr><td class="titletd top"><i class="important">*</i>链接名称</td>
                    <td class="infotd">
                    <input type="text" class="text" name="name" maxlength="50" value="<%=V("name")%>"/>
                    <span class="t-normal ml5" name="t_name"></span>
                    </td>
                </tr>
                <tr><td class="titletd top">logo</td>
                    <td class="infotd">
                    <%=Admin.createImageSelectGrid("logo",V("logo"),"","")%>
                    </td>
                </tr>
                <tr><td class="titletd top"><i class="important">*</i>链接url</td>
                    <td class="infotd">
                    <input type="text" class="text text-long" name="url" maxlength="255" value="<%=V("url")%>"/>
                    <span class="t-normal ml5" name="t_url"></span>
                    </td>
                </tr>
                <tr><td class="titletd top">分类id</td>
                    <td class="infotd">
                    <select name="cate_id">
                    <%=Admin.createOptions(array("1:1","2:2","3:3","4:4"),V("cate_id"))%>
                    </select>
                    <span class="t-normal ml5" name="t_cate_id"></span>
                    </td>
                </tr>
                </table>
            </div>
            
        </div>
        <div class="button-container">
            <button type="submit" class="btn btn-large btn-primary" name="submit">确定保存</button>
            <button type="reset" class="btn btn-large" name="reset">重置</button>
            <button type="button" class="btn btn-large" name="close" onClick="OW.goBack();">关闭</button>
        </div>
        </form>
    </div>
    <script type="text/javascript">
	$(document).ready(function(){
		//提交保存数据
		var $saveForm = $("#save_form");
		$saveForm.submit(function(){
			var check = true;
			OW.parseFormInputValue({form:$saveForm});
			if(!V.input({me:$("input[name='url']"),tip:$("span[name='t_url']"),okValue:'',errorValue:'请先填写链接名称'})){check=false;};
			if(!V.input({me:$("input[name='name']"),tip:$("span[name='t_name']"),okValue:'',errorValue:'请先填写链接名称'})){check=false;};
			if(check){Admin.dialogPosting();};
			return check;
		});
	});
    </script>
    <%
		call Admin.echoFooter()
	end function
	
	function doingSave()
		dim check,result
		check = true
		'**接收数据
		V("name")    = OW.validDBData(OW.getForm("post","name"),50)
		V("logo")    = OW.validDBData(OW.getForm("post","logo"),255)
		V("url")     = OW.validDBData(OW.getForm("post","url"),255)
		V("cate_id") = OW.int(OW.getForm("post","cate_id"))
		'**数据合法性判断
		if not Admin.validate("s",V("name"),"minLength:1,maxLength:0","必须填写链接名称") then check = false
		if not Admin.validate("s",V("url"),"minLength:1,maxLength:0","必须填写链接url") then check = false
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			if ACT="add" then
				V("link_id")  = OW.DB.maxID(linksTable,"link_id") + 1
				V("sequence") = OW.int(OW.DB.getFieldValueBySQL("SELECT max(sequence) FROM "& linksTable &" WHERE "& OW.DB.auxSQL &"")) + 1
				'**
				bResult       = OW.DB.addRecord(linksTable,array("site_id:"& SITE_ID,"link_id:"& V("link_id"),"sequence:"& V("sequence"),"status:0","cate_id:"& V("cate_id"),"name:"& V("name"),"logo:"& V("logo"),"url:"& V("url")))
				'**
				Admin.actionFinishSuccess     = bResult
				Admin.actionFinishSuccessText = array("成功添加友情链接"&"(link_id: "& V("link_id") &", name: "& V("name") &")",array("返回列表>index.asp?ctl="& CTL &"&act=list","继续添加>index.asp?ctl="& CTL &"&act="& ACT &""))
				Admin.actionFinishFailText    = array("添加友情链接失败"&"(link_id: "& V("link_id") &", name: "& V("name") &")",array("返回列表>index.asp?ctl="& CTL &"&act=list","继续添加>index.asp?ctl="& CTL &"&act="& ACT &""))
				Admin.actionFinishRun()
				
			elseif ACT="edit" then
				'**edit
				bResult      = OW.DB.updateRecord(linksTable,array("cate_id:"& V("cate_id"),"name:"& V("name"),"logo:"& V("logo"),"url:"& V("url")),array("link_id:"& V("link_id")))
				'**
				Admin.actionFinishSuccess     = bResult
				Admin.actionFinishSuccessText = array("成功编辑友情链接"&"(link_id: "& V("link_id") &", name: "& V("name") &")","?ctl="& CTL &"&act=list")
				Admin.actionFinishFailText    = array("编辑友情链接失败"&"(link_id: "& V("link_id") &", name: "& V("name") &")","")
				Admin.actionFinishRun()
			end if
		end if
	end function
	
	private function list()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <div class="top-area">
            <table cellspacing="0" cellpadding="0" border="0">
              <tbody>
              <tr>
              <td class="do-cell">
                  <div class="do-cell-name">添加操作区</div>
                  <div class="do-cell-btn"><a class="btn btn-primary" id="add_new" href="index.asp?ctl=<%=CTL%>&act=add">添加友情链接</a></div>
              </td>
              <td class="do-cell">
                  <div class="do-cell-name">删除操作区</div>
                  <div class="do-cell-btn"><button class="btn" id="delete_selected">批量删除</button></div>
              </td>
              </tr>
              </tbody>
            </table>
        </div>
        <div class="list-area" id="data_list_area">
            <table border="0" cellpadding="0" cellspacing="0" width="100%" class="listTable">
              <thead>
                  <tr class="thead">
                      <th><input type="checkbox" name="select_all" id="select_all"></th>
                      <th>link_id</th>
                      <th>名称</th>
                      <th>logo</th>
                      <th>链接url</th>
                      <th>分类id</th>
                      <th>状态</th>
                      <th>排序</th>
                      <th>操作</th>
                  </tr>
              </thead>
              <tbody>
              <%=listing()%>
              </tbody>
            </table>
        </div>
    </div>
    <script type="text/javascript">
    $(window).ready(function(){
		Admin.dataListTableInit({
			ctl:"<%=CTL%>",
			act_edit:"edit",
			field_name:"name",
			status_validValue:"正常",
			status_validTitle:"点击可设置为无效状态",
			status_invalidValue:'无效',
			status_invalidTitle:'点击可设置为正常状态',
			delete_confirm:"删除后推荐位将无法恢复，您确定要删除吗？",
			delete_confirm2:"删除后推荐位{tpl:name}将无法恢复，您确定要删除吗？",
			delete_doing:"正在删除推荐位...",
			delete_success:"删除成功",
			delete_failed:"删除操作失败",
			delete_tip:"请先选择您要删除的推荐位"
		});
		//**logo
		$("#data_list_area td[field='logo']").each(function(){
			var url = $(this).attr("value");
			$(this).html('<img src="'+url+'" height="32" />');
		});
	});
    </script>
	<%
		call Admin.echoFooter()
	end function
	
	private function listing()
		Admin.list("fields")         = "link_id,name,logo,url,cate_id,status,sequence"
		Admin.list("sql")            = "SELECT "& Admin.list("fields") &" FROM ["& DB_PRE &"links] WHERE "& OW.DB.auxSQL &" ORDER BY sequence"
		Admin.list("pagesize")       = Admin.getPageSise(ACTION_ID)
		Admin.list("auxURLPara")     = ""
		Admin.list("returnType")     = "html"
		Admin.list("checkboxExists") = true
		Admin.list("opeations")      = "<a class=""btn btn-small btn-primary mr5"" name=""edit"" href=""javascript:;"">编辑</a><a class=""btn btn-small"" name=""delete"" href=""javascript:;"">删除</a>"
		listing = Admin.getDataList()
	end function
end class



%>