<%
'**
'站点管理
'**
dim AP_FORM
class AP_FORM_CLASS

	private aArr,oRs,iI,sString,bResult
	private sFormTable,sFormFieldTable,sFormDataTable,sFormReplyTable
	private listTpl,fieldTpl,replyTpl
	private iIsShop
	
	private sub class_initialize()
		sFormTable      = DB_PRE &"form"
		sFormFieldTable = DB_PRE &"form_field"
		sFormReplyTable = DB_PRE &"form_reply"
		
		iIsShop = 0
		
		listTpl = "<div class=""form-data"">"
		listTpl = listTpl &"<div class=""avatar"">"
		listTpl = listTpl &"<img src=""{$vo:avatar}"">"
		listTpl = listTpl &"<h6>{$vo:username}</h6>"
		listTpl = listTpl &"</div>"
		listTpl = listTpl &"<div class=""form-data-content"">"
		listTpl = listTpl &"<div class=""heading""><span class=""datetime"">{$vo:post_time}</span><span class=""data-id"">#{$vo:id}</span></div>"
		listTpl = listTpl &"<table border=""0"" cellpadding=""0"" cellspacing=""0"">{$vo:fields_html}</table>"
		listTpl = listTpl &"</div>"
		listTpl = listTpl &"</div>"
		listTpl = listTpl &"{$vo:reply}"
		
		fieldTpl = "<tr class=""row""><td class=""col-name""><div>{$field:name}</div></td><td class=""col-value""><div>{$field:value}</div></td></tr>"
		
		replyTpl = "<div class=""form-data form-data-reply"">"
        replyTpl = replyTpl &"<div class=""avatar"">"
        replyTpl = replyTpl &"<img src=""{$reply:avatar}"">"
        replyTpl = replyTpl &"<h6>管理员</h6>"
        replyTpl = replyTpl &"</div>"
        replyTpl = replyTpl &"<div class=""form-data-content"">"
		replyTpl = replyTpl &"<div class=""heading""><span class=""datetime"">回复于 {$reply:post_time}</span></div>"
        replyTpl = replyTpl &"<div class=""reply-content"">"
        replyTpl = replyTpl &"{$reply:content}"
        replyTpl = replyTpl &"</div>"
        replyTpl = replyTpl &"</div>"
        replyTpl = replyTpl &"</div>"
		
	end sub
	
	public sub init()
		if CTL="form" then
			select case ACT
			case "list"
				if SUBACT = "getformhtml" then
					call getFormHtml()
				else
					call list()
				end if
			case "add"
				call add(SAVE)
			case "edit"
				if SUBACT = "status_edit" then
					if SAVE then
						bAuxSQLValid = true
						call Admin.statusEdit(sFormTable,"form_id",auxSQLValid,array("成功更改表单状态","无法更新数据库，表单状态更改失败！"))
					end if
				elseif SUBACT = "sequence_edit" then
					if SAVE then
						bAuxSQLValid = true
						call Admin.sequenceEdit(sFormTable,"form_id",bAuxSQLValid,array("成功进行表单排序","无法更新数据库，表单排序失败！"))
					end if
				else
					call edit(SAVE)
				end if
			case "edit_tpl"
				call editTpl(SAVE)
			case "delete"
				call delete()
			end select
		end if
	end sub
	
	private sub class_terminate()
	end sub
	
	private function getFormDetail()
		arr = OW.DB.getRecordBySQL("SELECT [name],[table],urlpath,display,pagesize,tpl,list_tpl,field_tpl,reply_tpl,post_html,send_email,rec_email,auth,post_once,forbid_member_group,need_check FROM "& sFormTable &" WHERE is_shop="& iIsShop &" AND form_id="& V("form_id") &" AND "& OW.DB.auxSQL &"")
		V("name")       = arr(0)
		V("table")      = arr(1)
		V("urlpath")    = arr(2)
		V("display")    = OW.int(arr(3))
		V("pagesize")   = OW.int(arr(4))
		V("tpl")        = arr(5)
		V("list_tpl")   = arr(6)
		V("field_tpl")  = arr(7)
		V("reply_tpl")  = arr(8)
		V("post_html")  = arr(9)
		V("send_email") = OW.int(arr(10))
		V("rec_email")  = arr(11)
		V("auth")       = OW.int(arr(12))
		V("post_once")  = OW.int(arr(13))
		V("forbid_member_group") = arr(14)
		V("need_check") = OW.int(arr(15))
	end function
	
	'**创建模型表，若表存在则会被删除重新创建
	public function createFormDataTable(byval table)
		dim sql,cresult,aresult
		if OW.DB.isTableExists(table) then OW.DB.deleteTable(table)
		select case DB_TYPE
		case 0
			sql = "CREATE TABLE ["& table &"] ("
			sql = sql & "[id] integer IDENTITY (1,1) PRIMARY KEY NOT NULL,"
			sql = sql & "[uid] integer NOT NULL,"
			sql = sql & "[status] integer NOT NULL,"
			sql = sql & "[ip] text (64) NOT NULL,"
			sql = sql & "[post_time] date NOT NULL"
			sql = sql & ")"
			cresult = OW.DB.execute(sql)
			aresult = true
		case 1
			sql = "CREATE TABLE ["& table &"] ("
			sql = sql & "[id] [int] IDENTITY (1,1) NOT NULL,"
			sql = sql & "[uid] [int] NOT NULL,"
			sql = sql & "[status] [tinyint] NOT NULL,"
			sql = sql & "[ip] [nvarchar] (64) NOT NULL,"
			sql = sql & "[post_time] [datetime] NOT NULL"
			sql = sql & ")"
			cresult = OW.DB.execute(sql)
			aresult = OW.DB.execute("ALTER TABLE ["& table &"] WITH NOCHECK ADD CONSTRAINT [PK_"& table &"] PRIMARY KEY CLUSTERED ([id]) ON [PRIMARY]")
		end select
		if cresult=true and aresult=true then
			createFormDataTable=true
		else
			createFormDataTable=false
		end if
	end function
	
	private function add(byval isSave)
		if isSave then
			call doingSave()
		else
			call doing()
		end if
	end function
	
	private function edit(byval isSave)
		V("form_id") = ID
		'**传递id是否正确
		if V("form_id")<1 then
			call Admin.errorSetting("form_id传递不正确"&"(form_id: "& V("form_id") &")"&"<br>")
			exit function
		end if
		'**判断记录是否存在
		if not(OW.DB.isRecordExistsBySQL("SELECT * FROM "& sFormTable &" WHERE is_shop="& iIsShop &" AND form_id="& V("form_id") &" AND "& OW.DB.auxSQL &"")) then
			Admin.errorSetting("表单不存在"&"(form_id: "& V("form_id") &")"&"<br>")
			exit function
		end if
		'**
		if isSave then
			call doingSave()
		else
			call getFormDetail()
			call doing()
		end if
	end function
	
	private function editTpl(byval isSave)
		V("form_id") = ID
		'**传递id是否正确
		if V("form_id")<1 then
			call Admin.errorSetting("form_id传递不正确"&"(form_id: "& V("form_id") &")"&"<br>")
			exit function
		end if
		'**判断记录是否存在
		if not(OW.DB.isRecordExistsBySQL("SELECT * FROM "& sFormTable &" WHERE is_shop="& iIsShop &" AND form_id="& V("form_id") &" AND "& OW.DB.auxSQL &"")) then
			Admin.errorSetting("表单不存在"&"(form_id: "& V("form_id") &")"&"<br>")
			exit function
		end if
		'**
		if isSave then
			call editTplSave()
		else
			call getFormDetail()
			call editTplHtml()
		end if
	end function
	
	private function delete()
		dim check : check = true
		'**接收数据
		V("ids") = OW.regReplace(OW.getForm("post","ids"),"[^0-9,]","")
		aArr     = split(V("ids"),",")
		'**
		if V("ids")="" then check = false : Admin.errorSetting("form_id传递不正确")
		'**从数据库删除记录
		if check then
			for iI=0 to ubound(aArr)
				call deleteFormData(OW.int(aArr(iI)))
			next
			'**输出操作结果信息
			Admin.actionFinishSuccess     = true
			Admin.actionFinishSuccessText = array(V("delete_action_text"),"")
			Admin.actionFinishFailText    = array(V("delete_action_text"),"")
			Admin.actionFinishRun()
		end if
	end function
	
	private function deleteFormData(byval id)
		dim arr,result : result = true
		if id<=0 then
			deleteFormData = false
			exit function
		end if
		'**
		if not(OW.DB.isRecordExistsBySQL("SELECT * FROM "& sFormTable &" WHERE is_shop="& iIsShop &" AND form_id="& id &" AND "& OW.DB.auxSQL &"")) then
			V("delete_action_text") = V("delete_action_text") &"表单不存在或已被删除"&"(form_id: "& id &")"&"<br>"
			deleteFormData = false
			exit function
		end if
		'**
		arr       = OW.DB.getFieldValueBySQL("SELECT [name],[table] FROM "& sFormTable &" WHERE is_shop="& iIsShop &" AND form_id="& id &" AND "& OW.DB.auxSQL &"")
		V("name") = arr(0)
		V("table")= arr(1)
		result    = OW.DB.execute("DELETE FROM "& sFormTable &" WHERE is_shop="& iIsShop &" AND form_id="& id &" AND "& OW.DB.auxSQL &"")
		if result then
			'**[删除]表单字段
			call OW.DB.execute("DELETE FROM ["& sFormFieldTable &"] WHERE form_id="& id &"")
			'**[删除]表单表
			call OW.DB.deleteTable(OW.DB.Table.formPre & V("table"))
			'**[删除]表单回复
			call OW.DB.execute("DELETE FROM ["& sFormReplyTable &"] WHERE form_id="& id &" AND "& OW.DB.auxSQL &"")
			'**
			V("delete_action_text") = V("delete_action_text") &"表单删除成功"&"(form_id: "& id &", name: "& V("name") &")"&"<br>"
		else
			V("delete_action_text") = V("delete_action_text") &"表单删除失败"&"(form_id: "& id &", name: "& V("name") &")"&"<br>"
		end if
		deleteFormData = result
	end function

	function doing()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <form name="save_form" id="save_form" action="?ctl=<%=CTL%>&act=<%=ACT%>&id=<%=V("form_id")%>&save=true" method="post">
        <div class="wbox">
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                <tr><td class="titletd top"><i class="important">*</i>表单名称</td>
                    <td class="infotd">
                    <input type="text" class="text" name="name" maxlength="50" value="<%=V("name")%>"/>
                    <span class="t-normal ml5" name="t_name"></span>
                    </td>
                </tr>
                <tr><td class="titletd top"><i class="important">*</i>数据表名</td>
                    <td class="infotd">
                    <input type="text" class="text text-short <%=OW.iif(ACT="edit","disabled","")%>" name="table" maxlength="30" onblur="OW.onblur(this,{rep:'/[^0-9a-zA-Z_]*/g',length:30})" value="<%=V("table")%>" <%=OW.iif(ACT="edit","disabled","")%>/>
                    <span class="t-normal ml5" name="t_table">数据表名只能由字母和数字组成，且必须由字母开头</span>
                    </td>
                </tr>
                <tr><td class="titletd"><i class="important">*</i>URL路径</td>
                    <td class="infotd">
                    <input type="text" class="text text-short disabled" name="url_pre" readonly="readonly" style="width:160px;" value="<%=SITE_URL%>form/"/><input type="text" class="text" name="urlpath" maxlength="64" style="width:192px;" placeholder="输入url路径" value="<%=V("urlpath")%>"/><input type="text" class="text text-short-mini disabled" name="url_suffix" readonly="readonly" style="width:34px;" value="<%=SITE_HTML_FILE_SUFFIX%>"/><button type="button" class="btn btn-font-normal ml5" name="create_urlpath">点击生成</button>
                    <span class="t-normal ml5" name="t_urlpath">此设置对于seo优化很有帮助</span>
                    </td>
                </tr>
                <tr><td class="titletd top">前台显示列表</td>
                    <td class="infotd">
                    <div class="labels">
                    <label><input type="radio" name="display" value="0" <%=OW.iif(V("display")=0,"checked","")%>>不显示</label>
                    <label><input type="radio" name="display" value="1" <%=OW.iif(V("display")=1,"checked","")%>>显示</label>
                    <span class="t-normal ml5" name="t_display">是否在前台页面显示表单内容列表</span>
                    </div>
                    <div class="form-in-table" name="pagesize" <%=OW.iif(V("display")=0,"style=""display:none;""","")%>>
                        <dl>
                            <dt>前台分页数</dt>
                            <dd><input type="text" class="text text-short" name="pagesize" maxlength="2" value="<%=V("pagesize")%>"/>
                                <span class="t-normal ml5" name="t_pagesize">即前台每页显示的数量</span>
                            </dd>
                        </dl>
                    </div>
                    </td>
                </tr>
                </table>
            </div>
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                <tr><td class="titletd top">发送邮件</td>
                    <td class="infotd">
                    <div class="labels">
                    <label><input type="radio" name="send_email" value="0" <%=OW.iif(V("send_email")=0,"checked","")%>>不发送</label>
                    <label><input type="radio" name="send_email" value="1" <%=OW.iif(V("send_email")=1,"checked","")%>>发送</label>
                    <span class="t-normal ml5" name="t_send_email">当有新数据提交时是否给管理员发送邮件</span>
                    </div>
                    <div class="form-in-table" name="rec_email" <%=OW.iif(V("send_email")=0,"style=""display:none;""","")%>>
                        <dl>
                            <dt>接收邮件的邮箱</dt>
                            <dd><input type="text" class="text text-long" name="rec_email" maxlength="250" value="<%=V("rec_email")%>"/>
                                <span class="t-normal ml5" name="t_rec_email">多个邮箱之间请用英文逗号,隔开</span>
                            </dd>
                        </dl>
                    </div>
                    </td>
                </tr>
                <tr><td class="titletd top">权限设置</td>
                    <td class="infotd">
                    <div class="labels">
                    <label><input type="radio" name="auth" value="0" <%=OW.iif(V("auth")=0,"checked","")%>>任何人都可以提交</label>
                    <label><input type="radio" name="auth" value="1" <%=OW.iif(V("auth")=1,"checked","")%>>只允许会员提交</label>
                    <span class="t-normal ml5" name="t_auth"></span>
                    </div>
                    <div class="form-in-table" name="auth" <%=OW.iif(V("auth")=0,"style=""display:none;""","")%>>
                        <dl>
                            <dt>提交次数设置</dt>
                            <dd>
                            <label><input type="checkbox" name="post_once" value="1" <%=OW.iif(V("post_once")=1,"checked","")%>>每个会员只允许提交一次</label>
                            </dd>
                        </dl>
                        <dl>
                            <dt>选择<span class="note">禁止提交</span>的用户组(<span class="t-normal" name="t_group">不选则表示所有会员都可以提交</span>)</dt>
                            <dd>
                            <div class="labels">
                                <%=Admin.memberGroupCheckboxs("2",split(V("forbid_member_group"),","))%>
                                <span style="color:#888; padding:0px 10px 0px 0px;">|</span>
                                <%=Admin.memberGroupCheckboxs("3",split(V("forbid_member_group"),","))%>
                            </div>
                            </dd>
                        </dl>
                    </div>
                    </td>
                </tr>
                <tr><td class="titletd top">内容审核</td>
                    <td class="infotd">
                    <div class="labels">
                    <label><input type="checkbox" name="need_check" value="1" <%=OW.iif(V("need_check")=1,"checked","")%>>需要审核</label>
                    <span class="t-normal ml5" name="t_send_email">需要审核表示前台提交的表单内容需要通过审核才能显示</span>
                    </div>
                    </td>
                </tr>
                </table>
            </div>
        </div>
        <div class="button-container">
            <button type="submit" class="btn btn-large btn-primary" name="submit">确定保存</button>
            <button type="reset" class="btn btn-large" name="reset">重置</button>
            <button type="button" class="btn btn-large" name="close" onClick="OW.goBack();">关闭</button>
        </div>
        </form>
    </div>
    <script type="text/javascript">
	$(document).ready(function(){
		//提交保存数据
		var $saveForm = $("#save_form");
		$saveForm.submit(function(){
			var check = true;
			OW.parseFormInputValue({form:$saveForm});
			if(!V.input({me:$("input[name='urlpath']"),tip:$("span[name='t_urlpath']"),okValue:'',errorValue:'请先填写URL路径'})){check=false;};
			if(!V.input({me:$("input[name='table']"),tip:$("span[name='t_table']"),okValue:'',errorValue:'请先填写数据表名'})){check=false;};
			if(!V.input({me:$("input[name='name']"),tip:$("span[name='t_name']"),okValue:'',errorValue:'请先填写链接名称'})){check=false;};
			if(check){Admin.dialogPosting();};
			return check;
		});
		//**点击生成URL路径
		$("button[name='create_urlpath']").click(function(){
			Admin.createUrlPath({
				urlpath:$("input[name='urlpath']"),
				string:$("input[name='name']").val()
			});
		});
		//**数据列表
		$("input[name='display']").click(function(){
			if($(this).val()==1 && $(this).attr("checked")==true){
				$("div[name='pagesize']").show("fast");
			}else if($(this).val()==0 && $(this).attr("checked")==true){
				$("div[name='pagesize']").hide("fast");
			};
		});
		//**发送邮件
		$("input[name='send_email']").click(function(){
			if($(this).val()==1 && $(this).attr("checked")==true){
				$("div[name='rec_email']").show("fast");
			}else if($(this).val()==0 && $(this).attr("checked")==true){
				$("div[name='rec_email']").hide("fast");
			};
		});
		//**权限设置
		$("input[name='auth']").click(function(){
			if($(this).val()==1 && $(this).attr("checked")==true){
				$("div[name='auth']").show("fast");
			}else if($(this).val()==0 && $(this).attr("checked")==true){
				$("div[name='auth']").hide("fast");
			};
		});
	});
    </script>
    <%
		call Admin.echoFooter()
	end function
	
	function doingSave()
		dim check,result
		check = true
		'**接收数据
		V("name")       = OW.validDBData(OW.getForm("post","name"),50)
		V("table")      = OW.validDBData(OW.regReplace(OW.getForm("post","table"),"[^0-9a-zA-Z_]",""),30)
		V("urlpath")    = OW.validDBData(Admin.urlpath(),50)
		V("display")    = OW.int(OW.getForm("post","display"))
		V("pagesize")   = OW.int(OW.getForm("post","pagesize"))
		V("tpl")        = OW.validDBData(OW.getForm("post","tpl"),50)
		V("send_email") = OW.int(OW.getForm("post","send_email"))
		V("rec_email")  = OW.validDBData(OW.getForm("post","rec_email"),250)
		V("auth")       = OW.int(OW.getForm("post","auth"))
		V("post_once")  = OW.int(OW.getForm("post","post_once"))
		V("forbid_member_group") = OW.validDBData(OW.getForm("post","member_group"),250)
		V("need_check") = OW.int(OW.getForm("post","need_check"))
		'**
		if V("pagesize")>100 then V("pagesize") = 100
		if V("pagesize")<1   then V("pagesize") = 20
		if V("tpl")="" then V("tpl")="form.html"
		'**数据合法性判断
		if not Admin.validate("s",V("name"),"minLength:1,maxLength:0","必须填写表单名称") then check = false
		if V("urlpath")<>"" then
			if ACT = "add" then
				if OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"form WHERE urlpath='"& V("urlpath") &"' AND "& OW.DB.auxSQL &"") then check = false : Admin.errorSetting(replace("URL路径 {$urlpath} 已被其他表单使用，请返回修改","{$urlpath}",V("urlpath")))
			elseif ACT = "edit" then
				if OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"form WHERE form_id<>"& V("form_id") &" AND urlpath='"& V("urlpath") &"' AND "& OW.DB.auxSQL &"") then check = false : Admin.errorSetting(replace("URL路径 {$urlpath} 已被其他表单使用，请返回修改","{$urlpath}",V("urlpath")))
			end if
		end if
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			if ACT="add" then
				echo "<div style=""font-size:14px; padding:20px;"">亲，正式版才有此功能，请<a href=""http://www.openwbs.com/contact_us.html"" target=""_blank"">联系OpenWBS购买正式版和授权许可</a>！</div>"
			elseif ACT="edit" then
				'**edit
				bResult      = formEdit()
				'**
				Admin.actionFinishSuccess     = bResult
				Admin.actionFinishSuccessText = array("成功编辑表单"&"(form_id: "& V("form_id") &", name: "& V("name") &")","?ctl="& CTL &"&act=list")
				Admin.actionFinishFailText    = array("编辑表单失败"&"(form_id: "& V("form_id") &", name: "& V("name") &")","")
				Admin.actionFinishRun()
			end if
		end if
	end function
	
	private function formEdit()
		formEdit = OW.DB.updateRecord(sFormTable,array("name:"& V("name"),"urlpath:"& V("urlpath"),"display:"& V("display"),"pagesize:"& V("pagesize"),"send_email:"& V("send_email"),"rec_email:"& V("rec_email"),"auth:"& V("auth"),"post_once:"& V("post_once"),"forbid_member_group:"& V("forbid_member_group"),"need_check:"& V("need_check")),array("is_shop:"& iIsShop,"form_id:"& V("form_id")))
	end function
	
	private function editTplHtml()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <form name="save_form" id="save_form" action="?ctl=<%=CTL%>&act=<%=ACT%>&id=<%=V("form_id")%>&save=true" method="post">
        <div class="wbox">
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable"> 
                <tr><td class="titletd top"><i class="important">*</i>前台模板页面</td>
                    <td class="infotd">
                    <%=Admin.tplOptions("tpl","form.html",V("tpl"))%>
                    <span class="t-normal ml5" name="t_tpl"></span>
                    </td>
                </tr>
                </table>
            </div>
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable"> 
                <tr><td class="titletd top">表单提交html</td>
                    <td class="infotd">
                    <textarea class="textarea textarea-code" style="height:120px;" name="post_html"><%=OW.templateHTMLEncode(V("post_html"))%></textarea><br />
                    <span class="t-normal ml5" name="t_post_html">注意：每一次添加/编辑/删除表单字段都会重新生成此表单提交html</span>
                    </td>
                </tr>
                </table>
            </div>
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable"> 
                <tr><td class="titletd top">数据列表模板</td>
                    <td class="infotd">
                    <textarea class="textarea textarea-code" style="height:120px;" name="list_tpl"><%=OW.templateHTMLEncode(V("list_tpl"))%></textarea>
                    <span class="t-normal ml5" name="t_list_tpl"></span>
                    </td>
                </tr>
                <tr><td class="titletd top">字段循环输出模板</td>
                    <td class="infotd">
                    <textarea class="textarea textarea-code" name="field_tpl" style="height:60px;"><%=OW.templateHTMLEncode(V("field_tpl"))%></textarea>
                    <span class="t-normal ml5" name="t_field_tpl"></span>
                    </td>
                </tr>
                <tr><td class="titletd top">管理员回复模板</td>
                    <td class="infotd">
                    <textarea class="textarea textarea-code" style="height:120px;" name="reply_tpl"><%=OW.templateHTMLEncode(V("reply_tpl"))%></textarea>
                    <div><span class="t-normal ml5" name="t_reply_tpl">输出数据时会把数据列表模板中的{$vo:reply}替换成此管理员回复模板</span></div>
                    </td>
                </tr>
                </table>
            </div>
            <div class="instruction">
                <h5>标签解释</h5>
                <table border="0" cellpadding="0" cellspacing="0" class="list fl">
                <thead><tr><th>表单标签</th><th colspan="2">说明</th></tr></thead>
                <tbody>
                <tr><td>{$vo:id}</td><td colspan="2">列表数据id</td></tr>
                <tr><td>{$vo:post_time}</td><td colspan="2">数据提交时间</td></tr>
                <tr><td>{$vo:username}</td><td colspan="2">用户名</td></tr>
                <tr><td>{$vo:avatar}</td><td colspan="2">用户头像</td></tr>
                <tr><td>{$vo:fields_html}</td><td colspan="2">字段循环输出模板</td></tr>
                <tr><td>{$vo:reply}</td><td colspan="2">管理员回复模板</td></tr>
                </tbody>
                <thead><tr><th>表单字段</th><th>字段名称</th><th>是否在前端显示</th></tr></thead>
                <tbody>
                <%
				set oRs = OW.DB.getRecordBySQL("SELECT field,field_name,display_in_client FROM "& DB_PRE &"form_field WHERE form_id="& V("form_id") &" AND "& OW.DB.auxSQL &"ORDER BY sequence")
				do while not oRs.eof
					echo "<tr><td>{$field:"& oRs("field") &"}</td><td>"& oRs("field_name") &"</td><td>"& OW.iif(OW.int(oRs("display_in_client"))=1,"可显示","不可显示") &"</td></tr>"
					oRs.movenext
				loop
				OW.DB.closeRs oRs
				%>
                </tbody>
                </table>
                
                <table border="0" cellpadding="0" cellspacing="0" class="list fl ml10">
                <tr><th colspan="2">自动判断并循环输出表单字段</th></tr>
                <tr><td>{$field:name}</td><td>字段名称</td></tr>
                <tr><td>{$field:value}</td><td>字段内容</td></tr>
                </table>
                
                <table border="0" cellpadding="0" cellspacing="0" class="list fl ml10">
                <tr><th>回复标签</th><th>说明</th></tr>
                <tr><td>{$reply:avatar}</td><td>管理员头像</td></tr>
                <tr><td>{$reply:post_time}</td><td>回复时间</td></tr>
                <tr><td>{$reply:content}</td><td>回复内容</td></tr>
                </table>
            </div>
        </div>
        <div class="button-container">
            <button type="submit" class="btn btn-large btn-primary" name="submit">确定保存</button>
            <button type="reset" class="btn btn-large" name="reset">重置</button>
        </div>
        </form>
    </div>
    <script type="text/javascript">
	$(document).ready(function(){
		//提交保存数据
		var $saveForm = $("#save_form");
		$saveForm.submit(function(){
			var check = true;
			OW.parseFormInputValue({form:$saveForm});
			if(!V.select({me:$("select[name='tpl']"),tip:$("span[name='t_tpl']"),okValue:'',errorValue:'请选择前台模板页面'})){check=false;};
			if(check){Admin.dialogPosting();};
			return check;
		});
	});
    </script>
    <%
		call Admin.echoFooter()
	end function
	
	private function editTplSave()
		dim check,result
		check = true
		'**接收数据
		V("tpl")       = OW.validDBData(OW.templateHTMLDecode(OW.getForm("post","tpl")),50)
		V("list_tpl")  = OW.validDBData(OW.templateHTMLDecode(OW.getForm("post","list_tpl")),0)
		V("field_tpl") = OW.validDBData(OW.templateHTMLDecode(OW.getForm("post","field_tpl")),0)
		V("reply_tpl") = OW.validDBData(OW.templateHTMLDecode(OW.getForm("post","reply_tpl")),0)
		V("post_html") = OW.validDBData(OW.templateHTMLDecode(OW.getForm("post","post_html")),0)
		'**数据合法性判断
		if not Admin.validate("s",V("tpl"),"minLength:1,maxLength:0","必须填写选择前台模板页面") then check = false
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			'**edit
			bResult = OW.DB.updateRecord(sFormTable,array("tpl:"& V("tpl"),"list_tpl:"& V("list_tpl"),"field_tpl:"& V("field_tpl"),"reply_tpl:"& V("reply_tpl"),"post_html:"& V("post_html")),array("is_shop:"& iIsShop,"form_id:"& V("form_id")))
			'**
			Admin.actionFinishSuccess     = bResult
			Admin.actionFinishSuccessText = array("成功编辑表单模板"&"(form_id: "& V("form_id") &", name: "& V("name") &")","?ctl="& CTL &"&act="& ACT &"&id="& V("form_id") &"")
			Admin.actionFinishFailText    = array("编辑表单模板失败"&"(form_id: "& V("form_id") &", name: "& V("name") &")","")
			Admin.actionFinishRun()
		end if
	end function
	
	private function getFormHtml()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
        <div class="wbox">
            <div class="instruction">
                <h5>表单及数据的前台调用代码</h5>
                <table border="0" cellpadding="0" cellspacing="0" class="list fl">
                <tr><td rowspan="2">表单页</td>
                    <td>表单</td>
                    <td>{$form_post_html}</td>
                </tr>
                <tr>
                    <td>数据列表</td>
                    <td>{$form_post_html}</td>
                </tr>
                <tr><td rowspan="2">非表单页</td>
                    <td>表单</td>
                    <td>{$form_post_html id="<%=ID%>"}</td>
                </tr>
                <tr>
                    <td>数据列表</td>
                    <td>{$form_list_html id="<%=ID%>"}</td>
                </tr>
                </table>
            </div>
        </div>
    <%
	end function
	
	private function list()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <div class="top-area">
            <table cellspacing="0" cellpadding="0" border="0">
              <tbody>
              <tr>
              <td class="do-cell">
                  <div class="do-cell-name">添加操作区</div>
                  <div class="do-cell-btn"><a class="btn btn-primary" id="add_new" href="index.asp?ctl=<%=CTL%>&act=add">添加表单</a></div>
              </td>
              <td class="do-cell">
                  <div class="do-cell-name">删除操作区</div>
                  <div class="do-cell-btn"><button class="btn" id="delete_selected">批量删除</button></div>
              </td>
              </tr>
              </tbody>
            </table>
        </div>
        <div class="list-area" id="data_list_area">
            <table border="0" cellpadding="0" cellspacing="0" width="100%" class="listTable">
              <thead>
                  <tr class="thead">
                      <th><input type="checkbox" name="select_all" id="select_all"></th>
                      <th>id</th>
                      <th>表单名称</th>
                      <th>数据表名</th>
                      <th>字段数量</th>
                      <th>URL路径</th>
                      <th>前台显示列表</th>
                      <th>发送邮件</th>
                      <th>状态</th>
                      <th>排序</th>
                      <th>操作</th>
                  </tr>
              </thead>
              <tbody>
              <%=listing()%>
              </tbody>
            </table>
        </div>
    </div>
    <script type="text/javascript">
    $(window).ready(function(){
		Admin.dataListTableInit({
			ctl:"<%=CTL%>",
			act_edit:"edit",
			field_name:"name",
			status_validValue:"正常",
			status_validTitle:"点击可设置为已终止状态",
			status_invalidValue:'已终止',
			status_invalidTitle:'点击可设置为正常状态',
			delete_confirm:"删除后表单将无法恢复，您确定要删除吗？",
			delete_confirm2:"删除后表单{tpl:name}将无法恢复，您确定要删除吗？",
			delete_doing:"正在删除表单...",
			delete_success:"删除成功",
			delete_failed:"删除操作失败",
			delete_tip:"请先选择您要删除的表单"
		});
		//**链接
		$("#data_list_area td[field='name']").each(function(){
			var $urlpath = $(this).parent().find("td[field='urlpath']"),
			url = "<%=OW.urlRewrite("f1")%>";
			url = url.replace("{$urlpath}",$urlpath.attr("value"));
			$(this).html('<a href="'+url+'" target="_blank">'+$(this).attr("value")+'</a>');
		});
		//**前台列表显示
		$("#data_list_area td[field='display']").each(function(){
			if(parseInt($(this).attr("value"))==1){
				$(this).html("是");
			}else{
				$(this).html("否");
			};
		});
		//**发送邮件
		$("#data_list_area td[field='send_email']").each(function(){
			if(parseInt($(this).attr("value"))==1){
				$(this).html("是");
			}else{
				$(this).html("否");
			};
		});
		//**模板编辑
		$("#data_list_area a[name='edit_tpl']").click(function(){
			var form_id = $(this).parent().parent().attr("value");
			var dialog = OWDialog({
				id:'d_edit_tpl_manage',
				title:''+$(this).parent().parent().find("td[field='name']").attr("value")+' - 模板编辑',
				iframe:'index.asp?ctl=form&act=edit_tpl&id='+form_id+"&r="+OW.random(),padding:'0px',
				height:OW.dialogBigHeight(),
				width:OW.dialogBigWidth()
			});
		});
		//**字段管理
		$("#data_list_area a[name='form_field_manage']").click(function(){
			var form_id = $(this).parent().parent().attr("value");
			var dialog = OWDialog({
				id:'d_form_field_manage',
				title:''+$(this).parent().parent().find("td[field='name']").attr("value")+' - 字段管理',
				iframe:'index.asp?ctl=form_field&act=list&form_id='+form_id+"&r="+OW.random(),padding:'0px',
				height:OW.dialogBigHeight(),
				width:OW.dialogBigWidth()
			});
		});
		//**内容管理
		$("#data_list_area a[name='form_data_manage']").click(function(){
			var form_id = $(this).parent().parent().attr("value");
			var dialog = OWDialog({
				id:'d_form_field_manage',
				title:''+$(this).parent().parent().find("td[field='name']").attr("value")+' - 内容管理',
				iframe:'index.asp?ctl=form_data&act=list&form_id='+form_id+"&r="+OW.random(),padding:'0px',
				height:OW.dialogBigHeight(),
				width:OW.dialogBigWidth()
			});
		});
		//**调用方式
		$("#data_list_area a[name='getform']").click(function(){
			var form_id = $(this).parent().parent().attr("value");
			var dialog = OWDialog({
				id:'d_form_field_manage',
				title:''+$(this).parent().parent().find("td[field='name']").attr("value")+' - 调用方式',
				iframe:'index.asp?ctl=form&act=list&subact=getformhtml&id='+form_id+"&r="+OW.random(),padding:'0px',
				height:280,
				width:600
			});
		});
		//**
		
	});
    </script>
	<%
		call Admin.echoFooter()
	end function
	
	private function listing()
		Admin.list("fields")         = "form_id,[name],[table],(SELECT count(*) FROM "& DB_PRE &"form_field WHERE form_id=a.form_id AND "& OW.DB.auxSQL &") as fields,urlpath,display,send_email,status,sequence"
		Admin.list("sql")            = "SELECT "& Admin.list("fields") &" FROM ["& sFormTable &"] a WHERE is_shop="& iIsShop &" AND "& OW.DB.auxSQL &" ORDER BY sequence"
		Admin.list("pagesize")       = Admin.getPageSise(ACTION_ID)
		Admin.list("auxURLPara")     = ""
		Admin.list("returnType")     = "html"
		Admin.list("checkboxExists") = true
		Admin.list("opeations")      = "<a class=""btn btn-small btn-primary mr5"" name=""edit"" href=""javascript:;"">编辑</a>"
		Admin.list("opeations")      = Admin.list("opeations") &"<a class=""btn btn-small mr5"" name=""edit_tpl"" href=""javascript:;"">模板编辑</a>"
		Admin.list("opeations")      = Admin.list("opeations") &"<a class=""btn btn-small mr5"" name=""form_field_manage"" href=""javascript:;"">字段管理</a>"
		Admin.list("opeations")      = Admin.list("opeations") &"<a class=""btn btn-small mr5"" name=""form_data_manage"" href=""javascript:;"">内容管理</a>"
		Admin.list("opeations")      = Admin.list("opeations") &"<a class=""btn btn-small mr5"" name=""getform"" href=""javascript:;"">调用代码</a>"
		Admin.list("opeations")      = Admin.list("opeations") &"<a class=""btn btn-small"" name=""delete"" href=""javascript:;"">删除</a>"
		listing = Admin.getDataList()
	end function
end class



%>