<%
'**
'站点管理
'**
dim AP_MODEL_FIELD
class AP_MODEL_FIELD_CLASS
	
	private aArr,oRs,iI,bResult
	private bAuxSQLValid,bShowOptions
	
	private sub class_initialize()
		bAuxSQLValid = false
		bShowOptions = false
	end sub
	
	public sub init()
		if CTL="model_field" then
			V("model_id") = OW.int(OW.getForm("get","model_id"))
			select case ACT
			case "list"
				call list()
			case "add"
				call add(SAVE)
			case "edit"
				if SUBACT = "status_edit" then
					if SAVE then
						bAuxSQLValid = true
						call Admin.statusEdit(DB_PRE &"model_field","field_id",bAuxSQLValid,array("成功更改字段状态","无法更新数据库，字段状态更改失败！"))
					end if
				elseif SUBACT = "sequence_edit" then
					if SAVE then
						bAuxSQLValid = true
						call Admin.sequenceEdit(DB_PRE &"model_field","field_id",bAuxSQLValid,array("成功进行字段排序","无法更新数据库，字段排序失败！"))
					end if
				else
					call edit(SAVE)
				end if
			case "delete"
				call delete()
			end select
		end if
	end sub
	
	private sub class_terminate()
	end sub
	
	private function getInfo()
		set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& DB_PRE &"model_field WHERE field_id="& V("field_id") &" AND "& OW.DB.auxSQL &"")
		if not(oRs.eof) then
			V("field")         = oRs("field")
			V("field_name")    = oRs("field_name")
			V("field_type")    = oRs("field_type")
			V("field_default") = oRs("field_default")
			V("field_options") = oRs("field_options")
			V("not_null")      = oRs("not_null")
			V("tips")          = oRs("tips")
		end if
		OW.DB.closeRs oRs
	end function
	
	private function add(byval isSave)
		if V("model_id")<1 then call Admin.errorSetting("内容模型id传递不正确") : exit function
		if isSave then
			call doingSave()
		else
			select case DB_TYPE
			case 0
				V("field_datatype") = "text"
			case 1
				V("field_datatype") = "nvarchar"
			end select
			call doing()
		end if
	end function
	
	private function edit(byval isSave)
		dim check
		check = true
		V("field_id") = ID
		'**传递id是否正确
		if V("field_id")<1 then check = false : call Admin.errorSetting("字段id传递不正确")
		'**是否存在
		if check then
			if not(OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"model_field WHERE field_id="& V("field_id") &" AND "& OW.DB.auxSQL &"")) then
				check = false
				call Admin.errorSetting("字段不存在")
			end if
		end if
		'**
		if check then
			if isSave then
				call doingSave()
			else
				call getInfo()
				if V("field_type")="radio" or V("field_type")="checkbox" or V("field_type")="select" then
					bShowOptions = true
				end if
				call doing()
			end if
		end if
	end function
	
	private function delete()
		dim check,s,isSkip
		check = true
		'**接收数据
		V("ids") = OW.regReplace(OW.getForm("post","ids"),"[^0-9,]","")
		'**数据处理
		aArr = split(V("ids"),",")
		'**数据合法性校验
		if V("ids")="" then check = false : Admin.errorSetting("字段id值传递不正确")
		'**从数据库删除记录
		if check then
			'**delete
			for iI=0 to ubound(aArr)
				V("field_id") = OW.clng(aArr(iI))
				if V("field_id")>0 then
					isSkip = false
					if not(OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"model_field WHERE field_id="& V("field_id") &" AND "& OW.DB.auxSQL &"")) then
						isSkip = true
						s = s &"字段不存在或已被删除，请刷新试试!(field_id:"& V("field_id") &");<br>"
					end if
					if not(isSkip) then
						V("field") = OW.DB.getFieldValueBySQL("SELECT field FROM "& DB_PRE &"model_field WHERE field_id="& V("field_id") &" AND "& OW.DB.auxSQL &"")
						bResult = deleteField(V("field"),V("field_id"))
						if bResult then
							s = s &"(field_id:"& V("field_id") &",field:"& V("field") &")成功删除字段;<br>"
						else
							s = s &"(field_id:"& V("field_id") &",field:"& V("field") &")从数据库中删除字段失败;<br>"
						end if
					end if
				end if
			next
			'**输出操作结果信息
			Admin.actionFinishSuccess = bResult
			Admin.actionFinishSuccessText = array(s,"")
			Admin.actionFinishFailText = array(s,"")
			Admin.actionFinishRun()
		end if
	end function
	
	private function deleteField(byval field,byval field_id)
		dim result,sql,table,fieldTable
		result = false
		V("model_id")    = OW.DB.getFieldValueBySQL("SELECT model_id FROM "& DB_PRE &"model_field WHERE field_id="& field_id &" AND "& OW.DB.auxSQL &"")
		V("model_table") = OW.DB.getFieldValueBySQL("SELECT model_table FROM "& DB_PRE &"model WHERE model_id="& V("model_id") &" AND "& OW.DB.auxSQL &"")
		table            = OW.DB.Table.content &"_"& V("model_table")
		'**
		if OW.DB.execute("DELETE FROM ["& DB_PRE &"model_field] WHERE field_id="& field_id &" AND "& OW.DB.auxSQL &"") then
			result = true
			if OW.DB.isTableExists(table) then
				if not OW.DB.deleteColumn(table,field) then
					call OW.DB.deleteColumn(table,field)
				end if
			end if
		end if
		deleteField = result
	end function

	function doing()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <form name="save_form" id="save_form" action="?ctl=<%=CTL%>&act=<%=ACT%>&id=<%=V("field_id")%>&save=true&model_id=<%=V("model_id")%>" method="post">
        <div class="wbox">
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                <tbody>
                <tr><td class="titletd"><i class="important">*</i>字段</td>
                    <td class="infotd">
                    <input type="text" class="text" name="field" maxlength="50" onblur="OW.onblur(this,{rep:'/[^0-9a-zA-Z_]*/g',length:50})" value="<%=V("field")%>" <%=OW.iif(DB_TYPE=0 and ACT="edit","readonly","")%> />
                    <span class="t-normal ml5" name="t_field">只能由英文字母、数字和下划线组成，并且只能字母开头，长度30以内，不能以下划线结尾</span>
                    </td>
                </tr>
                <tr><td class="titletd"><i class="important">*</i>字段名称</td>
                    <td class="infotd">
                    <input type="text" class="text" name="field_name" maxlength="50" value="<%=V("field_name")%>" />
                    <span class="t-normal ml5" name="t_field_name"></span>
                    </td>
                </tr>
                <tr><td class="titletd top"><i class="important">*</i>字段类型</td>
                    <td class="infotd">
                    <%=Admin.fieldTypeOptions("field_type","",V("field_type"))%>
                    <span id="adv_opt_grid" class="adv_opt_grid" style="display:none;">
                        <%=Admin.fieldDatatypeOptions("field_datatype","",V("field_datatype"))%>
                        <input type="text" class="text text-short-mini" name="field_datasize" value="<%=V("field_datasize")%>" placeholder="长度" />
                    </span>
                    <span class="t-normal ml5" name="t_field_type" <%=OW.iif(ACT="edit","style=""display:none;""","")%>>
                        <a class="mr10" id="adv_opt_btn" href="javascript:;">高级</a>
                        字段类型一旦确定后不能再修改
                    </span>
                    <div id="field_options_grid" <%=OW.iif(bShowOptions,"","style=""display:none;""")%>>
                        <div class="head-line">备选内容</div>
                        <textarea class="textarea" name="field_options"><%=replace(V("field_options"),"||",chr(10))%></textarea>
                        <span class="t-normal ml5" name="t_field_options">一行代表一个选项，如果值和显示项不同可以用:隔开，如men:男</span>
                    </div>
                    </td>
                </tr>
                <tr><td class="titletd">是否为必填项</td>
                    <td class="infotd">
                    <label><input type="checkbox" name="not_null" value="1" <%=OW.iif(V("not_null")=1,"checked","")%> />必填</label>
                    <span class="t-normal ml5" name="t_not_null"></span>
                    </td>
                </tr>
                </tbody>
                </table>
            </div>
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                <tr><td class="titletd top">默认内容</td>
                    <td class="infotd">
                    <textarea class="textarea textarea-mini" name="field_default" onblur="OW.onblur(this,{length:250})"><%=V("field_default")%></textarea>
                    <span class="t-normal ml5" name="t_tips"></span>
                    </td>
                </tr>
                <tr><td class="titletd top">字段提示</td>
                    <td class="infotd">
                    <input class="text text-long" name="tips" onblur="OW.onblur(this,{length:250})" value="<%=V("tips")%>" />
                    <span class="t-normal ml5" name="t_tips">后台填写字段数据时的提示</span>
                    </td>
                </tr>
                </table>
            </div>
        </div>
        <div class="button-container">
            <button type="submit" class="btn btn-large btn-primary" name="submit">确定保存</button>
            <button type="reset" class="btn btn-large" name="reset">重置</button>
            <button type="button" class="btn btn-large" name="close" onClick="OW.goBack();">关闭</button>
        </div>
        </form>
    </div>
    <script type="text/javascript">
	$(document).ready(function(){
		//提交保存数据
		$("#save_form").submit(function(){
			var check = true;
			//**
			OW.parseFormInputValue({form:$("div.login-form")});
			//**
			var filedType = $("select[name='field_type']").find(":selected").attr("value");
			if(filedType=="radio" || filedType=="checkbox" || filedType=="select"){
				if(!V.input({me:$("textarea[name='field_options']"),tip:$("span[name='t_field_options']"),okValue:'',errorValue:'请先填写备选内容'})){check=false;};
			};
			if(!V.select({me:$("select[name='field_type']"),tip:$("span[name='t_field_type']"),okValue:'',errorValue:'请先选择字段类型'})){check=false;};
			if(!V.input({me:$("input[name='field_name']"),tip:$("span[name='t_field_name']"),okValue:'',errorValue:'请先填写字段名称'})){check=false;};
			if(!V.input({me:$("input[name='field']"),tip:$("span[name='t_field']"),okValue:'',errorValue:'请先填写字段'})){check=false;};
			if(check){Admin.dialogPosting();};
			return check;
		});
		//**字段类型
		var $fieldType = $("select[name='field_type']");
		var $fieldDatatype = $("select[name='field_datatype']");
		var $fieldDatasize = $("input[name='field_datasize']");
		//**
		var $advOptBtn = $("#adv_opt_btn");
		var $advOptGrid = $("#adv_opt_grid");
		var $fieldOptionsGrid = $("#field_options_grid");
		//**
		if(ACT=="edit"){$fieldType.attr("disabled",true)};
		//**
		$fieldType.change(function(){
			var type = $(this).val();
			if(type=="select" || type=="radio" || type=="checkbox"){
				$fieldOptionsGrid.show("fast");
			}else{
				$fieldOptionsGrid.hide("fast");
			};
			if(type=="text" || type=="textarea" || type=="radio" || type=="checkbox" || type=="select"){
				$fieldDatatype.find("option[value='text'],option[value='nvarchar']").attr("selected",true);
				$fieldDatatype.attr("disabled",false);
				$fieldDatasize.val(250).show("fast").removeClass("disabled").attr("disabled",false);
			}else if(type=="image"){
				$fieldDatatype.find("option[value='text'],option[value='nvarchar']").attr("selected",true);
				$fieldDatatype.attr("disabled",true);
				$fieldDatasize.val(255).show("fast").addClass("disabled").attr("disabled",true);
			}else if(type=="editor" || type=="images"){
				$fieldDatatype.find("option[value='memo'],option[value='ntext']").attr("selected",true);
				$fieldDatatype.attr("disabled",true);
				$fieldDatasize.hide("fast");
			}else if(type=="number"){
				$fieldDatatype.find("option[value='integer'],option[value='int']").attr("selected",true);
				$fieldDatatype.attr("disabled",false);
				$fieldDatasize.hide("fast");
			}else if(type=="file"){
				$fieldDatatype.find("option[value='integer'],option[value='int']").attr("selected",true);
				$fieldDatatype.attr("disabled",true);
				$fieldDatasize.hide("fast");
			}else if(type=="money"){
				$fieldDatatype.find("option[value='currency'],option[value='money']").attr("selected",true);
				$fieldDatatype.attr("disabled",true);
				$fieldDatasize.hide("fast");
			}else if(type=="datetime"){
				$fieldDatatype.find("option[value='date'],option[value='datetime']").attr("selected",true);
				$fieldDatatype.attr("disabled",true);
				$fieldDatasize.hide("fast");
			};
		});
		$fieldDatatype.change(function(){
			var type = $(this).val();
			if(type=="text" || type=="nvarchar"){
				$fieldDatasize.show("fast");
			}else{
				$fieldDatasize.hide("fast");
			};
		});
		$advOptBtn.toggle(
			function(){$advOptGrid.show("fast");$advOptBtn.html("收起");},
			function(){$advOptGrid.hide("fast");$advOptBtn.html("高级");}
		);
	});
    </script>
    <%
		call Admin.echoFooter()
	end function
	
	private function doingSave()
		dim check,result,table,tmpDataType
		'**数据库初始化
		check = true
		'**接收数据
		V("field")          = OW.validDBData(OW.getForm("post","field"),50)
		V("field_name")     = OW.validDBData(OW.getForm("post","field_name"),50)
		V("field_type")     = OW.validDBData(OW.getForm("post","field_type"),20)
		V("field_datatype") = OW.validDBData(OW.getForm("post","field_datatype"),20)
		V("field_datasize") =  OW.int(OW.getForm("post","field_datasize"))
		V("field_default")  = OW.validDBData(OW.getForm("post","field_default"),250)
		V("field_options")  = OW.getForm("post","field_options")
		V("not_null")       = OW.int(OW.getForm("post","not_null"))
		V("tips")           = OW.validDBData(OW.getForm("post","tips"),250)
		V("display")        = OW.int(OW.getForm("post","display"))
		'**数据处理
		tmpDataType = Admin.createFieldDataType(V("field_type"))
		if tmpDataType<>"" then V("field_datatype")=tmpDataType
		if V("field_datatype")="text" or V("field_datatype")="nvarchar" then
			if V("field_datasize")=0 then V("field_datasize")=250
		end if
		if V("field_type")="image" then V("field_datasize")=255
		if V("field_datasize")<0   then V("field_datasize")=0
		if V("field_datasize")>255 then V("field_datasize")=255
		'**
		V("field_options") = replace(V("field_options"),chr(10),"||")
		V("field_options") = replace(V("field_options"),chr(13),"")
		V("field_options") = replace(V("field_options"),"<br>","")
		V("field_options") = replace(V("field_options"),"<br/>","")
		
		'**数据合法性校验
		if not Admin.validate("s",V("field"),"minLength:1,maxLength:0","必须填写字段") then check = false
		if not Admin.validate("s",V("field_name"),"minLength:1,maxLength:0","必须填写字段名称") then check = false
		'**
		if ACT = "add" then
			if not Admin.validate("s",V("field_type"),"minLength:1,maxLength:0","必须填写字段类型") then check = false
			'**判断模型表名是否已存在
			if OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"model_field WHERE field='"& V("field") &"' AND model_id="& V("model_id") &" AND "& OW.DB.auxSQL &"") then check = false : Admin.errorSetting("此字段已存在，请填写未被使用的字段；")
		elseif ACT = "edit" then
			'**
		end if
		
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			'**获取模型表
			V("model_table") = OW.DB.getFieldValueBySQL("SELECT model_table FROM "& DB_PRE &"model WHERE model_id="& V("model_id") &" AND "& OW.DB.auxSQL &"")
			table = OW.DB.Table.content &"_"& V("model_table")
			'**
			if ACT = "add" then
				'**
				V("field_id") = OW.DB.maxID(DB_PRE &"model_field","field_id") + 1
				V("sequence") = OW.DB.getFieldValueBySQL("SELECT max(sequence) FROM "& DB_PRE &"model_field WHERE model_id="& V("model_id") &" AND "& OW.DB.auxSQL &"") + 1
				'**
				bResult = OW.DB.addRecord(DB_PRE &"model_field",array("field_id:"& V("field_id"),"site_id:"& SITE_ID,"model_id:"& V("model_id"),"field:"& V("field"),"field_name:"& V("field_name"),"field_type:"& V("field_type"),"field_datasize:"& V("field_datasize"),"field_default:"& V("field_default"),"field_options:"& V("field_options"),"not_null:"& V("not_null"),"tips:"& V("tips"),"sequence:"& V("sequence"),"status:0","display:"& V("display")))
				
				'**增加表字段
				if bResult then
					V("table_field_datatype") = Admin.createFieldDataTypeSize(V("field_datatype"),V("field_datasize"))
					bResult = OW.DB.addColumn(table, "["& V("field") &"] "& V("table_field_datatype") &" NULL")
				end if
				'**
				Admin.actionFinishSuccess = bResult
				Admin.actionFinishSuccessText = array("成功添加模型字段："& V("field"),array("返回列表>index.asp?ctl="& CTL &"&act=list&model_id="& V("model_id") &"","继续添加>index.asp?ctl="& CTL &"&act="& ACT &"&model_id="& V("model_id") &""))
				Admin.actionFinishFailText = array("添加模型字段失败："& V("field"),array("返回列表>index.asp?ctl="& CTL &"&act=list&model_id="& V("model_id") &"","继续添加>index.asp?ctl="& CTL &"&act="& ACT &"&model_id="& V("model_id") &""))
				Admin.actionFinishRun()
			elseif ACT = "edit" then
				V("field_o") = OW.DB.getFieldValueBySQL("SELECT field FROM "& DB_PRE &"model_field WHERE field_id="& V("field_id") &" AND "& OW.DB.auxSQL &"")
				bResult = true
				if V("field_o")<>V("field") and DB_TYPE=1 then
					bResult = OW.DB.editColumn(table,V("field_o"),V("field"))
				end If
				if bResult then
					select case DB_TYPE
					case 0
					bResult = OW.DB.updateRecord(DB_PRE &"model_field",array("field_name:"& V("field_name"),"field_default:"& V("field_default"),"field_options:"& V("field_options"),"not_null:"& V("not_null"),"tips:"& V("tips"),"display:"& V("display")),array("field_id:"& V("field_id")))
					case 1
					bResult = OW.DB.updateRecord(DB_PRE &"model_field",array("field:"& V("field"),"field_name:"& V("field_name"),"field_default:"& V("field_default"),"field_options:"& V("field_options"),"not_null:"& V("not_null"),"tips:"& V("tips"),"display:"& V("display")),array("field_id:"& V("field_id")))
					end select
				end if
				'**
				Admin.actionFinishSuccess = bResult
				Admin.actionFinishSuccessText = array("成功编辑模型字段："& V("field"),"返回列表>index.asp?ctl="& CTL &"&act=list&model_id="& V("model_id") &"")
				Admin.actionFinishFailText = array("编辑模型字段失败："& V("field"),"")
				Admin.actionFinishRun()
			end if
		end if
	end function
	
	private function list()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <div class="top-area">
            <table cellspacing="0" cellpadding="0" border="0">
              <tbody>
              <tr>
              <td class="do-cell">
                  <div class="do-cell-name">添加操作区</div>
                  <div class="do-cell-btn"><a class="btn btn-primary" id="add_new" href="index.asp?ctl=<%=CTL%>&act=add&model_id=<%=V("model_id")%>">添加字段</a></div>
              </td>
              <td class="do-cell">
                  <div class="do-cell-name">删除操作区</div>
                  <div class="do-cell-btn"><button class="btn" id="delete_selected">批量删除</button></div>
              </td>
              </tr>
              </tbody>
            </table>
        </div>
        <div class="list-area" id="data_list_area">
            <table border="0" cellpadding="0" cellspacing="0" width="100%" class="listTable">
              <thead>
                  <tr class="thead">
                      <th><input type="checkbox" name="select_all" id="select_all"></th>
                      <th>字段id</th>
                      <th>字段</th>
                      <th>字段名称</th>
                      <th>字段类型</th>
                      <th>是否为必填项</th>
                      <th>排序</th>
                      <th>操作</th>
                  </tr>
              </thead>
              <tbody>
              <%=listing()%>
              </tbody>
            </table>
        </div>
    </div>
    <script type="text/javascript">
    $(window).ready(function(){
		var $dataListArea = $("#data_list_area");
		Admin.dataListTableInit({
			ctl:"<%=CTL%>",
			act_edit:"edit",
			field_name:"field_name",
			status_validValue:"正常",
			status_validTitle:"点击可设置为已停用状态",
			status_invalidValue:'已停用',
			status_invalidTitle:'点击可设置为正常状态',
			delete_confirm:"删除后字段将无法恢复，您确定要删除吗？",
			delete_confirm2:"删除后字段{tpl:name}将无法恢复，您确定要删除吗？",
			delete_doing:"正在删除字段...",
			delete_success:"删除成功",
			delete_failed:"删除操作失败",
			delete_tip:"请先选择您要删除的字段"
		});
		//**是否为必填项
		$dataListArea.find("td[field='not_null']").each(function(){
			if(parseInt($(this).attr("value"))==1){
				$(this).html("必填");
			}else{
				$(this).html("可为空");
			};
		});
		//**编辑
		var $edit = $("#data_list_area a[name='edit']");
		$edit.each(function(){
			$(this).attr("href","?ctl="+CTL+"&act=edit&id="+$(this).parent().parent().attr("value")+"&model_id=<%=V("model_id")%>");
		});
	});
    </script>
	<%
		call Admin.echoFooter()
	end function
	
	private function listing()
		Admin.list("fields") = "field_id,field,field_name,field_type,not_null,sequence"
		Admin.list("sql") = "SELECT "& Admin.list("fields") &" FROM ["& DB_PRE &"model_field] a WHERE model_id="& V("model_id") &" AND "& OW.DB.auxSQL &" ORDER BY sequence ASC"
		Admin.list("pagesize") = Admin.getPageSise(ACTION_ID)
		Admin.list("checkboxExists") = true
		Admin.list("opeations") = "<a class=""btn btn-small btn-primary mr5"" name=""edit"" href=""javascript:;"">编辑</a><a class=""btn btn-small"" name=""delete"" href=""javascript:;"">删除</a>"
		Admin.list("auxURLPara") = "model_id="& V("model_id") &""
		Admin.list("returnType") = "html"
		listing = Admin.getDataList()
	end function

end class
%>