<%
'**
'站点管理
'**
dim AP_NAVIGATOR
class AP_NAVIGATOR_CLASS
	
	public result
	private aArr,oRs,iI
	private bAuxSQLValid,bShowAdvGrid,bShowPicSet,sNavigatorTable
	private iIsShop
	
	private sub class_initialize()
		bAuxSQLValid    = false
		sNavigatorTable = DB_PRE &"navigator"
	end sub
	
	public sub init()
		if CTL="navigator" then
			select case ACT
			case "list"
				call list()
			case "add"
				if SUBACT ="get_category_data" then
					call getCategoryData()
				else
					call add(SAVE)
				end if
			case "edit"
				if SUBACT = "sequence_edit" then
					if SAVE then
						bAuxSQLValid = true
						call Admin.sequenceEdit(sNavigatorTable,"nav_id",bAuxSQLValid,array("成功进行网站导航排序","无法更新数据库，网站导航排序失败！"))
					end if
				elseif SUBACT ="get_category_data" then
					call getCategoryData()
				else
					call edit(SAVE)
				end if
			case "delete"
				call delete()
			end select
		end if
	end sub
	
	private sub class_terminate()
	end sub
	
	private function add(byval isSave)
		if isSave then
			call doingSave()
		else
			V("type")      = OW.int(OW.getForm("get","type"))
			V("parent_id") = OW.int(OW.getForm("get","nav_id"))
			if V("parent_id") > 0 then
				V("type") = OW.int(OW.DB.getFieldValueBySQL("SELECT type FROM "& sNavigatorTable &" WHERE nav_id="& V("parent_id") &" AND "& OW.DB.auxSQL &""))
			end if
			call doing()
		end if
	end function
	
	private function edit(byval isSave)
		dim arr
		V("nav_id") = OW.int(OW.getForm("get","id"))
		if V("nav_id")<=0 then
			call Admin.errorSetting("对不起，导航菜单不存在"&"(nav_id:"& V("nav_id") &")")
		else
			if isSave then
				call doingSave()
			else
				arr = OW.DB.getFieldValueBySQL("SELECT parent_id,type,cate_id,sync,name,subname,url,icon,image,target FROM "& sNavigatorTable &" WHERE nav_id="& V("nav_id") &" AND "& OW.DB.auxSQL &"")
				V("parent_id") = arr(0)
				V("type")      = arr(1)
				V("cate_id")   = arr(2)
				V("sync")      = arr(3)
				V("name")      = arr(4)
				V("subname")   = arr(5)
				V("url")       = arr(6)
				V("icon")      = arr(7)
				V("image")     = arr(8)
				V("target")    = arr(9)
				if V("cate_id")="" and V("name")="" then
					call Admin.errorSetting("对不起，导航菜单不存在"&"(nav_id:"& V("nav_id") &")")
				else
					call doing()
				end if
			end if
		end if
	end function
	
	private function delete()
		dim check,i,s,id,arr,isSkip
		check = true
		'**接收数据
		V("ids") = OW.regReplace(OW.getForm("post","ids"),"[^0-9,]","")
		'**数据合法性校验
		if V("ids")="" then check = false : Admin.errorSetting("导航菜单id值传递不正确")
		'**从数据库删除记录
		if check then
			'**数据处理
			arr = split(V("ids"),",")
			'**delete
			for i=0 to ubound(arr)
				V("nav_id") = OW.clng(arr(i))
				if V("nav_id")>0 then
					isSkip = false
					if not(OW.DB.isRecordExistsBySQL("SELECT * FROM "& sNavigatorTable &" WHERE nav_id="& V("nav_id") &" AND "& OW.DB.auxSQL &"")) then
						isSkip = true
						s = s &"导航菜单不存在或已被删除，请刷新页面！(nav_id:"& V("nav_id") &");<br>"
					end if
					if not(isSkip) then
						V("name") = OW.DB.getFieldValueBySQL("SELECT name FROM "& sNavigatorTable &" WHERE nav_id="& V("nav_id") &" AND "& OW.DB.auxSQL &"")
						result = deleteNavigator(V("nav_id"))
						if result then
							s = s &"成功导航菜单 (nav_id:"& V("nav_id") &",name:"& V("name") &")<br>"
						else
							s = s &"从数据库中删除导航菜单失败 (nav_id:"& V("nav_id") &",name:"& V("name") &")<br>"
						end if
					end if
				end if
			next
			'**输出操作结果信息
			Admin.actionFinishSuccess     = result
			Admin.actionFinishSuccessText = array(s,"")
			Admin.actionFinishFailText    = array(s,"")
			Admin.actionFinishRun()
		end if
	end function
	
	private function deleteNavigator(byval navId)
		dim pid,path,result,rs
		result = false
		set rs = OW.DB.getRecordBySQL("SELECT * FROM "& sNavigatorTable &" WHERE nav_id="& navId &" AND "& OW.DB.auxSQL &"")
		if rs.eof then
			V("nav_exist") = false
		else
			V("nav_exist") = true
			pid  = OW.int(rs("parent_id"))
			path = OW.rs(rs("path"))
		end if
		OW.DB.closeRs rs
		if V("nav_exist") then
			result = OW.DB.execute("DELETE FROM "& sNavigatorTable &" WHERE path like '"& path &"%' AND "& OW.DB.auxSQL &"")
			if result then
				call OW.DB.execute("UPDATE "& sNavigatorTable &" SET children=children-1 WHERE nav_id="& pid &" AND "& OW.DB.auxSQL &"")
			end if
		end if
		deleteNavigator = result
	end function
	
	private function getCategoryData()
		dim arr,dataJSON
		V("cate_id") = OW.int(OW.getForm("post","cate_id"))
		if V("cate_id")<=0 then
			call Admin.errorSetting("对不起，栏目id错误"&"(cate_id:"& V("cate_id") &")")
		else
			arr = OW.DB.getFieldValueBySQL("SELECT model_type,cate_type,name,subname,root_id,rootpath,urlpath,icon,image FROM "& DB_PRE &"category WHERE cate_id="& V("cate_id") &" AND "& OW.DB.auxSQL &"")
			V("model_type") = OW.rs(arr(0))
			V("cate_type")  = OW.rs(arr(1))
			V("name")       = OW.rs(arr(2))
			V("subname")    = OW.rs(arr(3))
			V("root_id")    = OW.rs(arr(4))
			V("rootpath")   = OW.rs(arr(5))
			V("urlpath")    = OW.rs(arr(6))
			V("icon")       = OW.rs(arr(7))
			V("image")      = OW.rs(arr(8))
			dataJSON = """category_data"":{""model_type"":"""& V("model_type") &""",""cate_type"":"""& V("cate_type") &""",""name"":"""& V("name") &""",""subname"":"""& V("subname") &""",""root_id"":"""& V("root_id") &""",""rootpath"":"""& V("rootpath") &""",""urlpath"":"""& V("urlpath") &""",""icon"":"""& V("icon") &""",""image"":"""& V("image") &"""}"
		end if
		call Admin.ajaxGetFinishRun(dataJSON)
	end function
	
	private function navigatorOptions(byval selectText, byval name, byval selectedId)
		dim s,rs,ds
		set rs = OW.DB.getRecordBySQL("SELECT nav_id,name,children FROM ["& sNavigatorTable &"] WHERE parent_id=0 AND type="& V("type") &" AND "& OW.DB.auxSQL &"")
		do while not rs.eof
			if rs("nav_id") = selectedId then
				s = s &"<option value="""& rs("nav_id") &""" selected>"& rs("name") &"</option>"
			else
				s = s &"<option value="""& rs("nav_id") &""">"& rs("name") &"</option>"
			end if
			if Ow.int(rs("children"))>0 then
				s = s & navigatorChildrenOptions(rs("nav_id"),selectedId)
			end if
			rs.movenext
		loop
		OW.DB.closeRs rs
		if selectText<>"" then ds = "<option value=""0"">"& selectText &"</option>"
		navigatorOptions = "<select name="""& name &""">"& ds & s &"</select>"
	end function
	
	private function navigatorChildrenOptions(byval parentId,byval selectedId)
		dim i,s,rs,v
		set rs = OW.DB.getRecordBySQL("SELECT nav_id,name,children,depth FROM ["& sNavigatorTable &"] WHERE parent_id="& parentId &" AND "& OW.DB.auxSQL &"")
		do while not rs.eof
			v = ""
			for i=2 to rs("depth")
				v = v &"&nbsp;&nbsp;&nbsp;&nbsp;"
			next
			v = v &"└"& trim(rs("name"))
			'**
			if rs("nav_id") = selectedId then
				s = s &"<option value="""& rs("nav_id") &""" selected>"& v &"</option>"
			else
				s = s &"<option value="""& rs("nav_id") &""">"& v &"</option>"
			end if
			if Ow.int(rs("children"))>0 then
				s = s & navigatorChildrenOptions(rs("nav_id"),selectedId)
			end if
			rs.movenext
		loop
		OW.DB.closeRs rs
		navigatorChildrenOptions = s
	end function
	
	private function doing()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
		'**
		if OW.isNotNul(V("subname")) then bShowAdvGrid = true
		if OW.isNotNul(V("icon")) or OW.isNotNul(V("image")) then bShowPicSet = true
	%>
    <div class="mbody">
        <form name="save_form" id="save_form" action="?ctl=<%=CTL%>&act=<%=ACT%>&id=<%=V("nav_id")%>&save=true" method="post">
        <div class="wbox">
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                <tr><td class="titletd"><i class="important">*</i>位置</td>
                    <td class="infotd">
                    <input type="hidden" name="type" value="<%=V("type")%>" />
                    <select name="type-view" disabled="disabled">
					<%=Admin.createOptions(Admin.navArray,V("type"))%>
                    </select>
                    <span class="t-normal ml5" name="t_type"></span>
                    </td>
                </tr>
                <tr><td class="titletd">上级菜单</td>
                    <td class="infotd">
                    <input type="hidden" name="old_parent_id" value="<%=V("parent_id")%>"/>
					<%=navigatorOptions("一级菜单","parent_id",V("parent_id"))%>
                    <span class="t-normal ml5" name="t_parent_id"></span>
                    </td>
                </tr>
                </table>
            </div>
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                <tr><td class="titletd top">关联页面/栏目/内容</td>
                    <td class="infotd">
                    <%=Admin.navMenuSelect("navpage","=页面=",V("url"))%>
                    <%=Admin.categoryOptions(-1,"=栏目/内容=","cate_id",V("cate_id"))%>
                    <label class="ml5"><input type="checkbox" name="sync" value="1" <%=OW.iif(V("sync")=1,"checked","")%> />栏目同步</label>
                    <span><a href="javascript:void(0);" onclick="Admin.showHelpMsg(this,{content:'<b>栏目同步</b><br>是指此导航菜单的菜单名称、菜单副名、菜单链接(url)和图片设置都和栏目保持一致。'});"><b class="icon icon-help-msg"></b></a></span>
                    <span class="t-normal" name="t_cate_id">选择页面/栏目/内容可自动生成菜单名称和菜单链接，当然也可以手工填写(不需要选择)。</span>
                    </td>
                </tr>
                <tr><td class="titletd top"><i class="important">*</i>菜单名称</td>
                    <td class="infotd">
                    <input type="text" class="text text-long" name="name" maxlength="100" placeholder="" value="<%=V("name")%>"/>
                    <span class="t-normal ml5" name="t_name"></span>
                    <a href="javascript:;" id="adv_btn"><%=OW.iif(bShowAdvGrid,"- 收起","+ 高级")%></a>
                    </td>
                </tr>
                <tr id="adv_grid" <%=OW.iif(bShowAdvGrid,"","style=""display:none;""")%>><td class="titletd top">菜单副名</td>
                    <td class="infotd">
                    <input type="text" class="text" name="subname" maxlength="100" placeholder="" value="<%=V("subname")%>"/>
                    <span class="t-normal ml5" name="t_subname">菜单副名可用作菜单英文名等用途，若不用可不必填写</span>
                    </td>
                </tr>
                <tr id="url_setting"><td class="titletd top"><i class="important">*</i>菜单链接(url)</td>
                    <td class="infotd">
                    <input type="text" class="text text-long" name="url" maxlength="255" placeholder="" value="<%=V("url")%>"/>
                    <span class="t-normal" name="t_url">{$site_hurl} 表示网站网址前缀，网站会自动解析成网址</span>
                    </td>
                </tr>
                <tr id="image_setting"><td class="titletd top">图片设置</td>
                    <td class="infotd">
                    <a href="javascript:;" id="pic_set_btn"><%=OW.iif(bShowPicSet,"- 收起","+ 展开设置")%></a>
                    <div class="inbox mt5" id="pic-set" <%=OW.iif(bShowPicSet,"","style=""display:none;""")%>>
                        <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                        <tbody>
                           <tr><td class="titletd top">icon 图标</td>
                               <td class="infotd">
                               <%=Admin.createImageSelectGrid("icon",V("icon"),"","")%>
                               </td>
                           </tr>
                           <tr><td class="titletd top">导航图片</td>
                               <td class="infotd">
                               <%=Admin.createImageSelectGrid("image",V("image"),"","")%>
                               </td>
                           </tr>
                         </tbody>
                        </table>
                    </div>
                    </td>
                </tr>
            </table>
            </div>
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                <tr><td class="titletd">是否新窗口打开:</td>
                   <td class="infotd">
                   <label><input type="checkbox" name="target" value="_blank" <%=OW.iif(V("target")="_blank","checked","")%> />新窗口</label>
                   </td>
                </tr>
                </table>
            </div>
        </div>
        <div class="button-container">
            <button type="submit" class="btn btn-large btn-primary" name="submit">确定保存</button>
            <button type="reset" class="btn btn-large" name="reset">重置</button>
            <button type="button" class="btn btn-large" name="close" onClick="OW.closeParentDialog()">关闭</button>
        </div>
        </form>
    </div>
    <script type="text/javascript">
	$(document).ready(function(){
		Admin.goBackHide();
		function sync(checked){
			if(checked==true){
				$name.attr("disabled",true).addClass("disabled");
				$subname.attr("disabled",true).addClass("disabled");
				$("#url_setting").hide("fast");
				$("#image_setting").hide("fast");
			}else{
				$name.attr("disabled",false).removeClass("disabled");
				$subname.attr("disabled",false).removeClass("disabled");
				$("#url_setting").show("fast");
				$("#image_setting").show("fast");
			};
		};
		//**
		var $navpage  = $("select[name='navpage']"),
		$category     = $("select[name='cate_id']"),
		$name         = $("input[name='name']"),
		$subname      = $("input[name='subname']"),
		$sync         = $("input[name='sync']");
		//提交保存数据
		var $saveForm = $("#save_form");
		$saveForm.submit(function(){
			OW.parseFormInputValue({form:$saveForm});
			var check  = true;
			var cateId = $category.val();
			if(cateId==0){
				if(!V.input({me:$("input[name='name']"),tip:$("span[name='t_name']"),okValue:'',errorValue:'请先填写菜单名称'})){check=false;};
				if(!V.input({me:$("input[name='url']"),tip:$("span[name='t_url']"),okValue:'',errorValue:'请先填写菜单链接(url)'})){check=false;};
			};
			if(check){Admin.dialogPosting();};
			return check;
		});
		//**高级
		var $advBtn  = $("#adv_btn");
		var $advGrid = $("#adv_grid");
		$advBtn.click(function(){
			if($advGrid.css("display")=="none"){
				$advGrid.show("fast");$(this).html("- 收起");
			}else{
				$advGrid.hide("fast");$(this).html("+ 高级");
			};
		});
		//**图片设置
		var $picSet = $("#pic-set");
		$("#pic_set_btn").click(function(){
			if($picSet.css("display")=="none"){
				$picSet.show("fast");$(this).html("- 收起");
			}else{
				$picSet.hide("fast");$(this).html("+ 展开设置");
			};
		});
		$navpage.change(function(){
			var name = $navpage.find("option:selected").text(),
			url      = $navpage.find("option:selected").attr("url");
			$("input[name='name']").val(name);
			$("input[name='url']").val(url);
		});
		//**选择栏目
		$category.change(function(){
			var cateId = $category.val();
			var url,category,modelType,cateType,name,subname,rootId,rootpath,urlpath,icon,image;
			if(cateId>0){
				var diaLoading = OWDialog('<span class="loading">正在获取数据 ... </span>');
				$sync.attr("disabled",false);
				Admin.ajax({
					me:"",data:'cate_id='+cateId,
					url:"index.asp?ctl=<%=CTL%>&act=<%=ACT%>&subact=get_category_data&r="+OW.random(),
					success:function(data){
						category  = Admin.ajaxData.category_data;
						modelType = OW.int(category.model_type);
						cateType  = OW.int(category.cate_type);
						name      = OW.trim(category.name);
						subname   = OW.trim(category.subname);
						rootId    = OW.int(category.root_id);
						rootpath  = OW.trim(category.rootpath);
						urlpath   = OW.trim(category.urlpath);
						icon      = OW.trim(category.icon);
						image     = OW.trim(category.image);
						if(cateType==0){
							if(modelType==0){
								if(rootId>0){
									url = "{$site_hurl}"+ rootpath +"/"+ urlpath +"/";
								}else{
									url = "{$site_hurl}"+ urlpath +"/";
								};
							}else{
								url = "{$site_hurl}"+ urlpath +"<%=SITE_HTML_FILE_SUFFIX%>";
							};
						};
						$("input[name='name']").val(name);
						$("input[name='subname']").val(subname);
						$("input[name='url']").val(url);
						$("input[name='icon']").val(icon);
						if(icon!=""){
							$("div[name='icon-box']").empty().append('<img src="'+icon+'" />');
						}else{
							$("div[name='icon-box']").empty().append('<img src="images/image.jpg" />');
						};
						$("input[name='image']").val(image);
						if(icon!=""){
							$("div[name='image-box']").empty().append('<img src="'+image+'" />');
						}else{
							$("div[name='image-box']").empty().append('<img src="images/image.jpg" />');
						};
						diaLoading.close();
					},
					failed:function(msg){
						diaLoading.error("获取数据失败，请再重新试试。",msg).timeout(1);
					}
				});
			}else{
				$sync.attr("disabled",true);
				sync(false);
			};
		});
		//**栏目同步
		$sync.click(function(){
			var cateId = $category.val();
			if(cateId>0){
				sync($(this).attr("checked"));
			};
		});
		if(ACT=="edit"){
			var is_sync = <%=OW.int(V("sync"))%>;
			if(is_sync==1){
				sync(true);
			};
		};
	});
    </script>
    <%
		call Admin.echoFooter()
	end function
	
	private function doingSave()
		dim arr,check
		'**数据库初始化
		check = true
		'**接收数据
		V("type")          = OW.int(OW.getForm("post","type"))
		V("old_parent_id") = OW.int(OW.getForm("post","old_parent_id"))
		V("parent_id")     = OW.int(OW.getForm("post","parent_id"))
		V("name")          = OW.validDBData(OW.getForm("post","name"),100)
		V("subname")       = OW.validDBData(OW.getForm("post","subname"),100)
		V("cate_id")       = OW.int(OW.getForm("post","cate_id"))
		V("sync")          = OW.int(OW.getForm("post","sync"))
		'**
		V("url")           = OW.validDBData(OW.getForm("post","url"),255)
		V("icon")          = OW.validDBData(OW.getForm("post","icon"),255)
		V("image")         = OW.validDBData(OW.getForm("post","image"),255)
		V("target")        = OW.validDBData(OW.getForm("post","target"),10)
		'**
		if V("cate_id")>0 and V("sync")=1 then
			arr = OW.DB.getFieldValueBySQL("SELECT name,subname,icon,image,model_type,cate_type,root_id,rootpath,urlpath FROM "& DB_PRE &"category WHERE cate_id="& V("cate_id") &" AND "& OW.DB.auxSQL &"")
			V("name")    = arr(0)
			V("subname") = arr(1)
			V("icon")    = arr(2)
			V("image")   = arr(3)
			V("model_type") = arr(4)
			V("cate_type")  = arr(5)
			V("root_id")    = arr(6)
			V("rootpath")   = arr(7)
			V("urlpath")    = arr(8)
			V("url")        = Admin.createCateLink(V("model_type"),V("cate_type"),V("root_id"),V("rootpath"),V("urlpath"))
		end if
		if V("parent_id")>0 then
			V("type") = OW.int(OW.DB.getFieldValueBySQL("SELECT type FROM "& sNavigatorTable &" WHERE nav_id="& V("parent_id") &" AND "& OW.DB.auxSQL &""))
		end if
		'**数据处理
		if V("target")<>"_blank" then V("target") = "_self"
		'**数据合法性校验
		if not Admin.validate("s",V("name"),"minLength:1,maxLength:0","必须填写菜单名称") then check = false
		if not Admin.validate("s",V("url"),"minLength:1,maxLength:0","必须填写菜单链接") then check = false
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			if ACT="add" then
				'**
				V("nav_id")   = OW.DB.maxID(sNavigatorTable,"nav_id") + 1
				V("sequence") = OW.int(OW.DB.getFieldValueBySQL("SELECT max(sequence) FROM "& sNavigatorTable &" WHERE parent_id="& V("parent_id") &" AND "& OW.DB.auxSQL &"")) + 1
				'**
				if V("parent_id")>0 then
					V("path") = OW.DB.getFieldValueBySQL("SELECT path FROM "& sNavigatorTable &" WHERE nav_id="& V("parent_id") &" AND "& OW.DB.auxSQL &"")
					V("path") = V("path") & V("nav_id") &","
				else
					V("path") = ","& V("nav_id") &","
				end if
				V("depth") = ubound(split(V("path"),",")) - 1
				'**
				result = addNavigatorData()
				'**
				Admin.actionFinishSuccess     = result
				Admin.actionFinishSuccessText = array("成功添加导航菜单："& V("name"),array("关闭>javascript:OW.closeParentDialog({refresh:true});","继续添加>index.asp?ctl="& CTL &"&act="& ACT &"&nav_id="& V("parent_id") &"&type="& V("type") &""))
				Admin.actionFinishFailText    = array("添加导航菜单失败："& V("name"),"")
				Admin.actionFinishRun()
				
			elseif ACT="edit" then
				'**如果上级菜单变了
				if V("old_parent_id")<>V("parent_id") then
					if V("parent_id")>0 then
						V("path")  = OW.DB.getFieldValueBySQL("SELECT path FROM "& sNavigatorTable &" WHERE nav_id="& V("parent_id") &" AND "& OW.DB.auxSQL &"")
						V("path")  = V("path") & V("nav_id") &","
					else
						V("path")  = ","& V("nav_id") &","
					end if
					V("depth") = ubound(split(V("path"),",")) - 1
				end if
				'**
				result = updateNavigatorData()
				'**
				Admin.actionFinishSuccess     = result
				Admin.actionFinishSuccessText = array("成功编辑导航菜单(nav_id:"& V("nav_id") &",菜单名称:"& V("name") &")","关闭>javascript:OW.closeParentDialog({refresh:true});")
				Admin.actionFinishFailText    = array("编辑导航菜单失败(nav_id:"& V("nav_id") &",菜单名称:"& V("name") &")","")
				Admin.actionFinishRun()
			end if
		end if
	end function
	
	private function addNavigatorData()
		dim arr
		arr = array("site_id:"& SITE_ID,"sequence:"& V("sequence"),"status:0","parent_id:"& V("parent_id"),"nav_id:"& V("nav_id"),"path:"& V("path"),"depth:"& V("depth"),"children:0","type:"& V("type"),"cate_id:"& V("cate_id"),"sync:"& V("sync"),"name:"& V("name"),"subname:"& V("subname"),"url:"& V("url"),"icon:"& V("icon"),"image:"& V("image"),"target:"& V("target"))
		result = OW.DB.addRecord(sNavigatorTable,arr)
		if result then
			'**更新上级栏目的children
			if V("parent_id")>0 then
				call OW.DB.execute("UPDATE "& sNavigatorTable &" SET children=children+1 WHERE nav_id="& V("parent_id") &" AND "& OW.DB.auxSQL &"")
			end if
		end if
		addNavigatorData = result
	end function
	
	private function updateNavigatorData()
		dim arr
		arr = array("cate_id:"& V("cate_id"),"sync:"& V("sync"),"name:"& V("name"),"subname:"& V("subname"),"url:"& V("url"),"icon:"& V("icon"),"image:"& V("image"),"target:"& V("target"))
		result =  OW.DB.updateRecord(sNavigatorTable,arr,array("nav_id:"& V("nav_id")))
		if result then
			'**
			if V("old_parent_id")<>V("parent_id") then
				call OW.DB.updateRecord(sNavigatorTable,array("parent_id:"& V("parent_id"),"path:"& V("path"),"depth:"& V("depth")),array("nav_id:"& V("nav_id")))
				'**更新原上级的数据
				if V("old_parent_id")>0 then
					call OW.DB.execute("UPDATE "& sNavigatorTable &" SET children=children-1 WHERE nav_id="& V("old_parent_id") &" AND "& OW.DB.auxSQL &"")
				end if
				'**更新上级的数据
				if V("parent_id")>0 then
					call OW.DB.execute("UPDATE "& sNavigatorTable &" SET children=children+1 WHERE nav_id="& V("parent_id") &" AND "& OW.DB.auxSQL &"")
				end if
				'**更新子栏目的数据
				call subNavigatorPathDepthEdit(V("nav_id"),V("path"))
			end if
		end if
		updateNavigatorData = result
	end function
	
	private function subNavigatorPathDepthEdit(byval navId,byval path)
		dim i,id,arr,rs,sql,ok,tmpPath,tmpDepth
		sql = "SELECT nav_id,path,depth FROM "& sNavigatorTable &" WHERE path like '%,"& navId &",%' AND nav_id<>"& navId &" AND "& OW.DB.auxSQL &""
		set rs = OW.DB.getRecordBySQL(sql)
		do while not rs.eof
			id      = rs("nav_id")
			arr     = split(rs("path"),",")
			ok      = false
			tmpPath = path
			for i=0 to ubound(arr)
				if trim(arr(i))<>"" then
					if ok=true then tmpPath = tmpPath & arr(i) &","
					if OW.int(cate_id)=OW.int(arr(i)) then ok = true
				end if
			next
			tmpDepth = ubound(split(tmpPath,",")) - 1
			call OW.DB.updateRecord(sNavigatorTable,array("path:"& tmpPath,"depth:"& tmpDepth),array("nav_id:"& id))
			rs.movenext
		loop
		OW.DB.closeRs rs
	end function
	
	private function list()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
		'**
		V("type") = OW.getForm("get","type")
		'**
		if OW.isNul(V("type")) then V("type")=1
		V("type") = OW.int(V("type"))
	%>
    <style type="text/css">
	table.listTable tr.data td{
		border-left:1px solid #f2f2f2;
		border-top:1px solid #f2f2f2;
	}
    </style>
    <div class="mbody">
        
        <div class="top-area">
            <table cellspacing="0" cellpadding="0" border="0">
              <tbody>
              <tr>
              <td class="do-cell">
                  <div class="do-cell-name">添加操作区</div>
                  <div class="do-cell-btn"><a class="btn btn-primary" id="add_new" href="index.asp?ctl=<%=CTL%>&act=add&type=<%=V("type")%>">添加导航菜单</a></div>
              </td>
              <td class="do-cell">
                  <div class="do-cell-name">删除操作区</div>
                  <div class="do-cell-btn"><button class="btn" id="delete_selected">批量删除</button></div>
              </td>
              <td class="do-cell">
                  <div class="do-cell-name text-left">系统提示</div>
                  <div class="do-cell-btn">排序只在同一父类下的同级间比较，数字越小越靠前。</div>
              </td>
              </tr>
              </tbody>
            </table>
        </div>
        <div class="tabbar">
            <ul>
            <li <%=OW.iif(V("type")=1,"class=""current""","")%>><a href="index.asp?ctl=<%=CTL%>&act=<%=ACT%>&type=1">网站主导航</a></li>
            <li <%=OW.iif(V("type")=0,"class=""current""","")%>><a href="index.asp?ctl=<%=CTL%>&act=<%=ACT%>&type=0">顶部导航</a></li>
            <li <%=OW.iif(V("type")=2,"class=""current""","")%>><a href="index.asp?ctl=<%=CTL%>&act=<%=ACT%>&type=2">底部导航</a></li>
            <% if OS.versionType="x" then %>
            <li <%=OW.iif(V("type")=3,"class=""current""","")%>><a href="index.asp?ctl=<%=CTL%>&act=<%=ACT%>&type=3">商城主导航</a></li>
            <% end if %>
            <li <%=OW.iif(V("type")=4,"class=""current""","")%>><a href="index.asp?ctl=<%=CTL%>&act=<%=ACT%>&type=4">用户中心导航</a></li>
            <li <%=OW.iif(V("type")=5,"class=""current""","")%>><a href="index.asp?ctl=<%=CTL%>&act=<%=ACT%>&type=5">手机端主导航</a></li>
            </ul>
        </div>
        <div class="category-list">
        <div class="list-area" id="data_list_area">
            <table border="0" cellpadding="0" cellspacing="0" width="100%" class="listTable">
              <thead>
                  <tr class="thead">
                      <th><input type="checkbox" name="select_all" id="select_all"></th>
                      <th>nav_id</th>
                      <th>菜单名称</th>
                      <th>位置</th>
                      <th>是否与关联栏目同步</th>
                      <th>排序</th>
                      <th>操作</th>
                  </tr>
              </thead>
              <%=listing(0)%>
            </table>
        </div>
        </div>
    </div>
    <script type="text/javascript">
    $(window).ready(function(){
		Admin.categoryDeleting = true;
		Admin.dataListTableInit({
			ctl:"<%=CTL%>",
			act_edit:"edit",
			field_name:"name",
			status_validValue:"正常",
			status_validTitle:"点击可设置为隐藏状态",
			status_invalidValue:'隐藏',
			status_invalidTitle:'点击可设置为正常状态',
			delete_confirm:"删除后栏目及其下的所有内容数据将被删除，无法恢复，您确定要删除吗？",
			delete_confirm2:"删除后栏目{tpl:name}及其下的所有内容数据将被删除，无法恢复，您确定要删除吗？",
			delete_doing:"正在删除栏目...",
			delete_success:"删除成功",
			delete_failed:"删除操作失败",
			delete_tip:"请先选择您要删除的栏目",
			delete_success_callback:function(id){
				$("tr.data[root_id="+id+"]").remove();
			},
		});
		//**添加
		$("#add_new").click(function(){
			var dialog = OWDialog({
				id:'d_add_new',
				title:'添加导航菜单',
				iframe:$(this).attr("href"),
				padding:'0px',
				height:OW.dialogBigHeight(),
				width:OW.dialogBigWidth()
			});
			return false;
		});
		$("a[name='add_subnav']").click(function(){
			var url = "?ctl="+CTL+"&act=add&nav_id="+$(this).parent().parent().attr("value")+"&type=<%=V("type")%>";
			var dialog = OWDialog({
				id:'d_add_new',
				title:'添加子菜单',
				iframe:url,
				padding:'0px',
				height:OW.dialogBigHeight(),
				width:OW.dialogBigWidth()
			});
			return false;
		});
		//**编辑
		$("a[name='edit']").click(function(){
			var dialog = OWDialog({
				id:'d_nav_edit',
				title:'导航菜单编辑',
				iframe:$(this).attr("href"),
				padding:'0px',
				height:OW.dialogBigHeight(),
				width:OW.dialogBigWidth()
			});
			return false;
		});
		//**点击收起
		$("span[name='node-switch'][children_count=0]").addClass("none-children");
		$("span[name='node-switch']").click(function(){
			var nav_id  = $(this).attr("nav_id"); 
			var $tr     = $("tr[root_id='"+nav_id+"']:not([pid=0])");
			if($(this).attr("type")=="close"){
				$tr.show();
				$(this).removeClass("close").addClass("open").attr("type","open");
			}else{
				$tr.hide();
				$(this).removeClass("open").addClass("close").attr("type","close");
			};
		});
		$("span[name='node-switch']").click();
		//**栏目类型
		$("#data_list_area td[field='type']").each(function(){
			var a = new Array("顶部导航","主导航","底部导航","商城主导航","用户中心导航","手机端主导航"),
			css   = "cate-type-"+$(this).attr("value");
			$(this).html('<font class="'+css+'">'+a[$(this).attr("value")]+'</font>');
			$(this).prev().addClass(css);
		});
		//**推荐
		$("#data_list_area td[field='sync']").each(function(){
			if($(this).attr("value")==1){
				$(this).html("同步");
			}else{
				$(this).html("否");
			};
		});
		//**
	});
    </script>
	<%
		call Admin.echoFooter()
	end function
	
	private function listing(byval parentId)
		dim cols,sql,ope
		dim navId,path,depth,children,navName
		dim i,s,rs,html,htmls,colspan
		'**
		cols = "nav_id,sequence,children,path,depth,type,sync,name,subname"
		sql  = "SELECT "& cols &" FROM "& sNavigatorTable &" WHERE type="& V("type") &" AND parent_id="& parentId &" AND "& OW.DB.auxSQL &" ORDER BY type ASC,sequence ASC"
		'**
		ope = "<a class=""btn btn-small btn-primary mr5"" name=""add_subnav"" href=""javascript:;"">添加子菜单</a><a class=""btn btn-small mr5"" name=""edit"" href=""javascript:;"">编辑</a><a class=""btn btn-small"" name=""delete"" href=""javascript:;"">删除</a>"
		'**
		colspan = ubound(split(cols,","))+1
		'**
		set rs = OW.DB.getRecordBySQL(sql)
		if rs.bof and rs.eof then
			html = "<tr><td colspan="""& colspan &""">暂无数据 ...</td></tr>"
		else
			do while not rs.eof
				s        = ""
				navId    = rs("nav_id")
				path     = rs("path")
				depth    = OW.int(rs("depth"))
				children = OW.int(rs("children"))
				navName = rs("name")
				'**
				s = s &"<td><input type=""checkbox"" name=""data-checkbox""></td>"
				s = s &"<td field=""nav_id"" value="""& navId &""">"& navId &"</td>"
				s = s &"<td field=""name"" value="""& navName &""">"
				
				if depth=1 then
					s = s &"<span class=""node-switch open"" name=""node-switch"" nav_id="""& navId &""" children_count="""& children &"""></span>"
				else
					for i=2 to depth
						if i=2 then
							s = s &""
						else
							s = s &"<span class=""blank-space""></span>"
						end if
					next
					s = s &"<span class=""node-sub-indent""></span>"
				end if
				s = s &"<span class=""name"">"& OW.iif(depth=1,"<b>"& navName &"</b>",navName) &"</span><span class=""subname"">"& rs("subname") &"</span>"
				
				s = s &"</td>"
				s = s &"<td field=""type"" value="""& rs("type") &""">"& rs("type") &"</td>"
				s = s &"<td field=""sync"" value="""& rs("sync") &""">"& rs("sync") &"</td>"
				s = s &"<td field=""sequence"" value="""& rs("sequence") &""">"& rs("sequence") &"</td>"
				s = s &"<td name=""opeation"">"& ope &"</td>"
				'**
				html = html &"<tr class=""data"" root_id="""& split(path,",")(1) &""" pid="""& parentId &""">"& s &"</tr>"
				'**
				if children>0 then
					html = html & listing(navId)
				end if
				rs.movenext
			loop
		end if
		set rs = nothing
		'**
		listing = html
	end function

end class
%>