﻿<%
'**
'站点管理
'**
dim AP_PLUGINS
class AP_PLUGINS_CLASS
	
	private aArr,oRs,iI,bResult
	private bAuxSQLValid
	private iIsShop,iPluginCenter
	
	private sub class_initialize()
		bAuxSQLValid = false
	end sub
	
	public sub init()
		iPluginCenter = CBool(OW.regReplace(OW.getForm("get","plugin_center"),"[^a-z]","")="true")
		if CTL="plugins" then
			select case ACT
			case "list"
				if iPluginCenter then
					call pluginCenter()
				else
					call pluginList()
				end if
			case "edit"
				if SUBACT = "status_edit" then
					if SAVE then
						call Admin.statusEdit(DB_PRE &"plugins","plugin_id",bAuxSQLValid ,array("成功更改应用状态","无法更新数据库，应用状态更改失败！"))
					end if
				elseif SUBACT = "sequence_edit" then
					if SAVE then
						call Admin.sequenceEdit(DB_PRE &"plugins","plugin_id",bAuxSQLValid,array("成功进行应用排序","无法更新数据库，应用排序失败！"))
					end if
				end if
			case "add"
				call install()
			case "delete"
				call uninstall()
			end select
		end if
	end sub
	
	private sub class_terminate()
	end sub
	
	private function pluginDownload(byval plugin)
		dim result : result = false
		pluginDownload = result
	end function
	
	private function isPluginHaveDownload(byval plugin)
		dim result : result = false
		if OW.FSO.folderExists(OS.pluginsRoot & plugin &"/") then
			result = true
		end if
		isPluginHaveDownload = result
	end function
	
	private function install()
		dim check : check = true
		dim plugin
		
		plugin = OW.left(OW.regReplace(OW.getForm("get","plugin"),"[^0-9a-zA-Z_]",""),32)
		if plugin="" then check = false : Admin.errorSetting("应用参数传递错误，无法或许应用信息！")
		
		'判断插件是否已下载,未下载则先下载
		if not isPluginHaveDownload(plugin) then
			check = pluginDownload(plugin)
			if not check then Admin.errorSetting("应用下载失败，请重新点击安装！")
		end if
		
		'判断是否已安装
		if OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"plugins WHERE plugin_code='"& plugin &"'") then check = false : Admin.errorSetting("此应用已安装，不需要再安装了！")
		'直接进入安装程序
		if check then
			if Admin.pluginIntall(plugin) then
				call installing(plugin)
				bResult = true
			end if
			Admin.actionFinishSuccess     = bResult
			Admin.actionFinishSuccessText = array("成功安装插件("& V("plugin_name") &")","")
			Admin.actionFinishFailText    = array("插件("& V("plugin_name") &")安装失败","")
			Admin.actionFinishRun()
		end if
	end function
	
	private function installing(byval plugin)
		dim arr,i,json,pluginAdapted,pluginAuthor,pluginAuthorURL,pluginAuthorLink,pluginCode,pluginLogo,pluginId,pluginName,pluginVersion,rs,s,sql,xmlFile,installTime,sequence,status
		pluginCode  = plugin
		set xmlFile = OW.createXMLDoc("")
		xmlFile.loadxml OW.read(OS.pluginsRoot & pluginCode &"/plugin.xml")
		pluginAdapted   = xmlFile.selectSingleNode("plugin").selectSingleNode("adapted").text
		pluginAuthor    = xmlFile.selectSingleNode("plugin").selectSingleNode("author").selectSingleNode("name").text
		pluginAuthorURL = xmlFile.selectSingleNode("plugin").selectSingleNode("author").selectSingleNode("url").text
		pluginLogo      = xmlFile.selectSingleNode("plugin").selectSingleNode("logo").text
		pluginName      = xmlFile.selectSingleNode("plugin").selectSingleNode("name").text
		pluginVersion   = xmlFile.selectSingleNode("plugin").selectSingleNode("version").text
		V("plugin_name")= pluginName
		'**插件表
		arr = array("plugin_code:"& pluginCode,"plugin_name:"& pluginName,"plugin_logo:"& pluginLogo,"plugin_version:"& pluginVersion,"plugin_author:"& pluginAuthor,"install_time:"& SYS_TIME,"plugin_sn:","sequence:1","status:0")
		if not OW.DB.addRecord(DB_PRE &"plugins",arr) then call OW.DB.addRecord(DB_PRE &"plugins",arr)
		'**创始人使用应用的权限**
		'**清除干净以前的权限
		call OW.DB.execute("DELETE FROM ["& DB_PRE &"admin_action] WHERE ctl='"& pluginCode &"' AND is_plugin=1")
		'**重新添加权限
		set rs = OW.DB.getRecordBySQL("SELECT site_id FROM ["& DB_PRE &"sites] ORDER BY site_id")
		do while not rs.eof
			OW.DB.execute "INSERT INTO ["& DB_PRE &"admin_action] ([site_id],[group_id],[ctl],[act],[is_plugin],[allow]) VALUES ("& rs("site_id") &",1,'"& pluginCode &"','',1,1)"
			rs.movenext
		loop
		OW.DB.closeRs rs
		'**
		installing = true
	end function
	
	private function uninstall()
		dim arr,s
		dim result : result = false
		dim check  : check  = true
		'**接收数据
		V("plugin_id")   = OW.int(OW.getForm("post","ids"))
		arr = OW.DB.getFieldValueBySQL("SELECT plugin_code,plugin_name FROM "& DB_PRE &"plugins WHERE plugin_id="& V("plugin_id") &"")
		V("plugin_code") = arr(0)
		V("plugin_name") = arr(1)
		'**数据合法性校验
		if V("plugin_code")="" then check = false : Admin.errorSetting("应用id值传递不正确")
		'**从数据库卸载记录
		if check then
			result = uninstalling(V("plugin_code"))
			'**输出操作结果信息
			Admin.actionFinishSuccess     = result
			Admin.actionFinishSuccessText = array("应用("& V("plugin_name") &")成功卸载","")
			Admin.actionFinishFailText    = array("应用("& V("plugin_name") &")卸载失败","")
			Admin.actionFinishRun()
		end if
	end function
	
	private function uninstalling(byval pluginCode)
		dim result : result = false
		if Admin.pluginUnintall(pluginCode) then
			call OW.DB.execute("DELETE FROM ["& DB_PRE &"plugins] WHERE plugin_code='"& pluginCode &"'")
			call OW.DB.execute("DELETE FROM ["& DB_PRE &"admin_action] WHERE ctl='"& pluginCode &"' AND is_plugin=1")
			result = true
		end if
		uninstalling = result
	end function
	
	private function pluginCenter()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <div class="tabbar">
            <ul>
            <li tab="1"><a href="index.asp?ctl=plugins&act=list">本地应用</a></li>
            <li tab="2" class="current"><a href="index.asp?ctl=plugins&act=list&plugin_center=true">在线安装更多应用</a></li>
            </ul>
        </div>
        
    </div>
	<%
		call Admin.echoFooter()
	end function
	
	private function pluginList()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <div class="tabbar">
            <ul>
            <li tab="1" class="current"><a href="javascript:;">本地应用</a></li>
            <li tab="2"><a href="index.asp?ctl=plugins&act=list&plugin_center=true">在线安装更多应用</a></li>
            </ul>
        </div>
        <div class="list-area" id="data_list_area">
            <table border="0" cellpadding="0" cellspacing="0" width="100%" class="listTable">
              <thead>
                  <tr class="thead">
                      <th width="1%">应用logo</th>
                      <th>应用名称</th>
                      <th>应用版本</th>
                      <th>应用作者</th>
                      <th>安装时间</th>
                      <th>状态</th>
                      <th>排序</th>
                      <th>操作</th>
                  </tr>
              </thead>
              <tbody>
              <%=pluginListing()%>
              </tbody>
            </table>
        </div>
    </div>
    <script type="text/javascript">
    $(window).ready(function(){
		Admin.dataListTableInit({
			ctl:"<%=CTL%>",
			act_edit:"edit",
			field_name:"plugin_name",
			status_validValue:"正常",
			status_validTitle:"点击可设置为已停用状态",
			status_invalidValue:'已停用',
			status_invalidTitle:'点击可设置为正常状态',
			delete_confirm:"卸载后应用将无法恢复，您确定要卸载吗？",
			delete_confirm2:"卸载后应用{tpl:name}将无法恢复，您确定要卸载吗？",
			delete_doing:"正在卸载应用...",
			delete_success:"应用卸载成功",
			delete_failed:"应用卸载失败",
			delete_tip:"请先选择您要卸载的应用"
		});
		$("#data_list_area a[name='install']").click(function(){
			var plugin     = $(this).attr("plugin");
			var pluginName = $(this).parent().parent().find("td[field='plugin_name']").attr("value");
			var $dialog = OWDialog({content:'<div class="posting">正在安装'+ pluginName +'，请稍候...</div>',follow:$(this),shadow:false});
			Admin.ajax({
				me:"",data:"",url:"index.asp?ctl=<%=CTL%>&act=add&plugin="+ plugin +"&save=true",
				success:function(){
					$dialog.success("安装成功").timeout(2);
					OW.refresh();
				},
				failed:function(msg){
					$dialog.error("安装失败",msg).timeout(2);
				}
			});
		});
		//**详细介绍
		$("#data_list_area a[name='detail']").click(function(){
			var pluginCode    = $(this).parent().parent().find("td[field='plugin_code']").attr("value");
			var pluginName    = $(this).parent().parent().find("td[field='plugin_name']").attr("value");
			var pluginVersion = $(this).parent().parent().find("td[field='plugin_version']").attr("value");
			var dialog = OWDialog({
				id:'d_model_field_manage',
				title:''+ pluginName +' - 详细介绍',
				iframe:'http://www.openwbs.com/plugin/detail/?plugin='+ pluginCode +'&version='+ pluginVersion +'&r='+OW.random(),padding:'0px',
				height:OW.dialogBigHeight(),
				width:OW.dialogBigWidth()
			});
		});
		//**
		
	});
    </script>
	<%
		call Admin.echoFooter()
	end function
	
	private function pluginListing()
		dim arr,i,json,pluginAdapted,pluginAuthor,pluginAuthorURL,pluginAuthorLink,pluginCode,pluginLogo,pluginId,pluginName,pluginVersion,s,xmlFile,installTime,sequence,status
		s = OW.FSO.folderList(OS.pluginsRoot,"json")
		set json = OW.JSON.parse(s)
		s = ""
		for i=0 to json.subfolders.length-1
			pluginCode  = json.subfolders.get(i).foldername 
			set xmlFile = OW.createXMLDoc("")
			xmlFile.loadxml OW.read(OS.pluginsRoot & pluginCode &"/plugin.xml")
			pluginAdapted   = xmlFile.selectSingleNode("plugin").selectSingleNode("adapted").text
			pluginAuthor    = xmlFile.selectSingleNode("plugin").selectSingleNode("author").selectSingleNode("name").text
			pluginAuthorURL = xmlFile.selectSingleNode("plugin").selectSingleNode("author").selectSingleNode("url").text
			pluginLogo      = xmlFile.selectSingleNode("plugin").selectSingleNode("logo").text
			pluginName      = xmlFile.selectSingleNode("plugin").selectSingleNode("name").text
			pluginVersion   = xmlFile.selectSingleNode("plugin").selectSingleNode("version").text
			
			arr = OW.DB.getFieldValueBySQL("SELECT plugin_id,install_time,sequence,status FROM "& DB_PRE &"plugins WHERE plugin_code='"& pluginCode &"'")
			pluginId    = OW.int(arr(0))
			installTime = arr(1)
			sequence    = OW.int(arr(2))
			status      = OW.int(arr(3))
			if pluginAuthorURL="" then
				pluginAuthorLink = pluginAuthor
			else
				pluginAuthorLink = "<a href="""& pluginAuthorURL &""" target=_blank>"& pluginAuthor &"</a>"
			end if
			s = s &"<tr value="""& pluginId &""" class=""data"">"
			s = s &"<td field=""plugin_logo"" value="""& pluginLogo &"""><img class=""plugin-logo"" src="""& SITE_PATH & OS.pluginsRoot & pluginCode &"/"& pluginLogo &"""></td>"
			s = s &"<td field=""plugin_name"" value="""& pluginName &""">"& pluginName &"</td>"
			s = s &"<td field=""plugin_version"" value="""& pluginVersion &""">"& pluginVersion &"</td>"
			s = s &"<td field=""plugin_author"" value="""& pluginAuthor &""">"& pluginAuthorLink &"</td>"
			s = s &"<td field=""install_time"" value="""& installTime &""">"& installTime &"</td>"
			'**
			if pluginId>0 then
			s = s &"<td field=""status"" installed=""true"" value="""& status &"""></td>"
			s = s &"<td field=""sequence"" installed=""true"" value="""& sequence &"""></td>"
			s = s &"<td name=""opeation""><a class=""btn btn-small btn-primary mr5"" name=""use"" href=""?ctl="& pluginCode &"&act=manage&is_plugin=true"">使用</a><a class=""btn btn-small mr5"" name=""detail"" href=""javascript:;"">详细介绍</a><a class=""btn btn-small"" name=""delete"" href=""javascript:;"">卸载</a></td>"
			else
			s = s &"<td field=""status"" installed=""false"" value=""0""></td>"
			s = s &"<td field=""sequence"" installed=""false"" value=""0""></td>"
			s = s &"<td name=""opeation""><a class=""btn btn-small mr5"" name=""install"" href=""javascript:;"" plugin="""& pluginCode &""">安装此应用</a><a class=""btn btn-small mr5"" name=""detail"" href=""javascript:;"">详细介绍</a></td>"
			end if
			s = s &"</tr>"
		next
		pluginListing = s
	end function

end class
%>