<%
'**
'站点管理
'**
dim AP_REGION
class AP_REGION_CLASS
	
	private aArr,oRs,sCols,sSQL,iI,iPageSize,sString,sOpeation,sURL,bResult,sTable
	private bAuxSQLValid
	
	private sub class_initialize()
		bAuxSQLValid = false
	end sub
	
	public sub init()
		if CTL="region" then
			select case ACT
			case "list"
				if SUBACT="get_sub_region" then
					call getSubRegion()
				else
					call list()
				end if
			case "add"
				call add(SAVE)
			case "edit"
				if SUBACT="recover" then
					call recover()
				elseIf SUBACT="create_js_file" then
					call createRegionJsFile()
				else
					call edit(SAVE)
				end if
			case "delete"
				call delete()
			end select
		end if
	end sub
	
	private sub class_terminate()
	end sub
	
	private function createRegionJsFile()
		dim text,result
		text   = "var OWRegion = ["& getRegionData(0) &"];"
		result = OW.FSO.saveFile("ow-content/data/ow.region.js",text)
		Admin.actionFinishSuccess = result
		Admin.actionFinishSuccessText = array("成功:生成地区文件","")
		Admin.actionFinishFailText    = array("失败:生成地区文件","")
		Admin.actionFinishRun()
	end function
	
	private function getRegionData(byval parentRegionId)
		dim rs,regionId,regionName,childCount,childRegions,jsonStr,returnStr
		parentRegionId = OW.int(parentRegionId)
		set rs = OW.DB.getRecordBySQL("SELECT region_id,region_name FROM "& DB_PRE &"region WHERE parent_region_id="& parentRegionId &" AND "& OW.DB.auxSQL &" ORDER BY sequence ASC")
		do while not rs.eof
			regionId   = OW.int(rs("region_id"))
			regionName = OW.rs(rs("region_name"))
			childCount = OW.int(OW.DB.getFieldValueBySQL("SELECT count(*) FROM "& DB_PRE &"region WHERE parent_region_id="& regionId &" AND "& OW.DB.auxSQL &""))
			if childCount>0 then
				childRegions = getRegionData(regionId)
			else
				childRegions = ""
			end if
			jsonStr  = "{""i"":"""& regionId &""",""n"":"""& regionName &""",""c"":["& childRegions &"]}"
			if returnStr="" then
				returnStr = jsonStr
			else
				returnStr = returnStr &","& jsonStr
			end if
			rs.movenext()
		loop
		OW.DB.closeRs rs
		getRegionData = returnStr
	end function
	
	private function edit(byval isSave)
		V("region_id") = OW.int(OW.getForm("post","region_id"))
		'**传递id是否正确
		if V("region_id")<1 then
			call Admin.errorSetting("region_id传递不正确"&"(region_id: "& V("region_id") &")"&"<br>")
			exit function
		end if
		'**判断记录是否存在
		if not(OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"region WHERE region_id="& V("region_id") &" AND "& OW.DB.auxSQL &"")) then
			Admin.errorSetting("region_id不存在"&"(region_id: "& V("region_id") &")"&"<br>")
			exit function
		end if
		'**
		if isSave then
			call doingSave()
		end if
	end function
	
	private function delete()
		dim check,id,isSkip,s
		check = true
		'**接收数据
		V("ids") = OW.regReplace(OW.getForm("post","ids"),"[^0-9,]","")
		'**数据处理
		aArr = split(V("ids"),",")
		'**数据合法性校验
		if V("ids")="" then check = false : Admin.errorSetting("地区id值传递不正确")
		'**从数据库删除记录
		if check then
			'**delete
			for iI=0 to ubound(aArr)
				V("region_id") = OW.clng(aArr(iI))
				if V("region_id")>0 then
					isSkip = false
					if not(OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"region WHERE region_id="& V("region_id") &" AND "& OW.DB.auxSQL &"")) then
						isSkip = true
						s = s &"地区不存在(region_id:"& V("region_id") &");<br>"
					end if
					if not(isSkip) then
						V("region_name") = OW.DB.getFieldValueBySQL("SELECT region_name FROM "& DB_PRE &"region WHERE region_id="& V("region_id") &" AND "& OW.DB.auxSQL &"")
						result = deleteRegion(V("region_id"))
						if result then
							s = s &"成功删除地区 "& V("region_name") &" > "& V("region_name") &" (region_id:"& V("region_id") &")<br>"
						else
							s = s &"删除地区失败(region_id:"& V("region_id") &",地区:"& V("region_name") &")<br>"
						end if
					end if
				end if
			next
			'**输出操作结果信息
			Admin.actionFinishSuccess     = true
			Admin.actionFinishSuccessText = array(s,"")
			Admin.actionFinishFailText    = array(s,"")
			Admin.actionFinishRun()
		end if
	end function
	
	private function deleteRegion(byval regionId)
		dim regionPath,result
		regionPath = OW.DB.getFieldValueBySQL("SELECT region_path FROM "& DB_PRE &"region WHERE region_id="& regionId &" AND "& OW.DB.auxSQL &"")
		if OW.DB.execute("DELETE FROM ["& DB_PRE &"region] WHERE region_path like '"& regionPath &"%' AND "& OW.DB.auxSQL &"") then
			result = true
			call OW.DB.execute("DELETE FROM ["& DB_PRE &"region] WHERE region_id="& regionId &" AND "& OW.DB.auxSQL &"")
		end if
		deleteRegion = result
	end function
	
	private function add(byval isSave)
		V("parent_region_id") = OW.int(OW.getForm("get","parent_region_id"))
		if V("parent_region_id")>0 then
			set oRs = OW.DB.getRecordBySQL("SELECT * FROM ["& DB_PRE &"region] WHERE region_id="& V("parent_region_id") &" AND "& OW.DB.auxSQL &"")
			if not oRs.eof then
				V("parent_region_exist") = true
				V("parent_region_path")  = oRs("region_path")
				V("parent_region_depth") = oRs("region_depth")
				V("parent_region_name")  = oRs("region_name")
			else
				V("parent_region_exist") = false
			end if
			OW.DB.closeRs oRs
			'**
			if V("parent_region_exist") then
				if isSave then
					call doingSave()
				else
					call doing()
				end if
			else
				call Admin.errorSetting("父级地区不存在")
			end if
		else
			if isSave then
				call doingSave()
			else
				call doing()
			end if
		end if
	end function

	function doing()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <form name="save_form" id="save_form" action="?ctl=<%=CTL%>&act=<%=ACT%>&parent_region_id=<%=V("parent_region_id")%>&save=true" method="post">
        <div class="wbox">
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                <% if V("parent_region_id")>0 then %>
                <tr><td class="titletd">所属上级地区</td>
                    <td class="infotd"><%=V("parent_region_name")%></td>
                </tr>
                <% end if %>
                <tr><td class="titletd top">地区</td>
                    <td class="infotd">
                    <textarea class="textarea textarea-attr-value" name="region_name"></textarea>
                    <span class="t-normal ml5" name="t_region_name">一行代表一个</span>
                    </td>
                </tr>
                </table>
            </div>
        </div>
        <div class="button-container">
            <button type="submit" class="btn btn-large btn-primary" name="submit">确定保存</button>
            <button type="reset" class="btn btn-large" name="reset">重置</button>
            <button type="button" class="btn btn-large" name="close" onClick="OW.closeParentDialog()">关闭</button>
        </div>
        </form>
    </div>
    <script type="text/javascript">
	$(document).ready(function(){
		Admin.goBackHide();
		//提交保存数据
		var $saveForm = $("#save_form");
		$saveForm.submit(function(){
			OW.parseFormInputValue({form:$saveForm});
			//**处理必填的字段
			var $validForm = OWValidForm({form:$saveForm});
			$validForm.verify();
			if($validForm.result){Admin.dialogPosting();};
			return $validForm.result;
		});
	});
    </script>
    <%
		call Admin.echoFooter()
	end function
	
	function doingSave()
		dim check
		'**数据库初始化
		check = true
		'**接收数据
		V("region_name") = OW.validDBData(OW.getForm("post","region_name"),1000)
		'**数据合法性校验
		if not Admin.validate("s",V("region_name"),"minLength:1,maxLength:0","必须填写地区") then check = false
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			if ACT = "add" then
				'**
				V("sequence")      = OW.int(OW.DB.getFieldValueBySQL("SELECT max(sequence) FROM "& DB_PRE &"region WHERE parent_region_id="& V("parent_region_id") &" AND "& OW.DB.auxSQL &"")) + 1
				V("max_region_id") = OW.DB.maxID(DB_PRE &"region","region_id")
				call addRegionName(V("region_name"))
				'**
				Admin.actionFinishSuccess     = true
				Admin.actionFinishSuccessText = array("成功添加地区："& V("region_name"),array("确定>javascript:OW.closeParentDialog({refresh:false,callBack:function(){parent.getSubRegionList("& V("parent_region_id") &")}});"))
				Admin.actionFinishFailText    = array("添加地区失败："& V("region_name"),array("确定>javascript:OW.closeParentDialog({refresh:false,callBack:function(){parent.getSubRegionList("& V("parent_region_id") &")}});"))
				Admin.actionFinishRun()
			elseif ACT = "edit" then
				'**
				result = OW.DB.updateRecord(DB_PRE &"region",array("region_name:"& V("region_name")),array("region_id:"& V("region_id")))
				'**
				Admin.actionFinishSuccess     = result
				Admin.actionFinishSuccessText = array("成功编辑地区(地区id:"& V("region_id") &",地区名称:"& V("region_name") &")","javascript:OW.closeParentDialog({refresh:true});")
				Admin.actionFinishFailText    = array("编辑地区失败(地区id:"& V("region_id") &",地区名称:"& V("region_name") &")","")
				Admin.actionFinishRun()
			end if
		end if
	end function
	
	private function addRegionName(byval text)
		dim arr,i,regionId,regionName,regionPath,regionDepth,sequence
		if OW.isNul(text) then exit function
		arr         = split(text,chr(13))
		regionId    = V("max_region_id")
		regionDepth = V("parent_region_depth") + 1
		sequence    = V("sequence")
		for i=0 to ubound(arr)
			regionName = arr(i)
			regionName = replace(regionName,chr(13)&chr(10),"")
			regionName = replace(regionName,chr(10),"")
			regionName = replace(regionName,chr(13),"")
			regionName = OW.trim(regionName)
			if not(OW.isNul(regionName)) then
				if V("parent_region_id")=0 then
				regionPath = ","& regionId &","
				else
				regionPath = V("parent_region_path") & regionId &","
				end if
				regionId   = regionId + 1
				sequence   = sequence + 1
				call OW.DB.addRecord(DB_PRE &"region",array("site_id:"& SITE_ID,"region_id:"& regionId,"parent_region_id:"& V("parent_region_id"),"region_path:"& regionPath,"region_depth:"& regionDepth,"region_name:"& regionName,"sequence:"& sequence,"status:0"))
			end if
		next
	end function
	
	
	private function list()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <div class="top-area">
            <table cellspacing="0" cellpadding="0" border="0">
              <tbody>
              <tr>
              <td class="do-cell">
                  <div class="do-cell-name">恢复操作区</div>
                  <div class="do-cell-btn"><a class="btn btn-primary" id="recover" href="javascript:;">恢复默认地区数据</a></div>
              </td>
              <td class="do-cell">
                  <div class="do-cell-name">生成操作区</div>
                  <div class="do-cell-btn"><a class="btn btn-primary" id="create_js_file" href="javascript:;">生成地区JS文件</a></div>
              </td>
              <td class="do-cell">
                  <div class="do-cell-name">删除操作区</div>
                  <div class="do-cell-btn"><button class="btn" id="delete_selected">批量删除</button></div>
              </td>
              <td class="do-cell">
                  <div class="do-cell-name text-left">系统提示</div>
                  <div class="do-cell-btn">当更改地区数据后，一定要重新生成地区JS文件才会生效！</div>
              </td>
              </tr>
              </tbody>
            </table>
        </div>
        <div class="ow-regions">
            <table border="0" cellpadding="0" cellspacing="0">
                <tr name="regions"><td>
                <div class="ow-region-grid" name="grid" depth="1">
                    <div class="header"><a class="btn" name="add" parent_region_id="0" region_name="" href="javascript:;">添加</a></div>
                    <div class="section"><%=regionListing(0)%></div>
                </div>
                </td></tr>
            </table>
        </div>
    </div>
    <script type="text/javascript">
	var $regions   = $("tr[name='regions']");
	var regionInit =function(){
		$regions.find("a[name='region']").click(function(){
			getSubRegionList($(this).attr("region_id"));
		});
		$regions.find("a[name='add']").click(function(){
			var parentRegionId = $(this).attr("parent_region_id"),
			regionName = $(this).attr("region_name"),
			title = regionName +' - 添加子地区'
			if(OW.isNull(regionName)){
				title = "添加顶级地区";
			};
			$dialog = new OWDialog({
				id:'d_add_region',
				title:title,
				padding:"0px",
				cancel:false,
				close:true,
				height:400,
				width:720,
				iframe:"index.asp?ctl=<%=CTL%>&act=add&parent_region_id="+parentRegionId,
				beforeClose:function(){
					getSubRegionList(parentRegionId);
				}
			});
		});
		$regions.find("a[name='edit']").click(function(){
			var regionId = $(this).attr("region_id"),
			addTpl = '<div class="inbox" style="width:480px;">'+
							'<table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">'+
							  '<tbody>'+
								'<tr><td class="titletd">地区名</td>'+
									'<td class="infotd"><input type="text" class="text" name="region_name" maxlength="100" value="'+$(this).attr("region_name")+'" />'+
									'<div><span class="t-normal" name="t_region_name"></span><div></td>'+
								'</tr>'+
							  '</tbody>'+
							'</table>'+
						'</div>';
			var $dialog = new OWDialog({
				id:'d_edit_region',
				title:'修改',
				content:addTpl,
				padding:"10px 10px 5px 10px",
				ok:function(){
					var check  = true,
					$diaWindow = $("#d_edit_region"),
					$input     = $diaWindow.find("input[name='region_name']"),
					$tip       = $diaWindow.find("span[name='t_region_name']"),
					data       = $.trim($input.val());
					$input.val(data);
					if(data==""){
						check = false;
						$tip.addClass("t-err").html("地区名不能为空").show();
						$input.focus();
					}
					if(check){
						$dialog.posting().button({id:'ok',remove:true},{id:'cancel',disabled:true}).padding("20px 40px");
						Admin.ajax({
							url:"index.asp?ctl=<%=CTL%>&act=edit&save=true",
							data:"region_id="+escape(regionId)+"&region_name="+escape(data),
							success:function(){
								$dialog.content('成功编辑').button({id:'cancel',value:'关闭',disabled:false,focus:true}).timeout(1);
								$("a[name='region'][region_id='"+regionId+"']").attr("region_name",data).html(data);
								$("a[name='edit'][region_id='"+regionId+"']").attr("region_name",data);
							},
							failed:function(msg){
								$dialog.error('编辑失败！',msg).button({id:'cancel',remove:true}).timeout(2);
							}
						});
					};
					return false;
				},
				cancel:true,
				close:false,
				follow:$(this),
				initialize:function(){}
			});
		});
	};
	
	var getSubRegionList = function(regionId){
		var $this  = $("a[region_id='"+regionId+"']"),
		depth      = OW.int($this.attr("depth"))+1,
		regionName = $this.attr("region_name"),
		$grid = $regions.find("div[name='grid']");
		$grid.each(function(){
			if(OW.int($(this).attr("depth"))>=depth){
				$(this).parent().remove();
			};
		});
		$regions.append('<td><div class="ow-region-grid" name="grid" depth="'+depth+'"><div class="header"><a class="btn" parent_region_id="'+regionId+'" region_name="'+regionName+'" name="add" href="javascript:;">添加</a></div><div class="section"></div></div></td>');
		$grid = $regions.find("div[name='grid'][depth='"+depth+"']");
		//**
		$this.parent().parent().addClass("current");
		$this.parent().parent().siblings().removeClass("current");
		//**
		var $dialog = OWDialog({id:OW.createDialogID()}).loading();
		Admin.ajax({
			data:"",
			url:"index.asp?ctl=<%=CTL%>&act=<%=ACT%>&subact=get_sub_region&parent_region_id="+regionId+"",
			success:function(){
				$dialog.close();
				var html = unescape(Admin.ajaxData.html);
				$grid.find(".section").html(html);
				$(".ow-regions").find("a[name='region']").unbind();
				regionInit();
			},
			failed:function(msg){
				$dialog.error('获取下级地区失败',msg).timeout(2);
			}
		});
	};
    $(window).ready(function(){
		//**恢复
		$("#recover").click(function(){
			var $dialog = OWDialog({
				id:'d_recover',
				title:'恢复默认地区数据',
				content:'您确定要恢复系统默认的地区数据吗？',
				ok:function(){
					$dialog.posting("正在恢复地区数据，请稍后...").button({id:'ok',remove:true},{id:'cancel',remove:true});;
					Admin.ajax({
						url:'index.asp?ctl=<%=CTL%>&act=edit&subact=recover&save=true',data:'',
						success:function(){
							OW.refresh();
						},
						failed:function(msg){
							$dialog.error('亲，很抱歉，排序失败，请查看以下错误信息',msg).timeout(3);
						}
					});
					return false;
				},
				okValue:'确定',
				cancel:true,
				cancelValue:'关闭'
			});
		});
		//**生成
		$("#create_js_file").click(function(){
			var $dialog = OWDialog({
				id:'d_recover',
				title:'生成地区JS文件',
				content:'您确定要生成地区JS文件吗？',
				ok:function(){
					$dialog.posting("正在生成保存文件，请稍后...").button({id:'ok',remove:true},{id:'cancel',remove:true});;
					Admin.ajax({
						url:'index.asp?ctl=<%=CTL%>&act=edit&subact=create_js_file&save=true',data:'',
						success:function(){
							$dialog.success("成功生成地区文件").title(false).timeout(2);
						},
						failed:function(msg){
							$dialog.error('亲，很抱歉，生成失败，请查看以下错误信息',msg).timeout(3);
						}
					});
					return false;
				},
				okValue:'确定',
				cancel:true,
				cancelValue:'关闭'
			});
		});
		regionInit();
		//**删除
		$("#delete_selected").click(function(){
			if($("input[name='data-checkbox']:checked").length>0){
				var $dialog = new OWDialog({
					id:OW.createDialogID(),
					content:"您确定要删除所选地区？",
					ok:function(){
						var ids = "";
						$("input[name='data-checkbox']:checked").each(function(){
							ids = ids +","+ $(this).val();
						});
						if(ids!=""){
							$dialog.posting('正在删除...').button({id:'ok',remove:true},{id:'cancel',disabled:true});
							Admin.ajax({
								url:'index.asp?ctl=<%=CTL%>&act=delete',
								data:"ids="+ids,
								success:function(){
									$dialog.button({id:'cancel',remove:true}).success("删除成功").timeout(1).shadow(false);
									ids = ids.split(",");
									var i,$tr;
									for(i=0;i<ids.length;i++){
										$("input[name='data-checkbox'][value="+ids[i]+"]").parent().delayRemove(600);
									};
								},
								failed:function(msg){
									$dialog.button({id:'cancel',remove:true}).error("删除失败",msg).timeout(3);
								}
							});
						};
						return false;
					},
					cancel:true,
					follow:$(this),
					close:false
				});
			}else{
				OWDialog({content:"请先选择您要删除的地区",ok:true,follow:$(this),shadow:false,timeout:2});
			};
		});
	});
    </script>
	<%
		call Admin.echoFooter()
	end function
	
	private function getSubRegion()
		dim html,parentRegionId
		parentRegionId = OW.int(OW.getForm("get","parent_region_id"))
		html   = regionListing(parentRegionId)
		dataJSON = """html"":"""& OW.escape(html) &""""
		call Admin.ajaxGetFinishRun(dataJSON)
	end function
	
	private function regionListing(byval parentRegionId)
		dim sb,str : set sb = OW.stringBuilder()
		parentRegionId= OW.int(parentRegionId)
		sb.append "<ul>"
		set oRs = OW.DB.getRecordBySQL("SELECT * FROM ["& DB_PRE &"region] WHERE parent_region_id="& parentRegionId&" AND "& OW.DB.auxSQL &"")
		do while not oRs.eof
			sb.append "<li><input type=""checkbox"" name=""data-checkbox"" value="""& oRs("region_id") &""" /><span class=""name""><a href=""javascript:;"" name=""region"" region_id="""& oRs("region_id") &""" region_name="""& oRs("region_name") &""" depth="""& oRs("region_depth") &""" >"& oRs("region_name") &"</a></span><span class=""edit""><a href=""javascript:;"" name=""edit"" region_id="""& oRs("region_id") &""" region_name="""& oRs("region_name") &""">编辑</a></span></li>"
			oRs.movenext
		loop
		OW.DB.closeRs oRs
		sb.append "</ul>"
		str = sb.toString() : set sb = nothing
		regionListing = str
	end function
	
	private function recover()
		dim InstallRegion
		call OW.include("ow-admin/ow.region.data.asp")
		set InstallRegion = new InstallRegion_Class
		call InstallRegion.init()
		set InstallRegion = nothing
		Admin.actionFinishSuccess = true
		Admin.actionFinishSuccessText = array("成功:恢复地区数据","")
		Admin.actionFinishFailText    = array("失败:恢复地区数据","")
		Admin.actionFinishRun()
	end function

end class
%>