﻿<%
'**
'系统设置
'**
dim AP_SETTING
class AP_SETTING_CLASS

	public result
	private aArr,oRs,sCols,sSQL,iI,iPageSize,sString,sOpeation,sURL,sTable
	
	private sub class_initialize()
	end sub
	
	public sub init()
		'if UID<>1 and SAVE then Admin.errorSetting("对不起，您无权进行此操作，如有需要请向上一级管理员请求分配（"& CTL_NAME &" > "& ACT_NAME &"）权限！") : exit sub
		'**
		if CTL="setting" then
			select case ACT
			case "edit"
				if SUBACT="add_domain" then
					call domainAdd()
				elseif SUBACT="delete_domain" then
					if SAVE then
						call domainDelete()
					end if
				elseif SUBACT="add_url_rewrite" then
					call urlRewriteAdd()
				elseif SUBACT="delete_rewrite_config" then
					if SAVE then
						call urlRewriteConfigDelete()
					end if
				else
					call setting()
				end if
			case "edit_site_info"
				call editSiteInfo()
			case "edit_my_info"
				call editMyInfo()
			case "edit_my_password"
				call editMyPassword()
			end select
		end if
	end sub
	
	private sub class_terminate()
	end sub
	
	private function domainAdd()
		dim domain,url,s
		domain = OW.regReplace(OW.getForm("post","domain"),"[^0-9a-zA-Z\.\-\_]","")
		url    = OW.regReplace(OW.getForm("post","url"),"[^0-9a-zA-Z:/\.\-\_]","")
		if OW.isNul(domain) or OW.isNul(url) then
			s = "添加域名失败，域名或网址不能为空！"
		else
			if OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"site_domains WHERE site_domain='"& domain &"' OR site_url='"& url&"'") then
				s = "添加域名失败，域名或网址已经存在！"
			else
				result = OW.DB.execute("INSERT INTO ["& DB_PRE &"site_domains] ([site_id],[site_domain],[site_url]) VALUES ("& SITE_ID &",'"& domain &"','"& url &"')")
				if result then
					s = "成功添加域名("& domain &")"
				else
					s = "添加域名("& domain &")失败，无法保存保存到数据库！"
				end if
			end if
		end if
		Admin.actionFinishSuccess = result
		Admin.actionFinishSuccessText = array(s,"")
		Admin.actionFinishFailText = array(s,"")
		Admin.actionFinishRun()
	end function
	
	private function createURLRewriteRule(byval rule)
		dim s
		select case rule
		case 1
			s = ""
			s = "[ISAPI_Rewrite]" &vbCrLf
			s = s &"RewriteRule ^"& SITE_PATH &"(?!ow-)(.*)/$ "& SITE_PATH &"index.asp?$1$2/ [QSA,NU,PT,L]" &vbCrLf
			s = s &"RewriteRule ^"& SITE_PATH &"(?!ow-)(.*)"& SITE_HTML_FILE_SUFFIX &"$ "& SITE_PATH &"index.asp?$1$2"& SITE_HTML_FILE_SUFFIX &" [QSA,NU,PT,L]" &vbCrLf
		case 2
			s = ""
			s = "RewriteEngine on" &vbCrLf
			s = s &"RewriteBase " &vbCrLf
			s = s &"RewriteRule ^"& SITE_PATH &"(?!ow-)(.*)/$ "& SITE_PATH &"index.asp?$1$2/ [QSA,NU,PT,L]" &vbCrLf
			s = s &"RewriteRule ^"& SITE_PATH &"(?!ow-)(.*)"& SITE_HTML_FILE_SUFFIX &"$ "& SITE_PATH &"index.asp?$1$2"& SITE_HTML_FILE_SUFFIX &" [QSA,NU,PT,L]" &vbCrLf
		case 3
			s = ""
			s = s &"<?xml version=""1.0"" encoding=""UTF-8""?>"&vbCrLf
			s = s &"<configuration>"&vbCrLf
			s = s &"<system.webServer>"&vbCrLf
			s = s &"<defaultDocument><files><add value=""index.asp"" /></files></defaultDocument>"&vbCrLf
			s = s &"<rewrite>"&vbCrLf
			s = s &"<rules>"&vbCrLf
			s = s &"<rule name=""Imported Rule content_category_root"" stopProcessing=""true"">"&vbCrLf
			s = s &"<match url=""^(?!ow-)(.+)/$"" ignoreCase=""false"" />"&vbCrLf
			s = s &"<action type=""Rewrite"" url=""?{R:1}/"" />"&vbCrLf
			s = s &"</rule>"&vbCrLf
			s = s &"<rule name=""Imported Rule content_category_sub"" stopProcessing=""true"">"&vbCrLf
			s = s &"<match url=""^(?!ow-)(.+)/(.+)/$"" ignoreCase=""false"" />"&vbCrLf
			s = s &"<action type=""Rewrite"" url=""?{R:1}/{R:2}/"" />"&vbCrLf
			s = s &"</rule>"&vbCrLf
			s = s &"<rule name=""Imported Rule content_category_type"" stopProcessing=""true"">"&vbCrLf
			s = s &"<match url=""^(?!ow-)(.+)/(.+)/(.+)/$"" ignoreCase=""false"" />"&vbCrLf
			s = s &"<action type=""Rewrite"" url=""?{R:1}/{R:2}/{R:3}/"" />"&vbCrLf
			s = s &"</rule>"&vbCrLf
			s = s &"<rule name=""Imported Rule content_category_type_page"" stopProcessing=""true"">"&vbCrLf
			s = s &"<match url=""^(?!ow-)(.+)/(.+)/(.+)/(.+)/$"" ignoreCase=""false"" />"&vbCrLf
			s = s &"<action type=""Rewrite"" url=""?{R:1}/{R:2}/{R:3}/{R:4}/"" />"&vbCrLf
			s = s &"</rule>"&vbCrLf
			s = s &"<rule name=""Imported Rule category_page"" stopProcessing=""true"">"&vbCrLf
			s = s &"<match url=""^(?!ow.)(.+)"& SITE_HTML_FILE_SUFFIX &"$"" ignoreCase=""false"" />"&vbCrLf
			s = s &"<action type=""Rewrite"" url=""?{R:1}"& SITE_HTML_FILE_SUFFIX &""" />"&vbCrLf
			s = s &"</rule>"&vbCrLf
			s = s &"<rule name=""Imported Rule content_detail"" stopProcessing=""true"">"&vbCrLf
			s = s &"<match url=""^(?!ow.)(.+)/(.+)"& SITE_HTML_FILE_SUFFIX &"$"" ignoreCase=""false"" />"&vbCrLf
			s = s &"<action type=""Rewrite"" url=""?{R:1}/{R:2}"& SITE_HTML_FILE_SUFFIX &""" />"&vbCrLf
			s = s &"</rule>"&vbCrLf
			s = s &"</rules>"&vbCrLf
			s = s &"</rewrite>"&vbCrLf
			s = s &"</system.webServer>"&vbCrLf
			s = s &"</configuration>"&vbCrLf
		end select
		s = OW.templateHTMLEncode(s)
		createURLRewriteRule = s
	end function
	
	private function domainDelete()
		dim domain,result,s
		domain = OW.regReplace(OW.getForm("post","domain"),"[^0-9a-zA-Z.-_]","")
		result = false
		if OW.isNul(domain) then
			s = "域名不存在"
		else
			if domain <> SITE_DOMAIN then
				if OW.int(OW.DB.getFieldValueBySQL("SELECT COUNT(*) FROM "& DB_PRE &"site_domains WHERE "& OW.DB.auxSQL &""))<=1 then
					s = "唯一的域名不可以删除"
				else
					result = OW.DB.execute("DELETE FROM ["& DB_PRE &"site_domains] WHERE site_domain='"& domain &"' AND "& OW.DB.auxSQL &"")
					if result then
						s = "成功删除域名("& domain &")"
					else
						s = "删除域名("& domain &")失败"
					end if
				end if
			end if
		end if
		Admin.actionFinishSuccess     = result
		Admin.actionFinishSuccessText = array(s,"")
		Admin.actionFinishFailText    = array(s,"")
		Admin.actionFinishRun()
	end function
	
	private function domainList()
		dim sb,str : set sb = OW.stringBuilder()
		iI = 0
		sb.append "<table border=""0"" cellpadding=""0"" cellspacing=""0"" class=""table table-bordered table-hover"" style=""width:auto;""><thead><tr class=""thead""><th>顺序</th><th>域名</th><th>网址</th><th>类型</th><th>跳转</th><th>操作</th></tr></thead><tbody>"
		set oRs = OW.DB.getRecordBySQL("SELECT * FROM ["& DB_PRE &"site_domains] WHERE "& OW.DB.auxSQL &"")
		do while not(oRs.eof)
			iI = iI+1
			sb.append "<tr class=""data"">"
			sb.append "<td>"& iI &"</td>"
			sb.append "<td>"& oRs("site_domain") &"</td><td><a href="""& oRs("site_url") &""" target=""_blank"">"& oRs("site_url") &"</a></td>"
			sb.append "<td>"
			if oRs("site_domain") = OW.config("main_site_domain") then
				sb.append "主域名"
			end if
			sb.append "</td>"
			sb.append "<td>"& OW.iif(OW.int(oRs("is_redirect"))=1,"是","") &"</td>"
			sb.append "<td>"
			if oRs("site_domain") <> OW.config("main_site_domain") then
				sb.append "<button type=""button"" class=""btn btn-small"" name=""btn_domain_delete"" domain="""& oRs("site_domain") &""">删除</button>"
			end if
			sb.append "</td>"
			sb.append "</tr>"
			oRs.movenext
		loop
		set oRs = nothing
		sb.append "</tbody></table>"
		str = sb.toString() : set sb = nothing
		domainList = str
	end function
	
	private function urlRewriteAdd()
		if SAVE then
			call addUrlRewriteSave()
		else
			call addUrlRewriteHtml()
		end if
	end function
	
	private function urlRewriteConfigDelete()
		dim filename
		filename = OW.getForm("get","file")
		if not(filename="httpd.ini" or filename=".htaccess" or filename="web.config") then
			call Admin.errorSetting("URL重写规则类型不正确")
			check = false
			exit function
		else
			result = OW.FSO.deleteFile(OW.FSO.ABSPath(filename))
			Admin.actionFinishSuccess     = result
			Admin.actionFinishSuccessText = array("成功删除"& filename &"","")
			Admin.actionFinishFailText    = array("删除"& filename &"失败，请检查"& filename &"是否有删除权限","")
			Admin.actionFinishRun()
		end if
		
	end function
	
	private function editMyInfo()
		
	end function
	
	private function editMyPassword()
		if SAVE then
			call editMyPasswordSave()
		else
			call editMyPasswordHtml()
		end if
	end function
	
	private function editSiteInfo()
		if SAVE then
			call siteInfoSettingSave()
		else
			call siteInfoSettingHtml()
		end if
	end function
	
	private function editMyPasswordHtml()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <form name="save_form" id="save_form" action="?ctl=<%=CTL%>&act=<%=ACT%>&save=true" method="post">
        <div class="wbox">
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                <tr><td class="titletd"><i class="important">*</i>当前密码</td>
                    <td class="infotd">
                    <input type="password" class="text text-large" name="owpw" maxlength="64" value="" datatype="*" errmsg="请输入密码" tips="" />
                    <span class="t-normal ml5" name="t_owpw"><% if ACT = "edit" then %>如不修改密码请留空<%end if%></span>
                    </td>
                </tr>
                <tr><td class="titletd"><i class="important">*</i>新密码</td>
                    <td class="infotd">
                    <input type="password" class="text text-large" name="new_owpw" maxlength="64" value="" datatype="*" errmsg="请输入新密码" tips="" />
                    <span class="t-normal ml5" name="t_new_owpw"></span>
                    </td>
                </tr>
                <tr><td class="titletd"><i class="important">*</i>确认新密码</td>
                    <td class="infotd">
                    <input type="password" class="text text-large" name="re_new_owpw" maxlength="64" value="" datatype="*" errmsg="请再输入一次新密码" tips="" />
                    <span class="t-normal ml5" name="t_re_new_owpw"></span>
                    </td>
                </tr>
                </table>
            </div>
        </div>
        <div class="button-container">
            <button type="submit" class="btn btn-large btn-primary" name="submit">确定保存</button>
            <button type="reset" class="btn btn-large" name="reset">重置</button>
        </div>
        </form>
    </div>
    <script type="text/javascript">
	$(document).ready(function(){
		//**隐藏返回按钮
		Admin.goBackHide();
		//提交保存数据
		var $saveForm = $("#save_form");
		$saveForm.submit(function(){
			OW.parseFormInputValue({form:$saveForm});
			//**表单验证
			var check  = true,
			$validForm = OWValidForm({form:$saveForm});
			$validForm.verify();
			check      = $validForm.result;
			var $pw = $("input[name='owpw']"),
			$newpw  = $("input[name='new_owpw']"),
			$reNewpw= $("input[name='re_new_owpw']"),
			pw      = OW.trim($pw.val()),
			newpw   = OW.trim($newpw.val()),
			reNewpw = OW.trim($reNewpw.val());
			if(OW.isNull(pw)){$pw.focus();};
			if(OW.isNull(newpw)){$newpw.focus();};
			if(newpw!=reNewpw){
				check = false;
				$("span[name='t_re_new_owpw']").addClass("t-err").html("两次输入的密码不一致");
				$reNewpw.focus();
			};
			//**返回验证结果
			if(check){
				$pw.val(OW.encrypt.encode(pw));
				$newpw.val(OW.encrypt.encode(newpw));
				$reNewpw.val(OW.encrypt.encode(reNewpw));
				Admin.dialogPosting();
			};
			return check;
		});
	});
    </script>
    <%
		call Admin.echoFooter()
	end function
	
	private function addUrlRewriteHtml()
		call Admin.echoHeader()
		Admin.breadcrumb = replace(Admin.breadcrumb,"<!--{$auxiliar}-->","<em>»</em>URL静态化配置")
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <form name="save_form" id="save_form" action="?ctl=<%=CTL%>&act=<%=ACT%>&subact=add_url_rewrite&save=true" method="post">
        <div class="url-rewrite-section" id="url_rewrite">
            <div class="header labels">
                <label><input type="radio" checked="checked" name="url_rewrite_type" value="1" />IIS6+ISAPI Rewrite 2.X</label>
                <label><input type="radio" name="url_rewrite_type" value="2" />IIS6+ISAPI Rewrite 3.X</label>
                <label><input type="radio" name="url_rewrite_type" value="3" />IIS7/7.5/8+Url Rewrite</label>
            </div>
            <div class="section">
                <div name="url_rewrite_rule" rule="1">
                    <div class="section">
                    <textarea class="textarea textarea-rewrite" name="url_rewrite_rule_1"><%=createURLRewriteRule(1)%></textarea>
                    </div>
                    <div class="footer">httpd.ini<a class="color-grey ml10" href="javascript:;" name="delete" file="httpd.ini" title="删除httpd.ini">删除</a></div>
                </div>
                <div name="url_rewrite_rule" rule="2" style="display:none;">
                    <div class="section">
                    <textarea class="textarea textarea-rewrite" name="url_rewrite_rule_2"><%=createURLRewriteRule(2)%></textarea>
                    </div>
                    <div class="footer">.htaccess<a class="color-grey ml10" href="javascript:;" name="delete" file=".htaccess" title="删除.htaccess">删除</a></div>
                </div>
                <div name="url_rewrite_rule" rule="3" style="display:none;">
                    <div class="section">
                    <textarea class="textarea textarea-rewrite" name="url_rewrite_rule_3"><%=createURLRewriteRule(3)%></textarea>
                    </div>
                    <div class="footer">web.config<a class="color-grey ml10" href="javascript:;" name="delete" file="web.config" title="删除web.config">删除</a></div>
                </div>
            </div>
        </div>
        <div class="button-container">
            <button type="submit" class="btn btn-large btn-primary" name="submit">确定保存配置</button>
            <button type="reset" class="btn btn-large" name="reset">重置</button>
            <button type="button" class="btn btn-large" name="close" onclick="OW.closeParentDialog();">关闭</button>
        </div>
        </form>
    </div>
    <script type="text/javascript">
	$(document).ready(function(){
		//**隐藏返回按钮
		Admin.goBackHide();
		OW.tabSwitch({tabbar:$("[name='tabbar']"),container:$("#tabs_container"),current:1});
		//提交保存数据
		var $saveForm = $("#save_form");
		$saveForm.submit(function(){
			OW.parseFormInputValue({form:$saveForm});
			//**表单验证
			var check  = true,
			$validForm = OWValidForm({form:$saveForm});
			$validForm.verify();
			
			//**返回验证结果
			if(check){Admin.dialogPosting();};
			return check;
		});
		//**
		$("input[name='url_rewrite_type']").click(function(){
			var type = OW.int($(this).val());
			$("div[name='url_rewrite_rule'][rule!='"+type+"']").hide(200);
			$("div[name='url_rewrite_rule'][rule='"+type+"']").show(200);
		});
		//**
		$("#url_rewrite").find("a[name='delete']").click(function(){
			var file = $(this).attr("file");
			var $dialog = new OWDialog({
				id:OW.createDialogID(),
				content:"您确定要删除"+file+"吗？",
				ok:function(){
					this.posting("正在删除"+file+" ... ").button({id:'ok',remove:true},{id:'cancel',remove:true});
					Admin.ajax({
						me:'',data:'',
						url:'index.asp?ctl=<%=CTL%>&act=<%=ACT%>&subact=delete_rewrite_config&file='+ file +'&save=true',
						success:function(){
							$dialog.success("已成功删除"+file+"！").timeout(3);
						},
						failed:function(msg){
							$dialog.error('亲，很抱歉，'+file+'删除操作失败，请查看以下错误信息',msg).timeout(3);
						}
					});
					return false;
				},
				cancel:true,
				close:false
			});
		});
	});
    </script>
    <%
		call Admin.echoFooter()
	end function
	
	function addUrlRewriteSave()
		dim check,filename
		check = true
		'**接收数据
		V("url_rewrite_type") = OW.int(OW.getForm("post","url_rewrite_type"))
		V("url_rewrite_rule") = OW.getForm("post","url_rewrite_rule_"& V("url_rewrite_type") &"")
		select case V("url_rewrite_type")
			case 1
				filename = "httpd.ini"
			case 2
				filename = ".htaccess"
			case 3
				filename = "web.config"
		end select
		'**数据合法性判断
		if OW.isNul(filename) then
			call Admin.errorSetting("URL重写规则类型不正确")
			check = false
		end if
		if OW.isNul(V("url_rewrite_rule")) then
			call Admin.errorSetting("URL重写规则不能为空")
			check = false
		end if
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			result = OW.FSO.saveFile(filename,OW.templateHTMLDecode(V("url_rewrite_rule")))
			'**
			Admin.actionFinishSuccess     = result
			Admin.actionFinishSuccessText = array("成功保存URL静态化配置","javascript:OW.closeParentDialog();")
			Admin.actionFinishFailText    = array("URL静态化配置保存失败，请检查网站根目录是否有写入"& filename &"文件的权限","")
			Admin.actionFinishRun()
		end if
	end function
	
	function editMyPasswordSave()
		dim check,password
		check = true
		'**接收数据
		V("password")     = OW.validDBData(OW.clientUserDataDecode(OW.getForm("post","owpw")),32)
		V("new_password") = OW.validDBData(OW.clientUserDataDecode(OW.getForm("post","new_owpw")),32)
		'**数据合法性判断
		if not Admin.validate("s",V("password"),"minLength:1,maxLength:0","必须填写密码") then check = false
		if not Admin.validate("s",V("new_password"),"minLength:1,maxLength:0","必须填写新密码") then check = false
		'**
		V("password")     = OW.parsePassword(V("password"))
		V("new_password") = OW.parsePassword(V("new_password"))
		'**
		password = OW.DB.getFieldValueBySQL("SELECT password FROM "& DB_PRE &"member WHERE uid="& ADMIN_UID &" AND "& OW.DB.auxSQL &"")
		if V("password")<>password then check = false : call Admin.errorSetting("当前密码不正确!")
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			'**edit
			result = OW.DB.updateRecord(DB_PRE &"member",array("password:"& V("new_password")),array("uid:"& ADMIN_UID))
			if result then
			result = OW.DB.updateRecord(DB_PRE &"ucenter_member",array("password:"& V("new_password")),array("uid:"& ADMIN_UID))
			end if
			'**
			Admin.actionFinishSuccess     = result
			Admin.actionFinishSuccessText = array("成功修改密码","javascript:OW.closeParentDialog();")
			Admin.actionFinishFailText    = array("修改密码失败","")
			Admin.actionFinishRun()
		end if
	end function
	
	private function setting()
		if SAVE then
			call settingSave()
		else
			call settingHtml()
		end if
	end function
	
	private function settingHtml()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
		OW.config("main_site_domain") = OW.DB.getFieldValueBySQL("SELECT top 1 config_value FROM "& DB_PRE &"site_config WHERE config_name='site_domain' AND "& OW.DB.auxSQL &"")
		OW.config("main_site_url")    = OW.DB.getFieldValueBySQL("SELECT top 1 config_value FROM "& DB_PRE &"site_config WHERE config_name='site_url' AND "& OW.DB.auxSQL &"")
	%>
    <script language="javascript" type="text/javascript" src="js/colorpicker.js"></script>
    <div class="mbody">
        <form name="save_form" id="save_form" action="?ctl=<%=CTL%>&act=<%=ACT%>&save=true" method="post">
        <div class="tabbar">
            <ul>
            <li name="tab" tab="1"><a href="javascript:;">基本配置</a></li>
            <li name="tab" tab="2"><a href="javascript:;">运行模式/缓存设置</a></li>
            <li name="tab" tab="3"><a href="javascript:;">会员相关</a></li>
            <li name="tab" tab="4"><a href="javascript:;">安全相关</a></li>
            <li name="tab" tab="5"><a href="javascript:;">上传相关</a></li>
            <li name="tab" tab="6"><a href="javascript:;">商微账号接口</a></li>
            <li name="tab" tab="7"><a href="javascript:;">邮箱服务器</a></li>
            <%if OS.hasMobile then%>
            <li name="tab" tab="8"><a href="javascript:;">手机端配置</a></li>
            <%end if%>
            <%if OS.versionWX then%>
            <li name="tab" tab="9"><a href="javascript:;">微信配置</a></li>
            <%end if%>
            </ul>
        </div>
        <div id="tabs_container" class="wbox">
            <div is_tab="true" tab="1">
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">系统语言</td>
                        <td class="infotd">
                        <%=Admin.selectLang("site_lang",OW.config("site_lang"))%>
                        <span class="t-normal ml5" name="t_site_lang"></span>
                        </td>
                    </tr>                    
                    <tr><td class="titletd">网站网址<span class="subtitle">(包含网站路径)</span></td>
                        <td class="infotd">
                        <input type="text" class="text" name="site_url" maxlength="150" value="<%=OW.config("main_site_url")%>"/>
                        <span class="t-normal ml5" name="t_site_url">以 http:// 或 https:// 开头，后面以 / 结束，如 http://www.openwbs.com/</span>
                        </td>
                    </tr>
                    <tr><td class="titletd">网站路径</td>
                        <td class="infotd">
                        <input type="text" class="text text-short" name="site_path" maxlength="50" value="<%=SITE_PATH%>"/>
                        <span class="t-normal ml5" name="t_site_path">即网站所在虚拟目录或二级目录(如/en/)，若不是虚拟目录则填写/</span>
                        </td>
                    </tr>
                    <tr><td class="titletd">静态文件目录</td>
                        <td class="infotd">
                        <input type="text" class="text text-short" name="site_folder" maxlength="50" value="<%=SITE_FOLDER%>"/>
                        <span class="t-normal ml5" name="t_site_folder">此目录用于存放静态页面(后面以/结尾)，如：cn/</span>
                        </td>
                    </tr>
                    <tr><td class="titletd">缓存目录</td>
                        <td class="infotd">
                        <input type="text" class="text readonly" name="cache_folder" disabled="disabled" maxlength="50" value="<%=OW.config("cache_folder")%>"/>
                        <span class="t-normal ml5" name="t_cache_folder">不能修改</span>
                        </td>
                    </tr>
                    <tr><td class="titletd">PC端<br />模板html文件夹</td>
                        <td class="infotd">
                        <input type="text" class="text text-short" name="tpl_html_folder" maxlength="50" value="<%=OW.config("tpl_html_folder")%>"/>
                        <span class="t-normal ml5" name="t_tpl_html_folder">默认为html，如果修改请确保与实际文件夹名一致！</span>
                        </td>
                    </tr>
                    <tr><td class="titletd">网站域名列表</td>
                        <td class="infotd">
                        <button type="button" class="btn" id="site_domains-add">添加域名</button>
                        <div style="padding-top:5px;" id="site_domains">
                        <%=domainList()%>
                        </div>
                        <span class="t-normal" name="t_site_domains" style="display:none;"></span>
                        </td>
                    </tr>
                    <tr><td class="titletd">网站后台风格选择</td>
                        <td class="infotd">
                        <input type="hidden" name="site_admin_theme" value="<%=OW.config("site_admin_theme")%>" />
                        <%=Admin.themes(OW.config("site_admin_theme"))%>
                        </td>
                    </tr>
                    </table>
                </div>
                <% if IS_MULTI_SITES AND SITE_ID=1 then %>
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">上传文件管理模式</td>
                        <td class="infotd">
                        <div class="labels">
                        <label><input type="radio" name="upload_share_manage" checked="checked" value="1" <%=OW.iif(OW.config("upload_share_manage")=1,"checked","")%> />各站之间共享管理</label>
                        <label><input type="radio" name="upload_share_manage" value="0" <%=OW.iif(OW.config("upload_share_manage")=0,"checked","")%> />各分站独立管理</label>
                        <span class="t-normal" id="t_upload_share_manage"></span>
                        </div>
                        </td>
                    </tr>
                    <tr><td class="titletd">会员管理模式</td>
                        <td class="infotd">
                        <div class="labels">
                        <label><input type="radio" name="member_share_manage" checked="checked" value="1" <%=OW.iif(OW.config("member_share_manage")=1,"checked","")%> />各站之间共享管理</label>
                        <label><input type="radio" name="member_share_manage" value="0" <%=OW.iif(OW.config("member_share_manage")=0,"checked","")%> />各分站独立管理</label>
                        <span class="t-normal" id="t_member_share_manage"></span>
                        </div>
                        </td>
                    </tr>
                    </table>
                </div>
                <% end if %>
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">货币符号</td>
                        <td class="infotd">
                        <select name="money_sb">
						<%=Admin.createOptions(array("￥:￥","$:$","€:€"),OW.config("money_sb"))%>
                        </select>
                        <span class="t-normal ml5" name="t_money_sb"></span>
                        </td>
                    </tr>
                    <tr><td class="titletd">是否开启调试模式</td>
                        <td class="infotd">
                        <label><input type="checkbox" name="debug" value="1" <%=OW.iif(OW.config("debug"),"checked","")%>>开启</label>
                        <span class="t-normal ml5" name="t_cache_open">只有当网站运行错误时才需要开启此模式进行调试，一般情况下请关闭调试模式。</span>
                        </td>
                    </tr>
                    </table>
                </div>
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">是否关闭网站</td>
                        <td class="infotd">
                        <input type="checkbox" name="site_close" id="site_close" value="1" <%=OW.iif(OW.config("site_close")=1,"checked","")%>><label for="site_close">关闭</label>
                        <span class="t-normal ml5" name="t_site_close"></span>
                        </td>
                    </tr>
                    <tr><td class="titletd top">网站关闭信息</td>
                        <td class="infotd">
                        <textarea class="textarea" name="site_close_html"><%=OW.config("site_close_html")%></textarea>
                        <span class="t-normal ml5" name="t_site_close_html"></span>
                        </td>
                    </tr>
                    </table>
                </div>
            </div>
            <div is_tab="true" tab="2">
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">模板缓存</td>
                        <td class="infotd">
                        <div class="labels">
                        <label><input type="checkbox" name="cache_open" value="1" <%=OW.iif(OW.config("cache_open")=1,"checked","")%> />开启</label>
                        <span class="t-normal ml5" name="t_cache_open"></span>
                        </div>
                        </td>
                    </tr>
                    <tr><td class="titletd">模板缓存更新时间</td>
                        <td class="infotd">
                        <input type="text" class="text text-short-mini" name="cache_time" value="<%=OW.config("cache_time")%>"/>
                        <span class="t-normal ml5" name="t_cache_time">即模板缓存的存活时间(以"分钟"为单位)，经过此时间后系统会生成新的模板缓存(不需要手动更新)。</span>
                        </td>
                    </tr>
                    <tr><td class="titletd">页面缓存</td>
                        <td class="infotd">
                        <div class="labels">
                        <label><input type="checkbox" name="html_cache_open" value="1" <%=OW.iif(OW.config("html_cache_open")=1,"checked","")%> />开启</label>
                        <span><a href="javascript:void(0);" onclick="Admin.showHelpMsg(this,{content:'<b>页面缓存</b><br>OpenWBS独创的介于内存缓存与静态页面之间的一种创新的缓存方式，它会自动生成静态页面保存起来，以加快页面的访问速度(<b>相当于静态页面</b>)和缓解服务器压力，对SEO优化和用户体验都有极大的作用。<br>您可以进入[<a href=index.asp?ctl=cache&act=list>静态缓存管理</a>]页面进行缓存的管理。',width:400});"><b class="icon icon-help-msg"></b></a></span>
                        <span class="t-normal ml5" name="t_html_cache_open"></span>
                        </div>
                        </td>
                    </tr>
                    <tr><td class="titletd">页面缓存更新时间</td>
                        <td class="infotd">
                        <input type="text" class="text text-short-mini" name="html_cache_time" value="<%=OW.config("html_cache_time")%>"/>
                        <span class="t-normal ml5" name="t_html_cache_time">即页面缓存的存活时间(以"分钟"为单位)，经过此时间后系统会生成新的静态页面页面(不需要手动更新)。</span>
                        </td>
                    </tr>
                    <tr><td class="titletd">清除缓存</td>
                        <td class="infotd">
                        <button type="button" class="btn btn-small" name="clear_cache">清除所有缓存</button>
                        </td>
                    </tr>
                    </table>
                </div>
                <div class="inbox" style="display:none;">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">页面GZIP压缩</td>
                        <td class="infotd">
                        <div class="labels">
                        <label><input type="radio" name="gzip_open" value="0" <%=OW.iif(OW.config("gzip_open")=0,"checked","")%> />关闭</label>
                        <label><input type="radio" name="gzip_open" value="1" <%=OW.iif(OW.config("gzip_open")=1,"checked","")%> />开启</label>
                        <span><a href="javascript:void(0);" onclick="Admin.showHelpMsg(this,{content:'开启GZIP后会将输出到用户浏览器的数据进行压缩的处理，提高浏览速度。',width:400});"><b class="icon icon-help-msg"></b></a></span>
                        <span class="t-normal ml5" name="t_gzip_open"></span>
                        </div>
                        </td>
                    </tr>
                    </table>
                </div>
                <% if SITE_ID=1 then %>
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">运行模式</td>
                        <td class="infotd">
                        <div class="labels">
                        <label><input type="radio" name="run_mode" value="0" <%=OW.iif(OW.config("run_mode")=0,"checked","")%> />动态</label>
                        <label><input type="radio" name="run_mode" value="1" <%=OW.iif(OW.config("run_mode")=1,"checked","")%> />动态 + URL静态化 <a href="javascript:;" onclick="urlRewriteAdd()">规则配置</a></label>
                        <label style="display:none;"><input type="radio" name="run_mode" value="2" <%=OW.iif(OW.config("run_mode")=2,"checked","")%> />生成静态页面</label>
                        <span><a href="javascript:void(0);" onclick="Admin.showHelpMsg(this,{content:'<b>动态 + URL重写</b><br>URL重写是指URL静态化，只有当服务器支持URL重写时才可以选择此模式。<br><br><a href=\'http://doc.openwbs.com/setup/IIS6_IIS7_weijingtaizujian_ISAPI_Rewrite_anzhuang.html\' target=\'_blank\'>教程：伪静态组件设置方法</a>',width:420});"><b class="icon icon-help-msg"></b></a></span>
                        <span class="t-normal ml5" name="t_run_mode"></span>
                        </div>
                        </td>
                    </tr>
                    </table>
                </div>
                <% end if %>
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">URL链接方式</td>
                        <td class="infotd">
                        <div class="radio-item selected">
                        <label><input type="radio" name="url_type" value="0" <%=OW.iif(OW.config("url_type")=0,"checked","")%> <%=OW.iif(OW.config("run_mode")=1,"disabled","")%> /><span>不带index.asp</span><i>?news/index.html</i></label>
                        </div>
                        <div class="radio-item">
                        <label><input type="radio" name="url_type" value="1" <%=OW.iif(OW.config("url_type")=1,"checked","")%> <%=OW.iif(OW.config("run_mode")=1,"disabled","")%> /><span>带index.asp</span><i>index.asp?news/index.html</i></label>
                        </div>
                        <span class="t-normal" name="t_url_type"></span>
                        </td>
                    </tr>
                    <tr><td class="titletd">URL链接路径</td>
                        <td class="infotd">
                        <div class="radio-item selected">
                        <label><input type="radio" name="url_path_type" value="0" <%=OW.iif(OW.config("url_path_type")=0,"checked","")%> /><span>不带域名</span><i>/?news/index.html</i></label>
                        </div>
                        <div class="radio-item">
                        <label><input type="radio" name="url_path_type" value="1" <%=OW.iif(OW.config("url_path_type")=1,"checked","")%> /><span>带域名</span><i>http://www.openwbs.com/?news/index.html</i></label>
                        </div>
                        <span class="t-normal" name="t_url_path_type"></span>
                        </td>
                    </tr>
                    </table>
                </div>
            </div>
            <div is_tab="true" tab="3">
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">会员登录</td>
                        <td class="infotd">
                        <label><input type="checkbox" name="user_login_close" value="1" <%=OW.iif(OW.config("user_login_close")=1,"checked","")%>>关闭</label>
                        <span class="t-normal ml5" name="t_user_login_close">关闭后前台会员用户不能登录</span>
                        </td>
                    </tr>
                    <tr><td class="titletd">会员注册</td>
                        <td class="infotd">
                        <label><input type="checkbox" name="user_reg_close" value="1" <%=OW.iif(OW.config("user_reg_close")=1,"checked","")%>>关闭</label>
                        <span class="t-normal ml5" name="t_user_reg_close">关闭后不能使用会员注册功能</span>
                        </td>
                    </tr>
                    <tr><td class="titletd">手机注册</td>
                        <td class="infotd">
                            <div class="labels">
                                <label><input type="radio" name="is_user_mobile_open" value="1" <%=OW.iif(OW.config("is_user_mobile_open")=1,"checked","")%> />开启</label>
                                <label><input type="radio" name="is_user_mobile_open" value="0" <%=OW.iif(OW.config("is_user_mobile_open")=0,"checked","")%> />关闭</label>
                                <span class="t-normal ml5" name="t_is_user_mobile_open"></span>
                            </div>
                            <div class="form-in-table" id="is_user_mobile_open_section" <%=OW.iif(OW.config("is_user_mobile_open")=0,"style=""display:none;""","")%>>
                                <dl>
                                    <dt>间隔时间</dt>
                                    <dd>
                                        <input type="text" class="text text-short-mini" name="mobile_interval_time" value="<%=OW.config("mobile_interval_time")%>" maxlength="5" onblur="OW.onblur(this,{rep:'/[^0-9]*/g',length:5})" /><span class="ml5">秒(s)</span><span class="t-normal ml5">发送短信验证码的间隔时间</span>
                                    </dd>
                                </dl>
                            </div>
                        </td>
                    </tr>
                    <tr><td class="titletd">邮箱注册</td>
                        <td class="infotd">
                            <div class="labels">
                                <label><input type="radio" name="is_user_email_open" value="1" <%=OW.iif(OW.config("is_user_email_open")=1,"checked","")%> />开启</label>
                                <label><input type="radio" name="is_user_email_open" value="0" <%=OW.iif(OW.config("is_user_email_open")=0,"checked","")%> />关闭</label>
                                <span class="t-normal ml5" name="t_is_invoice_open"></span>
                            </div>
                            <div class="form-in-table" id="is_user_email_open_section" <%=OW.iif(OW.config("is_user_email_open")=0,"style=""display:none;""","")%>>
                                <div style="display:none; padding:5px 0px 0px 0px;">
                                    <span style="border-top:1px solid #eee; display:inline-block; padding:5px 0px 5px 0px;">
                                        <label><input type="checkbox" name="is_user_email_activate" value="1" <%=OW.iif(OW.config("is_user_email_activate")=1,"checked","")%> />开启激活功能，新注册的会员需要通过邮箱激活账号</label>
                                    </span>
                                </div>
                            </div>
                        </td>
                    </tr>
                    <tr><td class="titletd">注册需填写用户名？</td>
                        <td class="infotd">
                            <div class="labels">
                                <label><input type="radio" name="is_reg_need_username" value="1" <%=OW.iif(OW.config("is_reg_need_username")=1,"checked","")%> />需要</label>
                                <label><input type="radio" name="is_reg_need_username" value="0" <%=OW.iif(OW.config("is_reg_need_username")=0,"checked","")%> />不需要</label>
                                <span class="t-normal" name="t_is_reg_need_username">不需要则系统随机生成一个</span>
                            </div>
                        </td>
                    </tr>
                    <tr><td class="titletd">会员审核</td>
                        <td class="infotd">
                        <label><input type="checkbox" name="user_reg_check" value="1" <%=OW.iif(OW.config("user_reg_check")=1,"checked","")%>>开启</label>
                        <span class="t-normal ml5" name="t_user_reg_check">开启审核功能后，新注册的会员需要通过管理员的审核才能登陆</span>
                        </td>
                    </tr>
                    <% if SITE_ID=1 then %>
                    <tr><td class="titletd">登陆有效时间</td>
                        <td class="infotd">
                        <input type="text" class="text text-short-mini" name="login_timeout" value="<%=OW.config("login_timeout")%>"/>
                        <span class="t-normal ml5" name="t_login_timeout">即在此时间内无动作即自动退出(以"分钟"为单位)</span>
                        </td>
                    </tr>
                    <tr><td class="titletd top">不允许注册的用户名</td>
                        <td class="infotd">
                        <textarea class="textarea" name="forbid_username"><%=OW.config("forbid_username")%></textarea>
                        <span class="t-normal ml5" name="t_forbid_username">不区分大小写，每个不允许注册的用户名之间用"|"号分割</span>
                        </td>
                    </tr>
                    <% end if %>
                    </table>
                </div>
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">积分功能</td>
                        <td class="infotd">
                        <div class="labels">
                            <label><input type="radio" name="is_point_open" value="1" <%=OW.iif(OW.config("is_point_open")=1,"checked","")%> />开启</label>
                            <label><input type="radio" name="is_point_open" value="0" <%=OW.iif(OW.config("is_point_open")=0,"checked","")%> />关闭</label>
                            <span class="t-normal ml5" name="t_is_invoice_open"></span>
                        </div>
                        </td>
                    </tr>
                    </table>
                </div>
            </div>
            <div is_tab="true" tab="4">
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">会员登录验证码</td>
                        <td class="infotd">
                        <div class="labels">
                            <label><input type="checkbox" name="user_login_vcode_open_pc" value="1" <%=OW.iif(OW.config("user_login_vcode_open_pc")=1,"checked","")%>>PC端开启</label>
                            <%if OS.hasMobile then%>
                            <label><input type="checkbox" name="user_login_vcode_open_mb" value="1" <%=OW.iif(OW.config("user_login_vcode_open_mb")=1,"checked","")%>>手机端开启</label>
                            <%end if%>
                            <span class="t-normal ml5">不开启验证码有爆库的风险，建议开启</span>
                        </div>
                        </td>
                    </tr>
                    <tr><td class="titletd">会员注册验证码</td>
                        <td class="infotd">
                        <div class="labels">
                            <label><input type="checkbox" name="user_reg_vcode_open_pc" value="1" <%=OW.iif(OW.config("user_reg_vcode_open_pc")=1,"checked","")%>>PC端开启</label>
                            <%if OS.hasMobile then%>
                            <label><input type="checkbox" name="user_reg_vcode_open_mb" value="1" <%=OW.iif(OW.config("user_reg_vcode_open_mb")=1,"checked","")%>>手机端开启</label>
                            <%end if%>
                            <span class="t-normal ml5">不开启验证码有爆库的风险，建议开启</span>
                        </div>
                        </td>
                    </tr>
                    <tr><td class="titletd">找回密码验证码</td>
                        <td class="infotd">
                        <div class="labels">
                            <label><input type="checkbox" name="user_forget_vcode_open_pc" value="1" <%=OW.iif(OW.config("user_forget_vcode_open_pc")=1,"checked","")%>>PC端开启</label>
                            <%if OS.hasMobile then%>
                            <label><input type="checkbox" name="user_forget_vcode_open_mb" value="1" <%=OW.iif(OW.config("user_forget_vcode_open_mb")=1,"checked","")%>>手机端开启</label>
                            <%end if%>
                            <span class="t-normal ml5">不开启验证码有爆库的风险，建议开启</span>
                        </div>
                        </td>
                    </tr>
                    <tr><td class="titletd">表单验证码</td>
                        <td class="infotd">
                        <div class="labels">
                            <label><input type="checkbox" name="form_vcode_open" value="1" <%=OW.iif(OW.config("form_vcode_open")=1,"checked","")%>>开启</label>
                            <span class="t-normal ml5">不开启验证码有爆库的风险，建议开启</span>
                        </div>
                        </td>
                    </tr>
                    </table>
                </div>
            </div>
            <div is_tab="true" tab="5">
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">后台上传文件</td>
                        <td class="infotd">
                        <button type="button" class="btn" name="add_upload_file_types">添加</button>
                        <span class="t-normal ml5" name="t_upload_file_types"></span>
                        <div class="tags" id="types_list"></div>
                        <input type="text" class="text text-long" name="upload_file_types" value="<%=OW.config("upload_file_types")%>"/>
                        <div class="spans-inline">
                            <div style="padding-top:5px;">
                                <span class="headline">单个文件大小限制</span>
                                <div class="spans">
                                <input type="text" class="text text-short-mini" name="upload_file_size_limit" value="<%=OW.config("upload_file_size_limit")%>"/> M 
                                <span class="t-normal ml5" name="t_upload_file_size_limit">不能超过服务器允许上传的最大设置，一般服务器不能超过2M</span>
                                </div>
                            </div>
                        </div>
                        </td>
                    </tr>
                    <tr><td class="titletd">允许前台上传附件？</td>
                        <td class="infotd">
                        <div class="spans-inline">
                            <div style="padding-bottom:5px;">
                                <span class="headline">
                                <label><input type="checkbox" name="upload_client_file" value="1" <%=OW.iif(OW.config("upload_client_file")=1,"checked","")%>><strong style="color:#424242;">允许</strong></label><span class="t-normal ml5" name="t_upload_client_file"></span>
                                </span>
                            </div>
                            <div style="padding-bottom:5px;">
                                <span class="headline">允许上传的文件格式</span>
                                <div class="spans">
                                <input type="text" class="text text-long" name="upload_client_file_types" value="<%=OW.config("upload_client_file_types")%>"/>
                                </div>
                            </div>
                            <span class="headline">单个文件大小限制</span>
                            <div class="spans">
                            <input type="text" class="text text-short-mini" name="upload_client_file_size_limit" value="<%=OW.config("upload_client_file_size_limit")%>"/> M 
                            <span class="t-normal ml5" name="t_upload_client_file_size_limit">不能超过服务器允许上传的最大设置，一般服务器不能超过2M</span>
                            </div>
                        </div>
                        </td>
                    </tr>
                    </table>
                </div>
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">开启图片水印？</td>
                        <td class="infotd">
                        <label><input type="checkbox" name="wartermark" value="1" <%=OW.iif(OW.config("wartermark")=1,"checked","")%>>开启</label>
                        <span class="t-normal ml5" name="t_wartermark"></span>
                        </td>
                    </tr>
                    <tr><td class="titletd">水印条件</td>
                        <td class="infotd">
                        <div class="spans-inline">
                            <span class="headline">当图片小于以下尺寸时则不添加水印</span>
                            <div class="spans">
                            <span>宽 <input type="text" class="text text-short-mini" name="wartermark_min_width" value="<%=OW.config("wartermark_min_width")%>"/> px</span>
                            <span>高 <input type="text" class="text text-short-mini" name="wartermark_min_height" value="<%=OW.config("wartermark_min_height")%>"/> px</span>
                            </div>
                        </div>
                        </td>
                    </tr>
                    <tr><td class="titletd">水印透明度</td>
                        <td class="infotd">
                        <input type="text" class="text text-short-mini" name="wartermark_transparency" value="<%=OW.config("wartermark_transparency")%>">
                        <span class="t-normal ml5" name="t_wartermark_transparency">半透明则设为0.5，不透明则设为1</span>
                        </td>
                    </tr>
                    <tr><td class="titletd">水印类型</td>
                        <td class="infotd">
                        <div class="labels">
                        <label><input type="radio" name="wartermark_type" value="0" <%=OW.iif(OW.config("wartermark_type")=0,"checked","")%> />图片</label>
                        <label><input type="radio" name="wartermark_type" value="1" <%=OW.iif(OW.config("wartermark_type")=1,"checked","")%> />文字</label>
                        </div>
                        <div class="wartermark_type" name="wartermark_type" value="0" <%=OW.iif(OW.config("wartermark_type")=0,"","style=""display:none""")%>>
                        <%=Admin.createImageSelectGrid("wartermark_image",OW.config("wartermark_image"),"若要做透明的水印，则须把水印图片做成透明png格式","")%>
                        </div>
                        <div class="wartermark_type" name="wartermark_type" value="1" <%=OW.iif(OW.config("wartermark_type")=1,"","style=""display:none""")%>>
                        <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                        <tr><td class="titletd top">水印文字</td>
                            <td class="infotd">
                            <input type="text" class="text" name="wartermark_font" maxlength="50" value="<%=OW.config("wartermark_font")%>"/>
                            </td>
                        </tr>
                        <tr><td class="titletd">文字颜色</td>
                            <td class="infotd">
                            <input type="text" class="text text-short-mini fl" name="wartermark_font_color" id="wartermark_font_color" maxlength="7" value="<%=OW.config("wartermark_font_color")%>" onblur="OW.onblur(this,{rep:'/[^#0-9a-zA-Z]*/g',length:7})"/>
                            <span id="select_color"></span>
                            <span class="t-normal ml5" name="t_site_sname"></span>
                            <script type="text/javascript">
                            var fontColor = OWColor({
                                container:$("#select_color"),
                                defaultColor:"<%=OW.config("wartermark_font_color")%>",
                                getColor:function(){
									$("input[name='wartermark_font']").css('color',fontColor.color);
									$("input[name='wartermark_font_color']").css('color',fontColor.color).val(fontColor.color);
								},
                                clear:function(){
									$("input[name='wartermark_font']").css('color','');
									$("input[name='wartermark_font_color']").css('color','').val('');
								},
                                clearValue:"清除"
                            });
							if(fontColor.config.defaultColor!=""){
								$("input[name='wartermark_font']").css('color',fontColor.config.defaultColor);
								$("input[name='wartermark_font_color']").css('color',fontColor.config.defaultColor);
							};
                            </script>
                            </td>
                        </tr>
                        <tr><td class="titletd top">文字大小</td>
                            <td class="infotd">
                            <input type="text" class="text text-short-mini" name="wartermark_font_size" value="<%=OW.config("wartermark_font_size")%>"/> px
                            </td>
                        </tr>
                        </table>
                        </div>
                        </td>
                    </tr>
                    <tr><td class="titletd">水印位置</td>
                        <td class="infotd">
                        <table border="0" cellpadding="0" cellspacing="0" class="table table-bordered table-hover" style="width:auto;">
                        <tr>
                            <td><label><input type="radio" name="wartermark_position" value="0" <%=OW.iif(OW.config("wartermark_position")=0,"checked","")%>>左上</label></td>
                            <td><label><input type="radio" name="wartermark_position" value="1" <%=OW.iif(OW.config("wartermark_position")=1,"checked","")%>>中上</label></td>
                            <td><label><input type="radio" name="wartermark_position" value="2" <%=OW.iif(OW.config("wartermark_position")=2,"checked","")%>>右上</label></td>
                        </tr>
                        <tr>
                            <td><label><input type="radio" name="wartermark_position" value="3" <%=OW.iif(OW.config("wartermark_position")=3,"checked","")%>>左中</label></td>
                            <td><label><input type="radio" name="wartermark_position" value="4" <%=OW.iif(OW.config("wartermark_position")=4,"checked","")%>>中正</label></td>
                            <td><label><input type="radio" name="wartermark_position" value="5" <%=OW.iif(OW.config("wartermark_position")=5,"checked","")%>>右中</label></td>
                        </tr>
                        <tr>
                            <td><label><input type="radio" name="wartermark_position" value="6" <%=OW.iif(OW.config("wartermark_position")=6,"checked","")%>>左下</label></td>
                            <td><label><input type="radio" name="wartermark_position" value="7" <%=OW.iif(OW.config("wartermark_position")=7,"checked","")%>>中下</label></td>
                            <td><label><input type="radio" name="wartermark_position" value="8" <%=OW.iif(OW.config("wartermark_position")=8,"checked","")%>>右下</label></td>
                        </tr>
                        </table>
                        </td>
                    </tr>
                    </table>
                </div>
            </div>
            <div is_tab="true" tab="6">
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">网站授权id</td>
                        <td class="infotd">
                        <input type="text" class="text" name="openwbs_website_id" value="<%=OW.config("openwbs_website_id")%>"/>
                        <span class="t-normal ml5"><a href="http://www.openwbs.com/contact_us.html" target="_blank">申请接口</a></span>
                        </td>
                    </tr>
                    <tr><td class="titletd">SMS密钥</td>
                        <td class="infotd">
                        <input type="text" class="text" name="openwbs_website_sms_key" value="<%=OW.config("openwbs_website_sms_key")%>"/>
                        <span class="t-normal ml5" name="t_openwbs_website_sms_key"></span>
                        </td>
                    </tr>
                    </table>
                </div>
            </div>
            <div is_tab="true" tab="7">
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">SMTP服务器</td>
                        <td class="infotd">
                        <input type="text" class="text" name="mail_smtp" value="<%=OW.config("mail_smtp")%>"/>
                        <span class="t-normal ml5" name="t_mail_smtp"></span>
                        </td>
                    </tr>
                    <tr><td class="titletd">SMTP身份验证用户名</td>
                        <td class="infotd">
                        <input type="text" class="text" name="mail_mailserver_username" value="<%=OW.config("mail_mailserver_username")%>"/>
                        <span class="t-normal ml5" name="t_mail_mailserver_username"></span>
                        </td>
                    </tr>
                    <tr><td class="titletd">SMTP身份验证密码</td>
                        <td class="infotd">
                        <input type="text" class="text" name="mail_mailserver_password" value="<%=OW.config("mail_mailserver_password")%>"/>
                        <span class="t-normal ml5" name="t_mail_mailserver_password"></span>
                        </td>
                    </tr>
                    <tr><td class="titletd">发信人邮件地址</td>
                        <td class="infotd">
                        <input type="text" class="text" name="mail_from" value="<%=OW.config("mail_from")%>"/>
                        <span class="t-normal ml5" name="t_mail_from"></span>
                        </td>
                    </tr>
                    <tr><td class="titletd">发信人名称</td>
                        <td class="infotd">
                        <input type="text" class="text" name="mail_fromname" value="<%=OW.config("mail_fromname")%>"/>
                        <span class="t-normal ml5" name="t_mail_fromname"></span>
                        </td>
                    </tr>
                    </table>
                </div>
            </div>
            <div is_tab="true" tab="8">
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">手机端</td>
                        <td class="infotd">
                        <div class="labels">
                        <label><input type="checkbox" name="mobile_open" value="1" <%=OW.iif(OW.config("mobile_open")=1,"checked","")%> />开启</label>
                        <span class="t-normal ml5" name="t_mobile_open"></span>
                        </div>
                        </td>
                    </tr>
                    <tr><td class="titletd">手机端模板设计调试</td>
                        <td class="infotd">
                        <div class="labels">
                        <label><input type="checkbox" name="mobile_design_open" value="1" <%=OW.iif(OW.config("mobile_design_open")=1,"checked","")%> />开启</label>
                        <span class="t-normal ml5" name="t_mobile_design_open">开启后在PC端也可以浏览手机端页面</span>
                        </div>
                        </td>
                    </tr>
                    <tr><td class="titletd">手机端<br />模板html文件夹</td>
                        <td class="infotd">
                        <input type="text" class="text text-short" name="mobile_tpl_html_folder" maxlength="50" value="<%=OW.config("mobile_tpl_html_folder")%>"/>
                        <span class="t-normal ml5" name="t_mobile_tpl_html_folder">默认为html，如果修改请确保与实际文件夹名一致！</span>
                        </td>
                    </tr>
                    </table>
                </div>
            </div>
            <div is_tab="true" tab="9">
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">微信PC网站接口</td>
                        <td class="infotd">
                        <div class="form-in-table">
                            <div class="labels">
                                <label><input type="checkbox" name="is_weixin_pc_open" value="1" <%=OW.iif(OW.config("is_weixin_pc_open")=1,"checked","")%> />开启</label>
                            </div>
                            <div id="is_weixin_pc_open_section" <%=OW.iif(OW.config("is_weixin_pc_open")=1,"","style=""display:none;""")%>>
                                <div style=" background-color:#fafafa; border:1px solid #eee; margin:5px 0px 0px 0px; padding:10px;">
                                <table border="0" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td>
                                    <dl style="border-right:1px solid #eee; padding-right:10px;">
                                        <dt>AppID</dt>
                                        <dd><input type="text" class="text" name="weixin_pc_appid" value="<%=OW.config("weixin_pc_appid")%>" maxlength="32" /></dd>
                                    </dl>
                                    </td>
                                    <td class="pl10">
                                    <dl style="border-right:1px solid #eee; padding-right:10px;">
                                        <dt>AppSecret</dt>
                                        <dd><input type="text" class="text" name="weixin_pc_appsecret" value="<%=OW.config("weixin_pc_appsecret")%>" maxlength="64" /></dd>
                                    </dl>
                                    </td>
                                </tr>
                                </table>
                                </div>
                            </div>
                        </div>
                        </td>
                    </tr>
                    <tr><td class="titletd">微信公众号接口</td>
                        <td class="infotd">
                        <div class="form-in-table">
                            <div class="labels">
                                <label><input type="checkbox" name="is_weixin_mobile_open" value="1" <%=OW.iif(OW.config("is_weixin_mobile_open")=1,"checked","")%> />开启</label>
                            </div>
                            <div id="is_weixin_mobile_open_section" <%=OW.iif(OW.config("is_weixin_mobile_open")=1,"","style=""display:none;""")%>>
                                <div style=" background-color:#fafafa; border:1px solid #eee; margin:5px 0px 0px 0px; padding:10px;">
                                <table border="0" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td>
                                    <dl style="border-right:1px solid #eee; padding-right:10px;">
                                        <dt>AppID</dt>
                                        <dd><input type="text" class="text" name="weixin_mobile_appid" value="<%=OW.config("weixin_mobile_appid")%>" maxlength="32" /></dd>
                                    </dl>
                                    </td>
                                    <td class="pl10">
                                    <dl style="border-right:1px solid #eee; padding-right:10px;">
                                        <dt>AppSecret</dt>
                                        <dd><input type="text" class="text" name="weixin_mobile_appsecret" value="<%=OW.config("weixin_mobile_appsecret")%>" maxlength="64" /></dd>
                                    </dl>
                                    </td>
                                </tr>
                                </table>
                                </div>
                            </div>
                        </div>
                        </td>
                    </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="button-container">
            <button type="submit" class="btn btn-large btn-primary" name="submit">确定保存</button>
            <button type="reset" class="btn btn-large" name="reset">重置</button>
        </div>
        </form>
        <script type="text/javascript">
        function siteDomainsListInit(){
            $("#site_domains tr").each(function(i){
                $(this).find("td:first").html(i);
                var btn = $(this).find("button");
                if(btn.attr("domain")=="<%=SITE_DOMAIN%>"){
                    btn.remove();
                };
            });
            $("#site_domains button[name='btn_domain_delete']").click(function(){
                var $this = $(this),
                $tr       = $(this).parent().parent(),
				domain    = $(this).attr("domain"),
                result    = false,
                $dialog   = new OWDialog({
					id:'delete_domain',
                    content:'确定要将此网站域名 '+ domain +' 删除吗？',
                    ok:function(){
                        $dialog.content('<div class="loading">正在删除...</div>').padding("20px 50px").button({id:'ok',remove:true},{id:'cancel',disabled:true});
						Admin.ajax({
							url:"index.asp?ctl=<%=CTL%>&act=<%=ACT%>&subact=delete_domain&save=true",
							data:"domain="+escape(domain),
							success:function(){
								$dialog.success('成功删除域名 '+ domain +'').button({id:'cancel',remove:true}).timeout(2);
								$tr.remove();
							},
							failed:function(msg){
								$dialog.error('删除域名 '+ domain +' 失败！',msg).button({id:'cancel',remove:true}).timeout(2);
							}
						});
						return false;
                    },
                    cancel:true,
                    close:false,
                    follow:$this
                });
            });
        };
		function urlRewriteAdd(){
			var $dialog = OWDialog({
				id:'d_add_url_rewrite',title:'URL静态化配置',height:'440px',width:'680px',padding:'0px',
				iframe:'index.asp?ctl=<%=CTL%>&act=<%=ACT%>&subact=add_url_rewrite&r='+OW.random()
			});
		};
        $(document).ready(function(){
			var $saveForm = $("#save_form");
			$saveForm.submit(function(){
				var check = true;
				OW.parseFormInputValue({form:$saveForm});
				//**处理必填的字段
				var $validForm = OWValidForm({form:$saveForm});
				$validForm.verify();
				if(!$validForm.result){
					check = false;
				};
				if(check){
					Admin.dialogPosting();
				};
				return check;
			});
			//**
			var tab = <%=OW.int(OW.getForm("get","tab"))%>;
			OW.tabSwitch({tabbar:$(".tabbar"),container:$("#tabs_container"),current:tab});
			//**
            siteDomainsListInit();
			//**
            $("#site_domains tr:even").addClass("eline");
            var addDomainTpl = '<div class="inbox">'+
					'<table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">'+
					  '<tbody>'+
						'<tr><td class="titletd auto">网站域名</td>'+
							'<td class="infotd">'+
							'<input type="text" class="text" name="site_domain" maxlength="100" value=""/>'+
							'<div><span class="t-normal" name="t_site_domain">前面不用加 http:// ，如 www.openwbs.com</span><div>'+
							'</td>'+
						'</tr>'+
						'<tr><td class="titletd auto">网站网址</td>'+
							'<td class="infotd">'+
							'<input type="text" class="text" name="site_url" maxlength="150" value="http://"/>'+
							'<div><span class="t-normal" name="t_site_url">以 http:// 或 https:// 开头，后面以 / 结束，如 http://www.openwbs.com/</span><div>'+
							'</td>'+
						'</tr>'+
					  '</tbody>'+
					'</table>'+
				'</div>';
			//**添加域名
            $("#site_domains-add").click(function(){
                var $dialog = new OWDialog({
                    id:'add_domain',
                    title:'添加域名',
                    content:addDomainTpl,
                    padding:"10px 10px 5px 10px",
                    ok:function(){
                        var check   = true,
                        $siteDomain = $("#add_domain input[name='site_domain']"),
                        $dTip       = $("#add_domain span[name='t_site_domain']"),
                        $siteURL    = $("#add_domain input[name='site_url']"),
                        $uTip       = $("#add_domain span[name='t_site_url']"),
                        domain      = $.trim($siteDomain.val()),
                        url         = $.trim($siteURL.val());
                        $siteDomain.val(domain);
                        $siteURL.val(url);
                        if(domain==""){
                            $dTip.addClass("t-err").html("请先填写网站域名！").show(); $siteDomain.focus(); check = false;
                        };
                        if(check){if(domain.search(/[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+\.?/) == -1){
							$dTip.addClass("t-err").html("这不是一个有效的域名，请填写正确的域名！").show(); $siteDomain.focus(); check = false;
						};};
                        if(check){if(url==""){
							$uTip.addClass("t-err").html("网站网址也要填写哦！").show(); $siteURL.focus(); check = false;
						};};
                        if(check){
                            $dialog.content('<div class="loading">正在向服务器提交数据...</div>').button({id:'ok',remove:true},{id:'cancel',disabled:true}).padding("20px 40px");
							Admin.ajax({
								url:"index.asp?ctl=<%=CTL%>&act=<%=ACT%>&subact=add_domain&save=true",
								data:"domain="+escape(domain)+"&url="+escape(url)+"",
								success:function(){
									$dialog.title(false).success('成功添加域名 '+ domain +'').button({id:'cancel',remove:true}).timeout(2);
									$("#site_domains table").append('<tr><td></td><td>'+domain+'</td><td><a href="'+url+'" target="_blank">'+url+'</a></td><td></td><td></td><td><button type="button" domain="'+domain+'" name="btn_domain_delete" class="btn btn-small">删除</button></td></tr>');
									siteDomainsListInit();
								},
								failed:function(msg){
									$dialog.title(false).error('添加 '+ domain +' 失败！',msg).button({id:'cancel',remove:true}).timeout(2);
								}
							});
                        };
                        return false;
                    },
                    cancel:true,
                    close:false,
                    follow:$(this),
                    initialize:function(){
                        $("#add_domain input[name='site_domain']").focus();
                        $siteDomain = $("#add_domain input[name='site_domain']"),
                        $dTip = $("#add_domain span[name='t_site_domain']"),
                        $siteURL = $("#add_domain input[name='site_url']"),
                        $uTip = $("#add_domain span[name='t_site_url']");
                        $siteDomain.blur(function(){
                            var domain = $.trim($siteDomain.val()).replace(/[^a-zA-Z0-9-_.]*/g,"");
                            $siteDomain.val(domain);
                            if(domain == ""){
                                $dTip.addClass("t-err").html("请先填写网站域名！").show();
                                $siteDomain.focus();
                            }else{
                                if(domain.search(OW.rule("domain")) == -1){
                                    $dTip.addClass("t-err").html("这不是一个有效的域名，请填写正确的域名！").show();
                                    $siteDomain.focus();
                                }else{
                                    $dTip.removeClass("t-err").addClass("t-ok").html("填写正确");
                                }
                            }
                            if(domain!=""){
                                $siteURL.val("http://"+ domain +"/");
                            };
                        });
                    }
                });
            });
			//选择风格
			$(".themes li").click(function(){
				$(".themes li").removeClass("current");
				$(this).addClass("current");
				$("input[name='site_admin_theme']").val($(this).attr("theme"));
			});
			//**运行模式
			$("input[name='run_mode']").click(function(){
				var runMode = OW.int($(this).val());
				if(runMode==1){
					urlRewriteAdd();
				};
				if(runMode>0){
					$("input[name='url_type']").attr("disabled",true);
				}else{
					$("input[name='url_type']").attr("disabled",false);
				};
			});
			//**手机注册
			$("input[name='is_user_mobile_open']").click(function(){
				$section = $("#is_user_mobile_open_section");
				if($(this).val()=="1"){
					$section.show(100);
				}else{
					$section.hide(100);
				};
			});
			//**邮箱注册
			$("input[name='is_user_email_open']").click(function(){
				$section = $("#is_user_email_open_section");
				if($(this).val()=="1"){
					$section.show(100);
				}else{
					$section.hide(100);
				};
			});
			//**用户名注册
			$("input[name='is_reg_need_username'][value='0']").click(function(){
				if($(this).attr("checked")==true){
					if($("input[name='is_user_mobile_open']").attr("checked")==false && $("input[name='is_user_email_open']").attr("checked")==false){
						alert('只要当"手机注册"或"邮箱注册"开启其中一个后才可以选择不需要填写用户名！');
						return false;
					};
				};
			});
			//**允许上传的文件格式{**
			var $typeList   = $("#types_list");
			var $typeInput  = $("input[name='upload_file_types']");
			var $addTypeBtn = $("button[name='add_upload_file_types']");
			appendFileTypeList($typeInput.val());
			function typeListAddEvent(){
				$typeList.find(".tag").hover(
					function(){
						var a = document.createElement("a");
						$(a).addClass("close-circle").attr("href","javascript:;").click(function(){deleteFileTypes({tag:$(this).parent()})});
						$(this).append(a);
					},
					function(){$(this).find(".close-circle").remove();}
				);
			};
			function deleteFileTypes(opt){
				var $tag = opt.tag;
				file_ex_name = $tag.attr("file_ex_name");
				$tag.remove();
				appendFileTypeList("");
			};
			function appendFileTypeList(types){
				var i,arr,exName,tmp = "";
				if(types==""){
					$typeList.find(".tag").each(function(){
						exName = $(this).attr("file_ex_name")
						tmp = "*."+exName;
						types = types=="" ? tmp : types+";"+tmp;
					});
					$typeInput.val(types);
				}else{
					arr = types.split(";");
					arr = OW.arrayUnique(arr);
					$typeList.empty();
					for(i=0;i<arr.length;i++){
						exName = OW.fileExName(arr[i]);
						if(exName!=""){
							$typeList.append('<span file_ex_name="'+exName+'" class="tag">'+exName+'</span>');
							typeListAddEvent();
						};
					};
					$typeInput.val(arr.join(";"));
				};
			};
			var addTypeTpl = '<div class="add_types" id="add_types">'+
				'<div class="title-line">填写文件格式</div>'+
				'<div class="input-line"><input type="text" class="text" name="input_add_types"></div>'+
				'<dl>'+
					'<dt>常用文件格式</dt>'+
					'<dd>'+
						'<div class="tags">'+
						'<span class="tag tag-small">jpg</span>'+
						'<span class="tag tag-small">jpeg</span>'+
						'<span class="tag tag-small">png</span>'+
						'<span class="tag tag-small">gif</span>'+
						'<span class="tag tag-small">bmp</span>'+
						'<span class="tag tag-small">psd</span>'+
						'<span class="tag tag-small">rar</span>'+
						'<span class="tag tag-small">zip</span>'+
						'<span class="tag tag-small">pdf</span>'+
						'<span class="tag tag-small">txt</span>'+
						'<span class="tag tag-small">doc</span>'+
						'<span class="tag tag-small">docx</span>'+
						'<span class="tag tag-small">ppt</span>'+
						'<span class="tag tag-small">pptx</span>'+
						'<span class="tag tag-small">xlsx</span>'+
						'<span class="tag tag-small">mdb</span>'+
						'<span class="tag tag-small">accdb</span>'+
						'<span class="tag tag-small">rm</span>'+
						'<span class="tag tag-small">rmvb</span>'+
						'<span class="tag tag-small">avi</span>'+
						'<span class="tag tag-small">wmv</span>'+
						'<span class="tag tag-small">mp3</span>'+
						'<span class="tag tag-small">mp4</span>'+
						'<span class="tag tag-small">swf</span>'+
						'<span class="tag tag-small">flv</span>'+
						'</div>'+
					'</dd>'+
				'</dl>'+
			'</div>';
			$addTypeBtn.click(function(){
				var $dialog = OWDialog({
					content:addTypeTpl,padding:"15px 20px 10px 20px",width:400,cancel:true,follow:$(this),shadow:false,
					ok:function(){
						var tmp,arr,exName,types="";
						var v = $.trim($("input[name='input_add_types']").val());
						if(v!=""){types = "*."+ v;};
						$("#add_types span.selected").each(function(){
							tmp   = "*."+$(this).html();
							types = types=="" ? tmp : types +";"+ tmp;
						});
						tmp = $.trim($typeInput.val());
						if(tmp!=""){types = tmp +";"+ types;};
						appendFileTypeList(types);
					}
				});
				$("#add_types span.tag").toggle(function(){$(this).addClass("selected");},function(){$(this).removeClass("selected");});
			});
			//**}**
			//**清除缓存
			$("button[name='clear_cache']").click(function(){Admin.clearCache()});
			//**水印类型
			$("input[name='wartermark_type']").click(function(){
				var val = $(this).val();
				$("div[name='wartermark_type'][value='"+val+"']").show("fast");
				$("div[name='wartermark_type']:not([value='"+val+"'])").hide("fast");
			});
			//**微信PC登录
			$("input[name='is_weixin_pc_open']").click(function(){
				var $section = $("#is_weixin_pc_open_section");
				if($(this).attr("checked")==true){
					$section.show(100);
				}else{
					$section.hide(100);
				};
			});
			//**微信公众号登录
			$("input[name='is_weixin_mobile_open']").click(function(){
				var $section = $("#is_weixin_mobile_open_section");
				if($(this).attr("checked")==true){
					$section.show(100);
				}else{
					$section.hide(100);
				};
			});
        });      
        </script>
    </div>
	<%
		call Admin.echoFooter()
	end function
	
	private function configUpdate(byval name, byval value)
		dim sql,result,siteId
		name  = trim(name)
		value = trim(value)
		if name="upload_share_manage" or name="member_share_manage" or name="run_mode" or name="login_timeout" or name="forbid_username" then
			if SITE_ID=1 then
				siteId = 0
			else
				siteId = -1
			end if
		else
			siteId = SITE_ID
		end if
		if OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"site_config WHERE site_id="& siteId &" AND config_name='"& name &"'") then
			result = OW.DB.execute("UPDATE "& DB_PRE &"site_config SET config_value='"& value &"' WHERE site_id="& siteId &" AND config_name='"& name &"'")
		else
			result = OW.DB.addRecord(DB_PRE &"site_config",array("site_id:"& siteId,"config_name:"& name,"config_value:"& value))
		end if
		configUpdate = result
	end function
	
	private function settingSave()
		dim check,key,scfg,config
		'**数据初始化
		check = true
		'**接收数据
		set config  = server.createObject(OW.dictName)
		'**
		'**
		config("site_lang")       = OW.validDBData(OW.getForm("post","site_lang"),20)
		config("site_admin_lang") = config("site_lang")
		config("site_domain")     = OW.getDomain(OW.getForm("post","site_url"))
		config("site_url")        = OW.validDBData(OW.getForm("post","site_url"),150)
		config("site_path")       = OW.validDBData(OW.getForm("post","site_path"),50)
		config("site_folder")     = OW.validDBData(OW.getForm("post","site_folder"),50)
		'**
		if OW.right(config("site_url"),1)<>"/" then config("site_url") = config("site_url") &"/"
		'**
		config("site_admin_theme")= OW.validDBData(OW.getForm("post","site_admin_theme"),20)
		'**
		config("site_close")      = OW.int(OW.getForm("post","site_close"))
		config("site_close_html") = OW.validDBData(OW.getForm("post","site_close_html"),2000)
		'**
		if IS_MULTI_SITES AND SITE_ID=1 then
		config("upload_share_manage") = OW.int(OW.getForm("post","upload_share_manage"))
		config("member_share_manage") = OW.int(OW.getForm("post","member_share_manage"))
		end if
		config("money_sb")            = OW.validDBData(OW.getForm("post","money_sb"),2)
		config("debug")               = OW.int(OW.getForm("post","debug"))
		'**
		if SITE_ID=1 then
		config("run_mode")        = OW.int(OW.getForm("post","run_mode"))
		end if
		config("cache_open")      = OW.int(OW.getForm("post","cache_open"))
		config("cache_time")      = OW.int(OW.getForm("post","cache_time"))
		config("html_cache_open") = OW.int(OW.getForm("post","html_cache_open"))
		config("html_cache_time") = OW.int(OW.getForm("post","html_cache_time"))
		config("gzip_open")       = OW.int(OW.getForm("post","gzip_open"))
		config("url_type")        = OW.int(OW.getForm("post","url_type"))
		config("url_path_type")   = OW.int(OW.getForm("post","url_path_type"))
		'**
		config("user_login_close")       = OW.int(OW.getForm("post","user_login_close"))
		config("user_reg_close")         = OW.int(OW.getForm("post","user_reg_close"))
		config("user_reg_check")         = OW.int(OW.getForm("post","user_reg_check"))
		config("is_user_mobile_open")    = OW.int(OW.getForm("post","is_user_mobile_open"))
		config("mobile_interval_time")   = OW.int(OW.getForm("post","mobile_interval_time"))
		if config("mobile_interval_time")<10 then config("mobile_interval_time")=10
		config("is_user_email_open")     = OW.int(OW.getForm("post","is_user_email_open"))
		config("is_user_email_activate") = OW.int(OW.getForm("post","is_user_email_activate"))
		config("is_reg_need_username")   = OW.int(OW.getForm("post","is_reg_need_username"))
		if config("is_user_mobile_open")=0 and config("is_user_email_open")=0 then
			config("is_reg_need_username") = 1
		end if
		if SITE_ID=1 then
		config("login_timeout")   = OW.int(OW.getForm("post","login_timeout"))
		config("forbid_username") = OW.validDBData(OW.getForm("post","forbid_username"),0)
		end if
		config("is_point_open")   = OW.int(OW.getForm("post","is_point_open"))
		'**
		config("user_login_vcode_open_pc")  = OW.int(OW.getForm("post","user_login_vcode_open_pc"))
		config("user_login_vcode_open_mb")  = OW.int(OW.getForm("post","user_login_vcode_open_mb"))
		config("user_reg_vcode_open_pc")    = OW.int(OW.getForm("post","user_reg_vcode_open_pc"))
		config("user_reg_vcode_open_mb")    = OW.int(OW.getForm("post","user_reg_vcode_open_mb"))
		config("user_forget_vcode_open_pc") = OW.int(OW.getForm("post","user_forget_vcode_open_pc"))
		config("user_forget_vcode_open_mb") = OW.int(OW.getForm("post","user_forget_vcode_open_mb"))
		config("form_vcode_open")           = OW.int(OW.getForm("post","form_vcode_open"))
		'**
		config("upload_file_types")        = OW.parseForbidFileEx(OW.validDBData(OW.getForm("post","upload_file_types"),0))
		config("upload_file_size_limit")   = OW.parseFloat(OW.getForm("post","upload_file_size_limit"),2)
		config("upload_client_file")       = OW.int(OW.getForm("post","upload_client_file"))
		config("upload_client_file_types") = OW.parseForbidFileEx(OW.validDBData(OW.getForm("post","upload_client_file_types"),0))
		config("upload_client_file_size_limit") = OW.parseFloat(OW.getForm("post","upload_client_file_size_limit"),2)
		config("wartermark")               = OW.int(OW.getForm("post","wartermark"))
		config("wartermark_min_width")     = OW.int(OW.getForm("post","wartermark_min_width"))
		config("wartermark_min_height")    = OW.int(OW.getForm("post","wartermark_min_height"))
		config("wartermark_transparency")  = OW.parseFloat(OW.getForm("post","wartermark_transparency"),2)
		if config("wartermark_transparency")>1 then config("wartermark_transparency")=1
		if config("wartermark_transparency")<0 then config("wartermark_transparency")=0
		config("wartermark_type")        = OW.int(OW.getForm("post","wartermark_type"))
		config("wartermark_image")       = OW.validDBData(OW.getForm("post","wartermark_image"),255)
		config("wartermark_font")        = OW.validDBData(OW.getForm("post","wartermark_font"),50)
		config("wartermark_font_color")  = OW.validDBData(OW.regReplace(OW.getForm("post","wartermark_font_color"),"[^#0-9a-zA-Z]",""),7)
		config("wartermark_font_size")   = OW.int(OW.getForm("post","wartermark_font_size"))
		config("wartermark_position")    = OW.int(OW.getForm("post","wartermark_position"))
		'**
		config("openwbs_website_id")       = OW.validDBData(OW.getForm("post","openwbs_website_id"),10)
		config("openwbs_website_sms_key")  = OW.validDBData(OW.getForm("post","openwbs_website_sms_key"),32)
		config("mail_smtp")                = OW.validDBData(OW.getForm("post","mail_smtp"),0)
		config("mail_mailserver_username") = OW.validDBData(OW.getForm("post","mail_mailserver_username"),0)
		config("mail_mailserver_password") = OW.validDBData(OW.getForm("post","mail_mailserver_password"),0)
		config("mail_from")                = OW.validDBData(OW.getForm("post","mail_from"),0)
		config("mail_fromname")            = OW.validDBData(OW.getForm("post","mail_fromname"),0)
		'**
		config("is_weixin_pc_open")        = OW.int(OW.getForm("post","is_weixin_pc_open"))
		config("weixin_pc_appid")          = OW.left(OW.regReplace(OW.getForm("post","weixin_pc_appid"),"[^0-9a-zA-Z]",""),18)
		config("weixin_pc_appsecret")      = OW.left(OW.regReplace(OW.getForm("post","weixin_pc_appsecret"),"[^0-9a-zA-Z]",""),32)
		config("is_weixin_mobile_open")    = OW.int(OW.getForm("post","is_weixin_mobile_open"))
		config("weixin_mobile_appid")      = OW.left(OW.regReplace(OW.getForm("post","weixin_mobile_appid"),"[^0-9a-zA-Z]",""),18)
		config("weixin_mobile_appsecret")  = OW.left(OW.regReplace(OW.getForm("post","weixin_mobile_appsecret"),"[^0-9a-zA-Z]",""),32)
		'**
		config("mobile_open")             = OW.int(OW.getForm("post","mobile_open"))
		config("mobile_design_open")      = OW.int(OW.getForm("post","mobile_design_open"))
		'**
		config("tpl_html_folder")         = OW.validDBData(OW.regReplace(OW.getForm("post","tpl_html_folder"),"[^0-9a-zA-Z-_.]",""),20)
		config("mobile_tpl_html_folder")  = OW.validDBData(OW.regReplace(OW.getForm("post","mobile_tpl_html_folder"),"[^0-9a-zA-Z-_.]",""),20)
		'**数据处理
		if config("run_mode")>0 then
			config("url_type") = 0
		end if
		'**数据合法性校验
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			result = false
			for each key in config
				if configUpdate(key,config(key)) then
					call OW.DB.updateRecord(DB_PRE &"sites",array("site_domain:"& config("site_domain"),"site_url:"& config("site_url"),"site_folder:"& config("site_folder")),"")
					if not OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"site_domains WHERE site_domain='"& config("site_domain") &"'") then
						if OW.int(OW.DB.getFieldValueBySQL("SELECT count(*) FROM ["& DB_PRE &"site_domains] WHERE "& OW.DB.auxSQL &""))=1 then
							call OW.DB.updateRecord(DB_PRE &"site_domains",array("site_domain:"& config("site_domain"),"site_url:"& config("site_url")),array("site_id:"& SITE_ID))
						else
							call OW.DB.addRecord(DB_PRE &"site_domains",array("site_id:"& SITE_ID,"site_domain:"& config("site_domain"),"site_url:"& config("site_url")))
						end if
					end if
					result = true
				end if
			next
			Admin.actionFinishSuccess     = result
			Admin.actionFinishSuccessText = array("成功保存网站设置",array("返回>index.asp?ctl="& CTL &"&act="& ACT &""))
			Admin.actionFinishFailText    = array("保存网站设置失败",array("返回>index.asp?ctl="& CTL &"&act="& ACT &""))
			Admin.actionFinishRun()
			if config("run_mode")=0 AND SITE_ID=1 then
				call OW.FSO.deleteFile(OW.FSO.ABSPath("httpd.ini"))
				call OW.FSO.deleteFile(OW.FSO.ABSPath(".htaccess"))
			end if
			'**更新配置缓存
			OS.updateConfigCache()
		end if
	end function
	
	private function siteInfoSettingHtml()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <script language="javascript" type="text/javascript" src="js/colorpicker.js"></script>
    <div class="mbody">
        <form name="save_form" id="save_form" action="?ctl=<%=CTL%>&act=<%=ACT%>&save=true" method="post">
        <div id="tabs_container" class="wbox">
            <div name="tabbar" tab="1">
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">网站名称</td>
                        <td class="infotd">
                        <input type="text" class="text" name="site_name" maxlength="250" value="<%=OW.config("site_name")%>"/>
                        <span class="t-normal ml5" name="t_site_name"></span>
                        </td>
                    </tr>
                    <tr><td class="titletd">网站简称</td>
                        <td class="infotd">
                        <input type="text" class="text" name="site_mini_name" maxlength="100" value="<%=OW.config("site_mini_name")%>"/>
                        <span class="t-normal ml5" name="t_site_mini_name"></span>
                        </td>
                    </tr>
                    <tr><td class="titletd">网站LOGO</td>
                        <td class="infotd">
                        <input type="text" class="text text-long" name="site_logo" maxlength="255" value="<%=OW.config("site_logo")%>"/>
                        <button type="button" class="btn" name="select_site_logo">选择...</button>
                        <span class="t-normal ml5" name="t_site_logo"></span>
                        <div class="site-logo" name="site_logo"><%=OW.iif(OW.isNotNul(OW.config("site_logo")),"<img src="""& OW.config("site_logo") &""" />","")%></div>
                        </td>
                    </tr>
                    <tr><td class="titletd">用户中心LOGO</td>
                        <td class="infotd">
                        <input type="text" class="text text-long" name="site_ucenter_logo" maxlength="255" value="<%=OW.config("site_ucenter_logo")%>"/>
                        <button type="button" class="btn" name="select_site_ucenter_logo">选择...</button>
                        <span class="t-normal ml5" name="t_site_ucenter_logo"></span>
                        <div class="site-logo" name="site_ucenter_logo"><%=OW.iif(OW.isNotNul(OW.config("site_ucenter_logo")),"<img src="""& OW.config("site_ucenter_logo") &""" />","")%></div>
                        </td>
                    </tr>
                    <tr><td class="titletd">移动端LOGO</td>
                        <td class="infotd">
                        <input type="text" class="text text-long" name="site_mobile_logo" maxlength="255" value="<%=OW.config("site_mobile_logo")%>"/>
                        <button type="button" class="btn" name="select_site_mobile_logo">选择...</button>
                        <span class="t-normal ml5" name="t_site_mobile_logo"></span>
                        <div class="site-logo" name="site_mobile_logo"><%=OW.iif(OW.isNotNul(OW.config("site_mobile_logo")),"<img src="""& OW.config("site_mobile_logo") &""" />","")%></div>
                        </td>
                    </tr>
                    </table>
                </div>
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">首页SEO标题</td>
                        <td class="infotd">
                        <input type="text" class="text text-long" name="site_title" maxlength="250" value="<%=OW.config("site_title")%>"/>
                        <span class="t-normal ml5" name="t_site_title">网站首页的标题(title)</span>
                        </td>
                    </tr>
                    <tr><td class="titletd">首页SEO关键词<div class="font-w-normal">keywords</div></td>
                        <td class="infotd">
                        <input type="text" class="text text-long" name="site_keywords" maxlength="250" value="<%=OW.config("site_keywords")%>"/>
                        <span class="t-normal ml5" name="t_site_keywords">网站首页的meta标签关键字</span>
                        </td>
                    </tr>
                    <tr><td class="titletd top">首页SEO描述<div class="font-w-normal">description</div></td>
                        <td class="infotd">
                        <textarea class="textarea" id="site_description" maxlength="250" name="site_description"><%=OW.config("site_description")%></textarea>
                        <span class="t-normal ml5" name="t_site_description">网站首页的meta标签描述</span>
                        </td>
                    </tr>
                    </table>
                </div>
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd top">网站公告</td>
                        <td class="infotd">
                        <textarea class="textarea textarea-long" name="notice" maxlength="2000"><%=OW.config("notice")%></textarea>
                        <span class="t-normal ml5" name="t_notice">支持html</span>
                        </td>
                    </tr>
                    </table>
                </div>
                <div class="inbox">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                    <tr><td class="titletd">ICP备案号</td>
                        <td class="infotd">
                        <input type="text" class="text text-short" name="icp" maxlength="20" value="<%=OW.config("icp")%>"/>
                        <span class="t-normal ml5" name="t_site_icp"></span>
                        </td>
                    </tr>
                    <tr><td class="titletd top">网站统计代码</td>
                        <td class="infotd">
                        <textarea class="textarea textarea-long" name="statistics" maxlength="2000"><%=OW.config("statistics")%></textarea>
                        <span class="t-normal ml5" name="t_statistics">把统计代码复制到此处即可</span>
                        </td>
                    </tr>
                    </table>
                </div>
            </div>
        </div>
        <div class="button-container">
            <button type="submit" class="btn btn-large btn-primary" name="submit">确定保存</button>
            <button type="reset" class="btn btn-large" name="reset">重置</button>
        </div>
        </form>
        <script type="text/javascript">
        $(document).ready(function(){
			//**网站logo
			$("button[name='select_site_logo']").click(function(){
				Admin.selectImages({
					num:1,type:'url',sitepath:'<%=SITE_PATH%>',
					callback:function(){
						if(Admin.selectImagesData!=""){
							$("input[name='site_logo']").val(Admin.selectImagesData);
							$("div[name='site_logo']").empty().append('<img src="'+Admin.selectImagesData+'" />');
						};
					}
				});
			});
			$("input[name='site_logo']").change(function(){
				var url = $.trim($(this).val());
				if(url!=""){
					$("div[name='site_logo']").empty().append('<img src="'+url+'" />');
				};
			});
			//**用户中心logo
			$("button[name='select_site_ucenter_logo']").click(function(){
				Admin.selectImages({
					num:1,type:'url',sitepath:'<%=SITE_PATH%>',
					callback:function(){
						if(Admin.selectImagesData!=""){
							$("input[name='site_ucenter_logo']").val(Admin.selectImagesData);
							$("div[name='site_ucenter_logo']").empty().append('<img src="'+Admin.selectImagesData+'" />');
						};
					}
				});
			});
			$("input[name='site_ucenter_logo']").change(function(){
				var url = $.trim($(this).val());
				if(url!=""){
					$("div[name='site_ucenter_logo']").empty().append('<img src="'+url+'" />');
				};
			});
			//**移动端logo
			$("button[name='select_site_mobile_logo']").click(function(){
				Admin.selectImages({
					num:1,type:'url',sitepath:'<%=SITE_PATH%>',
					callback:function(){
						if(Admin.selectImagesData!=""){
							$("input[name='site_mobile_logo']").val(Admin.selectImagesData);
							$("div[name='site_mobile_logo']").empty().append('<img src="'+Admin.selectImagesData+'" />');
						};
					}
				});
			});
			$("input[name='site_mobile_logo']").change(function(){
				var url = $.trim($(this).val());
				if(url!=""){
					$("div[name='site_mobile_logo']").empty().append('<img src="'+url+'" />');
				};
			});
			//**
        });      
        </script>
    </div>
	<%
		call Admin.echoFooter()
	end function
	
	private function siteInfoSettingSave()
		dim check,key,scfg,config
		'**数据初始化
		check = true
		'**接收数据
		set config  = server.createObject(OW.dictName)
		'**
		config("site_name")         = OW.validDBData(OW.getForm("post","site_name"),250)
		config("site_mini_name")    = OW.validDBData(OW.getForm("post","site_mini_name"),100)
		'**
		config("site_logo")         = OW.validDBData(OW.getForm("post","site_logo"),255)
		config("site_ucenter_logo") = OW.validDBData(OW.getForm("post","site_ucenter_logo"),255)
		config("site_mobile_logo") = OW.validDBData(OW.getForm("post","site_mobile_logo"),255)
		'**
		config("site_title")        = OW.validDBData(OW.getForm("post","site_title"),250)
		config("site_keywords")     = OW.validDBData(OW.getForm("post","site_keywords"),250)
		config("site_description")  = OW.validDBData(OW.getForm("post","site_description"),250)
		'**
		config("notice")            = OW.validDBData(OW.getForm("post","notice"),2000)
		config("icp")               = OW.validDBData(OW.getForm("post","icp"),20)
		config("statistics")        = OW.validDBData(OW.getForm("post","statistics"),2000)
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			result = false
			for each key in config
				if configUpdate(key,config(key)) then
					result = true
				end if
			next
			Admin.actionFinishSuccess = result
			Admin.actionFinishSuccessText = array("网站信息设置保存成功",array("返回>index.asp?ctl="& CTL &"&act="& ACT &""))
			Admin.actionFinishFailText = array("网站信息设置保存失败",array("返回>index.asp?ctl="& CTL &"&act="& ACT &""))
			Admin.actionFinishRun()
			'**更新配置缓存
			OS.updateConfigCache()
		end if
	end function
	
end class

%>
