<%
'**
'站点管理
'**
dim AP_SMSLOG
class AP_SMSLOG_CLASS
	
	private aArr,oRs,iI,bResult	
	private sub class_initialize()
	end sub
	
	public sub init()
		if CTL="smslog" then
			select case ACT
			case "list"
				call list()
			case "delete"
				if SUBACT="delete_all" then
					call deleteAll()
				else
					call delete()
				end if
			end select
		end if
	end sub
	
	private sub class_terminate()
	end sub
	
	private function delete()
		dim check,s,id
		check = true
		'**接收数据
		V("ids") = OW.regReplace(OW.getForm("post","ids"),"[^0-9,]","")
		'**数据处理
		aArr = split(V("ids"),",")
		'**数据合法性校验
		if V("ids")="" then check = false : Admin.errorSetting("短信记录id值传递不正确")
		'**从数据库删除记录
		if check then
			'**delete
			for iI=0 to ubound(aArr)
				id = OW.clng(aArr(iI))
				bResult = OW.DB.execute("DELETE FROM ["& DB_PRE &"mobile_sms_log] WHERE id="& id &"")
				if bResult then
					s = s & replace("成功删除短信记录(id:{$id})","{$id}",id) &"<br>"
				else
					s = s & replace("删除短信记录失败(id:{$id})","{$id}",id) &"<br>"
				end if
			next
			'**输出操作结果信息
			Admin.actionFinishSuccess = true
			Admin.actionFinishSuccessText = array(s,"")
			Admin.actionFinishFailText = array(s,"")
			Admin.actionFinishRun()
		end if
	end function
	
	private function deleteAll()
		bResult = OW.DB.execute("DELETE FROM ["& DB_PRE &"mobile_sms_log] WHERE "& OW.DB.auxSQL &"")
		if bResult then
			s = "成功清空所有系统记录。"
		else
			s = "清空所有系统记录失败。"
		end if
		'**输出操作结果信息
		Admin.actionFinishSuccess = true
		Admin.actionFinishSuccessText = array(s,"index.asp?ctl="& CTl &"&act=list")
		Admin.actionFinishFailText = array(s,"index.asp?ctl="& CTl &"&act=list")
		Admin.actionFinishRun()
	end function
	
	private function list()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <div class="top-area">
            <table cellspacing="0" cellpadding="0" border="0">
              <tbody>
              <tr>
              <td class="do-cell">
                  <div class="do-cell-name">删除操作区</div>
                  <div class="do-cell-btn"><button class="btn" id="delete_selected">批量删除</button><button class="btn ml5" id="delete_all" style="display:none;">清空所有记录</button></div>
              </td>
              <td class="do-cell">
                  <div class="do-cell-name">短信剩余提醒</div>
                  <div class="do-cell-btn"><div style="font-size:14px;"><%=OS.getSmsRemainder()%> 条</div></div>
              </td>
              </tr>
              </tbody>
            </table>
        </div>
        <div class="list-area" id="data_list_area">
            <table border="0" cellpadding="0" cellspacing="0" width="100%" class="listTable">
              <thead>
                  <tr class="thead">
                      <th><input type="checkbox" name="select_all" id="select_all"></th>
                      <th style="width:40px;">id</th>
                      <th style="width:60px;">操作人</th>
                      <th style="width:60px;">用户</th>
                      <th style="width:90px;">手机</th>
                      <th style="width:60px;">类型</th>
                      <th style="width:60px;">结果</th>
                      <th style="width:110px;">时间</th>
                      <th>短信内容</th>
                      <th>调试记录</th>
                  </tr>
              </thead>
              <tbody>
              <%=listing()%>
              </tbody>
            </table>
        </div>
    </div>
    <script type="text/javascript">
    $(window).ready(function(){
		Admin.dataListTableInit({
			ctl:"<%=CTL%>",
			act_edit:"edit",
			field_name:"logid",
			status_validValue:"",
			status_validTitle:"",
			status_invalidValue:'',
			status_invalidTitle:'',
			delete_confirm:"删除后记录将无法恢复，您确定要删除吗？",
			delete_confirm2:"",
			delete_doing:"正在删除记录...",
			delete_success:"删除成功",
			delete_failed:"删除操作失败",
			delete_tip:"请先选择您要删除的记录"
		});
		$("#data_list_area td[field='sms_type']").each(function(){
			var type = $(this).attr("value");
			if(type=="1"){
				$(this).html("用户注册");
			}else if(type=="2"){
				$(this).html("找回密码");
			}else if(type=="3"){
				$(this).html("绑定手机");
			}else if(type=="11"){
				$(this).html("订单提醒");
			}else{
				$(this).html("");
			};
		});
		$("#data_list_area td[field='send_result']").each(function(){
			if($(this).attr("value")=="1"){
				$(this).html("发送成功");
			}else{
				$(this).html("发送失败");
			};
		});
		$("#data_list_area td[field='debug_text']").each(function(){
			var text = $(this).attr("value");
			$(this).html('<div class="sms_debug_text">'+text+'</div>');
		});
		$("#delete_all").click(function(){
			var dialog = new OWDialog({
				id:OW.createDialogID(),
				content:"删除后记录将无法恢复，您确定要清空所有系统记录吗？",
				ok:function(){
					OW.openPage("index.asp?ctl=<%=CTL%>&act=delete&subact=delete_all");
				},
				cancel:true,
				follow:$(this),
				close:false
			});
			
		});
	});
    </script>
	<%
		call Admin.echoFooter()
	end function
	
	private function listing()
		Admin.list("fields") = "id,(select username from ["& DB_PRE &"member] where uid=a.operate_uid) as operate_username,(select username from ["& DB_PRE &"member] where uid=a.sms_uid) as username,mobile,sms_type,send_result,send_time,sms_text,debug_text"
		Admin.list("sql")    = "SELECT "& Admin.list("fields") &" FROM ["& DB_PRE &"mobile_sms_log] a ORDER BY id DESC"
		Admin.list("pagesize")       = Admin.getPageSise(ACTION_ID)
		Admin.list("checkboxExists") = true
		Admin.list("opeations")      = ""
		Admin.list("auxURLPara")     = ""
		Admin.list("returnType")     = "html"
		listing = Admin.getDataList()
	end function

end class
%>