<%
'**
'站点管理
'**
dim AP_SYSTEM_CHECK
class AP_SYSTEM_CHECK_CLASS

	private aArr,oRs,sCols,sSQL,iI,iPageSize,sString,sOpeation,sURL,iResult,sTable
	
	private sub class_initialize()
	end sub
	
	public sub init()
		if CTL="system_check" then
			select case ACT
			case "infomation"
				call infomation()
			case "com_check"
				call comCheck()
			case "writeable_check"
				call writeableCheck()
			end select
		end if
	end sub
	
	private sub class_terminate()
	end sub
	
	function support()
		echo "<span class=""cue_ok"">支持</span>"
	end function
	
	function unSupport()
		echo "<span class=""cue_err"">不支持</span>"
	end function
	
	function writeable()
		echo "<span class=""cue_ok"">可读写</span>"
	end function
	function unWriteable()
		echo "<span class=""cue_err"">不可写入</span>"
	end function
	
	
	function infomation()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
		on error resume next
		dim wshShell,wshSysEnv,os,cpu,cpus
		Set wshShell  = server.createObject("WScript.Shell")
		Set wshSysEnv = wshShell.Environment("SYSTEM")
		Set fso = OW.objectFSO
		Set dir = fso.getFolder(OW.serverMapPath(SITE_PATH))
		os   = cstr(wshSysEnv("OS"))
		cpus = cstr(wshSysEnv("PROCESSOR_IDENTIFIER"))
		cpus = cstr(wshSysEnv("NUMBER_OF_PROCESSORS"))
		if isempty(cpus) then
		  cpus = request.serverVariables("NUMBER_OF_PROCESSORS")
		end if
		if cpus & "" = "" then cpus = "(未知)"
		if os & "" = "" then os = "(未知)"
	%>
    <div class="mbody">
        <div class="tabbar">
            <ul>
            <li class="current"><a href="index.asp?ctl=system_check&act=infomation">系统概况</a></li>
            <li><a href="index.asp?ctl=system_check&act=com_check">系统组件检测</a></li>
            <li><a href="index.asp?ctl=system_check&act=writeable_check">文件读写检测</a></li>
            </ul>
        </div>
        <div class="wbox">
            <div class="check-section">
                <h2 class="header">服务器信息</h2>
                <div class="section">
                    <table border="0" cellpadding="0" cellspacing="0" class="table table-bordered table-striped table-hover">
                    <colgroup><col class="col-xs-1"><col class="col-xs-7"></colgroup>
                    <thead><tr class="thead"><th>项目</th><th>信息</th></tr></thead>
                    <tbody>
                        <tr><td style="text-align:left;">操作系统</td><td><%=os%></td></tr>
                        <tr><td style="text-align:left;">web 服务器</td><td><%=request.serverVariables("SERVER_SOFTWARE")%></td></tr>
                        <tr><td style="text-align:left;">服务器地址</td><td><%=OW.getDomain("")%></td></tr>
                        <tr><td style="text-align:left;">服务器端口</td><td><%=OW.getPort()%></td></tr>
                        <tr><td style="text-align:left;">服务器IP</td><td><%=OW.getServerIP()%></td></tr>
                        <tr><td style="text-align:left;">服务器时间</td><td><%=SYS_TIME%></td></tr>
                        <tr><td style="text-align:left;">脚本超时时间</td><td><%=Server.ScriptTimeout%> s</td></tr>
                        <tr><td style="text-align:left;">服务器脚本引擎</td><td><%=ScriptEngine & "/"& ScriptEngineMajorVersion &"."&ScriptEngineMinorVersion&"."& ScriptEngineBuildVersion %></td></tr>
                        <tr><td style="text-align:left;">服务器CPU通道数</td><td><%=cpus%></td></tr>
                        <tr><td style="text-align:left;">已用空间</td><td><%=OW.formatSize(dir.Size)%></td></tr>
                    </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <%
		if err.number<>0 then err.clear
		call Admin.echoFooter()
	end function
	
	function comCheck()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <div class="tabbar">
            <ul>
            <li><a href="index.asp?ctl=system_check&act=infomation">系统概况</a></li>
            <li class="current"><a href="index.asp?ctl=system_check&act=com_check">系统组件检测</a></li>
            <li><a href="index.asp?ctl=system_check&act=writeable_check">文件读写检测</a></li>
            </ul>
        </div>
        <div class="wbox">
            <div class="check-section">
                <h2 class="header">服务器信息</h2>
                <div class="section">
                    <table border="0" cellpadding="0" cellspacing="0" width="100%" class="table table-bordered table-striped table-hover">
                    <thead><tr class="thead"><th><div style="width:320px;">系统组件</div></th><th><div style="width:180px;">当前状态</div></th><th style="width:80%;"><div style="width:180px;">所需状态</div></th></tr></thead>
                    <tbody>
                        <tr><td align="left"><div class="p5">Adodb.Recordset</div></td><td><% if OW.isObjInstalled("Adodb.Recordset") then support : else unSupport : end if %></td><td>支持</td></tr>
                        <tr><td align="left"><div class="p5">Adodb.Connection<p class="exinfo">(ADO 数据对象)</p></div></td><td><% if OW.isObjInstalled("Adodb.Connection") then support : else unSupport : end if %></td><td>支持</td></tr>
                        <tr><td align="left"><div class="p5">Adodb.Stream<p class="exinfo">(ADO 数据流对象,常见被用在无组件上传程序中)</p></div></td><td><% if OW.isObjInstalled("Adodb.Stream") then support : else unSupport : end if %></td><td>支持</td></tr>
                        <tr><td align="left"><div class="p5">Scripting.Dictionary<p class="exinfo">(保存数据键和项目对的对象)</p></div></td><td><% if OW.isObjInstalled("Scripting.Dictionary") then support : else unSupport : end if %></td><td>支持</td></tr>
                        <tr><td align="left"><div class="p5">Microsoft.XMLHTTP<p class="exinfo">(Http 组件, 在采集系统中必须用到)</p></div></td><td><% if OW.isObjInstalled("Microsoft.XMLHTTP") then support : else unSupport : end if %></td><td>支持</td></tr>
                        <tr><td align="left"><div class="p5">Scripting.FileSystemObject<p class="exinfo">(FSO 文件系统管理、文本文件读写)</p></div></td><td><% if OW.isObjInstalled("Scripting.FileSystemObject") then support : else unSupport : end if %></td><td>支持</td></tr>
                        <tr><td align="left"><div class="p5">JMail.SmtpMail<p class="exinfo">(Dimac JMail 邮件收发组件)</p></div></td><td><% if OW.isObjInstalled("JMail.SmtpMail") then support : else unSupport : end if %></td><td>建议支持</td></tr>
                        <tr><td><div class="p5">Persits.Jpeg<p class="exinfo">(ASPJpeg 图片水印)</p></div></td><td><% if OW.isObjInstalled("Persits.Jpeg") then support : else unSupport : end if %></td><td>建议支持</td>
                        </tr>
                    </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    <%
		call Admin.echoFooter()
	end function
	
	function writeableCheck()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <div class="tabbar">
            <ul>
            <li><a href="index.asp?ctl=system_check&act=infomation">系统概况</a></li>
            <li><a href="index.asp?ctl=system_check&act=com_check">系统组件检测</a></li>
            <li class="current"><a href="index.asp?ctl=system_check&act=writeable_check">文件读写检测</a></li>
            </ul>
        </div>
        <div class="wbox">
            <div class="check-section">
                <h2 class="header">服务器信息</h2>
                <div class="section">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="table table-bordered table-striped table-hover">
                <thead>
                    <tr class="thead"><th><div style="width:320px;">目录文件</div></th><th><div style="width:180px;">当前状态</div></th><th style="width:80%;"><div style="width:180px;">所需状态</div></th></tr>
                </thead>
                <tbody>
                    <tr><td>ow-content/cache/html/</td><td><% if OW.FSO.folderWriteable(OW.serverMapPath(SITE_PATH &"ow-content/cache/html/")) then writeable : else unWriteable%></td><td>可写</td></tr>
                    <tr><td>ow-content/cache/sys/</td><td><% if OW.FSO.folderWriteable(OW.serverMapPath(SITE_PATH &"ow-content/cache/sys/")) then writeable : else unWriteable%></td><td>可写</td></tr>
                    <tr><td>ow-content/cache/tpl/</td><td><% if OW.FSO.folderWriteable(OW.serverMapPath(SITE_PATH &"ow-content/cache/tpl/")) then writeable : else unWriteable%></td><td>可写</td></tr>
                    <tr><td>ow-content/data/</td><td><% if OW.FSO.folderWriteable(OW.serverMapPath(SITE_PATH &"ow-content/data/")) then writeable : else unWriteable%></td><td>可写</td></tr>
                    <tr><td>ow-content/data/backup/</td><td><% if OW.FSO.folderWriteable(OW.serverMapPath(SITE_PATH &"ow-content/data/backup/")) then writeable : else unWriteable%></td><td>可写</td></tr>
                    <tr><td>ow-content/plugins/</td><td><% if OW.FSO.folderWriteable(OW.serverMapPath(SITE_PATH &"ow-content/plugins/")) then writeable : else unWriteable%></td><td>可写</td></tr>
                    <tr><td>ow-content/templates/</td><td><% if OW.FSO.folderWriteable(OW.serverMapPath(SITE_PATH &"ow-content/templates/")) then writeable : else unWriteable%></td><td>可写</td></tr>
                    <tr><td>ow-content/uploads/</td><td><% if OW.FSO.folderWriteable(OW.serverMapPath(SITE_PATH &"ow-content/uploads/")) then writeable : else unWriteable%></td><td>可写</td></tr>
                    <tr><td>ow.config.asp</td><td><% if OW.FSO.fileWriteable(OW.serverMapPath(SITE_PATH &"ow.config.asp")) then writeable : else unWriteable%></td><td>可写</td></tr>
                </tbody>
                </table>
                </div>
            </div>
        </div>
    </div>
    <%
		call Admin.echoFooter()
	end function

end class
%>