﻿<%
'**
'站点管理
'**
dim AP_TAGS
class AP_TAGS_CLASS
	
	private aArr,oRs,iI,sString,bResult
	private addFrom,sTagsTable,sTagsDataTable
	private iIsShop
	
	private sub class_initialize()
		iIsShop = 0
		sTagsTable     = DB_PRE &"tags"
		sTagsDataTable = DB_PRE &"tags_data"
	end sub
	
	public sub init()
		if CTL="tags" then
			select case ACT
			case "list"
				if SUBACT = "get_tags_data" then
					call getTagsData()
				elseif SUBACT = "get_tags_by_id" then
					call getTagsById()
				else
					call list()
				end if
			case "add"
				addFrom = OW.getForm("both","addfrom")
				if addFrom = "content" then
					call addTagFromContent(SAVE)
				else
					call add(SAVE)
				end if
			case "edit"
				if SUBACT = "status_edit" then
					if SAVE then
						bAuxSQLValid = true
						call Admin.statusEdit(sTagsTable,"tag_id",auxSQLValid,array("成功更改Tag状态","无法更新数据库，Tag状态更改失败！"))
					end if
				elseif SUBACT = "sequence_edit" then
					if SAVE then
						bAuxSQLValid = true
						call Admin.sequenceEdit(sTagsTable,"tag_id",bAuxSQLValid,array("成功进行Tag排序","无法更新数据库，Tag排序失败！"))
					end if
				else
					call edit(SAVE)
				end if
			case "delete"
				call delete()
			end select
		end if
	end sub
	
	private sub class_terminate()
	end sub
	
	private function getInfo()
		V("tag") = OW.DB.getFieldValueBySQL("SELECT tag FROM "& sTagsTable &" WHERE tag_id="& V("tag_id") &" AND "& OW.DB.auxSQL &"")
	end function
	
	private function add(byval isSave)
		if isSave then
			call doingSave()
		end if
	end function
	
	private function edit(byval isSave)
		V("tag_id") = ID
		'**传递id是否正确
		if V("tag_id")<1 then
			call Admin.errorSetting("tag_id传递不正确"&"(tag_id: "& V("tag_id") &")"&"<br>")
			exit function
		end if
		'**判断记录是否存在
		if not(OW.DB.isRecordExistsBySQL("SELECT * FROM "& sTagsTable &" WHERE tag_id="& V("tag_id") &" AND "& OW.DB.auxSQL &"")) then
			Admin.errorSetting("Tag不存在"&"(tag_id: "& V("tag_id") &")"&"<br>")
			exit function
		end if
		'**
		if isSave then
			call doingSave()
		else
			call getInfo()
			call doing()
		end if
	end function
	
	private function delete()
		dim check : check = true
		'**接收数据
		V("ids") = OW.regReplace(OW.getForm("post","ids"),"[^0-9,]","")
		aArr     = split(V("ids"),",")
		'**
		if V("ids")="" then check = false : Admin.errorSetting("tag_id传递不正确")
		'**从数据库删除记录
		if check then
			for iI=0 to ubound(aArr)
				call deleteTag(OW.int(aArr(iI)))
			next
			'**输出操作结果信息
			Admin.actionFinishSuccess     = true
			Admin.actionFinishSuccessText = array(V("delete_action_text"),"")
			Admin.actionFinishFailText    = array(V("delete_action_text"),"")
			Admin.actionFinishRun()
		end if
	end function
	
	private function deleteTag(byval id)
		dim result : result = true
		if id<=0 then
			deleteTag = false
			exit function
		end if
		'**
		if not(OW.DB.isRecordExistsBySQL("SELECT * FROM "& sTagsTable &" WHERE tag_id="& id &" AND "& OW.DB.auxSQL &"")) then
			V("delete_action_text") = V("delete_action_text") &"Tag不存在或已被删除"&"(tag_id: "& id &")"&"<br>"
			deleteTag = false
			exit function
		end if
		'**
		V("tag") = OW.DB.getFieldValueBySQL("SELECT [tag] FROM "& sTagsTable &" WHERE tag_id="& id &" AND "& OW.DB.auxSQL &"")
		result   = OW.DB.execute("DELETE FROM "& sTagsTable &" WHERE tag_id="& id &" AND "& OW.DB.auxSQL &"")
		if result then
			call OW.DB.execute("DELETE FROM "& sTagsDataTable &" WHERE tag_id="& id &" AND "& OW.DB.auxSQL &"")
			V("delete_action_text") = V("delete_action_text") &"Tag删除成功"&"(tag_id:"& id &", tag:"& V("tag") &")"&"<br>"
		else
			V("delete_action_text") = V("delete_action_text") &"Tag删除失败"&"(tag_id:"& id &", tag:"& V("tag") &")"&"<br>"
		end if
		deleteTag = result
	end function
	
	private function doing()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <form name="save_form" id="save_form" action="?ctl=<%=CTL%>&act=<%=ACT%>&id=<%=V("tag_id")%>&save=true" method="post">
        <div class="wbox">
            <div class="inbox">
                <table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">
                <tr><td class="titletd"><i class="important">*</i>Tag</td>
                    <td class="infotd">
                    <input type="text" class="text" name="tag" maxlength="50" value="<%=V("tag")%>" />
                    <span class="t-normal ml5" name="t_tag"></span>
                    </td>
                </tr>
                </table>
            </div>
        </div>
        <div class="button-container">
            <button type="submit" class="btn btn-large btn-primary" name="submit">确定保存</button>
            <button type="reset" class="btn btn-large" name="reset">重置</button>
            <button type="button" class="btn btn-large" name="close" onClick="OW.goBack();">关闭</button>
        </div>
        </form>
    </div>
    <%
		call Admin.echoFooter()
	end function
	
	private function doingSave()
		dim check,result
		check = true
		'**接收数据
		V("tag") = OW.validDBData(OW.reps(OW.getForm("post","tag")," ",""),50)
		'**数据合法性判断
		if not Admin.validate("s",V("tag"),"minLength:1,maxLength:0","必须填写Tag") then check = false
		if ACT="add" then
			if OW.DB.isRecordExists(sTagsTable,array("tag:"& V("tag"),"is_shop:"& iIsShop),"") then check = false : Admin.errorSetting("你要添加的Tag已经存在，不需要再添加！")
		else
			if OW.DB.isRecordExistsBySQL("SELECT * FROM "& sTagsTable &" WHERE is_shop="& iIsShop &" AND tag_id<>"& V("tag_id") &" AND tag='"& V("tag") &"'") then check = false : Admin.errorSetting("Tag <b>"& V("tag") &"</b> 已经存在，请返回重新更改Tag！")
		end if
		'**数据存入数据库
		if check and Admin.errMsgCount=0 then
			if ACT="add" then
				V("sequence") = OW.int(OW.DB.getFieldValueBySQL("SELECT max(sequence) FROM "& sTagsTable &" WHERE "& OW.DB.auxSQL &"")) + 1
				'**
				bResult       = OW.DB.addRecord(sTagsTable,array("site_id:"& SITE_ID,"is_shop:"& iIsShop,"sequence:"& V("sequence"),"status:0","tag:"& V("tag"),"hits:0"))
				'**
				Admin.actionFinishSuccess     = bResult
				Admin.actionFinishSuccessText = array("成功添加Tag"&"(tag: "& V("tag") &")","")
				Admin.actionFinishFailText    = array("添加Tag失败"&"(tag: "& V("tag") &")","")
				Admin.actionFinishRun()
			elseif ACT="edit" then
				bResult = OW.DB.updateRecord(sTagsTable,array("tag:"& V("tag")),array("tag_id:"& V("tag_id")))
				Admin.actionFinishSuccess     = bResult
				Admin.actionFinishSuccessText = array("成功编辑Tag"&"(tag_id: "& V("tag_id") &", tag: "& V("tag") &")","?ctl="& CTL &"&act=list")
				Admin.actionFinishFailText    = array("编辑Tag失败"&"(tag_id: "& V("tag_id") &", tag: "& V("tag") &")","")
				Admin.actionFinishRun()
			end if
		end if
	end function
	
	private function addTagFromContent(byval isSave)
		dim dataJSON
		if isSave then
			V("tag") = OW.validDBData(OW.reps(OW.getForm("post","tag")," ",""),50)
			if V("tag")<>"" then
				if OW.DB.isRecordExists(sTagsTable,array("tag:"& V("tag")),"") then
					V("tag_id")   = OW.DB.getFieldValue(sTagsTable,"tag_id",array("tag:"& V("tag")),"")
					dataJSON      = """tag_id"":"""& V("tag_id") &""""
				else
					V("sequence") = OW.int(OW.DB.getFieldValueBySQL("SELECT max(sequence) FROM "& sTagsTable &" WHERE "& OW.DB.auxSQL &"")) + 1
					'**
					bResult       = OW.DB.addRecord(sTagsTable,array("site_id:"& SITE_ID,"is_shop:"& iIsShop,"sequence:"& V("sequence"),"status:0","tag:"& V("tag"),"hits:0"))
					V("tag_id")   = OW.DB.maxID(sTagsTable,"tag_id")
					if not(bResult) then V("tag_id")=0
					dataJSON      = """tag_id"":"""& V("tag_id") &""""
				end if
				call Admin.ajaxGetFinishRun(dataJSON)
			else
				call Admin.errorSetting("对不起，Tag不能为空！")
			end if
		end if
	end function
	
	private function getTagsData()
		dim dataJSON,s
		set oRs = OW.DB.getRecordBySQL("SELECT tag_id,tag FROM ["& sTagsTable &"] WHERE is_shop="& iIsShop &" AND status=0 AND "& OW.DB.auxSQL &" ORDER BY sequence ASC")
		do while not oRs.eof
			if s="" then
				s = "{""tag_id"":"""& oRs("tag_id") &""",""tag"":"""& OW.escape(oRs("tag")) &"""}"
			else
				s = s &",{""tag_id"":"""& oRs("tag_id") &""",""tag"":"""& OW.escape(oRs("tag")) &"""}"
			end if
			oRs.movenext
		loop
		OW.DB.closeRs oRs
		dataJSON = """tags_data"":["& s &"]"
		call Admin.ajaxGetFinishRun(dataJSON)
	end function
	
	private function getTagsById()
		dim dataJSON,s,ids
		ids = OW.regReplace(OW.getForm("post","tags_id"),"[^0-9,]","")
		set oRs = OW.DB.getRecordBySQL("SELECT tag_id,tag FROM ["& sTagsTable &"] WHERE tag_id IN ("& ids &") AND "& OW.DB.auxSQL &" ORDER BY sequence ASC")
		do while not oRs.eof
			if s="" then
				s = "{""tag_id"":"""& oRs("tag_id") &""",""tag"":"""& OW.escape(oRs("tag")) &"""}"
			else
				s = s &",{""tag_id"":"""& oRs("tag_id") &""",""tag"":"""& OW.escape(oRs("tag")) &"""}"
			end if
			oRs.movenext
		loop
		OW.DB.closeRs oRs
		dataJSON = """tags_data"":["& s &"]"
		call Admin.ajaxGetFinishRun(dataJSON)
	end function
	
	
	private function list()
		call Admin.echoHeader()
		call Admin.echoBreadcrumb()
	%>
    <div class="mbody">
        <div class="top-area">
            <table cellspacing="0" cellpadding="0" border="0">
              <tbody>
              <tr>
              <td class="do-cell">
                  <div class="do-cell-name">添加操作区</div>
                  <div class="do-cell-btn"><a class="btn btn-primary" id="add_new" href="javascript:;">添加Tag</a></div>
              </td>
              <td class="do-cell">
                  <div class="do-cell-name">删除操作区</div>
                  <div class="do-cell-btn"><button class="btn" id="delete_selected">批量删除</button></div>
              </td>
              </tr>
              </tbody>
            </table>
        </div>
        <div class="list-area" id="data_list_area">
            <table border="0" cellpadding="0" cellspacing="0" width="100%" class="listTable">
              <thead>
                  <tr class="thead">
                      <th><input type="checkbox" name="select_all" id="select_all"></th>
                      <th>id</th>
                      <th>名称</th>
                      <th>点击量</th>
                      <th>状态</th>
                      <th>排序</th>
                      <th>操作</th>
                  </tr>
              </thead>
              <tbody>
              <%=listing()%>
              </tbody>
            </table>
        </div>
    </div>
    <script type="text/javascript">
    $(window).ready(function(){
		Admin.dataListTableInit({
			ctl:"<%=CTL%>",
			act_edit:"edit",
			field_name:"tag",
			status_validValue:"正常",
			status_validTitle:"点击可设置为无效状态",
			status_invalidValue:'无效',
			status_invalidTitle:'点击可设置为正常状态',
			delete_confirm:"删除后Tag将无法恢复，您确定要删除吗？",
			delete_confirm2:"删除后Tag{tpl:name}将无法恢复，您确定要删除吗？",
			delete_doing:"正在删除Tag...",
			delete_success:"删除成功",
			delete_failed:"删除操作失败",
			delete_tip:"请先选择您要删除的Tag"
		});
		//**链接
		$("#data_list_area td[field='tag']").each(function(){
			var tag = $(this).attr("value"),
			url = "<%=OW.urlRewrite("t1")%>";
			url = url.replace("{$tag}",tag);
			$(this).html('<a href="'+url+'" target="_blank">'+tag+'</a>');
		});
		//**添加域名
		var addTagTpl = '<div class="inbox" style="width:480px;">'+
							'<table border="0" cellpadding="0" cellspacing="0" width="100%" class="infoTable">'+
							  '<tbody>'+
								'<tr><td class="titletd">填写新Tag</td>'+
									'<td class="infotd">'+
									'<input type="text" class="text" name="tag" maxlength="50" value="" />'+
									'<div><span class="t-normal" name="t_tag"></span><div>'+
									'</td>'+
								'</tr>'+
							  '</tbody>'+
							'</table>'+
						'</div>';
		$("#add_new").click(function(){
			var dialog = new OWDialog({
				id:'add_tag',
				title:'添加Tag',
				content:addTagTpl,
				padding:"10px 10px 5px 10px",
				ok:function(){
					var check = true,
					$addWindow = $("#add_tag"),
					$input = $addWindow.find("input[name='tag']"),
					$tip  = $addWindow.find("span[name='t_tag']"),
					d = $.trim($input.val());
					$input.val(d);
					if(d==""){
						check = false;
						$tip.addClass("t-err").html("请先填写Tag！").show();
						$input.focus();
					}
					if(check){
						dialog.content('<div class="loading">正在向服务器提交数据...</div>').button({id:'ok',remove:true},{id:'cancel',disabled:true}).padding("20px 40px");
						Admin.ajax({
							me:$addWindow,
							url:"index.asp?ctl=<%=CTL%>&act=add&save=true",
							data:"tag="+escape(d),
							success:function(){
								dialog.content('成功添加 <b>'+ d +'</b>').button({id:'cancel',value:'关闭',disabled:false,focus:true}).timeout(4);
								OW.refresh();
							},
							failed:function(msg){
								dialog.error('添加 <b>'+ d +'</b>失败！',msg).button({id:'cancel',remove:true}).timeout(2);
							}
						});
					};
					return false;
				},
				cancel:true,
				close:false,
				follow:$(this),
				initialize:function(){
					var $addWindow = $("#add_tag"),
					$input = $addWindow.find("input[name='tag']"),
					$tip   = $addWindow.find("span[name='t_tag']");
					$input.focus();
					$input.blur(function(){
						var data = $.trim($input.val());
						if(data == ""){
							$tip.addClass("t-err").html("请先填写Tag！").show();
							$input.focus();
						}else{
							$tip.removeClass("t-err").addClass("t-ok").html("");
						};
					});
				}
			});
		});
		//**
	});
    </script>
	<%
		call Admin.echoFooter()
	end function
	
	private function listing()
		Admin.list("fields")         = "tag_id,tag,hits,status,sequence"
		Admin.list("sql")            = "SELECT "& Admin.list("fields") &" FROM ["& sTagsTable &"] WHERE is_shop="& iIsShop &" AND "& OW.DB.auxSQL &" ORDER BY sequence"
		Admin.list("pagesize")       = Admin.getPageSise(ACTION_ID)
		Admin.list("auxURLPara")     = ""
		Admin.list("returnType")     = "html"
		Admin.list("checkboxExists") = true
		Admin.list("opeations")      = "<a class=""btn btn-small btn-primary mr5"" name=""edit"" href=""javascript:;"">编辑</a><a class=""btn btn-small"" name=""delete"" href=""javascript:;"">删除</a>"
		listing = Admin.getDataList()
	end function
end class



%>