﻿<%
'**
'站点管理
'**
dim AP_UPLOADS
class AP_UPLOADS_CLASS
	
	private folderpath,uploadFileTypes,uploadFileSizeLimit
	private aArr,oRs,sCols,sSQL,iI,iPageSize,sString,sOpeation,sURL,bResult,sTable
	private sFolderpath,sJson,sFileListType
	
	private sub class_initialize()
		sFileListType = ""
	end sub
	
	public sub init()
		V("view_type") = OW.left(OW.regReplace(OW.getForm("get","view_type"),"[^0-9a-zA-Z_]",""),30)
		sFileListType = OW.regReplace(OW.getForm("get","file_listtype"),"[^0-9a-zA-Z_]","")
		if sFileListType<>"list" and sFileListType<>"thumb" and sFileListType<>"" then
			sFileListType = "thumb"
		end if
		folderpath          = OS.uploadsRoot
		uploadFileTypes     = OW.parseForbidFileEx(OW.config("upload_file_types"))
		uploadFileSizeLimit = OW.config("upload_file_size_limit")
		'**
		'call OS.timeDelay(10)
		if CTL="uploads" then
			select case ACT
			case "list"
				sFolderpath = OW.GetForm("get","folderpath")
				select case SUBACT
				case "folderlist"
					if not OS.isValidUploadPath(sFolderpath) then
						call Admin.errorSetting("文件夹路径错误或者是您没有查看此目录文件的权限")
					else
						sJson = OW.FSO.folderList(sFolderpath,"json")
						Admin.runAuxJSON = """folderJson"":["& sJson &"]"
						Admin.actionFinishSuccess = true
						Admin.actionFinishSuccessText = array(sFolderpath,"")
						Admin.actionFinishFailText = array(sFolderpath,"")
						Admin.actionFinishRun()
					end if
				case "folderlist_and_filelist"
					if not OS.isValidUploadPath(sFolderpath) then
						call Admin.errorSetting("文件夹路径错误或者是您没有查看此目录文件的权限")
					else
						sJson = """folderJson"":["& OW.FSO.folderList(sFolderpath,"json") &","& OW.FSO.fileList(sFolderpath,"json") &",{""runtime"":"""& OW.RunTime &""",""sqlquerynum"":"""& OW.DB.SQLQueryNum &"""}]"
						Admin.runAuxJSON = sJson
						Admin.actionFinishSuccess = true
						Admin.actionFinishSuccessText = array(sFolderpath,"")
						Admin.actionFinishFailText = array(sFolderpath,"")
						Admin.actionFinishRun()
					end if
				case else
					call list()
				end select
			case "list_redundant_check"
				'冗余文件检测
				'Admin.runDisplayIsEcho = false
				'call redundantCheck()
			case "add_uploadfile"
				Admin.runDisplayIsEcho = false
				call UPLOAD_INIT()
			case "add_createfolder"
				call createFolder()
			case "edit_filerename"
				call fileRename()
			case "delete"
				call delete()
			end select
		end if
	end sub
	
	private sub class_terminate()
	end sub

	public function createFolder()
		dim check
		'**数据初始化
		check = true
		'**接收数据
		V("foldername") = OW.parseFolderName(OW.validDBData(OW.getForm("post","foldername"),50))
		V("foldername") = lcase(OW.regReplace(V("foldername"),"[^0-9a-zA-Z_-]",""))
		V("folderpath") = OW.validDBData(OW.getForm("post","folderpath"),250)
		'**数据合法性校验
		if not Admin.validate("s",V("foldername"),"minLength:1,maxLength:0","文件夹名称不能为空") then check = false
		if not Admin.validate("s",V("folderpath"),"minLength:1,maxLength:0","文件夹路径错误") then check = false
		if check=true and not OS.isValidUploadPath(V("folderpath")) then
			check = false
			call Admin.errorSetting("文件夹路径错误")
		end if
		'**保存数据
		if check and Admin.errMsgCount=0 then
			if OW.FSO.createFolder(V("folderpath") & V("foldername") &"/")<>false then
				bResult = true
			else
				bResult = false
			end if
			'输出操作结果信息
			Admin.actionFinishSuccess = bResult
			Admin.actionFinishSuccessText = array("成功新建文件夹："& V("foldername"),"")
			Admin.actionFinishFailText = array("新建文件夹失败："& V("foldername"),"")
			Admin.actionFinishRun()
		end if
	end function
	
	public function fileRename()
		dim arr,check,ex,newEx,newFileName
		'**数据初始化
		check = true
		arr   = split(OW.parseForbidFileEx(OW.config("upload_file_types")),";")
		'**接收数据
		V("new_filename") = OW.parseFolderName(OW.validDBData(OW.getForm("post","new_filename"),50))
		V("new_filename") = OW.regReplace(V("new_filename"),"[^0-9a-zA-Z._-]","")
		V("filepath")     = OW.validDBData(OW.getForm("post","filepath"),250)
		'**处理数据
		ex    = lcase(OW.getFileExName(V("filepath")))
		newEx = lcase(OW.getFileExName(V("new_filename")))
		if OW.isNul(newEx) then
			newFileName = V("new_filename")
		else
			newFileName = OW.getFileName(V("new_filename"),false)
		end if
		'**数据合法性校验
		if not Admin.validate("s",V("new_filename"),"minLength:1,maxLength:0","新文件名不能为空") then check = false
		if not Admin.validate("s",V("filepath"),"minLength:1,maxLength:0","文件夹路径错误") then check = false
		if check and not OS.isValidUploadPath(V("filepath")) then
			check = false
			call Admin.errorSetting("文件夹路径错误")
		end if
		if not(OW.FSO.fileExists(V("filepath"))) then
			check = false
			call Admin.errorSetting("文件"& V("filepath") &"不存在")
		end if
		if check then
			if OW.isNul(newEx) then
				V("new_filename") = V("new_filename") &"."& ex
			else
				if ex<>newEx and not(OW.isInArray(arr,"*."& newEx)) then
					check = false
					call Admin.errorSetting("不可以将后缀名改为"& newEx &"")
				end if
			end if
		end if
		if check and OW.FSO.fileExists(OW.getFolderPath(V("filepath")) & V("new_filename")) then
			check = false
			call Admin.errorSetting("文件 "& V("new_filename") &" 已经存在")
		end if
		'**保存数据
		if check and Admin.errMsgCount=0 then
			if OW.FSO.fileRename(V("filepath"),V("new_filename")) then
				bResult = true
			else
				bResult = false
			end if
			'输出操作结果信息
			Admin.actionFinishSuccess     = bResult
			Admin.actionFinishSuccessText = array("成功重命名文件："& V("filepath") &" > "& V("new_filename") &"","")
			Admin.actionFinishFailText    = array("重命名文件失败："& V("filepath") &" > "& V("new_filename") &"","")
			Admin.actionFinishRun()
		end if
	end function
	
	public function redundantCheck()
		echo redundantFoldersAndFiles()
	end function
	
	'获取冗余文件夹和文件列表
	Public function RedundantFoldersAndFiles()
		Dim Fn_FolderPath
		Fn_FolderPath = OpenWBS.GetForm("get","folderpath")
		if not OS.isValidUploadPath(Fn_FolderPath) then
			RedundantFoldersAndFiles = "{""error"":""true"",""error_message"":""folderpath_error""}"
		end if
		RedundantFoldersAndFiles = "["& RedundantFolders(Fn_FolderPath) &","& RedundantFiles(Fn_FolderPath) &",{""runtime"":"""& OpenWBS.RunTime &"""}]"
	end function
	
	'获取冗余文件夹列表
	Public function RedundantFolders(ByVal BV_FolderPath)
		Dim Fn_FSO,Fn_Folder,Fn_SubFolder,Fn_FolderPath,Fn_Json,Fn_html,Fn_Temp

		Fn_FolderPath = OpenWBS.Data.FolderPath(BV_FolderPath)

		Set Fn_FSO = OpenWBS.FSO.ObjectFSO
		if Fn_FSO.FolderExists(OW.serverMapPath(SystemPath & Fn_FolderPath))=False then
			RedundantFolders = "{""foldername"":"""& OpenWBS.Data.FolderName(Fn_FolderPath) &""",""size"":""0"",""datetime"":"""",""folderpath"":"""& Fn_FolderPath &""",""subfolderscount"":""0"",""subfolders"":[],""folderexists"":""false""}"
			Exit function
		end if

		Set Fn_Folder=Fn_FSO.GetFolder(OW.serverMapPath(SystemPath & Fn_FolderPath))
		For Each Fn_SubFolder in Fn_Folder.SubFolders
			if (Fn_SubFolder.SubFolders.Count + Fn_SubFolder.Files.Count) = 0 then
			'如果文件夹为空，则可以判定为冗余文件夹
				Fn_Temp = "{""foldername"":"""& Fn_SubFolder.name &""",""size"":"""& OpenWBS.Data.FormatSize(Fn_SubFolder.Size) &""",""datetime"":"""& Fn_SubFolder.datelastmodified &""",""folderpath"":"""& Fn_FolderPath & Fn_SubFolder.name &""",""subfolderscount"":"""& Fn_SubFolder.SubFolders.Count &""",""subfolders"":[],""folderexists"":""true""}"
				if Fn_Json="" then
					Fn_Json = Fn_Temp
				Else
					Fn_Json = Fn_Json &","& Fn_Temp
				end if
			Else
				if Fn_SubFolder.SubFolders.Count>0 then
					Fn_Temp = SubRedundantFolders(Fn_FolderPath & Fn_SubFolder.name)
					if Fn_Temp<>"" then
						if Fn_Json="" then
							Fn_Json = Fn_Temp
						Else
							Fn_Json = Fn_Json &","& Fn_Temp
						end if
					end if
				end if
			end if
		Next
		Fn_Json = "{""foldername"":"""& OpenWBS.Data.FolderName(Fn_FolderPath) &""",""size"":"""& OpenWBS.Data.FormatSize(Fn_Folder.Size) &""",""datetime"":"""& Fn_Folder.datelastmodified &""",""folderpath"":"""& Fn_FolderPath &""",""subfolderscount"":"""& Fn_Folder.SubFolders.Count &""",""subfolders"":["& Fn_Json &"],""folderexists"":""true""}"
		
		Set Fn_Folder = Nothing
		Set Fn_FSO    = Nothing
		
		RedundantFolders = Fn_Json
	end function
	
	'循环获取冗余子文件夹
	Public function SubRedundantFolders(ByVal BV_FolderPath)
		Dim Fn_FSO,Fn_Folder,Fn_SubFolder,Fn_FolderPath,Fn_Json,Fn_html,Fn_Temp
		Fn_FolderPath = OpenWBS.Data.FolderPath(BV_FolderPath)
		Set Fn_FSO = OpenWBS.FSO.ObjectFSO
		Set Fn_Folder=Fn_FSO.GetFolder(OW.serverMapPath(SystemPath & Fn_FolderPath))
		For Each Fn_SubFolder in Fn_Folder.SubFolders
			if (Fn_SubFolder.SubFolders.Count + Fn_SubFolder.Files.Count) = 0 then
				Fn_Temp = "{""foldername"":"""& Fn_SubFolder.name &""",""size"":"""& OpenWBS.Data.FormatSize(Fn_SubFolder.Size) &""",""datetime"":"""& Fn_SubFolder.datelastmodified &""",""folderpath"":"""& Fn_FolderPath & Fn_SubFolder.name &""",""subfolderscount"":"""& Fn_SubFolder.SubFolders.Count &""",""subfolders"":[],""folderexists"":""true""}"
				if Fn_Json="" then
					Fn_Json = Fn_Temp
				Else
					Fn_Json = Fn_Json &","& Fn_Temp
				end if
			Else
				if Fn_SubFolder.SubFolders.Count>0 then
					Fn_Temp = SubRedundantFolders(Fn_FolderPath & Fn_SubFolder.name)
					if Fn_Temp<>"" then
						if Fn_Json="" then
							Fn_Json = Fn_Temp
						Else
							Fn_Json = Fn_Json &","& Fn_Temp
						end if
					end if
				end if
			end if
		Next
		Set Fn_Folder = Nothing
		Set Fn_FSO    = Nothing
		SubRedundantFolders = Fn_Json
	end function
	
	'获取冗余文件列表
	Public function RedundantFiles(BV_FolderPath)
		Dim Fn_FSO,Fn_File,Fn_Folder,Fn_FolderPath,Fn_SubFolder,Fn_Json,Fn_html,Fn_Temp

		Fn_FolderPath = OpenWBS.Data.FolderPath(BV_FolderPath)

		Set Fn_FSO = OpenWBS.FSO.ObjectFSO
		if Fn_FSO.FolderExists(OW.serverMapPath(SystemPath & Fn_FolderPath))=False then
			RedundantFiles = "{""foldername"":"""& OpenWBS.Data.FolderName(Fn_FolderPath) &""",""size"":""0"",""datetime"":"""",""folderpath"":"""& Fn_FolderPath &""",""filecount"":""0"",""files"":[],""folderexists"":""false""}"
			Exit function
		end if
		Set Fn_Folder=Fn_FSO.GetFolder(OW.serverMapPath(SystemPath & Fn_FolderPath))
		For Each Fn_File in Fn_Folder.Files
			if IsRedundantFile(Fn_FolderPath & Fn_File.name) then
				Fn_Temp = "{""filename"":"""& Fn_File.name &""",""size"":"""& OpenWBS.Data.FormatSize(Fn_File.Size) &""",""datetime"":"""& Fn_File.datelastmodified &""",""filepath"":"""& Fn_FolderPath & Fn_File.name &"""}"
				if Fn_Json = "" then
					Fn_Json = Fn_Temp
				Else
					Fn_Json = Fn_Json &","& Fn_Temp
				end if
			end if
		Next
		if Fn_Folder.SubFolders.Count>0 then
			For Each Fn_SubFolder in Fn_Folder.SubFolders
				Fn_Temp = SubFolderRedundantFiles(Fn_FolderPath & Fn_SubFolder.name)
				if Fn_Temp<>"" then
					if Fn_Json = "" then
						Fn_Json = Fn_Temp
					Else
						Fn_Json = Fn_Json &","& Fn_Temp
					end if
				end if
			Next
		end if
		Fn_Json = "{""foldername"":"""& OpenWBS.Data.FolderName(Fn_FolderPath) &""",""size"":"""& OpenWBS.Data.FormatSize(Fn_Folder.Size) &""",""datetime"":"""& Fn_Folder.datelastmodified &""",""folderpath"":"""& Fn_FolderPath &""",""filecount"":"""& Fn_Folder.Files.Count &""",""files"":["& Fn_Json &"]}"
		
		Set Fn_Folder = Nothing
		Set Fn_FSO    = Nothing

		RedundantFiles = Fn_Json
	end function
	
	'循环获取[子文件夹]冗余文件列表
	Public function SubFolderRedundantFiles(BV_FolderPath)
		Dim Fn_FSO,Fn_File,Fn_Folder,Fn_FolderPath,Fn_SubFolder,Fn_Json,Fn_html,Fn_Temp
		Fn_FolderPath = OpenWBS.Data.FolderPath(BV_FolderPath)
		Set Fn_FSO = OpenWBS.FSO.ObjectFSO
		Set Fn_Folder=Fn_FSO.GetFolder(OW.serverMapPath(SystemPath & Fn_FolderPath))
		For Each Fn_File in Fn_Folder.Files
			if IsRedundantFile(Fn_FolderPath & Fn_File.name) then
				Fn_Temp = "{""filename"":"""& Fn_File.name &""",""size"":"""& OpenWBS.Data.FormatSize(Fn_File.Size) &""",""datetime"":"""& Fn_File.datelastmodified &""",""filepath"":"""& Fn_FolderPath & Fn_File.name &"""}"
				if Fn_Json = "" then
					Fn_Json = Fn_Temp
				Else
					Fn_Json = Fn_Json &","& Fn_Temp
				end if
			end if
		Next
		if Fn_Folder.SubFolders.Count>0 then
			For Each Fn_SubFolder in Fn_Folder.SubFolders
				Fn_Temp = SubFolderRedundantFiles(Fn_FolderPath & Fn_SubFolder.name)
				if Fn_Temp<>"" then
					if Fn_Json = "" then
						Fn_Json = Fn_Temp
					Else
						Fn_Json = Fn_Json &","& Fn_Temp
					end if
				end if
			Next
		end if
		Set Fn_Folder = Nothing
		Set Fn_FSO    = Nothing
		SubFolderRedundantFiles = Fn_Json
	end function
	
	'获取需要检测冗余文件的数据库表
	Public function GetRedundFilesDBTable()
		Dim Fn_ii,Fn_Rs,Fn_TableStr,Fn_TableArray,Fn_Temp
		if CloseModuleShop<>1 then
			Fn_TableStr = "Goods,GoodsClass,GoodsVirtualClass,Delivery,DeliveryCorp,Payments,Brand,"
		end if
		if CloseModuleVote<>1 then
			Fn_TableStr = Fn_TableStr &"VoteClass,"
		end if
		Fn_TableStr = Fn_TableStr &"CModule,Link,CollectionResult,Ads_Detail,MailTemplate,Members"
		Fn_Temp     = ""
		Set Fn_Rs = OpenWBS.DB.GetRecordBySQL("SELECT System FROM ["& DBTable_ContentSubSystem &"] ORDER BY Orders ASC")
        Do While Not(Fn_Rs.Eof)
			if Fn_Temp = "" then
				Fn_Temp = "Content_"& Fn_Rs(0) &","& "Content_"& Fn_Rs(0) &"_Class"
			Else
				Fn_Temp = Fn_Temp &",Content_"& Fn_Rs(0) &","& "Content_"& Fn_Rs(0) &"_Class"
			end if
		Fn_Rs.Movenext()
        Loop
        OpenWBS.DB.CloseRs Fn_Rs
		if Fn_Temp<>"" then
			Fn_TableStr = Fn_Temp &","& Fn_TableStr
		end if
		
		'获取所有可遍历的字段
		Fn_TableArray = Split(Fn_TableStr,",")
		Fn_TableStr   = ""
		For Fn_ii=0 To Ubound(Fn_TableArray)
			Fn_Temp = Fn_TableArray(Fn_ii) &"|"& GetCheckRedundFields(TablePre & Fn_TableArray(Fn_ii))
			if Fn_TableStr = "" then
				Fn_TableStr = Fn_Temp
			Else
				Fn_TableStr = Fn_TableStr &","& Fn_Temp
			end if
		Next
		Pv_RedundDBTableArray = Split(Fn_TableStr,",")
		ReDim Pv_CheckRedundSQL(Ubound(Pv_RedundDBTableArray))
	end function
	
	'获取需要检测冗余文件的数据库表字段
	Public function GetCheckRedundFields(BV_DBTable)
		Dim Fn_Rs,Fn_ii,Fn_FieldType,Fn_FieldName,Fn_Result
		Set Fn_Rs = OpenWBS.DB.GetRecordBySQL("SELECT * FROM ["& BV_DBTable &"]")
		For Fn_ii=0 To Fn_Rs.Fields.Count-1 
			Fn_FieldType = Fn_Rs.Fields(Fn_ii).Type
			Fn_FieldName = Fn_Rs.Fields(Fn_ii).Name
			Select Case Fn_FieldType
			Case 129,200,201,130,202,203,8,133,134
				if Fn_Result="" then
					Fn_Result = Fn_FieldName
				Else
					Fn_Result = Fn_Result &":"& Fn_FieldName
				end if
			end Select
		Next
		OpenWBS.DB.CloseRs Fn_Rs
		GetCheckRedundFields = Fn_Result
	end function
	
	Public function CreateCheckRedundSQL()
		Dim Fn_ii,Fn_jj,Fn_Rs,Fn_SQL,Fn_Conditon,Fn_Array,Fn_DBTable,Fn_TableArray,Fn_Filed,Fn_FiledArray

		if Not(IsArray(Pv_RedundDBTableArray)) then
			call GetRedundFilesDBTable()
		end if
		Fn_TableArray = Pv_RedundDBTableArray
		For Fn_ii=0 To Ubound(Fn_TableArray)
			Fn_Array      = Split(Fn_TableArray(Fn_ii),"|")
			Fn_DBTable    = TablePre & Fn_Array(0)
			Fn_FiledArray = Split(Fn_Array(1),":")
			Fn_Conditon   = ""
			For Fn_jj=0 To Ubound(Fn_FiledArray)
				Fn_Filed    = Trim(Fn_FiledArray(Fn_jj))
				if Fn_Filed<>"" then
					if Fn_Conditon = "" then
						Fn_Conditon = " ["& Fn_Filed &"] LIKE '%{tpl:filepath}%' Or ["& Fn_Filed &"] LIKE '%{tpl:filepathencode}%' "
					Else
						Fn_Conditon = Fn_Conditon &" OR ["& Fn_Filed &"] LIKE '%{tpl:filepath}%' Or ["& Fn_Filed &"] LIKE '%{tpl:filepathencode}%' "
					end if
				end if
			Next
			'生成SQL语句
			Fn_SQL = "SELECT ID FROM ["& Fn_DBTable &"] WHERE "& Fn_Conditon &" ORDER BY ID ASC"
			Pv_CheckRedundSQL(Fn_ii) = Fn_SQL
		Next
	end function
	
	public function delete()
		dim check
		dim json,i,result,s,folderPath,filePath,foldersJson,filesJson
		'**数据初始化
		check = true
		'**接收数据
		V("jsondata") = OW.getForm("post","jsondata")
		'**数据合法性校验
		if not Admin.validate("s",V("jsondata"),"minLength:1,maxLength:0","传递到服务器的json数据错误") then check = false
		'**保存数据
		if check and Admin.errMsgCount=0 then
			set json = OW.JSON.parse(V("jsondata"))
			'**删除文件夹
			for i=0 to json.folders.length-1
				folderPath = json.folders.get(i).folderpath
				if OS.isValidUploadPath(folderPath) then
					result = OW.FSO.deleteFolder(OW.FSO.ABSPath(folderPath))
					if result then
						s = s &"成功删除文件夹{"& folderPath &"}<br>"
					else
						s = s &"删除文件夹失败{"& folderPath &"}<br>"
					end if
					result = OW.iif(result,"true","false")
					if foldersJson = "" then
						foldersJson = "{""folderpath"":"""& folderPath &""",""delete_result"":"""& result &"""}"
					else
						foldersJson = foldersJson &",{""folderpath"":"""& folderPath &""",""delete_result"":"""& result &"""}"
					end if
				end if
			next
			'**删除文件
			for i=0 to json.files.length-1
				filePath = json.files.get(i).filepath
				if OS.isValidUploadPath(filePath) then
					result = OW.FSO.DeleteFile(OW.FSO.ABSPath(filePath))
					if result then
						s = s &"成功删除文件{"& filePath &"}<br>"
					else
						s = s &"删除文件失败{"& filePath &"}<br>"
					end if
					result = OW.iif(result,"true","false")
					if filesJson = "" then
						filesJson = "{""filepath"":"""& filePath &""",""delete_result"":"""& result &"""}"
					else
						filesJson = filesJson &",{""filepath"":"""& filePath &""",""delete_result"":"""& result &"""}"
					end if
				end if
			next
			sJson = """auxJson"":[{""folders"":["& foldersJson &"],""files"":["& filesJson &"]}]"
			'输出操作结果信息
			Admin.runAuxJSON = sJson
			Admin.actionFinishSuccess = true
			Admin.actionFinishSuccessText = array(s,"")
			Admin.actionFinishFailText = array(s,"")
			Admin.actionFinishRun()
		end if
	end function
	

	function list()
		call Admin.echoHeader()
		if V("view_type")<>"dialog" then
			call Admin.echoBreadcrumb()
		end if
	%>
    <link rel="stylesheet" href="css/ow.filemanage.css" />
    <script type="text/javascript" src="js/ow.filemanage.js"></script>
    <script type="text/javascript" src="js/upload/swfupload.js"></script>
    <script type="text/javascript" src="js/upload/swfupload.handler.js"></script>
    <div class="mbody">
        <div class="tabbar" style="display:none;">
            <ul>
            <li tab="1" class="current"><a href="index.asp?ctl=<%=CTL%>&act=add">文件浏览器</a></li>
            <li tab="2"><a href="index.asp?ctl=<%=CTL%>&act=list">上传文件</a></li>
            </ul>
        </div>
        <div class="filemanage_body">
            <div class="filemanage clear" id="filemanage">
            <form>
                <table border="0" cellpadding="0" cellspacing="0" width="100%"><tr>
                <td class="asider">
                <div class="foldertree" id="folder_tree">
                </div>
                </td>
                <td class="section">
                <div class="container" id="file_container">
                    <div class="dirpath" id="dir_path"></div>
                    <div class="menuline" id="menu_line"><ul class="listtype" id="listtype"><li listtype="list"><a href="javascript:;" class="list"></a></li><li listtype="thumb"><a href="javascript:;" class="thumb"></a></li></ul><span class="hide" id="selectall-box"></span>
                    <%
					call Admin.actionMenuPrint(Array(CTL,"add_uploadfile"),"<button type=""button"" class=""f-btn f-btn-upload"" id=""upload-file""><span></span>上传文件/ 图片</button>")
					call Admin.actionMenuPrint(Array(CTL,"add_createfolder"),"<button type=""button"" class=""f-btn"" id=""create-new-folder""><span></span>新建文件夹</button>")
					call Admin.actionMenuPrint(Array(CTL,"delete"),"<button type=""button"" class=""f-btn"" id=""delete""><span></span>删除</button>")
					call Admin.actionMenuPrint(Array(CTL,"list_redundant_check"),"<button type=""button"" class=""f-btn f-btn-filecheck"" id=""redundant-check"" style=""display:none;""><span></span>冗余文件检测</button>")
                    %>
                    </div>
                    <div class="upload-grid" id="upload_area" style="display:none;"></div>
                    <div class="operationtip" id="operation_tip"></div>
                    <div class="filelist" id="file_list"></div>
                    <div class="pages" id="file_pages"></div>
                </div>
                </td>
                <td class="rsider" style="display:none;">
                <div class="selected-grid">
                </div>
                </td>
                </tr>
                </table>
            </form>
            </div>
			<script type="text/javascript">
			//**upload
			//**
			var swfu,Files=[];
			var uploadInitString = '{'+
				'upload_url:"index.asp?ctl=uploads&act=add_uploadfile&savepath={tpl:savepath}&admin_uid=<%=ADMIN_UID%>&admin_uss_key=<%=ADMIN_USS_KEY%>",'+
				'file_post_name:"filedata",'+
				'button_append:"add_files",'+
				'bind_id:"upload_files_grid",'+
				'file_types:"<%=uploadFileTypes%>",'+
				'file_types_description:"选择文件...",'+
				'file_size_limit:"<%=uploadFileSizeLimit * 1024 *1024%>",'+
				'file_upload_limit:20,'+
				'button_width:94,'+
				'button_height:28,'+
				'button_image_url:"images/upload-select-file.png",'+
				'auto:false,'+
				'debug:Admin.debug'+
				'}';
			//**上传初始化
			function uploadInit(opt){
				var savepath = opt.savepath;
				var conf = uploadInitString.replace('{tpl:savepath}',savepath);
				var html = 
				'<div class="upload-file" id="upload">'+
				   '<div class="upload-buttons">'+
					  '<button type="button" class="btn" onClick="$(\'#upload_area\').hide(\'fast\')" style="float:right;">隐藏</button>'+
                      '<span class="upload-select-file" id="add_files" style="margin-right:3px;">加载中...</span>'+
                      '<button type="button" class="btn btn-primary" onClick="swfu.startUploadFiles();" id="doupload" style="margin-right:15px;">开始上传</button>'+
                      '<button type="button" class="btn" onClick="swfu.stopUpload();" id="dostop"  style="margin-right:5px;">停止</button>'+
                      '<button type="button" class="btn" onClick="$(\'#upload_files_grid\').html(\'\')">清除</button>'+
                      '<span class="message" id="upload_message"></span>'+
                   '</div>'+
                   '<div class="upload-files-grid" id="upload_files_grid"></div>'+
                '<div id="upload_result"></div>'+
                '</div>';
				$("#upload_area").html(html);
				eval('uploadIniting('+ conf +')');
			};
			function uploadIniting(conf){
				swfu = HandlerInit(conf);
			};
			//**文件上传成功后调用的函数
			function UploadSucceedCallBack(file){
				$("span.newname[filename='"+file.name+"']").html(file.newname);
				var notUploadCount = $("#upload_files_grid").find(".the-file[upload_status='readying']").length;
				//alert("notUploadCount:"+notUploadCount);
				if(notUploadCount==0){
					fileManage.folderAndFilesReload({folderpath:$("#dir_path").attr("folderpath")});
				};
			};
			//**上传前执行的函数
			function BeforeUploadCallBack(file){
			};
			
			//**filemanage
			var fileManage;
            var folderJsonData = '<%=OW.FSO.folderList(folderpath,"json")%>';
			var folderAndfileJsonData = '['+folderJsonData+',<%=OW.FSO.fileList(folderpath,"json")%>,{"runtime":"<%=OW.RunTime%>"}]';
			var listType = '<%=sFileListType%>';
            $(document).ready(function(){
				fileManage = OWFileManage({
					ctl:'<%=CTL%>',
					root:'list',
					listType:listType,
					folderTreeID:'folder_tree',//树型文件夹区
					fileContainerID:'file_container',//文件列表区
					dirPathID:'dir_path',
					menuLineID:'menu_line',
					operationTipID:'operation_tip',
					fileListID:'file_list',
					filePagesID:'file_pages',
					listTypeID:'listtype',
					folderAndFilesAppendCallBack:'uploadInit({savepath:json[0].folderpath})'
				});
				fileManage.listType({def:listType});
				fileManage.treeFoldersAppend({treeInit:true,jsonData:$.parseJSON(folderJsonData)});
				fileManage.folderAndFilesAppend({treeInit:true,jsonData:$.parseJSON(folderAndfileJsonData)});
				
				
				var $uploadFile = $("#upload-file");
				var $createNewFolder = $("#create-new-folder");
				var $delete = $("#delete");
				var $redundantCheck = $("#redundant-check");
				
				//**上传
				$uploadFile.click(function(){
					fileManage.uploadFile({upload_area:$("#upload_area")});
				});
				//**新建文件夹
				$createNewFolder.click(function(){
					fileManage.createNewFolder();
				});
				//**删除
				$delete.click(function(){
					fileManage.del({me:$(this)});
				});
				//**冗余检测
				$redundantCheck.click(function(){
					fileManage.redundantCheck();
				});
            });
			</script>
      </div>
    </div>
    <%
		call Admin.echoFooter()
	end function

end class

public function UPLOAD_INIT()
		
	Dim Upload,file,savePath
	set Upload = new MoLibUpload
	'**
	savePath = OW.parseFolderPath(OW.getForm("get","savepath"))
	if not OS.isValidUploadPath(savePath) then savePath = OS.uploadsRoot
	'**
	Upload.AllowMaxSize     = OW.config("upload_file_size_limit") &"mb"
	Upload.AllowMaxFileSize = OW.config("upload_file_size_limit") * 10 &"mb"
	Upload.AllowFileTypes   = OW.parseForbidFileEx(OW.config("upload_file_types"))
	Upload.Charset          = SYS_CHARSET
	'**
	if not Upload.GetData() then
		response.Write("{err:true,msg:'" & Upload.Description & "'}")
		Admin.logText = "试图上传文件失败："& savePath &"："& Upload.Description &""
		Admin.logSave()
	else
		Upload.SavePath = SITE_PATH & savePath
		set file = Upload.files("filedata")
		if Upload.Save(file,0,true).Succeed then
			if OW.config("wartermark")=1 then
				if OW.isImage(file.filename) then
					call OW.FSO.addWatermark(SITE_PATH & savePath & file.filename)
				end if
			end if
			response.Write("{err:false,msg:'upload',name:'" & file.filename & "',src:'" & file.LocalName & "'}")
			Admin.logText  = "成功上传文件 "& file.LocalName &" > "& savePath & file.filename
			Admin.logSave()
		else
			response.Write("{err:true,msg:'" & file.Exception & "'}")
			Admin.logText  = "试图上传文件 "& file.filename &" 失败"
			Admin.logSave()
		end if
		set file=nothing
	end if
	set Upload=nothing
end function

'=========================================================
 'Class: MoLibUpload
 'Author: Anlige
 'Version:MoLibUpload V1.1
 'CreationDate: 2008-04-12
 'ModificationDate: 2014-01-06
 'Homepage: http://dev.mo.cn
 'Email: zhanghuiguoanlige@126.com
'=========================================================
Class MoLibUpload
	Private Form, Fils,StreamT,mvarClsName, mvarClsDescription,mvarSavePath,mvarCheckImageFormat
	Private vCharSet, vMaxSize, vSingleSize, vErr, vVersion, vTotalSize, vExe, vErrExe,vboundary, vLostTime, vFileCount,StreamOpened
	private vMuti,vServerVersion,mvarDescription
	
	Public Property Let AllowMaxSize(ByVal value)
		vMaxSize = value
	End Property
	
	Public Property Let AllowMaxFileSize(ByVal value)
		vSingleSize = value
	End Property
	
	Public Property Let AllowFileTypes(ByVal value)
		vExe = LCase(value)
		vExe = replace(vExe,"*.","")
		vExe = replace(vExe,";","|")
	End Property
	
	Public Property Let CheckImageFormat(byval value)
		mvarCheckImageFormat = value
	End Property
	Public Property Let CharSet(ByVal value)
		vCharSet = value
	End Property
	
	Public Property Let SavePath(ByVal value)
		mvarSavePath = value
	End Property
	
	Public Property Get FileCount()
		FileCount = Fils.count
	End Property
	
	Public Property Get Description()
		Description = mvarDescription
	End Property
	
	Public Property Get Version()
		Version = vVersion
	End Property
	
	Public Property Get TotalSize()
		TotalSize = vTotalSize
	End Property
	
	Public Property Get LostTime()
		LostTime = vLostTime
	End Property
	
	Private Sub Class_Initialize()
		Dim T__
		Set Form = Server.CreateObject("Scripting.Dictionary")
		Set Fils = Server.CreateObject("Scripting.Dictionary")
		Set StreamT = Server.CreateObject("Adodb.stream")
		vVersion = "MoLibUpload V1.1"
		vMaxSize = -1
		vSingleSize = -1
		vErr = -1
		vExe = ""
		vTotalSize = 0
		vCharSet = "gb2312"
		StreamOpened=false
		vMuti="_" & Getname() & "_"
		mvarCheckImageFormat = false
		vServerVersion = 6.0
		T__ = lcase(Request.ServerVariables("SERVER_SOFTWARE"))
		T__ = replace(T__,"microsoft-iis/","")
		if isnumeric(T__) then vServerVersion = cdbl(T__)
		mvarClsName = "MoLibFileExtern_"+Getname()
		mvarClsDescription="Class {ClsName}\nPublic ContentType,Size,UserSetName,Path,Position,FormName,TempFormName, NewName,FileName,LocalName,IsFile,Extend,Succeed,Exception,Width,Height,IsImage\nEnd Class"
		mvarClsDescription = Replace(mvarClsDescription,"{ClsName}",mvarClsName)
		mvarClsDescription = Replace(mvarClsDescription,"\n",vbcrlf)
		ExecuteGlobal mvarClsDescription
	End Sub
	
	Private Sub Class_Terminate()
		Dim f
		Form.RemoveAll()
		For each f in Fils
			Set Fils(f) = Nothing
		Next
		Fils.RemoveAll()
		Set Form = Nothing
		Set Fils = Nothing
		if StreamOpened then StreamT.close()
		Set StreamT = Nothing
	End Sub
	
	Private Function ParseSizeLimit(byval SizeLimit)
		dim unit,value,multiplier,limit
		If Not isnumeric(SizeLimit) Then
			multiplier = 1
			SizeLimit = ReplaceEx(lcase(SizeLimit),"\s","")
			value = replaceex(SizeLimit,"[^\d]+","")
			if isnumeric(value) then
				value = clng(value)
				if right(SizeLimit,2)="gb" then multiplier = 1073741824
				if right(SizeLimit,2)="mb" then multiplier = 1048576
				if right(SizeLimit,2)="kb" then multiplier = 1024
				limit = value * multiplier
			else
				limit=-1
			end if
		else
			limit = SizeLimit
		End If	
		if limit<-1 then limit=-1
		ParseSizeLimit = limit
	End Function
		
	Public function GetData()
		GetData =false
		vMaxSize = ParseSizeLimit(vMaxSize)
		vSingleSize = ParseSizeLimit(vSingleSize)
		Dim time1
		time1 = timer()
		Dim value, str, bcrlf, fpos, sSplit, slen, istart,ef
		Dim TotalBytes,tempdata,BytesRead,ChunkReadSize,PartSize,DataPart,formend, formhead, startpos, endpos, formname, FileName, fileExe, valueend, NewName,localname,type_1,contentType
		TotalBytes = Request.TotalBytes
		ef = false
		If checkEntryType = false Then ef = true : mvarDescription = "ERROR_INVALID_ENCTYPEOR_METHOD"
		If vServerVersion>=6 Then
			If Not ef Then
				If vMaxSize > 0 And TotalBytes > vMaxSize Then ef = true : mvarDescription = "ERROR_FILE_EXCEEDS_MAXSIZE_LIMIT"
			End If
		End If
		If ef Then Exit function
		vTotalSize = 0 
		StreamT.Type = 1
		StreamT.Mode = 3
		StreamT.Open
		StreamOpened = true
		BytesRead = 0
		ChunkReadSize = 1024 * 16
		Do While BytesRead < TotalBytes
			PartSize = ChunkReadSize
			If PartSize + BytesRead > TotalBytes Then PartSize = TotalBytes - BytesRead
			DataPart = Request.BinaryRead(PartSize)
			StreamT.Write DataPart
			BytesRead = BytesRead + PartSize
		Loop
		StreamT.Position = 0
		tempdata = StreamT.Read
		bcrlf = ChrB(13) & ChrB(10)
		fpos = InStrB(1, tempdata, bcrlf)
        sSplit = MidB(tempdata, 1, fpos - 1)
		slen = LenB(sSplit)
		istart = slen + 2
        Do
            formend = InStrB(istart, tempdata, bcrlf & bcrlf)
            if formend<=0 then exit do
            formhead = MidB(tempdata, istart, formend - istart)
            str = Bytes2Str(formhead)
            startpos = InStr(str, "name=""") + 6
            if startpos<=0 then exit do
            endpos = InStr(startpos, str, """")
            if endpos<=0 then exit do
            formname = LCase(Mid(str, startpos, endpos - startpos))
            valueend = InStrB(formend + 3, tempdata, sSplit)
            if valueend<=0 then exit do
			If InStr(str, "filename=""") > 0 Then
				formname = formname & vMuti & "0"
				startpos = InStr(str, "filename=""") + 10
				endpos = InStr(startpos, str, """")
				type_1=instr(endpos,lcase(str),"content-type")
				contentType=lcase(trim(mid(str,type_1+13)))
				FileName = Mid(str, startpos, endpos - startpos)
				If Trim(FileName) <> "" Then
					FileName = Replace(FileName, "/", "\")
					FileName = Replace(FileName, chr(0), "")
					LocalName = FileName
					FileName = Mid(FileName, InStrRev(FileName, "\") + 1)
					If instr(FileName,".")>0 Then
						fileExe = Split(FileName, ".")(UBound(Split(FileName, ".")))
					else
						fileExe = ""
					End If
					If vExe <> "" Then
						If checkExe(fileExe) = True Then
							mvarDescription = "ERROR_INVALID_FILETYPE(." & ucase(fileExe) & ")"
							vErrExe = fileExe
							tempdata = empty
							Exit function
						End If
					End If
					NewName = Getname()
					vTotalSize = vTotalSize + valueend - formend - 6
					If vSingleSize > 0 And (valueend - formend - 6) > vSingleSize Then
						mvarDescription = "ERROR_FILE_EXCEEDS_SIZE_LIMIT"
						tempdata = empty
						Exit function
					End If
					If vMaxSize > 0 And vTotalSize > vMaxSize Then
						mvarDescription = "ERROR_FILE_EXCEEDS_MAXSIZE_LIMIT"
						tempdata = empty
						Exit function
					End If
					If Fils.Exists(formname) Then formname = GetNextFormName(formname)
					fileExe = lcase(fileExe)
					fileExe = replace(fileExe,";","")
					Dim fileCls:set fileCls= NewFile()
					fileCls.ContentType=contentType
					fileCls.Size= (valueend - formend - 6)
					fileCls.Position = (formend + 3)
					fileCls.FormName = mid(formname,instr(formname,vMuti)-1)
					fileCls.TempFormName = formname
					fileCls.NewName = NewName & "." & fileExe
					fileCls.FileName = FileName
					fileCls.LocalName = FileName
					fileCls.IsFile = true
					fileCls.IsImage = false
					fileCls.Extend=fileExe
					if mvarCheckImageFormat=true then
						if Instr(",image/jpeg,image/pjpeg,image/jpg,image/gif,image/png,image/bmp,application/x-shockwave-flash,","," & contentType & ",")>0 or Instr(",jpg,jpeg,pjpeg,bmp,png,gif,swf,","," & fileExe & ",")>0 then
							fileCls.IsImage = IsImage(fileCls)
							if fileCls.IsImage then fileCls.NewName = NewName & "." & fileCls.Extend
						end if
					end if
					Fils.Add formname, fileCls
				End If
			Else
				value = MidB(tempdata, formend + 4, valueend - formend - 6)
				If Form.Exists(formname) Then
					Form(formname) = Form(formname) & "," & Bytes2Str(value)
				Else
					Form.Add formname, Bytes2Str(value)
				End If
			End If
            istart = valueend + 2 + slen
        Loop Until (istart + 2) >= LenB(tempdata)
		tempdata = empty
		vLostTime = FormatNumber((timer-time1)*1000,2)
		GetData =true
	End Function
	
	Private Function CheckExe(ByVal ex)
		Dim notIn: notIn = True
		If vExe="*" then
			notIn=false 
		elseIf InStr(1, vExe, "|") > 0 Then
			Dim tempExe: tempExe = Split(vExe, "|")
			Dim I: I = 0
			For I = 0 To UBound(tempExe)
				If LCase(ex) = tempExe(I) Then
					notIn = False
					Exit For
				End If
			Next
		Else
			If vExe = LCase(ex) Then
				notIn = False
			End If
		End If
		checkExe = notIn
	End Function
	
	Private Function Bytes2Str(ByVal byt)
		If LenB(byt) = 0 Then
			Bytes2Str = ""
			Exit Function
		End If
		Dim mystream, bstr
		Set mystream =Server.CreateObject("ADODB.Stream")
		mystream.Type = 2
		mystream.Mode = 3
		mystream.Open
		mystream.WriteText byt
		mystream.Position = 0
		mystream.CharSet = vCharSet
		mystream.Position = 2
		bstr = mystream.ReadText()
		mystream.Close
		Set mystream = Nothing
		Bytes2Str = bstr
	End Function
	
	Private Function Getname()
		Dim y, m, d, h, mm, S, r
		Randomize
		y = Year(Now)
		m = right("0" & Month(Now),2)
		d = right("0" & Day(Now),2)
		h = right("0" & Hour(Now),2)
		mm =right("0" & Minute(Now),2)
		S = right("0" & Second(Now),2)
		r = CInt(Rnd() * 10000)
		r = right("0000" & r,4)
		Getname = y & m & d & h & mm & S & r
	End Function
	
	Private Function checkEntryType()
		Dim ContentType, ctArray, bArray,RequestMethod
		RequestMethod=trim(LCase(Request.ServerVariables("REQUEST_METHOD")))
		if RequestMethod="" or RequestMethod<>"post" then
			checkEntryType = False
			exit function
		end if
		ContentType = LCase(Request.ServerVariables("HTTP_CONTENT_TYPE"))
		if ContentType="" then ContentType = LCase(Request.ServerVariables("CONTENT_TYPE"))
		ctArray = Split(ContentType, ";")
		if ubound(ctarray)>=0 then
			If Trim(ctArray(0)) = "multipart/form-data" Then
			checkEntryType = True
			vboundary = Split(ContentType,"boundary=")(1)
			Else
			checkEntryType = False
			End If
		else
			checkEntryType = False
		end if
	End Function
	
	Public Function Post(ByVal formname)
		If trim(formname) = "-1" Then
			Set Post = Form
		Else
			If Form.Exists(LCase(formname)) Then
				Post = Form(LCase(formname))
			Else
				Post = ""
			End If
		End If
	End Function
	
	Public Default Function Files(ByVal formname)
		If trim(formname) = "-1" Then
			Set Files = Fils
		Else
			dim vname
			vname = LCase(formname) & vMuti & "0"
			if instr(formname,vMuti)>0 then vname = formname
			If Fils.Exists(vname) Then
				Set Files = Fils(vname)
			Else
				Set Files = NewFile()
				Files.IsFile = false
			End If
		End If
	End Function
	
	Public Function Search(ByVal formname)
		if formname="*" or formname="-1" then
			Set Search = Fils
			Exit Function
		end if
		Dim TempFormName
		TempFormName = formname & vMuti
		Dim FileCollection
		Set FileCollection = Server.CreateObject("Scripting.Dictionary")
		Dim v
		For Each v In Fils
			If lcase(left(v,len(TempFormName))) = lcase(TempFormName) Then
				FileCollection.Add v,Fils(v)
			End If
		Next
		Set Search = FileCollection
	End Function
	
	
	Public Function QuickSave(ByVal formname)
		Dim FC,SucceedCount,File
		SucceedCount = 0
		Set FC = Search(formname)
		For Each File In FC
			If Save(File,0,True).Succeed Then SucceedCount = SucceedCount + 1
		Next
		QuickSave = SucceedCount
	End Function
	
	Public Function IsImage(Name)
		Dim File
		if not isobject(Name) then
			Set File = Files(Name)
			If Not File.IsFile Then
				IsImage = false
				Exit Function
			End If
		else
			Set File = Name
		end if
		IsImage = false
		'from internet
		Dim intTemp,strTemp,isJpeg,ispng,a,b,c,d,tempContentType
		tempContentType = lcase(File.contentType)
		select case lcase(File.Extend)
			case "jpg","jpeg","pjpeg"
				tempContentType = "image/jpeg"
			case "gif"
				tempContentType = "image/gif"
			case "png"
				tempContentType = "image/png"
			case "bmp"
				tempContentType = "image/bmp"
			case "swf"
				tempContentType = "application/x-shockwave-flash"
		end select
		select case tempContentType
		case "image/jpeg","image/pjpeg","image/jpg"
			if Lcase(File.Extend)<>"jpg" then File.Extend="jpg"
			StreamT.Position=File.Position+3
			do while not StreamT.EOS
				do
					intTemp = Ascb(StreamT.Read(1))
				loop while intTemp = 255 and not StreamT.EOS
				if intTemp < 192 or intTemp > 195 then
					StreamT.read(Bin2Val(StreamT.Read(2))-2)
				else
					Exit do
				end if
				do
					intTemp = Ascb(StreamT.Read(1))
				loop while intTemp < 255 and not StreamT.EOS
			loop
			StreamT.Read(3)
			File.Height = Bin2Val(StreamT.Read(2))
			File.Width = Bin2Val(StreamT.Read(2))
			StreamT.Position = File.Position + File.Size-2
			isJpeg = false
			if ascb(StreamT.read(1))=&HFF then
				if ascb(StreamT.read(1))=&HD9 then
					isJpeg = true
				end if
			end if
			if not isJpeg then
				File.Width = 0
				File.Height = 0
				File.size=0
			end if
		case "image/gif"
			if Lcase(File.Extend)<>"gif" then File.Extend="gif"
			StreamT.Position=File.Position+6
			File.Width = BinVal2(StreamT.Read(2))
			File.Height = BinVal2(StreamT.Read(2))
			StreamT.Position = File.Position + File.Size-1
			if ascb(StreamT.read(1)) <>asc(";") then
				File.Width = 0
				File.Height = 0
				File.size=0
			end if
		case "image/png"
			if Lcase(File.Extend)<>"png" then File.Extend="png"
			StreamT.Position=File.Position+18
			File.Width = Bin2Val(StreamT.Read(2))
			StreamT.Read(2)
			File.Height = Bin2Val(StreamT.Read(2))
			StreamT.Position = File.Position + File.Size-12
			ispng = false
			intTemp = Ascb(StreamT.Read(1))
			intTemp = intTemp+Ascb(StreamT.Read(1))
			intTemp = intTemp+Ascb(StreamT.Read(1))
			intTemp = intTemp+Ascb(StreamT.Read(1))
			if intTemp=0 then
				a = Ascb(StreamT.Read(1))
				b = Ascb(StreamT.Read(1))
				c = Ascb(StreamT.Read(1))
				d = Ascb(StreamT.Read(1))
				if a=&H49 and b = &H45 and c = &H4e and d = &H44 then
					a = Ascb(StreamT.Read(1))
					b = Ascb(StreamT.Read(1))
					c = Ascb(StreamT.Read(1))
					d = Ascb(StreamT.Read(1))
					if a=&HAE and b = &H42 and c = &H60 and d = &H82 then
						ispng = true	
					end if
				end if
			end if
			if not ispng then
				File.Width = 0
				File.Height = 0
				File.size=0
			end if
		case "image/bmp"
			if Lcase(File.Extend)<>"bmp" then File.Extend="bmp"
			StreamT.Position=File.Position+18
			File.Width = BinVal2(StreamT.Read(4))
			File.Height = BinVal2(StreamT.Read(4))
			StreamT.Position=File.Position+2
			File.Size= BinVal2(StreamT.Read(4))
		case "application/x-shockwave-flash"
			if Lcase(File.Extend)<>"swf" then File.Extend="swf"
			StreamT.Position=File.Position
			if Ascb(StreamT.Read(1))=&H46 then
				StreamT.Position=File.Position+8
				strTemp = Num2Str(Ascb(StreamT.Read(1)), 2 ,8)
				intTemp = Str2Num(Left(strTemp, 5), 2)
				strTemp = Mid(strTemp, 6)
				while (Len(strTemp) < intTemp * 4)
					strTemp = strTemp & Num2Str(Ascb(StreamT.Read(1)), 2 ,8)
				wend
				File.Width = Int(Abs(Str2Num(Mid(strTemp, intTemp + 1, intTemp), 2) - Str2Num(Mid(strTemp, 1, intTemp), 2)) / 20)
				File.Height = Int(Abs(Str2Num(Mid(strTemp, 3 * intTemp + 1, intTemp), 2) - Str2Num(Mid(strTemp, 2 * intTemp + 1, intTemp), 2)) / 20)
			end if
		end select
		if File.Width>0 and File.Height>0 then
			IsImage = true
		else
			IsImage = false
			File.Size=0
		end if
	End Function
	
	Public Function Save(Byref Name,byval tOption, byval OverWrite)
		Dim File
		if not isobject(name) then
			Set File = Files(Name)
			If Not File.IsFile Then
				File.Succeed = false
				File.Exception="ERROR_FILE_NO_FOUND"
				Set Save = File
				Exit Function
			End If
		else
			Set File = Name
		end if
		If Not File.IsFile Then
			File.Succeed = false
			File.Exception="ERROR_FILE_NO_FOUND"
			Set Save = File
			Exit Function
		End If
		On Error Resume Next
		Err.clear
		Dim IsP,Path
		Path = mvarSavePath
		IsP = (InStr(mvarSavePath, ":") = 2)
		If Not IsP Then Path = Server.MapPath(mvarSavePath)
		Path = Replace(Path, "/", "\")
		If Mid(Path, Len(Path) - 1) <> "\" Then Path = Path + "\"
		CreateFolder Path
		File.Path= Replace(Replace(Path,Server.MapPath("/"),""),"\","/")
		If tOption = 1 Then
			Path = Path & File.LocalName: File.FileName =File.LocalName
		Else
			If tOption = -1 And File.UserSetName <> "" Then
				Path = Path & File.UserSetName & "." & File.Extend: File.FileName = File.UserSetName & "." & File.Extend
			Else
				Path = Path & File.NewName: File.FileName = File.NewName
			End If
		End If
		If Not OverWrite Then
			Path = GetFilePath(File)
		End If
		If Err.Number<>0 Then
			File.Succeed = false
			File.Exception=Err.Description
			Err.clear()
			Set Save = File
			Exit Function
		End if
		Dim tmpStrm
		Set tmpStrm =Server.CreateObject("ADODB.Stream")
		tmpStrm.Mode = 3
		tmpStrm.Type = 1
		tmpStrm.Open
		StreamT.Position = File.Position
		StreamT.copyto tmpStrm,File.Size
		tmpStrm.SaveToFile Path, 2
		tmpStrm.Close
		Set tmpStrm = Nothing
		If Err.Number=0 Then
			File.Succeed = true
		Else
			File.Succeed = false
			File.Exception=Err.Description
			Err.clear()
		End If
		Set Save = File
	End Function
	
	Public Function GetBinary(byval Name)
		Dim File
		Set File = Files(Name)
		If Not File.IsFile Then
			GetBinary = chrb(0)
			Exit Function
		End If
		StreamT.Position = File.Position
		GetBinary = StreamT.read(File.Size)
	End Function 
	
	Private Function GetNextFormName(byval formname)
		Dim formStart,currentIndex
		formStart = left(formname,instr(formname,vMuti)+len(vMuti)-1)
		currentIndex = mid(formname,instr(formname,vMuti)+len(vMuti))
		currentIndex =cint(currentIndex)
		do while Fils.Exists(formname)
			currentIndex = currentIndex + 1
			formname = formStart & currentIndex
		loop
		GetNextFormName = formname
	End Function
	Private Function ReplaceEx(sourcestr, regString, str)
		if isnull(sourcestr) then sourcestr=""
		dim re
		Set re = new RegExp
		re.IgnoreCase = true
		re.Global = True
		re.pattern = "" & regString & ""
		str = re.replace(sourcestr, str)
		set re = Nothing
		ReplaceEx = str
	End Function
	Private Function CreateFolder(ByVal folderPath )
		Dim oFSO
		Set oFSO = Server.CreateObject("Scripting.FileSystemObject")
		Dim sParent 
		sParent = oFSO.GetParentFolderName(folderPath)
		If sParent = "" Then Exit Function
		If Not oFSO.FolderExists(sParent) Then CreateFolder (sParent)
		If Not oFSO.FolderExists(folderPath) Then oFSO.CreateFolder (folderPath)
		Set oFSO = Nothing
	End Function
	
	Private Function GetFilePath(Byref File) 
		Dim oFSO, Fname , FNameL , i 
		i = 0
		Set oFSO = Server.CreateObject("Scripting.FileSystemObject")
		Fname = Server.MapPath(File.Path & File.FileName)
		FNameL = Mid(File.FileName, 1, InStr(File.FileName, ".") - 1)
		Do While oFSO.FileExists(Fname)
			Fname = Server.MapPath(File.Path & FNameL & "(" & i & ")." & File.Extend)
			File.FileName = FNameL & "(" & i & ")." & File.Extend
			i = i + 1
		Loop
		Set oFSO = Nothing
		GetFilePath = Fname
	End Function
	
	Private Function NewFile()
		Execute "Set NewFile = new " & mvarClsName
		NewFile.Width = 0
		NewFile.Height = 0
	End Function
	
	Private Function BinVal2(bin)
		dim lngValue,i
		lngValue=0
		for i = lenb(bin) to 1 step -1
			lngValue = lngValue *256 + Ascb(midb(bin,i,1))
		Next
		BinVal2=lngValue
	End Function

	Private Function Bin2Val(bin)
		dim lngValue,i
		lngValue=0
		for i = 1 to lenb(bin)
			lngValue = lngValue *256 + Ascb(midb(bin,i,1))
		Next
		Bin2Val=lngValue
	End Function

	Private Function Num2Str(num, base, lens)
		Dim ret,i
		ret = ""
		while(num >= base)
			i   = num Mod base
			ret = i & ret
			num = (num - i) / base
		wend
		Num2Str = Right(String(lens, "0") & num & ret, lens)
	End Function

	Private Function Str2Num(str, base)
		Dim ret, i
		ret = 0 
		for i = 1 to Len(str)
			ret = ret * base + Cint(Mid(str, i, 1))
		Next
		Str2Num = ret
	End Function
End Class
%>