<%
call imageMainHtml()
function imageMainHtml()
%>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"
        "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
    <title></title>
    <meta http-equiv="Content-Type" content="text/html;charset=utf-8"/>
    <script type="text/javascript" src="../internal.js"></script>
    <link rel="stylesheet" href="image.css" type="text/css" />
</head>
<body>
    <div class="wrapper">
        <div id="imageTab">
            <div id="tabHeads" class="tabhead">
                <span tabSrc="remote"  class="focus"><var id="lang_tab_remote"></var></span>
                <span tabSrc="local"><var id="lang_tab_local"></var></span>
                <span tabSrc="imgManager"><var id="lang_tab_imgManager"></var></span>
                <span tabSrc="imgSearch"><var id="lang_tab_imgSearch"></var></span>
            </div>
            <div id="tabBodys" class="tabbody">
                <div id="remote" class="panel">
                    <table cellpadding="0" cellspacing="0">
                        <tr>
                            <td class="label"><label for="url"><var id="lang_input_url"></var></label></td>
                            <td><input id="url" type="text"/></td>
                        </tr>
                        <tr>
                            <td class="label"><label for="width"><var id="lang_input_width"></var></label></td>
                            <td><input type="text" id="width"/> px</td>
                        </tr>
                        <tr>
                            <td class="label"><label for="height"><var id="lang_input_height"></var></label></td>
                            <td><input type="text" id="height"/> px</td>
                        </tr>
                        <tr>
                            <td class="label"><label for="border"><var id="lang_input_border"></var></label></td>
                            <td><input type="text" id="border"/> px</td>
                        </tr>
                        <tr>
                            <td class="label"><label for="vhSpace"><var id="lang_input_vhspace"></var></label></td>
                            <td><input type="text" id="vhSpace"/> px</td>
                        </tr>
                        <tr>
                            <td class="label"><label for="title"><var id="lang_input_title"></var></label></td>
                            <td><input type="text" id="title"/></td>
                        </tr>
                        <tr>
                            <td class="label"><var id="lang_input_remoteAlign"></var></td>
                            <td id="remoteFloat"></td>
                        </tr>
                    </table>

                    <div id="preview"></div>
                    <div class="lock"><input id="lock" type="checkbox" checked="checked"></div>
                </div>
                <div id="local" class="panel">
                    <div id="flashContainer"></div>
                    <div><div id="upload" style="display: none" ></div><div id="duiqi"></div><div id="localFloat"></div></div>

                    <div class="saveDir">
                        <var id="lang_savePath" ></var><span id="saveDirSelector"><var id="lang_load_savePath"></var></span>
                    </div>
                </div>
                <div id="imgManager" class="panel">
                    <div id="imageList"><var id="lang_imgLoading"></var></div>
                </div>
                <div id="imgSearch" class="panel">
                    <table style="margin-top: 5px;">
                        <tr>
                            <td width="200"><input id="imgSearchTxt" type="text" /></td>
                            <td width="65">
                                <select id="imgType">
                                    <!--具体内容值将由国际化组件动态填充-->
                                    <option value="&s=4&z=0"></option>
                                    <option value="&s=1&z=19"></option>
                                    <option value="&s=2&z=0"></option>
                                    <option value="&s=3&z=0"></option>
                                </select>
                            </td>
                            <td width="80"><input id="imgSearchBtn" type="button"  /></td>
                            <td width="80"><input id="imgSearchReset" type="button" /></td>
                        </tr>
                    </table>
                    <div id="searchList"></div>
                </div>
                <iframe id="maskIframe" src="about:blank" scrolling="no" frameborder="no"></iframe>
            </div>
        </div>
    </div>
    <script type="text/javascript" src="../tangram.js"></script>
    <script type="text/javascript" src="image.js"></script>
    <script type="text/javascript">
        //全局变量
        var imageUrls = [],          //用于保存从服务器返回的图片信息数组
            selectedImageCount = 0,  //当前已选择的但未上传的图片数量
            savePathComplete = false, //保存目录已经就绪
            params = baidu.json.stringify({
                "fileNameFormat":editor.options.fileNameFormat
            });

        editor.setOpt({
            imageFieldName:"upfile",
            compressSide:0,
            maxImageSideLength:900
        });

        utils.domReady(function(){
            var flashOptions = {
                container:"flashContainer",                                                    //flash容器id
                url:editor.options.imageUrl,                                           // 上传处理页面的url地址
                ext:params,                                 //可向服务器提交的自定义参数列表
                fileType:'{"description":"'+lang.fileType+'", "extension":"*.gif;*.jpeg;*.png;*.jpg"}',     //上传文件格式限制
                flashUrl:'imageUploader.swf',                                                  //上传用的flash组件地址
                width:608,          //flash的宽度
                height:272,         //flash的高度
                gridWidth:121,     // 每一个预览图片所占的宽度
                gridHeight:120,    // 每一个预览图片所占的高度
                picWidth:100,      // 单张预览图片的宽度
                picHeight:100,     // 单张预览图片的高度
                uploadDataFieldName:editor.options.imageFieldName,    // POST请求中图片数据的key
                picDescFieldName:'pictitle',      // POST请求中图片描述的key
                maxSize:4,                         // 文件的最大体积,单位M
                compressSize:2,                   // 上传前如果图片体积超过该值，会先压缩,单位M
                maxNum:32,                         // 单次最大可上传多少个文件
                compressSide:editor.options.compressSide,                 //等比压缩的基准，0为按照最长边，1为按照宽度，2为按照高度
                compressLength:editor.options.maxImageSideLength        //能接受的最大边长，超过该值Flash会自动等比压缩
            };
            //回调函数集合，支持传递函数名的字符串、函数句柄以及函数本身三种类型
            var callbacks = {
                // 选择文件的回调
                selectFileCallback: function(selectFiles){
                    utils.each(selectFiles,function(file){
                        var tmp = {};
                        tmp.id = file.index;
                        tmp.data = {};
                        postConfig.push(tmp);
                    });
                    selectedImageCount += selectFiles.length;
                    if(selectedImageCount) baidu.g("upload").style.display = "";
                    dialog.buttons[0].setDisabled(true); //初始化时置灰确定按钮
                },
                // 删除文件的回调
                deleteFileCallback: function(delFiles){
                    for(var i = 0,len = delFiles.length;i<len;i++){
                        var index = delFiles[i].index;
                        postConfig.splice(index,1);
                    }
                    selectedImageCount -= delFiles.length;
                    if (!selectedImageCount) {
                        baidu.g("upload").style.display = "none";
                        dialog.buttons[0].setDisabled(false);         //没有选择图片时重新点亮按钮
                    }
                },

                // 单个文件上传完成的回调
                uploadCompleteCallback: function(data){
                    try{
                        var info = eval("(" + data.info + ")");
                        info && imageUrls.push(info);
                        selectedImageCount--;
                    }catch(e){}

                },
                // 单个文件上传失败的回调,
                uploadErrorCallback: function (data){
                    if(!data.info){
                        alert(lang.netError);
                    }
                    //console && console.log(data);
                },
                // 全部上传完成时的回调
                allCompleteCallback: function(){
                    dialog.buttons[0].setDisabled(false);    //上传完毕后点亮按钮
                },
                // 文件超出限制的最大体积时的回调
                //exceedFileCallback: 'exceedFileCallback',
                // 开始上传某个文件时的回调
                startUploadCallback: function(){
                    var config = postConfig.shift();
                    //也可以在这里更改
                    //if(config.id==2){ //设置第三张图片的对应参数
                    //     config.data={"myParam":"value"}
                    // }
                    flashObj.addCustomizedParams(config.id,config.data);
                }
            };

            initSavePath();

            imageUploader.init(flashOptions,callbacks);
            $G("upload").onclick = function () {

                if ( !savePathComplete ) {
                    alert('请等待保存目录就绪!')
                    return;
                }
                /**
                 * 接口imageUploader.setPostParams()可以在提交时设置本次上传提交的参数（包括所有图片）
                 * 参数为json对象{"key1":"value1","key2":"value2"}，其中key即为向后台post提交的name，value即为值。
                 * 其中有一个特殊的保留key值为action，若设置，可以更改本次提交的处理地址
                 */
                var postParams = {
                    "dir":baidu.g("savePath").value
                };
                imageUploader.setPostParams(postParams);
                flashObj.upload();
                this.style.display = "none";
                $G("savePath").parentNode.style.display = "none";
            };

        });

        function initSavePath () {

            if ( editor.options.savePath && editor.options.savePath.length > 0 ) {
                updateSavePath( editor.options.savePath );
            } else {
                //远程加载
                var scriptNode = document.createElement('script'),
                    reqAddress = editor.options.imageUrl.split( "#" ),
                    uri = reqAddress[0].split( "?" );

                if ( uri.length > 1 ) {
                    uri = uri[ 0 ] + "?" + uri.slice( 1 ).join("?") + ( !!uri? "&fetch=1" : "fetch=1" );
                } else {
                    uri = uri[ 0 ] + "?fetch=1";
                }

                if ( reqAddress.length > 1 ) {
                    uri += "#" + reqAddress.slice( 1 ).join("#");
                }

                scriptNode.src = uri;
                document.body.appendChild( scriptNode );
            }

        }

        function updateSavePath ( pathArr ) {

            var selector = $G( "saveDirSelector" ),
                htmlStr = [ '<select id="savePath">' ],
                dirs = pathArr;

            for ( var i = 0, len = dirs.length; i < len; i++ ) {

                htmlStr.push( '<option value="'+ dirs[ i ] +'">'+ dirs[ i ] +'</option>' );

            }

            htmlStr.push( '</select>' );

            selector.innerHTML = htmlStr.join( "" );

            savePathComplete = true;

        }

    </script>
</body>
</html>
<%
end function
%>