﻿<!--#include file="ow.client.asp"-->
<%
dim AjaxForm
'**前台初始化
call Client.init()

'**ajax合法性判断
if Client.ajaxValid() then
    '**如果是合法提交的ajax数据则初始化表单类
	set AjaxForm = new AjaxForm_Class
	    AjaxForm.init()
	set AjaxForm = nothing
else
    '**如果是不合法的ajax数据则输出错误信息
	call Client.ajaxError()
end if

'**表单类
class AjaxForm_Class
	
	private aArr,iI,sFormDataTable
	
	private sub class_initialize()
	end sub
	
	public sub init()
		if CTL="form" and ACT="post_formdata" then
			V("form_id") = OW.int(OW.getForm("get","form_id"))
			call getFormInfo(V("form_id"))
			if valid() then
				call postFormData(V("form_id"))
			end if
		else
			call Client.ajaxFailed("ctl或act参数错误！")
		end if
		call Client.ajaxFinishRun()
	end sub
	
	private sub class_terminate()
		set Client = nothing
	end sub
	
	private function valid()
		dim vcodeOpen
		vcodeOpen = OW.int(OW.config("form_vcode_open"))
		if vcodeOpen then
			if not OS.validVerifyCode() then
				call Client.ajaxFailed("验证码错误，请输入正确的验证码！")
				valid = false
				exit function
			end if
		end if
		if not V("form_exist") then
			call Client.ajaxFailed("form_id错误，表单不存在！")
			valid = false
			exit function
		end if
		if V("status")=1 then
			call Client.ajaxFailed("亲，表单["& V("name") &"]已终止了，不能再提交数据了哦！")
			valid = false
			exit function
		end if
		'**权限设置
		if V("auth")=1 then
			if UID<1 then
				call Client.ajaxFailed("亲，表单["& V("name") &"]只允许会员提交，请先登陆哦！")
				valid = false
				exit function
			end if
			if OW.isInArray(split(V("forbid_member_group"),","),GROUP_ID) or OW.isInArray(split(V("forbid_member_group"),","),SPECIAL_GROUP_ID) then
				call Client.ajaxFailed("亲，很抱歉，您所在会员组没有提交此表单数据的权限哦。")
				valid = false
				exit function
			end if
			if V("post_once")=1 then
				if OW.DB.isRecordExistsBySQL("SELECT * FROM "& sFormDataTable &" WHERE uid="& UID &"") then
					call Client.ajaxFailed("亲，很抱歉，您已提交过表单数据，不能再提交了哦。")
					valid = false
					exit function
				end if
			end if
		end if
		valid = true
	end function
	
	public function getFormInfo(byval formId)
		aArr = OW.DB.getFieldValueBySQL("SELECT status,[name],[table],send_email,rec_email,auth,post_once,forbid_member_group,need_check FROM "& DB_PRE &"form WHERE form_id="& formId &" AND "& OW.DB.auxSQL &"")
		V("status")     = OW.int(aArr(0))
		V("name")       = aArr(1)
		V("table")      = aArr(2)
		V("send_email") = OW.int(aArr(3))
		V("rec_email")  = OW.rs(aArr(4))
		V("auth")       = OW.int(aArr(5))
		V("post_once")  = OW.int(aArr(6))
		V("forbid_member_group") = OW.rs(aArr(7))
		V("need_check") = OW.int(aArr(8))
		'**
		if V("table")<>"" then
			V("form_exist") = true
			sFormDataTable = OW.DB.Table.formPre & V("table")
		else
			V("form_exist") = false
		end if
	end function
	
	public function postFormData(byval formId)
		dim result : result = false
		dim i,rs,arr,count,field,fieldType,datasize,value
		count = OW.int(OW.DB.getFieldValueBySQL("SELECT count(*) FROM "& DB_PRE &"form_field WHERE form_id="& formId &" AND "& OW.DB.auxSQL &""))
		if count>0 then
			redim arr(count+3)
			arr(0) = "uid:"& UID
			arr(1) = "status:"& OW.iif(V("need_check")=1,"1","0")
			arr(2) = "ip:"& OW.getClientIP()
			arr(3) = "post_time:"& SYS_TIME
			i      = 4
			set rs = OW.DB.getRecordBySQL("SELECT * FROM "& DB_PRE &"form_field WHERE form_id="& formId &" AND "& OW.DB.auxSQL &" ORDER BY sequence")
			do while not(rs.eof)
				field     = rs("field")
				fieldType = rs("field_type")
				datasize  = rs("field_datasize")
				value     = Client.getFormFieldValue(field,fieldType,datasize)
				arr(i)    = field &":"& value
				i         = i + 1
				rs.movenext
			loop
			OW.DB.closeRs rs
			result = OW.DB.addRecord(sFormDataTable,arr)
		end if
		if result then
			if V("send_email")=1 then call sendEmail()
			call Client.ajaxSuccess("保存成功！")
		else
			call Client.ajaxFailed("保存失败！")
		end if
	end function
	
	public function sendEmail()
		'发送失败，记录下日志
		dim title,body
		title = "网站["& SITE_NAME &"]有人提交了["& V("name") &"]数据"
		body  = "网站["& SITE_NAME &"]有人提交了["& V("name") &"]数据，详情请进入网站管理后台查看。<br>"
		body  = body &"进入后台：<a href="""& SITE_URL &"ow-admin/"" target=""_blank"">"& SITE_URL &"ow-admin/</a>"
		aArr  = split(V("rec_email"),",")
		for iI=0 to ubound(aArr)
			call OS.sendEmail("",trim(aArr(iI)),title,body)
		next
	end function 
	
end class
%>