﻿<!--#include file="ow.client.asp"-->
<%
'**前台初始化
call Client.init()

'**ajax合法性判断
if Client.ajaxValid() then
    '**如果是合法提交的ajax数据则初始化用户类
	dim Member
	set Member = new Member_Class
	    Member.init()
	set Member = nothing
else
    '**如果是不合法的ajax数据则输出错误信息
	call Client.ajaxError()
end if

'**表单类
class Member_Class
	
	private aArr,iI,sFormDataTable
	
	private sub class_initialize()
	end sub
	
	public sub init()
		if CTL="member" then
			select case ACT
			case "login"
				call login()
			case "reg"
				call reg()
			case "is_logined"
				call isLogined()
			case "forget"
				call forgetPassword()
			case "forget_reset"
				call forgetPasswordReset()
			case "mobile_bind"
				if LOGINED then call mobileBind()
			case "mobile_and_password_set"
				if LOGINED then
					if OW.config("is_user_mobile_open")=1 and OW.isNul(MOBILE) then
						call mobileAndPasswordSet()
					end if
				end if
			case "get_reg_mobile_code"
				call getRegMobileCode()
			case "get_forget_mobile_code"
				call getForgetMobileCode()
			case "get_mobile_set_mobile_code"
				call getMobileSetMobileCode()
			case "get_login_win_html"
				call getLoginWinHtml()
			end select
		else
			call Client.ajaxFailed("ctl或act参数错误！")
		end if
		call Client.ajaxFinishRun()
	end sub
	
	private sub class_terminate()
		set Client = nothing
	end sub
	
	private function valid()
		if not OS.validVerifyCode() then
			call Client.ajaxFailed("验证码错误，请输入正确的验证码！")
			valid = false
			exit function
		end if
		valid = true
	end function
	
	private function isLogined()
		if LOGINED then
			Client.auxJson = """logined"":""true"""
			call Client.ajaxSuccess("已登录")
		else
			Client.auxJson = """logined"":""false"""
			call Client.ajaxSuccess("未登录")
		end if
	end function
	
	private function getLoginWinHtml()
		Client.auxJson = """login_html"":"""& OW.escape(OS.loginWinHtml) &""""
		call Client.ajaxSuccess("")
	end function
	
	public function login()
		dim result,vcodeOpen,valid : valid = true
		if OW.isMobile then
			vcodeOpen = OW.int(OW.config("user_login_vcode_open_mb"))
		else
			vcodeOpen = OW.int(OW.config("user_login_vcode_open_pc"))
		end if
		if vcodeOpen then
			if not OS.validVerifyCode() then
				call Client.ajaxFailed("验证码错误，请输入正确的验证码！")
				valid = false
			end if
		end if
		if valid then 
			result = OS.login(OW.clientUserDataDecode(OW.getForm("post","username")),OW.clientUserDataDecode(OW.getForm("post","password")))
			if result<>true then
				call Client.ajaxFailed(result)
			else
				call Client.ajaxSuccess("登录成功！")
			end if
		end if
	end function
	
	public function reg()
		dim result,vcodeOpen,valid : valid = true
		if OW.isMobile then
			vcodeOpen = OW.int(OW.config("user_reg_vcode_open_mb"))
		else
			vcodeOpen = OW.int(OW.config("user_reg_vcode_open_pc"))
		end if
		if OW.config("is_user_mobile_open")=0 then
			if vcodeOpen then
				if not OS.validVerifyCode() then
					call Client.ajaxFailed("验证码错误，请输入正确的验证码！")
					valid = false
				end if
			end if
		else
			valid = true
		end if
		if valid then
			result = OS.reg(OW.clientUserDataDecode(OW.getForm("post","username")),OW.clientUserDataDecode(OW.getForm("post","password")),OW.clientUserDataDecode(OW.getForm("post","email")),OW.clientUserDataDecode(OW.getForm("post","mobile")),OW.clientUserDataDecode(OW.getForm("post","mobile_code")))
			if result=true then
				call Client.ajaxSuccess("注册成功！")
			else
				call Client.ajaxFailed(result)
			end if
		end if
	end function
	
	public function forgetPassword()
		dim arr,hash,resetPasswordUrl,vcodeOpen,result,rs,sql : result  = true
		dim valid : valid = true
		V("by")          = OW.left(OW.regReplace(OW.getForm("post","by"),"[^0-9a-zA-Z_]",""),6)
		V("mobile")      = OW.parseMobile(OW.clientUserDataDecode(OW.getForm("post","mobile")))
		V("mobile_code") = OW.parseMobileCode(OW.clientUserDataDecode(OW.getForm("post","mobile_code")))
		V("account")     = OW.left(OW.clientUserDataDecode(OW.getForm("post","account")),64)
		if OW.isMobile then
			vcodeOpen = OW.int(OW.config("user_forget_vcode_open_mb"))
		else
			vcodeOpen = OW.int(OW.config("user_forget_vcode_open_pc"))
		end if
		if V("by")="mobile" then
			if not OW.isValidMobile(V("mobile")) then
				call Client.ajaxFailed("手机号码填写不正确！")
				exit function
			end if
			if OW.isNul(V("mobile_code")) then
				call Client.ajaxFailed("短信验证码必须填写！")
				exit function
			end if
			'**
			if not OS.isMobileCodeValid(V("mobile"),V("mobile_code"),2) then
				call Client.ajaxFailed(OS.lang(21))
				exit function
			end if
			V("condition")      = "mobile='"& V("mobile") &"'"
			V("user_not_exist") = "手机号码不存在"
		else
			if vcodeOpen then
				if not OS.validVerifyCode() then
					call Client.ajaxFailed("验证码错误，请输入正确的验证码！")
					valid = false
				end if
			end if
			if valid then 
				if OW.isNul(V("account")) then
					call Client.ajaxFailed("用户邮箱或用户名必须填写")
					exit function
				end if
				if OW.isEmail(V("account")) then
					V("account")        = OW.parseEmail(V("account"))
					V("condition")      = "email='"& V("account") &"'"
					V("user_not_exist") = "用户邮箱不存在"
					V("by")             = "email"
				else
					V("account")        = OW.parseUsername(V("account"))
					V("condition")      = "username='"& V("account") &"'"
					V("user_not_exist") = "用户名不存在"
					V("by")             = "username"
				end if
			else
				exit function
			end if
		end if
		'**
		set rs = OW.DB.getRecordBySQL("SELECT * FROM ["& OW.DB.Table.member &"] WHERE "& V("condition") &"")
		if rs.eof then
			V("user_exist") = false
		else
			V("user_exist") = true
			V("uid")        = OW.int(rs("uid"))
			V("username")   = OW.rs(rs("username"))
			V("email")      = OW.rs(rs("email"))
			V("password")   = OW.rs(rs("password"))
			V("status")     = OW.int(rs("status"))
			V("last_login_time") = OW.rs(rs("last_login_time"))
		end if
		OW.DB.closeRs rs
		'**
		if not V("user_exist") then
			call Client.ajaxFailed(V("user_not_exist"))
			exit function
		end if
		if V("status")=1 then
			call Client.ajaxFailed("该用户已被冻结，无法找回密码")
			exit function
		end if
		'**
		hash            = OW.MD6.encrypt(V("password") & V("last_login_time"))
		resetPasswordUrl= OW.reps(OW.reps(OW.urlRewrite("reset_pw"),"{$hash}",hash),"{$uid}",V("uid"))
		'**
		if V("by")="mobile" then
			call OW.DB.execute("DELETE FROM ["& DB_PRE &"mobile_sms_code] WHERE sms_type=2 AND mobile='"& V("mobile") &"'")
			Client.auxJson = """hash"":"""& hash &""",""uid"":"""& V("uid") &""""
			call Client.ajaxSuccess("正确")
		else
			if V("by")="email" then
				V("email_tips") = "系统已成功发送了一封关于找回密码的邮件到您的"& V("email") &"邮箱里，请注意查收！按邮件内容的说明即可重新设置您的登陆密码。"
			else
				V("email_tips") = "系统已成功发送了一封关于找回密码的邮件到您的"& OW.anonymousEmail(V("email")) &"邮箱里，请注意查收！按邮件内容的说明即可重新设置您的登陆密码。"
			end if
			arr = OW.DB.getFieldValueBySQL("SELECT id,mail_title,mail_body,mail_tpl_file,status FROM "& DB_PRE &"mail_tpl WHERE mail_type='forget_password' AND "& OW.DB.auxSQL &"")
			V("id")            = OW.int(arr(0))
			V("mail_title")    = arr(1)
			V("mail_body")     = arr(2)
			V("mail_tpl_file") = arr(3)
			V("status")        = OW.int(arr(4))
			if not(V("id")>0) then
				call Client.ajaxFailed("邮件模板不存在，无法发送邮件")
				exit function
			end if
			if V("status")=1 then
				call Client.ajaxFailed("邮件模板未启用，无法发送邮件")
				exit function
			end if
			if not OW.isNul(V("mail_tpl_file")) then
				if OW.FSO.fileExists(OS.mailTplRoot & V("mail_tpl_file")) then
					V("mail_body") = OW.read(OS.mailTplRoot & V("mail_tpl_file"))
				else
					call Client.ajaxFailed("邮件模板文件"& V("mail_tpl_file") &"不存在，无法发送邮件")
					exit function
				end if
			else
				V("mail_body") = OW.editorContentClientDecode(V("mail_body"))
			end if
			'**
			V("ip")         = OW.getClientIP()
			V("mail_body")  = Replace(V("mail_body"),"{$username}",V("username"))
			V("mail_body")  = Replace(V("mail_body"),"{$site_name}",SITE_NAME)
			V("mail_body")  = Replace(V("mail_body"),"{$reset_password_url}",resetPasswordUrl)
			V("mail_body")  = Replace(V("mail_body"),"{$site_url}",site_url)
			V("mail_body")  = Replace(V("mail_body"),"{$ip}",V("ip"))
			'**
			result = OS.sendEmail("",V("email"),V("mail_title"),V("mail_body"))
			'**
			if result=true then
				V("email_tips") = OW.escape(V("email_tips"))
				Client.auxJson = """html"":"""& V("email_tips") &""""
				call Client.ajaxSuccess("找回密码邮件发送成功！")
			else
				call Client.ajaxfailed("找回密码邮件发送失败！")
			end if
		end if
	end function
	
	public function forgetPasswordReset()
		dim arr,hash,newPassword,vcodeOpen,result,rs,sql : result = true
		V("uid")          = OW.int(OW.clientUserDataDecode(OW.getForm("post","uid")))
		V("hash")         = OW.left(OW.regReplace(OW.getForm("post","hash"),"[^0-9a-zA-Z_]",""),32)
		V("new_password") = OW.clientUserDataDecode(OW.getForm("post","password"))
		'**
		if OW.isMobile then
			vcodeOpen = OW.int(OW.config("user_forget_vcode_open_mb"))
		else
			vcodeOpen = OW.int(OW.config("user_forget_vcode_open_pc"))
		end if
		if vcodeOpen then
			if not OS.validVerifyCode() then
				call Client.ajaxFailed("验证码错误，请输入正确的验证码！")
				exit function
			end if
		end if
		'**
		if OW.isNul(V("new_password")) then
			call Client.ajaxFailed("新密码不能为空")
			exit function
		end if
		newPassword = OW.parsePassword(V("new_password"))
		'**
		set rs = OW.DB.getRecordBySQL("SELECT * FROM ["& OW.DB.Table.member &"] WHERE uid="& V("uid") &"")
		if rs.eof then
			V("user_exist") = false
		else
			V("user_exist") = true
			V("username")   = OW.rs(rs("username"))
			V("email")      = OW.rs(rs("email"))
			V("password")   = OW.rs(rs("password"))
			V("status")     = OW.int(rs("status"))
			V("last_login_time") = OW.rs(rs("last_login_time"))
		end if
		OW.DB.closeRs rs
		if not(V("user_exist")) then
			call Client.ajaxFailed("用户不存在")
			exit function
		end if
		if OW.MD6.encrypt(V("password") & V("last_login_time"))<>V("hash") then
			call Client.ajaxFailed("安全校验错误")
			exit function
		end if
		'**
		OW.DB.auxSQLValid = false
		result = OW.DB.updateRecord(DB_PRE &"member",array("password:"& newPassword),array("uid:"& V("uid")))
		if result then
			call OW.DB.updateRecord(DB_PRE &"ucenter_member",array("password:"& newPassword),array("uid:"& V("uid")))
			call OS.login(V("username"),V("new_password"))
		end if
		OW.DB.auxSQLValid = true
		'**
		if result then
			call Client.ajaxSuccess("成功设置新密码！")
		else
			call Client.ajaxfailed("无法更新密码！")
		end if
	end function
	
	'发送注册手机验证码
	public function getRegMobileCode()
		dim vcodeOpen
		if OW.isMobile then
			vcodeOpen = OW.int(OW.config("user_reg_vcode_open_mb"))
		else
			vcodeOpen = OW.int(OW.config("user_reg_vcode_open_pc"))
		end if
		V("result") = true
		V("mobile") = OW.parseMobile(OW.clientUserDataDecode(OW.getForm("post","mobile")))
		if not OW.isValidMobile(V("mobile")) then
			call Client.ajaxFailed("手机号码填写不正确！")
			exit function
		end if
		if OS.isValidSecurityCode<>true then
			call Client.ajaxFailed("数据未通过安全验证，请手动刷新网页重新获取短信验证码！")
			exit function
		end if
		if not OS.isMobileCodeGetTimeValid(V("mobile"),1) then
			call Client.ajaxFailed("请不要频繁操作，请稍等几分钟。")
			exit function
		end if
		if OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"member WHERE mobile='"& V("mobile") &"'") then
			call Client.ajaxFailed(OW.reps(OS.lang(25),"{$tel}",V("mobile")))
			exit function
		end if
		if vcodeOpen then
			if not OS.validVerifyCode() then
				call Client.ajaxFailed("验证码错误，请输入正确的验证码！")
				exit function
			end if
		end if
		V("result") = OS.sendMobileCode(V("mobile"),1)
		if V("result") then
			call Client.ajaxSuccess("send_mobile_code_success")
		else
			call Client.ajaxFailed("手机短信发送失败，可能是手机号错误导致无法接收短信！")
		end if
	end function
	
	'发送找回密码手机验证码
	public function getForgetMobileCode()
		dim vcodeOpen
		if OW.isMobile then
			vcodeOpen = OW.int(OW.config("user_forget_vcode_open_mb"))
		else
			vcodeOpen = OW.int(OW.config("user_forget_vcode_open_pc"))
		end if
		V("result") = true
		V("mobile") = OW.parseMobile(OW.clientUserDataDecode(OW.getForm("post","mobile")))
		if not OW.isValidMobile(V("mobile")) then
			call Client.ajaxFailed("手机号码填写不正确！")
			exit function
		end if
		if OS.isValidSecurityCode<>true then
			call Client.ajaxFailed("数据未通过安全验证，请手动刷新网页重新获取短信验证码！")
			exit function
		end if
		if not OS.isMobileCodeGetTimeValid(V("mobile"),2) then
			call Client.ajaxFailed("请不要频繁操作，请稍等几分钟。")
			exit function
		end if
		if not OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"member WHERE mobile='"& V("mobile") &"'") then
			call Client.ajaxFailed(OW.reps("手机号码{$tel}不存在","{$tel}",V("mobile")))
			exit function
		end if
		if vcodeOpen then
			if not OS.validVerifyCode() then
				call Client.ajaxFailed("验证码错误，请输入正确的验证码！")
				exit function
			end if
		end if
		V("result") = OS.sendMobileCode(V("mobile"),2)
		if V("result") then
			call Client.ajaxSuccess("send_mobile_code_success")
		else
			call Client.ajaxFailed("手机短信发送失败，可能是手机号错误导致无法接收短信！")
		end if
	end function
	
	'发送绑定手机号码和设置密码的手机验证
	public function getMobileSetMobileCode()
		dim vcodeOpen
		if OW.isMobile then
			vcodeOpen = OW.int(OW.config("user_forget_vcode_open_mb"))
		else
			vcodeOpen = OW.int(OW.config("user_forget_vcode_open_pc"))
		end if
		V("result") = true
		V("mobile") = OW.parseMobile(OW.clientUserDataDecode(OW.getForm("post","mobile")))
		if not OW.isValidMobile(V("mobile")) then
			call Client.ajaxFailed("手机号码填写不正确！")
			exit function
		end if
		if OS.isValidSecurityCode<>true then
			call Client.ajaxFailed("数据未通过安全验证，请手动刷新网页重新获取短信验证码！")
			exit function
		end if
		if not OS.isMobileCodeGetTimeValid(V("mobile"),3) then
			call Client.ajaxFailed("请不要频繁操作，请稍等几分钟。")
			exit function
		end if
		if vcodeOpen then
			if not OS.validVerifyCode() then
				call Client.ajaxFailed("验证码错误，请输入正确的验证码！")
				exit function
			end if
		end if
		'if OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"member WHERE mobile='"& V("mobile") &"'") then
'			call Client.ajaxFailed(OW.reps(OS.lang(25),"{$tel}",V("mobile")))
'			exit function
'		end if
		V("result") = OS.sendMobileCode(V("mobile"),3)
		if V("result") then
			call Client.ajaxSuccess("send_mobile_code_success")
		else
			call Client.ajaxFailed("手机短信发送失败，可能是手机号错误导致无法接收短信！")
		end if
	end function
	
	'绑定手机号码
	public function mobileBind()
		
	end function
	
	public function mobileAndPasswordSet()
		dim mb,mc,pw,result
		mb = OW.parseMobile(OW.clientUserDataDecode(OW.getForm("post","mobile")))
		mc = OW.parseMobileCode(OW.clientUserDataDecode(OW.getForm("post","mobile_code")))
		pw = OW.clientUserDataDecode(OW.getForm("post","password"))
		'**检查是否需要绑定
		if not(OW.config("is_user_mobile_open")=1 and OW.isNul(OW.DB.getFieldValueBySQL("SELECT mobile FROM "& DB_PRE &"member WHERE uid="& UID &""))) then
			call Client.ajaxFailed("手机已绑定，不要重复操作！")
			exit function
		end if
		'**
		if OW.isNul(mb) or OW.isNul(mc) then
			call Client.ajaxFailed(OS.lang(21))
			exit function
		end if
		if OW.isNul(pw) then
			call Client.ajaxFailed(OS.lang(19))
			exit function
		end if
		if not OS.isMobileCodeValid(mb,mc,3) then
			call Client.ajaxFailed(OS.lang(21))
			exit function
		end if
		result = OS.mobileAndPasswordSetting(UID,mb,pw)
		if result=true then
			call Client.ajaxSuccess("设置成功！")
		else
			call Client.ajaxFailed(result)
		end if
		
	end function

	
end class
%>