﻿<!--#include file="../ow.config.asp"-->
<!--#include file="ow.version.asp"-->
<%
function echo(byval str)
	response.write(str)
end function
function print(byval str)
	response.write(str)
	response.flush()
end function
function die(byval str)
	response.write(str)
	response.end()
end function
function redirect(byval url)
	set OS = nothing
	err.clear()
	response.redirect(url)
end function
class VBS_Class
	public function cbool_(byval s)
		cbool_ = cbool(s)
	end function
	public function isArray_(byval arr)
		isArray_ = isArray(arr)
	end function
	public function int_(byval s)
		int_ = int(s)
	end function
	public function clng_(byval s)
		clng_ = clng(s)
	end function
	public function dateDiff_(byval t, byval t1, byval t2)
		dateDiff_ = dateDiff(t,t1,t2)
	end function
	public function dateAdd_(byval t, byval n, byval d)
		dateAdd_ = dateAdd(t,n,d)
	end function
	public function formatCurrency_(byval s,byval decLen)
		formatCurrency_ = formatCurrency(s,decLen,-1)
	end function
	public function instr_(byval ss,byval s)
		instr_ = instr(ss,s)
	end function
	public function left_(byval s, byval l)
		left_ = left(s,l)
	end function
	public function len_(byval s)
		len_ = len(s)
	end function
	public function right_(byval s, byval l)
		right_ = right(s,l)
	end function
	public function split_(byval s,byval st)
		split_ = split(s,st)
	end function
	public function trim_(byval s)
		trim_ = trim(s)
	end function
end class
dim OW
set OW = new OW_Class
call OW.init()
class OW_Class
	public VBS,[Error],DB,FSO,HTTP,JSON,MD5,MD6,AES,Base64,SHA1,Cookie,[Session],Cache,Pager
	public config,configCacheName,fsoName,dictName,objectFSO,fileBom,loginTimeout
	public url,isRewrite,isMobile,URLQueryString,ruleCount,poweredBy
	private oURLRewrite,sRule,sCurrentURL,sCharset,sErrMsg,sTempStr,oRegExp,aArray,aMailSetting,iLen,iI
	private sub Class_Initialize()
		sCharset	= "utf-8"
		fileBom		= "remove"
		fsoName	    = "Scripting.FileSystemObject"
		dictName    = "Scripting.Dictionary"
		loginTimeout= 240
		poweredBy   = "Powered by OpenWBS"
		isRewrite       = false
		isMobile        = false
		ruleCount       = 0
		set objectFSO   = server.createObject(fsoName)
		set config      = server.createObject(dictName)
		set url         = server.createObject(dictName)
		set oURLRewrite = server.createObject(dictName)
		set oRegExp     = new regExp
		set VBS         = new VBS_Class
		OPENWBS_SMSURL  = "aHR0cDovL3d3dy5vcGVud2JzLmNvbS9vdy1zZXJ2aWNlLw"
		url.add "c1","\?{$urlpath}/"
		url.add "c2","\?{$urlpath}/{$page}/"
		url.add "c3","\?{$rootpath}/{$urlpath}/"
		url.add "c4","\?{$rootpath}/{$urlpath}/{$page}/"
		url.add "c1t","\?{$urlpath}/type-{$typeid}-order-{$orderby}/"
		url.add "c2t","\?{$urlpath}/type-{$typeid}-order-{$orderby}/{$page}/"
		url.add "c3t","\?{$rootpath}/{$urlpath}/type-{$typeid}-order-{$orderby}/"
		url.add "c4t","\?{$rootpath}/{$urlpath}/type-{$typeid}-order-{$orderby}/{$page}/"
		url.add "c5","\?{$urlpath}"& SITE_HTML_FILE_SUFFIX
		url.add "c6","\?{$urlpath}-{$page}"& SITE_HTML_FILE_SUFFIX
		url.add "c7","\?{$rootpath}\/{$urlpath}"& SITE_HTML_FILE_SUFFIX
		url.add "c8","\?{$rootpath}\/{$urlpath}-{$page}"& SITE_HTML_FILE_SUFFIX
		url.add "i1","\?index"& SITE_HTML_FILE_SUFFIX
		url.add "i2","\?index-{$page}"& SITE_HTML_FILE_SUFFIX
		url.add "l1","\?login"&  SITE_HTML_FILE_SUFFIX
		url.add "l2","\?logout"& SITE_HTML_FILE_SUFFIX
		url.add "l3","\?reg"&    SITE_HTML_FILE_SUFFIX
		url.add "l4","\?forget_password"& SITE_HTML_FILE_SUFFIX
		url.add "f1","\?form\/{$urlpath}"& SITE_HTML_FILE_SUFFIX
		url.add "f2","\?form\/{$urlpath}-{$page}"& SITE_HTML_FILE_SUFFIX
		url.add "t1","\?tags\/{$tag}"& SITE_HTML_FILE_SUFFIX
		url.add "t2","\?tags\/{$tag}-{$page}"& SITE_HTML_FILE_SUFFIX
		url.add "gt1","\?gtags\/{$tag}"& SITE_HTML_FILE_SUFFIX
		url.add "gt2","\?gtags\/{$tag}-{$page}"& SITE_HTML_FILE_SUFFIX
		url.add "b1","\?brand\/"
		url.add "b2","\?brand\/{$urlpath}"& SITE_HTML_FILE_SUFFIX
		url.add "b3","\?brand\/{$urlpath}-{$page}"& SITE_HTML_FILE_SUFFIX
		url.add "cp1","\?coupon\/"
		url.add "cp2","\?coupon\/{$page}/"
		url.add "cp3","\?coupon\/{$id}"& SITE_HTML_FILE_SUFFIX
		url.add "s1","\?shop/"
		url.add "ct","\?cart"& SITE_HTML_FILE_SUFFIX
		url.add "e1","\?error404"& SITE_HTML_FILE_SUFFIX
	end sub
	public sub init()
		set [Error] = new OW_Error_Class
		SYS_TIME = OW.formatDateTime(SYS_TIME,0)
		set DB = new OW_DB_Class
			DB.SitePath = SITE_PATH
			DB.dbType  = DB_TYPE
			Select case DB_Type
			case 0
				DB.dbServer = DB_ACCESS_PATH
			case 1
				DB.dbServer = DB_SERVER
			end select
			DB.dbPort     = DB_PORT
			DB.dbName     = DB_NAME
			DB.dbUsername = DB_USERNAME
			DB.dbPassword = DB_PASSWORD
			DB.showSQL     = DEBUG_SQL_SHOW
		'**
		set FSO       = new OW_FSO_Class
		set HTTP      = new OW_HTTP_Class
		set JSON      = new OW_JSON_Class
		set MD5       = new OW_MD5_Class
		set MD6       = new OW_MD6_Class
		'OW.MD5.encrypt(s)
		'OW.MD6.encrypt(s)
		set AES       = new OW_AES_Class
		'OW.AES.encrypt(s)
		set Base64    = new OW_Base64_Class
		set SHA1      = new OW_SHA1_Class
		set Cookie    = new OW_Cookie_Class
		set [Session] = new OW_Session_Class
		set Cache     = new OW_Cache_Class
		set Pager     = new OW_Pager_Class
		'**
		AES.EncryptKey = ENCRYPT_KEY
		'**
		COOKIE_PATH      = SITE_PATH
		'**
		Cookie.isEncrypt = false '开启Cookie加密会消耗一定系统资源，请慎重考虑.
		Cookie.isSecure  = false
		Cookie.domain    = COOKIE_DOMAIN
		Cookie.path      = COOKIE_PATH
		Cookie.cookiePre = COOKIE_PRE
		'**
		[Session].isEncrypt  = false
		[Session].sessionPre = SESSION_PRE
		[Session].timeout    = 15 'session有效时间(分钟)
		'**
		Cache.cacheFlag = CACHE_FLAG
		'**
		IS_MULTI_SITES = OW.iif(lcase(OW_VERSION_SITE_TYPE)="z",true,false)
	end sub

	private sub class_terminate()
		set oRegExp     = nothing
		set objectFSO   = nothing
		set url         = nothing
		set oURLRewrite = nothing
		'**
		set VBS      = nothing
		set [Error]  = nothing
		set DB       = nothing
		set FSO      = nothing
		set JSON     = nothing
		set Cache    = nothing
		set Cookie   = nothing
		set [Session]= nothing
		set MD5      = nothing
		set AES      = nothing
		set Base64   = nothing
		set Pager    = nothing
		err.clear
		on error goto 0
	end sub
	public property let [charset](byval str)
		sCharset = ucase(str)
	end property
	
	public property get [charset]()
		[charset] = sCharset
	end property
	
	public property get isFSOInstalled()
		isFSOInstalled = isObjInstalled(fsoName)
	end property
	
	public property get runTime()
		 runTime = OW.parseRuntime(Timer()-SYS_TIME_START)
	end property
	
	public property get currentURL()
		if sCurrentURL="" or isNull(sCurrentURL) then sCurrentURL = getURL("")
		currentURL = sCurrentURL
	end property
	
	public property let currentURL(byval str)
		sCurrentURL = currentURL
	end property
	public property get urlRewrite(byval key)
		dim s
		select case key
		case "search"
			s = "?ctl=search&is_shop={$is_shop}&keyword={$keyword}&page={$page}"
			if OW.config("url_type")=1 then
				s = "index.asp"& s
			end if
		case "reset_pw"
			s = "?ctl=forget_password&act=reset&hash={$hash}&uid={$uid}"
			if OW.config("url_type")=1 then
				s = "index.asp"& s
			end if
		case "order"
			s = "?ctl=order&act={$act}&order_id={$order_id}"
			if OW.config("url_type")=1 then
				s = "index.asp"& s
			end if
		case else
			s = url(key)
			s = replace(s,"\","")
			if OW.config("run_mode")>0 then
				s = replace(s,"?","")
			else
				if OW.config("url_type")=1 then
					s = "index.asp"& s
				end if
			end if
		end select
		'**
		if OW.config("url_path_type")=1 then
			s = SITE_URL & s
		else
			s = SITE_PATH & s
		end if
		'**
		urlRewrite = s
	end property
	public function rewriteRule(byval key, byval rule, byval str)
		ruleCount = ruleCount + 1
		oURLRewrite.add key,array(rule,str)
	end function
	public function addRewriteRule()
		rewriteRule "c1",url("c1"),"ctl=content&is_cate=1&urlpath={$urlpath}" : rewriteRule "c3",url("c3"),"ctl=content&is_cate=1&rootpath={$rootpath}&urlpath={$urlpath}" : rewriteRule "c2",url("c2"),"ctl=content&is_cate=1&urlpath={$urlpath}&page={$page}" : rewriteRule "c4",url("c4"),"ctl=content&is_cate=1&rootpath={$rootpath}&urlpath={$urlpath}&page={$page}" : rewriteRule "c1t",url("c1t"),"ctl=content&is_cate=1&urlpath={$urlpath}&typeid={$typeid}&orderby={$orderby}" : rewriteRule "c3t",url("c3t"),"ctl=content&is_cate=1&rootpath={$rootpath}&urlpath={$urlpath}&typeid={$typeid}&orderby={$orderby}" : rewriteRule "c2t",url("c2t"),"ctl=content&is_cate=1&urlpath={$urlpath}&typeid={$typeid}&orderby={$orderby}&page={$page}" : rewriteRule "c4t",url("c4t"),"ctl=content&is_cate=1&rootpath={$rootpath}&urlpath={$urlpath}&typeid={$typeid}&orderby={$orderby}&page={$page}" : rewriteRule "c5",url("c5"),"ctl=content&is_cate=1&urlpath={$urlpath}" : rewriteRule "c6",url("c6"),"ctl=content&is_cate=1&urlpath={$urlpath}&page={$page}" : rewriteRule "c7",url("c7"),"ctl=content&is_cate=0&rootpath={$rootpath}&urlpath={$urlpath}" : rewriteRule "c8",url("c8"),"ctl=content&is_cate=0&rootpath={$rootpath}&urlpath={$urlpath}&page={$page}" : rewriteRule "i1",url("i1"),"ctl=index" : rewriteRule "i2",url("i2"),"ctl=index&page={$page}" : rewriteRule "l1",url("l1"),"ctl=login" : rewriteRule "l2",url("l2"),"ctl=logout" : rewriteRule "l3",url("l3"),"ctl=reg" : rewriteRule "l4",url("l4"),"ctl=forget_password" : rewriteRule "f1",url("f1"),"ctl=form&urlpath={$urlpath}" : rewriteRule "f2",url("f2"),"ctl=form&urlpath={$urlpath}&page={$page}" : rewriteRule "t1",url("t1"),"ctl=tags&tag={$tag}" : rewriteRule "t2",url("t2"),"ctl=tags&tag={$tag}&page={$page}" : rewriteRule "gt1",url("gt1"),"ctl=gtags&tag={$tag}" : rewriteRule "gt2",url("gt2"),"ctl=gtags&tag={$tag}&page={$page}" : rewriteRule "b1",url("b1"),"ctl=brand" : rewriteRule "b2",url("b2"),"ctl=brand&urlpath={$urlpath}" : rewriteRule "b3",url("b3"),"ctl=brand&urlpath={$urlpath}&page={$page}" : rewriteRule "cp1",url("cp1"),"ctl=coupon" : rewriteRule "cp2",url("cp2"),"ctl=coupon&page={$page}" : rewriteRule "cp3",url("cp3"),"ctl=coupon&id={$id}" : rewriteRule "s1",url("s1"),"ctl=shop" : rewriteRule "ct",url("ct"),"ctl=cart" : rewriteRule "e1",url("e1"),"ctl=error404"
	end function
	public function URLRewriteInit()
		call addRewriteRule()
		dim rule,m,ms,subM,v
		if ruleCount=0 or OW.isNul(oURLRewrite) then exit function
		for each rule in oURLRewrite
			sRule = oURLRewrite(rule)(0) : sRule = replace(sRule,"{$id}","(\d+)") : sRule = replace(sRule,"{$rootpath}","([\s\S]+?)") : sRule = replace(sRule,"{$urlpath}","([\s\S]+?)") : sRule = replace(sRule,"{$page}","(\d+)") : sRule = replace(sRule,"{$typeid}","([\s\S]+?)") : sRule = replace(sRule,"{$orderby}","([\s\S]+?)") : sRule = replace(sRule,"{$tag}","([\s\S]+?)")
			if OW.regTest(OW.currentURL,sRule) then
				isRewrite = true
				v = oURLRewrite(rule)(1)
				set ms = OW.getMatch(v,"({[\s\S]*?})")
				iI = 0
				for each m in ms
					iI = iI + 1
					v = replace(v,m.value,"$"& iI &"")
				next
				set ms = OW.getMatch(OW.currentURL,sRule)
				if ms.Count > 0 then sTempStr = ms(0).Value
				for each m in ms
					iI = 0
					for each subM in m.subMatches
						iI = iI + 1
						v = OW.regReplace(v,"(\$"& iI &")",subM)
					next
				next
				set ms = nothing
				URLQueryString = v
			end if
		next
	end function
	public function anonymousName(byval s)
		anonymousName = OW.left(s,1) &"****"& OW.right(s,1)
	end function
	public function anonymousEmail(byval s)
		dim i,elen,ename,esufx,anonys
		ename = OW.cLeft(s,"@")
		esufx = OW.cRight(s,"@")
		elen  = OW.int(OW.len(ename)/3)
		for i=1 to (OW.len(ename)-elen-elen-1)
			anonys = anonys &"*"
		next
		anonymousEmail = OW.left(ename,elen+1) & anonys & OW.right(ename,elen) &"@"& esufx
	end function
	public function arrSort(byval arr)
		dim nCount,i,j,minmax,minmaxSlot,mark,temp
		nCount = ubound(arr)
		for i = nCount to 0 Step -1
			minmax     = arr(0)
			minmaxSlot = 0
			for j=1 to i
				mark = (arr(j) > minmax)
				if mark then 
					minmax = arr( j )
					minmaxSlot = j
				end If
			next
			If minmaxSlot<>i Then 
				temp = arr(minmaxSlot)
				arr(minmaxSlot) = arr(i)
				arr(i) = temp
			end If
		next
		arrSort = arr
	end function
	public function clientUserDataDecode(byval s)
		dim i,l,code
		l = len(s)
		s = OW.right(s,l-2)
		s = OW.reps(s,".","=")
		s = OW.reps(s,"1L1LWA","a")
		s = OW.reps(s,"2Z2ZWB","b")
		s = OW.reps(s,"3V3VWC","c")
		s = OW.reps(s,"4X4XWD","d")
		s = OW.reps(s,"5Y5YWD","e")
		s = OW.base64Decode(s)
		clientUserDataDecode = s
	end function
	public function stringtobytes(byval t0)
		on error resume next
		dim stream
		set stream = server.createobject("adodb.stream")
		with stream
			.type = 2
			.charset = "utf-8"
			.open
			.writetext t0
			.position = 0
			.type = 1
			.read 3
			stringtobytes = .read(-1)
			.close
		end with
		if err.number<>0 then err.clear
	end function
	public function bytestostring(byval t0)
		on error resume next
		dim stream
		set stream = server.createobject("adodb.stream")
		with stream
			.type = 1
			.open
			.write t0
			.position = 0
			.type = 2
			.charset = "utf-8"
			bytestostring = .readtext(-1)
			.close
		end with
		if err.number<>0 then err.clear
	end function
		
	public function base64Encode(byval t0)
		on error resume next
		dim t1,t2
		set t1 = server.createobject("msxml2.domdocument")
		set t2 = t1.createelement("b64")
		t2.datatype = "bin.base64"
		if vartype(t0) = (vbbyte or vbarray) then
			t2.nodetypedvalue = t0
		else
			t2.nodetypedvalue = stringtobytes(t0)
		end if
		base64Encode = t2.text
		set t2 = nothing
		set t1 = nothing
		if err.number<>0 then err.clear
	end function
	public function base64Decode(byval t0)
		on error resume next
		dim t1,t2
		set t1 = server.createobject("msxml2.domdocument")
		set t2 = t1.createelement("b64")
		t2.datatype = "bin.base64"
		t2.text = t0
		base64Decode = bytestostring(t2.nodetypedvalue)
		set t2 = nothing
		set t1 = nothing
		if err.number<>0 then err.clear
	end function

	'返回bool值
	public function cbool(str)
		on error resume next
		str=VBS.cbool_(str)
		if err.number <> 0 then
			str=false
			err.clear
		end if
		[cbool]=str
	end function
	public function checkIsMobileAgent()
		dim str
		str = lcase(request.servervariables("http_user_agent"))
        if instr(str,"mobile")>0 then
			isMobile = true
		end if
	end function
	public function createSubDomain(byval subs,byval domain)
		dim arr,subDomain
		arr = split(domain,".")
		if ubound(arr)>1 then
			subDomain = subs &"."& cRight(domain,".")
		else
			subDomain = subs &"."& domain
		end if
		createSubDomain = subDomain
	end function
	public function createXMLDoc(byval s)
		if s="" then
			set createXMLDoc = server.createObject("msxml2.FreeThreadedDOMDocument"& XML_VERSION &"")
		else
			set createXMLDoc = server.createObject(s)
		end if
		createXMLDoc.async = false
	end function
	public function cLeft(byval str,byval st)
		dim s,l
		l = instr(str,st)
		if l>=1 then
			s = OW.left(str,l-1)
		else
			s = str
		end if
		cLeft = trim(s)
	end function
	public function cRight(byval str,byval st)
		dim s,l
		l = instr(str,st)
		if l>=1 then
			s = mid(str,l+1)
		else
			s = ""
		end if
		cRight = trim(s)
	end function
	public function cutString(byval StrText,byval cutStart,byval Strlen)
		dim str,l,t,c,i
		str=StrText
		cutStart=int(regReplace(cutStart,"[^0-9,]",""))
		if cutStart<1 then cutStart=1
		l=Len(str)
		t=0
		for i=1 to l
			c=Abs(ascw(mid(str,i,1)))
			if c>255 then'一个汉字占两个字节
				t=t+2
			else
				t=t+1
			end if
			if t>=Strlen then
				cutString = mid(str, cutStart, i) 
				exit for
			else
				cutString=str
			end if
		next
		cutString=replace(cutString,chr(10),"")'替换换行符
		cutString=replace(cutString,chr(13),"")'替换回车符
	end function
	public function [dateDiff](byval t, byval d1, byval d2)
		[dateDiff] = VBS.dateDiff_(t,d1,d2)
	end function
	public function [dateAdd](byval t, byval n, byval d)
		[dateAdd] = VBS.dateAdd_(t,n,d)
	end function
	public function echoJsCode(byval s)
		echo "<script type=""text/javascript"">"& s &"</script>"
	end function
	public function echoAdImg(byval id,byval tpls)
		dim i,jn,s,ss,htmls
		id = OW.int(id)
		s  = OS.getAdData(id,"json_data")
		if OW.isNul(s) then exit function
		set jn = OW.JSON.parse(s)
		for i=0 to jn.length-1
			ss = replace(tpls,"{$i}",i+1)
			ss = replace(ss,"{$name}",jn.get(i).name)
			ss = replace(ss,"{$url}",jn.get(i).url)
			ss = replace(ss,"{$link}",jn.get(i).link)
			htmls = htmls & ss
		next
		echoAdImg = htmls
	end function
	public function echoImages(byval s,byval tpls)
		dim i,jn,ss,htmls
		if OW.isNul(s) then exit function
		s = dbDataDecode(s)
		set jn = OW.JSON.parse(s)
		for i=0 to jn.length-1
			ss = replace(tpls,"{$i}",i+1)
			ss = replace(ss,"{$name}",jn.get(i).name)
			ss = replace(ss,"{$url}",jn.get(i).url)
			htmls = htmls & ss
		next
		echoImages = htmls
	end function
	
	'编辑器文本编码
	public function editorContentEncode(byval s)
		if OW.isNul(s) then editorContentEncode="" : exit function
		s = OW.validDBData(s,0)
		s = reps(s,"<","&lt;")
		s = reps(s,">","&gt;")
		editorContentEncode = s
	end function
	
	'编辑器文本解码
	public function editorContentDecode(byval s)
		if OW.isNul(s) then editorContentDecode="" : exit function
		dim v,code,match,matches
		s = OW.dbDataDecode(s)
		oRegExp.pattern = "&lt;pre([\s\S]*?)&gt;([\s\S]*?)&lt;/pre&gt;"
		set matches = oRegExp.Execute(s)
		for each match in matches
			v    = match.subMatches(1)
			code = v
			code = replace(code,"&nbsp;"," ")
			code = replace(code,"""","&quot;")
			code = replace(code,"&","&amp;")
			s = OW.replaceString(s,v,code)
		next
		editorContentDecode = s
	end function
	public function editorContentClientDecode(byval s)
		if OW.isNul(s) then editorContentClientDecode="" : exit function
		dim v,code,m,ms,match,matches
		s = OW.dbDataDecode(s)
		s = reps(s,"&lt;","<")
		s = reps(s,"&gt;",">")
		set ms = OW.getMatch(s,"<pre([\s\S]*?)>([\s\S]*?)</pre>")
		if ms.count>0 then
			for each m in ms
				v = m.subMatches(1)
				v = replace(v,"<","&lt;")
				v = replace(v,">","&gt;")
				s = replace(s,m.subMatches(1),v)
			next
		end if
		set ms = nothing
		s = reps(s,"&nbsp;"," ")
		editorContentClientDecode = s
	end function
	public function escape(byval str)
		if isNul(str) then escape="" : exit function
		dim i,s,c,a
		for i=1 to len(str)
			c = mid(str, i, 1)
			a = Ascw(c)
			if (a>=48 and a<=57) or (a>=65 and a<=90) or (a>=97 and a<=122) or instr("@*_+-./", c)>0 then
				s = s & c
			ElseIf a>0 and a<16 then
				s = s &"%0"& Hex(a)
			elseIf a>=16 and a<256 then
				s = s &"%"& Hex(a)
			else
				s = s &"%u"& Hex(a)
			end if
		next
		escape = s
	end function
	public function formatDouble(byval str)
		'on error resume next
		str = trim(str)
		if isNul(str) or str="." then formatDouble=0 : exit function
		str = cstr(str)
		dim symbol,l
		if left(str,1) = "-" then symbol="-"
		str = regReplace(str,"[^0-9.]","")
		if isNul(str) then formatDouble=0 : exit function
		aArray = split(str,".")
		l = ubound(aArray)
		if l>=2 then
			if not(isNul(aArray(0))) then str=aArray(0)&"."&aArray(1)
		end if
		str = trim(str)
		if str="." then formatDouble=0 : exit function
		str = cdbl(str)
		'if err then die "["& str &"]"
		if isNul(str) then str=0
		if str<>0 then str = symbol & str
		formatDouble= cdbl(str)
	end function
	public function [formatCurrency](byval float)
		if isNul(float) or float=0 then [FormatCurrency]="0.00" : exit function
		[formatCurrency] = mid(replace(VBS.formatCurrency_(float,2),",",""),2)
	end function
	public function [formatDateTime](byval d,byval t)
		if d="" or isNull(d) then exit function
		dim yyyy,mm,dd,hh,mn,ss
		if not isDate(d) then
			d = SYS_TIME
		end if
		'**
		d    = cdate(d)
		yyyy = year(d)
		mm   = month(d)
		dd   = day(d)
		hh   = hour(d)
		mn   = minute(d)
		ss   = second(d)
		if mm<10 then mm = 0 & mm
		if dd<10 then dd = 0 & dd
		if hh<10 then hh = 0 & hh
		if mn<10 then mn = 0 & mn
		if ss<10 then ss = 0 & ss
		if not(OW.isNum(t)) then t = lcase(t)
		select case t
			case "0","yyyy-mm-dd hh:mm:ss","yyyy-mm-dd hh:mn:ss"
			   d = yyyy &"-"& mm &"-"& dd &" "& hh &":"& mn &":"& ss
			case "1","yyyy/mm/dd"
			   d = yyyy&"/"&mm&"/"&dd&""
			case "2","yyyy-mm-dd"
			   d = yyyy &"-"& mm &"-"& dd
			case "3","上午/下午 hh:mm:ss","上午/下午 hh:mn:ss"
			   if cint(hh)<12 then
				   d = "上午 "& hh &":"& mn &":"& ss
			   elseif cint(hh)=12 then
				   d = "下午 "& hh &":"& mn &":"& ss
			   else
				   hh=cint(hh)-12
				   if len(hh)=1 then hh=0&hh
				   d = "下午 "& hh &":"& mn &":"& ss
			   end if
			case "4","hh:mm:ss","hh:mn:ss"
			   d = hh&":"& mn &":"& ss
			case "5","yyyy"
			   d = yyyy
			case "6","mm"
			   d = mm
			case "7","dd"
			   d = dd
			case "8","yyyymmdd"
			   d = yyyy&mm&dd
			case "9","yyyymmddhhmnss"
			   d = yyyy&mm&dd& hh & mn & ss
			case "10","hh"
			   d = hh
			case "11","mn"
			   d = mn
			case "12","ss"
			   d = ss
		end select
		[formatDateTime] = d
    end function
	function formatSize(tSize)
		if tSize>=1073741824 then
			formatSize=int((tSize/1073741824)*1000)/1000 & " GB"
		elseIf tSize>=1048576 then
			formatSize=int((tSize/1048576)*1000)/1000 & " MB"
		elseIf tSize>=1024 then
			formatSize=int((tSize/1024)*1000)/1000 & " KB"
		else
			formatSize=tSize & "B"
		end if
	end function
	public function formatToFixNumber(l,i)
		l = OW.int(l)
		i = OW.int(i)
		formatToFixNumber=0
		if l < 1  or l <= Len(i) then
			formatToFixNumber = i
			exit function
		end if
		dim ii
		for ii=1 To (l-Len(i))
			i = 0 & i
		next
		formatToFixNumber = i
	end function
	public function getClientAgent()
		getClientAgent = request.serverVariables("HTTP_USER_AGENT") 
	end function
	public function getForm(byval getType, byval element)
		on error resume next
		getType=lcase(getType)
		dim s,e
		select case getType
			case "get","both"
				if isRewrite and URLQueryString<>"" then
					aArray = split(URLQueryString,"&")
					element = lcase(element)
					for iI = 0 To ubound(aArray)
						iLen = instr(aArray(iI),"=")
						if iLen > 0 then
						    e = lcase(left(aArray(iI),iLen-1))
							if element = e then s = mid(aArray(iI),iLen+1)
						end if
					next
				end if
				if s="" then s = request.queryString(element)
				if getType="both" and s="" then s = request.form(element)
			case "post"
				s = request.form(element)
		end select
		getForm = OW.trim(s)
		if err.number<>0 then err.clear
	end function
	public function getFileExName(byval filePath)
		dim a,ex
		filePath = replace(filePath,chr(0),"")
		if instr(filePath,".")>0 then
			a  = split(filePath,".")
			ex = a(ubound(a))
		else
			ex = ""
		end if
		getFileExName = lcase(ex)
	end function
	public function getFileName(byval filePath, byval haveExName)
		dim arr,s
		filePath = replace(filePath,chr(0),"")
		if filePath="" then getFileName="" : exit function
		if instr(filePath,"/")>0 then
			arr = split(filePath,"/")
			s   = arr(ubound(arr))
		elseIf instr(filePath,"\")>0 then
			arr = split(filePath,"\")
			s = arr(ubound(arr))
		else
			s = filePath
		end if
		if not(haveExName) then
			s = left(s,instrRev(s,".")-1)
		end if
		getFileName = s
	end function
	public function getFolderName(byval folderPath)
		dim i,arr,s
		folderPath = replace(folderPath,chr(0),"")
		if instr(folderPath,"/")>0 then
			arr = split(folderPath,"/")
			for i=ubound(arr) To 0 step -1
				if trim(arr(i))<>"" then
					s = trim(arr(i))
					exit for
				end if
			next
		end if
		getFolderName = s
	end function
	public function getFolderPath(byval filePath)
		dim i,arr,s,path
		filePath = replace(filePath,chr(0),"")
		if instr(filePath,"/")>0 then
			arr = split(filePath,"/")
			for i=0 to ubound(arr)-1
				if trim(arr(i))<>"" then
					s = trim(arr(i))
				end if
				path = path & s &"/"
			next
		else
			path = "/"
		end if
		if OW.right(path,1)<>"/" then path = path &"/"
		getFolderPath = path
	end function
	public function getClientIP()
		dim ip
		ip = request.serverVariables("HTTP_X_FORWARDED_FOR")
		if OW.isNul(ip) or lcase(ip)="unknown" then
			ip = request.serverVariables("REMOTE_ADDR")
		end if
		if not(instr(ip,".")>0) then ip = "0.0.0.0"
		getClientIP = ip
	end function
	public function getServerIP()
		dim ip
		ip = request.serverVariables("LOCAL_ADDR")
		if not(instr(ip,".")>0) then ip = "0.0.0.0"
		getServerIP = ip
	end function
	public function getServerVariables(byval s)
		getServerVariables = lcase(request.serverVariables(s))
	end function
	
	'来源地址
	public function getReferer()
		getReferer = request.serverVariables("HTTP_REFERER")
	end function
	
	'获取当前的域名
	'dev.openwbs.com = OW.getDomain("")
	'en.dev.openwbs.com = OW.getDomain("http://en.devo.openwbs.com/cms/")
	public function getDomain(byval url)
		if url="" then
			getDomain = lcase(request.serverVariables("SERVER_NAME"))
		else
			aArray   = split(url,"/")
			iLen     = ubound(aArray)
			if iLen>=2 then
				getDomain = aArray(2)
			end if
		end if
	end function
	
	'获取当前的端口
	public function getPort()
		getPort = request.serverVariables("SERVER_PORT")
	end function

	'从url获取当前的网站所在目录
	'/openwbs/en/ = OW.getSitePath("http://www.openwbs.com/openwbs/en/")
	public function getSitePath(byval url)
		dim path,s
		if url="" then
			path=""
		else
			aArray   = split(url,"/")
			iLen     = ubound(aArray)
			if iLen>=3 then
				for iI=3 to iLen
					s = aArray(iI)
					if s<>"" then
						path = path &"/"& s
					end if
				next
			end if
		end if
		getSitePath = path &"/"
	end function
	public function getSiteURL()
		dim http,port,url
		port = OW.getPort()
		if lcase(request.serverVariables("HTTPS"))="off" then
			http="http://"
		else
			http="https://"
		end if
		url = http & OW.getDomain("")
		if port<>80 then
			url = url &":"& port
		end if
		getSiteURL = url & getCurrentPagePath()
	end function
	
	'获取当前页面的相对网站路径
	'OW.getCurrentPagePath()
	public function getCurrentPagePath()
		dim url
		url      = lcase(request.serverVariables("url")) '/openwbs/install/index.asp
		aArray   = split(url,"/")
		iLen     = ubound(aArray)
		sTempStr = ""
		if iLen>0 then
			for iI=1 to iLen-1
				sTempStr = sTempStr &"/"& aArray(iI)
			next
		end if
		getCurrentPagePath = sTempStr &"/"
	end function

	'获取当前页面URL
	'getURL("")              http://www.openwbs.com/news/index.asp?action=news&page=1&user=phenex  (包括端口和参数)
	'getURL(0)               /news/index.asp
	'getURL(1)               /news/index.asp?action=news&page=1&user=phenex
	'getURL(2)               /news/
	'getURL("action")        http://www.openwbs.com/news/index.asp?action=news
	'getURL("action,type")   http://www.openwbs.com/news/index.asp?action=news&type=
	'getURL("-action,-page") http://www.openwbs.com/news/index.asp?user=phenex
	public function getURL(byval t)
		dim u,i,h,d,p,su,dir,para
		if lcase(request.serverVariables("HTTPS"))="off" then h = "http://" : else : h = "https://" : end if
		d = request.serverVariables("SERVER_NAME")
		if request.serverVariables("SERVER_PORT")<>80 then p = ":"& request.serverVariables("SERVER_PORT")
		su  = request.serverVariables("URL")
		dir = left(su,instrRev(su,"/"))
		if trim(request.queryString)<>"" then
			para = "?"& trim(request.queryString)
		else
			para = ""
		end if
		if trim(t)<>"" then
			t=cstr(t)
			select case t
				case "0"
					u = su
				case "1"
					u = su & para
				case "2"
					u = dir
				case else
					dim QSItem,arr,param
					arr = split(t,",")
					param = "?"
					for i=0 To ubound(arr)
						QSItem=trim(arr(i))
						if instr(QSItem,"-") = 1 then
							QSItem    = mid(QSItem,2)
							para  = OW.regReplace(para,""& QSItem &"=[^&]*","")
							para  = replace(para,"?&","?")
							para  = replace(para,"&&","&")
							param = para
							para  = param
						else
							if not(OW.regTest(param,""&QSItem&"=[^&]")) then
								QSItem = QSItem &"="& request.queryString(QSItem)
								if i > 0 then QSItem = "&"& QSItem
								param = param & QSItem
							end if
						end if
					next
					para=param
					u=h & d & p & su & para
			end select
		else
			u=h & d & p & su & para
		end if
		getURL = u
	end function
	
	'获取内容中第一张图片URL
	public function getFirstImgURL(byval str)
		getFirstImgURL = getImgURLs(str)(0)
	end function
	
	private function getImgs(byval str, byval t)
		dim arr,i,rule,m,ms
		rule = "<img([^>]+?)(/?)>"
		i = 0
		redim arr(-1)
		if not(OW.isNul(str)) and OW.regTest(str,rule) then
			str = replace(str,vbCrLf," ")
			str = replace(str,vbTab," ")
			set ms = OW.getMatch(str,"(<img\s[^>]*src\s*=\s*([""|']?))([^""'>]+)(\2[^>]*>)")
			for each m in ms
				redim preserve arr(i)
				arr(i) = OW.iif(t=0,m.subMatches(2),m.Value)
				i = i + 1
			next
		end if
		getImgs = arr
	end function
	
	'取得图片URL(返回值为数组)
	public function getImgURLs(byval str)
		getImgURLs = getImgs(str,0)
	end function
	
	'取得图片整个标签(返回值为数组)
	public function getImgTags(byval str)
		getImgTags = getImgs(str,1)
	end function
	
	'正则匹配
	'set ms = OW.getMatch(string,"^([\s\S]*?){nav:loop}([\s\S]+?){/nav:loop}([\s\S]*?)$")
	public function getMatch(byval str, byval rule)
		dim re
		set re = oRegExp
		re.ignoreCase = true
		re.global     = true
		re.pattern    = ""& rule &""
		set getMatch  = re.execute(str)
		set re = nothing
	end function
	public function getOWSString(byval st)
		dim str
		select case st
		case "sms" : str = smsString
		case "smsrd" : str = "Z2V0U21"&"zUmVtYWluZGVyID0gT1cuc21zUmVtYWluZGVyKCk"
		case else
		end select
		getOWSString = OW.Base64.decode(str)
	end function
	
	'msg = OW.getSubMatches(string,"""msg"":""([\s\S]*?)""")(0,0)
	public function getSubMatches(byval str, byval rule)
		on error resume next
		dim i,j,m,ms,subM,arr
		i = 0
		j = 0
		set ms = getMatch(str,rule)
		if ms.Count > 0 then 
			reDim arr(ms(0).subMatches.count,ms.count)
			for each m in ms
				j = 0
				for each subM in m.subMatches
					arr(j,i) = subM
					j = j + 1
				next
				i = i+1
			next
		else
			reDim arr(1,1)
		end if
		set ms = nothing
		if err.number <> 0 then
			err.clear
			getSubMatches = nothing
		else
			getSubMatches = arr
		end if
	end function
	
	'OW.getSubString("string",":","}","")
	public function getSubString(byval str,byval s1,byval s2,byval t)
		dim l1,l2
		select case t
		case "start"
			l1 = instr(str,s1)+Len(s1)
			l2 = len(str)+1
		case "end"
			l1 = 1
			l2 = instr(l1,str,s2)
		case else
			l1 = instr(str,s1)+Len(s1)
			l2 = instr(l1,str,s2)
		end select
		getSubString = mid(str,l1,l2-l1) 
	End Function
	public function getStringByMatch(byval str,byval rule,byval area)
		if str="" or rule="" or area="" then getStringByMatch = "" : exit function
		rule = replace(rule,area,"([\s\S]*?)")
		getStringByMatch = OW.getSubMatches(str,rule)(0,0)
	end function
	public function getTimeStamp()
		getTimeStamp = OW.left(OW.dateDiff("s","1970-1-1 00:00:00",now()),10)
	end function
	public function getNonceStr()
		getNonceStr = lcase(OW.randsn(16))
	end function
	public function getODataKeyValue(s,k)
		if OW.isNul(s) then getODataKeyValue = "" : exit function
		dim data
		data = OW.getStringByMatch(s,""""& k &""":""[list]""","[list]")
		data = OW.unEscape(data)
		getODataKeyValue = data
	end function
	public function [HTMLEncode](byval str)
		if trim(str)="" or isNull(str) then exit function
		'str = replace(str,chr(13)&chr(10),"<br/>")'chr(13)是回车符
		'str = replace(str, chr(10),"<br/>")'chr(10)是换行符
		str = replace(str,"%","&#037;")
		str = replace(str,"<","&lt;")
		str = replace(str,">","&gt;")
		str = replace(str,chr(32), "&nbsp;")'chr(32)是一个空格符
		str = replace(str,chr(34), "&quot;")'chr(34)是英文双引号
		str = replace(str,chr(39), "&#39;")'chr(39)是英文单引号
		'str = replace(str, chr(9), "&nbsp;&nbsp;&nbsp;")'chr(9)是制表符
		[HTMLEncode]=str
	end function
	
	function HTMLDecode(byval str)
		if trim(str)="" or isNull(str) then exit function
		str = replace(str,"&#037;","%")
		str = replace(str,"&quot;",chr(34))
		str = replace(str,"&nbsp;",chr(32))
		str = replace(str,"&#39;",chr(39))
		str = replace(str,"&apos;",chr(39))
		str = replace(str,"&gt;",">")
		str = replace(str,"&lt;","<")
		str = replace(str,"&amp;",chr(38))
		str = replace(str,"&#38;",chr(38))'chr(38):&
		HTMLDecode = str
	end function
	
	'过滤HTML标记
	public function HTMLReplace(byval s)
	    if s = "" or isnull(s) then
			replaceHTML = ""
			exit function
		end if
		oRegExp.ignoreCase = true
		oRegExp.global = true
		oRegExp.pattern = "<(.[^>]*)>"
		s = oRegExp.replace(s,"")
		replaceHTML = s
	end function
	public function HTMLTextTreat(strHtmlText,brExit,pExit,imgExit)
		brExit  = cbool(brExit)
		pExit   = cbool(pExit)
		imgExit = cbool(imgExit)
		dim strHtml
		oRegExp.ignoreCase=true
		oRegExp.global=true
		strHtml=strHtmlText
		
		if brExit then
			oRegExp.pattern="<br([^>]*)>"'br标签
			strHtml=oRegExp.replace(strHtml,"&lt;br&gt;")
			oRegExp.pattern="</br([^>]*)>"'br标签
			strHtml=oRegExp.replace(strHtml,"&lt;/br&gt;")
		end if
		if pExit then
			oRegExp.pattern="<p([^>]*)>"'P标签
			strHtml=oRegExp.replace(strHtml,"&lt;p&gt;")
			oRegExp.pattern="</p([^>]*)>"'P标签
			strHtml=oRegExp.replace(strHtml,"&lt;/p&gt;")
		end if
		if imgExit then
			oRegExp.pattern="<img"'img标签
			strHtml=oRegExp.replace(strHtml,"&lt;img")
		end if
		
		oRegExp.pattern="<style[^>]*>[\s\S]*?</style>"'过滤样式
		strHtml=oRegExp.replace(strHtml,"")
		oRegExp.pattern="<script[^>]*>[\s\S]*?</script>"'过滤js脚本
		strHtml=oRegExp.replace(strHtml,"")
		oRegExp.pattern="<(.[^>]*)>"'过滤html
		strHtml=oRegExp.replace(strHtml,"")
		
		if brExit then
			oRegExp.pattern="&lt;br&gt;"
			strHtml=oRegExp.replace(strHtml,"<br>")
			oRegExp.pattern="&lt;/br&gt;"
			strHtml=oRegExp.replace(strHtml,"</br>")
		end if
		if pExit then
			oRegExp.pattern="&lt;p&gt;"
			strHtml=oRegExp.replace(strHtml,"<p>")
			oRegExp.pattern="&lt;/p&gt;"
			strHtml=oRegExp.replace(strHtml,"</p>")
		end if
		if imgExit then
			oRegExp.pattern="&lt;img"
			strHtml=oRegExp.replace(strHtml,"<img")
		end if
		HTMLTextTreat=strHtml
	end function
	
	function iif(byval e, byval t, byval f)
		if e then
			iif = t
		else
			iif = f
		end if
	end function
	
	'返回整数(正整数和负整数),str为空时返回0
	public function [int](byval i)
		if isNul(i) then [int]=0 : exit function
		err.clear
		on error resume next
		i=VBS.int_(i)
		if err.number <> 0 then
			i = regReplace(i,"[^0-9]","")
			err.clear
		end if
		if i="" then i=0
		[int]=VBS.int_(i)
	end function
	
	'$ 返回已被转换为 Long 子类型的 Variant (即 -2,147,483,648 到 2,147,483,647 之间的整数), i为空时返回0
	public function [clng](byval i)
		i = [Int](i)
		if i > 2147483647  then i = 2147483647
		if i < -2147483647 then i = -2147483647
		[clng] = VBS.clng_(i)
	end function
	public sub include(byval filePath)
		on error resume next
		ExecuteGlobal includeCode(read(filePath),0)
		if err.number<>0 then
			[Error].Msg = "OW.include:<a href="""& SITE_PATH & filePath &""">"& filePath &"</a>"
			[Error].raise 3
			err.clear()
		end if
	end sub
	
	'include静态文件,文件必须是静态文件,否则报错.
	function includeHTMLFile(byval filePath)
		'on error resume next
		ExecuteGlobal includeCode(read(filePath),1)
		includeHTML = OW_S_HTML
		if err.number<>0 then
			[Error].Msg = "OW.getInclude:" & filePath & ""
			[Error].raise 1
			err.clear()
		end if
	end function
	
	'include处理read到的文件
	public function includeCode(byval text, byval isHtml)
		dim s,c,c1,c2,st,l
		c1 = ""
		if isHtml=1 then
			c2 = "OW_S_HTML = OW_S_HTML & "
		else
			c2 = "response.write "
		end if
		st  = 1
		l = instr(text,"<%") + 2
		while l > st + 1
			s = mid(text,st,l-st-2)
			st = instr(l,text,"%"&">") + 2
			if s<>"" then
				s = replace(s,"""","""""")
				s = replace(s,vbCrLf,"""&vbCrLf&""")
				c1 = c1 & c2 & """" & s & """" & vbCrLf
			end if
			s = mid(text,l,st-l-2)
			c = OW.regReplace(s,"^\s*=\s*",c2) & vbCrLf
			if isHtml = 1 then
				c = OW.regReplace(c,"response\.write([\( ])", c2 & "$1",1) & vbCrLf
				c = OW.regReplace(c,"response\.write([\( ])", c2 & "$2",1) & vbCrLf
			end if
			c1 = c1 & c
			l = instr(st,text,"<%") + 2
		wend
		s = mid(text,st)
		if not(OW.isNul(s)) then
			s = replace(s,"""","""""")
			s = replace(s,vbcrlf,"""&vbCrLf&""")
			c1 = c1 & c2 & """" & s & """" & vbCrLf
		end if
		if isHtml = 1 then c1 = "OW_S_HTML = """" " & vbCrLf & c1
		includeCode = OW.regReplace(c1,"(\n\s*\r)+",vbCrLf)
	end function
	public function indexOf(byval ss,byval s)
		if OW.isNul(ss) or OW.isNul(s) then indexOf = 0 : exit function
		indexOf = VBS.instr_(ss,s)
	end function
	
	'检查是否为16进制的颜色
	public function isColor(byval s)
		IsColor=false
		if isNul(s) then exit function
		oRegExp.ignoreCase=true
		oRegExp.global=true
		oRegExp.pattern="^#[0-9a-zA-Z]{6}$"
		if oRegExp.test(s) then IsColor=true
	end function
	
	'$ 检查Email是否合法(合法:返回true,不合法:返回false)
	public function isEmail(byval s)
	    if isNul(s) then IsEmail=false : exit function
		isEmail = regTest(s,"^\w+([-+\.]\w+)*@(([\da-zA-Z][\da-zA-Z-]{0,61})?[\da-zA-Z]\.)+([a-zA-Z]{2,4}(?:\.[a-zA-Z]{2})?)$")
	end function
	public function [isArray](byval arr)
		dim result
		if VBS.isArray_(arr) then
			result = true
		else
			result = false
		end if
		[isArray] = result
	end function
	public function isInArray(byval arr,byval s)
		dim i,result
		result = false
		if s="" then isInArray = result : exit function
		s = trim(s)
		if isArray(arr) then
			for i=0 to ubound(arr)
				if s=trim(arr(i)) then result = true : exit for
			next
		else
			if trim(arr)=s then result = true
		end if
		isInArray = result
	end function
	public function isImage(byval filepath)
		dim ex
		if OW.isNul(filepath) then isImage=false : exit function
		ex = OW.getFileExName(filepath)
		if ex="jpg" or ex="jpeg" or ex="gif" or ex="png" or ex="bmp" then
			isImage = true
		else
			isImage = false
		end if
	end function
	public function isMultArray(byval arr)
		dim i,result
		on error resume next
		i = ubound(arr,2)
		if err.number <> 0 then
			err.clear
			result = false
		else
			result = true
		end if
		isMultArray = result
	end function
	
	
	'返回 Boolean 值，判断 str 是否不包含任何有效数据
	public function isNul(byval s)
		isNul = false
		select case varType(s)
			case vbEmpty, vbNull
				isNul = true : exit function
			case vbObject
				select case TypeName(s)
					case "Nothing","Empty"
						isNul = true : exit function
					case "Recordset"
						if s.State = 0 then isNul = true : exit function
						if s.Bof and s.Eof then isNul = true : exit function
					case "Dictionary"
						if s.Count = 0 then isNul = true : exit function
				end select
			case vbArray,8194,8204,8209
				if ubound(s)=-1 then isNul = true : exit function
			case else
				if isNull(s) then isNul = true : exit function
				s=replace(s,chr(9),"")'chr(9)是制表符
				s=replace(s,chr(10),"")'chr(10)是换行符
				s=replace(s,chr(32),"")'chr(32)是一个空格符
				s=replace(s,chr(13),"")'chr(13)是回车符
				's=replace(s,chr(255),"")'chr(255)是一个特殊空格符(在iis5下会把数字直接当成空，不知道什么原因，暂时先注释掉)
				if trim(s)="" then isNul = true
		end select
	end function
	public function isNotNul(byval s)
		isNotNul = not(isNul(s))
	end function
	
	
	'$ isNum(s) 返回 Boolean 值，判断 s 的值是否为数字
	public function isNum(byval s)
		if isNul(s) then
			isNum = false
		else
			isNum = isnumeric(s)
		end if
	end function
	public function isStringExist(byval str,byval s)
        if str="" or s="" then
			isStringExist = false
		else
			if instr(str,s)>0 then isStringExist = true
		end if
	end function
	public function isRemoteURL(byval s)
		if instr(s,"http")>0 then
			isRemoteURL = true
		else
			isRemoteURL = false
		end if
	end function
	public function isValidDatetime(byval d)
		if OW.isNul(d) then isValidDatetime = false : exit function
		if OW.formatDateTime(d,5)="1900" then
			isValidDatetime = false
		else
			isValidDatetime = true
		end if
	end function
	
	'非法提交数据则输出错误提示(防止从本站外部提交数据)
	public function invalidClientPost()
		if not(OW.validClientPost()) then
			sErrMsg = sErrMsg & "[Local:"& OW.URLDecode(getURL("")) &";From:"& cstr(request.serverVariables("HTTP_REFERER")) &" ]" 
			[Error].Msg = sErrMsg
			[Error].raise 6
			Error.clear
		else
			invalidClientPost = false
		end IF
	end function
	public function isValidMobile(byval str)
		dim result : result = false
		if len(str)=11 and OW.left(str,1)="1" then
			result = true
		end if
		isValidMobile = result
	end function
	public function isValidHex(byval str)
		if OW.isNul(str) then isValidHex = false : exit function
		dim c
		isValidHex=true
		str=ucase(str)
		if len(str)<>3 then isValidHex=false:exit function
		if left(str,1)<>"%" then isValidHex=false:exit function
		c=mid(str,2,1)
		if not (((c>="0") and (c<="9")) or ((c>="A") and (c<="Z"))) then isValidHex = false : exit function
		c=mid(str,3,1)
		if not (((c>="0") and (c<="9")) or ((c>="A") and (c<="Z"))) then isValidHex = false : exit function
	end function
	public function isWeixinAgent()
		dim str
		str = lcase(request.servervariables("http_user_agent"))
        if instr(str,"micromessenger")>0 then
			isWeixinAgent = true
		else
			isWeixinAgent = false
		end if
	end function
	
	'检查组件是否已经安装
	public function isObjInstalled(byval str)
		on error resume next
		err.clear()
		dim obj
		set obj = server.createObject(str)
		if err.number = 0 then
			isObjInstalled = true
		else
			isObjInstalled = false
		end if
		set obj = nothing
		err.clear()
	end function
	public function join(byval arr,byval spl)
		dim i,s
		if isArray(arr) then
			for i=0 to ubound(arr)
				if arr(i)<>"" then
					if s="" then
						s = arr(i)
					else
						s = s & spl & arr(i)
					end if
				end if
			next
		else
			s = arr
		end if
		join = s
	end function
	
	'OW.leftString("string",5)
	public function leftString(byval str,byval l)
		dim length
		length = OW.len(str)
		str    = OW.left(str,l)
		if length>l then str = str &" ..."
		leftString = str
	end function
	
	'OW.left("string",5)
	public function [left](byval str, byval l)
		err.clear : on error resume next
		if isNul(str) then [left]="" : exit function
		str = VBS.left_(str,l)
		if err.number <> 0 then str="" : err.clear
		[left] = str
	end function
	public function [len](byval str)
		if isNul(str) then [len]=0 : exit function
		[len] = VBS.len_(str)
	end function
	public function loadXML(byval filePath)
		
	end function
	public function ODataBuilder()
		set ODataBuilder = new OW_ODataBuilder_Class
	end function
	public function okData(byval data)
		on error resume next
		if isNul(data) then
			data = ""
		end if
		if err.number <> 0 then err.clear
		okData = data
	end function
	public function parseBillId(byval s)
		parseBillId = OW.left(OW.regReplace(s,"[^0-9]",""),20)
	end function
	public function parseBankCode(byval s)
		s = OW.left(OW.regReplace(s,"[^0-9a-zA-Z_-]",""),64)
		parseBankCode = s
	end function
	public function parseCouponCode(byval s)
		s = OW.left(OW.regReplace(s,"[^0-9a-zA-Z]",""),20)
		parseCouponCode = s
	end function
	
	'返回16进制颜色(如:#02DF4C)
	public function parseColor(byval s)
		s = trim(s)
		if OW.left(s,1) = "#" then s = mid(s,2,Len(s)-1)
		s = OW.regReplace(s,"[^0-9a-zA-Z]","")
		if len(s)<>3 and len(s)<>6 then
			parseColor = "#000000"
		else
			parseColor = "#" & OW.left(s,6)
		end if
	end function
	public function parseFloat(byval float,byval decLen)
		dim arr
		float = OW.formatDouble(float)
		if decLen<>"" then
			float = ""& float &""
			if instr(float,".")>0 then
				arr   = split(float,".")
				if decLen>0 then
					float = arr(0) &"."& left(arr(1),decLen)
				else
					float = arr(0)
				end if
			end if
		end if
		if left(float,1)="." then float = "0"& float
		parseFloat = cdbl(float)
	end function
	
	'过滤掉不合法的文件夹字符
	'images = OW.parseFolderName("*i?m"|%^<>ages")
	public function parseFolderName(byval s)
		s = replace(s,chr(0),"")
		s = replace(s," ","")
		s = replace(s,chr(32),"")
		s = replace(s,"&nbsp;","")
		s = replace(s,"*","")
		s = replace(s,"?","")
		s = replace(s,"%","")
		s = replace(s,"&","")
		s = replace(s,":","")
		s = replace(s,"\","")
		s = replace(s,"/","")
		s = replace(s,"""","")
		s = replace(s,"|","")
		s = replace(s,"^","")
		s = replace(s,"<","")
		s = replace(s,">","")
		parseFolderName = s
	end function
	
	'返回正确的文件夹路径()
	'attachment/image/ = OW.parseFolderPath("/attachment/im%^ages")
	'/ = OW.parseFolderPath("")
	public function parseFolderPath(byval s)
		s = replace(s,chr(0),"")
		if s="" then
			parseFolderPath = "/"
		else
			s = replace(s," ","")
			s = replace(s,chr(32),"")
			s = replace(s,"&nbsp;","")
			s = replace(s,"\","")
			s = replace(s,":","")
			s = replace(s,"*","")
			s = replace(s,"?","")
			s = replace(s,"""","")
			s = replace(s,"|","")
			s = replace(s,"<","")
			s = replace(s,">","")
			s = OW.regReplace(s,"[/]+","/")
			if left(s,1)   = "/" then s = mid(s,2)
			if right(s,1) <> "/" then s = s &"/"
			parseFolderPath = s
		end if
	end function
	public function parseForbidFileEx(byval s)
		dim arr,i,fileEx,ss
		s   = replace(s,chr(0),"")
		arr = split(s,";")
		for i=0 to ubound(arr)
			fileEx = arr(i)
			fileEx = lcase(replace(fileEx," ",""))
			if not(fileEx="" or instr(fileEx,".as")>0 or instr(fileEx,".inc")>0 or instr(fileEx,".bat")>0 or instr(fileEx,".vb")>0 or instr(fileEx,".sh")>0 or instr(fileEx,".php")>0 or instr(fileEx,".js")>0  or instr(fileEx,".java")>0 or instr(fileEx,".exe")>0) then
				ss = OW.iif(ss="",fileEx,ss &";"& fileEx)
			end if
		next
		parseForbidFileEx = ss
	end function
	public function parseIds(byval str)
		str = OW.regReplace(str,"[^0-9,]","")
		str = OW.regReplace(str,"(,{2,})",",")
		if left(str,1)="," then str = mid(str,2)
		if right(str,1)="," then str = left(str,Len(str)-1)
		parseIds = str
	end function
	
	'处理IP格式,检查IP是否合法,不合法的IP返回0.0.0.0
	public function parseIP(byval str)
		oRegExp.ignoreCase = true
		oRegExp.global     = true
		oRegExp.pattern    = "^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$"
		if oRegExp.test(str) then
			parseIP = str
		else
			parseIP = "0.0.0.0"
		end if
	end function
	
	' 0  = OW.parseMoney("")
	' -1 = OW.parseMoney("-1")
	' 10 = OW.parseMoney("$10")
	public function parseMoney(byval float)
		parseMoney = OW.parseFloat(float,2)
	end function
	public function parsePrice(byval s)
		if OW.isNul(s) or s="0" then
			parsePrice = "0.00"
			exit function
		end if
		if not(instr(s,".")>0) then
			s = s &".00"
		else
			if len(split(s,".")(1))=1 then
				s = s &"0"
			end if
		end if
		if instr(s,".")=1 then
			s = "0"& s
		end if
		parsePrice = s
	end function
	
	'处理系统运行时间格式,单位(s)
	public function parseRuntime(byval timeStr)
		if isNull(timeStr) or timeStr="" then
			parseRuntime="0.00"
		else
			timeStr = FormatNumber(timeStr,4)
			if instr(1,timeStr,".") <= 1 then timeStr= "0" & timeStr
			parseRuntime=timeStr
		end if
	end function
	
	'返回正确的MetaDescription
	public function parseMetaDescription(byval s)
		if OW.isNul(s) then parseMetaDescription="" : exit function
		s = OW.HTMLTextTreat(s,true,false,false)
		s = OW.HTMLEncode(replace(s,"	",""))
		s = replace(s,"&lt;br/&gt;","")
		parseMetaDescription = OW.left(s,250)
	end function

	'返回2个元素的数组(以:分割)
	'arr = OW.param("ow_sites:10:site_id,site_name")
	'ow_sites = arr(0)
	'10:site_id,site_name = arr(0)
	public function param(byval str)
		dim l,arr(1)
		l = instr(str,":")
		if l > 0 then
			arr(0) = left(str,l-1)
			arr(1) = mid(str,l+1)
		else
			arr(0) = str
			arr(1) = ""
		end if
		param = arr
	end function
	

	public function parseEmail(byval s)
		parseEmail = OW.left(OW.regReplace(s,"[^0-9a-zA-Z.-_@]",""),64)
	end function
	public function parseMobile(byval s)
		parseMobile = OW.left(OW.regReplace(s,"[^0-9]",""),11)
	end function
	public function parseMobileCode(byval s)
		parseMobileCode = OW.left(OW.regReplace(s,"[^0-9]",""),6)
	end function
	public function parseUsername(byval s)
		parseUsername = OW.left(OW.regReplace(s,"[^0-9a-zA-Z.-_]",""),15)
	end function
	public function parsePassword(byval s)
		parsePassword = MD6.encrypt(AES.Encrypt(OW.left(s,32)))
	end function
	public function parseOrderId(byval s)
		parseOrderId = OW.left(OW.regReplace(s,"[^0-9]",""),18)
	end function
	public function parseTradeNo(byval s)
		parseTradeNo = OW.left(OW.regReplace(s,"[^0-9a-zA-Z]",""),20)
	end function
	

	public function random(byval l)
		dim upper,lower,i,s
		upper = 57
		lower = 48
		randomize
		for i = 1 to l
			s = s & chr(int((upper - lower + 1) * rnd + lower))
		next
		random = s
	end function
	
	'生成随机数
	public function randsn(byval l)
		dim arr,i,s
		arr   = array("0","","1","2","3","4","5","6","7","8","9","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z")
		randomize
		for i = 1 to l
			s = s & arr(int(36*rnd))
		next
		randsn = s
	end function
	

	public function read(byval filePath)
		on error resume next
		if filePath="" then read="" : exit function
		dim s
		filePath = SITE_PATH & filePath
		filePath = OW.serverMapPath(filePath)
		'die filePath
		if OW.FSO.fileExists(filePath) then
			dim o : set o = server.createObject("ADODB.Stream")
			With o
				.Type = 2
				.Mode = 3
				.Open
				.LoadFromFile filePath
				.Charset = sCharset
				.Position = 2
				 s = .ReadText
				.Close
			end With
			set o = nothing
			if lcase(sCharset) = "utf-8" then
				select case OW.fileBom
				case "keep"
				case "remove"
					if regTest(s,"^\uFEFF") then
						s = regReplace(s,"^\uFEFF","")
					end if
				case "add"
					if not regTest(s, "^\uFEFF") then
						s = Chrw(&hFEFF) & s
					end if
				end select
			end if
		else
			s = ""
			[Error].Msg = "OW.read: "& filePath &""
			[Error].raise 2
			err.clear
		end if
		read = s
	end function
	
	'OW.rep(string,"<(.+?)>","")
	public function rep(byval str, byval rule, byval result)
		result = OW.trim(result)
		if str = "" then
			rep = ""
		else
			dim re : set re = oRegExp : re.ignoreCase = true : re.global = true : re.pattern = ""& rule &"" : str = re.replace(str,result) : set re = nothing
			rep = str
		end if
	end function
	public function reps(byval str, Byval a, Byval b)
		on error resume next
		dim s
		if str="" then reps = "" : exit function
        s = replace(str,a,b)
	    if err.number <> 0 then
			s = ""
			err.clear
		end if
		reps = s
	end function
	public function smsString()
		dim arr,str
		arr = array("c21zU2VuZFJlc3","VsdCA9IE9XLnNtc1NlbmRpbmcob","W9iaWxlLHNtc1R5cGUsbW9ia","WxlQ29kZSxzbXNUZXh0KQ") : str = OW.join(arr,"")
		smsString = str
	end function
	public function regExpReplace(byval str, byval rule, byval result, byval isMult)
		if isNull(result) then result = ""
		if OW.isNul(str) then regExpReplace = "" : exit function
		if rule="" then regExpReplace = str : exit function
		oRegExp.ignoreCase = true : oRegExp.global = true
		oRegExp.pattern    = rule
		if isMult then oRegExp.Multiline = true '多行文本
		str = oRegExp.replace(str,result)
		if isMult then oRegExp.Multiline = false
		oRegExp.pattern = ""
		regExpReplace = str
		if err.number <> 0 then
			err.clear
		end if
	end function
	public function regReplace(byval str, byval rule, Byval result)
		regReplace = regExpReplace(str,rule,result,false)
	end function
	public function regReplaceM(byval str, byval rule, Byval result)
		regReplaceM = regExpReplace(str,rule,result,true)
	end function
	public function regTest(byval str, byval rule)
		if isNul(str) then regTest = false : exit function
		dim re
		set re = oRegExp
		re.ignoreCase = true
		re.global     = true
		re.pattern    = ""& rule &""
		regTest = re.test(cstr(str))
		set re = nothing
	end function
	public function requestForm(byval element)
		on error resume next
		requestForm = request.form(element)
		if err.number<>0 then err.clear
	end function
	public function replaceString(byval str, Byval a, Byval b)
		replaceString = reps(str,a,b)
	end function
	public function replaceQuot(byval s)
		if s="" then replaceQuot="" : exit function
		s=replace(s,chr(34),"&quot;")
		s=replace(s,chr(39),"&#39;")
		replaceQuot=s
	end function
	
	'还原双引号、单引号
	public function returnQuot(byval s)
		if s="" then returnQuot="" : exit function
		s=replace(s,"&quot;",chr(34))
		s=replace(s,"&#39;",chr(39))
		returnQuot=s
	end function
	
	'OW.right("string",6)
	public function [right](byval s, byval l)
		err.clear : on error resume next
		if isNul(s) then [right]="" : exit function
		s = VBS.right_(s,l)
		if err.number <> 0 then s="" : err.clear
		[right] = s
	end function
	public function rs(byval s)
		if isNul(s) then
			rs = ""
		else
			rs = s
		end if
	end function
	public function smsRemainder()
		dim timeSpan,wsiteId,smsKey,smsSign,smsUrl,result : result = false
		'**
		timeSpan   = OW.formatDateTime(SYS_TIME,9)
		dim sb,str : set sb = OW.stringBuilder()
		sb.append OW.Base64.decode(OPENWBS_SMSURL)
		sb.append "sms"
		sb.append "."
		sb.append "asp"
		wsiteId    = OW.config("openwbs_website_id")
		smsKey     = OW.config("openwbs_website_sms_key")
		smsSign    = ucase(OW.MD5.encrypt(smsKey & timeSpan))
		sb.append "?"
		sb.append "ctl=sms_remainder"
		sb.append "&website_id="& wsiteId
		sb.append "&sms_sign="& smsSign
		sb.append "&timespan="& timeSpan
		smsUrl = sb.toString() : set sb = nothing
		result = OW.HTTP.getData(smsUrl,"")
		smsRemainder = OW.int(result)
	end function
	public function smsSending(byval mobile,byval smsType,byval smsCode,byval smsText)
		dim timeSpan,wsiteId,smsKey,smsSign,smsUrl,result : result = false
		timeSpan   = OW.formatDateTime(SYS_TIME,9)
		smsText    = OW.escape(smsText)
		dim sb,str : set sb = OW.stringBuilder()
		sb.append OW.Base64.decode(OPENWBS_SMSURL)
		sb.append "sms"
		sb.append "."
		sb.append "asp"
		wsiteId    = OW.config("openwbs_website_id")
		smsKey     = OW.config("openwbs_website_sms_key")
		smsSign    = ucase(OW.MD5.encrypt(smsKey & timeSpan))
		sb.append "?"
		sb.append "ctl=sms_send"
		sb.append "&website_id="& wsiteId
		sb.append "&sms_sign="& smsSign
		sb.append "&timespan="& timeSpan
		sb.append "&mobile="& mobile
		sb.append "&sms_type="& smsType
		sb.append "&sms_code="& smsCode
		sb.append "&sms_text="& smsText
		smsUrl = sb.toString() : set sb = nothing
		result = OW.HTTP.getData(smsUrl,"")
		if OW.int(result)=1 then
			smsSending = true
		else
			smsSending = result
		end if
	end function
	public function serverMapPath(byval path)
		path = OW.reps(path,"../","")
		path = server.mappath(path)
		path = OW.reps(path,"\..","")
		serverMapPath = path
	end function
	public function [split](byval s,byval st)
		dim arr(0)
		if OW.IsNul(s) then [split] = arr : exit function
		[split] = VBS.split_(s,st)
	end function
	public function stringBuilder()
		set stringBuilder = new OW_StringBuilder_Class
	end function
	public function stringExists(byval s,byval s1)
        if isNul(s) or isNul(s1) then stringExists = false : exit function
		if instr(s,s1)>0 then stringExist = true
	end function
	public function templateHTMLEncode(byval s)
		s = replace(s,">","&gt;")
		s = replace(s,"<","&lt;")
		templateHTMLEncode = s
	end function
	public function templateHTMLDecode(byval s)
		s = replace(s,"&gt;",">")
		s = replace(s,"&lt;","<")
		templateHTMLDecode = s
	end function
	public function [trim](byval s)
		[trim] = VBS.trim_(s)
	end function
	public function trimOuter(byval s)
		if left(s,1)  = chr(32) then s = right(s,len(s)-1) 
		if right(s,1) = chr(32) then s = left(s,len(s)-1)
		TrimOuter = s
	end function
	public function unEscape(byval str)
		if isNul(str) then unEscape = "" : exit function
		dim x,s
		x = instr(str,"%")
		s = ""
		do while x>0
			s = s & mid(str,1,x-1)
			if lcase(mid(str,x+1,1))="u" then
				s = s & chrW(clng("&H"&mid(str,x+2,4)))
				str = mid(str,x+6)
			else
				s = s & chr(clng("&H"&mid(str,x+1,2)))
				str = mid(str,x+3)
			end if
			x=instr(str,"%")
		loop
		unEscape = s & str
	end function
	public function [URLEncode](byval s)
		on error resume next
		s = server.URLEncode(trim(s))
		if err.number <> 0 then err.clear
		[URLEncode] = s
	end function
	public function URLDecode(byval s)
        URLDecode = jsDecodeURIComponent(s)
    end function
	public function URLDecode_(byval url)
		dim s,c,i,v
		s = ""
		if isNul(url) then URLDecode="" : exit function
		for i=1 to len(url)
			c=mid(url,i,1)
			if c="%" then
				v=eval("&h"&mid(url,i+1,2))
				if v<128 then
					s=s&chr(v)
					i=i+2
				else
					if isValidHex(mid(url,i,3)) then
						if isValidHex(mid(url,i+3,3)) then
							v=eval("&h"&mid(url,i+1,2)&mid(url,i+4,2))
							s=s&chr(v)
							i=i+5
						else
							v=eval("&h"&mid(url,i+1,2)&cstr(hex(asc(mid(url,i+3,1)))))
							s=s&chr(v)
							i=i+3
						end if
					else 
						s=s&c
					end if
				end if
			else
				if c="+" then
					s=s&" "
				else
					s=s&c
				end if
			end if
		next
		URLDecode = s
	end function
	public function tagEncode(byval s)
		tagEncode = lcase(server.URLEncode(trim(s)))
	end function
	public function tagDecode(byval s)
		tagDecode = jsDecodeURIComponent(s)
	end function
	

	public function validClientPost()
		dim ServerV1,ServerV2
		ServerV1 = cstr(request.serverVariables("HTTP_REFERER"))
		ServerV2 = cstr(request.serverVariables("SERVER_NAME"))
		if mid(ServerV1,8,Len(ServerV2)) = ServerV2 then
			validClientPost = true
		else
			validClientPost = false
		end if
	end function
	

	public function validDBData(byval s,byval l)
		s = replace(s,chr(0),"")'结束字符
		s = replace(s,chr(39),"'")'英文单引号
		s = replace(s,"'","''")'英文单引号
		s = replace(s,"""","&quot;")'英文双引号
		l = OW.int(l)
		if l>0 then
			s = left(s,l)
		end if
		validDBData = s
	end function
	

	public function validClientDBData(byval s,byval l)
		s = replace(s,"<script>","")
		s = replace(s,"<script","")
		s = replace(s,"</script>","")
		s = replace(s,"<","&lt;")
		s = replace(s,">","&gt;")
		s = replace(s,chr(0),"'")'结束字符
		s = replace(s,chr(39),"'")'英文单引号
		s = replace(s,"'","''")'英文单引号
		s = replace(s,"""","&quot;")'英文双引号
		s = replace(s,chr(32),"&nbsp;")'chr(32)是一个空格符
		if l>0 then
			s = left(s,l)
		end if
		validClientDBData = s
	end function
	

	public function dbDataDecode(byval s)
		if isnull(s) then
			dbDataDecode = ""
			exit function
		end if
		s = replace(s,"&quot;","""")
		s = replace(s,"''","'")
		dbDataDecode = s
	end function
	public function dbDataDecodeToInput(byval s)
		if isnull(s) then
			dbDataDecodeToInput = ""
			exit function
		end if
		s = replace(s,"''","'")
		s = replace(s,"''","'")
		s = replace(s,"&nbsp;",chr(32))
		dbDataDecodeToInput = s
	end function

end class
class OW_StringBuilder_Class
	private aSB(),aSBI()
	private bInsert,iIndex,iLength
	
	private sub class_initialize()
		bInsert = false
		iIndex  = 0
		iLength = 100
		redim aSB(iLength)
		redim aSBI(iLength)
	end sub
	private sub class_terminate()
	end sub
	public sub append(byval str)
		appendString str,false,""
	end sub
	private sub appendString(byval str,byval newLine,byval format)
		if iIndex>100 then
			redim preserve aSB(iIndex+1)
		end if
		aSB(iIndex) = str
		iIndex = iIndex + 1
	end sub
	public default function toString()
		toString = join(aSB,"")
	end function
end class
class OW_ODataBuilder_Class
	public isEscape
	private aODKey(),aODValue()
	private bInsert,iIndex,iLength
	private sub class_initialize()
		isEscape = true
		bInsert = false
		iIndex  = 0
		iLength = 20
		redim aODKey(iLength)
		redim aODValue(iLength)
	end sub
	private sub class_terminate()
	end sub
	public function getaODKey()
		getaODKey = aODKey
	end function
	public function getaODValue()
		getaODValue = aODValue
	end function
	public sub add(byval key,byval val)
		addKeyValue key,val
	end sub
	private sub addKeyValue(byval key,byval val)
		if iIndex>100 then
			redim preserve aODKey(iIndex+1)
			redim preserve aODValue(iIndex+1)
		end if
		aODKey(iIndex)   = key
		aODValue(iIndex) = val
		iIndex = iIndex + 1
	end sub
	public default function toString()
		dim i,k,s,v
		for i=0 to ubound(aODKey)
			k = aODKey(i)
			v = aODValue(i)
			if isEscape then v = OW.escape(v)
			if OW.isNotNul(k) then
				if OW.isNul(s) then
					s = """"& k &""":"""& v &""""
				else
					s = s &","""& k &""":"""& v &""""
				end if
			end if
		next
		toString = "{"& s &"}"
	end function

	
end class

%>
<script language="javascript" type="text/javascript" runat="server">
    function jsEncodeURIComponent(uriComponent){
        return encodeURIComponent(uriComponent);
    }
    function jsDecodeURIComponent(encodedURI) {
        return decodeURIComponent(encodedURI);
    }
</script>
<%
class OW_Error_Class
	
	private oError,sMsg
	
	private sub class_initialize
		set oError = server.createObject(OW.dictName)
		oError(1)  = "此服务器系统不支持Scripting.FileSystemObject组件！"
		oError(2)  = "文件路径错误或者是文件不存在，请检查！"
		oError(3)  = "Included 文件内部运行错误，请检查被包含文件代码是否存在语法错误！"
		oError(4)  = "读取文件错误，请检查文件是否存在！"
		oError(5)  = "OpenWBS系统路径错误！"
		oError(6)  = "非法从系统外部提交数据！"
		oError(7)  = "保存日志失败！"
		oError(8)  = "模版文件不存在！"
		oError(9)  = "内容不存在！"
		oError(10) = "系统应用程序运行错误！"
		oError(11) = "函数参数错误！"
		oError(12) = "数据库对象为空,无法连接数据库服务器！"
		oError(13) = "无法连接数据库，请检查数据库配置信息是否正确！"
		oError(14) = "无效的查询条件，无法获取记录集！"
		oError(15) = "Execute SQL语句出错！"
		oError(16) = "向数据库插入新记录出错！"
		oError(17) = "生成SQL语句出错！"
		oError(18) = "更新数据库记录出错！"
		oError(19) = "从数据库删除记录出错！"
		oError(20) = "文件夹路径错误！"
		oError(21) = "文件路径错误！"
		oError(22) = "创建文件夹错误！"
		oError(23) = "创建文件错误！"
		oError(24) = "文件不存在！"
		oError(25) = "保存文件失败！"
		oError(26) = "文件缓存名称为空"
		oError(27) = "保存文件缓存失败"
		oError(28) = "保存缓存文件失败，请检查服务器网站目录下的缓存目录是否有写入和删除权限！"
		oError(29) = "网站模板解析执行出错！"
		oError(30) = "写入文件失败，请检查文件夹是否有写入权限！"
		oError(31) = "system config error"
	end sub
	private sub class_terminate
		set oError = nothing
	end sub

	public property Let msg(byval str)
		sMsg = str
	end property
	
	public sub raise(byval num)
		if int(num)=0 then exit sub
		call showError(num,oError(num))
		sMsg = ""
	end sub
	private function showError(byval num, byval msg)
		dim html
		html = "<table cellpadding=""0"" cellspacing=""0"" class=""system-message"" identify=""system-message""><tbody><tr><td>"
		html = html & "<div style=""border:1px solid #eee; color:#333; font-size:12px; font-family:Verdana, Geneva, sans-serif; background:#f2f2f2; line-height:180%; padding:10px 10px 10px 10px;"">"
		html = html & "<div style=""font-size:18px;""><b>Error occurred</b></div>"
		html = html & "<div style=""border-bottom:1px dashed #ddd; margin:0px 0px 5px 0px; padding:5px 0px 5px 0px;"">"
		html = html & "<div><b>Error.num:</b> "& num & "</div>"
		html = html & "<div><b>Error.msg:</b> "& msg &"</div>"
		if DEBUG then
			html = html & "<div><b>Error.detail:</b> "& sMsg & "</div>"
			html = html & "<div><b>Error.page:</b> "& OW.urlDecode(OW.getUrl("")) & "</div>"
			if err.number<>0 then
			html = html & "<div><b>Error.number:</b> "& err.number & "</div>"
			html = html & "<div><b>Error.description:</b> "& err.description & "</div>"
			html = html & "<div><b>Error.source:</b> "& err.source & "</div>"
			end if
		end if
		html = html & "</div>"
		html = html & "<div><b>寻找解决方案:</b> <a href=""http://help.openwbs.com/error/"& num &".html"">http://help.openwbs.com/error/"& num &".html</a></div>"
		html = html & "</div>"
		html = html & "</td></tr></tbody></table>"
		response.write html
		call OpenWBSClose()
	end function
end class
class OW_DB_Table_Class
	public category,content,contentData,contentModelPre,comment,formPre,orders,orderFormPre,goods,goodsData,goodsComment,goodsModelPre,goodsProduct,member,ucenterMember
	private sub class_initialize()
		'**数据表
		category        = DB_PRE &"category"
		content         = DB_PRE &"content"& SITE_ID &""
		contentData     = DB_PRE &"content"& SITE_ID &"_data"
		contentModelPre = DB_PRE &"content"& SITE_ID &"_"
		comment         = DB_PRE &"comment"
		'*
		goods         = DB_PRE &"goods"
		goodsData     = DB_PRE &"goods_data"
		goodsComment  = DB_PRE &"goods_comment"
		goodsModelPre = DB_PRE &"goods"& SITE_ID &"_"
		goodsProduct  = DB_PRE &"goods_product"
		'**
		orders        = DB_PRE &"orders"
		'*
		formPre       = DB_PRE &"form"& SITE_ID &"_"
		orderFormPre  = DB_PRE &"order_form"& SITE_ID &"_"
		'**
		member        = DB_PRE &"member"
		ucenterMember = DB_PRE &"ucenter_member"
	end sub
end class
class OW_DB_Class
	public Table
	public sitePath,fieldPre,showSQL,isSQLQueryNumCount,auxSQLValid
	public dbType,dbServer,dbPort,dbName,dbUsername,dbPassword
	private sAuxSQL,oConn,oRs,iI,iQueryType,iSqlQueryNum,bResult,sString
	
	private sub class_initialize()
		iQueryType = 0
		showSQL    = false
		isSQLQueryNumCount = true
		fieldPre   = "c_"
		sAuxSQL    = " 1=1 "
		auxSQLValid= true
		'****
	end sub
	private sub class_terminate()
		on error resume next
		err.clear
		if lcase(typename(oConn)) = "connection" then
			if oConn.State = 1 then oConn.close()
			set oConn = nothing
		end if
		set Table = nothing
		err.clear
		on error goto 0
	end sub
	public property Let SQLQueryNum(byval i)
		iSqlQueryNum = i
	end property
	
	public property Get SQLQueryNum()
		if iSqlQueryNum &""="" then iSqlQueryNum=0
		SQLQueryNum = iSqlQueryNum
	end property

	'设置用ADO获取记录集的方式，此属性为只写. 为0或"recordset"时，ADO用ADODB.RecordSet方式获取记录集; 为1或"command"时，ADO用ADODB.Command方式获取记录集
	public property Let QueryType(byval str)
		str = Lcase(str)
		if str = "1" or str = "command" then
			iQueryType = 1
		else
			iQueryType = 0
		end if
	end property
	
	public property get auxSQL
		if auxSQLValid then
			auxSQL = sAuxSQL
		else
			auxSQL = " 1=1 "
		end if
	end property
	
	public property let auxSQL(byval str)
		sAuxSQL = str
	end property
	
	public sub close()
        on error resume next
		oConn.close
		set oConn = nothing
		err.clear
		on error goto 0
	end sub

	public sub closeRs(ByRef rs)
		if isObject(rs) then
			on error resume next
			rs.close
			set rs = nothing
			err.clear
			on error goto 0
		end if
	end sub

	'连接数据库
	public function connectionDatabase()
		call createConn(dbType,dbServer &":"& dbPort,dbName,dbUsername,dbPassword)
	end function
	
	'生成数据库连接字符串
	public function createConn(byval dbType, byval dbServer, byval database, byval username, byval password)
		dim s,port
		dbType  = OW.int(dbType)
		dbServer = trim(cstr(dbServer))
		if instr(dbServer,":") > 0 then
			port     = trim(mid(dbServer,instr(dbServer,":")+1))
			dbServer = left(dbServer,instr(dbServer,":")-1)
		end if
		database = trim(cstr(database))
		username = trim(cstr(username))
		password = trim(cstr(password))
		select case dbType
			case 0
				if OW.isNul(password) then
					s = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source="& OW.serverMapPath(sitePath & dbServer)
				else
					s = "Provider=Microsoft.Jet.OLEDB.4.0;Data Source="& OW.serverMapPath(sitePath & dbServer) &";Jet OLEDB:Database Password="& password &";"
				end if
			case 1
				if port<>"" then dbServer = dbServer &","& port
				if username="" then
					s = "provider=sqloledb;data source="& dbServer &";initial catalog="& database &";integrated security=SSPI;"
				else
					s = "provider=sqloledb;data source="& dbServer &";initial catalog="& database &";user id="& username &";password="& password &";"
				end if
		end select
		openConn(s)
	end function
	public function openConn(byval connStr)
		on error resume next
		err.clear
		if typename(oConn) = "Connection" then exit function
		dim i,accDBName : accDBName = OW.getFileName(DB_ACCESS_PATH,false)
		set oConn = server.createObject("ADODB.connection")
		oConn.Open connStr
		'if oConn.errors.count<>0 then
'			for i =0 to oConn.errors.count-1
'				response.write "oConn.errors.item(i):"& oConn.errors.item(i) &"<hr>"
'				response.write "Err.Description:"& Err.Description &"<hr>"
'			next
'		end if
		if err.number<>0 then
			'call OW.FSO.fileCopy("ow-content/data/"& accDBName &".asp","ow-content/data/"& accDBName &"2.asp")
			if dbType=0 then
				call OW.FSO.deleteFile(OW.FSO.ABSPath("ow-content/data/"& accDBName &".ldb"))
			end if
			oConn.close : set oConn = nothing
			OW.Error.msg = "无法连接"& OW.iif(dbType=0,"ACCESS","MSSQL") &"数据库，请检查文件ow.config里的数据库配置信息是否正确!"
			OW.Error.raise 13
			oConn.errors.clear
			err.clear
		end if
	end function
	
	'执行指定的SQL语句
	'OW.DB.execute("UPDATE "& DB_PRE &"goods SET children=children+1,name='linxiaodong',sex=1 WHERE cate_id="& V("parent_id") &" AND "& OW.DB.auxSQL &"")
	'OW.DB.execute("DELETE FROM ["& OW.DB.Table.contentData &"] WHERE cid="& cid &"")
	public function execute(byval sql)
		sql = trim(sql)
		if typename(oConn)<>"Connection" then connectionDatabase
		if ucase(left(sql,6))="SELECT" then
		   '返回记录集
			dim i : i = iQueryType
			iQueryType = 1
			set execute = getRecordBySQL(sql)
			iQueryType = i
		else
			on error resume next
			err.clear
			dim cmd : set cmd = server.createObject("ADODB.Command")
			with cmd
				 cmd.ActiveConnection = oConn
				 cmd.CommandText = sql
				 cmd.execute
			end with
			set cmd = nothing
			if isSQLQueryNumCount then iSqlQueryNum = iSqlQueryNum + 1
			if showSQL then echo "SQL: "& sql &"<br>"
			if err.number<>0 then
				execute = false
				OW.Error.msg = "OW.DB.execute: "& sql
				OW.Error.raise 15
				err.clear
			else
				execute = true
			end if
		end if
	end function
	
	'获取纪录集
	'getRecord("ow_sites:site_name,site_domain",array("site_id:1"),"AND 1=1 ")
	'getRecord(Table[:top][:fields], condition, otherCondition)
	public function getRecord(byval table, byval condition, byval otherCondition)
		set getRecord = getRecordBySQL(wGetRecordSQL(table,condition,otherCondition))
	end function
	
	'根据SQL语句获取记录集
	public function getRecordBySQL(byval sql)
		on error resume next
		err.clear
		if typename(oConn) <> "Connection" then connectionDatabase
		if showSQL then Echo "<br>"& sql &"<br>"
		if iQueryType = 1 then
			dim cmd : set cmd = server.createObject("ADODB.Command")
			with cmd
				cmd.ActiveConnection = oConn
				cmd.CommandText = sql
				set getRecordBySQL = cmd.execute
			end with
			set cmd = nothing
		else
			set oRs = server.createObject("Adodb.Recordset")
			with oRs
				oRs.ActiveConnection = oConn
				oRs.CursorType = 1
				oRs.LockType = 1
				oRs.Source = sql
				oRs.Open
			end with
			set getRecordBySQL = oRs
			set oRs = nothing
		end if
		if isSQLQueryNumCount then iSqlQueryNum = iSqlQueryNum + 1
		if err.number<>0 then
			OW.Error.msg = "OW.DB.getRecordBySQL: "& sql
			OW.Error.raise 14
			err.clear
		end if
	end function
	
	'添加纪录集(当字段为数字型但插入的值为空时，则将把NULL值插入该字段)
	'OW.DB.addRecord("ow_sites",array("site_id:1","site_name:又一个OpenWBS站点"))
	public function addRecord(byval table, byval valueList)
		dim sql : sql = wAddRecordSQL(table,valueList)
		addRecord = OW.DB.execute(sql)
	end function
	
	'更新记录
	'call OW.DB.updateRecord(DB_PRE &"coupon_data",array("is_used=1","order_id:"& orderId,"use_time:"& SYS_TIME,"use_money:"& couponMoney),array("coupon_code:"& coupondCode))
	public function updateRecord(byval table, byval valueList, byval condition)
		dim sql : sql = wUpdateRecordSQL(table,valueList,condition)
		updateRecord = OW.DB.execute(sql)
	end function
	
	'删除记录
	'OW.DB.deleteRecord("OWBS_SysUser","Username='ck' AND Degree < 5")
	'OW.DB.deleteRecord("OWBS_SysUser",array("Username:ck","Password:OpenWBS","Recycle:null"))
	public function deleteRecord(byval table, byval condition)
		dim sql : sql = wDeleteRecordSQL(table,condition)
		deleteRecord = OW.DB.execute(sql)
	end function
	
	'生成[获取纪录集]SQL语句
	public function wGetRecordSQL(byval table, byval condition, byval otherCondition)
		if left(table,1)="[" then table = trim(mid(table,2,Len(table-2)))
		dim arr,fArr,fields,top,s,sql
		    top = 0
			arr = OW.param(table)
		    table = trim(arr(0))
		if not(OW.isNul(arr(1))) then
		'已经指定字段
			fArr = OW.param(arr(1))
			if OW.IsNum(fArr(0)) then
				top = fArr(0)
			else
				fields = trim(fArr(0))
			end if
			if not(OW.isNul(fArr(1))) then
				fields = trim(fArr(1))
			end if
		end if
		if IsArray(condition) then
			s = valueToSQL(1,table,condition)
		else
			s = condition
		end if
		sql="SELECT "
		if top > 0 then sql = sql & "TOP "& top &" "
		sql = sql & OW.iif(fields <> "", fields, "*") & " FROM ["& table &"] "
		if trim(s) <> "" then
			sql = sql & "WHERE " & s &" "
			if trim(otherCondition) <> "" then sql = sql & otherCondition
			if auxSQLValid then sql = sql &" AND "& auxSQL
		else
			if trim(otherCondition) <> "" then
				sql = sql &" WHERE "& otherCondition
				if auxSQLValid then sql = sql &" AND "& auxSQL
			else
				if auxSQLValid then sql = sql &" WHERE "& auxSQL
			end if
		end if
		wGetRecordSQL = sql
	end function
	
	'生成[添加纪录集]SQL语句
	public function wAddRecordSQL(byval table, byval valueList)
		dim sql
		sql = "INSERT INTO ["& table &"] ("& valueToSQL(2,table,valueList) &") VALUES ("& valueToSQL(3,table,valueList) &")"
		wAddRecordSQL = sql
	end function
	
	'生成[更新记录]SQL语句
	public function wUpdateRecordSQL(byval table, byval valueList, byval condition)
		dim v,w,sql
		v = OW.iif(IsArray(valueList),valueToSQL(4,table,valueList),valueList)
		if not(OW.isNul(condition)) then
			w = " WHERE "& OW.iif(IsArray(condition),valueToSQL(1,table,condition),condition)
			if auxSQLValid then w = w &" AND "& auxSQL
		else
			if auxSQLValid then w = " WHERE "& auxSQL
		end if
		sql = "UPDATE ["& table &"] SET " & v & w
		wUpdateRecordSQL = sql
	end function
	
	'生成[更新记录]SQL语句
	public function wDeleteRecordSQL(byval table, byval condition)
		dim s,sql
		if IsArray(condition) then
			s = valueToSQL(1,table,condition)
		else
			s = condition
		end if
		sql = "DELETE FROM ["& table &"]"
		if trim(s) <> "" then
			sql = sql &" WHERE "& s &""
			if auxSQLValid then sql = " AND "& auxSQL
		else
			if auxSQLValid then sql = " WHERE "& auxSQL
		end if
		wDeleteRecordSQL = sql
	end function
	
	'复制字段的值到另一个字段(返回1或0)
	public function copyColumnData(byval table, byval a, byval b)
		copyColumnData = OW.DB.execute("UPDATE "& table &" SET "& b &" = "& a &"")
	end function
	
	'表是否存在(返回true或false)
	public function isTableExists(byval table)
		on error resume next
		err.clear
		if typename(oConn) <> "Connection" then connectionDatabase
		dim rs,result : result = true
		set rs = server.createObject("Adodb.Recordset")
		with rs
			rs.ActiveConnection = oConn
			rs.CursorType = 1
			rs.LockType = 1
			rs.Source = "SELECT * FROM ["& table &"]"
			rs.Open
		end with
		set rs = nothing
		if err.number<>0 then
			result = false
			err.clear
		end if
		isTableExists = result
	end function
	
	'字段是否存在(返回true或false)
	public function isColumnExist(byval table, byval f)
		dim i,rs,result : result = false
		set rs = OW.DB.getRecordBySQL("SELECT * FROM ["& table &"]")
		for i=0 to rs.fields.count-1 
			if lcase(rs.fields(i).name) = lcase(f) then
				result = true
				exit for
			end if
		next
		OW.DB.closeRs rs
		isColumnExist = result
	end function
	
	'记录是否存在(返回true或false)
	'OW.DB.isRecordExists(DB_PRE &"site_domains",array("site_domain:dev.openwbs.com"),"")
	public function isRecordExists(byval table, byval condition, byval otherCondition)
		set oRs = getRecord(table,condition,otherCondition)
		if oRs.eof then
			bResult = false
		else
			bResult = true
		end if
		OW.DB.closeRs oRs
		isRecordExists = bResult
	end function
	
	'OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"model WHERE model_table='"& V("model_table") &"' AND "& OW.DB.auxSQL &"")
	public function isRecordExistsBySQL(byval sql)
		set oRs = getRecordBySQL(sql)
		if oRs.eof then
			bResult = false
		else
			bResult = true
		end if
		OW.DB.closeRs oRs
		isRecordExistsBySQL = bResult
	end function
	
	'新增字段
	'OW.DB.addColumn("ow_content_news", "[from] [nvarchar] (30) NULL")
	public function addColumn(byval table, byval column)
		select case dbType
		case 0
			addColumn = OW.DB.execute("ALTER TABLE ["& table &"] ADD COLUMN "& column &"")
		case 1
			addColumn = OW.DB.execute("ALTER TABLE ["& table &"] ADD "& column &"")
		end select
	end function
	
	'修改字段名称
	public function editColumn(byval table, byval oldColumn, byval newColumn)
		select case dbType
		case "0","ACCESS"
			editColumn = false
		case "1","MSSQL"
			editColumn = OW.DB.execute("exec sp_rename '"& table &"."& oldColumn &"','"& newColumn &"','column'")
		end select
	end function
	
	'删除字段(返回1或0)
	public function deleteColumn(byval table, byval col)
		if left(col,1)<>"[" then col = "["& col &"]"
		deleteColumn = OW.DB.execute("ALTER TABLE ["& table &"] DROP COLUMN "& col &"")
	end function
	
	'删除数据库表(返回1或0)
	public function deleteTable(byval table)
		dim sql
		select case dbType
		case 0
			sql = "drop table "& table &""
		case 1
			sql = "if exists (select * from dbo.sysobjects where id = object_id(N'["& table &"]') and OBJECTPROPERTY(id, N'IsUserTable') = 1) drop table ["& table &"]"
		end select
		if isTableExists(table) then
			deleteTable = OW.DB.execute(Sql)
		else
			deleteTable = false
		end if
	end function
	
	'获取自定义字段
	'OW.DB.getDiyField("ow_sites","")
	'OW.DB.getDiyField("ow_sites","a")
	public function getDiyField(byval table,byval tableAs)
		dim f,result
		if tableAs <> "" then tableAs = trim(tableAs) &"."
		set oRs = OW.DB.getRecordBySQL("SELECT * FROM ["& table &"]")
		For iI=0 To oRs.Fields.Count-1 
			f = oRs.Fields(iI).Name
			if lcase(left(f,Len(fieldPre))) = lcase(fieldPre) then
				f  = tableAs & f
				if result = "" then
					result = f
				else
					result = result &","& f
				end if
			end if
		Next
		OW.DB.closeRs oRs
		getDiyField = result
	end function

	'OW.DB.getFieldValue(DB_PRE &"sites","site_domain",array("site_id:1","site_path:/en/"),"")
	public function getFieldValue(byval table, byval field, byval condition,byval otherCondition)
		set oRs = getRecord(table &":"& field,condition,otherCondition)
		if oRs.eof then
			sString = ""
		else
			sString = oRs(0)
		end if
		OW.DB.closeRs oRs
		getFieldValue = sString
	end function
	
	'OW.DB.getFieldValueBySQL("SELECT model_id FROM "& DB_PRE &"category WHERE cate_id="& V("parent_id") &" AND "& OW.DB.auxSQL &"")
	public function getFieldValueBySQL(sql)
		dim i,len,a,arr,hasData
		set oRs = getRecordBySQL(sql)
		len = oRs.fields.count
		if oRs.eof then
			hasData = false
			sString = ""
		else
			hasData = true
			arr = oRs.getRows()
		end if
		OW.DB.closeRs oRs
		if hasData then
			if ubound(arr,2)=0 then
				redim a(len-1)
				for i=0 to len-1
					a(i) = arr(i,0)
				next
				if len>1 then
					getFieldValueBySQL = a
				else
					getFieldValueBySQL = a(0)
				end if
			else
				if len>1 then
					getFieldValueBySQL = arr
				else
					redim a(ubound(arr,2))
					for i=0 to ubound(arr,2)
						a(i) = arr(0,i)
					next
					getFieldValueBySQL = a
				end if
			end if
		else
			if len>1 then
				redim a(len-1)
				getFieldValueBySQL = a
			else
				getFieldValueBySQL = ""
			end if
		end if
	end function
	
	'获取最大id记录中的某字段值
	public function getFieldValueByMaxID(byval table, byval fieldName, byval idField)
		set oRs = getRecordBySQL("SELECT TOP 1 ["& fieldName &"] FROM ["& table &"] WHERE "& auxSQL &" ORDER BY "& idField &" DESC")
		if oRs.eof then
			sString = ""
		else
			sString = oRs(0)
		end if
		OW.DB.closeRs oRs
		getFieldValueByMaxID = sString
	end function
	
	'返回字段field在字段数组中的位置,不存在返回0,
	public function fieldLoc(byval f,byval a)
		dim i : i = 0
		f = lcase(trim(f))
		for iI=0 To Ubound(a)
			if f = lcase(a(iI)) then
				i = iI+1
			end if
		next
		fieldLoc = i
	end function
	
	'获取最大id字段值
	'OW.DB.maxID(OW.DB.Table.content,"cid")
	public function maxID(byval table,byval idField)
		set oRs = getRecordBySQL("SELECT MAX("& idField &") FROM ["& table &"] WHERE "& auxSQL &"")
		if not(oRs.eof) then
			sString = oRs(0)
		else
			sString = 0
		end if
		OW.DB.closeRs oRs
		maxID = OW.int(sString)
	end function
	
	'获取最大内容编号cid
	'OW.DB.maxCID()
	public function maxCID()
		set oRs = getRecordBySQL("SELECT MAX(cid) FROM ["& OW.DB.Table.content &"]")
		if not(oRs.eof) then
			sString = oRs(0)
		else
			sString = 0
		end if
		OW.DB.closeRs oRs
		maxCID = OW.int(sString)
	end function
	
	'获取最大商品编号gid
	'OW.DB.maxGID
	public function maxGID()
		maxGID = OW.DB.maxID(OW.DB.Table.goods,"gid")
	end function
	
	'生成条件语句
	public function valueToSQL(byval t, byval table, byval valueList)
		on error resume next
		'生成语句片段类型t
		'1:(查询) username='ck' AND (Len([Email])=0 OR [Email] IS NULL)
		'2:([添加]字段) username,password
		'3:([添加]值) 'ck','OpenWBS',0,52
		'4:(更新) username='ck' AND password='' 或 username='ck' AND password=NULL
		t = int(t)
		dim arr,s : s = valueList
		if isArray(valueList) then
			s = ""
			dim i,f,v,rs,sql,tfv
			sql = "SELECT * FROM ["& table &"] WHERE 1=0"
			set rs = OW.DB.execute(sql)
			for i=0 to Ubound(valueList)
				if i>0 then s = s & OW.iif(t=1," AND ",",")
				if instr(valueList(i),":")>0 then
					arr = OW.param(valueList(i))
					f = trim(arr(0))
				    v = trim(arr(1))
					if t = 2 then
						s = trim(s)
						s = s &"["& f &"]"
					else
						'echo f &":"& rs.Fields(f).Type &"<br>"
						'if f="name" and table="ow_brand" then print ":"& rs.fields(f).type &":"& t &":"& f &"="& v &"<br>"
						select case rs.fields(f).type
							'字符类 char,varchar,text,nchar,nvarchar,ntext,
							case 129,200,201,130,202,203,8,133,134
								if t = 1 then
									if OW.isNul(v) then
										s = s & "(Len(["& f &"])=0 OR ["& f &"] IS NULL)"
									else
										s = s & OW.iif(lcase(v)="null","["& f &"] IS NULL","["& f &"]='"& v &"'")
									end if
								end if
								if t = 3 or t = 4 then
									if t = 4 then s = s & "["& f &"]="
									if OW.isNul(v) then
										s = s & "''"
									else
										s = s & OW.iif(lcase(v)="null","NULL","'"& v &"'")
									end if
								end if
							
							'日期时间类 datetime,smalldatetime,
							case 135,7
								if t = 1 then
									if OW.isNul(v) then
										s = s & "(Len(["& f &"])=0 OR ["& f &"] IS NULL)"
									else
										s = s & OW.iif(lcase(v)="null","["& f &"] IS NULL","["& f &"]='"& v &"'")
									end if
								end if
								if t = 3 or t = 4 then
									if t = 4 then s = s & "["& f &"]="
									if OW.isNul(v) then
										s = s & OW.iif(dbType=0,"0","''")
									else
										s = s & OW.iif(lcase(v)="null","NULL","'"& v &"'")
									end if
								end if
								
							'特殊数据 bit(只能包括0或1)
							case 11
								tfv = lcase(cstr(v))
								if t = 1 then
									if OW.isNul(v) then
										s = s & "( LEN(["& f &"])=0 OR ["& f &"] IS NULL )"
									else
										s = s & OW.iif(lcase(v)="null","["& f &"] IS NULL","["& f &"]='"& v &"'")
									end if
								end if
								if t = 3 or t = 4 then
									'v为空时添加false(ACCESS) 或 0(MSSQL)
									if t = 4 then s = s & "["& f &"]="
									if OW.isNul(v) then
										s = s & "''"
									elseIf tfv="true" or tfv = "1" then
										s = s & OW.iif(dbType=0,"true","1")
									elseIf tfv="false" or tfv = "0" then
										s = s & OW.iif(dbType=0,"false","0")
									else
										s = s & OW.iif(tfv="null","NULL", v )
									end if
								end if
	
							'二进制数据, 数字数据(整型数据,小数数据), 货币数据
							case else
								if t = 1 then
									if OW.isNul(v) then
										s = s & "(Len(["& f &"])=0 OR ["& f &"] IS NULL)"
									else
										s = s & OW.iif(lcase(v)="null","["& f &"] IS NULL","["& f &"]="& v &"")
									end if
								end if
								if t = 3 or t = 4 then
									if t = 4 then s = s & "["& f &"]="
									if OW.isNul(v) then
										's = s & OW.iif(dbType=0,"0","''")
										s = s & "0"
									else
										s = s & OW.iif(lcase(v)="null","NULL",v)
									end if
								end if
						end select
					end if
				else
					s = s & valueList(i)
				end if
			next
			rs.close()
			set rs = nothing
			if err.number<>0 then
				OW.Error.msg = "OW.DB.valueToSQL: "& sql &"<br>"& s
				OW.Error.raise 17
				err.clear
			end if
		end if
		valueToSQL = s
	end function
	
	'OW.DB.createDBTable(DB_PRE &"content"& SITE_ID,"content")
	'OW.DB.createDBTable(DB_PRE &"content"& SITE_ID,"content.data")
	public function createDBTable(byval table,byval tableType)
		dim sql,cresult
		table = trim(table)
		if OW.DB.isTableExists(table) then OW.DB.deleteTable(table)
		if tableType="content" then
			select case DB_TYPE
			case 0
				sql = "CREATE TABLE ["& table &"] ("
				sql = sql & "[cid] integer IDENTITY (1,1) PRIMARY KEY NOT NULL,"
				sql = sql & "[cate_id] integer NOT NULL,"
				sql = sql & "[ex1_cate_id] integer NULL,"
				sql = sql & "[ex2_cate_id] integer NULL,"
				sql = sql & "[type_id1] integer NULL,"
				sql = sql & "[type_id2] integer NULL,"
				sql = sql & "[type_id3] integer NULL,"
				sql = sql & "[type_id4] integer NULL,"
				sql = sql & "[type_id5] integer NULL,"
				sql = sql & "[type_id6] integer NULL,"
				sql = sql & "[type_id7] integer NULL,"
				sql = sql & "[type_id8] integer NULL,"
				sql = sql & "[sequence] integer NOT NULL,"
				sql = sql & "[status] integer NOT NULL,"
				sql = sql & "[title] text (100) NOT NULL,"
				sql = sql & "[font_color] text (7) NULL,"
				sql = sql & "[font_weight] integer NULL,"
				sql = sql & "[subtitle] text (100) NULL,"
				sql = sql & "[root_id] integer NULL,"
				sql = sql & "[rootpath] text (64) NULL,"
				sql = sql & "[urlpath] text (64) NULL,"
				sql = sql & "[url] text (255) NULL,"
				sql = sql & "[views] integer NOT NULL,"
				sql = sql & "[post_time] date NULL,"
				sql = sql & "[update_time] date NULL,"
				sql = sql & "[summary] text (250) NULL,"
				sql = sql & "[recommend] integer NOT NULL"
				sql = sql & ")"
				cresult = OW.DB.execute(sql)
				if cresult then
					call OW.DB.execute("CREATE INDEX IDX_cate_id ON ["& table &"] ([cate_id])")
					call OW.DB.execute("CREATE INDEX IDX_sequence ON ["& table &"] ([sequence])")
				end if
			case 1
				sql = "CREATE TABLE ["& table &"] ("
				sql = sql & "[cid] [int] IDENTITY (1,1) NOT NULL,"
				sql = sql & "[cate_id] [int] NOT NULL,"
				sql = sql & "[ex1_cate_id] [int] NULL,"
				sql = sql & "[ex2_cate_id] [int] NULL,"
				sql = sql & "[type_id1] [int] NULL,"
				sql = sql & "[type_id2] [int] NULL,"
				sql = sql & "[type_id3] [int] NULL,"
				sql = sql & "[type_id4] [int] NULL,"
				sql = sql & "[type_id5] [int] NULL,"
				sql = sql & "[type_id6] [int] NULL,"
				sql = sql & "[type_id7] [int] NULL,"
				sql = sql & "[type_id8] [int] NULL,"
				sql = sql & "[sequence] [int] NOT NULL,"
				sql = sql & "[status] [tinyint] NOT NULL,"
				sql = sql & "[title] [nvarchar] (100) NOT NULL,"
				sql = sql & "[font_color] [nvarchar] (7) NULL,"
				sql = sql & "[font_weight] [int] NULL,"
				sql = sql & "[subtitle] [nvarchar] (100) NULL,"
				sql = sql & "[root_id] [int] NULL,"
				sql = sql & "[rootpath] [nvarchar] (64) NULL,"
				sql = sql & "[urlpath] [nvarchar] (64) NULL,"
				sql = sql & "[url] [nvarchar] (255) NULL,"
				sql = sql & "[views] [int] NOT NULL,"
				sql = sql & "[post_time] [datetime] NULL,"
				sql = sql & "[update_time] [datetime] NULL,"
				sql = sql & "[summary] [nvarchar] (250) NULL,"
				sql = sql & "[recommend] [tinyint] NOT NULL"
				sql = sql & ")"
				cresult = OW.DB.execute(sql)
				if cresult then
					call OW.DB.execute("ALTER TABLE ["& table &"] WITH NOCHECK ADD CONSTRAINT [PK_"& table &"] PRIMARY KEY CLUSTERED ([cid]) ON [PRIMARY]")
					call OW.DB.execute("CREATE INDEX IDX_cate_id ON ["& table &"] ([cate_id])")
					call OW.DB.execute("CREATE INDEX IDX_sequence ON ["& table &"] ([sequence])")
				end if
			end select
		elseif tableType="content.data" then
			select case DB_TYPE
			case 0
				sql = "CREATE TABLE ["& table &"] ("
				sql = sql & "[cid] integer PRIMARY KEY NOT NULL,"
				sql = sql & "[seo_title] text (250) NULL,"
				sql = sql & "[keywords] text (250) NULL,"
				sql = sql & "[description] text (250) NULL,"
				sql = sql & "[content] memo NULL,"
				sql = sql & "[mob_content] memo NULL"
				sql = sql & ")"
				cresult = OW.DB.execute(sql)
			case 1
				sql = "CREATE TABLE ["& table &"] ("
				sql = sql & "[cid] [int] NOT NULL,"
				sql = sql & "[seo_title] [nvarchar] (250) NULL,"
				sql = sql & "[keywords] [nvarchar] (250) NULL,"
				sql = sql & "[description] [nvarchar] (250) NULL,"
				sql = sql & "[content] [ntext] NULL,"
				sql = sql & "[mob_content] [ntext] NULL"
				sql = sql & ")"
				cresult = OW.DB.execute(sql)
				if cresult then
					call OW.DB.execute("ALTER TABLE ["& table &"] WITH NOCHECK ADD CONSTRAINT [PK_"& table &"] PRIMARY KEY CLUSTERED ([cid]) ON [PRIMARY]")
				end if
			end select
		end if
		createDBTable = cresult
	end function
	public function createModelTable(byval table,byval primaryKey)
		dim sql,cresult
		table = trim(table)
		if OW.DB.isTableExists(table) then OW.DB.deleteTable(table)
		select case DB_TYPE
		case 0
			sql = "CREATE TABLE ["& table &"] ("
			sql = sql & "["& primaryKey &"] integer PRIMARY KEY NOT NULL"
			sql = sql & ")"
			cresult = OW.DB.execute(sql)
		case 1
			sql = "CREATE TABLE ["& table &"] ("
			sql = sql & "["& primaryKey &"] [int] NOT NULL"
			sql = sql & ")"
			cresult = OW.DB.execute(sql)
			if cresult then
				call OW.DB.execute("ALTER TABLE ["& table &"] WITH NOCHECK ADD CONSTRAINT [PK_"& table &"] PRIMARY KEY CLUSTERED (["& primaryKey &"]) ON [PRIMARY]")
			end if
		end select
	end function
	
end class
class OW_FSO_Class
	
	private sCharSet,sOverWrite
	private iIsWatermarkPng
	
	private sub class_initialize()
		sCharSet   = OW.CharSet
		sOverWrite = true
		iIsWatermarkPng = false
	end sub
	private sub class_terminate()
	end sub
	public Property Let [CharSet](byval str)
		sCharSet = Ucase(str)
	end property
	
	public property Get [CharSet]()
		[CharSet] = sCharSet
	end property
	
	public property Let OverWrite(byval bool)
		sOverWrite = bool
	end property
	
	public property Get OverWrite()
		OverWrite = sOverWrite
	end property
	
	'返回绝对路径(absolute path)
	'无论filepath是相对路径还是绝对路径都转化为绝对路径,如果文件夹路径为空而且是"/////"或"\\\\\"形式的错误路径则返回空字符串
	'E:\web\OpenWBS\wwwroot\ow-content\data\db.asp = ABSPath("ow-content/data/db.asp")
	'E:\web\OpenWBS\wwwroot\ow-content\data\db.asp = ABSPath("/ow-content/data/db.asp")
	public function ABSPath(byval path)
		path = replace(path,"*","")
		path = replace(path,"?","")
		path = replace(path,"""","")
		path = replace(path,"|","")
		path = replace(path,"<","")
		path = replace(path,">","")
		path = replace(path,"../","")
		path = replace(path,"\..","")
		if OW.isNul(path) or OW.isNul(replace(path,"/","")) or OW.isNul(replace(path,"\","")) then
			ABSPath = ""
			exit function
		end if
		'**
		if instr(path,":")>0 then
			path = OW.regReplace(path,"[/]+","/")
		else
			path = replace(path,"\","/")
			path = OW.regReplace(path,"[/]+","/")
			if left(path,1)="/" then
				'path = Mid(path,2)
				path = OW.serverMapPath(path)
			else
				path = OW.serverMapPath(SITE_PATH & path)
			end if
		end if
		if right(path,1)="\" then path=left(path,Len(path)-1)
		ABSPath = path
	end function
	public function wartermarkPosition(byval imgWidth,byval imgHeight,byval wmWidth,byval wmHeight)
		dim arr(1)
		select case OW.config("wartermark_position")
		case 0
			arr(0) = 10
			arr(1) = 10
		case 1
			arr(0) = (imgWidth - wmWidth)/2
			arr(1) = 10
		case 2
			arr(0) = imgWidth - wmWidth - 10
			arr(1) = 10
		case 3
			arr(0) = 10
			arr(1) = (imgHeight - wmHeight)/2
		case 4
			arr(0) = (imgWidth - wmWidth)/2
			arr(1) = (imgHeight - wmHeight)/2
		case 5
			arr(0) = imgWidth - wmWidth - 10
			arr(1) = (imgHeight - wmHeight)/2
		case 6
			arr(0) = 10
			arr(1) = imgHeight - wmHeight - 10
		case 7
			arr(0) = (imgWidth - wmWidth)/2
			arr(1) = imgHeight - wmHeight - 10
		case 8
			arr(0) = imgWidth - wmWidth - 10
			arr(1) = imgHeight - wmHeight - 10
		end select
		wartermarkPosition = arr
	end function
	public function fontLength(byval fontText,byval fontSize)
		dim c,i,length,n
		n = len(fontText)
		length = 0
		for i=1 to n
			c = abs(ascw(mid(fontText,i,1)))
			if c>255 then
				length = length + fontSize
				
			else
				length = length + fontSize/2
			end if
		next
		fontLength = length
	end function
	
	'带SITE_PATH的相对路径
	'/ow-content/uploads/201407131732392658.jpg
	public function addWatermark(byval filepath)
		on error resume next
		dim arr,isPNG,jpeg,wmLogo,wmX,wmY,wmImagePath
		if not iIsWatermarkPng then
			if OW.getFileExName(OW.config("wartermark_image"))="png" then
				iIsWatermarkPng = true
			end if
		end if
		set jpeg = server.createObject("Persits.Jpeg")
		jpeg.Open OW.serverMapPath(filepath)
		if jpeg.OriginalWidth<OW.int(OW.config("wartermark_min_width")) or jpeg.OriginalHeight<OW.int(OW.config("wartermark_min_height")) then
			addWatermark = false
		else
			OW.config("wartermark_transparency") = OW.parseFloat(OW.config("wartermark_transparency"),2)
			if OW.config("wartermark_transparency")>1 then OW.config("wartermark_transparency")=1
			if OW.config("wartermark_transparency")<0 then OW.config("wartermark_transparency")=0
			if OW.config("wartermark_type")=0 then
				wmImagePath = OW.serverMapPath(OW.config("wartermark_image"))
				set wmLogo  = server.CreateObject("Persits.Jpeg")
				wmLogo.open wmImagePath
				arr = wartermarkPosition(jpeg.OriginalWidth,jpeg.OriginalHeight,wmLogo.OriginalWidth,wmLogo.OriginalHeight)
				wmX = arr(0)
				wmY = arr(1)
				if wmX < 0 then wmX=0
				if wmY < 0 then wmY=0
				if iIsWatermarkPng  then
					jpeg.Canvas.DrawPNG wmX,wmY,wmImagePath
				else
					jpeg.Canvas.DrawImage wmX,wmY,wmLogo,OW.config("wartermark_transparency")
				end if
				jpeg.save OW.serverMapPath(filepath)
				set wmLogo = nothing
			else
				arr = wartermarkPosition(jpeg.OriginalWidth,jpeg.OriginalHeight,fontLength(OW.config("wartermark_font"),OW.config("wartermark_font_size")),OW.config("wartermark_font_size"))
				wmX = arr(0)
				wmY = arr(1)
				if wmX < 0 then wmX=0
				if wmY < 0 then wmY=0
				jpeg.Canvas.Font.Size    = OW.config("wartermark_font_size")
				jpeg.Canvas.Font.Color   = OW.reps(OW.config("wartermark_font_color"),"#","&H")
				jpeg.Canvas.Font.Bold    = false
				jpeg.Canvas.Font.Family  = "宋体"
				jpeg.Canvas.Print wmX,wmY,OW.config("wartermark_font")
				jpeg.Save server.MapPath(filepath)
				jpeg.Quality= 98
				
			end if
			addWatermark = true
		end if
		set jpeg = nothing
		if err.number<>0 then
			err.clear
			addWatermark = false
		end if
	end function
	public function checkFSOInstalled()
		if OW.isFSOInstalled = false then
			OW.Error.Msg = "OW.FSO.checkFSOInstalled()"
			OW.Error.raise 1
			err.clear()
		end if
	end function
	
	'创建文件夹(相对或绝对路径)
	'OW.FSO.createFolder("")
	'OW.FSO.createFolder("ow-content/uploads/214/")
	'系统不支持FSO则程序终止,提示系统不支持FSO(Lang_ObjFSONotInstalled)
	'创建失败则返回false
	'创建成功则返回正确的绝对路径okPath(E:\wwwoot\CMS\ASP\OpenWBS\wwwroot\attachment\image\201012\27)
	public function createFolder(byval folderPath)
		call checkFSOInstalled()
		dim okPath,i
		dim pFolderExists : pFolderExists = false
		createFolder  = false
		folderPath = ABSPath(folderPath)

		if not(OW.isNul(folderPath)) then'如果路径有效
			folderPath=split(folderPath,"\")
			for i=0 to ubound(folderPath)
				if i=0 then
					okPath = trim(folderPath(i))
				else
					if trim(folderPath(i))<>"" then
						okPath = okPath &"\"& trim(folderPath(i))
				    end if
				end if

				if i>0 then
					'判断是否对系统文件有读取权限
					if pFolderExists=false then
						if not OW.ObjectFSO.folderExists(okPath)=false then
							pFolderExists = true
						end if
					end if

					'对系统文件有读取权限则继续判断子文件夹是否存在(不存在则创建)
					if pFolderExists=true then
						on error resume next
						'如果文件不存在则创建文件夹
						if OW.ObjectFSO.folderExists(okPath)=false then
							call createFolderByFSO(okPath)
						end if
						if err.number<>0 then
							OW.Error.Msg = okPath
							OW.Error.raise 20
							err.clear()
						end if
					end if
				end if
			next
			createFolder = okPath
		end if
	end function
	
	'通FSO创建文件夹,创建成功返回true,创建失败返回false
	public function createFolderByFSO(byval folderPath)
		err.clear()
		on error resume next
		dim result : result = true
		OW.ObjectFSO.createFolder(folderPath)
		if err.number<>0 then
			result = false
		end if
		err.clear()
		createFolderByFSO = result
	end function
	
	'[fileABSPath:要删除的文件的绝对路径]删除成功返回true,文件不存在或删除失败返回false
	public function deleteFile(byval fileABSPath)
		dim result : result = true
		on error resume next
		OW.ObjectFSO.deleteFile(fileABSPath)
		if err.number<>0 then
			result = false
		else
			result = true
		end if
		err.clear()
		deleteFile = result
	end function
	
	'删除文件夹
	'OW.FSO.deleteFolder(OW.FSO.ABSPath(folderPath))
	public function deleteFolder(byval folderABSPath)
		dim result : result = true
		on error resume next
		OW.ObjectFSO.deleteFolder(folderABSPath)
		if err.number<>0 then
			result = false
		else
			result = true
		end if
		err.clear()
		deleteFolder = result
	end function
	
	'拷贝文件
	'OW.FSO.fileCopy("ow-content/data/db.asp","ow-content/data/backup/db_1.asp")
	public function fileCopy(byval fromFilePath,byval toFilePath)
		on error resume next
		dim result : result = true
		if fromFilePath="" or toFilePath="" then fileCopy = false : exit function
		OW.ObjectFSO.copyFile ABSPath(fromFilePath),ABSPath(toFilePath)
		if err.number<>0 then
			result = false
			err.clear()
		end if
		fileCopy = result
	end function
	
	'文件是否存在
	'OW.FSO.fileExists("ow-content/uploads/201306181020401339.jpg")
	public function fileExists(byval filepath)
		on error resume next
		dim restult
		filepath = ABSPath(filepath)
		restult = OW.ObjectFSO.FileExists(filepath)
		if err.number<>0 then
			restult = false
			'OW.Error.Msg = "OW.FSO.fileExists("""& filepath &""")"
			'OW.Error.raise 1
			err.clear()
		end if
		fileExists = restult
	end function
	
	'获取文件列表数据
	'fileList("ow-content/uploads/","json")
	public function fileList(byval folderPath,byval returnType)
		dim i,f,fi,folder,arr,json,html,mapPath,tmp
		folderPath = OW.parseFolderPath(folderPath)
		if folderPath = "/" then folderPath = ""
		'**
		mapPath = OW.serverMapPath(SITE_PATH & folderPath)
		'**
		set f = OW.objectFSO
		if f.folderExists(mapPath)=false then
			fileList = "{""foldername"":"""& OW.getFolderName(folderPath) &""",""size"":""0"",""datetime"":"""",""folderpath"":"""& folderPath &""",""filecount"":""0"",""files"":[],""folderexists"":""false""}"
			exit function
		end if
		
		set folder=f.getFolder(mapPath)
		i = 0
		redim arr(folder.Files.count)
		for each fi in folder.Files
			arr(i) = fi.name
			i      = i + 1
			tmp    = "{""filename"":"""& fi.name &""",""size"":"""& OW.FormatSize(fi.size) &""",""datetime"":"""& fi.datelastmodified &""",""filepath"":"""& folderPath & fi.name &"""}"
			if OW.isNul(json) then
				json = tmp
			else
				json = json &","& tmp
			end if
		next
		json = "{""foldername"":"""& OW.getFolderName(folderPath) &""",""size"":"""& OW.FormatSize(folder.size) &""",""datetime"":"""& folder.datelastmodified &""",""folderpath"":"""& folderPath &""",""filecount"":"""& folder.Files.count &""",""files"":["& json &"]}"
		
		set folder = nothing
		set f    = nothing
		
		select case lcase(returnType)
		case "array" : fileList = arr
		case "html"  : fileList = html
		case "json"  : fileList = json
		end select
	end function
	
	'文件重命名(文件路径,新文件名)
	'OW.FSO.fileRename("ow-content/uploads/201306181020401339.jpg","01.jpg")
	public function fileRename(byval filepath, byval filename)
		if fileExists(filepath) then
			on error resume next
			dim fso,f
			filepath = ABSPath(filepath)
			set fso = OW.objectFSO
			set f = fso.getFile(filepath)
			f.name = filename
			
			set fso = nothing
			set f = nothing
			if err.number<>0 then
				err.clear()
				fileRename = false
			else
				fileRename = true
			end if
		else
			fileRename = false
		end if
	end function
	
	'判断文件是否可写入(filepath为文件的绝对路径)
	public function fileWriteable(byval filepath)
		on error resume next
		dim fileABSPath : fileABSPath = filepath
		dim ado
		set ado = server.createObject("ADODB.Stream")
		With ado
			.Mode = 3
			.Type = 2 '以本模式读取
			.Open
			.CharSet   = sCharSet
			.LoadFromFile fileABSPath
			.SaveToFile fileABSPath,2
			.Close
		end With
		set ado = nothing
		fileWriteable = true
		if err.number<>0 then fileWriteable = false
		err.clear()
	end function
	
	'文件夹是否存在
	'folderExists("ow-content/uploads/")
	public function folderExists(byval folderPath)
		folderPath = ABSPath(folderPath)
		if OW.IsFSOInstalled then
			if OW.ObjectFSO.folderExists(folderPath) then folderExists = true
		else
			folderExists = false
			OW.Error.Msg = "OW.FSO.folderExists("""& folderPath &""")"
			OW.Error.raise 1
			err.clear()
		end if
	end function
	
	'获取文件夹列表数据(文件夹路径,返回类型)
	'folderList("ow-content/uploads/","json")
	public function folderList(byval folderPath,byval returnType)
		dim i,f,folder,subFolder,json,html,mapPath,tmp
		folderPath = OW.parseFolderPath(folderPath)
		if folderPath = "/" then folderPath = ""
		'**
		mapPath = OW.serverMapPath(SITE_PATH & folderPath)
		'**
		set f = OW.objectFSO
		if f.folderExists(mapPath)=false then
			folderList = "{""foldername"":"""& OW.getFolderName(folderPath) &""",""size"":""0"",""datetime"":"""",""folderpath"":"""& folderPath &""",""subfolderscount"":""0"",""subfolders"":[],""folderexists"":""false""}"
			exit function
		end if
		
		i = 0
		set folder=f.getFolder(mapPath)
		for each subFolder in folder.subFolders
			i   = i + 1
			tmp = "{""foldername"":"""& subFolder.name &""",""size"":"""& OW.FormatSize(subFolder.size) &""",""datetime"":"""& subFolder.datelastmodified &""",""folderpath"":"""& folderPath & subFolder.name &"/"",""subfolderscount"":"""& subFolder.SubFolders.count &""",""subfolders"":[],""folderexists"":""true""}"
			if json = "" then
				json = tmp
			else
				json = json &","& tmp
			end if
		next
		json = "{""foldername"":"""& OW.getFolderName(folderPath) &""",""size"":"""& OW.FormatSize(folder.size) &""",""datetime"":"""& folder.datelastmodified &""",""folderpath"":"""& folderPath &""",""subfolderscount"":"""& folder.SubFolders.count &""",""subfolders"":["& json &"],""folderexists"":""true""}"
		
		set folder = nothing
		set f    = nothing
		
		select case lcase(returnType)
		case "json" : folderList = json
		case "html" : folderList = html
		end select
	end function
	
	
	'判断文件夹是否有写入权限(文件夹的绝对路径)
	public function folderWriteable(byval folderPath)
		on error resume next
		dim filepath,text : text = "writeable "& SYS_TIME
		if right(folderPath,1)="\" then
			filepath = folderPath & "testwriteable.txt"
		else
			filepath = folderPath &"\"& "testwriteable.txt"
		end if
		dim ado
		set ado = server.createObject("ADODB.Stream")
		With ado
			.Mode = 3
			.Type = 2
			.Open
			.CharSet   = sCharSet
			.Position  = 0
			.WriteText = text
			.SaveToFile filepath,2
			.Close
		end With
		set ado = nothing
		if err.number<>0 then
			folderWriteable = false
		else
			if fileExists(filepath) then
				folderWriteable = true
				call deleteFile(filepath)
			else
				folderWriteable = false
			end if
		end if
		err.clear()
	end function
	
	'保存文件
	'OW.FSO.saveFile("ow-content/data/db.asp",text)
	public function saveFile(byval filepath, byval text)
		saveFile = saveTextFileByADO(filepath,text)
	end function

	'保存文件
	'OW.FSO.saveTextFile("ow-content/data/db.asp",text)
	public function saveTextFile(byval filepath, byval text)
		saveTextFile = saveTextFileByADO(filepath,text)
	end function
	
	'保存文本文件(直接覆盖保存)[会改变文件的读写权限]，如果文件不存在则自动创建
	public function saveTextFileByADO(byval filepath, byval fileContent)
		on error resume next
		if OW.isNul(filepath) then saveTextFileByADO=false : exit function
		dim ado,folderPath,result
		filepath = ABSPath(filepath)
		
		'检查文件夹是否存在(不存在则创建)
		folderPath = left(filepath,InstrRev(filepath,"\")-1)
		if folderExists(folderPath) = false then
			folderPath = createFolder(folderPath)
		end if
		if folderPath = false then saveTextFileByADO = false : exit function
		
		'开始写入文件
		set ado = server.createObject("ADODB.Stream")
		With ado
			.Mode = 3
			.Type = 2
			.Open
			.CharSet   = sCharSet
			.Position  = 0
			.WriteText = fileContent
			.SaveToFile filepath,2
			.Flush
			.Close
		end With
		set ado = nothing
		result = true
		if err.number<>0 then
			result = false
			OW.Error.Msg = filepath
			OW.Error.raise 30
		end if
		err.clear()
		saveTextFileByADO = result
	end function
	
	'保存文本文件(先打开再保存,修改config.main.asp等文件时采用此方式)[不会改变文件的读写权限]
	public function saveTextFileByFSO(byval fileABSPath,byval text)
		on error resume next
		dim f,fi
		set f  = server.createObject("Scripting.FileSystemObject")     
		set fi = f.OpenTextFile(fileABSPath,2,true)'文件不存在时则创建
		fi.Write text
		set fi = nothing
		set f  = nothing
		if err.number<>0 then
			saveTextFileByFSO = false
		else
			saveTextFileByFSO = true
		end if
		err.clear()
	end function
	
end class
class OW_HTTP_Class
	
	private sTempString,sRelFilePath,sAbsFilePath
	
	public function bytesToBstr(byval body,byval coding)
		on error resume next
		dim stream
		set stream = server.createObject("adodb.stream")
		stream.type = 1
		stream.mode = 3
		stream.open
		stream.write body
		stream.position = 0
		stream.type = 2
		stream.charset = coding
		bytesToBstr = stream.ReadText
		stream.close
		set stream = nothing
		if err.number<>0 then
			err.clear
		end if
	end function

	'getBody(conStr,startStr,overStr,incluL,incluR)
	'conStr   被截取的原字符串
	'startStr 开始字符串
	'overStr  结束字符串
	'incluL   true:返回的结果包含startStr字符串 false:返回的结果不包含startStr字符串
	'incluR   true:返回的结果包含overStr字符串  false:返回的结果不包含overStr字符串
	function getBody(conStr,startStr,overStr,incluL,incluR)
		if conStr="$false$" or conStr="" or isNull(conStr)=true or startStr="" or isNull(startStr)=true or overStr="" or isNull(overStr)=true then
			getBody = "$false$"
			exit function
		end if
		dim start,over
		start = InStrB(1,conStr,startStr,vbBinaryCompare)
		if start <= 0 then
			start = InStrB(1,conStr,replace(startStr,vbCrLf,chr(10)),vbBinaryCompare)
			if start <= 0 then
				start = InStrB(1,conStr,replace(startStr,vbCrLf,chr(13)),vbBinaryCompare)
				if start <= 0 then
					getBody = "$false$"
					exit function
				else
					if incluL = false then
						start = start + LenB(startStr)
					end if
				end if
			else
				if incluL = false then
					start = start + LenB(startStr)
				end if
			end if
		else
			if incluL = false then
				start = start + LenB(startStr)
			end if
		end if
		over = InStrB(start,conStr,overStr,vbBinaryCompare)
		if over <= 0 or over <= start then
			over = InStrB(start,conStr,replace(overStr,vbCrLf,chr(10)),vbBinaryCompare)
			if over <= 0 or over <= start then
				over = InStrB(start,conStr,replace(overStr,vbCrLf,chr(13)),vbBinaryCompare)
				if over <= 0 or over <= start then
					getBody = "$false$"
					exit function
				else
					if incluR = true then
						over = over + LenB(overStr)
					end if
				end if
			else
				if incluR = true then
					over = over + LenB(overStr)
				end if
			end if
		else
			if incluR = true then
				over = over + LenB(overStr)
			end if
		end if
		getBody = MidB(conStr,start,over - start)
	end function
	public function getData(byval url,byval coding)
		getData = httpRequest("GET",url,"",coding)
	end function
	public function postData(byval url,byval data,byval coding)
		postData = httpRequest("POST",url,data,coding)
	end function
	public function httpRequest(byval method,byval url,byval data,byval coding)
		dim i,http,xmlHttp,return
		if OW.isNul(url) or len(url)<8 then
			httpRequest = ""
			exit function
		end if
		method  = OW.iif(ucase(method)="GET","GET","POST")
		xmlHttp = array("Msxml2.ServerXMLHTTP.3.0","Msxml2.ServerXMLHTTP.6.0","Microsoft.XMLHTTP","MSXML2.serverXMLHTTP","MSXML2.XMLHTTP","WinHttp.WinHttpRequest.5.1")
		coding  = OW.trim(coding)
		coding  = OW.iif(OW.isNul(coding),OW.charset,coding)
		do while true
			on error resume next
			if OW.isObjInstalled(xmlHttp(i)) then
				set http = server.createObject(xmlHttp(i))
				http.open method,url,false
				if method="GET" then
					http.send
					if http.readystate<>4 then
						return = ""
					else
						return = bytesToBstr(http.ResponseBody,coding)
					end if
				else
					http.setRequestHeader "Content-Type","application/x-www-form-urlencoded"
					http.send data
					return = bytesToBstr(http.ResponseBody,coding)
					'return = http.responseText
				end if
				if err.number<>0 then
					err.clear
				else
					exit do
				end if
				if i<ubound(xmlHttp) then
					i = i+1
				else
					exit do
				end if
			end if
		loop
		'**
		set http = nothing
		httpRequest = return
	end function
	
	'locPath为相对文件路径
	public function saveRemoteFile(byval remoteUrl,byval locPath)
		if OW.isNul(locPath) then
			saveRemoteFile = false
			exit function
		end if
		on error resume next
		dim folderPath,ado,xHttp,remoteData
		folderPath = OW.getFolderPath(locPath)
		if not(OW.FSO.folderExists(folderPath)) then
			call OW.FSO.createFolder(folderPath)
		end if
		set xHttp = server.createObject("Microsoft.XMLHTTP")
		with xHttp
			.open "get",remoteUrl,false,"",""
			.send
			remoteData = .responseBody
		end with
		if err.number<>0 then
			err.clear
			saveRemoteFile = false
			exit function
		end if
		set xHttp = Nothing
		set ado = server.createObject("Adodb.Stream")
		with ado
			.type = 1
			.open
			.write remoteData
			.saveToFile OW.serverMapPath(SITE_PATH & locPath),2
			.cancel
			.close
		end with
		set ado = Nothing
		if err.number<>0 then
			err.clear
			saveRemoteFile = false
		else
			saveRemoteFile = true
		end if
	end function

end class
class OW_JSON_Class
	private sub class_initialize()
	end sub
	private sub class_terminate()
	end sub
	
	'OW.JSON.parse(str)
	public function parse(byval str)
		set parse = JSON.parse(str)
	end function
	public function stringify(byval obj)
		stringify = JSON.stringify(obj)
	end function
end class
%>
<script language="javascript" runat="server">
/**
 * http://tforster.wik.is/ASP_Classic_Practices_For_The_21st_Century/JSON4ASP
**/
if(!Array.prototype.get){Array.prototype.get=function(prop){return this[prop];}}"use strict";if(!this.JSON){JSON={};}
(function(){function f(n){return n<10?'0'+n:n;}
if(typeof Date.prototype.toJSON!=='function'){Date.prototype.toJSON=function(key){return isFinite(this.valueOf())?this.getUTCFullYear()+'-'+
f(this.getUTCMonth()+1)+'-'+
f(this.getUTCDate())+'T'+
f(this.getUTCHours())+':'+
f(this.getUTCMinutes())+':'+
f(this.getUTCSeconds())+'Z':null;};String.prototype.toJSON=Number.prototype.toJSON=Boolean.prototype.toJSON=function(key){return this.valueOf();};}
var cx=/[\u0000\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,escapable=/[\\\"\x00-\x1f\x7f-\x9f\u00ad\u0600-\u0604\u070f\u17b4\u17b5\u200c-\u200f\u2028-\u202f\u2060-\u206f\ufeff\ufff0-\uffff]/g,gap,indent,meta={'\b':'\\b','\t':'\\t','\n':'\\n','\f':'\\f','\r':'\\r','"':'\\"','\\':'\\\\'},rep;function quote(string){escapable.lastIndex=0;return escapable.test(string)?'"'+string.replace(escapable,function(a){var c=meta[a];return typeof c==='string'?c:'\\u'+('0000'+a.charCodeAt(0).toString(16)).slice(-4);})+'"':'"'+string+'"';}
function str(key,holder){var i,k,v,length,mind=gap,partial,value=holder[key];if(value&&typeof value==='object'&&typeof value.toJSON==='function'){value=value.toJSON(key);}
if(typeof rep==='function'){value=rep.call(holder,key,value);}
switch(typeof value){case'string':return quote(value);case'number':return isFinite(value)?String(value):'null';case'boolean':case'null':return String(value);case'object':if(!value){return'null';}
gap+=indent;partial=[];if(Object.prototype.toString.apply(value)==='[object Array]'){length=value.length;for(i=0;i<length;i+=1){partial[i]=str(i,value)||'null';}
v=partial.length===0?'[]':gap?'[\n'+gap+
partial.join(',\n'+gap)+'\n'+
mind+']':'['+partial.join(',')+']';gap=mind;return v;}
if(rep&&typeof rep==='object'){length=rep.length;for(i=0;i<length;i+=1){k=rep[i];if(typeof k==='string'){v=str(k,value);if(v){partial.push(quote(k)+(gap?': ':':')+v);}}}}else{for(k in value){if(Object.hasOwnProperty.call(value,k)){v=str(k,value);if(v){partial.push(quote(k)+(gap?': ':':')+v);}}}}
v=partial.length===0?'{}':gap?'{\n'+gap+partial.join(',\n'+gap)+'\n'+
mind+'}':'{'+partial.join(',')+'}';gap=mind;return v;}}
if(typeof JSON.stringify!=='function'){JSON.stringify=function(value,replacer,space){var i;gap='';indent='';if(typeof space==='number'){for(i=0;i<space;i+=1){indent+=' ';}}else if(typeof space==='string'){indent=space;}
rep=replacer;if(replacer&&typeof replacer!=='function'&&(typeof replacer!=='object'||typeof replacer.length!=='number')){throw new Error('JSON.stringify');}
return str('',{'':value});};}
if(typeof JSON.parse!=='function'){JSON.parse=function(text,reviver){var j;function walk(holder,key){var k,v,value=holder[key];if(value&&typeof value==='object'){for(k in value){if(Object.hasOwnProperty.call(value,k)){v=walk(value,k);if(v!==undefined){value[k]=v;}else{delete value[k];}}}}
return reviver.call(holder,key,value);}
cx.lastIndex=0;if(cx.test(text)){text=text.replace(cx,function(a){return'\\u'+
('0000'+a.charCodeAt(0).toString(16)).slice(-4);});}
if(/^[\],:{}\s]*$/.test(text.replace(/\\(?:["\\\/bfnrt]|u[0-9a-fA-F]{4})/g,'@').replace(/"[^"\\\n\r]*"|true|false|null|-?\d+(?:\.\d*)?(?:[eE][+\-]?\d+)?/g,']').replace(/(?:^|:|,)(?:\s*\[)+/g,''))){j=eval('('+text+')');return typeof reviver==='function'?walk({'':j},''):j;}
throw new SyntaxError('JSON.parse');};}}());
</script>
<%
class OW_Cookie_Class

	public cookiePre  'cookie 前缀
	public domain     'cookie 作用域
	public path       'cookie 作用路径
	public isEncrypt  '是否对Cookie加密
	public isSecure   'cookie 发送条件 true:仅限加密连接 false:任意类型的连接
	
	private sub class_initialize()
	end sub
	private sub class_terminate()
	end sub
	private function encrypt(byval s)
		encrypt = OW.Base64.Encode(s)
	end function
	private function decrypt(byval s)
		decrypt = OW.Base64.Decode(s)
	end function
	
	function attrTest(byval s, byval t)
		dim rule
		select case lcase(t)
			case "int"		rule = "^[-\+]?\d+$"
			case "domain"	rule = "^(([\da-zA-Z][\da-zA-Z-]{0,61})?[\da-zA-Z]\.)+([a-zA-Z]{2,4}(?:\.[a-zA-Z]{2})?)$"
			case "ip"		rule = "^((25[0-5]|2[0-4]\d|(1\d|[1-9])?\d)\.){3}(25[0-5]|2[0-4]\d|(1\d|[1-9])?\d)$"
			case else rule = t
		end select
		attrTest = OW.regTest(cstr(s),rule)
	end function

	'OW.Cookie.getCookie("ip")
	'OW.Cookie.getCookie("my:id")
	'OW.Cookie.getCookie("goods:price")
	public function getCookie(byval key)
		'on error resume next
		if key="" then getCookie="" : exit function
		dim arr,subKey,c
		if instr(key,":") > 0 then
			arr = split(key,":")
			key = arr(0)
			subKey = arr(1)
		end if
		if key<>"" then
			key = cookiePre & key
			if OW.isNul(subKey) then
				c = request.cookies(key)
			else
				if request.cookies(key).HasKeys then c = request.cookies(key)(subKey)
			end if
			if isEncrypt then c = decrypt(c)
		else
			c = ""
		end if
		if Err.number <> 0 then Err.Clear
		getCookie = c
	end function
	
	'OW.Cookie.setCookie("ip","192.168.0.1",240)
	public function setCookie(byval key, byval v, byval opt)
		'on error resume next
		dim i,a,exps,arr,subKey,domain_,path_,secure_
		if instr(key,":") > 0 then
			arr  = split(key,":")
			key = arr(0)
			subKey = arr(1)
		end if
		'**
		if key<>"" then
			'**
			if isArray(opt) then
				for i = 0 to ubound(opt)
					a = opt(i)
					if isDate(a) then
						exps = CDate(a)
					elseif attrTest(a,"int") then
						if a<>0 then exps = now() + int(a)/60/24
					elseif attrTest(a,"domain") or attrTest(a,"ip") then
						domain_ = a
					elseif instr(a,"/")>0 then
						path_ = a
					elseif lcase(a)="true" or lcase(a)="false" then
						secure_ = a
					end if
				next
			else
				a = opt
				if isDate(a) then
					exps = CDate(a)
				elseif attrTest(a,"int") then
					if a<>0 then exps = now() + int(a)/60/24
				elseif attrTest(a,"domain") or attrTest(a,"ip") then
					domain_ = a
				elseif instr(a,"/")>0 then
					path_ = a
				elseif lcase(a)="true" or lcase(a)="false" then
					secure_ = a
				end if
			end if
			key = cookiePre & key
			if isEncrypt and v<>"" then v = encrypt(v)
			if OW.isNul(subKey) then
				response.cookies(key) = v
			else
				response.cookies(key)(subKey) = v
			end if
			if OW.isNul(domain_) then domain_ = domain
			if OW.isNul(path_)   then path_   = path
			if OW.isNul(secure_) then secure_ = isSecure
			if not(OW.isNul(exps))     then response.cookies(key).expires = exps
			if not(OW.isNul(domain_))  then response.cookies(key).domain  = domain_
			if not(OW.isNul(path_))    then response.cookies(key).path    = path_
			if not(OW.isNul(secure_))  then response.cookies(key).secure  = secure_
		end if
		'if err.number <> 0 then err.clear
	end function
	public sub removeCookie(byval key)
		dim arr,subKey
		if instr(key,":") > 0 then
			arr     = split(key,":")
			key    = arr(0)
			subKey = arr(1)
		end if
		if key<>"" then
			key = cookiePre & key
			if OW.isNul(subKey) then
				response.cookies(key) = empty
				'response.cookies(key).Expires = Now()'formatDateTime(Now)'SysTime'Now()
			else
				if request.cookies(key).HasKeys then response.cookies(key)(subKey) = empty
			end if
		end if
	end sub
	private sub clear()
		dim key
		for each key in request.cookies
			response.cookies(key) = empty
			'response.cookies(key).Expires = formatDateTime(Now)
		next
	end sub
end class
class OW_Session_Class
	public isEncrypt,sessionPre,[timeout],appSessionNumLimit
	
	private sub class_initialize()
		appSessionNumLimit = 5000
	end sub
	private sub class_terminate()
	end sub
	private function encrypt(byval s)
		encrypt = OW.Base64.Encode(s)
	end function
	private function decrypt(byval s)
		decrypt = OW.Base64.Decode(s)
	end function
	
	'**application session
	'**expiresTime存活时间(s)
	'OW.Session.getAppSession("key",7200)
	public function getAppSession(byval key,byval expiresTime)
		dim arr,t
		expiresTime = OW.int(expiresTime)
		arr         = application(sessionPre & key)
		if isArray(arr) then
			if OW.dateDiff("s",cdate(arr(1)),SYS_TIME) < expiresTime then
				getAppSession = arr(0)
			else
				getAppSession = ""
				call removeAppSession(sessionPre & key)
			end if
		else
			getAppSession = ""
			call removeAppSession(sessionPre & key)
		end if
	end function
	public sub setAppSession(byval key ,byval v)
		key = sessionPre & key
		application(key) = array(v,SYS_TIME)
		if application.contents.count > appSessionNumLimit then
			call clearTimeoutAppSession()
		end if
	end sub
	
	'更新用户session时间
	public sub updateAppSession(byval key)
		dim arr
		arr = application(sessionPre & key)
		if isArray(arr) then
			application(sessionPre & key) = array(arr(0),SYS_TIME)
		end if
	end sub
	
	'清理超时的用户session记录
	public sub clearTimeoutAppSession()
		dim key,val
		for each key in application.contents
			val = application.Contents(key)
			if isArray(val) then
				if dateDiff("n",cdate(val(1)),SYS_TIME) > OW.loginTimeout then
					call removeAppSession(key)
				end if
			end if
		next
	end sub
	public sub removeAppSession(byval key)
		if left(key,len(sessionPre))<>sessionPre then
			key = sessionPre & key
		end if
		application.lock
		application.contents.remove(key)
		application.unLock
	end sub
	public sub removeAllAppSession()
		dim key
		for each key in application.contents
			application.lock
			application.contents.remove(key)
			application.unLock
		next
	end sub
	
	'******
	public function getSession(byval key)
		dim v
		if key<>"" then
			key = sessionPre & key
			if isObject(session(key)) then
				set getSession = session(key)
			else
				v = session(key)
				if isEncrypt then v = decrypt(v)
				getSession = v
			end if
		else
			getSession = ""
		end if
	end function
	public sub setSession(byval key, byval v)
		key = sessionPre & key
		if isObject(v) then
			set session(key) = v
		else
			if isEncrypt then v = encrypt(v)
			session(key) = v
		end if
		session.Timeout = timeout
	end sub
	public sub removeSession(byval key)
		key = sessionPre & key
		if isObject(session(key)) then
			set session(key) = nothing
		end if
        session.Contents.remove(key)
	end sub
	public sub removeAll()
        session.Contents.removeAll()
	end sub
	private sub clear()
		session.Abandon()
	end sub
end class
'**
'Feature     : 32 LM MD5 HASH
'Update Date : 2010-11-03 14:46:12
'Description : Encrypt strings with MD5 in OpenWBS
'**
class OW_MD5_Class
	
	private BITS_TO_A_BYTE,BYTES_TO_A_WORD,BITS_TO_A_WORD
	
	private m_lOnBits(30)
	private m_l2Power(30)
	
	private sub class_initialize()
		BITS_TO_A_BYTE  = 8
		BYTES_TO_A_WORD = 4
		BITS_TO_A_WORD  = 32
		
	end sub
	public function encode(byval s)
		s = trim(s)
		if s = "" then encrypt = "" : exit function
		encode = MD5(s,OW.charset)
	end function
	public function encrypt(byval s)
		s = trim(s)
		if s = "" then encrypt = "" : exit function
		'die lcase(OW.charset) &"<br>"
		encrypt = MD5(s,lcase(OW.charset))
	end function
	
	private function LShift(lValue, iShiftBits)
		if iShiftBits = 0 then
			LShift = lValue
			Exit function
		ElseIf iShiftBits = 31 then
			if lValue And 1 then
				LShift = &H80000000
			else
				LShift = 0
			end if
			Exit function
		ElseIf iShiftBits < 0 Or iShiftBits > 31 then
			Err.Raise 6
		end if
	
		if (lValue And m_l2Power(31 - iShiftBits)) then
			LShift = ((lValue And m_lOnBits(31 - (iShiftBits + 1))) * m_l2Power(iShiftBits)) Or &H80000000
		else
			LShift = ((lValue And m_lOnBits(31 - iShiftBits)) * m_l2Power(iShiftBits))
		end if
	end function
	
	private function str2bin(varstr) 
		dim varasc
		dim i
		dim varchar
		dim varlow
		dim varhigh
		
		str2bin="" 
		for i=1 to Len(varstr) 
			varchar=mid(varstr,i,1) 
			varasc = Asc(varchar) 
			
			if varasc<0 then 
			varasc = varasc + 65535 
			end if 
			
			if varasc>255 then 
			varlow = Left(Hex(Asc(varchar)),2) 
			varhigh = right(Hex(Asc(varchar)),2) 
			str2bin = str2bin & chrB("&H" & varlow) & chrB("&H" & varhigh) 
			else 
			str2bin = str2bin & chrB(AscB(varchar)) 
			end if 
		next 
	end function 
	
	private function str2bin_utf(varstr)
		dim varchar, code, codearr, j, i
		str2bin_utf = ""
		for i=1 to Len(varstr)
			varchar = Mid(varstr,i,1)
			code = Server.UrlEncode(varchar)
			if(code="+") then code="%20"
			if Len(code) = 1 then
			   str2bin_utf = str2bin_utf & chrB(AscB(code))
			else
			   codearr = Split(code,"%")
			   for j = 1 to UBound(codearr)
				  str2bin_utf = str2bin_utf & ChrB("&H" & codearr(j))
			   next
			 end if
		next
	end function
	
	private function RShift(lValue, iShiftBits)
		if iShiftBits = 0 then
			RShift = lValue
			Exit function
		ElseIf iShiftBits = 31 then
			if lValue And &H80000000 then
				RShift = 1
			else
				RShift = 0
			end if
			Exit function
		ElseIf iShiftBits < 0 Or iShiftBits > 31 then
			Err.Raise 6
		end if
	
		RShift = (lValue And &H7FFFFFFE) \ m_l2Power(iShiftBits)
	
		if (lValue And &H80000000) then
			RShift = (RShift Or (&H40000000 \ m_l2Power(iShiftBits - 1)))
		end if
	end function
	
	private function RotateLeft(lValue, iShiftBits)
		RotateLeft = LShift(lValue, iShiftBits) Or RShift(lValue, (32 - iShiftBits))
	end function
	
	private function AddUnsigned(lX, lY)
		dim lX4
		dim lY4
		dim lX8
		dim lY8
		dim lResult
	
		lX8 = lX And &H80000000
		lY8 = lY And &H80000000
		lX4 = lX And &H40000000
		lY4 = lY And &H40000000
		
		lResult = (lX And &H3FFFFFFF) + (lY And &H3FFFFFFF)
	
		if lX4 And lY4 then
			lResult = lResult Xor &H80000000 Xor lX8 Xor lY8
		ElseIf lX4 Or lY4 then
			if lResult And &H40000000 then
				lResult = lResult Xor &HC0000000 Xor lX8 Xor lY8
			else
				lResult = lResult Xor &H40000000 Xor lX8 Xor lY8
			end if
		else
			lResult = lResult Xor lX8 Xor lY8
		end if
	
		AddUnsigned = lResult
	end function
	
	private function md5_F(x, y, z)
		md5_F = (x And y) Or ((Not x) And z)
	end function
	
	private function md5_G(x, y, z)
		md5_G = (x And z) Or (y And (Not z))
	end function
	
	private function md5_H(x, y, z)
		md5_H = (x Xor y Xor z)
	end function
	
	private function md5_I(x, y, z)
		md5_I = (y Xor (x Or (Not z)))
	end function
	
	private Sub md5_FF(a, b, c, d, x, s, ac)
		a = AddUnsigned(a, AddUnsigned(AddUnsigned(md5_F(b, c, d), x), ac))
		a = RotateLeft(a, s)
		a = AddUnsigned(a, b)
	end sub
	private Sub md5_GG(a, b, c, d, x, s, ac)
		a = AddUnsigned(a, AddUnsigned(AddUnsigned(md5_G(b, c, d), x), ac))
		a = RotateLeft(a, s)
		a = AddUnsigned(a, b)
	end sub
	private Sub md5_HH(a, b, c, d, x, s, ac)
		a = AddUnsigned(a, AddUnsigned(AddUnsigned(md5_H(b, c, d), x), ac))
		a = RotateLeft(a, s)
		a = AddUnsigned(a, b)
	end sub
	private Sub md5_II(a, b, c, d, x, s, ac)
		a = AddUnsigned(a, AddUnsigned(AddUnsigned(md5_I(b, c, d), x), ac))
		a = RotateLeft(a, s)
		a = AddUnsigned(a, b)
	end sub
	private function ConvertToWordArray(sMessage)
		dim lMessageLength
		dim lNumberOfWords
		dim lWordArray()
		dim lBytePosition
		dim lByteCount
		dim lWordCount
		
		Const MODULUS_BITS = 512
		Const CONGRUENT_BITS = 448
		
		lMessageLength = LenB(sMessage)
		
		lNumberOfWords = (((lMessageLength + ((MODULUS_BITS - CONGRUENT_BITS) \ BITS_TO_A_BYTE)) \ (MODULUS_BITS \ BITS_TO_A_BYTE)) + 1) * (MODULUS_BITS \ BITS_TO_A_WORD)
		ReDim lWordArray(lNumberOfWords - 1)
		
		lBytePosition = 0
		lByteCount = 0
		Do Until lByteCount >= lMessageLength
			lWordCount = lByteCount \ BYTES_TO_A_WORD
			lBytePosition = (lByteCount Mod BYTES_TO_A_WORD) * BITS_TO_A_BYTE
			lWordArray(lWordCount) = lWordArray(lWordCount) Or LShift(AscB(MidB(sMessage, lByteCount + 1, 1)), lBytePosition)
			lByteCount = lByteCount + 1
		Loop
	
		lWordCount = lByteCount \ BYTES_TO_A_WORD
		lBytePosition = (lByteCount Mod BYTES_TO_A_WORD) * BITS_TO_A_BYTE
		
		lWordArray(lWordCount) = lWordArray(lWordCount) Or LShift(&H80, lBytePosition)
		
		lWordArray(lNumberOfWords - 2) = LShift(lMessageLength, 3)
		lWordArray(lNumberOfWords - 1) = RShift(lMessageLength, 29)
	
		ConvertToWordArray = lWordArray
	end function
	
	private function WordToHex(lValue)
		dim lByte
		dim lCount
		
		for lCount = 0 to 3
			lByte = RShift(lValue, lCount * BITS_TO_A_BYTE) And m_lOnBits(BITS_TO_A_BYTE - 1)
			WordToHex = WordToHex & Right("0" & Hex(lByte), 2)
		next
	end function
	
	private function MD5(sMessage,input_charset)
		m_lOnBits(0) = CLng(1)
		m_lOnBits(1) = CLng(3)
		m_lOnBits(2) = CLng(7)
		m_lOnBits(3) = CLng(15)
		m_lOnBits(4) = CLng(31)
		m_lOnBits(5) = CLng(63)
		m_lOnBits(6) = CLng(127)
		m_lOnBits(7) = CLng(255)
		m_lOnBits(8) = CLng(511)
		m_lOnBits(9) = CLng(1023)
		m_lOnBits(10) = CLng(2047)
		m_lOnBits(11) = CLng(4095)
		m_lOnBits(12) = CLng(8191)
		m_lOnBits(13) = CLng(16383)
		m_lOnBits(14) = CLng(32767)
		m_lOnBits(15) = CLng(65535)
		m_lOnBits(16) = CLng(131071)
		m_lOnBits(17) = CLng(262143)
		m_lOnBits(18) = CLng(524287)
		m_lOnBits(19) = CLng(1048575)
		m_lOnBits(20) = CLng(2097151)
		m_lOnBits(21) = CLng(4194303)
		m_lOnBits(22) = CLng(8388607)
		m_lOnBits(23) = CLng(16777215)
		m_lOnBits(24) = CLng(33554431)
		m_lOnBits(25) = CLng(67108863)
		m_lOnBits(26) = CLng(134217727)
		m_lOnBits(27) = CLng(268435455)
		m_lOnBits(28) = CLng(536870911)
		m_lOnBits(29) = CLng(1073741823)
		m_lOnBits(30) = CLng(2147483647)
		
		m_l2Power(0) = CLng(1)
		m_l2Power(1) = CLng(2)
		m_l2Power(2) = CLng(4)
		m_l2Power(3) = CLng(8)
		m_l2Power(4) = CLng(16)
		m_l2Power(5) = CLng(32)
		m_l2Power(6) = CLng(64)
		m_l2Power(7) = CLng(128)
		m_l2Power(8) = CLng(256)
		m_l2Power(9) = CLng(512)
		m_l2Power(10) = CLng(1024)
		m_l2Power(11) = CLng(2048)
		m_l2Power(12) = CLng(4096)
		m_l2Power(13) = CLng(8192)
		m_l2Power(14) = CLng(16384)
		m_l2Power(15) = CLng(32768)
		m_l2Power(16) = CLng(65536)
		m_l2Power(17) = CLng(131072)
		m_l2Power(18) = CLng(262144)
		m_l2Power(19) = CLng(524288)
		m_l2Power(20) = CLng(1048576)
		m_l2Power(21) = CLng(2097152)
		m_l2Power(22) = CLng(4194304)
		m_l2Power(23) = CLng(8388608)
		m_l2Power(24) = CLng(16777216)
		m_l2Power(25) = CLng(33554432)
		m_l2Power(26) = CLng(67108864)
		m_l2Power(27) = CLng(134217728)
		m_l2Power(28) = CLng(268435456)
		m_l2Power(29) = CLng(536870912)
		m_l2Power(30) = CLng(1073741824)
		
		
		dim x
		dim k
		dim AA
		dim BB
		dim CC
		dim DD
		dim a
		dim b
		dim c
		dim d
		
		Const S11 = 7
		Const S12 = 12
		Const S13 = 17
		Const S14 = 22
		Const S21 = 5
		Const S22 = 9
		Const S23 = 14
		Const S24 = 20
		Const S31 = 4
		Const S32 = 11
		Const S33 = 16
		Const S34 = 23
		Const S41 = 6
		Const S42 = 10
		Const S43 = 15
		Const S44 = 21
		
		if LCase(input_charset) = "utf-8" then 
			x = ConvertToWordArray(str2bin_utf(sMessage))
		else
			x = ConvertToWordArray(str2bin(sMessage))
		end if
		
		a = &H67452301
		b = &HEFCDAB89
		c = &H98BADCFE
		d = &H10325476
		
		for k = 0 to UBound(x) Step 16
			AA = a
			BB = b
			CC = c
			DD = d
			
			md5_FF a, b, c, d, x(k + 0), S11, &HD76AA478
			md5_FF d, a, b, c, x(k + 1), S12, &HE8C7B756
			md5_FF c, d, a, b, x(k + 2), S13, &H242070DB
			md5_FF b, c, d, a, x(k + 3), S14, &HC1BDCEEE
			md5_FF a, b, c, d, x(k + 4), S11, &HF57C0FAF
			md5_FF d, a, b, c, x(k + 5), S12, &H4787C62A
			md5_FF c, d, a, b, x(k + 6), S13, &HA8304613
			md5_FF b, c, d, a, x(k + 7), S14, &HFD469501
			md5_FF a, b, c, d, x(k + 8), S11, &H698098D8
			md5_FF d, a, b, c, x(k + 9), S12, &H8B44F7AF
			md5_FF c, d, a, b, x(k + 10), S13, &HFFFF5BB1
			md5_FF b, c, d, a, x(k + 11), S14, &H895CD7BE
			md5_FF a, b, c, d, x(k + 12), S11, &H6B901122
			md5_FF d, a, b, c, x(k + 13), S12, &HFD987193
			md5_FF c, d, a, b, x(k + 14), S13, &HA679438E
			md5_FF b, c, d, a, x(k + 15), S14, &H49B40821
			
			md5_GG a, b, c, d, x(k + 1), S21, &HF61E2562
			md5_GG d, a, b, c, x(k + 6), S22, &HC040B340
			md5_GG c, d, a, b, x(k + 11), S23, &H265E5A51
			md5_GG b, c, d, a, x(k + 0), S24, &HE9B6C7AA
			md5_GG a, b, c, d, x(k + 5), S21, &HD62F105D
			md5_GG d, a, b, c, x(k + 10), S22, &H2441453
			md5_GG c, d, a, b, x(k + 15), S23, &HD8A1E681
			md5_GG b, c, d, a, x(k + 4), S24, &HE7D3FBC8
			md5_GG a, b, c, d, x(k + 9), S21, &H21E1CDE6
			md5_GG d, a, b, c, x(k + 14), S22, &HC33707D6
			md5_GG c, d, a, b, x(k + 3), S23, &HF4D50D87
			md5_GG b, c, d, a, x(k + 8), S24, &H455A14ED
			md5_GG a, b, c, d, x(k + 13), S21, &HA9E3E905
			md5_GG d, a, b, c, x(k + 2), S22, &HFCEFA3F8
			md5_GG c, d, a, b, x(k + 7), S23, &H676F02D9
			md5_GG b, c, d, a, x(k + 12), S24, &H8D2A4C8A
			
			md5_HH a, b, c, d, x(k + 5), S31, &HFFFA3942
			md5_HH d, a, b, c, x(k + 8), S32, &H8771F681
			md5_HH c, d, a, b, x(k + 11), S33, &H6D9D6122
			md5_HH b, c, d, a, x(k + 14), S34, &HFDE5380C
			md5_HH a, b, c, d, x(k + 1), S31, &HA4BEEA44
			md5_HH d, a, b, c, x(k + 4), S32, &H4BDECFA9
			md5_HH c, d, a, b, x(k + 7), S33, &HF6BB4B60
			md5_HH b, c, d, a, x(k + 10), S34, &HBEBFBC70
			md5_HH a, b, c, d, x(k + 13), S31, &H289B7EC6
			md5_HH d, a, b, c, x(k + 0), S32, &HEAA127FA
			md5_HH c, d, a, b, x(k + 3), S33, &HD4EF3085
			md5_HH b, c, d, a, x(k + 6), S34, &H4881D05
			md5_HH a, b, c, d, x(k + 9), S31, &HD9D4D039
			md5_HH d, a, b, c, x(k + 12), S32, &HE6DB99E5
			md5_HH c, d, a, b, x(k + 15), S33, &H1FA27CF8
			md5_HH b, c, d, a, x(k + 2), S34, &HC4AC5665
			
			md5_II a, b, c, d, x(k + 0), S41, &HF4292244
			md5_II d, a, b, c, x(k + 7), S42, &H432AFF97
			md5_II c, d, a, b, x(k + 14), S43, &HAB9423A7
			md5_II b, c, d, a, x(k + 5), S44, &HFC93A039
			md5_II a, b, c, d, x(k + 12), S41, &H655B59C3
			md5_II d, a, b, c, x(k + 3), S42, &H8F0CCC92
			md5_II c, d, a, b, x(k + 10), S43, &HFFEFF47D
			md5_II b, c, d, a, x(k + 1), S44, &H85845DD1
			md5_II a, b, c, d, x(k + 8), S41, &H6FA87E4F
			md5_II d, a, b, c, x(k + 15), S42, &HFE2CE6E0
			md5_II c, d, a, b, x(k + 6), S43, &HA3014314
			md5_II b, c, d, a, x(k + 13), S44, &H4E0811A1
			md5_II a, b, c, d, x(k + 4), S41, &HF7537E82
			md5_II d, a, b, c, x(k + 11), S42, &HBD3AF235
			md5_II c, d, a, b, x(k + 2), S43, &H2AD7D2BB
			md5_II b, c, d, a, x(k + 9), S44, &HEB86D391
			
			a = AddUnsigned(a, AA)
			b = AddUnsigned(b, BB)
			c = AddUnsigned(c, CC)
			d = AddUnsigned(d, DD)
		next
		
		MD5 = LCase(WordToHex(a) & WordToHex(b) & WordToHex(c) & WordToHex(d))
	end function
end class
class OW_MD6_Class
	private m_lOnBits(30)
	private m_l2Power(30)
	'------------------------------------
	private BITS_TO_A_BYTE,BYTES_TO_A_WORD,BITS_TO_A_WORD
	private Pv_Md5Bits
	
	private sub class_initialize()
		BITS_TO_A_BYTE  = 8
		BYTES_TO_A_WORD = 4
		BITS_TO_A_WORD  = 32
		Pv_Md5Bits      = 32
	end sub
	
	'设置生成的MD5的位数
	public Property Let MD5Bits(byval BV_Bits)
		Pv_Md5Bits = BV_Bits
	end property
	public property Get MD5Bits()
		MD5Bits = Pv_Md5Bits
	end property
	
	private function LShift(lValue, iShiftBits)
		if iShiftBits = 0 then
			LShift = lValue
			exit function
		elseIf iShiftBits = 31 then
			if lValue and 1 then
				LShift = &H80000000
			else
				LShift = 0
			end if
			exit function
		elseIf iShiftBits < 0 or iShiftBits > 31 then
			Err.Raise 6
		end if
	
		if (lValue and m_l2Power(31 - iShiftBits)) then
			LShift = ((lValue and m_lOnBits(31 - (iShiftBits + 1))) * m_l2Power(iShiftBits)) or &H80000000
		else
			LShift = ((lValue and m_lOnBits(31 - iShiftBits)) * m_l2Power(iShiftBits))
		end if
	end function
	
	private function RShift(lValue, iShiftBits)
		if iShiftBits = 0 then
			RShift = lValue
			exit function
		elseIf iShiftBits = 31 then
			if lValue and &H80000000 then
				RShift = 1
			else
				RShift = 0
			end if
			exit function
		elseIf iShiftBits < 0 or iShiftBits > 31 then
			Err.Raise 6
		end if
	
		RShift = (lValue and &H7FFFFFFE) \ m_l2Power(iShiftBits)
	
		if (lValue and &H80000000) then
			RShift = (RShift or (&H40000000 \ m_l2Power(iShiftBits - 1)))
		end if
	end function
	
	private function RotateLeft(lValue, iShiftBits)
		RotateLeft = LShift(lValue, iShiftBits) or RShift(lValue, (32 - iShiftBits))
	end function
	
	private function AddUnsigned(lX, lY)
		dim lX4
		dim lY4
		dim lX8
		dim lY8
		dim lResult
	
		lX8 = lX and &H80000000
		lY8 = lY and &H80000000
		lX4 = lX and &H40000000
		lY4 = lY and &H40000000
	
		lResult = (lX and &H3FFFFFFF) + (lY and &H3FFFFFFF)
	
		if lX4 and lY4 then
			lResult = lResult Xor &H80000000 Xor lX8 Xor lY8
		elseIf lX4 or lY4 then
			if lResult and &H40000000 then
				lResult = lResult Xor &HC0000000 Xor lX8 Xor lY8
			else
				lResult = lResult Xor &H40000000 Xor lX8 Xor lY8
			end if
		else
			lResult = lResult Xor lX8 Xor lY8
		end if
	
		AddUnsigned = lResult
	end function
	
	private function md5_F(x, y, z)
		md5_F = (x and y) or ((not x) and z)
	end function
	
	private function md5_G(x, y, z)
		md5_G = (x and z) or (y and (not z))
	end function
	
	private function md5_H(x, y, z)
		md5_H = (x Xor y Xor z)
	end function
	
	private function md5_I(x, y, z)
		md5_I = (y Xor (x or (not z)))
	end function
	
	private sub md5_FF(a, b, c, d, x, s, ac)
		a = AddUnsigned(a, AddUnsigned(AddUnsigned(md5_F(b, c, d), x), ac))
		a = RotateLeft(a, s)
		a = AddUnsigned(a, b)
	end sub
	private sub md5_GG(a, b, c, d, x, s, ac)
		a = AddUnsigned(a, AddUnsigned(AddUnsigned(md5_G(b, c, d), x), ac))
		a = RotateLeft(a, s)
		a = AddUnsigned(a, b)
	end sub
	private sub md5_HH(a, b, c, d, x, s, ac)
		a = AddUnsigned(a, AddUnsigned(AddUnsigned(md5_H(b, c, d), x), ac))
		a = RotateLeft(a, s)
		a = AddUnsigned(a, b)
	end sub
	private sub md5_II(a, b, c, d, x, s, ac)
		a = AddUnsigned(a, AddUnsigned(AddUnsigned(md5_I(b, c, d), x), ac))
		a = RotateLeft(a, s)
		a = AddUnsigned(a, b)
	end sub
	private function ConvertToWordArray(sMessage)
		dim lMessageLength
		dim lNumberOfWords
		dim lWordArray()
		dim lBytePosition
		dim lByteCount
		dim lWordCount
	
		Const MODULUS_BITS = 512
		Const CONGRUENT_BITS = 448
	
		lMessageLength = Len(sMessage)
	
		lNumberOfWords = (((lMessageLength + ((MODULUS_BITS - CONGRUENT_BITS) \ BITS_TO_A_BYTE)) \ (MODULUS_BITS \ BITS_TO_A_BYTE)) + 1) * (MODULUS_BITS \ BITS_TO_A_WORD)
		ReDim lWordArray(lNumberOfWords - 1)
	
		lBytePosition = 0
		lByteCount = 0
		Do Until lByteCount >= lMessageLength
			lWordCount = lByteCount \ BYTES_TO_A_WORD
			lBytePosition = (lByteCount Mod BYTES_TO_A_WORD) * BITS_TO_A_BYTE
			lWordArray(lWordCount) = lWordArray(lWordCount) or LShift(Asc(Mid(sMessage, lByteCount + 1, 1)), lBytePosition)
			lByteCount = lByteCount + 1
		Loop
	
		lWordCount = lByteCount \ BYTES_TO_A_WORD
		lBytePosition = (lByteCount Mod BYTES_TO_A_WORD) * BITS_TO_A_BYTE
	
		lWordArray(lWordCount) = lWordArray(lWordCount) or LShift(&H80, lBytePosition)
	
		lWordArray(lNumberOfWords - 2) = LShift(lMessageLength, 3)
		lWordArray(lNumberOfWords - 1) = RShift(lMessageLength, 29)
	
		ConvertToWordArray = lWordArray
	end function
	
	private function WordToHex(lValue)
		dim lByte
		dim lCount
	
		For lCount = 0 To 3
			lByte = RShift(lValue, lCount * BITS_TO_A_BYTE) and m_lOnBits(BITS_TO_A_BYTE - 1)
			WordToHex = WordToHex & right("0" & Hex(lByte), 2)
		Next
	end function
	public function MD5(sMessage)
		m_lOnBits(0) = CLng(1)
		m_lOnBits(1) = CLng(3)
		m_lOnBits(2) = CLng(7)
		m_lOnBits(3) = CLng(15)
		m_lOnBits(4) = CLng(31)
		m_lOnBits(5) = CLng(63)
		m_lOnBits(6) = CLng(127)
		m_lOnBits(7) = CLng(255)
		m_lOnBits(8) = CLng(511)
		m_lOnBits(9) = CLng(1023)
		m_lOnBits(10) = CLng(2047)
		m_lOnBits(11) = CLng(4095)
		m_lOnBits(12) = CLng(8191)
		m_lOnBits(13) = CLng(16383)
		m_lOnBits(14) = CLng(32767)
		m_lOnBits(15) = CLng(65535)
		m_lOnBits(16) = CLng(131071)
		m_lOnBits(17) = CLng(262143)
		m_lOnBits(18) = CLng(524287)
		m_lOnBits(19) = CLng(1048575)
		m_lOnBits(20) = CLng(2097151)
		m_lOnBits(21) = CLng(4194303)
		m_lOnBits(22) = CLng(8388607)
		m_lOnBits(23) = CLng(16777215)
		m_lOnBits(24) = CLng(33554431)
		m_lOnBits(25) = CLng(67108863)
		m_lOnBits(26) = CLng(134217727)
		m_lOnBits(27) = CLng(268435455)
		m_lOnBits(28) = CLng(536870911)
		m_lOnBits(29) = CLng(1073741823)
		m_lOnBits(30) = CLng(2147483647)
	
		m_l2Power(0) = CLng(1)
		m_l2Power(1) = CLng(2)
		m_l2Power(2) = CLng(4)
		m_l2Power(3) = CLng(8)
		m_l2Power(4) = CLng(16)
		m_l2Power(5) = CLng(32)
		m_l2Power(6) = CLng(64)
		m_l2Power(7) = CLng(128)
		m_l2Power(8) = CLng(256)
		m_l2Power(9) = CLng(512)
		m_l2Power(10) = CLng(1024)
		m_l2Power(11) = CLng(2048)
		m_l2Power(12) = CLng(4096)
		m_l2Power(13) = CLng(8192)
		m_l2Power(14) = CLng(16384)
		m_l2Power(15) = CLng(32768)
		m_l2Power(16) = CLng(65536)
		m_l2Power(17) = CLng(131072)
		m_l2Power(18) = CLng(262144)
		m_l2Power(19) = CLng(524288)
		m_l2Power(20) = CLng(1048576)
		m_l2Power(21) = CLng(2097152)
		m_l2Power(22) = CLng(4194304)
		m_l2Power(23) = CLng(8388608)
		m_l2Power(24) = CLng(16777216)
		m_l2Power(25) = CLng(33554432)
		m_l2Power(26) = CLng(67108864)
		m_l2Power(27) = CLng(134217728)
		m_l2Power(28) = CLng(268435456)
		m_l2Power(29) = CLng(536870912)
		m_l2Power(30) = CLng(1073741824)
	
	
		dim x
		dim k
		dim AA
		dim BB
		dim CC
		dim DD
		dim a
		dim b
		dim c
		dim d
	
		Const S11 = 7
		Const S12 = 12
		Const S13 = 17
		Const S14 = 22
		Const S21 = 5
		Const S22 = 9
		Const S23 = 14
		Const S24 = 20
		Const S31 = 4
		Const S32 = 11
		Const S33 = 16
		Const S34 = 23
		Const S41 = 6
		Const S42 = 10
		Const S43 = 15
		Const S44 = 21
	
		x = ConvertToWordArray(sMessage)
	
		a = &H67452301
		b = &HEFCDAB89
		c = &H98BADCFE
		d = &H10325476
	
		For k = 0 To UBound(x) Step 16
			AA = a
			BB = b
			CC = c
			DD = d
	
			md5_FF a, b, c, d, x(k + 0), S11, &HD76AA478
			md5_FF d, a, b, c, x(k + 1), S12, &HE8C7B756
			md5_FF c, d, a, b, x(k + 2), S13, &H242070DB
			md5_FF b, c, d, a, x(k + 3), S14, &HC1BDCEEE
			md5_FF a, b, c, d, x(k + 4), S11, &HF57C0FAF
			md5_FF d, a, b, c, x(k + 5), S12, &H4787C62A
			md5_FF c, d, a, b, x(k + 6), S13, &HA830461A
			md5_FF b, c, d, a, x(k + 7), S14, &HFD469501
			md5_FF a, b, c, d, x(k + 8), S11, &H698098DB
			md5_FF d, a, b, c, x(k + 9), S12, &H8B44F7AF
			md5_FF c, d, a, b, x(k + 10), S13, &HFFFF5BB1
			md5_FF b, c, d, a, x(k + 11), S14, &H895CD7BE
			md5_FF a, b, c, d, x(k + 12), S11, &H6B90112E
			md5_FF d, a, b, c, x(k + 13), S12, &HFD987193
			md5_FF c, d, a, b, x(k + 14), S13, &HA6794383
			md5_FF b, c, d, a, x(k + 15), S14, &H49B40821
	
			md5_GG a, b, c, d, x(k + 1), S21, &HF61E2562
			md5_GG d, a, b, c, x(k + 6), S22, &HC040B340
			md5_GG c, d, a, b, x(k + 11), S23, &H265E5A51
			md5_GG b, c, d, a, x(k + 0), S24, &HE9B6C7AA
			md5_GG a, b, c, d, x(k + 5), S21, &HD62F105D
			md5_GG d, a, b, c, x(k + 10), S22, &H2441453
			md5_GG c, d, a, b, x(k + 15), S23, &HD8A1E681
			md5_GG b, c, d, a, x(k + 4), S24, &HE7D3FBC8
			md5_GG a, b, c, d, x(k + 9), S21, &H21E1CDE6
			md5_GG d, a, b, c, x(k + 14), S22, &HC33707D6
			md5_GG c, d, a, b, x(k + 3), S23, &HF4D50D87
			md5_GG b, c, d, a, x(k + 8), S24, &H455A14ED
			md5_GG a, b, c, d, x(k + 13), S21, &HA9E3E905
			md5_GG d, a, b, c, x(k + 2), S22, &HFCEFA3F8
			md5_GG c, d, a, b, x(k + 7), S23, &H676F02D9
			md5_GG b, c, d, a, x(k + 12), S24, &H8D2A4C8A
	
			md5_HH a, b, c, d, x(k + 5), S31, &HFFFA3942
			md5_HH d, a, b, c, x(k + 8), S32, &H8771F681
			md5_HH c, d, a, b, x(k + 11), S33, &H6D9D6122
			md5_HH b, c, d, a, x(k + 14), S34, &HFDE5380C
			md5_HH a, b, c, d, x(k + 1), S31, &HA4BEEA44
			md5_HH d, a, b, c, x(k + 4), S32, &H4BDECFA9
			md5_HH c, d, a, b, x(k + 7), S33, &HF6BB4B60
			md5_HH b, c, d, a, x(k + 10), S34, &HBEBFBC70
			md5_HH a, b, c, d, x(k + 13), S31, &H289B7EC6
			md5_HH d, a, b, c, x(k + 0), S32, &HEAA127FA
			md5_HH c, d, a, b, x(k + 3), S33, &HD4EF3085
			md5_HH b, c, d, a, x(k + 6), S34, &H4881D05
			md5_HH a, b, c, d, x(k + 9), S31, &HD9D4D039
			md5_HH d, a, b, c, x(k + 12), S32, &HE6DB99E5
			md5_HH c, d, a, b, x(k + 15), S33, &H1FA27CF8
			md5_HH b, c, d, a, x(k + 2), S34, &HC4AC5665
	
			md5_II a, b, c, d, x(k + 0), S41, &HF4292244
			md5_II d, a, b, c, x(k + 7), S42, &H432AFF97
			md5_II c, d, a, b, x(k + 14), S43, &HAB9423A7
			md5_II b, c, d, a, x(k + 5), S44, &HFC93A039
			md5_II a, b, c, d, x(k + 12), S41, &H655B59C3
			md5_II d, a, b, c, x(k + 3), S42, &H8F0CCC92
			md5_II c, d, a, b, x(k + 10), S43, &HFFEFF47D
			md5_II b, c, d, a, x(k + 1), S44, &H85845DD1
			md5_II a, b, c, d, x(k + 8), S41, &H6FA87E4F
			md5_II d, a, b, c, x(k + 15), S42, &HFE2CE6E0
			md5_II c, d, a, b, x(k + 6), S43, &HA3014314
			md5_II b, c, d, a, x(k + 13), S44, &H4E0811A1
			md5_II a, b, c, d, x(k + 4), S41, &HF7537E82
			md5_II d, a, b, c, x(k + 11), S42, &HBD3AF235
			md5_II c, d, a, b, x(k + 2), S43, &H2AD7D2BB
			md5_II b, c, d, a, x(k + 9), S44, &HEB86D391
	
			a = AddUnsigned(a, AA)
			b = AddUnsigned(b, BB)
			c = AddUnsigned(c, CC)
			d = AddUnsigned(d, DD)
		Next
	
		if Pv_Md5Bits=32 then
			MD5 = LCase(WordToHex(a) & WordToHex(b) & WordToHex(c) & WordToHex(d))
		else
		    MD5 = LCase(WordToHex(b) & WordToHex(c))  'I crop this to fit 16byte database password :D
		end if
	end function
	public function encode(byval s)
		s = trim(s)
		if s = "" then encrypt = "" : exit function
		encode = MD5(s)
	end function
	public function encrypt(byval s)
		s = Trim(s)
		if s = "" then Encrypt = "" : exit function
		encrypt = MD5(s)
	end function
end class
'**
'Feature     : AES Encryption
'Author      : Roderick Divilbiss
'Update      : linx(openwbs@qq.com)
'Update Date : 2010-11-03 12:13:26
'Description : Encrypt strings with AES in OpenWBS
'**
class OW_AES_Class
	private m_lOnBits(30)
	private m_l2Power(30)
	private m_bytOnBits(7)
	private m_byt2Power(7)

	private m_InCo(3)

	private m_fbsub(255)
	private m_rbsub(255)
	private m_ptab(255)
	private m_ltab(255)
	private m_ftable(255)
	private m_rtable(255)
	private m_rco(29)

	private m_Nk
	private m_Nb
	private m_Nr
	private m_fi(23)
	private m_ri(23)
	private m_fkey(119)
	private m_rkey(119)

	private sEncryptKey

	private sub class_initialize()
		m_InCo(0) = &HB
		m_InCo(1) = &HD
		m_InCo(2) = &H9
		m_InCo(3) = &HE
			
		m_bytOnBits(0) = 1
		m_bytOnBits(1) = 3
		m_bytOnBits(2) = 7
		m_bytOnBits(3) = 15
		m_bytOnBits(4) = 31
		m_bytOnBits(5) = 63
		m_bytOnBits(6) = 127
		m_bytOnBits(7) = 255
			
		m_byt2Power(0) = 1
		m_byt2Power(1) = 2
		m_byt2Power(2) = 4
		m_byt2Power(3) = 8
		m_byt2Power(4) = 16
		m_byt2Power(5) = 32
		m_byt2Power(6) = 64
		m_byt2Power(7) = 128
			
		m_lOnBits(0) = 1
		m_lOnBits(1) = 3
		m_lOnBits(2) = 7
		m_lOnBits(3) = 15
		m_lOnBits(4) = 31
		m_lOnBits(5) = 63
		m_lOnBits(6) = 127
		m_lOnBits(7) = 255
		m_lOnBits(8) = 511
		m_lOnBits(9) = 1023
		m_lOnBits(10) = 2047
		m_lOnBits(11) = 4095
		m_lOnBits(12) = 8191
		m_lOnBits(13) = 16383
		m_lOnBits(14) = 32767
		m_lOnBits(15) = 65535
		m_lOnBits(16) = 131071
		m_lOnBits(17) = 262143
		m_lOnBits(18) = 524287
		m_lOnBits(19) = 1048575
		m_lOnBits(20) = 2097151
		m_lOnBits(21) = 4194303
		m_lOnBits(22) = 8388607
		m_lOnBits(23) = 16777215
		m_lOnBits(24) = 33554431
		m_lOnBits(25) = 67108863
		m_lOnBits(26) = 134217727
		m_lOnBits(27) = 268435455
		m_lOnBits(28) = 536870911
		m_lOnBits(29) = 1073741823
		m_lOnBits(30) = 2147483647
			
		m_l2Power(0) = 1
		m_l2Power(1) = 2
		m_l2Power(2) = 4
		m_l2Power(3) = 8
		m_l2Power(4) = 16
		m_l2Power(5) = 32
		m_l2Power(6) = 64
		m_l2Power(7) = 128
		m_l2Power(8) = 256
		m_l2Power(9) = 512
		m_l2Power(10) = 1024
		m_l2Power(11) = 2048
		m_l2Power(12) = 4096
		m_l2Power(13) = 8192
		m_l2Power(14) = 16384
		m_l2Power(15) = 32768
		m_l2Power(16) = 65536
		m_l2Power(17) = 131072
		m_l2Power(18) = 262144
		m_l2Power(19) = 524288
		m_l2Power(20) = 1048576
		m_l2Power(21) = 2097152
		m_l2Power(22) = 4194304
		m_l2Power(23) = 8388608
		m_l2Power(24) = 16777216
		m_l2Power(25) = 33554432
		m_l2Power(26) = 67108864
		m_l2Power(27) = 134217728
		m_l2Power(28) = 268435456
		m_l2Power(29) = 536870912
		m_l2Power(30) = 1073741824

		sEncryptKey = "OW_AES"
	end sub
	private sub class_terminate()
	end sub

	public property Let EncryptKey(byval BV_EK)
		sEncryptKey = BV_EK
	end property
	public property Get EncryptKey()
		EncryptKey = sEncryptKey
	end property

	private function LShift(lValue, iShiftBits)
		if iShiftBits = 0 then
			LShift = lValue
			exit function
		elseIf iShiftBits = 31 then
			if lValue and 1 then
				LShift = &H80000000
			else
				LShift = 0
			end if
			exit function
		elseIf iShiftBits < 0 or iShiftBits > 31 then
			Err.Raise 6
		end if
		
		if (lValue and m_l2Power(31 - iShiftBits)) then
			LShift = ((lValue and m_lOnBits(31 - (iShiftBits + 1))) * m_l2Power(iShiftBits)) or &H80000000
		else
			LShift = ((lValue and m_lOnBits(31 - iShiftBits)) * m_l2Power(iShiftBits))
		end if
	end function

	private function RShift(lValue, iShiftBits)
		if iShiftBits = 0 then
			RShift = lValue
			exit function
		elseIf iShiftBits = 31 then
			if lValue and &H80000000 then
				RShift = 1
			else
				RShift = 0
			end if
			exit function
		elseIf iShiftBits < 0 or iShiftBits > 31 then
			Err.Raise 6
		end if
		
		RShift = (lValue and &H7FFFFFFE) \ m_l2Power(iShiftBits)
		
		if (lValue and &H80000000) then
			RShift = (RShift or (&H40000000 \ m_l2Power(iShiftBits - 1)))
		end if
	end function

	private function LShiftByte(bytValue, bytShiftBits)
		if bytShiftBits = 0 then
			LShiftByte = bytValue
			exit function
		elseIf bytShiftBits = 7 then
			if bytValue and 1 then
				LShiftByte = &H80
			else
				LShiftByte = 0
			end if
			exit function
		elseIf bytShiftBits < 0 or bytShiftBits > 7 then
			Err.Raise 6
		end if
		LShiftByte = ((bytValue and m_bytOnBits(7 - bytShiftBits)) * m_byt2Power(bytShiftBits))
		
	end function

	private function RShiftByte(bytValue, bytShiftBits)
		if bytShiftBits = 0 then
			RShiftByte = bytValue
			exit function
		elseIf bytShiftBits = 7 then
			if bytValue and &H80 then
				RShiftByte = 1
			else
				RShiftByte = 0
			end if
			exit function
		elseIf bytShiftBits < 0 or bytShiftBits > 7 then
			Err.Raise 6
		end if
		
		RShiftByte = bytValue \ m_byt2Power(bytShiftBits)
	end function

	private function RotateLeft(lValue, iShiftBits)
		RotateLeft = LShift(lValue, iShiftBits) or RShift(lValue, (32 - iShiftBits))
	end function

	private function RotateLeftByte(bytValue, bytShiftBits)
		RotateLeftByte = LShiftByte(bytValue, bytShiftBits) or RShiftByte(bytValue, (8 - bytShiftBits))
	end function

	private function Pack(b())
		dim lCount
		dim lTemp
		
		For lCount = 0 To 3
			lTemp = b(lCount)
			Pack = Pack or LShift(lTemp, (lCount * 8))
		Next
	end function

	private function PackFrom(b(), k)
		dim lCount
		dim lTemp
		
		For lCount = 0 To 3
			lTemp = b(lCount + k)
			PackFrom = PackFrom or LShift(lTemp, (lCount * 8))
		Next
	end function

	private sub Unpack(a, b())
		b(0) = a and m_lOnBits(7)
		b(1) = RShift(a, 8) and m_lOnBits(7)
		b(2) = RShift(a, 16) and m_lOnBits(7)
		b(3) = RShift(a, 24) and m_lOnBits(7)
	end sub

	private sub UnpackFrom(a, b(), k)
		b(0 + k) = a and m_lOnBits(7)
		b(1 + k) = RShift(a, 8) and m_lOnBits(7)
		b(2 + k) = RShift(a, 16) and m_lOnBits(7)
		b(3 + k) = RShift(a, 24) and m_lOnBits(7)
	end sub

	private function xtime(a)
		dim b
		
		if (a and &H80) then
			b = &H1B
		else
			b = 0
		end if
		
		xtime = LShiftByte(a, 1)
		xtime = xtime Xor b
	end function

	private function bmul(x, y)
		if x <> 0 and y <> 0 then
			bmul = m_ptab((CLng(m_ltab(x)) + CLng(m_ltab(y))) Mod 255)
		else
			bmul = 0
		end if
	end function

	private function SubByte(a)
		dim b(3)
		
		Unpack a, b
		b(0) = m_fbsub(b(0))
		b(1) = m_fbsub(b(1))
		b(2) = m_fbsub(b(2))
		b(3) = m_fbsub(b(3))
		
		SubByte = Pack(b)
	end function

	private function product(x, y)
		dim xb(3)
		dim yb(3)
		
		Unpack x, xb
		Unpack y, yb
		product = bmul(xb(0), yb(0)) Xor bmul(xb(1), yb(1)) Xor bmul(xb(2), yb(2)) Xor bmul(xb(3), yb(3))
	end function

	private function InvMixCol(x)
		dim y
		dim m
		dim b(3)
		
		m = Pack(m_InCo)
		b(3) = product(m, x)
		m = RotateLeft(m, 24)
		b(2) = product(m, x)
		m = RotateLeft(m, 24)
		b(1) = product(m, x)
		m = RotateLeft(m, 24)
		b(0) = product(m, x)
		y = Pack(b)
		
		InvMixCol = y
	end function

	private function ByteSub(x)
		dim y
		dim z
		
		z = x
		y = m_ptab(255 - m_ltab(z))
		z = y
		z = RotateLeftByte(z, 1)
		y = y Xor z
		z = RotateLeftByte(z, 1)
		y = y Xor z
		z = RotateLeftByte(z, 1)
		y = y Xor z
		z = RotateLeftByte(z, 1)
		y = y Xor z
		y = y Xor &H63
		
		ByteSub = y
	end function
	public sub gentables()
		dim i
		dim y
		dim b(3)
		dim ib
		
		m_ltab(0) = 0
		m_ptab(0) = 1
		m_ltab(1) = 0
		m_ptab(1) = 3
		m_ltab(3) = 1
		
		For i = 2 To 255
			m_ptab(i) = m_ptab(i - 1) Xor xtime(m_ptab(i - 1))
			m_ltab(m_ptab(i)) = i
		Next
		
		m_fbsub(0) = &H63
		m_rbsub(&H63) = 0
		
		For i = 1 To 255
			ib = i
			y = ByteSub(ib)
			m_fbsub(i) = y
			m_rbsub(y) = i
		Next
		
		y = 1
		For i = 0 To 29
			m_rco(i) = y
			y = xtime(y)
		Next
		
		For i = 0 To 255
			y = m_fbsub(i)
			b(3) = y Xor xtime(y)
			b(2) = y
			b(1) = y
			b(0) = xtime(y)
			m_ftable(i) = Pack(b)
			
			y = m_rbsub(i)
			b(3) = bmul(m_InCo(0), y)
			b(2) = bmul(m_InCo(1), y)
			b(1) = bmul(m_InCo(2), y)
			b(0) = bmul(m_InCo(3), y)
			m_rtable(i) = Pack(b)
		Next
	end sub

	public sub gkey(nb, nk, key())                
		dim i
		dim j
		dim k
		dim m
		dim N
		dim C1
		dim C2
		dim C3
		dim CipherKey(7)
		
		m_Nb = nb
		m_Nk = nk
		
		if m_Nb >= m_Nk then
			m_Nr = 6 + m_Nb
		else
			m_Nr = 6 + m_Nk
		end if
		
		C1 = 1
		if m_Nb < 8 then
			C2 = 2
			C3 = 3
		else
			C2 = 3
			C3 = 4
		end if
		
		For j = 0 To nb - 1
			m = j * 3
			
			m_fi(m) = (j + C1) Mod nb
			m_fi(m + 1) = (j + C2) Mod nb
			m_fi(m + 2) = (j + C3) Mod nb
			m_ri(m) = (nb + j - C1) Mod nb
			m_ri(m + 1) = (nb + j - C2) Mod nb
			m_ri(m + 2) = (nb + j - C3) Mod nb
		Next
		
		N = m_Nb * (m_Nr + 1)
		
		For i = 0 To m_Nk - 1
			j = i * 4
			CipherKey(i) = PackFrom(key, j)
		Next
		
		For i = 0 To m_Nk - 1
			m_fkey(i) = CipherKey(i)
		Next
		
		j = m_Nk
		k = 0
		Do While j < N
			m_fkey(j) = m_fkey(j - m_Nk) Xor _
				SubByte(RotateLeft(m_fkey(j - 1), 24)) Xor m_rco(k)
			if m_Nk <= 6 then
				i = 1
				Do While i < m_Nk and (i + j) < N
					m_fkey(i + j) = m_fkey(i + j - m_Nk) Xor _
						m_fkey(i + j - 1)
					i = i + 1
				Loop
			else
				i = 1
				Do While i < 4 and (i + j) < N
					m_fkey(i + j) = m_fkey(i + j - m_Nk) Xor _
						m_fkey(i + j - 1)
					i = i + 1
				Loop
				if j + 4 < N then
					m_fkey(j + 4) = m_fkey(j + 4 - m_Nk) Xor _
						SubByte(m_fkey(j + 3))
				end if
				i = 5
				Do While i < m_Nk and (i + j) < N
					m_fkey(i + j) = m_fkey(i + j - m_Nk) Xor _
						m_fkey(i + j - 1)
					i = i + 1
				Loop
			end if
			
			j = j + m_Nk
			k = k + 1
		Loop
		
		For j = 0 To m_Nb - 1
			m_rkey(j + N - nb) = m_fkey(j)
		Next
		
		i = m_Nb
		Do While i < N - m_Nb
			k = N - m_Nb - i
			For j = 0 To m_Nb - 1
				m_rkey(k + j) = InvMixCol(m_fkey(i + j))
			Next
			i = i + m_Nb
		Loop
		
		j = N - m_Nb
		Do While j < N
			m_rkey(j - N + m_Nb) = m_fkey(j)
			j = j + 1
		Loop
	end sub

	public sub Encrypting(buff())
		dim i
		dim j
		dim k
		dim m
		dim a(7)
		dim b(7)
		dim x
		dim y
		dim t
		
		For i = 0 To m_Nb - 1
			j = i * 4
			
			a(i) = PackFrom(buff, j)
			a(i) = a(i) Xor m_fkey(i)
		Next
		
		k = m_Nb
		x = a
		y = b
		
		For i = 1 To m_Nr - 1
			For j = 0 To m_Nb - 1
				m = j * 3
				y(j) = m_fkey(k) Xor m_ftable(x(j) and m_lOnBits(7)) Xor _
					RotateLeft(m_ftable(RShift(x(m_fi(m)), 8) and m_lOnBits(7)), 8) Xor _
					RotateLeft(m_ftable(RShift(x(m_fi(m + 1)), 16) and m_lOnBits(7)), 16) Xor _
					RotateLeft(m_ftable(RShift(x(m_fi(m + 2)), 24) and m_lOnBits(7)), 24)
				k = k + 1
			Next
			t = x
			x = y
			y = t
		Next
		
		For j = 0 To m_Nb - 1
			m = j * 3
			y(j) = m_fkey(k) Xor m_fbsub(x(j) and m_lOnBits(7)) Xor _
				RotateLeft(m_fbsub(RShift(x(m_fi(m)), 8) and m_lOnBits(7)), 8) Xor _
				RotateLeft(m_fbsub(RShift(x(m_fi(m + 1)), 16) and m_lOnBits(7)), 16) Xor _
				RotateLeft(m_fbsub(RShift(x(m_fi(m + 2)), 24) and m_lOnBits(7)), 24)
			k = k + 1
		Next
		
		For i = 0 To m_Nb - 1
			j = i * 4
			UnpackFrom y(i), buff, j
			x(i) = 0
			y(i) = 0
		Next
	end sub

	public sub Decrypting(buff())
		dim i
		dim j
		dim k
		dim m
		dim a(7)
		dim b(7)
		dim x
		dim y
		dim t
		
		For i = 0 To m_Nb - 1
			j = i * 4
			a(i) = PackFrom(buff, j)
			a(i) = a(i) Xor m_rkey(i)
		Next
		
		k = m_Nb
		x = a
		y = b
		
		For i = 1 To m_Nr - 1
			For j = 0 To m_Nb - 1
				m = j * 3
				y(j) = m_rkey(k) Xor m_rtable(x(j) and m_lOnBits(7)) Xor _
					RotateLeft(m_rtable(RShift(x(m_ri(m)), 8) and m_lOnBits(7)), 8) Xor _
					RotateLeft(m_rtable(RShift(x(m_ri(m + 1)), 16) and m_lOnBits(7)), 16) Xor _
					RotateLeft(m_rtable(RShift(x(m_ri(m + 2)), 24) and m_lOnBits(7)), 24)
				k = k + 1
			Next
			t = x
			x = y
			y = t
		Next
		
		For j = 0 To m_Nb - 1
			m = j * 3
			
			y(j) = m_rkey(k) Xor m_rbsub(x(j) and m_lOnBits(7)) Xor _
				RotateLeft(m_rbsub(RShift(x(m_ri(m)), 8) and m_lOnBits(7)), 8) Xor _
				RotateLeft(m_rbsub(RShift(x(m_ri(m + 1)), 16) and m_lOnBits(7)), 16) Xor _
				RotateLeft(m_rbsub(RShift(x(m_ri(m + 2)), 24) and m_lOnBits(7)), 24)
			k = k + 1
		Next
		
		For i = 0 To m_Nb - 1
			j = i * 4
			
			UnpackFrom y(i), buff, j
			x(i) = 0
			y(i) = 0
		Next
	end sub

	private function IsInitialized(vArray)
		on error resume next
		IsInitialized = IsNumeric(UBound(vArray))
	end function

	private sub CopyBytesASP(bytDest, lDestStart, bytSource(), lSourceStart, lLength)
		dim lCount
		lCount = 0
		Do
			bytDest(lDestStart + lCount) = bytSource(lSourceStart + lCount)
			lCount = lCount + 1
		Loop Until lCount = lLength
	end sub

	public function EncryptData(bytMessage, bytPassword)
		dim bytKey(31)
		dim bytIn()
		dim bytOut()
		dim bytTemp(31)
		dim lCount
		dim lLength
		dim lEncodedLength
		dim bytLen(3)
		dim lPosition
		
		if not IsInitialized(bytMessage) then
			exit function
		end if
		if not IsInitialized(bytPassword) then
			exit function
		end if
		
		For lCount = 0 To UBound(bytPassword)
			bytKey(lCount) = bytPassword(lCount)
			if lCount = 31 then
				exit For
			end if
		Next
		
		gentables
		gkey 8, 8, bytKey
		
		lLength = UBound(bytMessage) + 1
		lEncodedLength = lLength + 4
		
		if lEncodedLength Mod 32 <> 0 then
			lEncodedLength = lEncodedLength + 32 - (lEncodedLength Mod 32)
		end if
		ReDim bytIn(lEncodedLength - 1)
		ReDim bytOut(lEncodedLength - 1)
		
		Unpack lLength, bytIn
		CopyBytesASP bytIn, 4, bytMessage, 0, lLength

		For lCount = 0 To lEncodedLength - 1 Step 32
			CopyBytesASP bytTemp, 0, bytIn, lCount, 32
			Encrypting bytTemp
			CopyBytesASP bytOut, lCount, bytTemp, 0, 32
		Next
		
		EncryptData = bytOut
	end function
	public function DecryptData(bytIn, bytPassword)
		dim bytMessage()
		dim bytKey(31)
		dim bytOut()
		dim bytTemp(31)
		dim lCount
		dim lLength
		dim lEncodedLength
		dim bytLen(3)
		dim lPosition
		
		if not IsInitialized(bytIn) then
			exit function
		end if
		if not IsInitialized(bytPassword) then
			exit function
		end if
		
		lEncodedLength = UBound(bytIn) + 1
		
		if lEncodedLength Mod 32 <> 0 then
			exit function
		end if
		
		For lCount = 0 To UBound(bytPassword)
			bytKey(lCount) = bytPassword(lCount)
			if lCount = 31 then
				exit For
			end if
		Next
		
		gentables
		gkey 8, 8, bytKey

		ReDim bytOut(lEncodedLength - 1)
		
		For lCount = 0 To lEncodedLength - 1 Step 32
			CopyBytesASP bytTemp, 0, bytIn, lCount, 32
			Decrypting bytTemp
			CopyBytesASP bytOut, lCount, bytTemp, 0, 32
		Next

		lLength = Pack(bytOut)
		
		if lLength > lEncodedLength - 4 then
			exit function
		end if
		
		ReDim bytMessage(lLength - 1)
		CopyBytesASP bytMessage, 0, bytOut, 4, lLength
		
		DecryptData = bytMessage
	end function

	function AESEncrypt(sPlain,sPassword)
		dim bytIn()
		dim bytOut
		dim bytPassword()
		dim lCount
		dim lLength
		dim sTemp
		
		lLength = Len(sPlain)
		ReDim bytIn(lLength-1)
		For lCount = 1 To lLength
			bytIn(lCount-1) = CByte(AscB(Mid(sPlain,lCount,1)))
		Next
		lLength = Len(sPassword)
		ReDim bytPassword(lLength-1)
		For lCount = 1 To lLength
			bytPassword(lCount-1) = CByte(AscB(Mid(sPassword,lCount,1)))
		Next

		bytOut = EncryptData(bytIn, bytPassword)

		sTemp = ""
		For lCount = 0 To UBound(bytOut)
			sTemp = sTemp & right("0" & Hex(bytOut(lCount)), 2)
		Next

		AESEncrypt = sTemp
	end function

	function AESDecrypt(sCypher, sPassword)
		dim bytIn()
		dim bytOut
		dim bytPassword()
		dim lCount
		dim lLength
		dim sTemp
		on error resume next
		lLength = Len(sCypher)
		ReDim bytIn(lLength/2-1)
		For lCount = 0 To lLength/2-1
			bytIn(lCount) = CByte("&H" & Mid(sCypher,lCount*2+1,2))
		Next
		lLength = Len(sPassword)
		ReDim bytPassword(lLength-1)
		For lCount = 1 To lLength
			bytPassword(lCount-1) = CByte(AscB(Mid(sPassword,lCount,1)))
		Next
		bytOut = DecryptData(bytIn, bytPassword)
		if IsArray(bytOut) then
			lLength = UBound(bytOut) + 1
			sTemp = ""
			For lCount = 0 To lLength - 1
				sTemp = sTemp & Chr(bytOut(lCount))
			Next
		end if
		if Err.number <> 0 then Err.Clear
		AESDecrypt = sTemp
	end function
	public function encrypt(byval s)
		s = Trim(s)
		if s = "" then Encrypt = "" : exit function
		encrypt = AESEncrypt(OW.Escape(s),OW.Escape(sEncryptKey))
	end function
	public function decrypt(byval s)
		s = Trim(s)
		if s = "" then decrypt = "" : exit function
		decrypt = OW.unEscape(AESDecrypt(s,OW.Escape(sEncryptKey)))
	end function
end class
' Programmed by Markus Hartsmar for ShameDesigns in 2002. 
' Email me at: mark@shamedesigns.com
' Visit our website at: http://www.shamedesigns.com/
'**
'Feature     : Encoding/Decoding of strings with Base64
'Author      : Markus Hartsmar(mark@shamedesigns.com)
'Update By   : linx(openwbs@qq.com)
'Update Date : 2010-11-04 10:42:27
'Description : Encoding strings with Base64 in OpenWBS
'**
class OW_Base64_Class
	private Base64Chars
	public sub class_initialize		
		Base64Chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/"
	end sub

	public function Encode( byVal strIn )
		dim c1, c2, c3, w1, w2, w3, w4, n, strOut
		For n = 1 To Len( strIn ) Step 3
			c1 = Asc( Mid( strIn, n, 1 ) )
			c2 = Asc( Mid( strIn, n + 1, 1 ) + Chr(0) )
			c3 = Asc( Mid( strIn, n + 2, 1 ) + Chr(0) )
			w1 = Int( c1 / 4 ) : w2 = ( c1 and 3 ) * 16 + Int( c2 / 16 )
			if Len( strIn ) >= n + 1 then 
				w3 = ( c2 and 15 ) * 4 + Int( c3 / 64 ) 
			else 
				w3 = -1
			end if
			if Len( strIn ) >= n + 2 then 
				w4 = c3 and 63 
			else 
				w4 = -1
			end if
			strOut = strOut + mimeEncode( w1 ) + mimeEncode( w2 ) + _
					  mimeEncode( w3 ) + mimeEncode( w4 )
		Next
		Encode = strOut
	end function
	public function Decode( byVal strIn )
		dim w1, w2, w3, w4, n, strOut
		For n = 1 To Len( strIn ) Step 4
			w1 = mimeDecode( Mid( strIn, n, 1 ) )
			w2 = mimeDecode( Mid( strIn, n + 1, 1 ) )
			w3 = mimeDecode( Mid( strIn, n + 2, 1 ) )
			w4 = mimeDecode( Mid( strIn, n + 3, 1 ) )
			if w2 >= 0 then _
				strOut = strOut + _
					Chr( ( ( w1 * 4 + Int( w2 / 16 ) ) and 255 ) )
			if w3 >= 0 then _
				strOut = strOut + _
					Chr( ( ( w2 * 16 + Int( w3 / 4 ) ) and 255 ) )
			if w4 >= 0 then _
				strOut = strOut + _
					Chr( ( ( w3 * 64 + w4 ) and 255 ) )
		Next
		Decode = strOut
	end function
	
	private function mimeEncode( byVal intIn )
		if intIn >= 0 then 
			mimeEncode = Mid( Base64Chars, intIn + 1, 1 ) 
		else 
			mimeEncode = ""
		end if
	end function

	private function mimeDecode( byVal strIn )
		if Len( strIn ) = 0 then 
			mimeDecode = -1 : exit function
		else
			mimeDecode = InStr( Base64Chars, strIn ) - 1
		end if
	end function
end class
class OW_SHA1_Class
	
	'OW.SHA1.encode(str)
	public function encode(byval str)
		encode = SHA1Class.encode(str)
	end function
	
end class
%>
<script language="javascript" type="text/javascript" runat="server">
var SHA1Class = new SHA1_Class();
function SHA1_Class(){
	var hexcase = 0;
	var b64pad  = "=";
	var chrsz   = 8;
	function hex_sha1(s){return binb2hex(core_sha1(str2binb(s),s.length * chrsz));};
	function b64_sha1(s){return binb2b64(core_sha1(str2binb(s),s.length * chrsz));};
	function str_sha1(s){return binb2str(core_sha1(str2binb(s),s.length * chrsz));};
	function hex_hmac_sha1(key, data){ return binb2hex(core_hmac_sha1(key, data));};
	function b64_hmac_sha1(key, data){ return binb2b64(core_hmac_sha1(key, data));};
	function str_hmac_sha1(key, data){ return binb2str(core_hmac_sha1(key, data));};
	function sha1_vm_test(){
		return hex_sha1("abc") == "a9993e364706816aba3e25717850c26c9cd0d89d";
	};
	function core_sha1(x,len){
		x[len >> 5] |= 0x80 << (24 - len % 32);
		x[((len + 64 >> 9) << 4) + 15] = len;
		var w = Array(80);
		var a =  1732584193;
		var b = -271733879;
		var c = -1732584194;
		var d =  271733878;
		var e = -1009589776;
		for(var i = 0; i < x.length; i += 16){
			var olda = a;
			var oldb = b;
			var oldc = c;
			var oldd = d;
			var olde = e;
			for(var j = 0; j < 80; j++){
				if(j < 16) w[j] = x[i + j];
				else w[j] = rol(w[j-3] ^ w[j-8] ^ w[j-14] ^ w[j-16], 1);
				var t = safe_add(safe_add(rol(a, 5), sha1_ft(j, b, c, d)),
								 safe_add(safe_add(e, w[j]), sha1_kt(j)));
				e = d;
				d = c;
				c = rol(b, 30);
				b = a;
				a = t;
			};
			a = safe_add(a, olda);
			b = safe_add(b, oldb);
			c = safe_add(c, oldc);
			d = safe_add(d, oldd);
			e = safe_add(e, olde);
		};
		return Array(a, b, c, d, e);
	};
	function sha1_ft(t, b, c, d){
		if(t < 20) return (b & c) | ((~b) & d);
		if(t < 40) return b ^ c ^ d;
		if(t < 60) return (b & c) | (b & d) | (c & d);
		return b ^ c ^ d;
	};
	function sha1_kt(t){
		return (t < 20) ?  1518500249 : (t < 40) ?  1859775393 :
			 (t < 60) ? -1894007588 : -899497514;
	};
	function core_hmac_sha1(key, data){
		var bkey = str2binb(key);
		if(bkey.length > 16) bkey = core_sha1(bkey, key.length * chrsz);
		var ipad = Array(16), opad = Array(16);
		for(var i = 0; i < 16; i++){
			ipad[i] = bkey[i] ^ 0x36363636;
			opad[i] = bkey[i] ^ 0x5C5C5C5C;
		};
		var hash = core_sha1(ipad.concat(str2binb(data)), 512 + data.length * chrsz);
		return core_sha1(opad.concat(hash), 512 + 160);
	};
	function safe_add(x, y){
		var lsw = (x & 0xFFFF) + (y & 0xFFFF);
		var msw = (x >> 16) + (y >> 16) + (lsw >> 16);
		return (msw << 16) | (lsw & 0xFFFF);
	};
	function rol(num, cnt){
		return (num << cnt) | (num >>> (32 - cnt));
	};
	function str2binb(str){
		var bin = Array();
		var mask = (1 << chrsz) - 1;
		for(var i = 0; i < str.length * chrsz; i += chrsz){
			bin[i>>5] |= (str.charCodeAt(i / chrsz) & mask) << (32 - chrsz - i%32);
		};
		return bin;
	};
	function binb2str(bin){
		var str = "";
		var mask = (1 << chrsz) - 1;
		for(var i = 0; i < bin.length * 32; i += chrsz){
			str += String.fromCharCode((bin[i>>5] >>> (32 - chrsz - i%32)) & mask);
		};
		return str;
	};
	function binb2hex(binarray){
		var hex_tab = hexcase ? "0123456789ABCDEF" : "0123456789abcdef";
		var str = "";
		for(var i = 0; i < binarray.length * 4; i++){
			str += hex_tab.charAt((binarray[i>>2] >> ((3 - i%4)*8+4)) & 0xF) +
			   hex_tab.charAt((binarray[i>>2] >> ((3 - i%4)*8  )) & 0xF);
		};
		return str;
	};
	function binb2b64(binarray){
		var tab = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
		var str = "";
		for(var i = 0; i < binarray.length * 4; i += 3){
			var triplet = (((binarray[i   >> 2] >> 8 * (3 -  i   %4)) & 0xFF) << 16)
					| (((binarray[i+1 >> 2] >> 8 * (3 - (i+1)%4)) & 0xFF) << 8 )
					|  ((binarray[i+2 >> 2] >> 8 * (3 - (i+2)%4)) & 0xFF);
			for(var j = 0; j < 4; j++){
				if(i * 8 + j * 6 > binarray.length * 32){
					str += b64pad;
				}else{
					str += tab.charAt((triplet >> 6*(3-j)) & 0x3F);
				};
			};
		};
		return str;
	};
	this.encode = function(str){
		return hex_sha1(str);
	};
};
</script>
<%
class OW_Cache_Class
	public cacheTime,htmlCacheTime,cacheFlag,htmlCachePath,tplCachePath,sysCachePath,createCacheByAdmin
	public pcHtmlCachePath,pcTplCachePath,mobHtmlCachePath,mobTplCachePath
	private sCacheName,sCacheData,iCacheNum,iCreateCacheNum

	private sub class_initialize()
		cacheTime          = 24 * 60 '单位分钟
		htmlCacheTime      = cacheTime * 10
		cacheFlag          = "ow_"
		createCacheByAdmin = false
		iCacheNum          = 200
		iCreateCacheNum    = 0
	end sub
	private sub class_terminate()
	end sub
	public function sysCacheValid(byval cacheName)
		sysCacheValid = cacheValid(0,cacheName)
	end function
	public function tplCacheValid(byval cacheName)
		tplCacheValid = cacheValid(1,cacheName)
	end function
	public function htmlCacheValid(byval cacheName)
		htmlCacheValid = cacheValid(2,cacheName)
	end function
	
	'********************************************************************
	'判断模板缓存是否有效
	public function cacheValid(byval cacheType,byval cacheName)
		dim cachePath,file,result,ctime
		cacheName = lcase(cacheName)
		result    = false
		if OW.isNul(cacheName) then cacheValid = result : exit function
		select case cacheType
		case 0
			cacheName = sysCachePath & cacheName
			ctime     = cacheTime
		case 1
			cacheName = tplCachePath & cacheName
			ctime     = cacheTime
		case 2
			cacheName = htmlCachePath & cacheName
			ctime     = htmlCacheTime
		end select
		'**
		cachePath  = OW.FSO.ABSPath(cacheName)
		if OW.FSO.fileExists(cachePath) then
			set file = OW.objectFSO.getFile(cachePath)
			if OW.dateDiff("s",cDate(file.dateLastModified),now()) < (ctime*60) then
				result = true
			end if
			set file = nothing
		end if
		cacheValid = result
	end function
	
	'获取模板缓存
    public function getTplCache(byval cacheName)
		dim s
		cacheName = lcase(cacheName)
		if cacheName<>"" then
			s = OW.read(tplCachePath & cacheName)
		end if
		getTplCache = s
	end function
	
	'获取html缓存
    public function getHtmlCache(byval cacheName)
		dim s
		cacheName = lcase(cacheName)
		if cacheName<>"" then
			s = OW.read(htmlCachePath & cacheName)
		end if
		getHtmlCache = s
	end function
	
	'保存模板缓存
	public function saveTplCache(byval cacheName,byval cacheValue)
		on error resume next
		dim tmp
		cacheName = lcase(cacheName)
		'**
		if cacheName<>"" then
			cacheName = tplCachePath & cacheName
			tmp       = OW.FSO.overWrite
			OW.FSO.overWrite = true
			if OW.FSO.saveFile(cacheName,cacheValue) then
				iCreateCacheNum = iCreateCacheNum + 1
			else
				OW.Error.msg = "OW.Cache.saveTplCache: "& cacheName
				OW.Error.raise 27
				err.clear
			end if
			OW.FSO.OverWrite = tmp
		else
			OW.Error.msg = "OW.Cache.saveTplCache: "& cacheName
			OW.Error.raise 26
			err.clear
		end if
	end function
	
	'保存html缓存
	public function saveHtmlCache(byval cacheName,byval cacheValue)
		on error resume next
		dim tmp
		cacheName = lcase(cacheName)
		'**
		if cacheName<>"" then
			cacheName = htmlCachePath & cacheName
			tmp       = OW.FSO.overWrite
			OW.FSO.overWrite = true
			if OW.FSO.saveFile(cacheName,cacheValue) then
				iCreateCacheNum = iCreateCacheNum + 1
			else
				OW.Error.msg = "OW.Cache.saveHtmlCache: "& cacheName
				OW.Error.raise 27
				err.clear
			end if
			OW.FSO.OverWrite = tmp
		else
			OW.Error.msg = "OW.Cache.saveHtmlCache: "& cacheName
			OW.Error.raise 26
			err.clear
		end if
	end function
	public function clearFileCache(byval cachePath)
		on error resume next
		dim file,fso,folder,mapPath,subFolder
		mapPath    = OW.serverMapPath(SITE_PATH & cachePath)
		set fso    = OW.objectFSO
		set folder = fso.getFolder(mapPath)
		for each subFolder in folder.subFolders
			call OW.FSO.deleteFolder(OW.FSO.ABSPath(cachePath & subFolder.name))
		next
		for each file in folder.files
			call OW.FSO.deleteFile(OW.FSO.ABSPath(cachePath & file.name))
		next
		if err then
			clearFileCache = false
		else
			clearFileCache = true
		end if
	end function
	public function clearTplCache()
		dim result : result = false
		if clearFileCache(pcTplCachePath) then
			result = clearFileCache(mobTplCachePath)
		end if
		clearTplCache = result
	end function
	public function clearHtmlCache()
		dim result : result = false
		if clearFileCache(pcHtmlCachePath) then
			result = clearFileCache(mobHtmlCachePath)
		end if
		clearHtmlCache = result
	end function
	public function clearSysCache()
		dim result : result = false
		result = clearFileCache(sysCachePath)
		clearSysCache = result
	end function
	
	public function getRamCache(byval cacheName)
		dim cacheData
		on error resume next
		cacheName = lcase(cacheFlag & cacheName)
		cacheData = application(cacheName)
		if isArray(cacheData) then
			if isObject(cacheData(0)) then
				set getRamCache = cacheData(0)
			else
				getRamCache = cacheData(0)
			end if
		end If
		if err.number<>0 then err.clear
	end function 
	
	public function saveRamCache(byval cacheName,byval cacheValue)
		on error resume next
		dim cacheData
		cacheName = lcase(cacheFlag & cacheName)
		cacheData = application(cacheName)
		if isArray(cacheData) then
			if isObject(cacheValue) then set cacheData(0)=cacheValue else cacheData(0)=cacheValue
			cacheData(1) = SYS_TIME
		else
			redim cacheData(1)
			if isObject(cacheValue) then set cacheData(0)=cacheValue else cacheData(0)=cacheValue
			cacheData(1) = SYS_TIME
		end if
		application.lock
		application(cacheName)= cacheData
		application.unLock
		if err.number<>0 then err.clear
	end function
	public function ramCacheValid(byval cacheName)
		on error resume next
		dim cacheData,result
		result    = false
		cacheName = lcase(cacheFlag & cacheName)
		cacheData = application(cacheName)
		if not isArray(cacheData) then ramCacheValid = false : exit function
		if OW.dateDiff("s",cDate(cacheData(1)),now()) < (cacheTime*60) then
			result = true
		end If
		if err.number<>0 then err.clear
		ramCacheValid = result
	end function
	public sub clearRamCache(byval cacheName)
		cacheName = lcase(cacheFlag & cacheName)
		application.lock
		application(cacheName) = empty
		application.unLock
	end sub
	public function clearAllRamCache()
		on error resume next
		application.lock()
		application.contents.removeAll()
		application.unLock()
		if err.number<>0 then
			err.clear
			clearAllRamCache = false
		else
			clearAllRamCache = true
		end if
	end function

	public function showAllRamCache()
		dim app
		for each app in application.Contents
			echo app &"<br>"
		next
		'call clearAllRamCache()
	end function
	public function getRamCacheNum()
		getRamCacheNum = application.contents.count
	end function
	public function createCacheNum()
		createCacheNum = iCreateCacheNum
	end function
	public function clearOtherCache()
		dim i,appl,num
		num = getRamCacheNum - iCacheNum
		i = 0
		for each appl in application.Contents
			application.Lock()
			application.contents.remove(appl)
			application.UnLock()
			i = i + 1
			if i = num then exit for
		next
	end function
end class
class OW_Pager_Class
	public currentPage,count,fields,page,pageSize,pageUrl,sql,loopExecute,loopHtml,loopHtmls,pageHtmls,isRsEscape,pageTpl
	
	private sub class_initialize()
		currentPage = -1
		count       = 0
		fields      = ""
		pageSize    = 20
		pageUrl     = ""
		sql         = ""
		loopExecute = ""
		loopHtml    = ""
		loopHtmls   = ""
		pageHtmls   = ""
		isRsEscape  = false
		pageTpl     = ""
	end sub
	private sub class_terminate()
	end sub
	public function demo()
		OW.Pager.isRsEscape = true
		OW.Pager.sql        = "select title,rootpath,urlpath,url,post_time,update_time from "& OW.DB.Table.content &" where status=0 AND cate_id IN(2,16)"
		OW.Pager.pageSize   = 20
		OW.Pager.pageUrl    = OW.urlRewrite("c4")
		OW.Pager.pageUrl    = "javascript:OW.shop.getConsultation({$page});"
		OW.Pager.pageTpl    = "{prev}{current}{next}"
		OW.Pager.loopHtml   = "<li><span class=""datetime"">{$post_time}</span><a href=""{$url}"" target=""_blank"">{$title}</a></li>"
		OW.Pager.loopExecute= "if fieldName=""buyer"" then fieldValue = OW.anonymousName(fieldValue) else if fieldName=""goods_price"" then fieldValue = OW.parsePrice(fieldValue) end if"
		OW.Pager.run()
		echo "OW.Page.count: "& OW.Pager.count &"<br><br>"
		echo "OW.Page.loopHtmls: "& OW.Pager.loopHtmls &"<br><br>"
		echo "OW.Page.pageHtmls: "& OW.Pager.pageHtmls &"<br>"
		echo "OW.runTime: "& OW.runTime &"<br>"
	end function
	public function run()
		dim a,i,j,k,fieldsCount,url,p,pages,rs,loopStr,s
		dim fieldName,fieldValue,match,matches
		dim prevStr,firstStr,prevpagesStr,currentStr,nextpagesStr,nextStr,lastStr,allpagesStr,recordsStr,perpageStr
		dim curPage,rsCount,pCount,pSize
		'**
		pageHtmls = ""
		if currentPage = -1 then
			currentPage = OW.int(OW.getForm("get","page"))
		end if
		if currentPage=0 then currentPage = 1
		'**
		loopHtmls   = ""
		set rs      = OW.DB.getRecordBySQL(sql)
		fieldsCount = rs.fields.count-1
		if not rs.eof then
			if rs.recordCount>=1 then rsCount = rs.recordCount else rsCount = 0
			rs.pageSize = pageSize : curPage = currentPage
			if curPage>0 then : if curPage > rs.pageCount then rs.absolutePage = rs.pageCount else rs.absolutePage = curPage : end if
			curPage = rs.absolutePage
			pCount  = rs.pageCount
			pSize   = pageSize
			'**
			for i=1 to pageSize
				if rs.eof then exit for
				loopStr = loopHtml
				'**
				for k=0 to fieldsCount
					fieldName = rs.fields(k).name
					fieldValue= OW.rs(rs(fieldName))
					if isRsEscape then fieldValue = OW.escape(fieldValue)
					if loopExecute<>"" then execute(loopExecute)
					loopStr   = OW.rep(loopStr,"{\$"& fieldName &"}",fieldValue)
				next
				'**
				loopHtmls = loopHtmls & loopStr
				rs.movenext
			next
			url = pageUrl
			'首页
			if curPage>4 then firstStr = "<a class=""first"" href="""& replace(url,"{$page}",1) &""">"& lang_page(5) &"</a>"
			'上一页
			if curPage>1 then prevStr = "<a class=""prev"" href="""& replace(url,"{$page}",curPage-1) &""">"& lang_page(1) &"</a>"
			'前面几页
			if curPage>1 then a=1 : if curPage>2 then a=2
			for p=curPage-a to curPage-1
				prevpagesStr = prevpagesStr &"<a class=""prev-pages"" href="""& replace(url,"{$page}",p) &""">"& p &"</a>"
			next
			'当前页
			currentStr = "<span class=""current"">"&curPage&"</span>"
			'后面几页
			for p=curPage+1 to curPage+2
				if p>pCount then exit for
				nextpagesStr = nextpagesStr &"<a class=""next-pages"" href="""& replace(url,"{$page}",p) &""">"&p&"</a>"
			next
			'下一页
			if not(curPage=pCount or curPage>pCount) then nextStr = "<a class=""next"" href="""& replace(url,"{$page}",curPage+1) &""">"& lang_page(2) &"</a>"
			'尾页
			if (pCount - curPage) > 3 then lastStr = "<a class=""last"" href="""& replace(url,"{$page}",pCount) &""">"& lang_page(6) &"</a>"
			allpagesStr = "<span class=""unlink allpages"">"& replace(lang_page(3),"{$n}",pCount) &"</span>"
			recordsStr  = "<span class=""unlink records"">"& replace(lang_page(0),"{$n}",rsCount) &"</span>"
			perpageStr  = "<span class=""unlink perpage"">"& replace(lang_page(4),"{$n}",pSize) &"</span>"
			if OW.isNul(pageTpl) then
				s = "<div class=""pager"">"& prevStr & firstStr & prevpagesStr & currentStr & nextpagesStr & nextStr & lastStr & allpagesStr & recordsStr & perpageStr &"</div>"
			else
				s = pageTpl
				s = replace(s,"{prev}",prevStr)
				s = replace(s,"{first}",firstStr)
				s = replace(s,"{prevpages}",prevpagesStr)
				s = replace(s,"{current}",currentStr)
				s = replace(s,"{nextpages}",nextpagesStr)
				s = replace(s,"{next}",nextStr)
				s = replace(s,"{last}",lastStr)
				s = replace(s,"{allpages}",allpagesStr)
				s = replace(s,"{records}",recordsStr)
				s = replace(s,"{perpage}",perpageStr)
			end if
			pageHtmls = s
			count     = rsCount
		end if
		OW.DB.closeRs rs
	end function
end class
dim OS,OS_ERROR,V
dim CTL,ACT,SUBACT,IS_SHOP,IS_CATE,IS_CPAGE,ID,CID,GID,CATE_ID,FIELD_NAME,IS_EMPOWERED,OPENWBS_SMSURL,SITE_DOMAIN_IS_REDIRECT,IS_UPDATING
dim ROOTPATH,URLPATH,OW_PAGE,TAG,KEYWORD,TYPEID,TYPEID_ARR,ORDERBY
dim LOGINED,UID,USERNAME,PASSWORD,EMAIL,MOBILE,NICKNAME,AVATAR,GROUP_ID,SPECIAL_GROUP_ID,ADMIN_GROUP_ID,GROUP_RANK,USS_KEY,USS_VALUE
IS_UPDATING = false
set OS = new OS_Class
class OS_Class
	public SHOP,versionType,versionWX,versionWXFX,hasMobile
	public calendarCount,defAvatarRoot,lang,language,mailTplRoot,pluginsRoot,uploadsRoot,tplRoot,tplPath,tplHtmlPath,urlRewrite
	public mailConfig
	private oRs,aArr
	private sub class_initialize()
		OW.charSet     = SYS_CHARSET
		versionType    = lcase(OW_VERSION_TYPE)
		versionWX      = OW.iif(OW_VERSION_WX="W",true,false)
		versionWXFX    = OW.iif(OW_VERSION_WX="F",true,false)
		hasMobile      = OW.iif(OW_VERSION_MOB_TYPE="M",true,false)
		language       = "zh-cn"
		uploadsRoot    = "b3ctY29udGVudC91cGxvYWRzLw"
		defAvatarRoot  = "ow-content/uploads/avatar/"
		mailTplRoot    = "ow-content/mail/tpl/"
		pluginsRoot    = "ow-content/plugins/"
		tplRoot        = "ow-content/templates/"
		calendarCount  = 0
		set V          = server.createObject(OW.dictName)
		set lang       = server.createObject(OW.dictName)
		if versionType="x" then
		set SHOP = new OS_SHOP_CLASS
		end if
	end sub
	private sub class_terminate()
		set V          = nothing
		set lang       = nothing
		set OW         = nothing
		set SHOP       = nothing
	end sub
	public sub init()
		'**
		if SYS_IS_INSTALL=1 then
			call getSiteData()
			OW.configCacheName    = "ow.config."& SITE_ID
			call getConfig()
			OW.Cache.pcHtmlCachePath   = "ow-content/cache/html/"& OW.config("cache_folder") &"/"
			OW.Cache.pcTplCachePath    = "ow-content/cache/tpl/"& OW.config("cache_folder") &"/"
			OW.Cache.mobHtmlCachePath  = "ow-content/cache/html/mobile_"& OW.config("cache_folder") &"/"
			OW.Cache.mobTplCachePath   = "ow-content/cache/tpl/mobile_"& OW.config("cache_folder") &"/"
			OW.Cache.sysCachePath      = "ow-content/cache/sys/"& OW.config("cache_folder") &"/"
			if OW.isMobile then
			OW.Cache.htmlCachePath = OW.Cache.mobHtmlCachePath
			OW.Cache.tplCachePath  = OW.Cache.mobTplCachePath
			else
			OW.Cache.htmlCachePath = OW.Cache.pcHtmlCachePath
			OW.Cache.tplCachePath  = OW.Cache.pcTplCachePath
			end if
			'**
			OW.config("debug") = OW.cbool(OW.config("debug"))
			call combineConfig(DEBUG,"debug")
			OW.config("html_cache_open") = OW.int(OW.config("html_cache_open"))
			OW.config("html_cache_time") = OW.int(OW.config("html_cache_time"))
			OW.loginTimeout        = OW.config("login_timeout")
			OW.Cache.cacheTime     = OW.config("cache_time")
			OW.Cache.htmlCacheTime = OW.config("html_cache_time")
			language = OW.config("site_lang")
			if SITE_DOMAIN_IS_REDIRECT=1 then redirect(OW.config("main_site_url"))
		else
			SITE_PATH = OW.getSitePath(OW.getSiteURL())
		end if
		'**
		UID              = OW.int(UID)
		GROUP_ID         = OW.int(GROUP_ID)
		SPECIAL_GROUP_ID = OW.int(SPECIAL_GROUP_ID)
		LOGINED          = false
		uploadsRoot = OW.Base64.decode(uploadsRoot) & OW.iif(OW.config("upload_share_manage"),"",SITE_FOLDER)
		call OS.includeLanguageFile("os.lang.asp")
		if urlRewrite then OW.URLRewriteInit()
		CTL     = OW.left(OW.regReplace(OW.getForm("get","ctl"),"[^0-9a-zA-Z_]",""),30)
		ACT     = OW.left(OW.regReplace(OW.getForm("get","act"),"[^0-9a-zA-Z_]",""),30)
		SUBACT  = OW.regReplace(OW.getForm("get","subact"),"[^0-9a-zA-Z_]","")
		ID      = OW.int(OW.getForm("get","id"))
		IS_CATE = OW.int(OW.getForm("get","is_cate"))
		IS_CPAGE= false
		OW_PAGE = OW.int(OW.getForm("get","page"))
		ROOTPATH= OW.left(OW.regReplace(OW.getForm("get","rootpath"),"[^0-9a-zA-Z-_]",""),64)
		URLPATH = OW.left(OW.regReplace(OW.getForm("get","urlpath"),"[^0-9a-zA-Z-_]",""),64)
		if CTL="tags" or CTL="gtags" then
		TAG = OW.tagDecode(OW.left(OW.getForm("get","tag"),200))
		end if
		if CTL="search" then
		IS_SHOP = OW.int(OW.getForm("get","is_shop"))
		KEYWORD = OW.validClientDBData(OW.URLDecode(OW.reps(OW.getForm("get","keyword"),"'","")),100)
		end if
		if SYS_IS_INSTALL=1 then
			call verifyIsMemberLogined()
			if GROUP_ID=0 then
				GROUP_ID   = 10
				GROUP_RANK = 0
			end if
		end if
		'**
	end sub
	public function addImgAlt(byval htmlStr,byval titleStr)
		dim m,ms,keyword,rs,url,text1,text2
		set ms = OW.getMatch(htmlStr,"<img(?!alt)([^>]*?)src=""([^>]+?)""([^>]*?)>")
		if ms.count>0 then
		for each m in ms
			if not(instr(m.subMatches(2),"alt=")>0) then
				htmlStr = replace(htmlStr,m.value,"<img"& m.subMatches(0) &"src="""& m.subMatches(1) &""" alt="""& titleStr &""" title="""& titleStr &""" "& m.subMatches(2) &">")
			end if
		next
		end if
		set ms = nothing
		addImgAlt = htmlStr
	end function
	public function addKeywordsLink(byval htmlStr)
		dim i,m,ms,keyword,keywordCode,rs,url,repText,text1,text2
		i = 0
		set ms = OW.getMatch(htmlStr,"<a([^<]+?)</a>")
		if ms.count>0 then
			for each m in ms
				i = i+1
				V("_ow_v_"& i &"_") = "<a"& m.subMatches(0) &"</a>"
				htmlStr = replace(htmlStr,m.value,"_ow_v_"& i &"_")
			next
		end if
		set ms = OW.getMatch(htmlStr,"(src|href|alt|title)=""([^>]+?)""")
		if ms.count>0 then
			for each m in ms
				i = i+1
				V("_ow_v_"& i &"_") = m.subMatches(1)
				htmlStr = replace(htmlStr,m.value,m.subMatches(0)&"=""_ow_v_"& i &"_""")
			next
		end if
		set rs = OW.DB.getRecordBySQL("SELECT * FROM ["& DB_PRE &"keywords] WHERE status=0 AND "& OW.DB.auxSQL &" ORDER BY sequence ASC")
		do while not(rs.eof)
			keyword = OW.rs(rs("keyword"))
			url     = OW.rs(rs("url"))
			set ms = OW.getMatch(htmlStr,"("& keyword &")")
			if ms.count>0 then
				for each m in ms
					i = i+1
					V("_ow_v_"& i &"_") = "<a href="""& url &""" title="""& keyword &""">"& keyword &"</a>"
					htmlStr = replace(htmlStr,m.value,"_ow_v_"& i &"_")
				next
			end if
			rs.movenext 
		loop
		OW.DB.closeRs rs
		set ms = nothing
		set ms = OW.getMatch(htmlStr,"_ow_v_([\d]{1,6})_")
		if ms.count>0 then
			for each m in ms
				repText = V("_ow_v_"& m.subMatches(0) &"_")
				htmlStr = replace(htmlStr,m.value,repText)
			next
		end if
		set ms = nothing
		addKeywordsLink = htmlStr
	end function
	public function addSystemErrorRecord(byval desc,byval sc)
		desc = OW.validDBData(desc,250)
		sc   = OW.validDBData(sc,250)
		call OW.DB.addRecord(DB_PRE &"system_error",array("site_id:"& SITE_ID,"description:"& desc,"source:"& sc,"uid:"& UID,"current_url:"& OW.currentURL,"referer:"& OW.getReferer(),"ip:"& OW.getClientIP(),"datetime:"& SYS_TIME))
	end function
	
	'合并网站配置
	public sub combineConfig(byref cfg,byval key)
		if OW.config.exists(key) then
			cfg = OW.config(key)
		else
			OW.config(key) = cfg
		end if
	end sub
	
	'日历
	public function calendar(byval arr)
		dim inputField,trigger,dateFormat,s
		inputField = arr(0)
		trigger    = arr(1)
		dateFormat = arr(2)
		if calendarCount<1 then
			s = "<link rel=""stylesheet"" type=""text/css"" href="""& SITE_PATH &"ow-content/thr-plugin/calendar/jscal2.css""/>"
			s = s &"<link rel=""stylesheet"" type=""text/css"" href="""& SITE_PATH &"ow-content/thr-plugin/calendar/blue.css""/>"
			s = s &"<script type=""text/javascript"" src="""& SITE_PATH &"ow-content/thr-plugin/calendar/calendar.js""></script>"
			s = s &"<script type=""text/javascript"" src="""& SITE_PATH &"ow-content/thr-plugin/calendar/lang/"& OS.language &".js""></script>"
			calendarCount = calendarCount + 1
		end if
		if inputField<>"" and trigger<>"" then
		s = s &"<script type=""text/javascript"">Calendar.setup({weekNumbers:true,inputField:"""& inputField &""",trigger:"""& trigger &""",dateFormat:"""& dateFormat &""",showTime:true,minuteStep:1,onSelect:function(){this.hide();}});</script>"
		end if
		calendar = s
	end function
	
	'生成栏目地址
	public function createCateLink(byval rootpath,byval urlpath)
		if OW.isNul(rootpath) then
			createCateLink = replace(OW.urlRewrite("c1"),"{$urlpath}",urlpath)
		else
			createCateLink = replace(replace(OW.urlRewrite("c3"),"{$urlpath}",urlpath),"{$rootpath}",rootpath)
		end if
	end function
	
	'生成商品地址
	public function createGoodsLink(byval rootpath,byval urlpath,byval url)
		if OW.isNotNul(url) then createGoodsLink = url : exit function
		createGoodsLink = replace(replace(OW.urlRewrite("c7"),"{$urlpath}",urlpath),"{$rootpath}",rootpath)
	end function
	
	'生成28位的序列号
	public function createSN()
		dim dt,sn
		sn = OW.formatDateTime(SYS_TIME,9) & OW.random(14)
		if len(sn) <> 28 then
			dt = now()
			sn = year(d) & month(d) & day(d) & hour(d) & minute(d)& second(d)
			sn = sn & OW.random(28-len(sn))
		end if
		createSN = sn
	end function
	
	'生成16位的时间序列号
	public function createTimer()
		dim sn
		sn = OW.formatDateTime(SYS_TIME,9) & OW.random(2)
		createTimer = sn
	end function
	
	'生成20位的支付交易号
	public function createTradeNo()
		dim s,t
		t = OW.left(OW.cLeft(timer(),"."),5)
		select case len(t)
			case 4 : t = "0"& t
			case 3 : t = "00"& t
			case 2 : t = "000"& t
			case 1 : t = "0000"& t
		end select
		s = OW.right(OW.formatDateTime(SYS_TIME,8),6) &""& t &""& OW.random(4) &""& OW.random(3)
		createTradeNo = "TN"& s
	end function
	public function createFormPostHtml(byval formId,byval siteId)
		formId = OW.int(formId)
		siteId = OW.int(siteId)
		if not(formId>0) then createFormPostHtml="" : exit function
		dim rs,fs,formHtml,auxSQL,vcodeOpen
		dim arrayData,i,loc,arr,css,val,text,important,inputAttr,value,valueArr,temp,errmsg
		dim name,input,tips,js
		if siteId>0 then auxSQL="site_id="& siteId &"" else auxSQL=OW.DB.auxSQL 
		set rs = OW.DB.getRecordBySQL("SELECT * FROM "& DB_PRE &"form_field WHERE form_id="& formId &" AND "& auxSQL &" AND status=0 ORDER BY sequence ASC")
		do while not rs.eof
			arrayData = OS.createFormFieldHtml(true,OW.rs(rs("field")),OW.rs(rs("field_name")),OW.rs(rs("field_type")),OW.int(rs("field_datasize")),OW.rs(rs("field_default")),OW.rs(rs("field_options")),OW.int(rs("not_null")),OW.rs(rs("tips")))
			name  = arrayData(0)
			input = arrayData(1)
			tips  = arrayData(2) 
			js    = arrayData(3)
			fs = fs &"<div class=""form-group form-group-field-"& rs("field") &"""><div class=""col-name"">"& name &"</div><div class=""col-value"">"& input & tips & js &"</div></div>"
		    rs.movenext
		loop
		OW.DB.closeRs rs
		vcodeOpen = OW.int(OW.config("form_vcode_open"))
		important = "<i class=""important"">*</i>"
		inputAttr = "datasize=""5"" name=""verifycode_value"" datatype=""*"" errmsg="""& OS.lang(7) &""""
		name      = important & OS.lang(6)
		css       = "text text-short-mini text-verifycode"
		input     = "<input type=""text"" class="""& css &""" value="""" "& inputAttr &"/>"
		tips      = "<span class=""t-normal ml5"" name=""t_verifycode_value""></span>"
		js        = ""
		if vcodeOpen then
		fs = fs &"<div class=""form-group""><div class=""col-name"">"& name &"</div><div class=""col-value"">"& input &"<span class=""verifycode"" name=""verifycode""></span>"& tips & js &"</div></div>"
		end if
		formHtml = formHtml &"<form ajaxurl="""& SITE_URL &"ow-includes/ow.ajax.form.asp?ctl=form&act=post_formdata&form_id="& formId &""" class=""form"" name=""form_"& formId &"_post"" action=""javascript:;"" vcode_open="""& vcodeOpen &""">"
		formHtml = formHtml & fs
		formHtml = formHtml &"<div class=""form-actions"">"
		formHtml = formHtml &"<button type=""button"" class=""btn btn-primary"" name=""btn_submit"">"& OS.lang(5) &"</button>"
		formHtml = formHtml &"</div>"
		formHtml = formHtml &"</form>"
		formHtml = formHtml &"<script type=""text/javascript"">"
		formHtml = formHtml &"$(document).ready(function(){"
		formHtml = formHtml &"var $form = $(""form[name='form_"& formId &"_post']""),$submit = $form.find(""button[name='btn_submit']""),$validForm = OWValidForm({form:$form});"
		if vcodeOpen then
		formHtml = formHtml &"$vcodeValue = $form.find(""input[name='verifycode_value']""),"
		formHtml = formHtml &"$verifycode = $form.find(""span[name='verifycode']"");"
		formHtml = formHtml &"$vcodeValue.focus(function(){if(OW.isNull($verifycode.html())){OW.verifyCode({boxer:$verifycode})}});"
		formHtml = formHtml &"$vcodeValue.blur(function(){$(this).val(OW.parseVerifyCode($(this).val()))});"
		end if
		formHtml = formHtml &"$submit.click(function(){"
		formHtml = formHtml &"$validForm.verify();"
		formHtml = formHtml &"if($validForm.result){"
		formHtml = formHtml &"$validForm.getFormData();"
		formHtml = formHtml &"var $dialog = new OWDialog().posting().position();"
		formHtml = formHtml &"OW.ajax({"
		formHtml = formHtml &"url:$form.attr(""ajaxurl""),"
		formHtml = formHtml &"data:$validForm.formData +""&""+ $validForm.getVerifyCodeData,"
		formHtml = formHtml &"success:function(){$dialog.success("""& OS.lang(8) &""").position();},"
		formHtml = formHtml &"failed:function(msg){$dialog.error("""& OS.lang(9) &""",msg).position().timeout(3);"& OW.iif(vcodeOpen,"$vcodeValue.val("""");OW.verifyCode({boxer:$verifycode});","")&"}});"
		formHtml = formHtml &"};"
		formHtml = formHtml &"});"
		formHtml = formHtml &"});"
		formHtml = formHtml &"</script>"
		createFormPostHtml = formHtml
	end function
	public function createOrderFormPostHtml(byval formId,byval siteId,byval formData)
		formId = OW.int(formId)
		siteId = OW.int(siteId)
		if not(formId>0) then createOrderFormPostHtml="" : exit function
		dim arrayData,rs,fs,formHtml,name,input,tips,js,auxSQL
		dim isGetValue,fieldValue
		if formData="" then
			isGetValue = false
		else
			isGetValue = true
		end if
		if siteId>0 then auxSQL="site_id="& siteId &"" else auxSQL=OW.DB.auxSQL 
		set rs = OW.DB.getRecordBySQL("SELECT * FROM "& DB_PRE &"form_field WHERE form_id="& formId &" AND "& auxSQL &" AND status=0 AND display_in_admin=0 ORDER BY sequence ASC")
		do while not rs.eof
			if isGetValue then
				fieldValue = OW.dbDataDecodeToInput(OW.unEscape(OW.getODataKeyValue(formData,OW.rs(rs("field")))))
			else
				fieldValue = OW.rs(rs("field_default"))
			end if
			arrayData = OS.createFormFieldHtml(true,OW.rs(rs("field")),OW.rs(rs("field_name")),OW.rs(rs("field_type")),OW.int(rs("field_datasize")),fieldvalue,OW.rs(rs("field_options")),OW.int(rs("not_null")),OW.rs(rs("tips")))
			name  = arrayData(0)
			input = arrayData(1)
			tips  = arrayData(2) 
			js    = arrayData(3)
			fs = fs &"<div class=""form-group""><div class=""col-name"">"& name &"</div><div class=""col-value"">"& input & tips & js &"</div></div>"
		rs.movenext
		loop
		OW.DB.closeRs rs
		formHtml = formHtml &"<form class=""form"" form_id="& formId &" name=""form_"& formId &"_post"" action=""javascript:;"">"
		formHtml = formHtml & fs
		formHtml = formHtml &"</form>"
		createOrderFormPostHtml = formHtml
	end function
	public function createFormFieldHtml(byval isForClient,byval field,byval fieldName,byval fieldType,byval fieldDatasize,byval fieldDefault,byval fieldOptions,byval notNull,byval tipStr)
		dim arrayData,i,loc,arr,css,val,text,important,inputAttr,value,valueArr,temp,errmsg
		dim name,input,tips,js
		if notNull=1 then
			important = "<i class=""important"">*</i>"
			inputAttr = "datasize="""& fieldDatasize &""" name="""& field &""" datatype=""*"" errmsg=""{$errmsg}"" tips="""& tipStr &""" "
		else
			important = ""
			inputAttr = "datasize="""& fieldDatasize &""" name="""& field &""""
		end if
		name  = important & fieldName
		value = fieldDefault
		select case fieldType
		case "text"
			errmsg        = OS.lang(10) & fieldName
			inputAttr     = OW.rep(inputAttr,"{\$errmsg}",errmsg)
			if fieldDatasize<=50 then css="text" else css="text text-long"
			input = "<input type=""text"" class="""& css &"""  maxlength="""& fieldDatasize &""" value="""& value &""" "& inputAttr &"/>"
			tips  = "<span class=""t-normal ml5"" name=""t_"& field &""">"& tipStr &"</span>"
			js    = ""
		case "textarea"
			errmsg        = OS.lang(10) & fieldName
			inputAttr     = OW.rep(inputAttr,"{\$errmsg}",errmsg)
			input = "<textarea class=""textarea"" "& inputAttr &">"& value &"</textarea>"
			tips  = "<span class=""t-normal ml5"" name=""t_"& field &""">"& tipStr &"</span>"
			js    = ""
		case "editor"
			errmsg        = OS.lang(10) & fieldName
			inputAttr     = OW.rep(inputAttr,"{\$errmsg}",errmsg)
			input = "<textarea class=""textarea textarea-editor"" id=""field_"& field &""" "& inputAttr &">"& OW.editorContentDecode(value) &"</textarea>"
			tips  = "<br/><span class=""t-normal"" name=""t_"& field &""">"& tipStr &"</span>"
			js    = "<script type=""text/javascript"">var "& field &"WebEditor = new UE.getEditor('field_"& field &"');</script>"
			js    = ""
		case "radio"
			errmsg        = "请选择"& fieldName
			inputAttr     = OW.rep(inputAttr,"{\$errmsg}",errmsg)
			arr   = split(fieldOptions,"||")
			input = ""
			for i=0 to ubound(arr)
				val  = OW.cLeft(arr(i),":")
				text = OW.cRight(arr(i),":")
				if text="" then text = val
				input = input &"<label class=""radio-inline""><input type=""radio"" "& OW.iif(val=value,"checked","") &" value="""& val &""" "& inputAttr &">"& text &"</label>"
			next
			input = "<div class=""labels"">"& input &"<span class=""t-normal"" name=""t_"& field &""">"& tipStr &"</span></div>"
			tips  = ""
			js    = ""
		case "checkbox"
			errmsg        = "请选择"& fieldName
			inputAttr     = OW.rep(inputAttr,"{\$errmsg}",errmsg)
			valueArr = split(value,",")
			arr   = split(fieldOptions,"||")
			input = ""
			for i=0 to ubound(arr)
				val  = OW.cLeft(arr(i),":")
				text = OW.cRight(arr(i),":")
				if text="" then text = val
				input = input &"<label class=""checkbox-inline""><input type=""checkbox"" "& OW.iif(OW.isInArray(valueArr,val),"checked","") &" value="""& val &""" "& inputAttr &">"& text &"</label>"
			next
			input = "<div class=""labels"">"& input &"<span class=""t-normal"" name=""t_"& field &""">"& tipStr &"</span></div>"
			tips  = ""
			js    = ""
		case "select"
			errmsg        = "请选择"& fieldName
			inputAttr     = OW.rep(inputAttr,"{\$errmsg}",errmsg)
			arr    = split(fieldOptions,"||")
			input = ""
			tips   = "<span class=""t-normal ml5"" name=""t_"& field &""">"& tipStr &"</span>"
			js     = ""
			for i=0 to ubound(arr)
				val  = OW.cLeft(arr(i),":")
				text = OW.cRight(arr(i),":")
				if text="" then text = val
				input = input &"<option value="""& val &""" "& OW.iif(val=value,"selected","") &">"& text &"</option>"
			next
			input = "<select "& inputAttr &">"& input &"</select>"
		case "number"
			errmsg        = OS.lang(10) & fieldName
			inputAttr     = OW.rep(inputAttr,"{\$errmsg}",errmsg)
			css   = "text text-short"
			input = "<input type=""text"" class="""& css &""" value="""& value &""" onblur=""OW.onblur(this,{rep:'/[^0-9.]*/g',length:20})"" "& inputAttr &"/>"
			tips  = "<span class=""t-normal ml5"" name=""t_"& field &""">"& tipStr &"</span>"
			js    = ""
		case "money"
			errmsg        = OS.lang(10) & fieldName
			inputAttr     = OW.rep(inputAttr,"{\$errmsg}",errmsg)
			css   = "text text-short"
			input = "<input type=""text"" class="""& css &""" value="""& value &""" onblur=""OW.onblur(this,{rep:'/[^0-9.]*/g',length:20})"" "& inputAttr &"/>"
			tips  = "<span class=""t-normal ml5"" name=""t_"& field &""">"& tipStr &"</span>"
			js    = ""
		case "datetime"
			errmsg        = OS.lang(10) & fieldName
			inputAttr     = OW.rep(inputAttr,"{\$errmsg}",errmsg)
			css   = "text text-datetime"
			input = "<input type=""text"" class="""& css &""" id="""& field &""" value="""& value &""" "& inputAttr &"/>"
			tips  = "<span class=""t-normal ml5"" name=""t_"& field &""">"& tipStr &"</span>"
			js    = calendar(array(field,field,"%Y-%m-%d %H:%M:%S"))
		case "attachment"
			if isForClient then
				errmsg    = "请上传"& fieldName
				inputAttr = OW.rep(inputAttr,"{\$errmsg}",errmsg)
				css   = "text text-fileupload"
				input = "<input type=""text"" class="""& css &"""  maxlength="""& fieldDatasize &""" value="""& value &""" "& inputAttr &"/>"
				input = input &"<iframe class=""iframe-upload"" src="""& SITE_PATH &"ow-includes/module/upload/ow.upload.iframe.asp?upload_btn=upload_"& field &""" frameborder=""0"" id=""iframe_upload_"& field &"""></iframe>"
				input = input &"<button type=""button"" class=""btn btn-upload"" name=""upload_"& field &""" onclick=""OW.client.upload({inputName:'"& field &"',iframeId:'iframe_upload_"& field &"'})"">开始上传</button>"
				tips  = "<span class=""t-normal ml5"" name=""t_"& field &""">"& tipStr &"</span>"
				js    = ""
			else
				errmsg    = "请选择"& fieldName
				inputAttr = OW.rep(inputAttr,"{\$errmsg}",errmsg)
				css   = "text"
				input = "<input type=""text"" class="""& css &"""  maxlength="""& fieldDatasize &""" value="""& value &""" "& inputAttr &"/>"
				input = input &"<button type=""button"" class=""btn btn-font-bold ml5"" name=""select_"& field &""" onclick=""Admin.attachmentSelect2({inputName:'"& field &"'})"">选择...</button>"
				tips  = "<span class=""t-normal ml5"" name=""t_"& field &""">"& tipStr &"</span>"
				js    = ""
			end if
		case else
			errmsg        = OS.lang(10) & fieldName
			inputAttr     = OW.rep(inputAttr,"{\$errmsg}",errmsg)
			if fieldDatasize<=50 then css="text" else css="text text-long"
			input = "<input type=""text"" class="""& css &"""  maxlength="""& fieldDatasize &""" value="""& value &""" "& inputAttr &"/>"
			tips  = "<span class=""t-normal ml5"" name=""t_"& field &""">"& tipStr &"</span>"
			js    = ""
		end select
		arrayData = array(name,input,tips,js)
		createFormFieldHtml = arrayData
	end function
	public function createMobileSecurityCode()
		dim arr,scid,scodeName,scodeValue,result
		if OW.indexOf(OW.getServerVariables("http_accept"),"html")>0 then
			scodeValue = OW.left(OW.regReplace(OW.Cookie.getCookie("seccodevalue"),"[^0-9a-zA-Z]",""),32)
			scid       = OW.int(OW.DB.getFieldValueBySQL("SELECT top 1 id FROM "& DB_PRE &"security_code_lib WHERE scode_value='"& scodeValue &"' AND used_times=0 AND "& OW.DB.auxSQL &""))
			if scid>0 then
				scodeName  = OW.formatDateTime(SYS_TIME,9) & OW.random(8) & OW.random(6) & OW.random(4)
				scodeValue = OW.MD5.encrypt(scodeName & OW.getClientIP())
				result     = OW.DB.updateRecord(DB_PRE &"security_code_lib",array("scode_name:"& scodeName,"scode_value:"& scodeValue,"used_times:0","create_time:"& SYS_TIME,"latest_use_time:"),array("id:"& scid))
				if result then
					call OW.Cookie.setCookie("seccodevalue",scodeValue,24*60)
				end if
				'call OW.DB.addRecord(DB_PRE &"system_error",array("site_id:"& SITE_ID,"description:"& scodeName,"source:"& OW.getServerVariables("http_accept"),"uid:0","ip:0","datetime:"& SYS_TIME))
			else
				scodeName  = OW.formatDateTime(SYS_TIME,9) & OW.random(8) & OW.random(6) & OW.random(4)
				scodeValue = OW.MD5.encrypt(scodeName & OW.getClientIP())
				if OW.DB.addRecord(DB_PRE &"security_code_lib",array("site_id:"& SITE_ID,"scode_name:"& scodeName,"scode_value:"& scodeValue,"used_times:0","create_time:"& SYS_TIME,"latest_use_time:")) then
					call OW.Cookie.setCookie("seccodevalue",scodeValue,24*60)
				end if
				'call OW.DB.addRecord(DB_PRE &"system_error",array("site_id:"& SITE_ID,"description:"& scodeName,"source:"& OW.getServerVariables("http_accept"),"uid:0","ip:0","datetime:"& SYS_TIME))
			end if
			createMobileSecurityCode = scodeName
		end if
	end function
	public function createPasswordDynamic(byval uid,byval password)
		dim rs
		uid = OW.int(uid)
		if uid>0 then
			if password="" then
				password = OW.DB.getFieldValueBySQL("SELECT password FROM "& DB_PRE &"member WHERE uid="& uid &"")
			end if
			createPasswordDynamic = OW.MD6.encrypt(password & SYS_TIME)
		else
			createPasswordDynamic = ""
		end if
	end function
	public function createUsername(byval uid)
		dim i,us
		us = "US"& OW.formatToFixNumber(6,uid)
		if OW.DB.isRecordExistsBySQL("SELECT * FROM "& OW.DB.Table.member &" WHERE username='"& us &"'") then
			for i=0 to 20
				us = "US"& OW.randsn(12)
				if not(OW.DB.isRecordExistsBySQL("SELECT * FROM "& OW.DB.Table.member &" WHERE username='"& us &"'")) then
					exit for
				end if
			next
		end if
		createUsername = us
	end function
	public function getAdData(byval id,byval echoType)
		dim isValid
		dim adStatus,adStartTime,adEndTime,adHeight,adWidth,adType,adConfigField,adFullScreen,adSwitchTime
		dim adConfig,adHtml,jsonData,s
		id      = OW.int(id)
		isValid = false
		set oRs = OW.DB.getRecordBySQL("SELECT status,start_time,end_time,height,width,full_screen,type,switch_time FROM "& DB_PRE &"ad WHERE ad_id="& id &" AND "& OW.DB.auxSQL &"")
		if not oRs.eof then
			isValid       = true
			adStatus      = OW.int(oRs("status"))
			adStartTime   = oRs("start_time")
			adEndTime     = oRs("end_time")
			adHeight      = oRs("height")
			adWidth       = oRs("width")
			adFullScreen  = OW.int(oRs("full_screen"))
			adType        = oRs("type")
			adSwitchTime  = OW.int(oRs("switch_time"))
			adConfigField = "config_"& adType
			'**判断广告是否有效
			if adStatus=1 then isValid = false
			if OW.int(dateDiff("s",cdate(adStartTime),SYS_TIME))<0 then isValid = false
			if OW.int(dateDiff("s",SYS_TIME,cdate(adEndTime)))<0 then isValid = false
			if isValid then
				jsonData = OW.DB.getFieldValueBySQL("SELECT "& adConfigField &" FROM "& DB_PRE &"ad_data WHERE ad_id="& id &" AND "& OW.DB.auxSQL &"")
				jsonData = OW.dbDataDecode(jsonData)
				adConfig = jsonData
				select case adType
				case "image"
					adConfig = "<div id=""ow_ad_"& id &""" type=""image"" data='"& adConfig &"' style=""display:none; height:"& adHeight &"; width:"& adWidth &"; margin:auto;"" ad_height="""& adHeight &""" ad_width="""& adWidth &""" full_screen="""& adFullScreen &""" switch_time="""& adSwitchTime &"""></div>"
					adHtml   = adConfig &"<script type=""text/javascript"">$(document).ready(function(){OW.ad.parse("& id &");});</script>"
				case "flash"
					adConfig = "<div id=""ow_ad_"& id &""" type=""flash"" data='"& adConfig &"' style=""display:none; height:"& adHeight &"; width:"& adWidth &"; margin:auto;"" ad_height="""& adHeight &""" ad_width="""& adWidth &""" full_screen="""& adFullScreen &"""></div>"
					adHtml   = adConfig &"<script type=""text/javascript"">$(document).ready(function(){OW.ad.parse("& id &");});</script>"
				case else
					adHtml   = adConfig
				end select
			end if
		end if
		OW.DB.closeRs oRs
		if isValid then
			select case echoType
			case "json_data"
				s = jsonData
			case "config"
				s = adConfig
				s = s &"<script type=""text/javascript"">$(document).ready(function(){OW.ad.count("& id &");});</script>"
			case "iframe"
				s = "<iframe src=""ow.ad.asp?id="& id &""" name=""mainFrame"" class=""iframe"" style=""margin:0px; padding:0px; height:"& adHeight &"; width:"& adWidth &";"" frameborder=""0""></iframe>"
				s = s &"<script type=""text/javascript"">$(document).ready(function(){OW.ad.count("& id &");});</script>"
			case else
				s = adHtml
				s = s &"<script type=""text/javascript"">$(document).ready(function(){OW.ad.count("& id &");});</script>"
			end select
		end if
		getAdData = s
	end function
	
	'**附件下载
	public sub getAttachment(byval aid)
		dim fileEx,filename,filepath,filesize
		dim stream,readed,block
		aid = OW.int(aid)
		set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& DB_PRE &"attachment WHERE aid="& aid &" AND "& OW.DB.auxSQL &"")
		if not(oRs.eof) then
			filename = OW.rs(oRs("filename"))
			filepath = OW.rs(oRs("fileurl"))
			filesize = OW.int(oRs("filesize"))
		end if
		OW.DB.closeRs oRs
		call OW.DB.execute("UPDATE "& DB_PRE &"attachment SET downloads=downloads+1")
		fileEx = lcase(OW.right(filepath,4))
		if fileEx=".asp" or fileEx=".inc" or fileEx=".asa" or fileEx=".mdb" or fileEx=".accdb" or fileEx=".mdf" or fileEx=".ldf" then
			response.status="Forbid filetype"
			echo "禁止下载的文件类型，无法下载！"
			exit sub
		end if
		if filesize>1024000 then
			response.Redirect(filepath)
		else
			filepath = OW.FSO.ABSPath(filepath)
			if not OW.FSO.fileExists(filepath) then
				response.status="404 Not Found"
				echo "文件已不存在"
			else
				set stream  = server.createObject("adodb.stream")
				stream.mode = 3
				stream.type = 1
				stream.open
				stream.loadfromfile filepath
				response.ContentType="application/octet-stream"
				response.AddHeader "Content-Disposition", "attachment; filename=""" & filename & """"
				readed = 0
				block  = 102400
				if 102400>=stream.size then
					response.binaryWrite Stream.Read(Stream.size)
				else
					do while readed<stream.size
						if readed+block>stream.size then block = stream.size-readed
						response.binaryWrite stream.read(block)
						readed = readed+block
					loop
				end if
				stream.close
				set stream = nothing
			end if
		end if
	end sub
	public function getCateRootUrlpath(byval cateId)
		cateId = OW.int(cateId)
		dim arr,urlpath
		arr = OW.DB.getFieldValueBySQL("SELECT path,depth,urlpath FROM "& DB_PRE &"category WHERE cate_id="& cateId &" and "& OW.DB.auxSQL &"")
		if OW.int(arr(1))>1 then
			cateId  = OW.int(split(arr(0),",")(1))
			urlpath = OW.DB.getFieldValueBySQL("SELECT urlpath FROM "& DB_PRE &"category WHERE cate_id="& cateId &" and "& OW.DB.auxSQL &"")
		else
			urlpath = arr(2)
		end if
		getCateRootUrlpath = urlpath
	end function
	public function getGroupName(byval groupId)
		dim groupName
		groupName = OW.DB.getFieldValueBySQL("SELECT group_name FROM "& DB_PRE &"member_group_sites WHERE group_id="& groupId &" and "& OW.DB.auxSQL &"")
		if groupName="" then groupName = OW.DB.getFieldValueBySQL("SELECT group_name FROM "& DB_PRE &"member_group WHERE group_id="& groupId &"")
		getGroupName = groupName
	end function
	
	'编译网站配置
	public function getConfig()
		dim arr,i,s,getcfg : getcfg = true
		on error resume next
		if CONFIG_CACHE_OPEN then
			if OW.Cache.ramCacheValid(OW.configCacheName) then
				set OW.config = OW.Cache.getRamCache(OW.configCacheName)
				getcfg = false
			end if
		end if
		if err.number<>0 then
			err.clear
			getcfg = true
		end if
		if getcfg then
			'if DEBUG_TIME then echo "start : getConfig : "& OW.runTime &"<br>"
			set oRs = OW.DB.getRecordBySQL("SELECT config_name,config_value FROM ["& DB_PRE &"site_config] WHERE site_id=0 OR "& OW.DB.auxSQL &"")
			arr = oRs.getRows() : OW.DB.closeRs oRs
			for i=0 to ubound(arr,2)
				OW.config(trim(arr(0,i))) = trim(arr(1,i))
			next
			'if DEBUG_TIME then echo "end : getConfig : "& OW.runTime &"<br>"
			if CONFIG_CACHE_OPEN then
				call OW.Cache.saveRamCache(OW.configCacheName,OW.config)
			end if
			OW.config("main_site_domain") = OW.config("site_domain")
			OW.config("main_site_url")    = OW.config("site_url")
		else
			OW.config("main_site_domain") = OW.DB.getFieldValueBySQL("SELECT top 1 config_value FROM "& DB_PRE &"site_config WHERE config_name='site_domain' AND "& OW.DB.auxSQL &"")
			OW.config("main_site_url")    = OW.DB.getFieldValueBySQL("SELECT top 1 config_value FROM "& DB_PRE &"site_config WHERE config_name='site_url' AND "& OW.DB.auxSQL &"")
		end if
		OW.config("site_domain") = SITE_DOMAIN
		OW.config("site_url")    = SITE_URL
		OW.config("run_mode")       = OW.int(OW.config("run_mode"))
		OW.config("notice")         = OW.dbDataDecode(OW.config("notice"))
		OW.config("service_online") = OW.dbDataDecode(OW.config("service_online"))
		OW.config("kefu")           = OW.dbDataDecode(OW.config("kefu"))
		OW.config("member_share_manage")    = OW.int(OW.config("member_share_manage"))
		OW.config("upload_share_manage")    = OW.int(OW.config("upload_share_manage"))
		OW.config("user_login_close")       = OW.int(OW.config("user_login_close"))
		OW.config("user_reg_close")         = OW.int(OW.config("user_reg_close"))
		OW.config("is_user_mobile_open")    = OW.int(OW.config("is_user_mobile_open"))
		OW.config("mobile_interval_time")   = OW.int(OW.config("mobile_interval_time"))
		OW.config("is_user_email_open")     = OW.int(OW.config("is_user_email_open"))
		OW.config("is_reg_need_username")   = OW.int(OW.config("is_reg_need_username"))
		OW.config("shopping_is_need_login") = OW.int(OW.config("shopping_is_need_login"))
		OW.config("order_is_send_email")    = OW.int(OW.config("order_is_send_email"))
		OW.config("order_is_send_sms")      = OW.int(OW.config("order_is_send_sms"))
		OW.config("is_invoice_open")        = OW.int(OW.config("is_invoice_open"))
		OW.config("is_invoice_vat_open")    = OW.int(OW.config("is_invoice_vat_open"))
		if OW.isNul(OW.config("invoice_taxrate")) or OW.config("invoice_taxrate")<0 then OW.config("invoice_taxrate") = 0
		OW.config("is_book_open")  = IS_BOOK_OPEN
		OW.config("is_point_open") = OW.int(OW.config("is_point_open"))
		OW.config("is_weixin_pc_open")     = OW.int(OW.config("is_weixin_pc_open"))
		OW.config("is_weixin_mobile_open") = OW.int(OW.config("is_weixin_mobile_open"))
		SITE_NAME        = OW.config("site_name")
		SITE_MINI_NAME   = OW.config("site_mini_name")
		SITE_FOLDER      = OW.config("site_folder") : if SITE_FOLDER="/" then SITE_FOLDER=""
		SITE_PATH        = OW.config("site_path")
		UCENTER_URL      = SITE_URL &"ow-ucenter/"
		if OW.config("run_mode")=0 then
			if OW.config("url_type")=1 then
				s = "index.asp?"
			else
				s = "?"
			end if
		end if
		if OW.config("url_path_type")=1 then
			SITE_HURL    = SITE_URL & s
			UCENTER_HURL = SITE_URL &"ow-ucenter/"& OW.iif(OW.config("url_type")=1,"index.asp?","?")
		else
			SITE_HURL    = SITE_PATH & s
			UCENTER_HURL = SITE_PATH &"ow-ucenter/"& OW.iif(OW.config("url_type")=1,"index.asp?","?")
		end if
		tplPath          = tplRoot & OW.config("tpl_folder") &"/"
		tplHtmlPath      = tplPath & OW.config("tpl_html_folder") &"/"
		set OW.DB.Table  = new OW_DB_Table_Class
        if not hasMobile then OW.config("mobile_open")=0
		if OW.config("mobile_open")=1 Then
			call OW.checkIsMobileAgent()
			if OW.config("mobile_design_open")=1 then
				OW.isMobile = true
			end if
			if OW.isMobile then
				tplPath     = tplRoot & OW.config("mobile_tpl_folder") &"/"
				tplHtmlPath = tplPath & OW.config("mobile_tpl_html_folder") &"/"
			end if
		end if
	end function
	public function getTplCacheName(byval key)
		dim s
		s = OW.url(key)
		s = replace(s,"\","")
		s = replace(s,"?","")
		s = replace(s,"{$rootpath}",ROOTPATH)
		s = replace(s,"{$urlpath}",URLPATH)
		s = replace(s,"{$page}",OW_PAGE)
		s = replace(s,"{$tag}",TAG)
		select case key
		case "c1","c3","s1"
			s = s &"index"& SITE_HTML_FILE_SUFFIX
		case "b1"
			s = "shop.brand"& SITE_HTML_FILE_SUFFIX
		case "b2"
			s = "shop.brand.detail"& SITE_HTML_FILE_SUFFIX
		case "order"
			s = "order"& SITE_HTML_FILE_SUFFIX
		case "order.shipping"
			s = "order.shipping"& SITE_HTML_FILE_SUFFIX
		case "order.payment"
			s = "order.payment"& SITE_HTML_FILE_SUFFIX
		case "search.0"
			s = "search.0"& SITE_HTML_FILE_SUFFIX
		case "search.1"
			s = "search.1"& SITE_HTML_FILE_SUFFIX
		case "t1"
			s = "tags"& SITE_HTML_FILE_SUFFIX
		case "gt1"
			s = "shop.tags"& SITE_HTML_FILE_SUFFIX
		end select
		getTplCacheName = s
	end function
	public function getHtmlCacheFile(byval key)
		dim s
		select case key
		case "form"
			if OW_PAGE>0 then
				s = OW.url("f2")
			else
				s = OW.url("f1")
			end if
		case "content"
			if IS_CATE then
				if IS_CPAGE then
					s = OW.iif(OW_PAGE>0,OW.url("c6"),OW.url("c5"))
				else
					if TYPEID<>"0-0-0-0-0-0-0-0" or ORDERBY<>"0-0" then
						if OW_PAGE>0 then
							s = OW.iif(OW.isNul(ROOTPATH),OW.url("c2t"),OW.url("c4t"))
						else
							s = OW.iif(OW.isNul(ROOTPATH),OW.url("c1t"),OW.url("c3t"))
						end if
						s = replace(s,"{$typeid}",TYPEID)
						s = replace(s,"{$orderby}",ORDERBY)
					else
						if OW_PAGE>0 then
							s = OW.iif(OW.isNul(ROOTPATH),OW.url("c2"),OW.url("c4"))
						else
							s = OW.iif(OW.isNul(ROOTPATH),OW.url("c1"),OW.url("c3"))
						end if
					end if
					s = s &"index"& SITE_HTML_FILE_SUFFIX
				end if
			else
				s = OW.iif(OW_PAGE>0,OW.url("c8"),OW.url("c7"))
			end if
		case "s1","b1","cp1"
			s = OW.url(key) &"index"& SITE_HTML_FILE_SUFFIX
		case "b2","b3","cp2","cp3"
			s = OW.url(key)
		case "tags"
			s = OW.iif(OW_PAGE>0,OW.url("t2"),OW.url("t1"))
		case "gtags"
			s = OW.iif(OW_PAGE>0,OW.url("gt2"),OW.url("gt1"))
		case else
			s = OW.url(key)
		end select
		s = replace(s,"{$rootpath}",ROOTPATH)
		s = replace(s,"{$urlpath}",URLPATH)
		s = replace(s,"{$page}",OW_PAGE)
		s = replace(s,"{$tag}",TAG)
		s = replace(s,"{$id}",ID)
		s = replace(s,"\","")
		s = replace(s,"?","")
		getHtmlCacheFile = s
	end function
	public function blackAuth()
		dim auDomain,auFile,auText,auURL,auSN,file,fso,text,s,result
		dim sb,str : set sb = OW.stringBuilder()
		auDomain = OW.AES.encrypt(SITE_DOMAIN)
		sb.append OW.Base64.decode("aHR0cDovL3d3dy5vcGVud2JzLmNvbS9vdy1zZXJ2aWNlL29hdXRoLmFzcD9jdGw9YmxhY2tfYXV0aA")
		auFile   = OW.Cache.sysCachePath & auDomain &"."& OW.Base64.decode("YXV0aA")
		sb.append "&dm=" : sb.append auDomain : sb.append "&dm_sn=" : sb.append auSN : sb.append "&v=" : sb.append OW_VERSION_SN
		auURL    = sb.toString() : set sb = nothing
		if OW.FSO.fileExists(auFile) Then
			set file = OW.objectFSO.getFile(OW.FSO.ABSPath(auFile))
			if OW.dateDiff("s",cDate(file.dateLastModified),now()) < 60*60*24 then
				auText = OW.int(OW.Base64.decode(OW.read(auFile)))
			else
				auText = OW.HTTP.getData(auURL,"") : call OW.FSO.saveFile(auFile,OW.Base64.encode(auText))
			end if
			set file = nothing
		else
			auText = OW.HTTP.getData(auURL,"") : call OW.FSO.saveFile(auFile,OW.Base64.encode(auText))
		end if
		if OW.int(auText)=1 then result = true else result = false
		blackAuth = result
	end function
	
	'获取用户存款数据
	'返回arr(总存款,可用存款,冻结存款)
	public function getMemberDeposit(byval uid)
		dim arr : arr = OW.DB.getFieldValueBySQL("SELECT deposit,available,freeze FROM "& DB_PRE &"member_deposit WHERE uid="& uid &"")
		if arr(0) = "" then arr(0) = 0
		if arr(1) = "" then arr(1) = 0
		if arr(2) = "" then arr(2) = 0
		getMemberDeposit = arr
	end function
	
	'获取用户存款数据
	'返回arr(总存款,可用存款,冻结存款)
	public function getMemberPoint(byval uid)
		dim arr : arr = OW.DB.getFieldValueBySQL("SELECT point,available,freeze FROM "& DB_PRE &"member_point WHERE uid="& uid &"")
		if arr(0) = "" then arr(0) = 0
		if arr(1) = "" then arr(1) = 0
		if arr(2) = "" then arr(2) = 0
		getMemberPoint = arr
	end function
	public function getMemberValidCoupon(byval uid)
		dim num
		num = OW.int(OW.DB.getFieldValueBySQL("SELECT count(*) FROM "& DB_PRE &"coupon_data a LEFT JOIN "& DB_PRE &"coupon b ON (b.coupon_id=a.coupon_id) WHERE a.uid="& uid &" AND a.is_used=0 AND (b.is_use_timelimit=0 or (b.is_use_timelimit=1 and b.use_endtime > '"& SYS_TIME &"')) AND a.site_id="& SITE_ID &""))
		getMemberValidCoupon = num
	end function
	public function getMemberUnReadMsg(byval uid)
		getMemberUnReadMsg = OW.int(OW.DB.getFieldValueBySQL("SELECT count(*) FROM "& DB_PRE &"system_msg WHERE uid="& OW.int(uid) &" AND is_user_read=0 AND "& OW.DB.auxSQL &""))
	end function
	public function getSmsRemainder()
		dim funString : funString = OW.getOWSString("smsrd")
		execute(funString)
	end function
	public function getRegionName(byval path)
		dim arr,i,rs,regionId,regionName,s
		arr = split(path,",")
		for i=0 to ubound(arr)
			regionId   = OW.int(arr(i))
			if regionId>0 then
			regionName = OW.DB.getFieldValueBySQL("SELECT region_name FROM "& DB_PRE &"region WHERE region_id="& regionId &" AND "& OW.DB.auxSQL &"")
			s = OW.iif(OW.isNul(s),regionName,s &" , "& regionName)
			end if
		next
		getRegionName = s
	end function
	
	'编译网站站点信息
	public function getSiteData()
		dim domain,rs
		domain = OW.getDomain("")
		if domain<>"" then
			if IS_UPDATING then
				set rs = OW.DB.getRecordBySQL("SELECT top 1 site_id,site_domain,site_url FROM ["& DB_PRE &"site_domains] WHERE site_domain='"& domain &"'")
				if not(rs.eof) then
					SITE_ID     = rs("site_id")
					SITE_DOMAIN = rs("site_domain")
					SITE_URL    = rs("site_url")
					SITE_DOMAIN_IS_REDIRECT = 0
				else
					die "域名记录不存在，无法获取网站配置信息"
				end if
				OW.DB.closeRs rs
			else
				set rs = OW.DB.getRecordBySQL("SELECT top 1 site_id,site_domain,site_url,is_redirect FROM ["& DB_PRE &"site_domains] WHERE site_domain='"& domain &"'")
				if not(rs.eof) then
					SITE_ID     = rs("site_id")
					SITE_DOMAIN = rs("site_domain")
					SITE_URL    = rs("site_url")
					SITE_DOMAIN_IS_REDIRECT = OW.int(rs("is_redirect"))
				else
					die "域名记录不存在，无法获取网站配置信息"
				end if
				OW.DB.closeRs rs
			end if
			SITE_ID      = OW.int(SITE_ID)
			SITE_FOLDER  = OW.DB.getFieldValueBySQL("SELECT site_folder FROM "& DB_PRE &"sites WHERE site_id="& SITE_ID &"")
			OW.DB.auxSQL = " site_id="& SITE_ID &" "
		end if
	end function
	public function getTypeCateId(byval cateId,byval catePath)
		dim arr,i,id,typeCateId
		cateId = OW.int(cateId)
		arr    = split(catePath,",")
		for i=ubound(arr) to 0 step -1
			id = OW.int(arr(i))
			if id>0 and id<>cateId then
				typeCateId = OW.int(OW.DB.getFieldValueBySQL("SELECT type_cate_id FROM "& OW.DB.Table.category &" WHERE cate_id="& id &" AND "& OW.DB.auxSQL &""))
				if typeCateId>0 then exit for
			end if
		next
		getTypeCateId = OW.int(typeCateId)
	end function
	
	'载入语言文件
	'OS.includeLanguageFile("main.lang.asp")
	public function includeLanguageFile(byval filename)
		on error resume next
		dim lang,filepath
		filepath = "ow-content/languages/"& OS.language &"/"& filename
		call OW.include(filepath)
		if err.Number <> 0 then
			OW.error.Msg = filepath
			OW.error.raise 2
			err.clear
		end if
	end function
	public function authorized()
		dim empFile,empText,empURL,empSN,file,fso,text,s,result
		dim sb,str : set sb = OW.stringBuilder()
		sb.append OW.Base64.decode("aHR0cDovL3d3dy5vcGVud2JzLmNvbS9vdy1zZXJ2aWNlL2VtcG93ZXIuYXNwP2N0bD1jaGVjaw")
		sb.append "&domain=" : sb.append SITE_DOMAIN : sb.append "&empower_sn=" : sb.append empSN
		empFile = OW.Cache.sysCachePath : empFile = empFile & SITE_DOMAIN &"."& OW.Base64.decode("Y2VydA")
		text    = sb.toString() : set sb = nothing
		if OW.FSO.fileExists(empFile) Then
			set file = OW.objectFSO.getFile(OW.FSO.ABSPath(empFile))
			if OW.dateDiff("s",cDate(file.dateLastModified),now()) < 60*60*24 then empText = OW.int(OW.read(empFile)) else empText = OW.int(OW.HTTP.getData(text,"")) : call OW.FSO.saveFile(empFile,empText)
			set file = nothing
		else
			empText = OW.int(OW.HTTP.getData(text,"")) : call OW.FSO.saveFile(empFile,empText)
		end if
		if empText=1 then result = true else result = false
		authorized = result
	end function
	public function isForbidUsername(byval us)
		dim arr
		arr = split(OW.config("forbid_username"),"|")
		if OW.isInArray(arr,us) then
			isForbidUsername = true
		else
			isForbidUsername = false
		end if
	end function
	
	'OS.isGoodsExist(1)
	public function isGoodsExist(byval gid)
		gid = OW.int(gid)
		'isGoodsExist = OW.DB.isRecordExistsBySQL("SELECT * FROM "& OW.DB.Table.goods &" WHERE gid="& gid &" AND status=0 AND "& OW.DB.auxSQL &"")
		isGoodsExist = OW.DB.isRecordExistsBySQL("SELECT * FROM "& OW.DB.Table.goods &" WHERE gid="& gid &" AND "& OW.DB.auxSQL &"")
	end function
	
	'OS.isProductExist(1,1)
	public function isProductExist(byval gid,byval pid)
		gid = OW.int(gid)
		pid = OW.int(pid)
		isProductExist = OW.DB.isRecordExistsBySQL("SELECT * FROM "& OW.DB.Table.goodsProduct &" WHERE pid="& pid &" AND gid="& gid &" AND "& OW.DB.auxSQL &"")
	end function
	public function isSuitExist(byval gid, byval suitId)
		gid    = OW.int(gid)
		suitId = OW.int(suitId)
		isSuitExist = OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"goods_suit WHERE gid="& gid &" AND suit_id="& suitId &" AND status=0 AND "& OW.DB.auxSQL &"")
	end function
	
	'是否是有效的上传路径
	public function isValidUploadPath(byval folderpath)
		if left(folderpath,len(uploadsRoot)) = uploadsRoot then
			isValidUploadPath = true
		else
			isValidUploadPath = false
		end if
	end function
	public function isValidSecurityCode()
		dim scid,scodeName,scodeValue
		scodeName  = OW.left(OW.regReplace(OW.getForm("post","scode_name"),"[^0-9a-zA-Z]",""),32)
		scodeValue = OW.left(OW.regReplace(OW.Cookie.getCookie("seccodevalue"),"[^0-9a-zA-Z]",""),32)
		if OW.isNul(scodeName) or OW.isNul(scodeValue) then isValidSecurityCode = false : exit function
		scid = OW.int(OW.DB.getFieldValueBySQL("SELECT top 1 id FROM "& DB_PRE &"security_code_lib WHERE scode_name='"& scodeName &"' AND scode_value='"& scodeValue &"' AND "& OW.DB.auxSQL &""))
		if scid>0 then
			call OW.DB.updateRecord(DB_PRE &"security_code_lib",array("used_times:used_times+1","latest_use_time:"& SYS_TIME),array("id:"& scid))
			isValidSecurityCode = true
		else
			isValidSecurityCode = false
		end if
	end function
	
	'判断用户名是否已经被注册
	public function isUsernameHaveUsed(byval username,byval uid)
		dim rs,result,sql
		uid    = OW.int(uid)
		if uid>0 then
			sql = "SELECT * FROM ["& DB_PRE &"member] WHERE uid<>"& uid &" AND username='"& username &"'"
		else
			sql = "SELECT * FROM ["& DB_PRE &"member] WHERE username='"& username &"'"
		end if
		set rs = OW.DB.getRecordBySQL(sql)
		if rs.eof then
			result = false
		else
			result = true
		end if
		OW.DB.CloseRs rs
		isUsernameHaveUsed = result
	end function
	
	'判断Email是否已经被注册
	public function isEmailHaveUsed(byval email,byval uid)
		dim rs,result,sql
		uid    = OW.int(uid)
		if uid>0 then
			sql = "SELECT * FROM ["& DB_PRE &"member] WHERE uid<>"& uid &" AND email='"& email &"'"
		else
			sql = "SELECT * FROM ["& DB_PRE &"member] WHERE email='"& email &"'"
		end if
		set rs = OW.DB.getRecordBySQL(sql)
		if rs.eof then
			result = false
		else
			result = true
		end if
		OW.DB.CloseRs rs
		isEmailHaveUsed = result
	end function
	
	'判断手机是否已经被注册
	public function isMobileHaveUsed(byval mobile,byval uid)
		dim rs,result,sql
		uid    = OW.int(uid)
		if uid>0 then
			sql = "SELECT * FROM ["& DB_PRE &"member] WHERE uid<>"& uid &" AND mobile='"& mobile &"'"
		else
			sql = "SELECT * FROM ["& DB_PRE &"member] WHERE mobile='"& mobile &"'"
		end if
		set rs = OW.DB.getRecordBySQL(sql)
		if rs.eof then
			result = false
		else
			result = true
		end if
		OW.DB.CloseRs rs
		isMobileHaveUsed = result
	end function
	public function isMobileCodeValid(byval mb,byval mc,byval smsType)
		dim rs,codeid,smsTime,verifyTimes,isValid : isValid = false
		smsType = OW.int(smsType)
		set rs  = OW.DB.getRecordBySQL("SELECT * FROM "& DB_PRE &"mobile_sms_code WHERE sms_type="& smsType &" AND mobile='"& mb &"' AND sms_text='"& mc &"' AND status=0 AND "& OW.DB.auxSQL &"")
		if not(rs.eof) then
			codeid      = rs("id")
			smsTime     = rs("sms_time")
			verifyTimes = OW.int(rs("verify_times"))
			if OW.dateDiff("s",cDate(smsTime),SYS_TIME) < 1800 and verifyTimes<20 then
				isValid = true
			end if
		end if
		OW.DB.CloseRs rs
		call OW.DB.execute("UPDATE "& DB_PRE &"mobile_sms_code SET verify_times=verify_times+1 WHERE sms_type="& smsType &" AND mobile='"& mb &"' AND "& OW.DB.auxSQL &"")
		isMobileCodeValid = isValid
	end function
	public function isMobileCodeGetTimeValid(byval mobile,byval smsType)
		dim rs,smsTime,isExist,isValid
		isValid= true
		set rs = OW.DB.getRecordBySQL("SELECT * FROM "& DB_PRE &"mobile_sms_code WHERE mobile='"& mobile &"' AND sms_type="& smsType &"")
		if rs.eof then
			isExist = false
		else
			isExist = true
			smsTime = rs("sms_time")
		end if
		OW.DB.CloseRs rs
		if isExist then
			if OW.dateDiff("s",cDate(smsTime),SYS_TIME) < OW.int(OW.config("mobile_interval_time")) then
				isValid = false
			end if
		end if
		isMobileCodeGetTimeValid = isValid
	end function
	public function forgetHtml()
		dim inputNumType,scodeName,vcodeOpen,sb,str : set sb = OW.stringBuilder()
		if OW.config("is_user_mobile_open") then scodeName = OS.createMobileSecurityCode()
		if OW.isMobile then
			inputNumType = "number"
			vcodeOpen    = OW.int(OW.config("user_forget_vcode_open_mb"))
		else
			inputNumType = "text"
			vcodeOpen    = OW.int(OW.config("user_forget_vcode_open_pc"))
		end if
		if OW.config("is_user_mobile_open") then
		sb.append "<div class=""header"" id=""forget_header""><ul><li class=""current""><a by=""mobile"" class=""by-mobile"" href=""javascript:;"">使用手机找回</a></li><li><a by=""email"" class=""by-email"" href=""javascript:;"">使用邮箱找回</a></li></ul></div>"
		end if
		sb.append "<div class=""section"">"
		sb.append "<form class=""form-forget"" name=""form_forget"" action=""javascript:;"" vcode_open="""& vcodeOpen &""">"
		if OW.config("is_user_mobile_open") then
			sb.append "<dl class=""mobile""><dt>手机号码</dt><dd><input type=""tel"" class=""text text-mobile"" name=""mobile"" placeholder=""手机号码"" scode_name="""& scodeName &""" /></dd></dl>"
		end if
		sb.append "<dl class=""email"" "& OW.iif(OW.config("is_user_mobile_open"),"style=""display:none;""","") &"><dt>用户帐号或邮箱</dt><dd><input type=""text"" class=""text text-email"" name=""email"" placeholder=""请输入您的用户账号或账户邮箱"" ></dd></dl>"
		if vcodeOpen then
		sb.append "<dl class=""verifycode""><dt>验证码</dt><dd><input type="""& inputNumType &""" class=""text text-verifycode"" name=""verifycode_value"" placeholder=""验证码"" ><span class=""verifycode"" name=""forget_verifycode""></span></dd></dl>"
		end if
		if OW.config("is_user_mobile_open") then
			sb.append "<dl class=""mobile-code""><dt>"& OS.lang(101) &"</dt><dd><input type="""& inputNumType &""" class=""text text-mobile-code"" maxlength=""6"" name=""mobile_code"" placeholder="""& OS.lang(101) &""" ><button type=""button"" class=""get-mobile-code"" name=""get_mobile_code"" timeout="""&  OW.config("mobile_interval_time") &""">"& OS.lang(106) &"</button></dd></dl>"
		end if
		sb.append "<dl class=""button""><dt></dt><dd><button type=""button"" class=""btn btn-large btn-primary"" name=""btn_submit"">下一步</button></dd></dl>"
		sb.append "</form>"
		sb.append "</div>"
		sb.append "<script type=""text/javascript"">"
		sb.append "$(document).ready(function(){"
		sb.append "var $tab = $(""#forget_header"");"
		sb.append "var $form = $(""form[name='form_forget']"");"
		sb.append "OW.member.forgetPassword({tab:$tab,by:'"& OW.iif(OW.config("is_user_mobile_open"),"mobile","email") &"',form:$form,btn:$form.find(""button[name='btn_submit']"")});"
		sb.append "});"
        sb.append "</script>"
		str = sb.toString() : set sb = nothing
		forgetHtml = str
	end function
	public function forgetResetHtml()
		dim inputNumType,scodeName,vcodeOpen,sb,str : set sb = OW.stringBuilder()
		if OW.isMobile then
			inputNumType = "number"
			vcodeOpen    = OW.int(OW.config("user_forget_vcode_open_mb"))
		else
			inputNumType = "text"
			vcodeOpen    = OW.int(OW.config("user_forget_vcode_open_pc"))
		end if
		sb.append "<form class=""form-forget form-forget-reset"" name=""form_forget"" action=""javascript:;"" uid="""& V("uid") &""" hash="""& V("hash") &""" vcode_open="""& vcodeOpen &""">"
		sb.append "<dl class=""username""><dt>用户</dt><dd>"& V("username") &"</dd></dl>"
		sb.append "<dl class=""password""><dt>设置新密码</dt><dd><input type=""password"" class=""text text-password"" name=""password"" placeholder=""新密码"" ></dd></dl>"
		sb.append "<dl class=""password""><dt>确认新密码</dt><dd><input type=""password"" class=""text text-password-re"" name=""repassword"" placeholder=""再输入一次新密码"" ></dd></dl>"
		if vcodeOpen then
		sb.append "<dl class=""verifycode""><dt>验证码</dt><dd><input type="""& inputNumType &""" class=""text text-verifycode"" name=""verifycode_value"" placeholder=""验证码"" ><span class=""verifycode"" name=""forget_verifycode""></span></dd></dl>"
		end if
		sb.append "<dl class=""button""><dt></dt><dd><button type=""button"" class=""btn btn-large btn-primary"" name=""btn_submit"">确定</button></dd></dl>"
		sb.append "</form>"
		sb.append "<script type=""text/javascript"">"
		sb.append "$(document).ready(function(){"
		sb.append "var $form = $(""form[name='form_forget']"");"
		sb.append "OW.member.forgetPasswordReset({form:$form,btn:$form.find(""button[name='btn_submit']"")});"
		sb.append "});"
        sb.append "</script>"
		str = sb.toString() : set sb = nothing
		forgetResetHtml = str
	end function
	public function loginWinHtml()
		loginWinHtml = OS.createLoginHtml("win")
	end function
	public function loginHtml()
		loginHtml = OS.createLoginHtml("")
	end function
	public function createLoginHtml(byval loginType)
		if OW.config("user_login_close") then loginHtml="<div class=""user-login-close"">网站已关闭用户登录</div>" : exit function
		dim sb,str : set sb = OW.stringBuilder()
		dim uNameInputType,codeInputType,uName,btnName,vcodeOpen
		if OW.config("is_user_mobile_open") then
			uName = "手机号码/用户名"
			uNameInputType = "tel"
		else
			uName = "用户名"
			uNameInputType = "text"
		end if
		if OW.isMobile then
			codeInputType  = "number"
			vcodeOpen      = OW.int(OW.config("user_login_vcode_open_mb"))
		else
			codeInputType  = "text"
			vcodeOpen      = OW.int(OW.config("user_login_vcode_open_pc"))
		end if
		sb.append "<form class=""form-login"" name=""form_login"" action=""javascript:;"" vcode_open="""& vcodeOpen &""">"
		sb.append "<dl class=""username""><dt>"& uName &"</dt><dd><input type="""& uNameInputType &""" class=""text text-username"" name=""username"" placeholder="""& uName &""" /></dd></dl>"
		sb.append "<dl class=""password""><dt>登陆密码</dt><dd><input type=""password"" class=""text text-password"" name=""password"" placeholder=""登陆密码"" /></dd></dl>"
		if vcodeOpen then
		sb.append "<dl class=""verifycode""><dt>验证码</dt><dd><input type="""& codeInputType &""" class=""text text-verifycode"" name=""verifycode_value"" placeholder=""验证码"" ><span class=""verifycode"" name=""login_verifycode""></span></dd></dl>"
		end if
		sb.append "<dl class=""button""><dt></dt><dd><button type=""button"" class=""btn btn-large btn-primary btn-login"" name=""btn_login"">立即登陆</button></dd></dl>"
		sb.append "<dl class=""remember""><dt></dt><dd><label class=""remember""><input type=""checkbox"" name=""remember"" checked=""checked"" value=""1"" >记住我</label><a class=""forget"" href="""& OW.urlRewrite("l4") &""">忘记密码？</a>"
		if loginType="win" then
		sb.append "<a href="""& OW.urlRewrite("l3") &""" class=""reg-member"" target=""_blank"">立即注册会员</a><a href=""javascript:;"" class=""unlogin-buy"" name=""unlogin_buy"">不登录，直接购买</a>"
		end if
		sb.append "</dd></dl>"
		sb.append "</form>"
		sb.append "<script type=""text/javascript"">"
		sb.append "$(document).ready(function(){"
		sb.append "var $form = $(""form[name='form_login']""),"
		sb.append "$username = $form.find(""input[name='username']""),"
		sb.append "$password = $form.find(""input[name='password']""),"
		sb.append "$vcodeValue = $form.find(""input[name='verifycode_value']""),"
		sb.append "$verifycode = $form.find(""span[name='login_verifycode']""),"
		sb.append "$remember = $form.find(""input[name='remember']""),"
		sb.append "$btnLogin = $form.find(""button[name='btn_login']"");"
		if OW.isMobile then
		sb.append "OW.verifyCode({boxer:$verifycode});"
		end if
		sb.append "OW.member.loginInit({username:$username,password:$password,vcodeValue:$vcodeValue,verifycode:$verifycode});"
		sb.append "$btnLogin.click(function(){OW.member.login({vcode_open:"&vcodeOpen&",username:$username,password:$password,vcodeValue:$vcodeValue,verifycode:$verifycode,remember:$remember,btnLogin:$btnLogin});});"
		sb.append "OW.enterClick(function(){$btnLogin.click();});"
		sb.append "});"
        sb.append "</script>"
		str = sb.toString() : set sb = nothing
		createLoginHtml = str
	end function
	public function login(byval us,byval pw)
		if OW.config("user_login_close") then login = OS.lang(26) : exit function
		login = OS.logining("",us,pw,"ajax")
	end function
	public function logining(byval usUid,byval us,byval pw,byval loginBy)
		dim email,mobile,ip,rs,sql,result : result = false
		usUid = OW.int(usUid)
		ip    = OW.getClientIP()
		if loginBy="app" then
			sql = "SELECT uid,username,password,nickname,group_id,special_group_id,admin_group_id,status FROM "& DB_PRE &"member WHERE uid="& usUid &""
		else
			pw = OW.parsePassword(pw)
			if OW.isNul(pw) then login = OS.lang(12) : exit function
			if OW.isValidMobile(us) then
				mobile = us
				sql    = "SELECT uid,username,password,nickname,group_id,special_group_id,admin_group_id,status FROM "& DB_PRE &"member WHERE mobile='"& mobile &"'"
			else
				us     = OW.parseUsername(us)
				sql    = "SELECT uid,username,password,nickname,group_id,special_group_id,admin_group_id,status FROM "& DB_PRE &"member WHERE username='"& us &"'"
			end if
			if OW.isNul(us) then login = OS.lang(11) : exit function
		end if
		set rs = OW.DB.getRecordBySQL(sql)
		if rs.eof then
			result = replace(OS.lang(13),"{$username}",us)
		else
			if OW.int(rs("status"))=1 then
				result = replace(OS.lang(14),"{$username}",us)
			else
				if loginBy<>"app" and pw<>rs("password") then
				    result = OS.lang(12)
				else
					result = true
					UID              = rs("uid")
					USERNAME         = rs("username")
					NICKNAME         = rs("nickname")
					PASSWORD         = rs("password")
					GROUP_ID         = rs("group_id")
					SPECIAL_GROUP_ID = rs("special_group_id")
					ADMIN_GROUP_ID   = rs("admin_group_id")
				end if
			end if
		end if
		OW.DB.CloseRs rs
		if result = true then
			USS_KEY   = OS.createPasswordDynamic(UID,PASSWORD)
			USS_VALUE = "1"
			call memberCookiesSetting()
			call memberSessionSetting()
			if not OS.updatePasswordDynamic(UID,USS_KEY) then
				if DB_TYPE = 0 then
					result = OS.lang(15)
				else
					result = OS.lang(16)
				end if
			end if
		end if
		if result = true then
			call OW.DB.updateRecord(DB_PRE &"member",array("login_times=login_times+1","last_login_time:"& SYS_TIME,"last_login_ip:"& ip),Array("uid:"& UID))
		end if
		logining = result
	end function
	
	'用户退出
	public function logout()
		call OS.memberCookiesRemove()
		call OS.memberSessionRemove()
	end function
	
	'**登陆成功后生成cookies
	public function memberCookiesSetting()
		call OW.Cookie.setCookie("uid",UID,OW.loginTimeout)
		call OW.Cookie.setCookie("username",USERNAME,OW.loginTimeout)
		call OW.Cookie.setCookie("nickname",OW.escape(NICKNAME),OW.loginTimeout)
		call OW.Cookie.setCookie("uss_key",USS_KEY,OW.loginTimeout)
	end function
	
	'**清除cookies
	public function memberCookiesRemove()
		call OW.Cookie.removeCookie("uid")
		call OW.Cookie.removeCookie("username")
		call OW.Cookie.removeCookie("uss_key")
		call OW.Cookie.removeCookie("admin_uid")
		call OW.Cookie.removeCookie("admin_uss_key")
	end function
	
	'**登陆成功后生成session
	public function memberSessionSetting()
		dim ussExist
		ussExist = OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"ucenter_session WHERE uid="& UID &"")
		if ussExist then
			OW.DB.auxSQLValid = false
			call OW.DB.updateRecord(DB_PRE &"ucenter_session",array("utype:1","username:"& USERNAME,"uss_key:"& USS_KEY,"uss_value:"& USS_VALUE,"datetime:"& SYS_TIME),array("uid:"& UID))
			OW.DB.auxSQLValid = true
		else
			call OW.DB.addRecord(DB_PRE &"ucenter_session",array("uid:"& UID,"utype:1","username:"& USERNAME,"uss_key:"& USS_KEY,"uss_value:"& USS_VALUE,"datetime:"& SYS_TIME))
		end if
	end function
	
	'**清除session
	public function memberSessionRemove()
		if UID>0 then
			call OW.DB.execute("DELETE FROM "& DB_PRE &"ucenter_session WHERE uid="& UID &"")
		end if
	end function
	
	'存入预存款
	'返回数组array(操作结果[true|false],信息)
	public function memberDepositIncome(byval uid,byval amount,byval remark)
		dim arr,available,deposit,ip,msg,result,sn,sql,tempSQLValid
		ip  = OW.getClientIP()
		sn  = OS.createSN()
		arr = OS.getMemberDeposit(uid)
		msg = ""
		deposit   = arr(0) + amount
		available = arr(1) + amount
		tempSQLValid      = OW.DB.auxSQLValid
		OW.DB.auxSQLValid = false
		'创建充值记录
		sql    = OW.DB.wAddRecordSQL(DB_PRE &"member_deposit_log",array("type:1","time:"& SYS_TIME,"uid:"& uid,"sn:"& sn,"expend:0","income:"& amount,"deposit:"& deposit,"remark:"& remark,"ip:"& ip))
		result = OW.DB.execute(sql)
		if not(result) then
			result = OW.DB.execute(sql)
		end if
		'更新存款
		if result then
			sql    = OW.DB.wUpdateRecordSQL(DB_PRE &"member_deposit",array("available:"& available,"deposit:"& deposit),array("uid:"& uid))
			result = OW.DB.execute(sql)
			if not(result) then
				result = OW.DB.execute(sql)
			end if
		end if
		OW.DB.auxSQLValid   = tempSQLValid
		memberDepositIncome = array(result,msg)
	end function
	
	'消费预存款
	'返回数组array(操作结果[true|false],信息)
	public function memberDepositExpend(byval uid,byval amount,byval remark)
		dim arr,available,deposit,ip,msg,result,sn,sql,tempSQLValid
		ip  = OW.getClientIP()
		sn  = OS.createSN()
		arr = OS.getMemberDeposit(uid)
		msg = ""
		'当可用存款小于amount时报告操作失败
		if arr(1) < amount then
			result = false
			msg    = "可用存款不足，无法消费！"
		else
			deposit   = arr(0) - amount
			available = arr(1) - amount
			tempSQLValid      = OW.DB.auxSQLValid
			OW.DB.auxSQLValid = false
			'创建消费记录
			sql    = OW.DB.wAddRecordSQL(DB_PRE &"member_deposit_log",array("type:2","time:"& SYS_TIME,"uid:"& uid,"sn:"& sn,"expend:"& amount,"income:0","deposit:"& deposit,"remark:"& remark,"ip:"& ip))
			result = OW.DB.execute(sql)
			if not(result) then
				result = OW.DB.execute(sql)
			end if
			'更新存款
			if result then
				sql    = OW.DB.wUpdateRecordSQL(DB_PRE &"member_deposit",array("available:"& available,"deposit:"& deposit),array("uid:"& uid))
				result = OW.DB.execute(sql)
				if not(result) then
					result = OW.DB.execute(sql)
				end if
			end if
			OW.DB.auxSQLValid   = tempSQLValid
		end if
		memberDepositExpend = array(result,msg)
	end function
	
	'积分充值
	'返回数组array(操作结果[true|false],信息)
	public function membePointCharge(byval uid,byval amount,byval remark)
		dim arr,available,ip,point,result,sn,sql,tempSQLValid
		ip  = OW.getClientIP()
		sn  = OS.createSN()
		arr = OS.getMemberPoint(uid)
		point     = arr(0) + amount
		available = arr(1) + amount
		tempSQLValid      = OW.DB.auxSQLValid
		OW.DB.auxSQLValid = false
		'创建充值记录
		sql    = OW.DB.wAddRecordSQL(DB_PRE &"member_point_log",array("type:1","time:"& SYS_TIME,"uid:"& uid,"sn:"& sn,"expend:0","income:"& amount,"point:"& point,"remark:"& remark,"ip:"& ip))
		result = OW.DB.execute(sql)
		if not(result) then
			result = OW.DB.execute(sql)
		end if
		'更新存款
		if result then
			sql    = OW.DB.wUpdateRecordSQL(DB_PRE &"member_point",array("available:"& available,"point:"& point),array("uid:"& uid))
			result = OW.DB.execute(sql)
			if not(result) then
				result = OW.DB.execute(sql)
			end if
		end if
		OW.DB.auxSQLValid = tempSQLValid
		membePointCharge  = result
	end function
	
	'消费积分
	'返回数组array(操作结果[true|false],信息)
	public function memberPointExpend(byval uid,byval amount,byval remark)
		dim arr,available,point,ip,msg,result,sn,sql,tempSQLValid
		ip  = OW.getClientIP()
		sn  = OS.createSN()
		arr = OS.getMemberPoint(uid)
		msg = ""
		'当可用存款小于amount时报告操作失败
		if arr(1) < amount then
			result = false
			msg    = "可用积分不足，无法消费！"
		else
			point     = arr(0) - amount
			available = arr(1) - amount
			tempSQLValid      = OW.DB.auxSQLValid
			OW.DB.auxSQLValid = false
			'创建消费记录
			sql    = OW.DB.wAddRecordSQL(DB_PRE &"member_point_log",array("type:2","time:"& SYS_TIME,"uid:"& uid,"sn:"& sn,"expend:"& amount,"income:0","point:"& point,"remark:"& remark,"ip:"& ip))
			result = OW.DB.execute(sql)
			if not(result) then
				result = OW.DB.execute(sql)
			end if
			'更新存款
			if result then
				sql    = OW.DB.wUpdateRecordSQL(DB_PRE &"member_point",array("available:"& available,"point:"& point),array("uid:"& uid))
				result = OW.DB.execute(sql)
				if not(result) then
					result = OW.DB.execute(sql)
				end if
			end if
			OW.DB.auxSQLValid   = tempSQLValid
		end if
		memberPointExpend = array(result,msg)
	end function
	public function deleteMember(byval delUid)
		dim result : result = false
		delUid = OW.int(delUid)
		result = OW.DB.execute("DELETE FROM "& DB_PRE &"member WHERE uid="& delUid &"")
		if result then
			call OW.DB.execute("DELETE FROM "& DB_PRE &"member_detail WHERE uid="& delUid &"")
			call OW.DB.execute("DELETE FROM "& DB_PRE &"ucenter_member WHERE uid="& delUid &"")
			call OW.DB.execute("DELETE FROM "& DB_PRE &"ucenter_session WHERE uid="& delUid &"")
			call OW.DB.execute("DELETE FROM "& DB_PRE &"coupon_data WHERE uid="& delUid &"")
			if OW.DB.isTableExists(DB_PRE &"member_weixin") then
				call OW.DB.execute("DELETE FROM "& DB_PRE &"member_weixin WHERE uid="& delUid &"")
			end if
		end if
		deleteMember = result
	end function
	public function mobileAndPasswordSetting(byval uid,byval mb,byval pw)
		dim rs,result : result = false
		dim isWXUser,oldUid,oldSex,oldNickname,oldAvatar,isOldUserWeixin
		uid= OW.int(uid)
		pw = OW.parsePassword(pw)
		if uid>0 and OW.isValidMobile(mb) then
			oldUid = OW.int(OW.DB.getFieldValueBySQL("SELECT top 1 uid FROM "& DB_PRE &"member WHERE mobile='"& mb &"'"))
			result = OW.DB.execute("UPDATE "& DB_PRE &"member SET mobile='"& mb &"',password='"& pw &"' WHERE uid="& uid &"")
			if result then
				call OW.DB.execute("UPDATE "& DB_PRE &"ucenter_member SET mobile='"& mb &"',password='"& pw &"' WHERE uid="& uid &"")
				if oldUid>0 then
					'**如果手机原来已经绑定其他会员
					call OW.DB.execute("UPDATE "& DB_PRE &"member SET mobile='' WHERE mobile='"& mb &"' AND uid<>"& uid &"")
					call OW.DB.execute("UPDATE "& DB_PRE &"ucenter_member SET mobile='' WHERE mobile='"& mb &"' AND uid<>"& uid &"")
				end if
			end if
		end if
		mobileAndPasswordSetting = result
	end function
	
	
	'系统邮件配置初始化
	public function mailConfigInit()
		redim mailConfig(5,0)
		mailConfig(0,0) = OW.config("mail_smtp")
		mailConfig(1,0) = OW.config("mail_mailserver_username")
		mailConfig(2,0) = OW.config("mail_mailserver_password")
		mailConfig(3,0) = OW.config("mail_from")
		mailConfig(4,0) = OW.htmlDecode(OW.config("mail_fromname"))
	end function
	public function redirectError404()
		call redirect(OW.urlRewrite("e1"))
	end function
	public function regHtml()
		if OW.config("user_reg_close") then regHtml="<div class=""user-reg-close"">"& OS.lang(117) &"</div>" : exit function
		dim vcodeOpen
		dim scodeName,sb,str : set sb = OW.stringBuilder()
		if OW.config("is_user_mobile_open") then scodeName = OS.createMobileSecurityCode()
		if OW.isMobile then
			vcodeOpen = OW.int(OW.config("user_reg_vcode_open_mb"))
		else
			vcodeOpen = OW.int(OW.config("user_reg_vcode_open_pc"))
		end if
		sb.append "<form class=""form-reg"" name=""form_reg"" action=""javascript:;"" vcode_open="""& vcodeOpen &""">"
		if OW.isMobile then
			if OW.config("is_user_mobile_open") then
				sb.append "<dl class=""mobile""><dt>"& OS.lang(100) &"</dt><dd><input type=""tel"" class=""text text-mobile"" maxlength=""11"" name=""mobile"" placeholder="""& OS.lang(100) &""" scode_name="""& scodeName &""" /></dd></dl>"
				if vcodeOpen then
				sb.append "<dl class=""verifycode""><dt>"& OS.lang(6) &"</dt><dd><input type=""number"" class=""text text-verifycode"" maxlength=""5"" name=""verifycode_value"" placeholder="""& OS.lang(6) &""" ><span class=""verifycode"" name=""reg_verifycode""></span></dd></dl>"
				end if
				sb.append "<dl class=""mobile-code""><dt>"& OS.lang(101) &"</dt><dd><input type=""number"" class=""text text-mobile-code"" maxlength=""6"" name=""mobile_code"" placeholder="""& OS.lang(101) &""" ><button type=""button"" class=""get-mobile-code"" name=""get_mobile_code"" timeout="""& OW.config("mobile_interval_time") &""">"& OS.lang(106) &"</button></dd></dl>"
			end if
			if OW.int(OW.config("is_reg_need_username"))=1 then
				sb.append "<dl class=""username""><dt>"& OS.lang(102) &"<span class=""t-normal"">"& OS.lang(114) &"</span></dt><dd><input type=""text"" class=""text text-username"" maxlength=""15"" name=""username"" placeholder="""& OS.lang(109) &""" ></dd></dl>"
			end if
			if OW.int(OW.config("is_user_email_open"))=1 then
				sb.append "<dl class=""email""><dt>Email</dt><dd><input type=""email"" class=""text text-email"" maxlength=""64"" name=""email"" placeholder="""& OS.lang(110) &""" ></dd></dl>"
			end if
			sb.append "<dl class=""pssword""><dt>"& OS.lang(104) &"</dt><dd><input type=""text"" class=""text text-pssword"" maxlength=""32"" name=""password"" placeholder="""& OS.lang(104) &""" ></dd></dl>"
			if OW.config("is_user_mobile_open")=0 then
				if vcodeOpen then
				sb.append "<dl class=""verifycode""><dt>"& OS.lang(6) &"</dt><dd><input type=""number"" class=""text text-verifycode"" maxlength=""5"" name=""verifycode_value"" placeholder="""& OS.lang(6) &""" ><span class=""verifycode"" name=""reg_verifycode""></span></dd></dl>"
				end if
			end if
			sb.append "<dl class=""agreement""><dt></dt><dd>"& OS.lang(112) &"<a href="""& SITE_HURL &"agreement"& SITE_HTML_FILE_SUFFIX &""" target=""_blank"">"& OS.lang(113) &"</a></dl>"
			sb.append "<dl class=""button""><dt></dt><dd><button type=""button"" class=""btn btn-large btn-primary btn-reg"" name=""btn_reg"">"& OS.lang(111) &"</button></dd></dl>"
		else
			if OW.config("is_user_mobile_open") then
				sb.append "<dl class=""mobile""><dt>"& OS.lang(100) &"</dt><dd><input type=""text"" class=""text text-mobile"" maxlength=""11"" name=""mobile"" placeholder="""& OS.lang(100) &""" scode_name="""& scodeName &""" /></dd></dl>"
				if vcodeOpen then
				sb.append "<dl class=""verifycode""><dt>"& OS.lang(6) &"</dt><dd><input type=""text"" class=""text text-verifycode"" maxlength=""5"" name=""verifycode_value"" placeholder="""& OS.lang(105) &""" ><span class=""verifycode"" name=""reg_verifycode""></span></dd></dl>"
				end if
				sb.append "<dl class=""mobile-code""><dt>"& OS.lang(101) &"</dt><dd><input type=""text"" class=""text text-mobile-code"" maxlength=""6"" name=""mobile_code"" placeholder="""& OS.lang(101) &""" ><button type=""button"" class=""get-mobile-code"" name=""get_mobile_code"" timeout="""&  OW.config("mobile_interval_time") &""">"& OS.lang(106) &"</button></dd></dl>"
			end if
			if OW.int(OW.config("is_reg_need_username"))=1 then
				sb.append "<dl class=""username""><dt>"& OS.lang(102) &"</dt><dd><input type=""text"" class=""text text-username"" maxlength=""15"" name=""username"" placeholder="""& OS.lang(109) &""" ><span class=""t-normal ml5"">"& OS.lang(114) &"</span></dd></dl>"
			end if
			if OW.config("is_user_email_open") then
				sb.append "<dl class=""email""><dt>Email</dt><dd><input type=""text"" class=""text text-email"" maxlength=""64"" name=""email"" placeholder="""& OS.lang(110) &""" ></dd></dl>"
			end if
			sb.append "<dl class=""pssword""><dt>"& OS.lang(104) &"</dt><dd><input type=""password"" class=""text text-pssword"" maxlength=""32"" name=""password"" placeholder="""& OS.lang(104) &""" ></dd></dl>"
			if OW.config("is_user_mobile_open")=0 then
				sb.append "<dl class=""repssword""><dt>"& OS.lang(115) &"</dt><dd><input type=""password"" class=""text text-pssword-re"" maxlength=""32"" name=""repassword"" placeholder="""& OS.lang(116) &""" ></dd></dl>"
				if vcodeOpen then
				sb.append "<dl class=""verifycode""><dt>"& OS.lang(6) &"</dt><dd><input type=""text"" class=""text text-verifycode"" maxlength=""5"" name=""verifycode_value"" placeholder="""& OS.lang(105) &""" ><span class=""verifycode"" name=""reg_verifycode""></span></dd></dl>"
				end if
			end if
			sb.append "<dl class=""agreement""><dt></dt><dd>"& OS.lang(112) &"<a href="""& SITE_HURL &"agreement"& SITE_HTML_FILE_SUFFIX &""" target=""_blank"">"& OS.lang(113) &"</a></dl>"
			sb.append "<dl class=""button""><dt></dt><dd><button type=""button"" class=""btn btn-large btn-primary btn-reg"" name=""btn_reg"">"& OS.lang(111) &"</button></dd></dl>"
		end if
		
		sb.append "</form>"
		sb.append "<script type=""text/javascript"">"
		sb.append "$(document).ready(function(){"
		sb.append "var $form   = $(""form[name='form_reg']""),"
		sb.append "$btnReg     = $form.find(""button[name='btn_reg']""),"
		sb.append "$vcodeValue = $form.find(""input[name='verifycode_value']""),"
		sb.append "$verifycode = $form.find(""span[name='reg_verifycode']"");"
		sb.append "OW.verifyCode({boxer:$verifycode});"
		sb.append "OW.verifyCodeValueFocus($vcodeValue,$verifycode);"
		sb.append "OW.verifyCodeValueBlur($vcodeValue);"
		sb.append "OW.member.regInit({form:$form});"
		sb.append "$btnReg.click(function(){OW.member.reg({form:$form,vcode_open:"&vcodeOpen&",vcodeValue:$vcodeValue,verifycode:$verifycode,btnReg:$btnReg});});"
		sb.append "OW.enterClick(function(){$btnReg.click();});"
		sb.append "});"
		sb.append "</script>"
		str = sb.toString() : set sb = nothing
		regHtml = str
	end function
	public function reg(byval us,byval pw,byval em,byval mb,byval mc)
		dim rs,result,groupId
		result = false
		us     = OW.parseUsername(us)
		pw     = OW.parsePassword(pw)
		em     = OW.parseEmail(em)
		mb     = OW.parseMobile(mb)
		mc     = OW.parseMobileCode(mc)
		if OW.config("user_reg_close") then reg=OS.lang(17) : exit function
		if OW.config("is_user_mobile_open") then
			if OW.isNul(mb) or OW.isNul(mc) then reg = OS.lang(21) : exit function
			if OS.isMobileHaveUsed(mb,0) then reg = OW.reps(OS.lang(25),"{$tel}",mb) : exit function
			if not OS.isMobileCodeValid(mb,mc,1) then
				reg = OS.lang(21) : exit function
			end if
		else
			if OW.config("is_reg_need_username") then
				if OW.isNul(us) then reg = OS.lang(18) : exit function
			end if
			if OW.isNul(em) or not(OW.isEmail(em)) then reg = OS.lang(20) : exit function
		end if
		if OW.isNul(pw) then reg = OS.lang(19) : exit function
		if OS.isForbidUsername(us) then reg=OW.reps(OS.lang(22),"{$username}",us) : exit function
		if OW.isNotNul(us) and OS.isUsernameHaveUsed(us,0) then reg=OW.reps(OS.lang(23),"{$username}",us) : exit function
		if OW.isNotNul(em) and OS.isEmailHaveUsed(em,0) then reg=OW.reps(OS.lang(24),"{$email}",em) : exit function
		reg = reging(us,pw,em,mb,0,"","")
	end function
	public function reging(byval us,byval pw,byval em,byval mb,byval sex,byval nickname,byval avatar)
		dim ip,groupId,result
		ip       = OW.getClientIP()
		nickname = OW.validClientDBData(nickname,32)
		sex      = OW.int(sex)
		avatar   = OW.left(avatar,255)
		groupId = OW.DB.getFieldValueBySQL("SELECT top 1 group_id FROM "& DB_PRE &"member_group WHERE group_type=2 AND group_rank>0 AND status=0 ORDER BY group_rank ASC")
		result  = OW.DB.addRecord(OW.DB.Table.member,array("site_id:"& SITE_ID,"status:0","utype:0","username:"& us,"password:"& pw,"password_dynamic:","email:"& em,"mobile:"& mb,"nickname:"& nickname,"sex:"& sex,"avatar:"& avatar,"avatar_big:"& avatar,"admin_group_id:0","group_id:"& groupId,"special_group_id:","reg_time:"& SYS_TIME,"reg_ip:"& ip,"login_times:1","last_login_time:"& SYS_TIME,"last_login_ip:"& ip))
		if result = true then
			if OW.isNul(us) then
				UID = OW.DB.getFieldValueBySQL("SELECT top 1 uid FROM "& OW.DB.Table.member &" ORDER BY uid desc")
				us  = OS.createUsername(UID)
				call OW.DB.execute("UPDATE "& OW.DB.Table.member &" SET username='"& us &"' WHERE uid="& UID &"")
			else
				UID = OW.DB.getFieldValueBySQL("SELECT uid FROM "& OW.DB.Table.member &" WHERE username='"& us &"'")
			end if
			call OW.DB.addRecord(DB_PRE &"member_detail",array("uid:"& UID))
			call OW.DB.addRecord(DB_PRE &"ucenter_member",array("uid:"& UID,"site_id:"& SITE_ID,"status:0","username:"& us,"password:"& pw,"email:"& em,"mobile:"& mb))
			call OW.DB.addRecord(DB_PRE &"member_deposit",array("uid:"& UID,"available:0","freeze:0","deposit:0"))
			call OW.DB.addRecord(DB_PRE &"member_point",array("uid:"& UID,"available:0","freeze:0","point:0"))
			call OW.DB.execute("DELETE FROM ["& DB_PRE &"mobile_sms_code] WHERE sms_type=1 AND mobile='"& mb &"'")
			USERNAME         = us
			PASSWORD         = pw
			GROUP_ID         = groupId
			SPECIAL_GROUP_ID = 0
			ADMIN_GROUP_ID   = 0
			USS_KEY   = OS.createPasswordDynamic(UID,PASSWORD)
			USS_VALUE = "1"
			call memberCookiesSetting()
			call memberSessionSetting()
			call OS.updatePasswordDynamic(UID,USS_KEY)
		end if
		reging = result
	end function
	public function typeIdDo(byval s)
		dim i,id,sqlStr
		TYPEID_ARR = split(s,"-")
		for i=0 to ubound(TYPEID_ARR)
			if i>=8 then exit for
			id = OW.int(TYPEID_ARR(i))
			if id>0 then
				sqlStr = sqlStr &" a.type_id"& i+1 &"="& id &" AND "
			end if
		next
		V("list_by_type") = sqlStr
	end function
	public function orderByDo(byval s)
		dim f,t
		f = OW.int(OW.cLeft(s,"-"))
		t = OW.int(OW.cRight(s,"-"))
		select case f
		case 1
			orderByDo = "price "& OW.iif(t=0,"ASC","DESC")
		case 2
			orderByDo = "sales "& OW.iif(t=1,"ASC","DESC")
		case 3
			orderByDo = "views "& OW.iif(t=1,"ASC","DESC")
		case else
			orderByDo = "sequence "& OW.iif(t=0,"ASC","DESC")
		end select
	end function
	public function sendEmail(byval froms, byval recipient, byval subject, byval body)
		dim smtp,MSUserName,MSPassword,from,fromName,recEmail,recName
		dim i,dataNum,isCircle,result
		isCircle = true
		result   = false
		if IsArray(froms) then
			if ubound(froms)>=2 then isCircle = false
		end if
		if IsArray(recipient) then
			recEmail = recipient(0)
			recName  = recipient(1)
		else
			recEmail = recipient
		end if
		call mailConfigInit()
		dataNum = -1
		if IsArray(mailConfig) then dataNum=ubound(mailConfig,2)
		if isCircle = false then dataNum=0
		for i=0 To dataNum
			smtp       = mailConfig(0,i)
			MSUserName = mailConfig(1,i)
			MSPassword = mailConfig(2,i)
			from       = mailConfig(3,i)
			fromName   = mailConfig(4,i)
			if IsArray(froms) then
				if ubound(froms)>=2 then
					smtp       = froms(0)
					MSUserName = froms(1)
					MSPassword = froms(2)
					from       = froms(3)
					fromName   = froms(4)
				else
					fromName   = froms(0)
				end if
			end if
			result = sendEmailing(smtp, MSUserName, MSPassword, from, fromName, recEmail, recName, subject, body)
			if result=true then exit for
		Next
		if err.number<>0 then err.clear() : result = "error_server"
		sendEmail = result
	end function
	public function sendEmailing(byval smtp,byval MSUserName,byval MSPassword, byval from, byval fromName, byval recEmail, byval recName, byval subject, byval body)
		on error resume next
		dim mail,jmail,result : result = false
		mail = "jmail"
		select case mail
		case "jmail"
			set jmail = server.createObject("JMail.Message")
			if err.number<>0 then
				err.clear()
				sendEmailing="JMail组件未安装"
				exit function
			end if
			jmail.Charset = OW.charSet
			jmail.ContentType = "text/html"
			jmail.From = from
			jmail.FromName = fromName
			if OW.isNul(recName) then
				jmail.AddRecipient recEmail
			else
				jmail.AddRecipient recEmail,recName
			end if
			jmail.Subject            = subject
			jmail.HTMLBody           = body
			jmail.MailServerUserName = MSUserName
			jmail.MailServerPassword = MSPassword
			result = jmail.Send(smtp)
			jmail.Close()
			set jmail = Nothing
			if err.number<>0 then
				err.clear()
				result = "邮件发送失败"
			end if
		case "cdonts"
		case "aspemail"
		end select
		sendEmailing = result
	end function
	public function sendMobileCode(byval mobile,byval smsType)
		dim mobileCode,smsTitle,smsText,sendResult,smsSendResult,funString,ip,userAgent
		funString = OW.getOWSString("sms")
		select case smsType
		case 1
			mobileCode = OW.random(6)
			smsText    = "发送注册会员短信验证码:"& mobileCode
		case 2
			mobileCode = OW.random(6)
			smsText    = "发送找回密码短信验证码:"& mobileCode
		case 3
			mobileCode = OW.random(6)
			smsText    = "发送绑定手机短信验证码:"& mobileCode
		case 11
			smsText    = "新订单提醒,会员:"& V("order_sms_username") &"("& V("order_sms_nickname") &"),订购商品:"& V("order_sms_goods_info")
		end select
		ip         = OW.getClientIP()
		userAgent  = OW.validClientDBData(OW.getClientAgent(),250)
		execute(funString)
		if smsSendResult=true then
			if OW.DB.isRecordExistsBySQL("SELECT * FROM "& DB_PRE &"mobile_sms_code WHERE mobile='"& mobile &"' AND sms_type="& smsType &" AND "& OW.DB.auxSQL &"") then
				call OW.DB.updateRecord(DB_PRE &"mobile_sms_code",array("sms_text:"& mobileCode,"sms_time:"& SYS_TIME),Array("mobile:"& mobile,"sms_type:"& smsType))
			else
				call OW.DB.addRecord(DB_PRE &"mobile_sms_code",array("site_id:"& SITE_ID,"operate_uid:"& UID,"sms_uid:"& UID,"sms_type:"& smsType ,"mobile:"& mobile,"sms_text:"& mobileCode,"sms_time:"& SYS_TIME,"status:0","verify_times:0"))
			end if
			sendResult     = 1
			sendMobileCode = true
		else
			sendResult     = 0
			sendMobileCode = false
			V("debug_text")= OW.validClientDBData(smsSendResult,250)
		end if
		call OW.DB.addRecord(DB_PRE &"mobile_sms_log",array("site_id:"& SITE_ID,"operate_uid:"& UID,"sms_uid:"& UID,"sms_type:"& smsType,"mobile:"& mobile,"sms_text:"& smsText,"send_result:"& sendResult,"send_time:"& SYS_TIME,"debug_text:"& V("debug_text"),"ip:"& ip,"useragent:"& userAgent))
	end function
	public function sendSystemMsg(byval operateUid,byval uid,byval msgType,byval msgTitle,byval msgContent)
		msgContent = OW.validDBData(msgContent,0)
		call OW.DB.addRecord(DB_PRE &"system_msg",array("site_id:"& SITE_ID,"operate_uid:"& operateUid,"uid:"& UID,"status:0","is_user_read:0","is_user_delete:0","msg_type:"& msgType,"msg_title:"& msgTitle,"msg_content:"& msgContent,"msg_time:"& SYS_TIME))
	end function
	public function timeDelay(byval sec)
		dim i,n
		n = sec * 1000000
		for i=0 to n
			i=i+1
		next
	end function
	public function updateConfigCache()
		dim rs
		if SITE_ID=1 then
			set rs = OW.DB.getRecordBySQL("SELECT site_id FROM "& DB_PRE &"sites")
			do while not rs.eof
				call OW.Cache.clearRamCache("ow.config."& OW.int(rs("site_id")))
				rs.movenext
			loop
			OW.DB.closeRs rs
		else
			call OW.Cache.clearRamCache(OW.configCacheName)
		end if
	end function
	public function updatePasswordDynamic(byval uid,byval dynamicPassword)
		uid = OW.int(uid)
		dim result
		if uid>0 then
			if OW.DB.execute("UPDATE "& DB_PRE &"member SET password_dynamic='"& dynamicPassword &"' WHERE uid="& uid &"") then
				result = true
			else
				result = false
			end if
		else
			result = false
		end if
		updatePasswordDynamic = result
	end function
	public function validVerifyCode()
		dim result,code,n,v
		result = false
		n = OW.left(OW.regReplace(OW.getForm("post","verifycode_name"),"[^0-9]",""),5)
		v = OW.left(OW.regReplace(OW.getForm("post","verifycode_value"),"[^0-9]",""),5)
		if n="" or v="" then
			result = false
		else
			n = "vfycode"& n
			code = OW.Session.getSession(n)
			if OW.isNul(code) then
				result = false
			else
				if code = v then
					result = true
				else
					result = false
				end if
			end if
		end if
		if n<>"" then call OW.Session.removeSession(n)
		validVerifyCode = result
	end function
	public function verifyIsMemberLogined()
		dim rs,sql,check,arr,timeDiff
		check = true
		UID     = OW.int(OW.Cookie.getCookie("uid"))
		USS_KEY = OW.left(OW.regReplace(OW.Cookie.getCookie("uss_key"),"[^0-9a-zA-Z]",""),32)
		if len(USS_KEY)<>32 then
			verifyIsMemberLogined = false
			exit function
		end if
		arr = OW.DB.getFieldValueBySQL("SELECT uss_key,datetime FROM "& DB_PRE &"ucenter_session WHERE uid="& UID &"")
		if arr(0)="" or arr(0)<>USS_KEY then
			verifyIsMemberLogined = false
			exit function
		end if
		timeDiff = OW.int(dateDiff("n",cdate(arr(1)),SYS_TIME))
		if timeDiff > OW.loginTimeout then
			verifyIsMemberLogined = false
			exit function
		end if
		set rs = OW.DB.getRecordBySQL("SELECT username,nickname,email,mobile,avatar,admin_group_id,group_id,special_group_id FROM "& DB_PRE &"member WHERE uid="& UID &" AND status=0")
		if rs.eof then
			check = false
		else
			USERNAME         = rs("username")
			NICKNAME         = rs("nickname")
			EMAIL            = rs("email")
			MOBILE           = rs("mobile")
			AVATAR           = OW.rs(rs("avatar"))
			GROUP_ID         = OW.int(rs("group_id"))
			SPECIAL_GROUP_ID = OW.int(rs("special_group_id"))
			ADMIN_GROUP_ID   = OW.int(rs("admin_group_id"))
			AVATAR           = OW.iif(OW.isNul(AVATAR),SITE_PATH &"ow-content/images/avatar.jpg",AVATAR)
			NICKNAME         = OW.iif(NICKNAME="",USERNAME,NICKNAME)
			if timeDiff > (OW.loginTimeout/30) then
				call memberCookiesSetting()
				call OW.DB.execute("UPDATE "& DB_PRE &"ucenter_session SET [datetime]='"& SYS_TIME &"' WHERE uid="& UID &"")
			end if
		end if
		OW.DB.closeRs rs
		LOGINED = check
	end function
	
end class

public function createContentPageUrl()
	dim pageUrl
	if ROOTPATH="" then
		if TYPEID<>"0-0-0-0-0-0-0-0" or ORDERBY<>"0-0" then
			pageUrl = OW.urlRewrite("c2t")
			pageUrl = replace(pageUrl,"{$typeid}",TYPEID)
			pageUrl = replace(pageUrl,"{$orderby}",ORDERBY)
		else
			pageUrl = OW.urlRewrite("c2")
		end if
		pageUrl = replace(pageUrl,"{$urlpath}",URLPATH)
	else
		if TYPEID<>"0-0-0-0-0-0-0-0" or ORDERBY<>"0-0" then
			pageUrl = OW.urlRewrite("c4t")
			pageUrl = replace(pageUrl,"{$typeid}",TYPEID)
			pageUrl = replace(pageUrl,"{$orderby}",ORDERBY)
		else
			pageUrl = OW.urlRewrite("c4")
		end if
		pageUrl = replace(replace(pageUrl,"{$rootpath}",ROOTPATH),"{$urlpath}",URLPATH)
	end if
	createContentPageUrl = pageUrl
end function
public function createTagsPageUrl(byval key)
	createTagsPageUrl = replace(OW.urlRewrite(key),"{$tag}",OW.URLEncode(TAG))
end function
sub OpenWBSClose()
	set OW = Nothing
	set OS = Nothing
	err.clear
	response.end()
end sub
dim Tpl
set Tpl = new Tpl_Class
Class Tpl_Class
	public html,tplFile,indexTpl,cateTpl,contentTpl
	public redirectURL,page,tplCacheFile,htmlCacheFile,htmlFilename
	public isBizUser,isContentExist,isContentDetail,isGoodsDetail,isShopCart
	public echoRunInfo
	private match,matches,oAttrDict,oCateData,oDictArray,oFMatche,oFMatches,oReg,oRs,oVar
	private aContentCateArray,aGoodsCateArray,sTempString,aDataArray,aTempArray,iDataCount,iL,iIsGoodsTag
	private sLoopPre,sLoopStr,sLoopSuf,sLoopSQL,sDBTable
	private sFields,sSQL,sWhere
	private sRule,sRule2,sRule3,sLabelRule,sFieldRule,oAttrs
	private sPreHtml,sSufHtml,sLoopHtml,sLoops,sLoopTotal
	private sField,sFName,sFAttr
	private sIf,sThen,sThen1,sElse1,sElseIf,sElseIfThen
	private ifFlag,elseIfFlag,resultStr,elseIfArr,elseIfSubArr,elseIfArrLen,elseIfLen
	private sub class_initialize()
		echoRunInfo        = false
		set oReg           = new regexp
		oReg.ignoreCase    = true
		oReg.global        = true
		set oCateData      = server.createObject(OW.dictName)
		set oDictArray     = server.createObject(OW.dictName)
		set oVar           = server.createObject(OW.dictName)
	end sub
	private sub class_terminate()
		set oCateData  = nothing
		set oDictArray = nothing
		set oReg       = nothing
		set oVar       = nothing
	end sub
	public function display()
		response.write html
	end function
	public function dimVar(byval var)
		dim s
		if oVar(var)<>1 then
			oVar(var)=1
			s = textToAsp("dim "& var &"")
		end if
		dimVar = s
	end function
	public function executeTpl(byval htmlStr)
		'on error resume next
		if DEBUG_TIME then echo "<br>start : executeTpl : "& OW.runTime &"<br>"
		dim asps,code,arr,i,j,pos,s
		s = htmlStr
		oReg.pattern= "<"&"%(.+?)%"&">"
		set matches = oReg.execute(s)
		if matches.count>0 then
			redim arr(matches.count*2)
			i   = 0
			pos = 1
			for each match in matches
				if match.firstIndex+1-pos > 0 then
					arr(i) = "code = code & mid(html,"& pos &","& match.firstindex+1-pos &")"
					i = i+1
				end if
				pos = match.firstindex+1+match.length
				if left(match.submatches(0),1)="=" then
					arr(i) = "code = code & "& mid(match.submatches(0),2)
				else
					arr(i) = match.submatches(0)
				end if
				i=i+1
			next
			arr(i)="code = code & mid(html,"&pos&")"
			redim preserve arr(i)
			asps = join(arr,vbcrlf)
		else
			asps = "code = code & html"
		end if
		set matches = nothing
		'echo asps &"<br>"
		if DEBUG_TIME then echo "<br>start : executeTpl : execute asps : "& OW.runTime &"<br>"
		execute asps
		if err then
			'echo asps
			OW.Error.Msg = "OW.executeTpl"
			OW.Error.Raise 29
			err.clear
		else
			html = code
			call parseBase()
			if OW.config("gzip_open")=1 then html = gzip(html)
		end if
		if DEBUG_TIME then echo "<br>end : executeTpl : execute asps : "& OW.runTime &"<br>"
	end function

	private function parseAttr(byval str)
		dim m,ms,dic
		set dic = server.createObject(OW.dictName)
		set ms  = OW.getMatch(str,"(.+?)=\""(.+?)\""")
		for each m in ms
			'echo "dic("& trim(m.subMatches(0)) &"):"& trim(m.subMatches(1)) &"<br>"
			dic(trim(m.subMatches(0))) = trim(m.subMatches(1))
		next
		set ms = nothing
		set parseAttr = dic
		set dic = nothing
	end function
	public sub parseHTML()
		if DEBUG_TIME then echo "<br>before : parseHTML : "& OW.runTime &"<br>"
		dim isCreateHtml,isSaveHtmlCache
		isCreateHtml    = true
		isSaveHtmlCache = false
		if OS.authorized() then Tpl.isBizUser = true else Tpl.isBizUser = false
		if redirectURL<>"" then
			call redirect(redirectURL)
			exit sub
		end if
		if OW.config("run_mode")=2 and not(OW.isNul(htmlFilename)) then
			call redirect(htmlFilename)
			exit sub
		end if
		if OW.config("html_cache_open") and not(OW.isNul(htmlCacheFile))then
			if OW.Cache.htmlCacheValid(htmlCacheFile) then
				html = OW.Cache.getHtmlCache(htmlCacheFile)
				isCreateHtml = false
			else
				isSaveHtmlCache = true
			end if
		end if
		if isCreateHtml then
			if OW.config("cache_open") and not(OW.isNul(tplCacheFile)) then
				if OW.Cache.tplCacheValid(tplCacheFile) then
					html = OW.Cache.getTplCache(tplCacheFile) 
				else
					call parseTplHTML()
					call OW.Cache.saveTplCache(tplCacheFile,html)
				end if
				call executeTpl(html)
			else
				call parseTplHTML()
				call executeTpl(html)
			end if
			if isSaveHtmlCache then
				call OW.Cache.saveHtmlCache(htmlCacheFile,html)
			end if
		end if
		if not(Tpl.isBizUser) then
		oReg.pattern = OW.Base64.decode("PC9ib2R5PihbXHNcU10rPyk8L2h0bWw+")
		html = oReg.replace(html,OW.Base64.decode(getOWStr))
		end if
		if OW.config("cache_open")=1 or OW.config("html_cache_open")=1 then
			html = OW.rep(html,"{\$logined}",lcase(LOGINED))
		end if
		call Tpl.parseRunInfo()
	end sub
	
	'解析头和尾
	public function parseInclude()
		oReg.pattern = "<!-- *?#include +?(file|virtual) *?= *?""??([^"":?*\f\n\r\t\v]+?)""?? *?-->"
		set matches = oReg.execute(html)
		if matches.count>0 then
			for each match in matches
				html = OW.rep(html,match.value,OW.read(OS.tplHtmlPath & match.subMatches(1)))
			next
			call parseInclude()
		end if
	end function
	
	'**解析**全局
	public function parseGlobal()
		dim s,jss
		'echo OW.config("html_cache_open")&"<br>"
		if OW.isMobile then
			jss = "mobile"
		else
			jss = "pc"
		end if
		s = s &"<script type=""text/javascript"">"&vbCrLf
		s = s &"OW.debug    = <"&"%=lcase(DEBUG)%"&">;"&vbCrLf
		s = s &"OW.runMode  = <"&"%=OW.config(""run_mode"")%"&">;"&vbCrLf
		s = s &"OW.cacheOpen     = <"&"%=lcase(OW.cbool(OW.config(""cache_open"")))%"&">;"&vbCrLf
		s = s &"OW.htmlCacheOpen = <"&"%=lcase(OW.cbool(OW.config(""html_cache_open"")))%"&">;"&vbCrLf
		s = s &"OW.logined  = "& OW.iif(OW.config("html_cache_open")=1,"{$logined}","<"&"%=lcase(LOGINED)%"&">;")&vbCrLf
		s = s &"OW.sitePath = ""<"&"%=SITE_PATH%"&">"";"&vbCrLf
		s = s &"OW.siteUrl  = ""<"&"%=SITE_URL%"&">"";"&vbCrLf
		s = s &"OW.siteHurl = ""<"&"%=SITE_HURL%"&">"";"&vbCrLf
		s = s &"OW.siteHtmlFileSuffix = ""<"&"%=SITE_HTML_FILE_SUFFIX%"&">"";"&vbCrLf
		s = s &"OW.ucenterHurl = ""<"&"%=UCENTER_HURL%"&">"";"&vbCrLf
		s = s &"OW.searchUrl = ""<"&"%=OW.urlRewrite(""search"")%"&">"";"&vbCrLf
		s = s &"OW.loginUrl  = ""<"&"%=OW.urlRewrite(""l1"")%"&">"";"&vbCrLf
		s = s &"OW.logoutUrl = ""<"&"%=OW.urlRewrite(""l2"")%"&">"";"&vbCrLf
		s = s &"OW.regUrl    = ""<"&"%=OW.urlRewrite(""l3"")%"&">"";"&vbCrLf
		s = s &"OW.forgetPasswordUrl = ""<"&"%=OW.urlRewrite(""l4"")%"&">"";"&vbCrLf
		s = s &"OW.c1t = ""<"&"%=OW.urlRewrite(""c1t"")%"&">"";"&vbCrLf
		s = s &"OW.c2t = ""<"&"%=OW.urlRewrite(""c2t"")%"&">"";"&vbCrLf
		s = s &"OW.c3t = ""<"&"%=OW.urlRewrite(""c3t"")%"&">"";"&vbCrLf
		s = s &"OW.c4t = ""<"&"%=OW.urlRewrite(""c4t"")%"&">"";"&vbCrLf
		s = s &"OW.moneySb   = ""<"&"%=OW.config(""money_sb"")%"&">"";"&vbCrLf
		s = s &"OW.ctl       = ""<"&"%=CTL%"&">"";"&vbCrLf
		s = s &"OW.rootpath  = ""<"&"%=ROOTPATH%"&">"";"&vbCrLf
		s = s &"OW.urlpath   = ""<"&"%=URLPATH%"&">"";"&vbCrLf
		s = s &"OW.page      = ""<"&"%=OW.int(OW.getForm(""get"",""page""))%"&">"";"&vbCrLf
		s = s &"OW.typeid    = ""<"&"%=TYPEID%"&">"";"&vbCrLf
		s = s &"OW.orderby   = ""<"&"%=ORDERBY%"&">"";"&vbCrLf
		s = s &"OW.time      = ""<"&"%=SYS_TIME%"&">"";"&vbCrLf
		s = s &"OW.timer     = ""<"&"%=Timer()%"&">"";"&vbCrLf
		s = s &"OW.cookie.cookiePre    = ""<"&"%=COOKIE_PRE%"&">"";"&vbCrLf
		s = s &"OW.cookie.cookieDomain = ""<"&"%=COOKIE_DOMAIN%"&">"";"&vbCrLf
		s = s &"OW.cookie.cookiePath   = ""<"&"%=COOKIE_PATH%"&">"";"&vbCrLf
		s = s &"OW.gid      = ""<"&"%=V(""gid"")%"&">"";"&vbCrLf
		s = s &"OW.pid      = ""<"&"%=V(""pid"")%"&">"";"&vbCrLf
		s = s &"OW.shoppingIsNeedLogin = <"&"%=OW.int(OW.config(""shopping_is_need_login""))%"&">;"&vbCrLf
		s = s &"OW.cartUrl  = ""<"&"%=OW.urlRewrite(""ct"")%"&">"";"&vbCrLf
		s = s &"OW.orderUrl = ""<"&"%=OW.urlRewrite(""order"")%"&">"";"&vbCrLf
		s = s &"</script>"
		html = OW.rep(html,"{\$ow.js.cfg}",s)
		s = "<script type=""text/javascript"" src=""../../../../ow-content/js/"& jss &"/com.js""></script>"&vbCrLf & s
		s = "<script type=""text/javascript"" src=""../../../../ow-content/js/"& jss &"/ow.js""></script>"&vbCrLf & s
		s = "<script type=""text/javascript"" src=""../../../../ow-content/js/"& jss &"/jquery.js""></script>"& vbCrLf & s
		html = OW.rep(html,"{\$ow.js.config}",s)
		html = OW.rep(html,"{\$version}","<"&"%=OW_VERSION%"&">")
		html = OW.rep(html,"{\$debug}","<"&"%=lcase(DEBUG)%"&">")
		html = OW.rep(html,"{\$moneysb}","<"&"%=OW.config(""money_sb"")%"&">")
		html = OW.rep(html,"{\$admin_url}","<"&"%=SITE_URL &""ow-admin/""%"&">")
		html = OW.rep(html,"{\$ucenter_url}","<"&"%=SITE_URL &""ow-ucenter/""%"&">")
		html = OW.rep(html,"{\$site_id}","<"&"%=SITE_ID%"&">")
		html = OW.rep(html,"{\$site_domain}","<"&"%=SITE_DOMAIN%"&">")
		html = OW.rep(html,"{\$site_path}","<"&"%=SITE_PATH%"&">")
		html = OW.rep(html,"{\$site_url}","<"&"%=SITE_URL%"&">")
		html = OW.rep(html,"{\$site_hurl}","<"&"%=SITE_HURL%"&">")
		html = OW.rep(html,"{\$site_name}","<"&"%=SITE_NAME%"&">")
		html = OW.rep(html,"{\$site_mini_name}","<"&"%=SITE_MINI_NAME%"&">")
		html = OW.rep(html,"{\$site_html_file_suffix}","<"&"%=SITE_HTML_FILE_SUFFIX%"&">")
		html = OW.rep(html,"{\$tpl_path}","<"&"%=OS.tplPath%"&">")
		html = OW.rep(html,"{\$shop_url}","<"&"%=OW.urlRewrite(""s1"")%"&">")
		html = OW.rep(html,"{\$shop_name}","<"&"%=OW.config(""shop_name"")%"&">")
		html = OW.rep(html,"{\$shop_brand_url}","<"&"%=OW.urlRewrite(""b1"")%"&">")
		html = OW.rep(html,"{\$shop_cart_url}","<"&"%=OW.urlRewrite(""ct"")%"&">")
		html = OW.rep(html,"{\$shop_order_url}","<"&"%=OW.urlRewrite(""order"")%"&">")
		if not(OW.config("html_cache_open")=1) then
		html = OW.rep(html,"{\$logined}","<"&"%=lcase(LOGINED)%"&">")
		end if
		html = OW.rep(html,"{\$uid}","<"&"%=UID%"&">")
		html = OW.rep(html,"{\$username}","<"&"%=USERNAME%"&">")
		html = OW.rep(html,"{\$title}","<"&"%=V(""seo_title"")%"&">")
		html = OW.rep(html,"{\$keywords}","<"&"%=V(""keywords"")%"&">")
		html = OW.rep(html,"{\$description}","<"&"%=V(""description"")%"&">")
		html = OW.rep(html,"{\$breadcrumb}","<"&"%=Tpl.getBreadcrumb()%"&">")
		html = OW.rep(html,"{\$login_url}","<"&"%=OW.urlRewrite(""l1"")%"&">")
		html = OW.rep(html,"{\$logout_url}","<"&"%=OW.urlRewrite(""l2"")%"&">")
		html = OW.rep(html,"{\$reg_url}","<"&"%=OW.urlRewrite(""l3"")%"&">")
		html = OW.rep(html,"{\$forget_password_url}","<"&"%=OW.urlRewrite(""l4"")%"&">")
		html = OW.rep(html,"{\$error404_url}","<"&"%=OW.urlRewrite(""e1"")%"&">")
		
		html = OW.rep(html,"{\$icp}","<"&"%=OW.config(""icp"")%"&">")
		html = OW.rep(html,"{\$statistics}","<"&"%=OW.dbDataDecode(OW.config(""statistics""))%"&">")
		html = OW.rep(html,"{\$notice}","<"&"%=OW.dbDataDecode(OW.config(""notice""))%"&">")
		
		html = OW.rep(html,"{\$service_online_open}","<"&"%=OW.config(""service_online_open"")%"&">")
		html = OW.rep(html,"{\$service_online}","<"&"%=OW.dbDataDecode(OW.config(""service_online""))%"&">")
		html = OW.rep(html,"{\$kefu_open}","<"&"%=OW.config(""kefu_open"")%"&">")
		html = OW.rep(html,"{\$kefu}","<"&"%=OW.dbDataDecode(OW.config(""kefu""))%"&">")
		html = OW.rep(html,"{\$search_keyword}","<"&"%=V(""keyword"")%"&">")
		html = OW.rep(html,"{\$search_keywords}","<"&"%=Tpl.searchKeywords(0)%"&">")
		html = OW.rep(html,"{\$search_goods_keywords}","<"&"%=Tpl.searchKeywords(1)%"&">")
		oReg.pattern = "{\$config\(([a-zA-Z0-9_]*)\)}"
		html         = oReg.replace(html,"<"&"%=OW.config(""$1"")%"&">")
		html = replace(html,"../../../../","<"&"%=SITE_PATH%"&">")
		html = replace(html,"../","<"&"%=SITE_PATH&OS.tplPath%"&">")
	end function
	public function parseBase()
		html = OW.rep(html,"{\$shop_brand_url}",OW.urlRewrite("b1"))
		html = OW.rep(html,"{\$site_domain}",SITE_DOMAIN)
		html = OW.rep(html,"{\$site_path}",SITE_PATH)
		html = OW.rep(html,"{\$site_url}",SITE_URL)
		html = OW.rep(html,"{\$site_hurl}",SITE_HURL)
		html = OW.rep(html,"{\$site_html_file_suffix}",SITE_HTML_FILE_SUFFIX)
	end function
	public function parseAd()
		dim id,m,ms,s,tmpCode,typ
		oReg.pattern = "{ad([\s\S]*?)}"
		set matches  = oReg.execute(html)
		for each match in matches
			s = match.subMatches(0)
			set ms = OW.getMatch(s,"<"&"%=([\s\S]*?)%"&">")
			if ms.count>0 then
				for each m in ms
					tmpCode = """& "& trim(m.subMatches(0)) &" &"""
					tmpCode = replace(tmpCode,"""","&quot;")
					s = replace(s,m.value,tmpCode)
				next
			end if
			set ms = nothing
			
			set ms = OW.getMatch(s,"id=""([\s\S]+?)""")
			if ms.count>0 then
				for each m in ms
					id = trim(m.subMatches(0))
					id = replace(id,"&quot;","""")
				next
			end if
			set ms = nothing
			
			set ms = OW.getMatch(s,"type=""([\s\S]+?)""")
			if ms.count>0 then
				for each m in ms
					typ = trim(m.subMatches(0))
				next
			end if
			set ms = nothing
			html = OW.reps(html,match.value,"<"&"%=Tpl.ad("""& id &""","""& typ &""")%"&">")
		next
		set matches  = nothing
	end function
	public function parseForm()
		dim code
		set matches = OW.getMatch(html,"{\$form_post_html id=""(.+?)""}")
		if matches.count>0 then
			for each match in matches
				html = OW.rep(html,replace(match.value,"$","\$"),textToAsp("=Client.formPostHtml("& OW.int(match.subMatches(0)) &")"))
			next
		end if
		set matches = nothing
		set matches = OW.getMatch(html,"{\$form_list_html id=""(.+?)""}")
		if matches.count>0 then
			for each match in matches
				html = OW.rep(html,replace(match.value,"$","\$"),textToAsp("=Client.formListHtml("& OW.int(match.subMatches(0)) &")"))
			next
		end if
		set matches = nothing
	end function
	public function parseIf()
		oReg.pattern = "{if:(.+?)}"
		html         = oReg.replace(html,textToAsp("if $1 then"))
		oReg.pattern = "{elseif:(.+?)}"
		html         = oReg.replace(html,textToAsp("elseif $1 then"))
		oReg.pattern = "{else}"
		html         = oReg.replace(html,textToAsp("else"))
		oReg.pattern = "{/if}"
		html         = oReg.replace(html,textToAsp("end if"))
	end function
	public function parseLabel()
		dim content,labelType,name,rs
		set matches = OW.getMatch(html,"{ow:([\s\S]+?)}")
		if matches.count>0 then
			for each match in matches
				name = match.subMatches(0)
				set rs = OW.DB.getRecordBySQL("SELECT type,content FROM "& DB_PRE &"label WHERE name='"& name &"'")
				if not rs.eof then
					labelType    = OW.int(rs("type"))
					content      = rs("content")
				end if
				OW.DB.closeRs rs
				if labelType=2 then
					html = replace(html,match.value,OW.editorContentClientDecode(content))
				else
					html = replace(html,match.value,"<"&"%=OW.editorContentClientDecode(OW.DB.getFieldValueBySQL(""SELECT content FROM "& DB_PRE &"label WHERE status=0 AND name='"& name &"' AND "& OW.DB.auxSQL &"""))%"&">")
				end if
			next
		end if
		set matches = nothing
	end function
	public function parseDBLoop()
		dim code,isPage,m,ms,pagesize,pagetype,pageUrl,rs,rsi,rsN,rsV,rsFieldsCount,allStr,tmpStr,linkCode,cTitleCode
		dim fieldName
		sLabelRule   = "\{([a-zA-Z0-9_]*)\s+(.+?)\}([\s\S]*?)\{/\1}"
		oReg.pattern = sLabelRule
		set matches  = oReg.execute(html)
		if matches.count>0 then
		for each match in matches
			rs = match.subMatches(0)
			rsi= rs &"_i"
			rsN= rs &"_n"
			rsV= rs &"_V"
			rsFieldsCount = rs &"_fieldsCount"
			call parseMatchAttr(match.subMatches(1),rs)
			call parseMatchLoop(match.subMatches(2),rs)
			sLoopPre = replace(sLoopPre,"["& rs &":count]","<"&"%="& rs &".recordCount%"&">")
			select case sDBTable
			case OW.DB.Table.content,OW.DB.Table.goods
				linkCode   = "<"&"%=Tpl.contentLink(OW.rs("& rs &"(""rootpath"")),OW.rs("& rs &"(""urlpath"")),OW.rs("& rs &"(""url"")))%"&">"
				cTitleCode = "<"&"%=Tpl.ctitle(OW.rs("& rs &"(""title"")),OW.rs("& rs &"(""font_color"")),OW.rs("& rs &"(""font_weight"")))%"&">"
			case OW.DB.Table.category
				linkCode = "<"&"%=Tpl.cateLink(OW.rs("& rs &"(""model_type"")),OW.rs("& rs &"(""cate_type"")),OW.rs("& rs &"(""root_id"")),OW.rs("& rs &"(""rootpath"")),OW.rs("& rs &"(""urlpath"")))%"&">"
			case DB_PRE &"tags"
				linkCode = "<"&"%=replace(OW.urlRewrite("""& OW.iif(iIsGoodsTag,"gt1","t1") &"""),""{$tag}"",OW.tagEncode(OW.rs("& rs &"(""tag""))))%"&">"
			case DB_PRE &"brand"
				linkCode = "<"&"%=replace(OW.urlRewrite(""b2""),""{$urlpath}"",OW.rs("& rs &"(""urlpath"")))%"&">"
			case DB_PRE &"type_attr"
				linkCode   = "<"&"%=Tpl.typeLink("& rs &"(""type_cate_id""),"& rs &"(""type_attr_id""),0)%"&">"
			case DB_PRE &"type"
				linkCode   = "<"&"%=Tpl.typeLink("& rs &"(""type_cate_id""),"& rs &"(""type_attr_id""),"& rs &"(""type_id""))%"&">"
			case DB_PRE &"coupon"
				linkCode = "<"&"%=replace(OW.urlRewrite(""cp3""),""{$id}"",OW.rs("& rs &"(""coupon_id"")))%"&">"
			end select
			if rs="cpage" then
				linkCode = "<"&"%=Tpl.cpageLink(OW.rs("& rs &"(""urlpath"")))%"&">"
			end if
			set ms = OW.getMatch(sLoopSuf,"\["& rs &":pages([\s\S]*?)\]")
			if ms.count>0 then
				isPage = true
				for each m in ms
					set oAttrs = parseAttr(m.subMatches(0))
					pagesize   = OW.int(oAttrs("pagesize"))
					pagetype   = OW.trim(oAttrs("pagetpl"))
				next
			else
				isPage = false
			end if
			code = ""
			code = code & dimVar(rs)
			code = code & dimVar(rsi)
			code = code & dimVar(rsV)
			code = code & textToAsp("set "& rsV &" = server.createObject(OW.dictName)")
			code = code & dimVar(rsFieldsCount)
			'**
			if isPage then
				if not(pagesize>0) then pagesize = 20
				select case CTL
				case "index"
					pageUrl = "OW.urlRewrite(""i2"")"
				case "content"
					pageUrl = "createContentPageUrl()"
				case "tags"
					pageUrl = "createTagsPageUrl(""t2"")"
				case "gtags"
					pageUrl = "createTagsPageUrl(""gt2"")"
				case "brand"
					pageUrl = "replace(OW.urlRewrite(""b3""),""{$urlpath}"",URLPATH)"
				case "coupon"
					pageUrl = "OW.urlRewrite(""cp2"")"
				case else
					pageUrl = "OW.urlRewrite(""i2"")"
				end select
				'**
				dim rsCurPage,rsCount,rsPageCount
				rsCurPage   = rs &"CurPage"
				rsCount     = rs &"RsCount"
				rsPageCount = rs &"PageCount"
				code = code & dimVar(rsCurPage)
				code = code & dimVar(rsCount)
				code = code & dimVar(rsPageCount)
				'**
				code = code & textToAsp("set "& rs &" = OW.DB.getRecordBySQL("""& sLoopSQL &""")")
				code = code & sLoopPre
				code = code & textToAsp(""& rsFieldsCount &" = "& rs &".fields.count-1")
				code = code & textToAsp("if not "& rs &".eof then")
				code = code & textToAsp("if "& rs &".recordCount>1 then "& rsCount &" = "& rs &".recordCount else "& rsCount &" = 0")
				code = code & textToAsp(""& rs &".pageSize = "& pagesize &"")
				code = code & textToAsp(""& rsCurPage &" = OW.int(OW.getForm(""get"",""page""))")
				code = code & textToAsp("if "& rsCurPage &">0 then : if "& rsCurPage &" > "& rs &".pageCount then "& rs &".absolutePage = "& rs &".pageCount else "& rs &".absolutePage = "& rsCurPage &" : end if")
				code = code & textToAsp(""& rsCurPage &" = "& rs &".absolutePage")
				code = code & textToAsp(""& rsPageCount &" = "& rs &".pageCount")
				code = code & textToAsp("for "& rsi &"=1 to "& pagesize &"")
				code = code & textToAsp("if "& rs &".eof then exit for")
				code = code & textToAsp("for "& rsN &"=0 to "& rsFieldsCount &"")
				code = code & textToAsp("FIELD_NAME = Tpl.vfield("& rs &".fields("& rsN &").name)")
				code = code & textToAsp(""& rsV &"(FIELD_NAME) = OW.rs("& rs &"("& rs &".fields("& rsN &").name))")
				code = code & textToAsp("next")
				'**
				'**字段解析
				set ms = OW.getMatch(sLoopStr,"\["& rs &":(.+?)\]")
				if ms.count>0 then
					for each m in ms
						fieldName = m.subMatches(0)
						select case fieldName
						case "i"
							sLoopStr = replace(sLoopStr,m.value,textToAsp("="& rsi))
						case "link"
							sLoopStr = replace(sLoopStr,m.value,linkCode)
						case "ctitle"
							sLoopStr = replace(sLoopStr,m.value,cTitleCode)
						case else
							sLoopStr = replace(sLoopStr,m.value,textToAsp("=OW.rs("& rsV &"("""& fieldName &"""))"))
						end select
					next
				end if
				code = code & sLoopStr
				'**
			    code = code & textToAsp(""& rs &".movenext")
				code = code & textToAsp("next")
				code = code & textToAsp("end if")
				code = code & textToAsp("OW.DB.closeRs "& rs &"")&vbCrLf
				code = code & textToAsp("set "& rsV &" = nothing")
				if CTL="search" then
					code = code & OW.rep(sLoopSuf,"\["& rs &":pages([\s\S]*?)\]",textToAsp("=Tpl.createPages(Tpl.searchPageLink(IS_SHOP,KEYWORD),"& rsCurPage &","& rsCount &","& rsPageCount &","& pagesize &","""& pagetype &""")"))
				else
					code = code & OW.rep(sLoopSuf,"\["& rs &":pages([\s\S]*?)\]",textToAsp("=Tpl.createPages("& pageUrl &","& rsCurPage &","& rsCount &","& rsPageCount &","& pagesize &","""& pagetype &""")"))
				end if
				'**
				allStr = code
			else
				code = code & textToAsp(rsi &" = 0")
				code = code & textToAsp("set "& rs &" = OW.DB.getRecordBySQL("""& sLoopSQL &""")")
				code = code & sLoopPre
				code = code & textToAsp(""& rsFieldsCount &" = "& rs &".fields.count-1")
				code = code & textToAsp("do while not "& rs &".eof")
				code = code & textToAsp(rsi &" = "& rsi &"+1")
				code = code & textToAsp("for "& rsN &"=0 to "& rsFieldsCount &"")
				code = code & textToAsp("FIELD_NAME = Tpl.vfield("& rs &".fields("& rsN &").name)")
				code = code & textToAsp(""& rsV &"(FIELD_NAME) = OW.rs("& rs &"("& rs &".fields("& rsN &").name))")
				code = code & textToAsp("next")
				'**字段解析
				set ms = OW.getMatch(sLoopStr,"\["& rs &":(.+?)\]")
				if ms.count>0 then
					for each m in ms
						fieldName = m.subMatches(0)
						select case fieldName
						case "i"
							sLoopStr = replace(sLoopStr,m.value,textToAsp("="& rsi))
						case "link"
							sLoopStr = replace(sLoopStr,m.value,linkCode)
						case "ctitle"
							sLoopStr = replace(sLoopStr,m.value,cTitleCode)
						case else
							sLoopStr = replace(sLoopStr,m.value,textToAsp("=OW.rs("& rsV &"("""& fieldName &"""))"))
						end select
					next
				end if
				code = code & sLoopStr
				'**
				code = code & textToAsp(""& rs &".movenext")
				code = code & textToAsp("loop")
				code = code & textToAsp("OW.DB.closeRs "& rs &"")&vbCrLf
				code = code & textToAsp("set "& rsV &" = nothing")
				code = code & sLoopSuf
				allStr = code
			end if
			html = replace(html,match.value,allStr)
		next
		end if
		set matches = nothing
	end function
	
	private function getOWStr()
		dim sb,str : set sb = OW.stringBuilder()
		sb.append "PGRpdiBjbGFzcz0ib3doaWRzIj5Qb3dlcmVkIGJ"
		sb.append "5IDxhIGhyZWY9Imh0dHA6Ly93d3cub3Blbndicy5jb20v"
		sb.append "Ij5PcGVuV0JTPC9hPjwvZGl2PjxzdHlsZT4ub3doaWRze2"
		sb.append "Rpc3BsYXk6bm9uZTt9PC9zdHlsZT48L2JvZHk+PC9odG1sPg"
		str = sb.toString() : set sb = nothing
		getOWStr = str
	end function
	
	private function parseMatchAttr(byval s,byval rs)
		dim arr,i,sql,top,field,modelField,table,modelJoin,modelTable,tableJoin,innerJoin,where,listByType,orderby,keyword,keywords
		dim topNum,m,ms,fieldName,fieldValue,tmpCode
		dim cateId,position,tag
		i = 0
		set ms = OW.getMatch(s,"<"&"%=([\s\S]*?)%"&">")
		if ms.count>0 then
			for each m in ms
				tmpCode = """& "& trim(m.subMatches(0)) &" &"""
				tmpCode = replace(tmpCode,"""","&quot;")
				s = replace(s,m.value,tmpCode)
			next
		end if
		set ms = nothing
		set ms = OW.getMatch(s,"table=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				table = replace(trim(replace(trim(m.subMatches(0)),"db_content",OW.DB.Table.content)),"db_",DB_PRE)
				s = replace(s,m.value,"")
			next
		end if
		set ms = nothing
		set ms = OW.getMatch(s,"orderby=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				orderby = "ORDER BY "& trim(m.subMatches(0)) &""
				orderby = replace(orderby,"&quot;","""")
				s = replace(s,m.value,"")
			next
		end if
		if left(rs,3)="nav" then
			table   = DB_PRE &"navigator"
			orderby = OW.iif(orderby<>"",orderby,"ORDER BY a.sequence")
		elseif left(rs,4)="cate" then
			table   = OW.DB.Table.category
			orderby = OW.iif(orderby<>"",orderby,"ORDER BY a.sequence")
		elseif left(rs,7)="content" then
			table   = OW.DB.Table.content
			orderby = OW.iif(orderby<>"",orderby,"ORDER BY a.sequence")
		elseif rs="cpage" then
		    '单页
			table   = OW.DB.Table.category
			orderby = OW.iif(orderby<>"",orderby,"ORDER BY a.sequence")
		elseif rs="tag" then
			table   = DB_PRE &"tags"
			orderby = OW.iif(orderby<>"",orderby,"ORDER BY a.sequence")
		elseif left(rs,5)="goods" then
			table   = OW.DB.Table.goods
			orderby = OW.iif(orderby<>"",orderby,"ORDER BY a.sequence")
		elseif rs="consultation" then
			table   = DB_PRE &"consultation"
			orderby = OW.iif(orderby<>"",orderby,"ORDER BY a.sequence")
		elseif rs="typeattr" then
			table   = DB_PRE &"type_attr"
			orderby = OW.iif(orderby<>"",orderby,"ORDER BY a.sequence")
		elseif rs="ctype" then
			table   = DB_PRE &"type"
			orderby = OW.iif(orderby<>"",orderby,"ORDER BY a.sequence")
		else
			table = OW.iif(table<>"",table,DB_PRE & rs)
		end if
		sDBTable = table
		'**直接写sql
		set ms = OW.getMatch(s,"sql=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				sql = trim(m.subMatches(0))
				sql = replace(sql,"db_",DB_PRE)
				sql = replace(sql,DB_PRE &"content",OW.DB.Table.content)
				sql = replace(sql,"&quot;","""")
				sLoopSQL = sql
				exit function
			next
		end if
		set ms = nothing'**top条记录
		set ms = OW.getMatch(s,"top=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				topNum = OW.int(trim(m.subMatches(0)))
				s = replace(s,m.value,"")
			next
		end if
		set ms = nothing
		if topNum>0 then top = "top "& topNum &""'**数据字段
		set ms = OW.getMatch(s,"field=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				field = replace(trim(m.subMatches(0)),"db_",DB_PRE)
				s = replace(s,m.value,"")
			next
		end if
		set ms = nothing
		if field="" then field = "*"'**联合表
		set ms = OW.getMatch(s,"model=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				if table = OW.DB.Table.content or table = OW.DB.Table.category then
					modelTable = OW.DB.Table.contentModelPre & trim(m.subMatches(0))
					modelJoin  = " INNER JOIN "& modelTable &" ON a.cid="& modelTable &".cid "
				elseif table = OW.DB.Table.goods then
					modelTable = OW.DB.Table.goodsModelPre & trim(m.subMatches(0))
					modelJoin  = " INNER JOIN "& modelTable &" ON a.gid="& modelTable &".gid "
				end if
				s = replace(s,m.value,"")
			next
		end if
		set ms = nothing'**tableJoin
		set ms = OW.getMatch(s,"table_join=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				tableJoin = " "& replace(replace(trim(m.subMatches(0)),"db_content",OW.DB.Table.content),"db_",DB_PRE) &" "
				s = replace(s,m.value,"")
			next
		end if
		set ms = nothing'**innerJoin
		if rs = "cpage" then
			innerJoin = " INNER JOIN "& OW.DB.Table.content &" c ON a.cate_id=c.cate_id "
			modelJoin = replace(modelJoin,"a.","c.")
		end if
		'**条件字段position_id
		set ms = OW.getMatch(s,"position_id=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				if table = OW.DB.Table.content then
					position = " INNER JOIN "& DB_PRE &"position_data ON ("& DB_PRE &"position_data.site_id="& SITE_ID &" AND "& DB_PRE &"position_data.status=0 AND "& DB_PRE &"position_data.pos_id="& m.subMatches(0) &" AND "& DB_PRE &"position_data.cid=a.cid) "
					orderby  = " ORDER BY "& DB_PRE &"position_data.sequence "
				elseif table = OW.DB.Table.goods then
					position = " INNER JOIN "& DB_PRE &"position_data ON ("& DB_PRE &"position_data.site_id="& SITE_ID &" AND "& DB_PRE &"position_data.status=0 AND "& DB_PRE &"position_data.pos_id="& m.subMatches(0) &" AND "& DB_PRE &"position_data.gid=a.gid) "
					orderby  = " ORDER BY "& DB_PRE &"position_data.sequence "
				end if
				s = replace(s,m.value,"")
			next
		end if
		set ms = nothing'**相关内容related_cid
		set ms = OW.getMatch(s,"related_cid=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				fieldValue = trim(m.subMatches(0))
				fieldValue = replace(fieldValue,"&quot;","""")
				position = " INNER JOIN "& DB_PRE &"content_related ON ("& DB_PRE &"content_related.site_id="& SITE_ID &" AND "& DB_PRE &"content_related.status=0 AND "& DB_PRE &"content_related.cid="& fieldValue &" AND "& DB_PRE &"content_related.related_cid=a.cid) "
				orderby  = " ORDER BY "& DB_PRE &"content_related.sequence ASC"
				s = replace(s,m.value,"")
			next
		end if
		set ms = nothing'**相关商品related_cid
		set ms = OW.getMatch(s,"related_gid=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				fieldValue = trim(m.subMatches(0))
				fieldValue = replace(fieldValue,"&quot;","""")
				position = " INNER JOIN "& DB_PRE &"goods_related ON ("& DB_PRE &"goods_related.site_id="& SITE_ID &" AND "& DB_PRE &"goods_related.status=0 AND "& DB_PRE &"goods_related.gid="& fieldValue &" AND "& DB_PRE &"goods_related.related_gid=a.gid) "
				orderby  = " ORDER BY "& DB_PRE &"goods_related.sequence ASC"
				s = replace(s,m.value,"")
			next
		end if
		set ms = nothing'**tag_id
		set ms = OW.getMatch(s,"tag_id=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				fieldValue = trim(m.subMatches(0))
				fieldValue = replace(fieldValue,"&quot;","""")
				if table = OW.DB.Table.content then
					position = " INNER JOIN "& DB_PRE &"tags_data ON ("& DB_PRE &"tags_data.tag_id="& fieldValue &" AND "& DB_PRE &"tags_data.cid=a.cid) "
				elseif table = OW.DB.Table.goods then
					position = " INNER JOIN "& DB_PRE &"tags_data ON ("& DB_PRE &"tags_data.tag_id="& fieldValue &" AND "& DB_PRE &"tags_data.gid=a.gid) "
				end if
				s = replace(s,m.value,"")
			next
		end if
		set ms = nothing'**tags cid
		set ms = OW.getMatch(s,"cid=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				if table = DB_PRE &"tags" then
					iIsGoodsTag = false
					fieldValue  = trim(m.subMatches(0))
					fieldValue  = replace(fieldValue,"&quot;","""")
					sql = "SELECT tag FROM "& DB_PRE &"tags WHERE tag_id IN (SELECT tag_id FROM "& DB_PRE &"tags_data WHERE "& DB_PRE &"tags_data.cid="& fieldValue &" AND "& OW.DB.auxSQL &") AND "& OW.DB.auxSQL &""
					s = replace(s,m.value,"")
					sLoopSQL = sql
					exit function
				end if
			next
		end if
		set ms = nothing'**tags gid
		set ms = OW.getMatch(s,"gid=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				if table = DB_PRE &"tags" then
					iIsGoodsTag = true
					fieldValue  = trim(m.subMatches(0))
					fieldValue  = replace(fieldValue,"&quot;","""")
					sql = "SELECT tag FROM "& DB_PRE &"tags WHERE tag_id IN (SELECT tag_id FROM "& DB_PRE &"tags_data WHERE "& DB_PRE &"tags_data.gid="& fieldValue &" AND "& OW.DB.auxSQL &") AND "& OW.DB.auxSQL &""
					s = replace(s,m.value,"")
					sLoopSQL = sql
					exit function
				end if
			next
		end if
		set ms = nothing'**tags gid
		set ms = OW.getMatch(s,"is_shop=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				if table = DB_PRE &"tags" then
					fieldValue = OW.int(m.subMatches(0))
					if fieldValue=1 then
						iIsGoodsTag = true
					else
						iIsGoodsTag = false
					end if
				end if
			next
		end if
		set ms = nothing'**条件字段cate_id
		set ms = OW.getMatch(s,"([\s]{1})cate_id=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				cateId = trim(m.subMatches(1))
				cateId = replace(cateId,"&quot;","""")
				if instr(m.value,",")>0 then
					if table=OW.DB.Table.category then
						cateId = OW.int(cateId)
						cateId = " a.cate_id="& cateId &" AND"
					else
						cateId = " a.cate_id IN ("& cateId &") AND"
					end if
				else
					cateId = " a.cate_id IN (SELECT cate_id FROM "& OW.DB.Table.category &" WHERE path like '%,"& cateId &",%' AND "& OW.DB.auxSQL &") AND"
				end if
				s = replace(s,m.value,"")
			next
		end if
		set ms = nothing
		
		set ms = OW.getMatch(s,"list_by_type=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				listByType = trim(m.subMatches(0))
				listByType = replace(listByType,"&quot;","""")
				s = replace(s,m.value,"")
			next
		end if
		set ms = nothing
		'**keyword
		set ms = OW.getMatch(s,"keyword=""([\s\S]+?)""")
		if ms.count>0 then
			for each m in ms
				keyword = trim(m.subMatches(0))
				keyword = replace(keyword,"&quot;","""")
				if table = OW.DB.Table.content then
					keywords  = " (a.title like '%"& keyword &"%' OR a.subtitle like '%"& keyword &"%' OR a.summary like '%"& keyword &"%' ) AND "
				elseif table = OW.DB.Table.goods then
					keywords  = " (a.title like '%"& keyword &"%' OR a.subtitle like '%"& keyword &"%' OR a.summary like '%"& keyword &"%' ) AND "
				end if
				s = replace(s,m.value,"")
			next
		end if'**条件字段
		set ms = OW.getMatch(s,"([a-zA-Z0-9-_]*)=""([\s\S]+?)""")
		if ms.count>0 then
			if isArray(arr) then
				redim preserve arr(i+ms.count)
			else
				redim arr(ms.count)
			end if
			for each m in ms
				fieldName  = trim(m.subMatches(0))
				fieldValue = trim(m.subMatches(1))
				fieldValue = replace(fieldValue,"&quot;","""")
				arr(i) = fieldName &":"& fieldValue
				i = i+1
			next
		end if
		set ms = nothing'**
		if isArray(arr) then
			where = "WHERE "& OW.DB.valueToSQL(1,table,arr)
		else
			where = "WHERE "
		end if
		
		if OW.DB.isColumnExist(table,"site_id") then
			where = where & "a.site_id="& SITE_ID &" AND"
		end if
		
		if OW.DB.isColumnExist(table,"status") then
			where = where &" a.status=0 AND"
		end if
		
		if table = DB_PRE &"coupon" then
			select case OW.DB.dbType
			case 0
				V("datediff_s") = "'s'"
			case 1
				V("datediff_s") = "s"
			end select
			where = where &" a.coupon_type<>'c3' AND (a.is_get_timelimit=0 OR (a.is_get_timelimit=1 AND DATEDIFF("& V("datediff_s") &",'"& SYS_TIME &"',a.get_endtime)>0)) AND"
		end if
		
		where = where & cateId & listByType & keywords &" 1=1"'**
		if orderby="" then
			if OW.DB.isColumnExist(table,"sequence") then
				orderby = "ORDER BY sequence"
			end if
		end if'**
		if table = OW.DB.Table.category then
			sql = "SELECT "& top &" "& field &" FROM ["& table &"] a "& innerJoin & modelJoin & tableJoin & position &" "& where &" "& orderby &""
		else
			sql = "SELECT "& top &" "& field &" FROM ["& table &"] a "& modelJoin & innerJoin & tableJoin & position &" "& where &" "& orderby &""
		end if
		set ms = OW.getMatch(sql,"([\s]+?)JOIN([\s]+?)")
		if ms.count>=2 then
			oReg.pattern = "([\s\S]+?)FROM([\s\S]+?)JOIN([\s\S]+?)INNER([\s\S]+?)$"
			sql          = oReg.replace(sql,"$1FROM ($2JOIN$3) INNER$4")
		end if
		set ms = nothing
		sLoopSQL = sql
	end function
	
	public sub parseTplHTML()
		dim temps
		html = OW.read(tplFile)
		call Tpl.parseInclude()
		call Tpl.parseGlobal()
		html = OW.rep(html,"{\$title}","<"&"%=V(""seo_title"")%"&">")
		html = OW.rep(html,"{\$keywords}","<"&"%=V(""keywords"")%"&">")
		html = OW.rep(html,"{\$description}","<"&"%=V(""description"")%"&">")
		call Tpl.parsePage()
		call Tpl.parseTag()
		call Tpl.parseSearch()
		call Tpl.parseCate()
		call Tpl.parseContent()
		call Tpl.parseGoods()
		call Tpl.parseBrand()
		call Tpl.parseCoupon()
		call Tpl.parseOrder()
		call Tpl.parseLabel()
		call Tpl.parseLabel()
		call Tpl.parseDBLoop()
		call Tpl.parseDBLoop()
		call Tpl.parseDBLoop()
		call Tpl.parseDBLoop()
		call Tpl.parseAd()
		call Tpl.parseIf()
        if CTL="form" then
			html = OW.rep(html,"{\$form_id}","<"&"%=V(""form_id"")%"&">")
			html = OW.rep(html,"{\$form_title}","<"&"%=V(""title"")%"&">")
			html = OW.rep(html,"{\$form_post_html}","<"&"%=Client.formPostHtml(V(""form_id""))%"&">")
			html = OW.rep(html,"{\$form_list_html}","<"&"%=Client.formListHtml(V(""form_id""))%"&">")
		else
			call Tpl.parseForm()
		end if
		call Tpl.parseGlobal()
		oReg.pattern = "<"&"%([^%]+)<"&"%\=([^%]+)%"&">([^%]+)%"&">"
		html = oReg.replace(html,"<"&"%$1""& $2 &""$3%"&">")
		oReg.pattern = "<"&"%([^%]+)<"&"%\=([^%]+)%"&">([^%]+)<"&"%\=([^%]+)%"&">([^%]+)%"&">"
		html = oReg.replace(html,"<"&"%$1""& $2 &""$3""& $4 &""$5%"&">")
		if not(Tpl.isBizUser) then
		oReg.pattern = OW.Base64.decode("PHRpdGxlPihbXHNcU10rPyk8L3RpdGxlPg")
		html = oReg.replace(html,OW.Base64.decode("PHRpdGxlPiQxIC0gUG93ZXJlZCBieSBPcGVuV0JTPC90aXRsZT4"))
		end if
	end sub
	private function parseMatchLoop(byval s,byval labelTag)
		dim m,ms
		set ms = OW.getMatch(s,"^([\s\S]*?){"& labelTag &":loop}([\s\S]+?){/"& labelTag &":loop}([\s\S]*?)$")
		if ms.count>0 then
			for each m in ms
				sLoopPre = m.subMatches(0)
				sLoopStr = m.subMatches(1)
				sLoopSuf = m.subMatches(2)
			next
		else
			sLoopPre = ""
			sLoopStr = ""
			sLoopSuf = ""
		end if
	end function
	public function parsePage()
		oReg.pattern = "{\$page:(.+?)}"
		html         = oReg.replace(html,textToAsp("=V(""$1"")"))
	end function
	public function parseCate()
		oReg.pattern = "{\$cate:(.+?)}"
		html         = oReg.replace(html,textToAsp("=V(""$1"")"))
	end function
	public function parseContent()
		html         = OW.rep(html,"{\$content:prev}","<"&"%=Tpl.getPrevNextContent(V(""root_id""),V(""cid""),""prev"")%"&">")
		html         = OW.rep(html,"{\$content:next}","<"&"%=Tpl.getPrevNextContent(V(""root_id""),V(""cid""),""next"")%"&">")
		oReg.pattern = "{\$content:(.+?)}"
		html         = oReg.replace(html,textToAsp("=V(""$1"")"))
	end function
	public function parseSearch()
		oReg.pattern = "{\$search:(.+?)}"
		html         = oReg.replace(html,textToAsp("=V(""$1"")"))
	end function
	public function parseGoods()
		html         = OW.rep(html,"{\$goods:prev}","<"&"%=Tpl.getPrevNextGoods(V(""root_id""),V(""gid""),""prev"")%"&">")
		html         = OW.rep(html,"{\$goods:next}","<"&"%=Tpl.getPrevNextGoods(V(""root_id""),V(""gid""),""next"")%"&">")
		html         = OW.rep(html,"{\$goods:typeattr}","<"&"%=OS.SHOP.getGoodsTypeAttr(V(""gid""),V(""type_id""))%"&">")
		oReg.pattern = "{\$goods:(.+?)}"
		html         = oReg.replace(html,textToAsp("=V(""$1"")"))
	end function
	public function parseTag()
		oReg.pattern = "{\$tag:(.+?)}"
		html         = oReg.replace(html,textToAsp("=V(""$1"")"))
	end function
	public function parseOrder()
		oReg.pattern = "{\$order:(.+?)}"
		html         = oReg.replace(html,textToAsp("=V(""$1"")"))
	end function
	public function parseBrand()
		oReg.pattern = "{\$brand:(.+?)}"
		html         = oReg.replace(html,textToAsp("=V(""$1"")"))
	end function
	public function parseCoupon()
		oReg.pattern = "{\$coupon:(.+?)}"
		html         = oReg.replace(html,textToAsp("=V(""$1"")"))
	end function
	public sub parseRunInfo()
		html = OW.rep(html,"{\$sqlquerynum}",OW.DB.SQLQueryNum)
		html = OW.rep(html,"{\$runtime}",OW.runTime)
	end sub
	private function textToAsp(byval s)
		textToAsp = "<"&"%"& s &"%"&">"
	end function
	public sub runInit()
		V("breadcrumb") = "<a href="""& SITE_URL &""">"& OS.lang(1) &"</a>"
	end sub
	public sub runIndex()
		call runInit()
		V("seo_title")   = OW.config("site_title")
		V("keywords")    = OW.config("site_keywords")
		V("description") = OW.config("site_description")
		V("tpl")         = "index.html"
		tplFile          = OS.tplHtmlPath & V("tpl")
		tplCacheFile     = V("tpl")
		htmlCacheFile    = tplCacheFile
		call parseHTML()
	end sub
	public sub runLogReg()
		dim rs
		if CTL="login" then
			if LOGINED then redirect(SITE_URL &"ow-ucenter/")
			V("seo_title")   = "用户登陆"
			V("keywords")    = "用户登陆，会员登陆"
			V("description") = "用户登陆页面，会员登陆页面"
			V("tpl")         = "login.html"
			tplFile          = OS.tplHtmlPath & V("tpl")
			tplCacheFile     = V("tpl")
			htmlCacheFile    = tplCacheFile
			call parseHTML()
		elseif CTL="logout" then
			V("seo_title")   = "您已安全退出"
			V("keywords")    = "用户安全退出"
			V("description") = "用户安全退出"
			V("tpl")         = "logout.html"
			tplFile          = OS.tplHtmlPath & V("tpl")
			tplCacheFile     = V("tpl")
			htmlCacheFile    = tplCacheFile
			call OS.logout()
			call parseHTML()
		elseif CTL="reg" then
			if LOGINED then redirect(SITE_URL &"ow-ucenter/")
			V("seo_title")   = "免费注册"
			V("keywords")    = "免费注册，会员登陆"
			V("description") = "用户登陆页面，会员登陆页面"
			V("tpl")         = "reg.html"
			tplFile          = OS.tplHtmlPath & V("tpl")
			tplCacheFile     = V("tpl")
			htmlCacheFile    = tplCacheFile
			call parseHTML()
		elseif CTL="forget_password" then
			if ACT="reset" then
				V("uid")  = OW.int(OW.getForm("get","uid"))
				V("hash") = OW.left(OW.regReplace(OW.getForm("get","hash"),"[^0-9a-zA-Z_]",""),32)
				set rs = OW.DB.getRecordBySQL("SELECT * FROM ["& OW.DB.Table.member &"] WHERE uid="& V("uid") &"")
				if rs.eof then
					V("user_exist") = false
				else
					V("user_exist") = true
					V("uid")        = OW.int(rs("uid"))
					V("username")   = OW.rs(rs("username"))
					V("email")      = OW.rs(rs("email"))
					V("password")   = OW.rs(rs("password"))
					V("status")     = OW.int(rs("status"))
					V("last_login_time") = OW.rs(rs("last_login_time"))
				end if
				OW.DB.closeRs rs
				if not(V("user_exist")) then
					Client.errorLink = "返回"& OW.config("site_mini_name") &"首页>"& SITE_URL &""
					Client.errorSetting("用户不存在！")
					Client.errorDisplay()
					exit sub
				end if
				if OW.MD6.encrypt(V("password") & V("last_login_time"))<>V("hash") then
					Client.errorLink = "返回"& OW.config("site_mini_name") &"首页>"& SITE_URL &""
					Client.errorSetting("此链接已无效！")
					Client.errorDisplay()
					exit sub
				end if
				V("seo_title")   = "重新设置密码"
				V("keywords")    = "重新设置密码"
				V("description") = "重新设置密码"
				V("tpl")         = "forget_password_reset.html"
				tplFile          = OS.tplHtmlPath & V("tpl")
				tplCacheFile     = V("tpl")
				htmlCacheFile    = tplCacheFile
			else
				V("seo_title")   = "找回密码"
				V("keywords")    = "找回密码"
				V("description") = "找回密码"
				V("tpl")         = "forget_password.html"
				tplFile          = OS.tplHtmlPath & V("tpl")
				tplCacheFile     = V("tpl")
				htmlCacheFile    = tplCacheFile
			end if
			call parseHTML()
		end if
	end sub
	public sub runForm()
		dim rs,formName
		set rs = OW.DB.getRecordBySQL("SELECT form_id,[name],tpl FROM "& DB_PRE &"form WHERE urlpath='"& URLPATH &"' AND is_shop=0 AND "& OW.DB.auxSQL &"")
		if not rs.eof then
			V("form_id")    = OW.int(rs("form_id"))
			V("form_exist") = true
			V("tpl")        = rs("tpl")
			V("title")      = rs("name")
			formName        = V("title")
		else
			V("form_exist") = false
		end if
		OW.DB.closeRs rs
		'**
		if V("form_exist") then
			V("seo_title")   = formName
			V("keywords")    = formName
			V("description") = formName
			tplFile          = OS.tplHtmlPath & V("tpl")
			tplCacheFile     = V("tpl")
			htmlCacheFile    = OS.getHtmlCacheFile("form")
			call parseHTML()
		else
			redirect(OW.urlRewrite("e1"))
		end if
	end sub
	public sub runContentAndGoods(byval isCate, byval rootpath, byval urlpath, byval cateId, byval cid, byval page)
		dim arr,fieldsCount,i
		if isCate then
			set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& OW.DB.Table.category &" WHERE rootpath='"& rootpath &"' AND urlpath='"& urlpath &"' AND "& OW.DB.auxSQL &"")
			if oRs.eof then
				V("cate_exist")= false
			else
				V("cate_exist")= true
				V("model_type")= OW.int(oRs("model_type"))
				V("cate_type") = OW.int(oRs("cate_type"))
				V("cate_id")   = OW.int(oRs("cate_id"))
				V("model_id")  = OW.int(oRs("model_id"))
				V("name")      = oRs("name")
				V("subname")   = oRs("subname")
				V("parent_id") = OW.int(oRs("parent_id"))
				V("path")      = oRs("path")
				V("children")  = OW.int(oRs("children"))
				V("root_id")   = OW.int(oRs("root_id"))
				V("rootpath")  = OW.rs(oRs("rootpath"))
				V("icon")      = OW.rs(oRs("icon"))
				V("image")     = OW.rs(oRs("image"))
				V("type_cate_id") = OW.int(oRs("type_cate_id"))
				'**
				V("tpl_inherit") = OW.int(oRs("tpl_inherit"))
				V("tpl_page")    = OW.rs(oRs("tpl_page"))
				V("tpl_index")   = OW.rs(oRs("tpl_index"))
				V("tpl_category")= OW.rs(oRs("tpl_category"))
				V("tpl_content") = OW.rs(oRs("tpl_content"))
				'**
				V("seo_title")   = OW.rs(oRs("seo_title"))
				V("keywords")    = OW.rs(oRs("keywords"))
				V("description") = OW.rs(oRs("description"))
			end if
			OW.DB.closeRs oRs
			if not V("cate_exist") then OS.redirectError404()
			if not(Client.validAuth(V("cate_id"))) then exit sub
			if V("model_type")=1 and V("cate_type")=0 then
				IS_CPAGE = true
				V("page_parent_id") = V("parent_id")
				set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& OW.DB.Table.content &" WHERE cate_id="& V("cate_id") &"")
				if oRs.eof then
					V("cid")         = 0
				else
					V("cid")         = OW.int(oRs("cid"))
					V("title")       = OW.rs(oRs("title"))
					V("subtitle")    = OW.rs(oRs("subtitle"))
					V("views")       = OW.int(oRs("views"))
					V("post_time")   = OW.rs(oRs("post_time"))
					V("update_time") = OW.rs(oRs("update_time"))
				end if
				OW.DB.closeRs oRs
				CID = V("cid")
				V("model_table") = OW.DB.getFieldValueBySQL("SELECT model_table FROM "& DB_PRE &"model WHERE model_id="& V("model_id") &" AND "& OW.DB.auxSQL &"")
				set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& OW.DB.Table.contentModelPre & V("model_table") &" WHERE cid="& CID &"")
				fieldsCount = oRs.fields.count-1
				if not oRs.eof then
					for i=0 to fieldsCount
						V(oRs.fields(i).name) = OW.rs(oRs(oRs.fields(i).name))
					next
				end if
				OW.DB.closeRs oRs
				set oRs = OW.DB.getRecordBySQL("SELECT [field] FROM "& DB_PRE &"model_field WHERE model_id="& V("model_id") &" AND field_type='editor' AND "& OW.DB.auxSQL &"")
				do while not oRs.eof
					execute("V("""& oRs("field") &""") = OW.editorContentClientDecode(V("""& oRs("field") &"""))")
					oRs.movenext
				loop
				OW.DB.closeRs oRs
				set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& OW.DB.Table.contentData &" WHERE cid="& CID &"")
				if not oRs.eof then
					V("seo_title")   = OW.rs(oRs("seo_title"))
					V("keywords")    = OW.rs(oRs("keywords"))
					V("description") = OW.rs(oRs("description"))
					V("content")     = OW.editorContentClientDecode(oRs("content"))
					V("mob_content") = OW.editorContentClientDecode(oRs("mob_content"))
				end if
				OW.DB.closeRs oRs
				V("seo_title") = OW.iif(V("seo_title")<>"",V("seo_title"),V("title"))
				V("breadcrumb")= "<a href="& SITE_PATH &">"& OS.lang(1) &"</a><span class=""sep"">></span>"& V("title")
				V("tpl")       = OW.iif(OW.int(V("tpl_inherit"))=1,getTpl(0,V("path")),V("tpl_page"))
				V("tpl")       = OW.iif(V("tpl")<>"",V("tpl"),"page.html")
			else
				if not(V("type_cate_id")>0) then V("type_cate_id") = OS.getTypeCateId(V("cate_id"),V("path"))
				TYPEID = OW.regReplace(OW.getForm("get","typeid"),"[^0-9-]","")
				ORDERBY = OW.regReplace(OW.getForm("get","orderby"),"[^0-9-]","")
				if OW.isNul(TYPEID) then TYPEID = "0-0-0-0-0-0-0-0"
				if OW.isNul(ORDERBY) then ORDERBY = "0-0"
				V("typeids") = OS.typeIdDo(TYPEID)
				V("orderby") = OS.orderByDo(ORDERBY)
				if V("root_id")=0 then
					V("seo_title") = OW.iif(V("seo_title")<>"",V("seo_title"),V("name"))
					V("breadcrumb")= "<a href="& SITE_PATH &">"& OS.lang(1) &"</a><span class=""sep"">></span>"& V("name")
					V("tpl")       = OW.iif(OW.int(V("tpl_inherit"))=1,getTpl(1,V("path")),V("tpl_index"))
				else
					V("seo_title") = OW.iif(V("seo_title")<>"",V("seo_title"),V("name"))
					V("breadcrumb")= "<a href="& SITE_PATH &">"& OS.lang(1) &"</a><span class=""sep"">></span>"& V("name")
					V("tpl")       = OW.iif(OW.int(V("tpl_inherit"))=1,getTpl(2,V("path")),V("tpl_index"))
				end if
			end if
			tplFile       = OS.tplHtmlPath & V("tpl")
			tplCacheFile  = V("tpl")
			htmlCacheFile = OS.getHtmlCacheFile("content")
			call parseHTML()
		else
			set oRs = OW.DB.getRecordBySQL("SELECT is_shop FROM "& OW.DB.Table.category &" WHERE root_id=0 AND urlpath='"& rootpath &"' AND "& OW.DB.auxSQL &"")
			if oRs.eof then
				V("root_exist") = false
				V("is_shop")    = OW.int(oRs("is_shop"))
			else
				V("root_exist") = true
				V("is_shop")    = OW.int(oRs("is_shop"))
			end if
			OW.DB.closeRs oRs
			if not(V("root_exist")) then call OS.redirectError404()
			if OS.blackAuth then : OW.Error.Msg = SITE_DOMAIN : OW.Error.raise "3"&"1" : err.clear()
			if V("is_shop") then
				set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& OW.DB.Table.goods &" WHERE rootpath='"& rootpath &"' AND urlpath='"& urlpath &"' AND root_id>0 AND "& OW.DB.auxSQL &"")
				if oRs.eof then
					V("goods_exist") = false
				else
					V("goods_exist") = true
					V("gid")           = OW.int(oRs("gid"))
					V("cate_id")       = OW.int(oRs("cate_id"))
					V("is_book")               = OW.int(oRs("is_book"))
					V("book_front_money_rate") = OW.parseMoney(oRs("book_front_money_rate"))
					V("book_final_pay_day")    = OW.int(oRs("book_final_pay_day"))
					V("book_price_discount")   = OW.parsePrice(oRs("book_price_discount"))
					V("is_book_timelimit")     = OW.int(oRs("is_book_timelimit"))
					V("book_starttime")        = OW.formatDateTime(oRs("book_starttime"),0)
					V("book_endtime")          = OW.formatDateTime(oRs("book_endtime"),0)
					V("goods_sn")      = OW.rs(oRs("goods_sn"))
					V("market_price")  = OW.parsePrice(oRs("market_price"))
					V("price")         = OW.parsePrice(oRs("price"))
					V("thumbnail")     = OW.rs(oRs("thumbnail"))
					V("spec_id")       = OW.rs(oRs("spec_id"))
					V("type_id")       = OW.int(oRs("type_id"))
					V("form_id")       = OW.int(oRs("form_id"))
					V("brand_id")      = OW.int(oRs("brand_id"))
					V("sales")         = OW.int(oRs("sales"))
					V("comments")      = OW.int(oRs("comments"))
					V("title")         = oRs("title")
					V("name")          = oRs("title")
					V("font_color")    = OW.rs(oRs("font_color"))
					V("font_weight")   = OW.rs(oRs("font_weight"))
					V("subtitle")      = OW.rs(oRs("subtitle"))
					V("root_id")       = OW.int(oRs("root_id"))
					V("rootpath")      = oRs("rootpath")
					V("urlpath")       = oRs("urlpath")
					V("url")           = OW.rs(oRs("url"))
					V("views")         = OW.int(oRs("views"))
					V("post_time")     = OW.rs(oRs("post_time"))
					V("update_time")   = OW.rs(oRs("update_time"))
					V("summary")       = OW.rs(oRs("summary"))
					V("recommend")     = OW.int(oRs("recommend"))
					V("sequence")      = OW.int(oRs("sequence"))
					V("status")        = OW.int(oRs("status"))
				end if
				OW.DB.closeRs oRs
				if not V("goods_exist") then OS.redirectError404()
				if not(Client.validAuth(V("cate_id"))) then exit sub
				GID = V("gid")
				V("pid") = OS.SHOP.getGoodsProductId(GID)
				V("buy_record_count") = OW.int(OW.DB.getFieldValueBySQL("select count(*) from "& DB_PRE &"order_goods where gid="& V("gid") &" AND order_id in (select order_id from "& OW.DB.Table.orders &" where pay_status>0 AND "& OW.DB.auxSQL &") AND "& OW.DB.auxSQL &""))
				set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& OW.DB.Table.goodsData &" WHERE gid="& GID &"")
				if not oRs.eof then
					V("seo_title")   = OW.rs(oRs("seo_title"))
					V("keywords")    = OW.rs(oRs("keywords"))
					V("description") = OW.rs(oRs("description"))
					V("content")     = OW.editorContentClientDecode(oRs("content"))
					V("mob_content") = OW.editorContentClientDecode(oRs("mob_content"))
					V("images")      = OW.rs(oRs("images"))
					V("goods_tpl_inherit") = OW.int(oRs("tpl_inherit"))
					V("goods_tpl")         = OW.rs(oRs("tpl"))
				end if
				OW.DB.closeRs oRs
				if instr(V("content"),"_openwbs_page_break_tag_")>0 then
					call createContentPage(V("rootpath"),V("urlpath"))
				end if
				if not(OW.isNul(V("spec_id"))) then
					V("spec_data") = OS.SHOP.getGoodsSpecData(GID,V("spec_id"))
				end if
				V("content") = OS.addKeywordsLink(V("content"))
				V("content") = OS.addImgAlt(V("content"),V("title"))
				set oRs = OW.DB.getRecordBySQL("SELECT model_id,parent_id,path,name,tpl_inherit,tpl_content FROM "& OW.DB.Table.category &" WHERE cate_id="& V("cate_id") &" AND is_shop=1 AND "& OW.DB.auxSQL &"")
				if oRs.eof then
					V("cate_exist")  = false
				else
					V("cate_exist")  = true
					V("model_id")    = OW.int(oRs("model_id"))
					V("parent_id")   = OW.int(oRs("parent_id"))
					V("path")        = oRs("path")
					V("cate_name")   = oRs("name")
					V("tpl_inherit") = OW.int(oRs("tpl_inherit"))
					V("tpl_content") = OW.rs(oRs("tpl_content"))
				end if
				OW.DB.closeRs oRs
				if not V("cate_exist") then OS.redirectError404()
				V("model_table") = OW.DB.getFieldValueBySQL("SELECT model_table FROM "& DB_PRE &"model WHERE model_id="& V("model_id") &" AND is_shop=1 AND "& OW.DB.auxSQL &"")
				set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& OW.DB.Table.goodsModelPre & V("model_table") &" WHERE gid="& GID &"")
				fieldsCount = oRs.fields.count-1
				if not oRs.eof then
					for i=1 to fieldsCount
						V(oRs.fields(i).name) = OW.rs(oRs(oRs.fields(i).name))
					next
				end if
				OW.DB.closeRs oRs
				'**
				set oRs = OW.DB.getRecordBySQL("SELECT [field] FROM "& DB_PRE &"model_field WHERE model_id="& V("model_id") &" AND field_type='editor' AND "& OW.DB.auxSQL &"")
				do while not oRs.eof
					execute("V("""& oRs("field") &""") = OW.editorContentClientDecode(V("""& oRs("field") &"""))")
					oRs.movenext
				loop
				OW.DB.closeRs oRs
				call OW.DB.execute("UPDATE "& OW.DB.Table.goods &" SET views=views+1 WHERE gid="& GID &"")
				V("seo_title") = OW.iif(V("seo_title")<>"",V("seo_title"),V("title"))
				V("breadcrumb")= "<a href="& SITE_PATH &">"& OS.lang(1) &"</a><span class=""sep"">></span>"& V("title")
				if OW.int(V("goods_tpl_inherit"))=0 and OW.isNotNul(V("goods_tpl")) then
					V("tpl")   = V("goods_tpl")
				else
					V("tpl")   = OW.iif(OW.int(V("tpl_inherit"))=1,getTpl(3,V("path")),V("tpl_content"))
				end if
				tplFile        = OS.tplHtmlPath & V("tpl")
				tplCacheFile   = V("tpl")
				htmlCacheFile  = OS.getHtmlCacheFile("content")
				call parseHTML()
			else
				set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& OW.DB.Table.content &" WHERE status=0 AND rootpath='"& rootpath &"' AND urlpath='"& urlpath &"' AND root_id>0")
				if oRs.eof then
					V("content_exist") = false
				else
					V("content_exist") = true
					V("cid")           = OW.int(oRs("cid"))
					V("cate_id")       = OW.int(oRs("cate_id"))
					V("root_id")       = OW.int(oRs("root_id"))
					V("title")         = oRs("title")
					V("font_color")    = OW.rs(oRs("font_color"))
					V("font_weight")   = OW.rs(oRs("font_weight"))
					V("subtitle")      = OW.rs(oRs("subtitle"))
					V("root_id")       = OW.int(oRs("root_id"))
					V("rootpath")      = oRs("rootpath")
					V("urlpath")       = oRs("urlpath")
					V("url")           = OW.rs(oRs("url"))
					V("views")         = OW.int(oRs("views"))
					V("post_time")     = OW.rs(oRs("post_time"))
					V("update_time")   = OW.rs(oRs("update_time"))
					V("summary")       = OW.rs(oRs("summary"))
					V("recommend")     = OW.int(oRs("recommend"))
				end if
				OW.DB.closeRs oRs
				if not V("content_exist") then OS.redirectError404()
				if not(Client.validAuth(V("cate_id"))) then exit sub
				CID = V("cid")
				set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& OW.DB.Table.contentData &" WHERE cid="& CID &"")
				if not oRs.eof then
					V("seo_title")   = OW.rs(oRs("seo_title"))
					V("keywords")    = OW.rs(oRs("keywords"))
					V("description") = OW.rs(oRs("description"))
					V("content")     = OW.editorContentClientDecode(oRs("content"))
					V("mob_content") = OW.editorContentClientDecode(oRs("mob_content"))
				end if
				OW.DB.closeRs oRs
				if instr(V("content"),"_openwbs_page_break_tag_")>0 then
					call createContentPage(V("rootpath"),V("urlpath"))
				end if
				V("content") = OS.addKeywordsLink(V("content"))
				V("content") = OS.addImgAlt(V("content"),V("title"))
				set oRs = OW.DB.getRecordBySQL("SELECT model_id,parent_id,path,name,tpl_inherit,tpl_content FROM "& OW.DB.Table.category &" WHERE cate_id="& V("cate_id") &" AND "& OW.DB.auxSQL &"")
				if oRs.eof then
					V("cate_exist")  = false
				else
					V("cate_exist")  = true
					V("model_id")    = OW.int(oRs("model_id"))
					V("parent_id")   = OW.int(oRs("parent_id"))
					V("path")        = oRs("path")
					V("cate_name")   = oRs("name")
					V("tpl_inherit") = OW.int(oRs("tpl_inherit"))
					V("tpl_content") = OW.rs(oRs("tpl_content"))
				end if
				OW.DB.closeRs oRs
				if not V("cate_exist") then OS.redirectError404()
				V("model_table") = OW.DB.getFieldValueBySQL("SELECT model_table FROM "& DB_PRE &"model WHERE model_id="& V("model_id") &" AND "& OW.DB.auxSQL &"")
				set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& OW.DB.Table.contentModelPre & V("model_table") &" WHERE cid="& CID &"")
				fieldsCount = oRs.fields.count-1
				if not oRs.eof then
					for i=0 to fieldsCount
						V(oRs.fields(i).name) = OW.rs(oRs(oRs.fields(i).name))
					next
				end if
				OW.DB.closeRs oRs
				'**
				set oRs = OW.DB.getRecordBySQL("SELECT [field] FROM "& DB_PRE &"model_field WHERE model_id="& V("model_id") &" AND field_type='editor' AND "& OW.DB.auxSQL &"")
				do while not oRs.eof
					execute("V("""& oRs("field") &""") = OW.editorContentClientDecode(V("""& oRs("field") &"""))")
					oRs.movenext
				loop
				OW.DB.closeRs oRs
				call OW.DB.execute("UPDATE "& OW.DB.Table.content &" SET views=views+1 WHERE cid="& CID &"")
				V("seo_title") = OW.iif(V("seo_title")<>"",V("seo_title"),V("title"))
				V("breadcrumb")= "<a href="& SITE_PATH &">"& OS.lang(1) &"</a><span class=""sep"">></span>"& V("title")
				V("tpl")       = OW.iif(OW.int(V("tpl_inherit"))=1,getTpl(3,V("path")),V("tpl_content"))
				tplFile        = OS.tplHtmlPath & V("tpl")
				tplCacheFile   = V("tpl")
				htmlCacheFile  = OS.getHtmlCacheFile("content")
				call parseHTML()
				'**
			end if
		end if
	end sub
	public sub runSearch()
		V("is_shop")     = OW.int(OW.getForm("get","is_shop"))
		V("is_shop")     = OW.iif(V("is_shop")=1,1,0)
		V("keyword")     = KEYWORD
		V("seo_title")   = KEYWORD
		V("keywords")    = KEYWORD
		V("description") = KEYWORD
		'**
		call OW.DB.execute("UPDATE "& DB_PRE &"search_keywords SET [search_count]=search_count+1 WHERE keyword='"& V("keyword") &"' AND is_shop="& V("is_shop") &" AND "& OW.DB.auxSQL &"")
		if V("is_shop") then
			V("tpl")     = "shop.search.html"
			tplFile      = OS.tplHtmlPath & V("tpl")
			tplCacheFile = V("tpl")
			htmlCacheFile= ""
		else
			V("tpl")     = "search.html"
			tplFile      = OS.tplHtmlPath & V("tpl")
			tplCacheFile = V("tpl")
			htmlCacheFile= ""
		end if
		call parseHTML()
	end sub
	public sub runShop()
		V("seo_title")   = OW.config("shop_title")
		V("keywords")    = OW.config("shop_keywords")
		V("description") = OW.config("shop_description")
		V("tpl")         = "shop.html"
		tplCacheFile     = V("tpl")
		htmlCacheFile    = OS.getHtmlCacheFile("s1")
		tplFile          = OS.tplHtmlPath & V("tpl")
		call parseHTML()
	end sub
	public sub runBrand(byval urlpath,byval page)
		if urlpath<>"" then
			set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& DB_PRE &"brand WHERE urlpath='"& urlpath &"' AND status=0")
			if oRs.eof then
				V("brand_exist") = false
			else
				V("brand_exist") = true
				V("brand_id")    = OW.int(oRs("brand_id"))
				V("name")        = OW.rs(oRs("name"))
				V("logo")        = OW.rs(oRs("logo"))
				V("url")         = OW.rs(oRs("url"))
				V("tpl")         = OW.rs(oRs("tpl"))
				V("seo_title")   = OW.rs(oRs("seo_title"))
				V("keywords")    = OW.rs(oRs("keywords"))
				V("description") = OW.rs(oRs("description"))
				V("content")     = OW.editorContentClientDecode(oRs("content"))
			end if
			OW.DB.closeRs oRs
			if not(V("brand_exist")) then call OS.redirectError404()
			V("tpl")         = OW.iif(V("tpl")<>"",V("tpl"),"shop.brand.detail.html")
			tplFile          = OS.tplHtmlPath & V("tpl")
			tplCacheFile     = V("tpl")
			htmlCacheFile    = OW.iif(OW_PAGE>0,OS.getHtmlCacheFile("b3"),OS.getHtmlCacheFile("b2"))
			call parseHTML()
		else
			V("seo_title")   = OW.config("brand_title")
			V("keywords")    = OW.config("brand_keywords")
			V("description") = OW.config("brand_description")
			V("tpl")         = "shop.brand.html"
			tplFile          = OS.tplHtmlPath & V("tpl")
			tplCacheFile     = V("tpl")
			htmlCacheFile    = OS.getHtmlCacheFile("b1")
			call parseHTML()
		end if
	end sub
	public sub runCoupon(byval couponId)
		dim fieldsCount,i
		couponId = OW.int(couponId)
		'**
		if couponId>0 then
			set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& DB_PRE &"coupon WHERE coupon_id="& couponId &" AND status=0")
			fieldsCount = oRs.fields.count-1
			if not oRs.eof then
				V("coupon_exist") = true
				for i=0 to fieldsCount
					V(oRs.fields(i).name) = OW.rs(oRs(oRs.fields(i).name))
				next
			else
				V("coupon_exist") = false
			end if
			OW.DB.closeRs oRs
			'**
			if not(V("coupon_exist")) then call OS.redirectError404() : exit sub
			V("coupon_goods")= OS.SHOP.getCouponValidGoods(V("coupon_rule_type"),V("cate_ids"),V("gids"))
			V("tpl")         = OW.iif(V("tpl")<>"",V("tpl"),"shop.coupon.detail.html")
			tplFile          = OS.tplHtmlPath & V("tpl")
			tplCacheFile     = V("tpl")
			htmlCacheFile    = OS.getHtmlCacheFile("cp3")
			call parseHTML()
		else
			V("seo_title")   = OW.config("coupon_title")
			V("keywords")    = OW.config("coupon_keywords")
			V("description") = OW.config("coupon_description")
			V("tpl")         = "shop.coupon.html"
			tplFile          = OS.tplHtmlPath & V("tpl")
			tplCacheFile     = V("tpl")
			htmlCacheFile    = OW.iif(OW_PAGE>0,OS.getHtmlCacheFile("cp2"),OS.getHtmlCacheFile("cp1"))
			call parseHTML()
		end if
	end sub
	public sub runCart()
		V("seo_title")   = "我的购物车"
		V("keywords")    = OW.config("cart_keywords")
		V("description") = OW.config("cart_description")
		V("tpl")         = "shop.cart.html"
		tplFile          = OS.tplHtmlPath & V("tpl")
		tplCacheFile     = V("tpl")
		htmlCacheFile    = OS.getHtmlCacheFile("ct")
		call parseHTML()
	end sub
	public sub runOrder()
		dim arr,orderId
		if not(LOGINED) and OW.config("shopping_is_need_login") then
			redirect(OW.urlRewrite("l1"))
		end if
		select case ACT
		case "init"
			V("order_form_html")    = OS.SHOP.getOrderFormHtml()
			V("order_invoice_html") = OS.SHOP.getOrderInvoiceHtml()
			V("order_coupon_html")  = OS.SHOP.getOrderCouponHtml()
			V("cost_freight")       = OW.parsePrice(OS.SHOP.getOrderDlyFee(V("order_goods_data"),V("order_region_path")))
			V("total_amount")       = OW.parsePrice(OW.parseMoney(V("cost_item")) + OW.parseMoney(V("cost_freight")))
			V("seo_title")   = "订单结算页"
			V("keywords")    = "订单结算页"
			V("description") = "订单结算页"
			V("tpl")         = "shop.order.html"
			tplFile          = OS.tplHtmlPath & V("tpl")
			tplCacheFile     = V("tpl")
			htmlCacheFile    = ""
			call parseHTML()
		case "shipping"
			orderId = OW.parseOrderId(OW.getForm("get","order_id"))
			arr     = OW.DB.getFieldValueBySQL("SELECT id,cost_item,cost_freight,total_amount,dly_id FROM "& DB_PRE &"orders WHERE order_id='"& orderId &"' AND status=0 AND "& OW.DB.auxSQL &"")
			if not(arr(0)>0) then OS.redirectError404()
			V("order_id")     = orderId
			V("cost_item")    = OW.parsePrice(arr(1))
			V("cost_freight") = OW.parsePrice(arr(2))
			V("total_amount") = OW.parsePrice(arr(3))
			V("dly_id")       = OW.int(arr(4))
			'**
			V("shipping_html")= OS.SHOP.getOrderShipping(orderId,V("dly_id"))
			V("seo_title")   = "选择送货方式"
			V("keywords")    = "选择送货方式"
			V("description") = "选择送货方式"
			'**
			V("tpl")         = "shop.order.shipping.html"
			tplFile          = OS.tplHtmlPath & V("tpl")
			tplCacheFile     = V("tpl")
			htmlCacheFile    = ""
			call parseHTML()
		case "payment"
			orderId       = OW.parseOrderId(OW.getForm("get","order_id"))
			V("order_id") = orderId
			'**
			set oRs = OW.DB.getRecordBySQL("SELECT * FROM "& OW.DB.Table.orders &" WHERE order_id='"& orderId &"' AND status=0 AND "& OW.DB.auxSQL &"")
			if oRs.eof then
				V("order_exist") = false
			else
				V("order_exist") = true
				V("order_uid")   = OW.int(oRs("uid"))
				V("cost_item")   = OW.parseMoney(oRs("cost_item"))
				V("cost_pay")    = OW.parseMoney(oRs("cost_pay"))
				V("total_amount")= OW.parseMoney(oRs("total_amount"))
				V("money_paid")  = OW.parseMoney(oRs("money_paid"))
				V("is_paid")     = OW.int(oRs("is_paid"))
				V("pay_id")      = OW.int(oRs("pay_id"))
				V("bank_code")   = OW.rs(oRs("bank_code"))
				V("is_book")               = OW.int(oRs("is_book"))
				V("book_front_money")      = OW.parseMoney(oRs("book_front_money"))
				V("is_pay_bookfrontmoney") = false
				V("is_pay_bookfinalmoney") = false
				V("trade_money") = OW.parseMoney(V("total_amount") - V("money_paid"))
				if V("is_book")=1 then
					if V("book_front_money")>0 then
						if V("money_paid")=0 then V("is_pay_bookfrontmoney") = true
						if V("money_paid")=V("book_front_money") then V("is_pay_bookfinalmoney") = true
					end if
					if V("is_pay_bookfrontmoney") then V("trade_money") = V("book_front_money")
				end if
				V("total_amount")= OW.parsePrice(V("total_amount"))
				V("trade_money") = OW.parsePrice(V("trade_money"))
			end if
			OW.DB.closeRs oRs
			if not(V("order_exist")) then OS.redirectError404()
			if not(V("total_amount")>0) then redirect(SITE_URL &"?ctl=order&act=finish&order_id="& V("order_id"))
			'**
			V("payment_html")= OS.SHOP.getOrderPayment(V("pay_id"))
			V("seo_title")   = "支付订单费用"
			V("keywords")    = "支付订单费用"
			V("description") = "支付订单费用"
			'**
			V("tpl")         = "shop.order.payment.html"
			tplFile          = OS.tplHtmlPath & V("tpl")
			tplCacheFile     = V("tpl")
			htmlCacheFile    = ""
			call parseHTML()
		case "finish"
			orderId = OW.parseOrderId(OW.getForm("get","order_id"))
			arr     = OW.DB.getFieldValueBySQL("SELECT id,total_amount,pay_id,dly_id FROM "& DB_PRE &"orders WHERE order_id='"& orderId &"' AND status=0 AND "& OW.DB.auxSQL &"")
			if not(arr(0)>0) then OS.redirectError404()
			V("order_id")     = orderId
			V("total_amount") = OW.parsePrice(arr(1))
			V("payment")      = OW.DB.getFieldValueBySQL("SELECT pay_name FROM "& DB_PRE &"payment WHERE pay_id="& OW.int(arr(2)) &" AND "& OW.DB.auxSQL &"")
			V("delivery_name")= OW.DB.getFieldValueBySQL("SELECT dly_name FROM "& DB_PRE &"delivery WHERE dly_id="& OW.int(arr(3)) &" AND "& OW.DB.auxSQL &"")
			V("seo_title")   = "成功提交订单"
			V("keywords")    = "成功提交订单"
			V("description") = "成功提交订单"
			'**
			V("tpl")         = "shop.order.finish.html"
			tplFile          = OS.tplHtmlPath & V("tpl")
			tplCacheFile     = V("tpl")
			htmlCacheFile    = ""
			call parseHTML()
		case else
			OS.redirectError404()
		end select
	end sub
	public sub runError404()
		V("seo_title")   = "404错误页面"
		V("keywords")    = "404错误页面"
		V("description") = "页面不存在"
		V("tpl")         = "error404.html"
		tplFile          = OS.tplHtmlPath & V("tpl")
		tplCacheFile     = V("tpl")
		htmlCacheFile    = "error404"& SITE_HTML_FILE_SUFFIX
		call parseHTML()
	end sub
	public sub runTags(byval isShop)
		dim sql
		isShop   = OW.int(isShop)
		V("tag") = TAG
		'**
		if isShop then
			sql = "SELECT tag_id FROM "& DB_PRE &"tags WHERE is_shop=1 AND tag='"& OW.validClientDBData(V("tag"),0) &"' AND status=0 AND "& OW.DB.auxSQL &""
		else
			sql = "SELECT tag_id FROM "& DB_PRE &"tags WHERE is_shop=0 AND tag='"& OW.validClientDBData(V("tag"),0) &"' AND status=0 AND "& OW.DB.auxSQL &""
		end if
		
		set oRs = OW.DB.getRecordBySQL(sql)
		if oRs.eof then
			V("tag_exist") = false
			V("tag_id")    = 0
		else
			V("tag_exist") = true
			V("tag_id")    = OW.int(oRs("tag_id"))
		end if
		OW.DB.closeRs oRs'**
		if not V("tag_exist") then OS.redirectError404()
		'**
		call OW.DB.execute("UPDATE "& DB_PRE &"tags SET hits=hits+1 WHERE tag_id="& V("tag_id") &" AND "& OW.DB.auxSQL &"")
		'**
		V("seo_title")   = V("tag")
		V("keywords")    = V("tag")
		V("description") = V("tag")
		V("breadcrumb")  = "<a href="& SITE_PATH &">"& OS.lang(1) &"</a><span class=""sep"">></span>"& V("tag")
		V("tpl")         = OW.iif(isShop=1,"shop.tags.html","tags.html")
		tplFile          = OS.tplHtmlPath & V("tpl")
		tplCacheFile     = V("tpl")
		htmlCacheFile    = OW.iif(isShop=1,OS.getHtmlCacheFile("gtags"),OS.getHtmlCacheFile("tags"))
		call parseHTML()
	end sub
	public function ad(byval id,byval echoType)
		ad = OS.getAdData(id,echoType)
	end function
	public function createContentPage(byval rootpath,byval urlpath)
		dim arr,i,pages,url
		dim prevStr,prevpagesStr,currentStr,nextpagesStr,nextStr
		arr = split(V("content"),"_openwbs_page_break_tag_")
		if OW_PAGE>=(ubound(arr)+1) then OW_PAGE=ubound(arr)+1
		if OW_PAGE=0 then OW_PAGE=1
		for i=1 to ubound(arr)+1
			url = contentPageLink(rootpath,urlpath)
			if OW_PAGE=i then
				currentStr = "<span class=""current"">"& i &"</span>"
			elseif i<OW_PAGE then
				prevpagesStr = prevpagesStr &"<a class=""prev-pages"" href="""& replace(url,"{$page}",i) &""">"& i &"</a>"
			elseif i>OW_PAGE then
				nextpagesStr = nextpagesStr &"<a class=""next-pages"" href="""& replace(url,"{$page}",i) &""">"& i &"</a>"
			end if
		next
		if OW_PAGE>1 then
			prevStr = "<a class=""prev"" href="""& replace(url,"{$page}",OW_PAGE-1) &""">"& lang_page(1) &"</a>"& pages
		end if
		if not(OW_PAGE>=ubound(arr)+1) then
			nextStr = "<a class=""next"" href="""& replace(url,"{$page}",OW_PAGE+1) &""">"& lang_page(2) &"</a>"
		end if
		V("content") = arr(OW_PAGE-1)
		if OW.isMobile then
			V("pages") = prevStr & currentStr & nextStr
		else
			V("pages") = prevStr & prevpagesStr & currentStr & nextpagesStr & nextStr
		end if
	end function
	public function contentPageLink(byval rootpath,byval urlpath)
		if OW.isNul(rootpath) then
			contentPageLink = replace(OW.urlRewrite("c6"),"{$urlpath}",urlpath)
		else
			contentPageLink = replace(replace(OW.urlRewrite("c8"),"{$urlpath}",urlpath),"{$rootpath}",rootpath)
		end if
	end function
	public function contentLink(byval rootpath,byval urlpath,byval url)
		if OW.isNotNul(url) then contentLink = url : exit function
		if OW.isNul(rootpath) then
			contentLink = replace(OW.urlRewrite("c5"),"{$urlpath}",urlpath)
		else
			contentLink = replace(replace(OW.urlRewrite("c7"),"{$urlpath}",urlpath),"{$rootpath}",rootpath)
		end if
	end function
	public function cpageLink(byval urlpath)
		cpageLink = replace(OW.urlRewrite("c5"),"{$urlpath}",urlpath)
	end function
	public function searchPageLink(byval isShop,byval kw)
		searchPageLink = replace(replace(OW.urlRewrite("search"),"{$is_shop}",isShop),"{$keyword}",kw)
	end function
	public function typeLink(byval typeCateId,byval typeAttrId,byval tid)
		dim arr,arr2,i,rs,url,typeId_
		if OW.isNul(ROOTPATH) then
			if OW_PAGE>=1 then
				url = replace(OW.urlRewrite("c2t"),"{$urlpath}",URLPATH)
				url = replace(url,"{$page}",OW_PAGE)
			else
				url = replace(OW.urlRewrite("c1t"),"{$urlpath}",URLPATH)
			end if
		else
			if OW_PAGE>=1 then
				url = replace(replace(OW.urlRewrite("c4t"),"{$urlpath}",URLPATH),"{$rootpath}",ROOTPATH)
				url = replace(url,"{$page}",OW_PAGE)
			else
				url = replace(replace(OW.urlRewrite("c3t"),"{$urlpath}",URLPATH),"{$rootpath}",ROOTPATH)
			end if
		end if
		url = replace(url,"{$orderby}",ORDERBY)
		'**
		if OW.isNul(V("_type_id_")) then
			set rs = OW.DB.getRecordBySQL("SELECT type_attr_id FROM "& DB_PRE &"type_attr WHERE type_cate_id="& typeCateId &" ORDER BY sequence ASC")
			do while not rs.eof
				typeId_ = OW.iif(typeId_="","{$"& rs("type_attr_id") &"}",typeId_&"-{$"& rs("type_attr_id") &"}")
				rs.movenext
			loop
			OW.DB.closeRs rs
			V("_type_id_") = typeId_
		else
			typeId_ = V("_type_id_")
		end if
		typeId_ = replace(typeId_,"{$"& typeAttrId &"}",tid)
		'**
		arr = split(typeId_,"-")
		for i=0 to ubound(arr)
			if instr(arr(i),"$")>0 then
				arr(i) = TYPEID_ARR(i)
			end if
		next
		typeId_ = join(arr,"-")
		'**
		url     = replace(url,"{$typeid}",typeId_)
		'**
		typeLink = url
	end function
	public function ctitle(byval s,byval fontColor,byval fontWeight)
		if fontColor<>"" then fontColor = "color:"& fontColor &";"
		if OW.int(fontWeight)>0 then fontWeight = "font-weight:"& fontWeight &";"
		if fontColor<>"" or fontWeight<>"" then
			s = "<font style="""& fontColor & fontWeight &""">"& s &"</font>"
		end if
		ctitle = s
	end function
	public function cateLink(byval modelType,byval cateType,byval rootId,byval rootpath,byval urlpath)
		dim s
		modelType = OW.int(modelType)
		cateType  = OW.int(cateType)
		rootId    = OW.int(rootId)
		if cateType=0 then
			if modelType=1 then
				s = replace(OW.urlRewrite("c5"),"{$urlpath}",urlpath)
			else
				if rootId>0 then
					s = replace(OW.urlRewrite("c3"),"{$rootpath}",rootpath)
					s = replace(s,"{$urlpath}",urlpath)
				else
					s = replace(OW.urlRewrite("c1"),"{$urlpath}",urlpath)
				end if
			end if
		else
			s = "javascript:;"
		end if
		cateLink = s
	end function
	public function getTpl(byval tplType,byval catePath)
		dim arr,cateId,field,i,tpl,modelId
		arr = split(catePath,",")
		select case tplType
		case 0
			field = "tpl_page"
		case 1
			field = "tpl_index"
		case 2
			field = "tpl_category"
		case 3
			field = "tpl_content"
		end select
		for i=ubound(arr) to 0 step -1
			cateId = OW.int(arr(i))
			if cateId>0  then
				set oRs = OW.DB.getRecordBySQL("SELECT model_id,tpl_inherit,"& field &" FROM "& OW.DB.Table.category &" WHERE cate_id="& cateId &" AND "& OW.DB.auxSQL &"")
				if not oRs.eof then
					if OW.int(oRs(1))=0 then tpl = OW.rs(oRs(2))
					if modelId="" then modelId = OW.int(oRs("model_id"))
				end if
				OW.DB.closeRs oRs
			end if
			if tpl<>"" then exit for
		next
		if tpl="" then
			set oRs = OW.DB.getRecordBySQL("SELECT "& field &" FROM "& DB_PRE &"model WHERE model_id="& modelId &" AND "& OW.DB.auxSQL &"")
			if not oRs.eof then
				tpl = OW.rs(oRs(0))
			end if
			OW.DB.closeRs oRs
		end if
		getTpl = tpl
	end function
	
	
	public function getBreadcrumb()
		dim bread,cateId
		if CTL="content" then
			cateId = V("cate_id")
			bread  = "<a href="& SITE_PATH &">"& OS.lang(1) &"</a>"
			bread  = bread & getCatePathBread(V("path"))
			if IS_CATE=0 then
				bread = bread &"<span class=""sep"">></span>"& V("title")
			end if
		else
			bread = V("breadcrumb")
		end if
		getBreadcrumb = bread
	end function
	public function getCatePathBread(byval path)
		dim arr,cateId,i,rs,ss
		if OW.isNul(path) then getBreadcrumb="" : exit function
		arr = split(path,",")
		for i=0 to ubound(arr)
			cateId = OW.int(arr(i))
			if cateId>0 then
				set rs = OW.DB.getRecordBySQL("SELECT * FROM "& OW.DB.Table.category &" WHERE cate_id="& cateId &" AND "& OW.DB.auxSQL &"")
				if not(rs.eof) then
					ss = ss &"<span class=""sep"">></span><a href="""& OS.createCateLink(rs("rootpath"),rs("urlpath")) &""">"& rs("name") &"</a>"
				end if
				OW.DB.closeRs rs
			end if
		next
		getCatePathBread = ss
	end function
	public function getComment(byval gid,byval cmtTpl,byval psize,byval pagetpl)
		dim arr
		arr = Client.getComment(gid,cmtTpl,psize,pagetpl)
		V("comment_list")  = arr(1)
		V("comment_pager") = arr(2)
	end function
	public function getConsultation(byval gid,byval cstTpl,byval psize,byval pagetpl)
		dim arr
		arr = Client.getConsultation(gid,cstTpl,psize,pagetpl)
		V("consultation_list")  = arr(1)
		V("consultation_pager") = arr(2)
	end function
	public function getBuyRecord(byval gid,byval recordTpl,byval psize,byval pagetpl)
		dim arr
		arr = Client.getBuyRecord(gid,recordTpl,psize,pagetpl)
		V("buy_record_list")  = arr(1)
		V("buy_record_pager") = arr(2)
	end function
	public function getPrevNextContent(byval rootId,byval cid,byval t)
		dim rs,sql,s
		if t="prev" then
			sql = "SELECT top 1 rootpath,urlpath,url,title FROM ["& OW.DB.Table.content &"] WHERE cate_id IN (SELECT cate_id FROM "& OW.DB.Table.category &" WHERE path like ',"& rootId &",%' AND "& OW.DB.auxSQL &") AND cid<"& cid &" AND status=0 ORDER BY cid DESC"
		else
			sql = "SELECT top 1 rootpath,urlpath,url,title FROM ["& OW.DB.Table.content &"] WHERE cate_id IN (SELECT cate_id FROM "& OW.DB.Table.category &" WHERE path like ',"& rootId &",%' AND "& OW.DB.auxSQL &") AND cid>"& cid &" AND status=0 ORDER BY cid ASC"
		end if
		set rs = OW.DB.getRecordBySQL(sql)
		if not(rs.eof) then
			s = "<a href="""& contentLink(rs("rootpath"),rs("urlpath"),rs("url")) &""" title="""& rs("title") &""">"& rs("title") &"</a>"
		else
			s = "没有了"
		end if
		OW.DB.closeRs rs
		getPrevNextContent = s
	end function
	public function getPrevNextGoods(byval rootId,byval gid,byval t)
		dim rs,sql,s
		if t="prev" then
			sql = "SELECT top 1 rootpath,urlpath,url,title,thumbnail FROM ["& OW.DB.Table.goods &"] WHERE cate_id IN (SELECT cate_id FROM "& OW.DB.Table.category &" WHERE path like ',"& rootId &",%' AND "& OW.DB.auxSQL &") AND gid<"& gid &" AND status=0 ORDER BY gid DESC"
		else
			sql = "SELECT top 1 rootpath,urlpath,url,title,thumbnail FROM ["& OW.DB.Table.goods &"] WHERE cate_id IN (SELECT cate_id FROM "& OW.DB.Table.category &" WHERE path like ',"& rootId &",%' AND "& OW.DB.auxSQL &") AND gid>"& gid &" AND status=0 ORDER BY gid ASC"
		end if
		set rs = OW.DB.getRecordBySQL(sql)
		if not(rs.eof) then
			s = "<a href="""& contentLink(rs("rootpath"),rs("urlpath"),rs("url")) &""" title="""& rs("title") &""">"& rs("title") &"</a>"
		else
			s = "没有了"
		end if
		OW.DB.closeRs rs
		getPrevNextGoods = s
	end function
	public function gzip(byval s)
		dim reg
		set reg = new regexp
			reg.ignorecase = true
			reg.global = true
			reg.pattern="<!--(.+?)-->"  : s = reg.replace(s,"")
			reg.pattern=" +"  : s = reg.replace(s,chr(32))
			reg.pattern="\t+|\r+|\n+" : s = reg.replace(s,"")
			reg.pattern="\r+" : s = reg.replace(s,"")
			reg.pattern="\n+" : s = reg.replace(s,"")
		set reg = nothing
		gzip = s
	end function
	public function createPages(byval url,byval curPage,byval rsCount,byval pCount,byval pSize,byval tType)
		dim a,p,s
		dim prevStr,firstStr,prevpagesStr,currentStr,nextpagesStr,nextStr,lastStr,allpagesStr,recordsStr,perpageStr
		curPage = OW.int(curPage)
		rsCount = OW.int(rsCount)
		pCount  = OW.int(pCount)
		pSize   = OW.int(pSize)
		if curPage>4 then firstStr = "<a class=""first"" href="""& replace(url,"{$page}",1) &""">"& lang_page(5) &"</a>"
		if curPage>1 then prevStr = "<a class=""prev"" href="""& replace(url,"{$page}",curPage-1) &""">"& lang_page(1) &"</a>"
		if curPage>1 then a=1 : if curPage>2 then a=2
		for p=curPage-a to curPage-1
			prevpagesStr = prevpagesStr &"<a class=""prev-pages"" href="""& replace(url,"{$page}",p) &""">"& p &"</a>"
		next
		if curPage>0 then
			currentStr = "<span class=""current"">"& curPage &"</span>"
		end if
		for p=curPage+1 to curPage+3
			if p>pCount then exit for
			nextpagesStr = nextpagesStr &"<a class=""next-pages"" href="""& replace(url,"{$page}",p) &""">"&p&"</a>"
		next
		if not(curPage=pCount or curPage>pCount) then nextStr = "<a class=""next"" href="""& replace(url,"{$page}",curPage+1) &""">"& lang_page(2) &"</a>"
		if (pCount - curPage) > 3 then lastStr = "<a class=""last"" href="""& replace(url,"{$page}",pCount) &""">"& lang_page(6) &"</a>"
		allpagesStr = "<span class=""unlink allpages"">"& replace(lang_page(3),"{$n}",pCount) &"</span>"
		recordsStr  = "<span class=""unlink records"">"& replace(lang_page(0),"{$n}",rsCount) &"</span>"
		perpageStr  = "<span class=""unlink perpage"">"& replace(lang_page(4),"{$n}",pSize) &"</span>"
		if OW.isNul(tType) then
			s = prevStr & firstStr & prevpagesStr & currentStr & nextpagesStr & nextStr & lastStr & allpagesStr & recordsStr & perpageStr
		else
			s = tType
			s = replace(s,"{prev}",prevStr)
			s = replace(s,"{first}",firstStr)
			s = replace(s,"{prevpages}",prevpagesStr)
			s = replace(s,"{current}",currentStr)
			s = replace(s,"{nextpages}",nextpagesStr)
			s = replace(s,"{next}",nextStr)
			s = replace(s,"{last}",lastStr)
			s = replace(s,"{allpages}",allpagesStr)
			s = replace(s,"{records}",recordsStr)
			s = replace(s,"{perpage}",perpageStr)
		end if
		createPages = s
	end function
	public function searchKeywords(byval isShop)
		dim link,kw,rs,s
		isShop = OW.int(isShop)
		set rs = OW.DB.getRecordBySQL("SELECT top 8 keyword FROM "& DB_PRE &"search_keywords WHERE is_shop="& isShop &" AND status=0 AND "& OW.DB.auxSQL &"")
		do while not rs.eof
			kw = rs("keyword")
			link = OW.urlRewrite("search")
			link = replace(link,"{$is_shop}",isShop)
			link = replace(link,"{$keyword}",kw)
			link = replace(link,"{$page}",1)
			s  = s &"<a href="""& link &""" target=""_blank"">"& kw &"</a>"
			rs.movenext
		loop
		OW.DB.closeRs rs
		searchKeywords = s
	end function
	public function vfield(byval s)
		iL = instr(s,".")
		if iL>=1 then
			s = mid(s,iL+1)
		end if
		vfield = s
	end function
end Class
%>
