<%
'**
' 网站前台初始化加载程序
' 网站前台界面数据输出应用放在此类
' author: Lin Xiaodong
' copyright: OpenWBS
'**
dim UC,UCCLASS,SAVE,RETURN_TYPE
set UC = new UC_Class
Class UC_Class
	
	public lang,errMsg,errorLink,actionLink,runMsg,runMsgCount,runAuxJSON
	public footerEchoCount,headerEchoCount,breadcrumbEchoCount,runDisplayIsEcho
	public actionFinishSuccess,actionFinishSuccessText,actionFinishFailText
	private aArr,oRs,sSQL,iI,iJ,sHtml,sString
	
	private sub class_initialize()
		runDisplayIsEcho = true
		footerEchoCount  = 0
		headerEchoCount  = 0
		runMsgCount      = 0
		set lang   = server.createObject(OW.dictName)
		set errMsg = server.createObject(OW.dictName)
		set runMsg = server.createObject(OW.dictName)
	end sub
	
	private sub class_terminate()
		set lang = nothing
	end sub
	
	public sub init()
		'**
		SAVE        = CBool(OW.regReplace(OW.getForm("get","save"),"[^a-z]","")="true")'所有需要保存数据到数据库的操作都必须SAVE=true
		RETURN_TYPE = OW.regReplace(OW.getForm("get","return_type"),"[^a-z]","")'输出数据格式(默认为html,可以指定为json)
		'**加载用户中心语言文件
		call OS.includeLanguageFile("uc.lang.asp")
		'**入口凭证处理
		select case CTL
		case "finance","point","setting","system_msg","password","orders","favorite","coupon"
		case else
			CTL = "index"
			ACT = "view"
		end select
	end sub
	
	public function actionFinishRun()
		dim s,json,links
		runMsgCount = runMsgCount + 1
		if RETURN_TYPE="json" then
			if actionFinishSuccess then
				s    = "{""message"":"""& OW.escape(actionFinishSuccessText(0)) &"""}"
				json = "{""result"":""success"",""messages"":["& s &"]"& OW.iif(runAuxJSON<>"",","& runAuxJSON,"") &"}"
			else
				s    = "{""message"":"""& OW.escape(actionFinishFailText(0)) &"""}"
				json = "{""result"":""failed"",""messages"":["& s &"]"& OW.iif(runAuxJSON<>"",","& runAuxJSON,"") &"}"
			end if
			runMsg(runMsgCount) = json
		else
			if actionFinishSuccess then
				s = s &"<div class=""display-site-name""><a href="""& SITE_URL &""">"& SITE_NAME &"</a></div><div class=""action-display success"" result=""success"" name=""display""><h3>操作结果信息</h3><div class=""action-message"">"& actionFinishSuccessText(0) &"</div><div class=""buttons"" name=""buttons"">"& UC.actionLinks(actionFinishSuccessText(1)) &"</div></div>"
				s = s &"<script type=""text/javascript"">$(document).ready(function(){UC.runDisplay();});</script>"
			else
				s = s &"<div class=""display-site-name""><a href="""& SITE_URL &""">"& SITE_NAME &"</a></div><div class=""action-display failed"" result=""failed"" name=""display""><h3>操作结果信息</h3><div class=""action-message"">"& actionFinishFailText(0) &"</div><div class=""buttons"" name=""buttons"">"& UC.actionLinks(actionFinishFailText(1)) &"</div></div>"
				s = s &"<script type=""text/javascript"">$(document).ready(function(){UC.runDisplay();});</script>"
			end if
			runMsg(runMsgCount) = s
		end if
	end function
	
	public function actionLinks(byval links)
		dim i,arr,s
		if isArray(links) then
			for i=0 to ubound(links)
				arr = split(links(i),">")
				s = s & "<a class=""btn"& OW.iif(i=0," btn-primary","") &""" href="""& arr(1) &""">"& arr(0) &"</a>"
			next
		else
			if links<>"" then
				if instr(links,">")>0 then
					arr = split(links,">")
					s = "<a class=""btn btn-primary"" href="""& arr(1) &""">"& arr(0) &"</a>"
				else
					s = "<a class=""btn btn-primary"" href="""& links &""">确定</a>"
				end if 
			else
				s = "<a class=""btn btn-primary"" href=""javascript:OW.goBack();"">返回</a>"
			end if
		end if
		actionLinks = s
	end function
	
	public function run()
		dim f
		'**
		if LOGINED then
			if OW.isMobile then
				if (CTL="setting" or CTL="password") and OW.config("is_user_mobile_open")=1 and OW.isNul(MOBILE) then
					call redirect(SITE_URL &"ow-ucenter/reg.boot.asp?ctl=set_mob_and_pw")
				end if
			else
			    if OW.config("is_user_mobile_open")=1 and OW.isNul(MOBILE) then
					call redirect(SITE_URL &"ow-ucenter/reg.boot.asp?ctl=set_mob_and_pw")
				end if
			end if
		end if
		if OW.isMobile then
			f = "ow-ucenter/mobile/"& CTL &".class.asp"
		else
			f = "ow-ucenter/pc/"& CTL &".class.asp"
		end if
		UCCLASS    = "UC_"& ucase(CTL)
		if UC.valid() then
			call OW.include(f)
			execute("set "& UCCLASS &" = new "& UCCLASS &"_CLASS")
			execute(""& UCCLASS &".init()")
		end if
		call runDisplay()
	end function
	
	'输出运行结果
	public function runDisplay()
		dim i,s,json
		if OW.isArray(errMsg) then
			if RETURN_TYPE="json" then
				for i=0 to ubound(errMsg)
					if i=ubound(errMsg) then
						s = s &"{""message"":"""& OW.escape(errMsg(i)) &"""}"
					else
						s = s &"{""message"":"""& OW.escape(errMsg(i)) &"""},"
					end if
				next
				json = "{""result"":""error"",""messages"":["& s &"]}"
				echo json
			else
				for i=0 to ubound(errMsg)
					s = s &"<li>"& errMsg(i) &"</li>"
				next
				s = "<div class=""display-site-name""><a href="""& SITE_URL &""">"& SITE_NAME &"</a></div><div class=""error-display"" name=""display""><h3>错误提示</h3><ul>"& s &"</ul>"&"<div class=""buttons"" name=""buttons"">"& UC.actionLinks(errorLink) &"</div></div>"
				s = s &"<script type=""text/javascript"">$(document).ready(function(){//UC.runDisplay();});</script>"
				call echoHeader()
				echo s
				call echoFooter()
			end if
		else
			if runDisplayIsEcho then
				if RETURN_TYPE<>"json" then call UC.echoHeader()
				for i=1 to runMsgCount
					s = s & runMsg(i)
				next
				echo s
				if RETURN_TYPE<>"json" then call UC.echoFooter()
			end if
		end if
	end function
	
	'运行错误
	'UC.errorLink = array("立即登陆>login.asp","返回>login.asp")
	'UC.errorSetting("请先登陆！")
	public function errorSetting(byval msg)
		dim k
		if OW.isArray(errMsg) then
			k = ubound(errMsg) + 1
			redim preserve errMsg(k) : errMsg(k) = msg
		else
			redim errMsg(0) : errMsg(0) = msg
		end if
	end function
	
	public function echoFooter()
		if footerEchoCount<1 then
			footerEchoCount = 1
			echo UC.footer()
		end if
	end function
	
	public function echoHeader()
		if headerEchoCount<1 then
			headerEchoCount = 1
			echo UC.header()
		end if
	end function
	
	public function footer()
		sHtml = "</body>"&vbCrLf
		sHtml = "</html>"&vbCrLf
		footer = sHtml
	end function
	
	public function header()
		sHtml = "<!DOCTYPE HTML>"&vbCrLf
		sHtml = sHtml &"<html>"&vbCrLf
		sHtml = sHtml &"<head>"&vbCrLf
		if OW.isMobile then
			sHtml = sHtml &"<meta charset=""UTF-8"">"
		else
			sHtml = sHtml &"<meta http-equiv=""Content-Type"" content=""text/html; charset=utf-8"">"&vbCrLf
		end if
		sHtml = sHtml &"<title>用户中心 - "& SITE_NAME &"</title>"&vbCrLf
		sHtml = sHtml &"<meta name=""keywords"" content=""用户中心"" />"&vbCrLf
		sHtml = sHtml &"<meta name=""description"" content=""用户中心"" />"&vbCrLf
		if OW.isMobile then
			sHtml = sHtml &"<meta name=""viewport"" content=""width=device-width, initial-scale=1.0, minimum-scale=1.0, maximum-scale=1.0, user-scalable=no""/>"&vbCrLf
			sHtml = sHtml &"<meta name=""format-detection"" content=""telephone=no, email=no"">"&vbCrLf
			sHtml = sHtml &"<meta name=""apple-mobile-web-app-title"" content="""& SITE_NAME &""" />"&vbCrLf
		end if
		sHtml = sHtml &"<meta name=""generator"" content=""OpenWBS X2.0"" />"&vbCrLf
		sHtml = sHtml &"<meta name=""author"" content=""OpenWBS Team"" />"&vbCrLf
		sHtml = sHtml &"<meta name=""copyright"" content=""2008-2020 OpenWBS Inc."" />"&vbCrLf
		if OW.isMobile then
			sHtml = sHtml &"<link rel=""stylesheet"" href=""css/mobile.css"" />"&vbCrLf
			sHtml = sHtml &"<link rel=""stylesheet"" href=""css/mobile.ucenter.css"" />"&vbCrLf
			sHtml = sHtml &"<script type=""text/javascript"" src=""../ow-content/js/mobile/jquery.js""></script>"&vbCrLf
			sHtml = sHtml &"<script type=""text/javascript"" src=""../ow-content/js/mobile/ow.js""></script>"&vbCrLf
			sHtml = sHtml &"<script type=""text/javascript"" src=""js/mobile.ucenter.js""></script>"&vbCrLf
		else
			sHtml = sHtml &"<link rel=""stylesheet"" href=""css/ucenter.css"" />"&vbCrLf
			sHtml = sHtml &"<script type=""text/javascript"" src=""../ow-content/js/pc/jquery.js""></script>"&vbCrLf
			sHtml = sHtml &"<script type=""text/javascript"" src=""../ow-content/js/pc/ow.js""></script>"&vbCrLf
			sHtml = sHtml &"<script type=""text/javascript"" src=""js/ucenter.js""></script>"&vbCrLf
		end if
		
		sHtml = sHtml &"<script type=""text/javascript"">"&vbCrLf
		sHtml = sHtml &"OW.debug    = """& lcase(DEBUG) &"""==""true"" ? true : false;"&vbCrLf
		sHtml = sHtml &"OW.logined  = """& lcase(LOGINED) &"""==""true"" ? true : false;"&vbCrLf
		sHtml = sHtml &"OW.sitePath = """& SITE_PATH &""";"&vbCrLf
		sHtml = sHtml &"OW.siteUrl  = """& SITE_URL &""";"&vbCrLf
		sHtml = sHtml &"OW.siteHurl = """& SITE_HURL &""";"&vbCrLf
		sHtml = sHtml &"OW.siteHtmlFileSuffix  = """& SITE_HTML_FILE_SUFFIX &""";"&vbCrLf
		sHtml = sHtml &"OW.ucenterHurl = """& UCENTER_HURL &""";"&vbCrLf
		sHtml = sHtml &"OW.cookie.cookiePre    = """& COOKIE_PRE &""";"&vbCrLf
		sHtml = sHtml &"OW.cookie.cookieDomain = """& COOKIE_DOMAIN &""";"&vbCrLf
		sHtml = sHtml &"OW.cookie.cookiePath   = """& COOKIE_PATH &""";"&vbCrLf
		sHtml = sHtml &"UC.ctl = """& CTL &""";"&vbCrLf
		sHtml = sHtml &"UC.act = """& ACT &""";"&vbCrLf
		sHtml = sHtml &"</script>"&vbCrLf
		sHtml = sHtml &"</head>"&vbCrLf
		sHtml = sHtml &"<body>"&vbCrLf
		header = sHtml
	end function
	
	public function htmlHeader()
		dim s
		s = "<div id=""header"">"
		s = s &"<div class=""toper"">"
		s = s &"<div class=""wrapper"">"
		s = s &"<div class=""account-sign-status"">"
		s = s &"<a class=""username"" href=""index.asp"">"& USERNAME &"</a><a href="""& UCENTER_HURL &"ctl=setting"">设置</a><a href="""& UCENTER_HURL &"ctl=password"">修改密码</a><a href="""& SITE_HURL &"logout"& SITE_HTML_FILE_SUFFIX &""">退出系统</a>"
		s = s &"</div>"
		s = s &"<div class=""logo""><a href="""& SITE_URL &""" title="""& SITE_NAME &""">"& OW.iif(OW.config("site_ucenter_logo")="","<span>"& SITE_NAME &"</span>","<img src="""& OW.config("site_ucenter_logo") &""" />") &"</a></div>"
		s = s & htmlUCNav
		s = s &"</div>"
		s = s &"</div>"
		s = s &"</div>"
		htmlHeader = s
	end function
	
	public function htmlHeaderMobile(byval l,byval t)
		dim s
		s = s &"<header class=""om-header"">"& l &"<div class=""title"">"& t &"</div>"
        s = s &"<a class=""menu"" id=""top_menu"" href=""javascript:;""></a>"
        s = s &"<div class=""menu-section"" id=""top_menu_section"" style=""display:none;"">"
		s = s &"<div class=""close""><a href=""javascript:;"" id=""top_menu_close""></a></div>"
		s = s & htmlUCNav()
        s = s &"</div>"
		s = s &"</header>"
		s = s &"<script type=""text/javascript"">$(document).ready(function(){UC.menu();});</script>"
		htmlHeaderMobile = s
	end function
	
	public function htmlFooter()
		dim s
		if OW.isMobile then
			s = htmlFooterMobile()
		else
			s = htmlFooterPC()
		end if
		htmlFooter = s
	end function
	
	public function htmlFooterMobile()
		dim i,navIcon,navLink,navName,rs,sb,str : set sb = OW.stringBuilder()
		sb.append "<footer class=""om-footer"">"
		sb.append "<div class=""powered""><a href=""http://www.openwbs.com/"" target=""_blank"">OpenWBS 建站系统</a> "& OW_VERSION &" , "& OW.runTime &" s , "& OW.DB.SQLQueryNum &" queries</div>"
		sb.append "</footer>"
		sb.append "<nav class=""om-nav"" id=""om_nav"">"
		sb.append "<ul class=""base"" id=""om_nav_base"">"
		i = 0
		set rs = OW.DB.getRecordBySQL("SELECT * FROM "& DB_PRE &"navigator WHERE type=5 AND status=0 AND parent_id=0 AND "& OW.DB.auxSQL &" ORDER BY sequence ASC")
		do while not rs.eof
			i = i + 1
			navIcon = rs("icon")
			navLink = rs("url")
			navLink = replace(navLink,"{$site_url}",SITE_URL)
			navLink = replace(navLink,"{$site_hurl}",SITE_HURL)
			navName = rs("name")
			sb.append "<li class=""n1"" n1=""true"" i="""& i &""" url="""& navLink &"""><a class=""n1"" href="""& navLink &""" style=""background-image:url("& navIcon &");"">"& navName &"</a></li>"
			rs.movenext
		loop
		OW.DB.closeRs rs
		sb.append "<li class=""n1 more""><a class=""n1 more"" id=""om_nav_more_btn"" href=""javascript:;"">更多</a></li>"
		sb.append "</ul>"
		sb.append "<ul class=""more"" id=""om_nav_more""><li class=""n1 close""><a class=""n1 close"" name=""close"" href=""javascript:;"">关闭</a></ul>"
		sb.append "</nav>"
		sb.append "<script type=""text/javascript"">"
		sb.append "$(document).ready(function(){"
		sb.append "UC.navMore({baseNav:$(""#om_nav_base""),moreBtn:$(""#om_nav_more_btn""),moreNav:$(""#om_nav_more""),baseNum:4});"
		sb.append "UC.navInit();"
		sb.append "});"
        sb.append "</script>"
		str = sb.toString() : set sb = nothing
		htmlFooterMobile = str
	end function
	
	public function htmlFooterPC()
		dim sb,str : set sb = OW.stringBuilder()
		sb.append "<div id=""footer"">"
		sb.append "<div class=""wrapper"">"
		sb.append "<div class=""powered-by"">"& SITE_NAME &" Powered by <a href=""http://www.openwbs.com/"" target=""_blank"">OpenWBS 建站系统</a> "& OW_VERSION &",<span>Processed in "& OW.runTime &" second(s),</span><span>"& OW.DB.SQLQueryNum &" queries</span></div>"
		sb.append "</div>"
		sb.append "</div>"
		sb.append "<script type=""text/javascript"">"
		sb.append "$(document).ready(function(){UC.init();});"
		sb.append "</script>"
		str = sb.toString() : set sb = nothing
		htmlFooterPC = str
	end function
	
	
	public function htmlUCNav()
		dim rs,s,url
		set rs = OW.DB.getRecordBySQL("SELECT * FROM "& DB_PRE &"navigator WHERE type=4 AND status=0 AND parent_id=0 AND "& OW.DB.auxSQL &" ORDER BY sequence ASC")
		do while not rs.eof
			url = OW.rs(rs("url"))
			url = OW.reps(url,"{$site_url}",SITE_URL)
			url = OW.reps(url,"{$site_hurl}",SITE_HURL)
			s = s &"<li><a href="""& url &""">"& rs("name") &"</a></li>"
			rs.movenext
		loop
		OW.DB.closeRs rs
		if not(OW.isNul(s)) then
			s = "<ul class=""top-nav"" name=""top-nav"">"& s &"</ul>"
		end if
		htmlUCNav = s
	end function
	
	public function htmlSider()
		dim sb,str : set sb = OW.stringBuilder()
		sb.append "<div id=""sidebar"">"
		sb.append "<div class=""heading""></div>"
		sb.append "<div class=""uc-sidenav"">"
		sb.append "<ul>"
		sb.append "<li name=""index""><a href="""& UCENTER_HURL &"ctl=index"">个人中心</a></li>"
		if OS.versionType="x" then
			sb.append "<li name=""orders""><a href="""& UCENTER_HURL &"ctl=orders"">我的订单</a></li>"
		end if
		sb.append "<li name=""finance""><a href="""& UCENTER_HURL &"ctl=finance"">我的预存款</a></li>"
		sb.append "<li name=""point""><a href="""& UCENTER_HURL &"ctl=point"">我的积分</a></li>"
		if OS.versionType="x" then
			sb.append "<li name=""coupon""><a href="""& UCENTER_HURL &"ctl=coupon"">我的优惠券</a></li>"
			sb.append "<li name=""favorite""><a href="""& UCENTER_HURL &"ctl=favorite"">我收藏的商品</a></li>"
		end if
		sb.append "<li name=""setting""><a href="""& UCENTER_HURL &"ctl=setting"">资料设置</a></li>"
		sb.append "<li name=""system_msg""><a href="""& UCENTER_HURL &"ctl=system_msg"">消息中心</a></li>"
		sb.append "</ul>"
		sb.append "</div>"
		sb.append "</div>"
		str = sb.toString() : set sb = nothing
		htmlSider = str
	end function
	
	'后台所有的应用都必须经过此验证有效后才可以执行
	public function valid()
		dim check : check = true
		'**合法客户端检查
		if SAVE and not OW.validClientPost() then
			check = false
			call errorSetting("请勿试图从本站外部提交数据，此次请求已被拦截！")
		end if
		'**用户是否登陆检查
		if not LOGINED then
			check = false
			UC.errorLink = array("立即登陆>"& OW.urlRewrite("l1") &"","返回>"& OW.urlRewrite("l1") &"")
			UC.errorSetting("您的登陆信息已注销，请先登陆！")
		end if
		'**权限检查
		valid = check
	end function
	
	
end Class
%>