﻿<%
dim UC_SETTING
class UC_SETTING_CLASS
	
	private oRs,sSQL,sString
	
	private sub class_initialize()
	end sub
	
	public sub init()
		select case ACT
		case "edit"
			if SAVE then
				call settingSave()
			else
				call setting()
			end if
		case "avatar"
			if SUBACT = "uploading" then
				call avatarUploading()
			else
				call avatarSetting()
			end if
		case else
			call setting()
		end select
	end sub
	
	private sub class_terminate()
	end sub
	
	private function avatarSetting()
	call UC.echoHeader()
%>
	<%=UC.htmlHeader()%>
    <div id="mbody">
	  <%=UC.htmlSider()%>
      <div id="container">
        <div class="avatar-set-body"> 
          <!--upload avatar-->
          <div class="avatar-upload">
              <div class="avatar-view-section">
                  <div class="header">您当前头像</div>
                <div class="section"><img name="photoview" src="" alt="头像"></div>
              </div>
              <div class="avatar-do-section">
                  <div class="header">上传新头像</div>
                  <div class="section">
                      <div class="upload-tip">
                      请上传jpg、jpeg、gif、png、bmp格式的形象照片.<br />
                      并且大小最好不要不能超过500k. 
                      </div>
                      <div class="upload-do">
                          <form method="post" name="uploadform" enctype="multipart/form-data" target="uploadloader">
                            <p><input type="file" class="file file-input" name="avatar" /></p>
                            <p><button type="button" class="btn btn-primary btn-large" name="btn-avatar-upload">开始上传</button></p>
                          </form>
                      </div>
                    <iframe name="uploadloader" style="display:none; width:400px; margin:10px 0px;"></iframe>
                  </div>
              </div>
          </div>
          <script language="javascript" type="text/javascript">
		  var $dialog;
          $(document).ready(function(){
			  var avatar = "<%=AVATAR%>";
			  $("img[name='photoview']").attr("src",avatar +"?r="+OW.random());
			  $("button[name='btn-avatar-upload']").click(function(){
				  OW.setDisabled($(this),true);
				  $("form[name='uploadform']").attr("action","index.asp?ctl=setting&act=avatar&subact=uploading");
				  $("form[name='uploadform']").submit();
				  $dialog = OWDialog({content:'<div class="posting">头像上传中 ... </div>',follow:$(this)}).shadowBackground("none");
			  });
          });
		  function uploadResult(msg){
			  var text = "";
			  var size = "1M";
			  msg = msg.toUpperCase();
			  if(msg=="SUCCESS"){
				  $dialog.success("头像上传成功！").timeout(2);
				  OW.redirect("index.asp?ctl=setting&act=avatar",0);
			  }else{
				  if(msg=="NOT_LOINED"){
					  text = "请先登陆！";
				  }else if(msg=="OUT_OF_ALLOWED_NUM"){
					  text = "您最多只能上传20张照片.";
				  }else if(msg=="HAVE_NOT_BYTES"){
					  text = "请不要上传空文件！";
				  }else if(msg=="UPLOAD_DATA_OVER_MAXTOTALSIZE "){
					  text = "上传文件总大小超过系统允许总大小！";
				  }else if(msg=="SYSTEM_NONSUPPORT_ADODB_STREAM"){
					  text = "当前网站服务器不支持ADODB.STREAM，无法保存头像！";
				  }else if(msg=="FILE_OVER_MAXSIZE"){
					  text = "请不要上传大于"+ size +"的照片！";
				  }else if(msg=="ILLEGAL_TYPE_OF_FILE"){
					  text = "照片上传失败！\n\n照片类型错误，请用photoshop或其他图片处理软件处理一下，另存为.jpg格式的照片后再上传。";
				  }else if(msg=="GET_UPLOAD_DATA_ERROR"){
					  text = "获取上传文件失败！\n\n照片的编码格式有问题，请用photoshop或其他图片处理软件处理一下，另存为.jpg格式的照片后再上传。";
				  }else if(msg=="HAVE_NOT_UPLOAD_ANY_FILE"){
					  text = "请选择要上传的照片！";
				  }else if(msg=="UPLOAD_FILES_OVER_THE_INCEPTMAXFILE"){
					  text = "上传的照片太大！";
				  }else if(msg=="SAVETOFILE_ERROR"){
					  text = "保存照片失败！";
				  }else if(msg=="THIS_FILE_IS_NULL"){
					  text = "请选择要上传的照片！";
				  }else{
					   text = "头像上传失败！";
				  };
				  $dialog.error(text).timeout(2);
			  };
			  OW.setDisabled($("button[name='btn-avatar-upload']"),false);
		  };
          </script> 
          <!--upload avatar:end--> 
        </div>
      </div>
    </div>
    <%=UC.htmlFooter()%>
<%
	call UC.echoFooter()
	end function
	
	private function avatarUploading()
%>
	<script type="text/javascript">
    function uploadResult(msg){
		parent.uploadResult(msg);
    }
    </script>
<%
	dim UploadSave
	set UploadSave = New Class_UploadSave
		UploadSave.Init()
	call OW.echoJsCode("uploadResult('"& UploadSave.message &"')")
	set UploadSave = nothing
%>
<%
	end function
	
	private function setting()
	call UC.echoHeader()
%>
	<%=UC.htmlHeader()%>
    <div id="mbody">
	  <%=UC.htmlSider()%>
      <div id="container">
          <h1 class="header">资料设置</h1>
          <form class="form-horizontal" name="reg-form">
              <div class="control-group">
                  <label class="control-label">用户名</label>
                  <div class="controls"><%=USERNAME%></div>
              </div>
              <div class="control-group">
                  <label class="control-label">Email</label>
                  <div class="controls"><%=EMAIL%></div>
              </div>
              <div class="control-group">
                  <label class="control-label">手机</label>
                  <div class="controls"><%=MOBILE%></div>
              </div>
              <div class="control-group">
                  <label class="control-label">昵称</label>
                  <div class="controls"><input type="text" class="text" name="nickname" placeholder="" value="<%=NICKNAME%>" ></div>
              </div>
              <div class="control-group">
                  <label for="username" class="control-label">会员组</label>
                  <div class="controls"><%=OS.getGroupName(GROUP_ID)%></div>
              </div>
              <% if SPECIAL_GROUP_ID>0 then %>
              <div class="control-group">
                  <label for="username" class="control-label">特殊会员组</label>
                  <div class="controls"><%=OS.getGroupName(SPECIAL_GROUP_ID)%></div>
              </div>
              <% end if %>
              <div class="control-group">
                  <div class="controls controls-btn">
                      <button type="button" class="btn btn-primary" name="btn_save">提交保存</button>
                  </div>
              </div>
          </form>
      </div>
    </div>
    <script type="text/javascript">
    $(document).ready(function(){
		$("button[name='btn_save']").click(function(){settingSave();});
		function settingSave(){
			OW.setDisabled($("button[name='btn_save']"),true);
			//**
			var errMsg,
			url       = "index.asp?ctl=setting&act=edit&save=true",
			valid     = true,
			$dialog   = OWDialog().posting(),
			$nickname = $("input[name='nickname']"),
			nickname  = $nickname.val();
			//**
			if(nickname=="" && valid){
				valid = false;
				$nickname.addClass("text-err").focus();
			}else{
				$nickname.removeClass("text-err");
			};
			//**
			if(valid){
				OW.ajax({
					me:"",url:url,data:"nickname="+escape(nickname),
					success:function(){
						$dialog.success("修改成功，正在刷新页面...");
						OW.setDisabled($("button[name='btn_save']"),false);
						OW.refresh();
					},
					failed:function(msg){
						$dialog.error('亲，很抱歉，修改失败，请查看以下错误信息',msg).timeout(4);
						OW.setDisabled($("button[name='btn_save']"),false);
					}
				});
			}else{
				$dialog.close();
				OW.setDisabled($("button[name='btn_save']"),false);
			};
		};
	});
    </script>
    <%=UC.htmlFooter()%>
<%
	call UC.echoFooter()
	end function
	
	private function settingSave()
		dim result,valid
		result = true
		valid  = true
		V("nickname") = OW.validClientDBData(OW.getForm("post","nickname"),32)
		if V("nickname")="" then
			UC.errorSetting("昵称不能为空")
			valid = false
		end if
		if valid then
			OW.DB.auxSQLValid = false
			result = OW.DB.updateRecord(DB_PRE &"member",array("nickname:"& V("nickname")),array("uid:"& UID))
			OW.DB.auxSQLValid = true
			UC.actionFinishSuccess     = result
			UC.actionFinishSuccessText = array("提交保存成功","")
			UC.actionFinishFailText    = array("提交保存失败","")
			UC.actionFinishRun()
		end if
	end function
	
end class

%>
<%

Class Class_UploadSave
	private UPLOAD
	private sMesssage,sURL,oFile,sFormName,sUploadPath,sAbsFilePath,sFileName,sUploadResult
	
	private sub Class_Initialize
	end sub
	private sub Class_Terminate
		set UPLOAD = nothing
	end sub
	public property get message : message = sMesssage : end property

	public sub init()
		sUploadPath  = OS.defAvatarRoot
		sAbsFilePath = OW.FSO.ABSPath(sUploadPath) &"\"
		'上传类
		set UPLOAD = New UPLOAD_CLASS
		UPLOAD.inceptMaxFile = 1
		UPLOAD.maxSize       = 1000*1024
		UPLOAD.maxTotalSize  = 10000*1024
		UPLOAD.allowedExt    = "jpg|jpeg|gif|png|bmp"
		UPLOAD.uploadPath    = sAbsFilePath
		UPLOAD.getUploadData()
		'**
		if UPLOAD.isError then
			sMesssage = UPLOAD.errMessage
		else
			if not(isNull(UPLOAD.File)) then
				for each oFile in UPLOAD.File
					'sFileName     = right(OW.formatDateTime(SYS_TIME,9),12) & OW.random(5) & OW.random(3)
					sFileName      = UID
					sUploadResult = UPLOAD.saveFile(oFile,sFileName)
					if UPLOAD.isError then
						sMesssage = UPLOAD.errMessage : exit for
					else
						if sUploadResult<>false and len(sUploadResult)>1 then
							sURL = SITE_PATH & sUploadPath & sUploadResult
							call OW.DB.execute("UPDATE "& DB_PRE &"member SET avatar='"& sURL &"',avatar_big='"& sURL &"'  WHERE uid="& UID &"")
						else
							sMesssage = "UPLOAD_FAIL"
						end if
					end if
				next
			end if
		end if
		if OW.isNul(sMesssage) then
			sMesssage = "SUCCESS"
		end if
	end sub
	
end Class

'**************************************************
'HAVE_NOT_BYTES                      没有选择要上传的文件
'UPLOAD_DATA_OVER_MAXTOTALSIZE       上传文件总大小超过系统允许总大小
'SYSTEM_NONSUPPORT_ADODB_STREAM      系统不支持ADODB.STREAM
'FILE_OVER_MAXSIZE                   上传文件大小超过系统允许大小
'ILLEGAL_TYPE_OF_FILE                不允许上传此类文件
'GET_UPLOAD_DATA_ERROR               获取上传文件数据时发生错误
'HAVE_NOT_UPLOAD_ANY_FILE            没上传任何文件
'UPLOAD_FILES_OVER_THE_INCEPTMAXFILE 上传文件的个数超过系统允许一次上传的个数
'SAVETOFILE_ERROR                    保存文件时出错，检查路径是否正确或是否有有文件写入权限
'THIS_FILE_IS_NULL                   不存在该对象(如该文件没有上传,文件为空)
'**************************************************
class UPLOAD_FILEINO_CLASS
	dim fromName,fileName,filePath,fileSize,fileMIME,fileStart,fileExt
end class

class UPLOAD_CLASS
	dim Form,File
	dim bAllowedExt	          '允许上传类型(白名单)
	dim bNotAllowedExt     	  '不允许上传类型(黑名单)
	dim bIsDebug            '是否显示出错信息
	private sCharSet
	private sUploadPath         '设置保存的目录相对路径 String
	private iMaxSize            '设置单个上传文件大小上限 (单位：字节)
	private iMaxTotalSize       '设置所有上传文件总大小上限 (单位：字节)
	private iInceptMaxFile      '设置一次上传文件最大个数
	private	oADODBStream        '上传的数据流
	private bIsError	        '是否有错（true/false）
	private sErrMessage	        '错误的字符串信息
	private bIsHavedGetUploadData '指示是否已执行过getUploadData过程

	public property get isError                : isError        = bIsError : end property
	public property get errMessage             : errMessage     = sErrMessage : end property
	public property get allowedExt             : allowedExt     = bAllowExt : end property
	public property let allowedExt(s)          : bAllowedExt    = lcase(s) : end property
	public property get notAllowedExt          : notAllowedExt  = bNotAllowedExt : end property
	public property let notAllowedExt(s)       : bNotAllowedExt = lcase(s) : end property
	public property let IsDebug(s)             : bIsDebug       = s : end property
	public property let uploadPath(byval path) : sUploadPath    = path : end property
	public property get uploadPath()           : uploadPath     =  sUploadPath : end property
	public property let maxSize(byval s)       : iMaxSize       = s : end property
	public property get maxSize()              : maxSize        = iMaxSize : end property
	public property let maxTotalSize(byval s)  : iMaxTotalSize  = s : end property
	public property get maxTotalSize()         : maxTotalSize   = iMaxTotalSize : end property
	public property let inceptMaxFile(byval s) : iInceptMaxFile = s : end property
	public property get inceptMaxFile()        : inceptMaxFile  = iInceptMaxFile : end property

	private sub class_initialize
		sCharSet       = OW.charset
		iMaxSize       = 1000*1024   '默认为2M
		iMaxTotalSize  = 10000*1024  '默认为10M
		iInceptMaxFile = 5           '默认允许一次上传5个
		bIsError              = false
		bIsHavedGetUploadData = false
	end sub
	private sub class_terminate
		on error resume next
		Form.RemoveAll : set Form = nothing
		File.RemoveAll : set File = nothing
		oADODBStream.close : set oADODBStream = nothing
		if err.number<>0 then err.clear
	end sub

	'取得并分析上传的数据
	public sub getUploadData()
		on error resume next
		if bIsHavedGetUploadData=false then
			dim tolBytes,requestBinDate,fileinfo,bCrLf
			dim iInfoStart,iInfoEnd,tStream,iStart
			dim sSpace,sInfo,sFormName,sFormValue,sFileName,iFindStart,iFindEnd,iFormStart,iFormEnd
			tolBytes = request.TotalBytes
			if tolBytes < 194 then	'如果没有数据上传
				bIsError = true : sErrMessage = "HAVE_NOT_BYTES" '没有数据上传,这是因为直接提交网址所产生的错误!
				exit sub
			end if
			if tolBytes > iMaxTotalSize then
				bIsError = true : sErrMessage = "UPLOAD_DATA_OVER_MAXTOTALSIZE"
				exit sub
			end if
			set Form = server.createObject ("Scripting.Dictionary")
			    Form.CompareMode = 1
			set File = server.createObject ("Scripting.Dictionary")
			    File.CompareMode = 1
			set tStream = server.createObject ("ADODB.Stream")
			set oADODBStream = server.createObject ("ADODB.Stream")
			if err.number<>0 then
				bIsError = true : sErrMessage = "SYSTEM_NONSUPPORT_ADODB_STREAM"  '创建流对象(ADODB.STREAM)时出错,可能系统不支持或没有开通该组件
				exit sub
			end if
			oADODBStream.type = 1
			oADODBStream.mode = 3
			oADODBStream.open
			oADODBStream.write request.binaryRead(tolBytes)'转成二进制
			oADODBStream.Position = 0
			requestBinDate = oADODBStream.Read
			bCrLf = ChrB (13) & ChrB (10) '回车符{Enter}和换行符
			'取得每个项目之间的分隔符
			sSpace = MidB(requestBinDate,1,InStrB(1,requestBinDate,bCrLf)-1)
			iFormEnd   = oADODBStream.size '字节总长度
			iStart     = LenB(sSpace)        '项目开始字节位置(包括分隔符)
			iFormStart = iStart+2            '项目开始字节位置(不包括分隔符)
			'分解项目
			do While (iFormStart+2) < iFormEnd
				iInfoEnd = InStrB (iFormStart,requestBinDate,bCrLf & bCrLf)+3
				tStream.type = 1
				tStream.mode = 3
				tStream.open
				oADODBStream.Position = iFormStart
				oADODBStream.CopyTo tStream,iInfoEnd-iFormStart
				tStream.Position = 0
				tStream.type     = 2
				tStream.charset  = sCharSet
				sInfo = tStream.ReadText
				'取得表单项目名称
				iFormStart = InStrB (iInfoEnd,requestBinDate,sSpace)-1
				iFindStart = instr (22,sInfo,"name=""",1)+6
				iFindEnd   = instr (iFindStart,sInfo,"""",1)
				sFormName  = mid(sinfo,iFindStart,iFindEnd-iFindStart)
				'如果是文件
				if instr(45,sInfo,"filename=""",1) > 0 then
					set fileinfo = New UPLOAD_FILEINO_CLASS
					'取得文件属性
					iFindStart = instr (iFindEnd,sInfo,"filename=""",1)+10
					iFindEnd   = instr (iFindStart,sInfo,""""&vbCrLf,1)
					sFileName  = trim(mid(sinfo,iFindStart,iFindEnd-iFindStart))
					fileinfo.filePath = OW.getFolderPath(sFileName)
					fileinfo.fileName = OW.getFileName(sFileName,true)
					fileinfo.fileExt  = OW.getFileExName(sFileName)
					iFindStart         = instr (iFindEnd,sInfo,"Content-type: ",1)+14
					iFindEnd           = instr (iFindStart,sInfo,vbCr)
					fileinfo.fileMIME = mid(sinfo,iFindStart,iFindEnd-iFindStart)
					fileinfo.fileStart= iInfoEnd
					fileinfo.fileSize = iFormStart -iInfoEnd -2
					fileinfo.fromName = sFormName
					'如果不是空文件则添加一个文件字典
					if fileinfo.fileSize>0 then
						if isAllowedExt(fileinfo.fileExt) then
							if fileinfo.fileSize > iMaxSize then
								bIsError = true : sErrMessage = "FILE_OVER_MAXSIZE"
							else
								File.Add sFormName,fileinfo
							end if
						else
							bIsError = true : sErrMessage = "ILLEGAL_TYPE_OF_FILE"
						end if
					end if
					set fileinfo = nothing
				else
				'如果是表单项目
					tStream.close
					tStream.type = 1
					tStream.mode = 3
					tStream.open
					oADODBStream.Position = iInfoEnd
					oADODBStream.CopyTo tStream,iFormStart-iInfoEnd-2
					tStream.Position = 0
					tStream.type     = 2
					tStream.charset  = sCharSet
					sFormValue = tStream.ReadText
					if not(OW.IsNul(sFormValue)) then
						if Form.Exists(sFormName) then
							Form(sFormName) = Form (sFormName) &", "& sFormValue
						else
							Form.Add sFormName,sFormValue
						end if
					end if
				end if
				tStream.close
				iFormStart = iFormStart+iStart+2
				'如果到文件尾了就退出
			loop
			if err.number<>0 then
				bIsError = true : sErrMessage = "GET_UPLOAD_DATA_ERROR"  '分解上传数据时发生错误,可能客户端的上传数据不正确或不符合上传数据规则
				exit sub
			end if
			requestBinDate = ""
			set tStream    = nothing
			bIsHavedGetUploadData = true
		end if
		if not(File.Count>0) then
			if bIsError<>true then
				bIsError    = true : sErrMessage = "HAVE_NOT_UPLOAD_ANY_FILE"
				exit sub
			end if
		end if
		if File.Count>iInceptMaxFile then
			bIsError    = true
			sErrMessage = "UPLOAD_FILES_OVER_THE_INCEPTMAXFILE"
		end if
	end sub

	'保存到文件,自动覆盖已存在的同名文件
	public function saveFile(item,fileName)
		saveFile = saveToFile(item,fileName,true)
	end function

	'保存到文件,fileName不包含后缀名,overwrite为真时,自动覆盖已存在的同名文件,否则自动把文件改名保存
	private function saveToFile(item,fileName,overwrite)
		'on error resume next
		dim i,fileExt,ADOStream,filePath
		i = 1
		if File.exists(item) then
			bIsError       = false
			set ADOStream  = server.createObject("ADODB.Stream")
			ADOStream.type = 1
			ADOStream.mode = 3
			ADOStream.open
			oADODBStream.Position = File(item).fileStart
			oADODBStream.copyTo ADOStream,File(item).fileSize
			oADODBStream.close
			set oADODBStream = nothing
			fileExt = File(item).fileExt
			'**
			if overwrite then
				if isAllowedExt(fileExt) then
					filePath = sUploadPath & fileName &"."& fileExt
					ADOStream.saveToFile filePath,2
					if err.number<>0 then
						bIsError = true : sErrMessage = "SAVETOFILE_ERROR"  '保存文件时出错,1.检查路径是否正确;2.检查是否有文件写入权限
						exit function
					else
						'判断是否真实的图片(防止植入木马)
						if isRealImageFile(filePath)=false then
							call OW.FSO.deleteFile(OW.FSO.ABSPath(filePath))
							bIsError = true : sErrMessage = "ILLEGAL_TYPE_OF_FILE"
						end if
					end if
				else
					bIsError = true : sErrMessage = "ILLEGAL_TYPE_OF_FILE"
					exit function
				end if
			else
				if isAllowedExt(File(item).fileExt) then
					do
					    '如果不能保存文件则循环5次不同的文件名来保存
						i=i+1
						err.clear()
						filePath = sUploadPath & createFileName &"."& fileExt
						ADOStream.saveToFile filePath
					loop until ((i>5) or (err.number=0))
					if err.number<>0 then
						bIsError = true : sErrMessage = "SAVETOFILE_ERROR"
						exit function
					else
						if isRealImageFile(filePath)=false then
							call OW.FSO.DeleteFile(filePath)
							bIsError = true : sErrMessage = "ILLEGAL_TYPE_OF_FILE"
						end if
					end if
				else
					bIsError = true : sErrMessage = "ILLEGAL_TYPE_OF_FILE"
					exit function
				end if
			end if
			ADOStream.close
			set ADOStream = nothing
		else
			bIsError = true : sErrMessage = "THIS_FILE_IS_NULL" '"不存在该对象(如该文件没有上传,文件为空)!"
			exit function
		end if
		err.clear()
		if bIsError then
			saveToFile = false
		else
			saveToFile = fileName &"."& fileExt
		end if
	end function
	
	'则执行真实图片判断
	function isRealImageFile(filename)
		on error resume next
		dim result : result = false
		dim jpg(1) : jpg(0) = cbyte(&HFF) : jpg(1) = cbyte(&HD8)
		dim bmp(1) : bmp(0) = cbyte(&H42) : bmp(1) = cbyte(&H4D)
		dim png(3) : png(0) = cbyte(&H89) : png(1) = cbyte(&H50) : png(2) = cbyte(&H4E) : png(3) = cbyte(&H47)
		dim gif(5) : gif(0) = cbyte(&H47) : gif(1) = cbyte(&H49) : gif(2) = cbyte(&H46) : gif(3) = cbyte(&H39) : gif(4) = cbyte(&H38) : gif(5) = cbyte(&H61)
		dim ADOStream,fileExt,stamp,i
		fileExt = OW.getFileExName(filename)
		if fileExt="jpg" or fileExt="jpeg" or fileExt="bmp" or fileExt="gif" or fileExt="png" then
			set ADOStream=server.createobject("ADODB.Stream")
			ADOStream.open
			ADOStream.type = 1
			ADOStream.loadFromFile filename
			ADOStream.position = 0
			select case fileExt
				case "jpg","jpeg"
					stamp = ADOStream.read(2)
					for i=0 to 1
						if ascB(MidB(stamp,i+1,1))=jpg(i) then result=true else result=false
					next
				case "gif"
					stamp = ADOStream.read(6)
					for i=0 to 5
					if ascB(MidB(stamp,i+1,1))=gif(i) then result=true else result=false
					next
				case "png"
					stamp = ADOStream.read(4)
					for i=0 to 3
						if ascB(MidB(stamp,i+1,1))=png(i) then result=true else result=false
					next
				case "bmp"
					stamp = ADOStream.read(2)
					for i=0 to 1
						if ascB(MidB(stamp,i+1,1))=bmp(i) then result=true else result=false
					next
			end select
			ADOStream.close
			set ADOStream=nothing
			if err.number<>0 then result = false
		else
		   result = true
		end if
		err.clear()
		isRealImageFile = result
	end function

	public function isAllowedExt(ByVAl ext)
		dim i,arr
		ext = lcase(ext)
		if notAllowedExt="" then
			isAllowedExt = false
			arr   = Split(bAllowedExt,"|")
			for i=0 to ubound(arr)
				if ext=lcase(arr(i)) then isAllowedExt = true : exit function
			next
		else
			isAllowedExt = true
			arr   = Split(bNotAllowedExt,"|")
			for i=0 to ubound(arr)
				if ext=lcase(arr(i)) then isAllowedExt = false : exit function
			next
		end if
	end function

	'取得一个不重复的序号
	public function createFileName()
		createFileName = OW.formatDateTime(SYS_TIME,8) &"-"& OW.random(6)
	end function

end class
%>
