<%
'ļ

Class Class_OpenWBS_FSO

	Private Pv_FolderOrder
	Private Pv_CharSet,Pv_FSOName,Pv_FSO,Pv_OverWrite
	
	Private Sub Class_Initialize()
		Pv_CharSet    = OpenWBS.CharSet
		Pv_FSOName    = OpenWBS.FSOName
		Pv_OverWrite  = True
		Set Pv_FSO    = Server.CreateObject(Pv_FSOName)
		OpenWBS.Error(50) = "Folder path error."'ļ·.
		OpenWBS.Error(51) = "File path error."'ļ·.
		OpenWBS.Error(52) = "Create folder error."'ļд.
		OpenWBS.Error(53) = "Create file error."'ļ.
		OpenWBS.Error(54) = "File does not Exist."'ļ.
		OpenWBS.Error(55) = "Failed to save file."'ļʧ.
	End Sub
	
	Private Sub Class_Terminate()
		Set Pv_FSO    = nothing
	End Sub
	
	Public Property Let [CharSet](ByVal BV_String) Pv_CharSet = Ucase(BV_String) : End Property
	Public Property Get [CharSet]() [CharSet] = Pv_CharSet : End Property
	Public Property Let OverWrite(ByVal BV_Bool) Pv_OverWrite = BV_Bool : End Property
	Public Property Get OverWrite() OverWrite = Pv_OverWrite : End Property
	Public Property Get ObjectFSO() Set ObjectFSO = Pv_FSO : End Property
	
	Public Function CheckFSOInstalled()
		If OpenWBS.IsFSOInstalled = False Then
			OpenWBS.Error.Msg = "OpenWBS.FSO.CheckFSOInstalled()"
			OpenWBS.Error.Raise 1 'ϵͳ֧Scripting.FileSystemObject.
			Err.Clear()
		End If
	End Function
	
	'ļǷ
	Public Function FileExists(ByVal BV_FilePath)
		BV_FilePath = ABSPath(BV_FilePath)
		If OpenWBS.IsFSOInstalled Then
			If Pv_FSO.FileExists(BV_FilePath) Then FileExists = True
		Else
			FileExists = False
			OpenWBS.Error.Msg = "OpenWBS.FSO.FileExists("""& BV_FilePath &""")"
			OpenWBS.Error.Raise 1
			Err.Clear()
		End If
	End Function
	
	'ļǷ
	Public Function FolderExists(ByVal BV_FolderPath)
		BV_FolderPath = ABSPath(BV_FolderPath)
		If OpenWBS.IsFSOInstalled Then
			If Pv_FSO.FolderExists(BV_FolderPath) Then FolderExists = True
		Else
			FolderExists = False
			OpenWBS.Error.Msg = "OpenWBS.FSO.FolderExists("""& BV_FolderPath &""")"
			OpenWBS.Error.Raise 1
			Err.Clear()
		End If
	End Function
	
	'·: E:\web\OpenWBS\wwwroot\data\javascript\region.json.js
	'·: data/javascript/region.json.js
	'*******************************************
	'ؾ·(absolute path) BV_Path·Ǿ·תΪ·,ļ·Ϊն"/////""\\\\\"ʽĴ·򷵻ؿַ
	'*******************************************
	Public Function ABSPath(ByVal BV_Path)
		Dim Fn_Path
		Fn_Path = BV_Path
		Fn_Path = Replace(Fn_Path,"*","")
		Fn_Path = Replace(Fn_Path,"?","")
		Fn_Path = Replace(Fn_Path,"""","")
		Fn_Path = Replace(Fn_Path,"|","")
		Fn_Path = Replace(Fn_Path,"<","")
		Fn_Path = Replace(Fn_Path,">","")
		
		If OpenWBS.Data.IsNul(Fn_Path) Or OpenWBS.Data.IsNul(Replace(Fn_Path,"/","")) Or OpenWBS.Data.IsNul(Replace(Fn_Path,"\","")) Then ABSPath = "" : Exit Function
		If Mid(Fn_Path,2,1)<>":" Then
			Fn_Path = Replace(Fn_Path,"\","/")
			Fn_Path = OpenWBS.Data.RegReplace(Fn_Path,"[/]+","/")
			If Left(Fn_Path,1)="/" Then Fn_Path = Mid(Fn_Path,2)
			Fn_Path = Server.MapPath(SystemPath & Fn_Path)
		Else
			Fn_Path = OpenWBS.Data.RegReplace(Fn_Path,"[/]+","/")
		End If
		If Right(Fn_Path,1)="\" Then Fn_Path=Left(Fn_Path,Len(Fn_Path)-1)
		ABSPath = Fn_Path
	End Function
	
	'ļ
	Public Function SaveTextFile(ByVal BV_FilePath, ByVal BV_Text)
		SaveTextFile = SaveTextFileByADO(BV_FilePath,BV_Text)
	End Function
	
	'ıļ(ֱӸǱ)[ıļĶдȨ]
	'ļԶ
	Public Function SaveTextFileByADO(ByVal BV_FilePath, ByVal BV_FileContent)
		On Error Resume Next
		If OpenWBS.Data.IsNul(BV_FilePath) Then SaveTextFileByADO=False : Exit Function
		Dim Fn_ADO,Fn_FilePath,Fn_FolderPath,Fn_Result
		Fn_FilePath = ABSPath(BV_FilePath)
		'ļǷ(򴴽)
		Fn_FolderPath = Left(Fn_FilePath,InstrRev(Fn_FilePath,"\")-1)
		If FolderExists(Fn_FolderPath) = False Then
			Fn_FolderPath = CreateFolder(Fn_FolderPath)
		End If
		If Fn_FolderPath = False Then SaveTextFileByADO = False : Exit Function
		
		'ʼдļ
		Set Fn_ADO = Server.CreateObject("ADODB.Stream")
		With Fn_ADO
			.Mode = 3
			.Type = 2
			.Open
			.CharSet   = Pv_CharSet
			.Position  = 0
			.WriteText = BV_FileContent
			.SaveToFile Fn_FilePath,2
			.Flush
			.Close
		End With
		Set Fn_ADO = Nothing
		Fn_Result = True
		If Err.Number<>0 Then
			Fn_Result = False
			OpenWBS.Error.Msg = Fn_FilePath
			OpenWBS.Error.Raise 55
		End If
		Err.Clear()
		SaveTextFileByADO = Fn_Result
	End Function
	
	'ıļ(ȴٱ,޸config.main.aspļʱô˷ʽ)[ıļĶдȨ]
	Public Function SaveTextFileByFSO(ByVal BV_FileABSPath,ByVal BV_Text)
		On Error Resume Next
		Dim Fn_FSO,Fn_File
		Set Fn_FSO  = Server.CreateObject("Scripting.FileSystemObject")     
		Set Fn_File = Fn_FSO.OpenTextFile(BV_FileABSPath,2,True)'ļʱ򴴽
		Fn_File.Write BV_Text
		Set Fn_File = Nothing
		Set Fn_FSO  = Nothing
		If Err.Number<>0 Then
			SaveTextFileByFSO = False
		Else
			SaveTextFileByFSO = True
		End If
		Err.Clear()
	End Function
	
	'ļ
	'{BV_FolderPath}ָ·
	'ϵͳ֧FSO   ֹ,ʾϵͳ֧FSO(Lang_ObjFSONotInstalled)
	'ʧ򷵻False   ɹ򷵻ȷľ·Fn_OkPath(E:\wwwoot\CMS\ASP\OpenWBS\wwwroot\attachment\image\201012\27)
	Function CreateFolder(ByVal BV_FolderPath)
		Call CheckFSOInstalled()
		Dim Fn_OkPath,Fn_LocalPath_ii,Fn_FolderPath
		CreateFolder  = False
		Fn_FolderPath = ABSPath(BV_FolderPath)
		
		Dim Fn_ParentFolderExist : Fn_ParentFolderExist = False
		Dim Fn_FolderExist       : Fn_FolderExist       = False
		
		If Not(OpenWBS.Data.IsNul(Fn_FolderPath)) Then'·Ч
			Fn_FolderPath=Split(Fn_FolderPath,"\")
			For Fn_LocalPath_ii=0 to Ubound(Fn_FolderPath)

				If Fn_LocalPath_ii=0 Then
					Fn_OkPath = Trim(Fn_FolderPath(Fn_LocalPath_ii))
				Else
					If Trim(Fn_FolderPath(Fn_LocalPath_ii))<>"" Then
						Fn_OkPath = Fn_OkPath &"\"& Trim(Fn_FolderPath(Fn_LocalPath_ii))
				    End If
				End If

				If Fn_LocalPath_ii>0 Then
				
					'жǷϵͳļжȡȨ
					If Fn_ParentFolderExist=False Then
						If Not Pv_FSO.FolderExists(Fn_OkPath)=False Then
							Fn_ParentFolderExist = True
						End If
					End If

					'ϵͳļжȡȨжļǷ(򴴽)
					If Fn_ParentFolderExist=True Then
						On Error Resume Next
						'ļ򴴽ļ
						If Pv_FSO.FolderExists(Fn_OkPath)=False Then
							Call CreateFolderByFSO(Fn_OkPath)
						End If
						If Err.Number<>0 Then
							OpenWBS.Error.Msg = Fn_OkPath
							OpenWBS.Error.Raise 50
							Err.Clear()
						End If
					End If
				End If
			Next
			CreateFolder = Fn_OkPath
		End If
	End Function
	
	'ͨFSOļ,ɹTrue,ʧܷFalse
	Function CreateFolderByFSO(ByVal BV_FolderPath)
		Err.Clear()
		On Error Resume Next
		Dim Fn_Result : Fn_Result = True
		Pv_FSO.CreateFolder(BV_FolderPath)
		If Err.Number<>0 Then
			Fn_Result = False
		End If
		Err.Clear()
		CreateFolderByFSO = Fn_Result
	End Function
	
	'[BV_FileABSPath:Ҫɾļľ·]ɾɹtrue,ļڻɾʧܷfalse
	Public Function DeleteFile(ByVal BV_FileABSPath)
		Dim Fn_Result : Fn_Result = True
		On Error Resume Next
		Pv_FSO.DeleteFile(BV_FileABSPath)
		If Err.Number<>0 Then
			Fn_Result = False
		Else
			Fn_Result = True
		End If
		Err.Clear()
		DeleteFile = Fn_Result
	End Function
	
	'ɾļ
	Public Function DeleteFolder(ByVal BV_FileABSPath)
		Dim Fn_Result : Fn_Result = True
		On Error Resume Next
		Pv_FSO.DeleteFolder(BV_FileABSPath)
		If Err.Number<>0 Then
			Fn_Result = False
		Else
			Fn_Result = True
		End If
		Err.Clear()
		DeleteFolder = Fn_Result
	End Function
	
	'жļǷд(BV_PathΪļľ·)
	Public Function FileWriteable(ByVal BV_Path)
		On Error Resume Next
		Dim BV_FileABSPath : BV_FileABSPath = BV_Path
		Dim Fn_ADO
		Set Fn_ADO = Server.CreateObject("ADODB.Stream")
		With Fn_ADO
			.Mode = 3
			.Type = 2 'Աģʽȡ
			.Open
			.CharSet   = Pv_CharSet
			.LoadFromFile BV_FileABSPath
			.SaveToFile BV_FileABSPath,2
			.Close
		End With
		Set Fn_ADO = Nothing
		FileWriteable = True
		If Err.Number<>0 Then FileWriteable = False
		Err.Clear()
	End Function
	
	'жļǷд(BV_ABSPathΪļеľ·)
	Public Function FolderWriteable(ByVal BV_ABSPath)
		On Error Resume Next
		Dim Fn_FileABSPath,Fn_Content : Fn_Content = "writeable "& SysTime
		If Right(BV_ABSPath,1)="\" Then
			Fn_FileABSPath = BV_ABSPath & "testwriteable.txt"
		Else
			Fn_FileABSPath = BV_ABSPath &"\"& "testwriteable.txt"
		End If
		Dim Fn_ADO
		Set Fn_ADO = Server.CreateObject("ADODB.Stream")
		With Fn_ADO
			.Mode = 3
			.Type = 2
			.Open
			.CharSet   = Pv_CharSet
			.Position  = 0
			.WriteText = Fn_Content
			.SaveToFile Fn_FileABSPath,2
			.Close
		End With
		Set Fn_ADO = Nothing
		If Err.Number<>0 Then
			FolderWriteable = False
		Else
			If FileExists(Fn_FileABSPath) Then
				FolderWriteable = True
				Call DeleteFile(Fn_FileABSPath)
			Else
				FolderWriteable = False
			End If
		End If
		Err.Clear()
	End Function
	
	'ȡļб
	Public Function FolderList(ByVal BV_ReturnType,ByVal BV_FolderPath)
		Dim Fn_i,Fn_FSO,Fn_Folder,Fn_SubFolder,Fn_FolderPath,Fn_Json,Fn_html,Fn_Temp

		Fn_FolderPath = OpenWBS.Data.FolderPath(BV_FolderPath)

		Set Fn_FSO = OpenWBS.FSO.ObjectFSO
		If Fn_FSO.FolderExists(Server.MapPath(SystemPath & Fn_FolderPath))=False Then
			FolderList = "{""foldername"":"""& OpenWBS.Data.FolderName(Fn_FolderPath) &""",""size"":""0"",""datetime"":"""",""folderpath"":"""& Fn_FolderPath &""",""subfolderscount"":""0"",""subfolders"":[],""folderexists"":""false""}"
			Exit Function
		End If
		
		Fn_i = 0
		Set Fn_Folder=Fn_FSO.GetFolder(Server.MapPath(SystemPath & Fn_FolderPath))
		For Each Fn_SubFolder in Fn_Folder.SubFolders
			Fn_i    = Fn_i + 1
			Fn_Temp = "{""foldername"":"""& Fn_SubFolder.name &""",""size"":"""& OpenWBS.Data.FormatSize(Fn_SubFolder.Size) &""",""datetime"":"""& Fn_SubFolder.datelastmodified &""",""folderpath"":"""& Fn_FolderPath & Fn_SubFolder.name &""",""subfolderscount"":"""& Fn_SubFolder.SubFolders.Count &""",""subfolders"":[],""folderexists"":""true""}"
			If Fn_Json = "" Then
				Fn_Json = Fn_Temp
			Else
				Fn_Json = Fn_Json &","& Fn_Temp
			End If
		Next
		Fn_Json = "{""foldername"":"""& OpenWBS.Data.FolderName(Fn_FolderPath) &""",""size"":"""& OpenWBS.Data.FormatSize(Fn_Folder.Size) &""",""datetime"":"""& Fn_Folder.datelastmodified &""",""folderpath"":"""& Fn_FolderPath &""",""subfolderscount"":"""& Fn_Folder.SubFolders.Count &""",""subfolders"":["& Fn_Json &"],""folderexists"":""true""}"
		
		Set Fn_Folder = Nothing
		Set Fn_FSO    = Nothing
		
		Select Case LCase(BV_ReturnType)
		Case "json" : FolderList = Fn_Json
		Case "html" : FolderList = Fn_html
		End Select
	End Function
	
	'ȡļб
	'FileList("json","attachment/image/201302/27/")
	Public Function FileList(ByVal BV_ReturnType,ByVal BV_FolderPath)
		Dim Fn_i,Fn_FSO,Fn_File,Fn_Folder,Fn_FolderPath,Fn_Json,Fn_Array,Fn_html,Fn_Temp

		Fn_FolderPath = OpenWBS.Data.FolderPath(BV_FolderPath)

		Set Fn_FSO = OpenWBS.FSO.ObjectFSO
		If Fn_FSO.FolderExists(Server.MapPath(SystemPath & Fn_FolderPath))=False Then
			FileList = "{""foldername"":"""& OpenWBS.Data.FolderName(Fn_FolderPath) &""",""size"":""0"",""datetime"":"""",""folderpath"":"""& Fn_FolderPath &""",""filecount"":""0"",""files"":[],""folderexists"":""false""}"
			Exit Function
		End If
		
		Set Fn_Folder=Fn_FSO.GetFolder(Server.MapPath(SystemPath & Fn_FolderPath))
		Fn_i = 0
		ReDim Fn_Array(Fn_Folder.Files.Count)
		For Each Fn_File in Fn_Folder.Files
			Fn_Array(Fn_i) = Fn_File.name
			Fn_i    = Fn_i + 1
			Fn_Temp = "{""filename"":"""& Fn_File.name &""",""size"":"""& OpenWBS.Data.FormatSize(Fn_File.Size) &""",""datetime"":"""& Fn_File.datelastmodified &""",""filepath"":"""& Fn_FolderPath & Fn_File.name &"""}"
			If Fn_Json = "" Then
				Fn_Json = Fn_Temp
			Else
				Fn_Json = Fn_Json &","& Fn_Temp
			End If
		Next
		Fn_Json = "{""foldername"":"""& OpenWBS.Data.FolderName(Fn_FolderPath) &""",""size"":"""& OpenWBS.Data.FormatSize(Fn_Folder.Size) &""",""datetime"":"""& Fn_Folder.datelastmodified &""",""folderpath"":"""& Fn_FolderPath &""",""filecount"":"""& Fn_Folder.Files.Count &""",""files"":["& Fn_Json &"]}"
		
		Set Fn_Folder = Nothing
		Set Fn_FSO    = Nothing
		
		Select Case LCase(BV_ReturnType)
		Case "json" : FileList = Fn_Json
		Case "array" : FileList = Fn_Array
		Case "html" : FileList = Fn_html
		End Select
	End Function
	
	'ļ
	Public Function CopyFile(ByVal BV_FromFilePath,ByVal BV_ToFilePath)
		Err.Clear()
		On Error Resume Next
		Dim Fn_Result : Fn_Result = True
		If BV_FromFilePath="" Or BV_ToFilePath="" Then CopyFile=False : Exit Function
		Pv_FSO.CopyFile ABSPath(BV_FromFilePath),ABSPath(BV_ToFilePath)
		If Err.Number<>0 Then
			Fn_Result = False
			Err.Clear()
		End If
		CopyFile = Fn_Result
	End Function
	
	'һļб
	Public Function SecFolderList(ParID,FolderPath,FileType)
		Dim Fn_FolderPath,Fn_FSO,Fn_Fold,Fn_FileItem,Fn_i
		    Fn_i=0
		Fn_FolderPath=OpenWBS.Data.URLDecode(FolderPath)
		Fn_FolderPath=FolderPath
		
		'**ļ· attachment/image/ ʽ
		Fn_FolderPath = OpenWBS.Data.RegReplace(Fn_FolderPath,"[/]+","/")
		If Left(Fn_FolderPath,1) = "/" Then Fn_FolderPath = Mid(Fn_FolderPath,2)
		If Right(Fn_FolderPath,1) <> "/" Then Fn_FolderPath = Fn_FolderPath &"/"
		
		'**˽ֹļַ
		Fn_FolderPath=Replace(Fn_FolderPath,"\","")
		Fn_FolderPath=Replace(Fn_FolderPath,":","")
		Fn_FolderPath=Replace(Fn_FolderPath,"*","")
		Fn_FolderPath=Replace(Fn_FolderPath,"?","")
		Fn_FolderPath=Replace(Fn_FolderPath,"""","")
		Fn_FolderPath=Replace(Fn_FolderPath,"|","")
		Fn_FolderPath=Replace(Fn_FolderPath,"<","")
		Fn_FolderPath=Replace(Fn_FolderPath,">","")
		'**
		
		Set Fn_FSO = OpenWBS.FSO.ObjectFSO
		If Fn_FSO.FolderExists(Server.MapPath(SystemPath&Fn_FolderPath))=False Then
			Exit Function
		End If
		
		set Fn_Fold=Fn_FSO.getfolder(Server.MapPath(SystemPath&Fn_FolderPath))
		for each Fn_FileItem in Fn_Fold.subfolders
			Pv_FolderOrder=Pv_FolderOrder+1
			Echo "d.add("& Pv_FolderOrder &","&ParID&","""& Fn_FileItem.name &""",""javascript:GetFiles('"& FileType &"','"& Fn_FolderPath & Fn_FileItem.name &"')"");"&vbCrLf
		next
		set Fn_Fold=nothing
		set Fn_FSO=Nothing
	End Function

	' $ļĿ¼
	' {FolderPath} ļ·
	' {RootName} Ŀ¼
	' {FileType} ļ
	Public Function TreeFolderList(FolderPath,RootName,FileType)
		Dim Fn_FolderPath,Fn_FSO,Fn_Fold,Fn_FileItem,Fn_i
		    Fn_i=0

		Fn_FolderPath = OpenWBS.Data.FolderPath(FolderPath)
		
		Set Fn_FSO = OpenWBS.FSO.ObjectFSO
		If Fn_FSO.FolderExists(Server.MapPath(SystemPath&Fn_FolderPath))=False Then
			Echo "FolderPath is Wrong "&Fn_FolderPath
			Exit Function
		End If
		Set Fn_Fold=Fn_FSO.getfolder(Server.MapPath(SystemPath&Fn_FolderPath))
		Echo "<script type=""text/javascript"">"&vbCrLf
		Echo "d = new dTree('d');"&vbCrLf
		Echo "d.add(0,-1,"""&RootName&""",""javascript:GetFiles('"& FileType &"','"& Fn_FolderPath &"')"");"&vbCrLf
		for each Fn_FileItem in Fn_Fold.subfolders
			Fn_i=Fn_i+1
			Echo "d.add("&Fn_i&",0,"""& Fn_FileItem.name &""",""javascript:GetFiles('"& FileType &"','"& Fn_FolderPath & Fn_FileItem.name &"')"");"&vbCrLf
		next
		Pv_FolderOrder=Fn_i
		Fn_i=0
		'**ȡһļ
		for each Fn_FileItem in Fn_Fold.subfolders
			Fn_i=Fn_i+1
			Pv_FolderOrder=Pv_FolderOrder+1
			Call SecFolderList(Fn_i,Fn_FolderPath & Fn_FileItem.name,FileType)
		next
		Echo "document.write(d);"&vbCrLf
		Echo "</script>"&vbCrLf
		set Fn_Fold=nothing
		set Fn_FSO=Nothing
	End Function
	
	
End Class
%>