/**
 * @file
 * @name UE.EventBase
 * @short EventBase
 * @import editor.js,core/utils.js
 * @desc UEõ¼̳࣬дĶӦཫȡaddListener,removeListener,fireEvent
 * UEУEditorԼuiʵ̳˸࣬ʿڶӦuiԼeditorʹ
 */
var EventBase = UE.EventBase = function () {};

EventBase.prototype = {
    /**
     * ע¼
     * @name addListener
     * @grammar editor.addListener(types,fn)  //typesΪ¼ƣÿոָ
     * @example
     * editor.addListener('selectionchange',function(){
     *      console.log("ѡѾ仯");
     * })
     * editor.addListener('beforegetcontent aftergetcontent',function(type){
     *         if(type == 'beforegetcontent'){
     *             //do something
     *         }else{
     *             //do something
     *         }
     *         console.log(this.getContent) // thisע¼ı༭ʵ
     * })
     */
    addListener:function (types, listener) {
        types = utils.trim(types).split(' ');
        for (var i = 0, ti; ti = types[i++];) {
            getListener(this, ti, true).push(listener);
        }
    },
    /**
     * Ƴ¼
     * @name removeListener
     * @grammar editor.removeListener(types,fn)  //typesΪ¼ƣÿոָ
     * @example
     * //changeCallbackΪ
     * editor.removeListener("selectionchange",changeCallback);
     */
    removeListener:function (types, listener) {
        types = utils.trim(types).split(' ');
        for (var i = 0, ti; ti = types[i++];) {
            utils.removeItem(getListener(this, ti) || [], listener);
        }
    },
    /**
     * ¼
     * @name fireEvent
     * @grammar editor.fireEvent(types)  //typesΪ¼ƣÿոָ
     * @example
     * editor.fireEvent("selectionchange");
     */
    fireEvent:function (types) {
        types = utils.trim(types).split(' ');
        for (var i = 0, ti; ti = types[i++];) {
            var listeners = getListener(this, ti),
                r, t, k;
            if (listeners) {
                k = listeners.length;
                while (k--) {
                    if(!listeners[k])continue;
                    t = listeners[k].apply(this, arguments);
                    if(t === true){
                        return t;
                    }
                    if (t !== undefined) {
                        r = t;
                    }
                }
            }
            if (t = this['on' + ti.toLowerCase()]) {
                r = t.apply(this, arguments);
            }
        }
        return r;
    }
};
/**
 * öӵм͵м
 * @public
 * @function
 * @param {Object} obj  ѯĶ
 * @param {String} type ¼
 * @param {Boolean} force  Ϊtrueҵǰtype͵ʱһռ
 * @returns {Array} 
 */
function getListener(obj, type, force) {
    var allListeners;
    type = type.toLowerCase();
    return ( ( allListeners = ( obj.__allListeners || force && ( obj.__allListeners = {} ) ) )
        && ( allListeners[type] || force && ( allListeners[type] = [] ) ) );
}

