/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.CircleShape;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.PolygonShape;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

public class CollideCircle {
    public static void collideCircles(Manifold manifold, CircleShape circle1, XForm xf1, CircleShape circle2, XForm xf2) {
        float separation;
        float r2;
        float r1;
        float radiusSum;
        manifold.pointCount = 0;
        Vec2 p1 = XForm.mul(xf1, circle1.getLocalPosition());
        Vec2 p2 = XForm.mul(xf2, circle2.getLocalPosition());
        Vec2 d = p2.sub(p1);
        float distSqr = Vec2.dot(d, d);
        if (distSqr > (radiusSum = (r1 = circle1.getRadius()) + (r2 = circle2.getRadius())) * radiusSum) {
            return;
        }
        if (distSqr < 1.1920929E-7f) {
            separation = -radiusSum;
            manifold.normal.set(0.0f, 1.0f);
        } else {
            float dist = (float)Math.sqrt(distSqr);
            separation = dist - radiusSum;
            float a = 1.0f / dist;
            manifold.normal.x = a * d.x;
            manifold.normal.y = a * d.y;
        }
        manifold.pointCount = 1;
        manifold.points[0].id.zero();
        manifold.points[0].separation = separation;
        p1.addLocal(manifold.normal.mul(r1));
        p2.subLocal(manifold.normal.mul(r2));
        Vec2 p = new Vec2(0.5f * (p1.x + p2.x), 0.5f * (p1.y + p2.y));
        manifold.points[0].localPoint1 = XForm.mulT(xf1, p);
        manifold.points[0].localPoint2 = XForm.mulT(xf2, p);
    }

    public static void collidePolygonAndCircle(Manifold manifold, PolygonShape polygon, XForm xf1, CircleShape circle, XForm xf2) {
        manifold.pointCount = 0;
        Vec2 c = XForm.mul(xf2, circle.getLocalPosition());
        Vec2 cLocal = XForm.mulT(xf1, c);
        int normalIndex = 0;
        float separation = -3.4028235E38f;
        float radius = circle.getRadius();
        int vertexCount = polygon.getVertexCount();
        Vec2[] vertices = polygon.getVertices();
        Vec2[] normals = polygon.getNormals();
        int i = 0;
        while (i < vertexCount) {
            float s = Vec2.dot(normals[i], cLocal.sub(vertices[i]));
            if (s > circle.m_radius) {
                return;
            }
            if (s > separation) {
                normalIndex = i;
                separation = s;
            }
            ++i;
        }
        if (separation < 1.1920929E-7f) {
            manifold.pointCount = 1;
            manifold.normal = Mat22.mul(xf1.R, normals[normalIndex]);
            manifold.points[0].id.features.incidentEdge = normalIndex;
            manifold.points[0].id.features.incidentVertex = Integer.MAX_VALUE;
            manifold.points[0].id.features.referenceEdge = 0;
            manifold.points[0].id.features.flip = 0;
            Vec2 position = c.sub(manifold.normal.mul(radius));
            manifold.points[0].localPoint1 = XForm.mulT(xf1, position);
            manifold.points[0].localPoint2 = XForm.mulT(xf2, position);
            manifold.points[0].separation = separation - radius;
            return;
        }
        int vertIndex1 = normalIndex;
        int vertIndex2 = vertIndex1 + 1 < vertexCount ? vertIndex1 + 1 : 0;
        Vec2 e = vertices[vertIndex2].sub(vertices[vertIndex1]);
        float length = e.normalize();
        assert (length > 1.1920929E-7f);
        float u = Vec2.dot(cLocal.sub(vertices[vertIndex1]), e);
        Vec2 p = new Vec2();
        if (u <= 0.0f) {
            p.set(vertices[vertIndex1]);
            manifold.points[0].id.features.incidentEdge = Integer.MAX_VALUE;
            manifold.points[0].id.features.incidentVertex = vertIndex1;
        } else if (u >= length) {
            p.set(vertices[vertIndex2]);
            manifold.points[0].id.features.incidentEdge = Integer.MAX_VALUE;
            manifold.points[0].id.features.incidentVertex = vertIndex2;
        } else {
            p.set(vertices[vertIndex1]);
            p.x += u * e.x;
            p.y += u * e.y;
            manifold.points[0].id.features.incidentEdge = normalIndex;
            manifold.points[0].id.features.incidentVertex = 0;
        }
        Vec2 d = cLocal.sub(p);
        float dist = d.normalize();
        if (dist > radius) {
            return;
        }
        manifold.pointCount = 1;
        manifold.normal = Mat22.mul(xf1.R, d);
        Vec2 position = c.sub(manifold.normal.mul(radius));
        manifold.points[0].localPoint1 = XForm.mulT(xf1, position);
        manifold.points[0].localPoint2 = XForm.mulT(xf2, position);
        manifold.points[0].separation = dist - radius;
        manifold.points[0].id.features.referenceEdge = 0;
        manifold.points[0].id.features.flip = 0;
    }
}

