/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.collision;

import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.MaxSeparation;
import org.jbox2d.collision.PolygonShape;
import org.jbox2d.common.Mat22;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;

public class CollidePoly {
    static int clipSegmentToLine(ClipVertex[] vOut, ClipVertex[] vIn, Vec2 normal, float offset) {
        int numOut = 0;
        float distance0 = Vec2.dot(normal, vIn[0].v) - offset;
        float distance1 = Vec2.dot(normal, vIn[1].v) - offset;
        if (distance0 <= 0.0f) {
            vOut[numOut] = new ClipVertex();
            vOut[numOut].id = new ContactID(vIn[0].id);
            vOut[numOut++].v = vIn[0].v.clone();
        }
        if (distance1 <= 0.0f) {
            vOut[numOut] = new ClipVertex();
            vOut[numOut].id = new ContactID(vIn[1].id);
            vOut[numOut++].v = vIn[1].v.clone();
        }
        if (distance0 * distance1 < 0.0f) {
            float interp = distance0 / (distance0 - distance1);
            vOut[numOut] = new ClipVertex();
            vOut[numOut].v.x = vIn[0].v.x + interp * (vIn[1].v.x - vIn[0].v.x);
            vOut[numOut].v.y = vIn[0].v.y + interp * (vIn[1].v.y - vIn[0].v.y);
            vOut[numOut].id = distance0 > 0.0f ? new ContactID(vIn[0].id) : new ContactID(vIn[1].id);
            ++numOut;
        }
        return numOut;
    }

    static float edgeSeparation(PolygonShape poly1, XForm xf1, int edge1, PolygonShape poly2, XForm xf2) {
        int count1 = poly1.getVertexCount();
        Vec2[] vertices1 = poly1.getVertices();
        Vec2[] normals1 = poly1.getNormals();
        int count2 = poly2.getVertexCount();
        Vec2[] vertices2 = poly2.getVertices();
        assert (edge1 >= 0 && edge1 < count1);
        Vec2 normal1World = Mat22.mul(xf1.R, normals1[edge1]);
        float normal1x = Vec2.dot(normal1World, xf2.R.col1);
        float normal1y = Vec2.dot(normal1World, xf2.R.col2);
        int index = 0;
        float minDot = Float.MAX_VALUE;
        int i = 0;
        while (i < count2) {
            float dot = vertices2[i].x * normal1x + vertices2[i].y * normal1y;
            if (dot < minDot) {
                minDot = dot;
                index = i;
            }
            ++i;
        }
        Vec2 v = vertices1[edge1];
        float v1x = xf1.position.x + xf1.R.col1.x * v.x + xf1.R.col2.x * v.y;
        float v1y = xf1.position.y + xf1.R.col1.y * v.x + xf1.R.col2.y * v.y;
        Vec2 v3 = vertices2[index];
        float v2x = xf2.position.x + xf2.R.col1.x * v3.x + xf2.R.col2.x * v3.y;
        float v2y = xf2.position.y + xf2.R.col1.y * v3.x + xf2.R.col2.y * v3.y;
        float separation = (v2x - v1x) * normal1World.x + (v2y - v1y) * normal1World.y;
        return separation;
    }

    static MaxSeparation findMaxSeparation(PolygonShape poly1, XForm xf1, PolygonShape poly2, XForm xf2) {
        float bestSeparation;
        int bestEdge;
        int increment;
        MaxSeparation separation = new MaxSeparation();
        int count1 = poly1.getVertexCount();
        Vec2[] normals1 = poly1.getNormals();
        Vec2 v = poly1.getCentroid();
        Vec2 v1 = poly2.getCentroid();
        float dx = xf2.position.x + xf2.R.col1.x * v1.x + xf2.R.col2.x * v1.y - (xf1.position.x + xf1.R.col1.x * v.x + xf1.R.col2.x * v.y);
        float dy = xf2.position.y + xf2.R.col1.y * v1.x + xf2.R.col2.y * v1.y - (xf1.position.y + xf1.R.col1.y * v.x + xf1.R.col2.y * v.y);
        Vec2 b = xf1.R.col1;
        Vec2 b1 = xf1.R.col2;
        Vec2 dLocal1 = new Vec2(dx * b.x + dy * b.y, dx * b1.x + dy * b1.y);
        int edge = 0;
        float maxDot = -3.4028235E38f;
        int i = 0;
        while (i < count1) {
            float dot = Vec2.dot(normals1[i], dLocal1);
            if (dot > maxDot) {
                maxDot = dot;
                edge = i;
            }
            ++i;
        }
        float s = CollidePoly.edgeSeparation(poly1, xf1, edge, poly2, xf2);
        if (s > 0.0f) {
            separation.bestSeparation = s;
            return separation;
        }
        int prevEdge = edge - 1 >= 0 ? edge - 1 : count1 - 1;
        float sPrev = CollidePoly.edgeSeparation(poly1, xf1, prevEdge, poly2, xf2);
        if (sPrev > 0.0f) {
            separation.bestSeparation = sPrev;
            return separation;
        }
        int nextEdge = edge + 1 < count1 ? edge + 1 : 0;
        float sNext = CollidePoly.edgeSeparation(poly1, xf1, nextEdge, poly2, xf2);
        if (sNext > 0.0f) {
            separation.bestSeparation = sNext;
            return separation;
        }
        if (sPrev > s && sPrev > sNext) {
            increment = -1;
            bestEdge = prevEdge;
            bestSeparation = sPrev;
        } else if (sNext > s) {
            increment = 1;
            bestEdge = nextEdge;
            bestSeparation = sNext;
        } else {
            separation.bestFaceIndex = edge;
            separation.bestSeparation = s;
            return separation;
        }
        while (true) {
            if ((s = CollidePoly.edgeSeparation(poly1, xf1, edge = increment == -1 ? (bestEdge - 1 >= 0 ? bestEdge - 1 : count1 - 1) : (bestEdge + 1 < count1 ? bestEdge + 1 : 0), poly2, xf2)) > 0.0f) {
                separation.bestSeparation = s;
                return separation;
            }
            if (!(s > bestSeparation)) break;
            bestEdge = edge;
            bestSeparation = s;
        }
        separation.bestFaceIndex = bestEdge;
        separation.bestSeparation = bestSeparation;
        return separation;
    }

    static void findIncidentEdge(ClipVertex[] c, PolygonShape poly1, XForm xf1, int edge1, PolygonShape poly2, XForm xf2) {
        int count1 = poly1.getVertexCount();
        Vec2[] normals1 = poly1.getNormals();
        int count2 = poly2.getVertexCount();
        Vec2[] vertices2 = poly2.getVertices();
        Vec2[] normals2 = poly2.getNormals();
        assert (edge1 >= 0 && edge1 < count1);
        Vec2 normal1 = Mat22.mulT(xf2.R, Mat22.mul(xf1.R, normals1[edge1]));
        int index = 0;
        float minDot = Float.MAX_VALUE;
        int i = 0;
        while (i < count2) {
            float dot = Vec2.dot(normal1, normals2[i]);
            if (dot < minDot) {
                minDot = dot;
                index = i;
            }
            ++i;
        }
        int i1 = index;
        int i2 = i1 + 1 < count2 ? i1 + 1 : 0;
        c[0] = new ClipVertex();
        c[1] = new ClipVertex();
        c[0].v = XForm.mul(xf2, vertices2[i1]);
        c[0].id.features.referenceEdge = edge1;
        c[0].id.features.incidentEdge = i1;
        c[0].id.features.incidentVertex = 0;
        c[1].v = XForm.mul(xf2, vertices2[i2]);
        c[1].id.features.referenceEdge = edge1;
        c[1].id.features.incidentEdge = i2;
        c[1].id.features.incidentVertex = 1;
    }

    public static void collidePolygons(Manifold manif, PolygonShape polyA, XForm xfA, PolygonShape polyB, XForm xfB) {
        int flip;
        int edge1;
        PolygonShape poly2;
        PolygonShape poly1;
        manif.pointCount = 0;
        MaxSeparation sepA = CollidePoly.findMaxSeparation(polyA, xfA, polyB, xfB);
        if (sepA.bestSeparation > 0.0f) {
            return;
        }
        MaxSeparation sepB = CollidePoly.findMaxSeparation(polyB, xfB, polyA, xfA);
        if (sepB.bestSeparation > 0.0f) {
            return;
        }
        XForm xf1 = new XForm();
        XForm xf2 = new XForm();
        float k_relativeTol = 0.98f;
        float k_absoluteTol = 0.001f;
        if (sepB.bestSeparation > k_relativeTol * sepA.bestSeparation + k_absoluteTol) {
            poly1 = polyB;
            poly2 = polyA;
            xf1.set(xfB);
            xf2.set(xfA);
            edge1 = sepB.bestFaceIndex;
            flip = 1;
        } else {
            poly1 = polyA;
            poly2 = polyB;
            xf1.set(xfA);
            xf2.set(xfB);
            edge1 = sepA.bestFaceIndex;
            flip = 0;
        }
        ClipVertex[] incidentEdge = new ClipVertex[2];
        CollidePoly.findIncidentEdge(incidentEdge, poly1, xf1, edge1, poly2, xf2);
        int count1 = poly1.getVertexCount();
        Vec2[] vertices1 = poly1.getVertices();
        Vec2 v11 = vertices1[edge1];
        Vec2 v12 = edge1 + 1 < count1 ? vertices1[edge1 + 1] : vertices1[0];
        Vec2 sideNormal = Mat22.mul(xf1.R, v12.sub(v11));
        sideNormal.normalize();
        Vec2 frontNormal = Vec2.cross(sideNormal, 1.0f);
        float v11x = xf1.position.x + xf1.R.col1.x * v11.x + xf1.R.col2.x * v11.y;
        float v11y = xf1.position.y + xf1.R.col1.y * v11.x + xf1.R.col2.y * v11.y;
        float v12x = xf1.position.x + xf1.R.col1.x * v12.x + xf1.R.col2.x * v12.y;
        float v12y = xf1.position.y + xf1.R.col1.y * v12.x + xf1.R.col2.y * v12.y;
        float frontOffset = frontNormal.x * v11x + frontNormal.y * v11y;
        float sideOffset1 = -(sideNormal.x * v11x + sideNormal.y * v11y);
        float sideOffset2 = sideNormal.x * v12x + sideNormal.y * v12y;
        ClipVertex[] clipPoints1 = new ClipVertex[2];
        ClipVertex[] clipPoints2 = new ClipVertex[2];
        int np = CollidePoly.clipSegmentToLine(clipPoints1, incidentEdge, sideNormal.negate(), sideOffset1);
        if (np < 2) {
            return;
        }
        np = CollidePoly.clipSegmentToLine(clipPoints2, clipPoints1, sideNormal, sideOffset2);
        if (np < 2) {
            return;
        }
        manif.normal = flip != 0 ? frontNormal.negate() : frontNormal.clone();
        int pointCount = 0;
        int i = 0;
        while (i < 2) {
            float separation = Vec2.dot(frontNormal, clipPoints2[i].v) - frontOffset;
            if (separation <= 0.0f) {
                ManifoldPoint cp = manif.points[pointCount];
                cp.separation = separation;
                Vec2 vec = clipPoints2[i].v;
                float v1x = vec.x - xfA.position.x;
                float v1y = vec.y - xfA.position.y;
                cp.localPoint1.x = v1x * xfA.R.col1.x + v1y * xfA.R.col1.y;
                cp.localPoint1.y = v1x * xfA.R.col2.x + v1y * xfA.R.col2.y;
                v1x = vec.x - xfB.position.x;
                v1y = vec.y - xfB.position.y;
                cp.localPoint2.x = v1x * xfB.R.col1.x + v1y * xfB.R.col1.y;
                cp.localPoint2.y = v1x * xfB.R.col2.x + v1y * xfB.R.col2.y;
                cp.id = new ContactID(clipPoints2[i].id);
                cp.id.features.flip = flip;
                ++pointCount;
            }
            ++i;
        }
        manif.pointCount = pointCount;
    }

    static class ClipVertex {
        Vec2 v = new Vec2();
        ContactID id = new ContactID();
    }
}

