/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.common;

import org.jbox2d.common.Vec2;

public class Mat22 {
    public Vec2 col1;
    public Vec2 col2;

    public String toString() {
        String s = "";
        s = String.valueOf(s) + "[" + this.col1.x + "," + this.col2.x + "]\n";
        s = String.valueOf(s) + "[" + this.col1.y + "," + this.col2.y + "]";
        return s;
    }

    public Mat22() {
        this(new Vec2(), new Vec2());
    }

    public Mat22(float angle) {
        this();
        this.setAngle(angle);
    }

    public Mat22(Vec2 c1, Vec2 c2) {
        this.col1 = c1.clone();
        this.col2 = c2.clone();
    }

    public Mat22(float col1x, float col2x, float col1y, float col2y) {
        this.col1 = new Vec2(col1x, col1y);
        this.col2 = new Vec2(col2x, col2y);
    }

    public void set(Mat22 m) {
        this.col1.x = m.col1.x;
        this.col1.y = m.col1.y;
        this.col2.x = m.col2.x;
        this.col2.y = m.col2.y;
    }

    public Mat22 clone() {
        return new Mat22(this.col1.clone(), this.col2.clone());
    }

    public void set(float angle) {
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        this.col1.x = c;
        this.col2.x = -s;
        this.col1.y = s;
        this.col2.y = c;
    }

    public void setIdentity() {
        this.col1.x = 1.0f;
        this.col2.x = 0.0f;
        this.col1.y = 0.0f;
        this.col2.y = 1.0f;
    }

    public void setZero() {
        this.col1.x = 0.0f;
        this.col2.x = 0.0f;
        this.col1.y = 0.0f;
        this.col2.y = 0.0f;
    }

    public void setAngle(float angle) {
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        this.col1.x = c;
        this.col2.x = -s;
        this.col1.y = s;
        this.col2.y = c;
    }

    public void set(Vec2 c1, Vec2 c2) {
        this.col1.x = c1.x;
        this.col2.x = c2.x;
        this.col1.y = c1.y;
        this.col2.y = c2.y;
    }

    public Mat22 invert() {
        float a = this.col1.x;
        float b = this.col2.x;
        float c = this.col1.y;
        float d = this.col2.y;
        Mat22 B = new Mat22();
        float det = a * d - b * c;
        det = 1.0f / det;
        B.col1.x = det * d;
        B.col2.x = -det * b;
        B.col1.y = -det * c;
        B.col2.y = det * a;
        return B;
    }

    public Mat22 abs() {
        return new Mat22(this.col1.abs(), this.col2.abs());
    }

    public static Mat22 abs(Mat22 R) {
        return R.abs();
    }

    public Vec2 mul(Vec2 v) {
        return new Vec2(this.col1.x * v.x + this.col2.x * v.y, this.col1.y * v.x + this.col2.y * v.y);
    }

    public Mat22 mul(Mat22 R) {
        Mat22 C = new Mat22();
        C.set(this.mul(R.col1), this.mul(R.col2));
        return C;
    }

    public Mat22 mulT(Mat22 B) {
        Vec2 c1 = new Vec2(Vec2.dot(this.col1, B.col1), Vec2.dot(this.col2, B.col1));
        Vec2 c2 = new Vec2(Vec2.dot(this.col1, B.col2), Vec2.dot(this.col2, B.col2));
        Mat22 C = new Mat22();
        C.set(c1, c2);
        return C;
    }

    public Vec2 mulT(Vec2 v) {
        return new Vec2(Vec2.dot(v, this.col1), Vec2.dot(v, this.col2));
    }

    public Mat22 add(Mat22 B) {
        return new Mat22(this.col1.add(B.col1), this.col2.add(B.col2));
    }

    public Mat22 addLocal(Mat22 B) {
        this.col1.addLocal(B.col1);
        this.col2.addLocal(B.col2);
        return this;
    }

    public Vec2 solve(Vec2 b) {
        float a11 = this.col1.x;
        float a12 = this.col2.x;
        float a21 = this.col1.y;
        float a22 = this.col2.y;
        float det = a11 * a22 - a12 * a21;
        assert (det != 0.0f);
        det = 1.0f / det;
        Vec2 x = new Vec2(det * (a22 * b.x - a12 * b.y), det * (a11 * b.y - a21 * b.x));
        return x;
    }

    public static Vec2 mul(Mat22 R, Vec2 v) {
        return R.mul(v);
    }

    public static Mat22 mul(Mat22 A, Mat22 B) {
        return A.mul(B);
    }

    public static Vec2 mulT(Mat22 R, Vec2 v) {
        return R.mulT(v);
    }

    public static Mat22 mulT(Mat22 A, Mat22 B) {
        return A.mulT(B);
    }
}

