/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.contacts;

import java.util.ArrayList;
import java.util.List;
import org.jbox2d.collision.CircleShape;
import org.jbox2d.collision.CollideCircle;
import org.jbox2d.collision.ContactID;
import org.jbox2d.collision.Manifold;
import org.jbox2d.collision.ManifoldPoint;
import org.jbox2d.collision.PolygonShape;
import org.jbox2d.collision.Shape;
import org.jbox2d.collision.ShapeType;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.ContactListener;
import org.jbox2d.dynamics.contacts.Contact;
import org.jbox2d.dynamics.contacts.ContactCreateFcn;
import org.jbox2d.dynamics.contacts.ContactPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PolyAndCircleContact
extends Contact
implements ContactCreateFcn {
    Manifold m_manifold;

    public PolyAndCircleContact(Shape s1, Shape s2) {
        super(s1, s2);
        assert (this.m_shape1.getType() == ShapeType.POLYGON_SHAPE);
        assert (this.m_shape2.getType() == ShapeType.CIRCLE_SHAPE);
        this.m_manifold = new Manifold();
        this.m_manifoldCount = 0;
        this.m_manifold.points[0].normalImpulse = 0.0f;
        this.m_manifold.points[0].tangentImpulse = 0.0f;
    }

    public PolyAndCircleContact() {
        this.m_manifold = new Manifold();
        this.m_manifoldCount = 0;
    }

    @Override
    public Contact clone() {
        PolyAndCircleContact newC = new PolyAndCircleContact(this.m_shape1, this.m_shape2);
        newC.m_manifold = new Manifold(this.m_manifold);
        newC.m_manifoldCount = this.m_manifoldCount;
        newC.m_world = this.m_world;
        newC.m_prev = this.m_prev;
        newC.m_next = this.m_next;
        newC.m_node1 = this.m_node1;
        newC.m_node2 = this.m_node2;
        newC.m_friction = this.m_friction;
        newC.m_restitution = this.m_restitution;
        newC.m_flags = this.m_flags;
        return newC;
    }

    @Override
    public Contact create(Shape shape1, Shape shape2) {
        return new PolyAndCircleContact(shape1, shape2);
    }

    @Override
    public List<Manifold> getManifolds() {
        ArrayList<Manifold> ret = new ArrayList<Manifold>(1);
        if (this.m_manifold != null) {
            ret.add(this.m_manifold);
        }
        return ret;
    }

    @Override
    public void evaluate(ContactListener listener) {
        int i;
        Body b1 = this.m_shape1.getBody();
        Body b2 = this.m_shape2.getBody();
        Manifold m0 = new Manifold(this.m_manifold);
        int k = 0;
        while (k < this.m_manifold.pointCount) {
            m0.points[k] = new ManifoldPoint(this.m_manifold.points[k]);
            m0.points[k].normalImpulse = this.m_manifold.points[k].normalImpulse;
            m0.points[k].tangentImpulse = this.m_manifold.points[k].tangentImpulse;
            m0.points[k].separation = this.m_manifold.points[k].separation;
            m0.points[k].id.features.set(this.m_manifold.points[k].id.features);
            ++k;
        }
        m0.pointCount = this.m_manifold.pointCount;
        CollideCircle.collidePolygonAndCircle(this.m_manifold, (PolygonShape)this.m_shape1, b1.getXForm(), (CircleShape)this.m_shape2, b2.getXForm());
        boolean[] persisted = new boolean[2];
        ContactPoint cp = new ContactPoint();
        cp.shape1 = this.m_shape1;
        cp.shape2 = this.m_shape2;
        cp.friction = this.m_friction;
        cp.restitution = this.m_restitution;
        if (this.m_manifold.pointCount > 0) {
            i = 0;
            while (i < this.m_manifold.pointCount) {
                ManifoldPoint mp = this.m_manifold.points[i];
                mp.normalImpulse = 0.0f;
                mp.tangentImpulse = 0.0f;
                boolean found = false;
                ContactID id = new ContactID(mp.id);
                int j = 0;
                while (j < m0.pointCount) {
                    if (!persisted[j]) {
                        ManifoldPoint mp0 = m0.points[j];
                        if (mp0.id.isEqual(id)) {
                            persisted[j] = true;
                            mp.normalImpulse = mp0.normalImpulse;
                            mp.tangentImpulse = mp0.tangentImpulse;
                            found = true;
                            if (listener == null) break;
                            cp.position = b1.getWorldPoint(mp.localPoint1);
                            Vec2 v1 = b1.getLinearVelocityFromLocalPoint(mp.localPoint1);
                            Vec2 v2 = b2.getLinearVelocityFromLocalPoint(mp.localPoint2);
                            cp.velocity = v2.sub(v1);
                            cp.normal = this.m_manifold.normal.clone();
                            cp.separation = mp.separation;
                            cp.id = new ContactID(id);
                            listener.persist(cp);
                            break;
                        }
                    }
                    ++j;
                }
                if (!found && listener != null) {
                    cp.position = b1.getWorldPoint(mp.localPoint1);
                    Vec2 v1 = b1.getLinearVelocityFromLocalPoint(mp.localPoint1);
                    Vec2 v2 = b2.getLinearVelocityFromLocalPoint(mp.localPoint2);
                    cp.velocity = v2.sub(v1);
                    cp.normal = this.m_manifold.normal.clone();
                    cp.separation = mp.separation;
                    cp.id = new ContactID(id);
                    listener.add(cp);
                }
                ++i;
            }
            this.m_manifoldCount = 1;
        } else {
            this.m_manifoldCount = 0;
        }
        if (listener == null) {
            return;
        }
        i = 0;
        while (i < m0.pointCount) {
            if (!persisted[i]) {
                ManifoldPoint mp0 = m0.points[i];
                cp.position = b1.getWorldPoint(mp0.localPoint1);
                Vec2 v1 = b1.getLinearVelocityFromLocalPoint(mp0.localPoint1);
                Vec2 v2 = b2.getLinearVelocityFromLocalPoint(mp0.localPoint2);
                cp.velocity = v2.sub(v1);
                cp.normal = m0.normal.clone();
                cp.separation = mp0.separation;
                cp.id = new ContactID(mp0.id);
                listener.remove(cp);
            }
            ++i;
        }
    }
}

