/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.GearJointDef;
import org.jbox2d.dynamics.joints.Jacobian;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.JointType;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.RevoluteJoint;

public class GearJoint
extends Joint {
    public Body m_ground1;
    public Body m_ground2;
    public RevoluteJoint m_revolute1;
    public PrismaticJoint m_prismatic1;
    public RevoluteJoint m_revolute2;
    public PrismaticJoint m_prismatic2;
    public Vec2 m_groundAnchor1;
    public Vec2 m_groundAnchor2;
    public Vec2 m_localAnchor1;
    public Vec2 m_localAnchor2;
    public Jacobian m_J = new Jacobian();
    public float m_constant;
    public float m_ratio;
    float m_mass;
    float m_force;

    public GearJoint(GearJointDef def) {
        super(def);
        float coordinate2;
        float coordinate1;
        JointType type1 = def.joint1.getType();
        JointType type2 = def.joint2.getType();
        assert (type1 == JointType.REVOLUTE_JOINT || type1 == JointType.PRISMATIC_JOINT);
        assert (type2 == JointType.REVOLUTE_JOINT || type2 == JointType.PRISMATIC_JOINT);
        assert (def.joint1.getBody1().isStatic());
        assert (def.joint2.getBody1().isStatic());
        this.m_revolute1 = null;
        this.m_prismatic1 = null;
        this.m_revolute2 = null;
        this.m_prismatic2 = null;
        this.m_ground1 = def.joint1.getBody1();
        this.m_body1 = def.joint1.getBody2();
        if (type1 == JointType.REVOLUTE_JOINT) {
            this.m_revolute1 = (RevoluteJoint)def.joint1;
            this.m_groundAnchor1 = this.m_revolute1.m_localAnchor1;
            this.m_localAnchor1 = this.m_revolute1.m_localAnchor2;
            coordinate1 = this.m_revolute1.getJointAngle();
        } else {
            this.m_prismatic1 = (PrismaticJoint)def.joint1;
            this.m_groundAnchor1 = this.m_prismatic1.m_localAnchor1;
            this.m_localAnchor1 = this.m_prismatic1.m_localAnchor2;
            coordinate1 = this.m_prismatic1.getJointTranslation();
        }
        this.m_ground2 = def.joint2.getBody1();
        this.m_body2 = def.joint2.getBody2();
        if (type2 == JointType.REVOLUTE_JOINT) {
            this.m_revolute2 = (RevoluteJoint)def.joint2;
            this.m_groundAnchor2 = this.m_revolute2.m_localAnchor1;
            this.m_localAnchor2 = this.m_revolute2.m_localAnchor2;
            coordinate2 = this.m_revolute2.getJointAngle();
        } else {
            this.m_prismatic2 = (PrismaticJoint)def.joint2;
            this.m_groundAnchor2 = this.m_prismatic2.m_localAnchor1;
            this.m_localAnchor2 = this.m_prismatic2.m_localAnchor2;
            coordinate2 = this.m_prismatic2.getJointTranslation();
        }
        this.m_ratio = def.ratio;
        this.m_constant = coordinate1 + this.m_ratio * coordinate2;
        this.m_force = 0.0f;
    }

    public void initVelocityConstraints(TimeStep step) {
        float crug;
        Vec2 r;
        Vec2 ug;
        Body g1 = this.m_ground1;
        Body g2 = this.m_ground2;
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        float K = 0.0f;
        this.m_J.setZero();
        if (this.m_revolute1 != null) {
            this.m_J.angular1 = -1.0f;
            K += b1.m_invI;
        } else {
            ug = Mat22.mul(g1.getXForm().R, this.m_prismatic1.m_localXAxis1);
            r = Mat22.mul(b1.getXForm().R, this.m_localAnchor1.sub(b1.getLocalCenter()));
            crug = Vec2.cross(r, ug);
            this.m_J.linear1 = ug.negate();
            this.m_J.angular1 = -crug;
            K += b1.m_invMass + b1.m_invI * crug * crug;
        }
        if (this.m_revolute2 != null) {
            this.m_J.angular2 = -this.m_ratio;
            K += this.m_ratio * this.m_ratio * b2.m_invI;
        } else {
            ug = Mat22.mul(g2.getXForm().R, this.m_prismatic2.m_localXAxis1);
            r = Mat22.mul(b2.getXForm().R, this.m_localAnchor2.sub(b2.getLocalCenter()));
            crug = Vec2.cross(r, ug);
            this.m_J.linear2 = ug.mulLocal(-this.m_ratio);
            this.m_J.angular2 = -this.m_ratio * crug;
            K += this.m_ratio * this.m_ratio * (b2.m_invMass + b2.m_invI * crug * crug);
        }
        assert (K > 0.0f);
        this.m_mass = 1.0f / K;
        if (step.warmStarting) {
            float P = step.dt * this.m_force;
            b1.m_linearVelocity.x += b1.m_invMass * P * this.m_J.linear1.x;
            b1.m_linearVelocity.y += b1.m_invMass * P * this.m_J.linear1.y;
            b1.m_angularVelocity += b1.m_invI * P * this.m_J.angular1;
            b2.m_linearVelocity.x += b2.m_invMass * P * this.m_J.linear2.x;
            b2.m_linearVelocity.y += b2.m_invMass * P * this.m_J.linear2.y;
            b2.m_angularVelocity += b2.m_invI * P * this.m_J.angular2;
        } else {
            this.m_force = 0.0f;
        }
    }

    public void solveVelocityConstraints(TimeStep step) {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        float Cdot = this.m_J.compute(b1.m_linearVelocity, b1.m_angularVelocity, b2.m_linearVelocity, b2.m_angularVelocity);
        float force = -step.inv_dt * this.m_mass * Cdot;
        this.m_force += force;
        float P = step.dt * force;
        b1.m_linearVelocity.x += b1.m_invMass * P * this.m_J.linear1.x;
        b1.m_linearVelocity.y += b1.m_invMass * P * this.m_J.linear1.y;
        b1.m_angularVelocity += b1.m_invI * P * this.m_J.angular1;
        b2.m_linearVelocity.x += b2.m_invMass * P * this.m_J.linear2.x;
        b2.m_linearVelocity.y += b2.m_invMass * P * this.m_J.linear2.y;
        b2.m_angularVelocity += b2.m_invI * P * this.m_J.angular2;
    }

    public boolean solvePositionConstraints() {
        float linearError = 0.0f;
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        float coordinate1 = this.m_revolute1 != null ? this.m_revolute1.getJointAngle() : this.m_prismatic1.getJointTranslation();
        float coordinate2 = this.m_revolute2 != null ? this.m_revolute2.getJointAngle() : this.m_prismatic2.getJointTranslation();
        float C = this.m_constant - (coordinate1 + this.m_ratio * coordinate2);
        float impulse = -this.m_mass * C;
        b1.m_sweep.c.x += b1.m_invMass * impulse * this.m_J.linear1.x;
        b1.m_sweep.c.y += b1.m_invMass * impulse * this.m_J.linear1.y;
        b1.m_sweep.a += b1.m_invI * impulse * this.m_J.angular1;
        b2.m_sweep.c.x += b2.m_invMass * impulse * this.m_J.linear2.x;
        b2.m_sweep.c.y += b2.m_invMass * impulse * this.m_J.linear2.y;
        b2.m_sweep.a += b2.m_invI * impulse * this.m_J.angular2;
        b1.synchronizeTransform();
        b2.synchronizeTransform();
        return linearError < 0.005f;
    }

    public Vec2 getAnchor1() {
        return this.m_body1.getWorldPoint(this.m_localAnchor1);
    }

    public Vec2 getAnchor2() {
        return this.m_body2.getWorldPoint(this.m_localAnchor2);
    }

    public Vec2 getReactionForce() {
        return new Vec2(this.m_force * this.m_J.linear2.x, this.m_force * this.m_J.linear2.y);
    }

    public float getReactionTorque() {
        Vec2 r = Mat22.mul(this.m_body2.getXForm().R, this.m_localAnchor2.sub(this.m_body2.getLocalCenter()));
        Vec2 F = new Vec2(this.m_force * this.m_J.linear2.x, this.m_force * this.m_J.linear2.y);
        float T = this.m_force * this.m_J.angular2 - Vec2.cross(r, F);
        return T;
    }

    public float getRatio() {
        return this.m_ratio;
    }
}

