/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.DistanceJoint;
import org.jbox2d.dynamics.joints.DistanceJointDef;
import org.jbox2d.dynamics.joints.GearJoint;
import org.jbox2d.dynamics.joints.GearJointDef;
import org.jbox2d.dynamics.joints.JointDef;
import org.jbox2d.dynamics.joints.JointEdge;
import org.jbox2d.dynamics.joints.JointType;
import org.jbox2d.dynamics.joints.MouseJoint;
import org.jbox2d.dynamics.joints.MouseJointDef;
import org.jbox2d.dynamics.joints.PrismaticJoint;
import org.jbox2d.dynamics.joints.PrismaticJointDef;
import org.jbox2d.dynamics.joints.PulleyJoint;
import org.jbox2d.dynamics.joints.PulleyJointDef;
import org.jbox2d.dynamics.joints.RevoluteJoint;
import org.jbox2d.dynamics.joints.RevoluteJointDef;

public abstract class Joint {
    public JointType m_type;
    public Joint m_prev;
    public Joint m_next;
    public JointEdge m_node1;
    public JointEdge m_node2;
    public Body m_body1;
    public Body m_body2;
    public boolean m_islandFlag;
    public boolean m_collideConnected;
    public Object m_userData;
    public float m_inv_dt;

    public Joint(JointDef description) {
        this.m_type = description.type;
        this.m_prev = null;
        this.m_next = null;
        this.m_node1 = new JointEdge();
        this.m_node2 = new JointEdge();
        this.m_body1 = description.body1;
        this.m_body2 = description.body2;
        this.m_collideConnected = description.collideConnected;
        this.m_islandFlag = false;
        this.m_userData = description.userData;
    }

    public static void destroy(Joint j) {
        j.destructor();
    }

    public void destructor() {
    }

    public static Joint create(JointDef description) {
        Joint joint = null;
        if (description.type == JointType.DISTANCE_JOINT) {
            joint = new DistanceJoint((DistanceJointDef)description);
        } else if (description.type == JointType.MOUSE_JOINT) {
            joint = new MouseJoint((MouseJointDef)description);
        } else if (description.type == JointType.PRISMATIC_JOINT) {
            joint = new PrismaticJoint((PrismaticJointDef)description);
        } else if (description.type == JointType.REVOLUTE_JOINT) {
            joint = new RevoluteJoint((RevoluteJointDef)description);
        } else if (description.type == JointType.PULLEY_JOINT) {
            joint = new PulleyJoint((PulleyJointDef)description);
        } else if (description.type == JointType.GEAR_JOINT) {
            joint = new GearJoint((GearJointDef)description);
        } else assert (false);
        return joint;
    }

    public JointType getType() {
        return this.m_type;
    }

    public Body getBody1() {
        return this.m_body1;
    }

    public Body getBody2() {
        return this.m_body2;
    }

    public abstract Vec2 getAnchor1();

    public abstract Vec2 getAnchor2();

    public abstract Vec2 getReactionForce();

    public abstract float getReactionTorque();

    public Joint getNext() {
        return this.m_next;
    }

    public Object getUserData() {
        return this.m_userData;
    }

    public void setUserData(Object o) {
        this.m_userData = o;
    }

    public abstract void initVelocityConstraints(TimeStep var1);

    public abstract void solveVelocityConstraints(TimeStep var1);

    public void initPositionConstraints() {
    }

    public abstract boolean solvePositionConstraints();
}

