/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.Vec2;
import org.jbox2d.common.XForm;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.MouseJointDef;

public class MouseJoint
extends Joint {
    public Vec2 m_localAnchor;
    public Vec2 m_target;
    public Vec2 m_force = new Vec2();
    public Mat22 m_mass;
    public Vec2 m_C;
    public float m_maxForce;
    public float m_beta;
    public float m_gamma;

    public MouseJoint(MouseJointDef def) {
        super(def);
        this.m_target = new Vec2();
        this.m_C = new Vec2();
        this.m_mass = new Mat22();
        this.m_target = def.target;
        this.m_localAnchor = XForm.mulT(this.m_body2.m_xf, this.m_target);
        this.m_maxForce = def.maxForce;
        float mass = this.m_body2.m_mass;
        float omega = (float)Math.PI * 2 * def.frequencyHz;
        float d = 2.0f * mass * def.dampingRatio * omega;
        float k = mass * omega * omega;
        this.m_gamma = 1.0f / (d + def.timeStep * k);
        this.m_beta = def.timeStep * k / (d + def.timeStep * k);
    }

    public void setTarget(Vec2 target) {
        if (this.m_body2.isSleeping()) {
            this.m_body2.wakeUp();
        }
        this.m_target = target;
    }

    public Vec2 getAnchor1() {
        return this.m_target;
    }

    public Vec2 getAnchor2() {
        return this.m_body2.getWorldPoint(this.m_localAnchor);
    }

    public void initVelocityConstraints(TimeStep step) {
        Body b = this.m_body2;
        Vec2 r = Mat22.mul(b.m_xf.R, this.m_localAnchor.sub(b.getLocalCenter()));
        float invMass = b.m_invMass;
        float invI = b.m_invI;
        Mat22 K1 = new Mat22(invMass, 0.0f, 0.0f, invMass);
        Mat22 K2 = new Mat22(invI * r.y * r.y, -invI * r.x * r.y, -invI * r.x * r.y, invI * r.x * r.x);
        Mat22 K = K1.add(K2);
        K.col1.x += this.m_gamma;
        K.col2.y += this.m_gamma;
        this.m_mass.set(K);
        this.m_mass = this.m_mass.invert();
        this.m_C.set(b.m_sweep.c.x + r.x - this.m_target.x, b.m_sweep.c.y + r.y - this.m_target.y);
        b.m_angularVelocity *= 0.98f;
        float Px = step.dt * this.m_force.x;
        float Py = step.dt * this.m_force.y;
        b.m_linearVelocity.x += invMass * Px;
        b.m_linearVelocity.y += invMass * Py;
        b.m_angularVelocity += invI * (r.x * Py - r.y * Px);
    }

    public boolean solvePositionConstraints() {
        return true;
    }

    public void solveVelocityConstraints(TimeStep step) {
        Body b = this.m_body2;
        Vec2 r = Mat22.mul(b.m_xf.R, this.m_localAnchor.sub(b.getLocalCenter()));
        Vec2 Cdot = b.m_linearVelocity.add(Vec2.cross(b.m_angularVelocity, r));
        Vec2 force = new Vec2(Cdot.x + this.m_beta * step.inv_dt * this.m_C.x + this.m_gamma * step.dt * this.m_force.x, Cdot.y + this.m_beta * step.inv_dt * this.m_C.y + this.m_gamma * step.dt * this.m_force.y);
        force = Mat22.mul(this.m_mass, force);
        force.mulLocal(-step.inv_dt);
        Vec2 oldForce = this.m_force.clone();
        this.m_force.addLocal(force);
        float forceMagnitude = this.m_force.length();
        if (forceMagnitude > this.m_maxForce) {
            this.m_force.mulLocal(this.m_maxForce / forceMagnitude);
        }
        force.set(this.m_force.x - oldForce.x, this.m_force.y - oldForce.y);
        Vec2 P = new Vec2(step.dt * force.x, step.dt * force.y);
        b.m_linearVelocity.addLocal(P.mul(b.m_invMass));
        b.m_angularVelocity += b.m_invI * Vec2.cross(r, P);
    }

    public Vec2 getReactionForce() {
        return this.m_force;
    }

    public float getReactionTorque() {
        return 0.0f;
    }
}

