/*
 * Decompiled with CFR 0.152.
 */
package org.jbox2d.dynamics.joints;

import org.jbox2d.common.Mat22;
import org.jbox2d.common.MathUtils;
import org.jbox2d.common.Vec2;
import org.jbox2d.dynamics.Body;
import org.jbox2d.dynamics.TimeStep;
import org.jbox2d.dynamics.joints.Jacobian;
import org.jbox2d.dynamics.joints.Joint;
import org.jbox2d.dynamics.joints.LimitState;
import org.jbox2d.dynamics.joints.PrismaticJointDef;

public class PrismaticJoint
extends Joint {
    public Vec2 m_localAnchor1;
    public Vec2 m_localAnchor2;
    public Vec2 m_localXAxis1;
    public Vec2 m_localYAxis1;
    public float m_refAngle;
    public Jacobian m_linearJacobian;
    public float m_linearMass;
    public float m_force;
    public float m_angularMass;
    public float m_torque;
    public Jacobian m_motorJacobian;
    public float m_motorMass;
    public float m_motorForce;
    public float m_limitForce;
    public float m_limitPositionImpulse;
    public float m_lowerTranslation;
    public float m_upperTranslation;
    public float m_maxMotorForce;
    public float m_motorSpeed;
    public boolean m_enableLimit;
    public boolean m_enableMotor;
    public LimitState m_limitState;

    public PrismaticJoint(PrismaticJointDef def) {
        super(def);
        this.m_localAnchor1 = def.localAnchor1.clone();
        this.m_localAnchor2 = def.localAnchor2.clone();
        this.m_localXAxis1 = def.localAxis1.clone();
        this.m_localYAxis1 = Vec2.cross(1.0f, this.m_localXAxis1);
        this.m_refAngle = def.referenceAngle;
        this.m_linearJacobian = new Jacobian();
        this.m_linearJacobian.setZero();
        this.m_linearMass = 0.0f;
        this.m_force = 0.0f;
        this.m_angularMass = 0.0f;
        this.m_torque = 0.0f;
        this.m_motorJacobian = new Jacobian();
        this.m_motorJacobian.setZero();
        this.m_motorMass = 0.0f;
        this.m_motorForce = 0.0f;
        this.m_limitForce = 0.0f;
        this.m_limitPositionImpulse = 0.0f;
        this.m_lowerTranslation = def.lowerTranslation;
        this.m_upperTranslation = def.upperTranslation;
        this.m_maxMotorForce = def.maxMotorForce;
        this.m_motorSpeed = def.motorSpeed;
        this.m_enableLimit = def.enableLimit;
        this.m_enableMotor = def.enableMotor;
    }

    public void initVelocityConstraints(TimeStep step) {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 r1 = Mat22.mul(b1.m_xf.R, this.m_localAnchor1.sub(b1.getLocalCenter()));
        Vec2 r2 = Mat22.mul(b2.m_xf.R, this.m_localAnchor2.sub(b2.getLocalCenter()));
        float invMass1 = b1.m_invMass;
        float invMass2 = b2.m_invMass;
        float invI1 = b1.m_invI;
        float invI2 = b2.m_invI;
        Vec2 ay1 = Mat22.mul(b1.m_xf.R, this.m_localYAxis1);
        Vec2 e = b2.m_sweep.c.add(r2).subLocal(b1.m_sweep.c);
        this.m_linearJacobian.set(ay1.negate(), -Vec2.cross(e, ay1), ay1, Vec2.cross(r2, ay1));
        this.m_linearMass = invMass1 + invI1 * this.m_linearJacobian.angular1 * this.m_linearJacobian.angular1 + invMass2 + invI2 * this.m_linearJacobian.angular2 * this.m_linearJacobian.angular2;
        assert (this.m_linearMass > 1.1920929E-7f);
        this.m_linearMass = 1.0f / this.m_linearMass;
        this.m_angularMass = invI1 + invI2;
        if (this.m_angularMass > 1.1920929E-7f) {
            this.m_angularMass = 1.0f / this.m_angularMass;
        }
        if (this.m_enableLimit || this.m_enableMotor) {
            Vec2 ax1 = Mat22.mul(b1.m_xf.R, this.m_localXAxis1);
            this.m_motorJacobian.set(ax1.negate(), -Vec2.cross(e, ax1), ax1, Vec2.cross(r2, ax1));
            this.m_motorMass = invMass1 + invI1 * this.m_motorJacobian.angular1 * this.m_motorJacobian.angular1 + invMass2 + invI2 * this.m_motorJacobian.angular2 * this.m_motorJacobian.angular2;
            assert (this.m_motorMass > 1.1920929E-7f);
            this.m_motorMass = 1.0f / this.m_motorMass;
            if (this.m_enableLimit) {
                Vec2 d = e.sub(r1);
                float jointTranslation = Vec2.dot(ax1, d);
                if (Math.abs(this.m_upperTranslation - this.m_lowerTranslation) < 0.01f) {
                    this.m_limitState = LimitState.EQUAL_LIMITS;
                } else if (jointTranslation <= this.m_lowerTranslation) {
                    if (this.m_limitState != LimitState.AT_LOWER_LIMIT) {
                        this.m_limitForce = 0.0f;
                    }
                    this.m_limitState = LimitState.AT_LOWER_LIMIT;
                } else if (jointTranslation >= this.m_upperTranslation) {
                    if (this.m_limitState != LimitState.AT_UPPER_LIMIT) {
                        this.m_limitForce = 0.0f;
                    }
                    this.m_limitState = LimitState.AT_UPPER_LIMIT;
                } else {
                    this.m_limitState = LimitState.INACTIVE_LIMIT;
                    this.m_limitForce = 0.0f;
                }
            }
        }
        if (!this.m_enableMotor) {
            this.m_motorForce = 0.0f;
        }
        if (!this.m_enableLimit) {
            this.m_limitForce = 0.0f;
        }
        if (step.warmStarting) {
            Vec2 P1 = new Vec2(step.dt * (this.m_force * this.m_linearJacobian.linear1.x + (this.m_motorForce + this.m_limitForce) * this.m_motorJacobian.linear1.x), step.dt * (this.m_force * this.m_linearJacobian.linear1.y + (this.m_motorForce + this.m_limitForce) * this.m_motorJacobian.linear1.y));
            Vec2 P2 = new Vec2(step.dt * (this.m_force * this.m_linearJacobian.linear2.x + (this.m_motorForce + this.m_limitForce) * this.m_motorJacobian.linear2.x), step.dt * (this.m_force * this.m_linearJacobian.linear2.y + (this.m_motorForce + this.m_limitForce) * this.m_motorJacobian.linear2.y));
            float L1 = step.dt * (this.m_force * this.m_linearJacobian.angular1 - this.m_torque + (this.m_motorForce + this.m_limitForce) * this.m_motorJacobian.angular1);
            float L2 = step.dt * (this.m_force * this.m_linearJacobian.angular2 + this.m_torque + (this.m_motorForce + this.m_limitForce) * this.m_motorJacobian.angular2);
            b1.m_linearVelocity.x += invMass1 * P1.x;
            b1.m_linearVelocity.y += invMass1 * P1.y;
            b1.m_angularVelocity += invI1 * L1;
            b2.m_linearVelocity.x += invMass2 * P2.x;
            b2.m_linearVelocity.y += invMass2 * P2.y;
            b2.m_angularVelocity += invI2 * L2;
        } else {
            this.m_force = 0.0f;
            this.m_torque = 0.0f;
            this.m_limitForce = 0.0f;
            this.m_motorForce = 0.0f;
        }
        this.m_limitPositionImpulse = 0.0f;
    }

    public void solveVelocityConstraints(TimeStep step) {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        float invMass1 = b1.m_invMass;
        float invMass2 = b2.m_invMass;
        float invI1 = b1.m_invI;
        float invI2 = b2.m_invI;
        float linearCdot = this.m_linearJacobian.compute(b1.m_linearVelocity, b1.m_angularVelocity, b2.m_linearVelocity, b2.m_angularVelocity);
        float force = -step.inv_dt * this.m_linearMass * linearCdot;
        this.m_force += force;
        float P = step.dt * force;
        b1.m_linearVelocity.x += invMass1 * P * this.m_linearJacobian.linear1.x;
        b1.m_linearVelocity.y += invMass1 * P * this.m_linearJacobian.linear1.y;
        b1.m_angularVelocity += invI1 * P * this.m_linearJacobian.angular1;
        b2.m_linearVelocity.x += invMass2 * P * this.m_linearJacobian.linear2.x;
        b2.m_linearVelocity.y += invMass2 * P * this.m_linearJacobian.linear2.y;
        b2.m_angularVelocity += invI2 * P * this.m_linearJacobian.angular2;
        float angularCdot = b2.m_angularVelocity - b1.m_angularVelocity;
        float torque = -step.inv_dt * this.m_angularMass * angularCdot;
        this.m_torque += torque;
        float L = step.dt * torque;
        b1.m_angularVelocity -= invI1 * L;
        b2.m_angularVelocity += invI2 * L;
        if (this.m_enableMotor && this.m_limitState != LimitState.EQUAL_LIMITS) {
            float motorCdot = this.m_motorJacobian.compute(b1.m_linearVelocity, b1.m_angularVelocity, b2.m_linearVelocity, b2.m_angularVelocity) - this.m_motorSpeed;
            float motorForce = -step.inv_dt * this.m_motorMass * motorCdot;
            float oldMotorForce = this.m_motorForce;
            this.m_motorForce = MathUtils.clamp(this.m_motorForce + motorForce, -this.m_maxMotorForce, this.m_maxMotorForce);
            motorForce = this.m_motorForce - oldMotorForce;
            float P2 = step.dt * motorForce;
            b1.m_linearVelocity.x += invMass1 * P2 * this.m_motorJacobian.linear1.x;
            b1.m_linearVelocity.y += invMass1 * P2 * this.m_motorJacobian.linear1.y;
            b1.m_angularVelocity += invI1 * P2 * this.m_motorJacobian.angular1;
            b2.m_linearVelocity.x += invMass2 * P2 * this.m_motorJacobian.linear2.x;
            b2.m_linearVelocity.y += invMass2 * P2 * this.m_motorJacobian.linear2.y;
            b2.m_angularVelocity += invI2 * P2 * this.m_motorJacobian.angular2;
        }
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE_LIMIT) {
            float oldLimitForce;
            float limitCdot = this.m_motorJacobian.compute(b1.m_linearVelocity, b1.m_angularVelocity, b2.m_linearVelocity, b2.m_angularVelocity);
            float limitForce = -step.inv_dt * this.m_motorMass * limitCdot;
            if (this.m_limitState == LimitState.EQUAL_LIMITS) {
                this.m_limitForce += limitForce;
            } else if (this.m_limitState == LimitState.AT_LOWER_LIMIT) {
                oldLimitForce = this.m_limitForce;
                this.m_limitForce = Math.max(this.m_limitForce + limitForce, 0.0f);
                limitForce = this.m_limitForce - oldLimitForce;
            } else if (this.m_limitState == LimitState.AT_UPPER_LIMIT) {
                oldLimitForce = this.m_limitForce;
                this.m_limitForce = Math.min(this.m_limitForce + limitForce, 0.0f);
                limitForce = this.m_limitForce - oldLimitForce;
            }
            float P2 = step.dt * limitForce;
            b1.m_linearVelocity.x += invMass1 * P2 * this.m_motorJacobian.linear1.x;
            b1.m_linearVelocity.y += invMass1 * P2 * this.m_motorJacobian.linear1.y;
            b1.m_angularVelocity += invI1 * P2 * this.m_motorJacobian.angular1;
            b2.m_linearVelocity.x += invMass2 * P2 * this.m_motorJacobian.linear2.x;
            b2.m_linearVelocity.y += invMass2 * P2 * this.m_motorJacobian.linear2.y;
            b2.m_angularVelocity += invI2 * P2 * this.m_motorJacobian.angular2;
        }
    }

    public boolean solvePositionConstraints() {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        float invMass1 = b1.m_invMass;
        float invMass2 = b2.m_invMass;
        float invI1 = b1.m_invI;
        float invI2 = b2.m_invI;
        Vec2 r1 = Mat22.mul(b1.m_xf.R, this.m_localAnchor1.sub(b1.getLocalCenter()));
        Vec2 r2 = Mat22.mul(b2.m_xf.R, this.m_localAnchor2.sub(b2.getLocalCenter()));
        Vec2 p1 = b1.m_sweep.c.add(r1);
        Vec2 p2 = b2.m_sweep.c.add(r2);
        Vec2 d = p2.sub(p1);
        Vec2 ay1 = Mat22.mul(b1.m_xf.R, this.m_localYAxis1);
        float linearC = Vec2.dot(ay1, d);
        linearC = MathUtils.clamp(linearC, -0.2f, 0.2f);
        float linearImpulse = -this.m_linearMass * linearC;
        b1.m_sweep.c.x += invMass1 * linearImpulse * this.m_linearJacobian.linear1.x;
        b1.m_sweep.c.y += invMass1 * linearImpulse * this.m_linearJacobian.linear1.y;
        b1.m_sweep.a += invI1 * linearImpulse * this.m_linearJacobian.angular1;
        b2.m_sweep.c.x += invMass2 * linearImpulse * this.m_linearJacobian.linear2.x;
        b2.m_sweep.c.y += invMass2 * linearImpulse * this.m_linearJacobian.linear2.y;
        b2.m_sweep.a += invI2 * linearImpulse * this.m_linearJacobian.angular2;
        float positionError = Math.abs(linearC);
        float angularC = b2.m_sweep.a - b1.m_sweep.a - this.m_refAngle;
        angularC = MathUtils.clamp(angularC, -0.13962635f, 0.13962635f);
        float angularImpulse = -this.m_angularMass * angularC;
        b1.m_sweep.a -= b1.m_invI * angularImpulse;
        b2.m_sweep.a += b2.m_invI * angularImpulse;
        b1.synchronizeTransform();
        b2.synchronizeTransform();
        float angularError = Math.abs(angularC);
        if (this.m_enableLimit && this.m_limitState != LimitState.INACTIVE_LIMIT) {
            Vec2 r1z = Mat22.mul(b1.m_xf.R, this.m_localAnchor1.sub(b1.getLocalCenter()));
            Vec2 r2z = Mat22.mul(b2.m_xf.R, this.m_localAnchor2.sub(b2.getLocalCenter()));
            Vec2 p1z = b1.m_sweep.c.add(r1z);
            Vec2 p2z = b2.m_sweep.c.add(r2z);
            Vec2 dz = p2z.sub(p1z);
            Vec2 ax1 = Mat22.mul(b1.m_xf.R, this.m_localXAxis1);
            float translation = Vec2.dot(ax1, dz);
            float limitImpulse = 0.0f;
            if (this.m_limitState == LimitState.EQUAL_LIMITS) {
                float limitC = MathUtils.clamp(translation, -0.2f, 0.2f);
                limitImpulse = -this.m_motorMass * limitC;
                positionError = Math.max(positionError, Math.abs(angularC));
            } else if (this.m_limitState == LimitState.AT_LOWER_LIMIT) {
                float limitC = translation - this.m_lowerTranslation;
                positionError = Math.max(positionError, -limitC);
                limitC = MathUtils.clamp(limitC + 0.005f, -0.2f, 0.0f);
                limitImpulse = -this.m_motorMass * limitC;
                float oldLimitImpulse = this.m_limitPositionImpulse;
                this.m_limitPositionImpulse = Math.max(this.m_limitPositionImpulse + limitImpulse, 0.0f);
                limitImpulse = this.m_limitPositionImpulse - oldLimitImpulse;
            } else if (this.m_limitState == LimitState.AT_UPPER_LIMIT) {
                float limitC = translation - this.m_upperTranslation;
                positionError = Math.max(positionError, limitC);
                limitC = MathUtils.clamp(limitC - 0.005f, 0.0f, 0.2f);
                limitImpulse = -this.m_motorMass * limitC;
                float oldLimitImpulse = this.m_limitPositionImpulse;
                this.m_limitPositionImpulse = Math.min(this.m_limitPositionImpulse + limitImpulse, 0.0f);
                limitImpulse = this.m_limitPositionImpulse - oldLimitImpulse;
            }
            b1.m_sweep.c.x += invMass1 * limitImpulse * this.m_motorJacobian.linear1.x;
            b1.m_sweep.c.y += invMass1 * limitImpulse * this.m_motorJacobian.linear1.y;
            b1.m_sweep.a += invI1 * limitImpulse * this.m_motorJacobian.angular1;
            b2.m_sweep.c.x += invMass2 * limitImpulse * this.m_motorJacobian.linear2.x;
            b2.m_sweep.c.y += invMass2 * limitImpulse * this.m_motorJacobian.linear2.y;
            b2.m_sweep.a += invI2 * limitImpulse * this.m_motorJacobian.angular2;
            b1.synchronizeTransform();
            b2.synchronizeTransform();
        }
        return positionError <= 0.005f && angularError <= 0.03490659f;
    }

    public Vec2 getAnchor1() {
        return this.m_body1.getWorldPoint(this.m_localAnchor1);
    }

    public Vec2 getAnchor2() {
        return this.m_body2.getWorldPoint(this.m_localAnchor2);
    }

    public float getJointTranslation() {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 p1 = b1.getWorldPoint(this.m_localAnchor1);
        Vec2 p2 = b2.getWorldPoint(this.m_localAnchor2);
        Vec2 d = p2.sub(p1);
        Vec2 axis = b1.getWorldVector(this.m_localXAxis1);
        float translation = Vec2.dot(d, axis);
        return translation;
    }

    public float getJointSpeed() {
        Body b1 = this.m_body1;
        Body b2 = this.m_body2;
        Vec2 r1 = Mat22.mul(b1.m_xf.R, this.m_localAnchor1.sub(b1.getLocalCenter()));
        Vec2 r2 = Mat22.mul(b2.m_xf.R, this.m_localAnchor2.sub(b2.getLocalCenter()));
        Vec2 p1 = b1.m_sweep.c.add(r1);
        Vec2 p2 = b2.m_sweep.c.add(r2);
        Vec2 d = p2.sub(p1);
        Vec2 axis = b1.getWorldVector(this.m_localXAxis1);
        Vec2 v1 = b1.m_linearVelocity;
        Vec2 v2 = b2.m_linearVelocity;
        float w1 = b1.m_angularVelocity;
        float w2 = b2.m_angularVelocity;
        float speed = Vec2.dot(d, Vec2.cross(w1, axis)) + Vec2.dot(axis, v2.add(Vec2.cross(w2, r2)).subLocal(v1).subLocal(Vec2.cross(w1, r1)));
        return speed;
    }

    public float getReactionTorque() {
        return this.m_torque;
    }

    public Vec2 getReactionForce() {
        Vec2 ax1 = Mat22.mul(this.m_body1.m_xf.R, this.m_localXAxis1);
        Vec2 ay1 = Mat22.mul(this.m_body1.m_xf.R, this.m_localYAxis1);
        return new Vec2(this.m_limitForce * ax1.x + this.m_force * ay1.x, this.m_limitForce * ax1.y + this.m_force * ay1.y);
    }

    public boolean isLimitEnabled() {
        return this.m_enableLimit;
    }

    public void enableLimit(boolean flag) {
        this.m_enableLimit = flag;
    }

    public float getLowerLimit() {
        return this.m_lowerTranslation;
    }

    public float getUpperLimit() {
        return this.m_upperTranslation;
    }

    public void setLimits(float lower, float upper) {
        assert (lower <= upper);
        this.m_lowerTranslation = lower;
        this.m_upperTranslation = upper;
    }

    public boolean isMotorEnabled() {
        return this.m_enableMotor;
    }

    public void enableMotor(boolean flag) {
        this.m_enableMotor = flag;
    }

    public void setMotorSpeed(float speed) {
        this.m_motorSpeed = speed;
    }

    public float getMotorSpeed() {
        return this.m_motorSpeed;
    }

    public void setMaxMotorForce(float force) {
        this.m_maxMotorForce = force;
    }

    public float getMotorForce() {
        return this.m_motorForce;
    }
}

