/*
 * JBox2D - A Java Port of Erin Catto's Box2D
 * 
 * JBox2D homepage: http://jbox2d.sourceforge.net/ 
 * Box2D homepage: http://www.box2d.org
 * 
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any damages
 * arising from the use of this software.
 * 
 * Permission is granted to anyone to use this software for any purpose,
 * including commercial applications, and to alter it and redistribute it
 * freely, subject to the following restrictions:
 * 
 * 1. The origin of this software must not be misrepresented; you must not
 * claim that you wrote the original software. If you use this software
 * in a product, an acknowledgment in the product documentation would be
 * appreciated but is not required.
 * 2. Altered source versions must be plainly marked as such, and must not be
 * misrepresented as being the original software.
 * 3. This notice may not be removed or altered from any source distribution.
 */

package org.jbox2d.dynamics;

import org.jbox2d.dynamics.contacts.ContactPoint;
import org.jbox2d.dynamics.contacts.ContactResult;

//Updated to rev 143 of b2WorldCallbacks.h

/**
 * Implement this class to get collision results. You can use these results for
 * things like sounds and game logic. You can also get contact results by
 * traversing the contact lists after the time step. However, you might miss
 * some contacts because continuous physics leads to sub-stepping.
 * Additionally you may receive multiple callbacks for the same contact in a
 * single time step.
 * You should strive to make your callbacks efficient because there may be
 * many callbacks per time step.
 * <BR><BR><em>Warning</em>: The contact separation is the last computed value.
 * <BR><BR><em>Warning</em>: You cannot create/destroy Box2D entities inside these callbacks.
 * Buffer any such events and apply them at the end of the time step.
 */
public interface ContactListener {
	

		/**
		 * Called when a contact point is added. This includes the geometry
		 * and the forces.
		 */
		public void add(ContactPoint point);

		/**
		 * Called when a contact point persists. This includes the geometry
		 * and the forces.
		 */
		public void persist(ContactPoint point);

		/**
		 * Called when a contact point is removed. This includes the last
		 * computed geometry and forces.
		 */
		public void remove(ContactPoint point);
		
		public void result(ContactResult point);

}
