/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.image.common_utils;

import com.qcloud.image.common_utils.CommonFileUtils;
import java.io.FileInputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonCodecUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CommonCodecUtils.class);
    private static final String HMAC_SHA1 = "HmacSHA1";

    public static String Base64Encode(byte[] binaryData) {
        String encodedstr = new String(Base64.encodeBase64(binaryData));
        return encodedstr;
    }

    public static String getEntireFileSha1(String filePath) throws Exception {
        FileInputStream fileInputStream = null;
        try {
            String sha1Digest;
            fileInputStream = CommonFileUtils.getFileInputStream(filePath);
            String string = sha1Digest = DigestUtils.sha1Hex(fileInputStream);
            return string;
        }
        catch (Exception e) {
            String errMsg = "getFileSha1 occur a exception, file:" + filePath + ", exception:" + e.toString();
            LOG.error(errMsg);
            throw new Exception(errMsg);
        }
        finally {
            CommonFileUtils.closeFileStream(fileInputStream, filePath);
        }
    }

    public static byte[] HmacSha1(byte[] binaryData, String key) throws Exception {
        try {
            Mac mac = Mac.getInstance(HMAC_SHA1);
            SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(), HMAC_SHA1);
            mac.init(secretKey);
            byte[] HmacSha1Digest = mac.doFinal(binaryData);
            return HmacSha1Digest;
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("mac not find algorithm {}", (Object)HMAC_SHA1);
            throw e;
        }
        catch (InvalidKeyException e) {
            LOG.error("mac init key {} occur a error {}", (Object)key, (Object)e.toString());
            throw e;
        }
        catch (IllegalStateException e) {
            LOG.error("mac.doFinal occur a error {}", (Object)e.toString());
            throw e;
        }
    }

    public static byte[] HmacSha1(String plainText, String key) throws Exception {
        return CommonCodecUtils.HmacSha1(plainText.getBytes(), key);
    }
}

