/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.image.op;

import com.qcloud.image.ClientConfig;
import com.qcloud.image.common_utils.CommonCodecUtils;
import com.qcloud.image.common_utils.CommonFileUtils;
import com.qcloud.image.exception.AbstractImageException;
import com.qcloud.image.exception.ParamException;
import com.qcloud.image.http.AbstractImageHttpClient;
import com.qcloud.image.http.HttpContentType;
import com.qcloud.image.http.HttpMethod;
import com.qcloud.image.http.HttpRequest;
import com.qcloud.image.op.BaseOp;
import com.qcloud.image.request.AbstractBaseRequest;
import com.qcloud.image.request.FaceAddFaceRequest;
import com.qcloud.image.request.FaceAddGroupIdsRequest;
import com.qcloud.image.request.FaceCompareRequest;
import com.qcloud.image.request.FaceDelFaceRequest;
import com.qcloud.image.request.FaceDelGroupIdsRequest;
import com.qcloud.image.request.FaceDelPersonRequest;
import com.qcloud.image.request.FaceDetectRequest;
import com.qcloud.image.request.FaceGetFaceIdsRequest;
import com.qcloud.image.request.FaceGetFaceInfoRequest;
import com.qcloud.image.request.FaceGetGroupIdsRequest;
import com.qcloud.image.request.FaceGetInfoRequest;
import com.qcloud.image.request.FaceGetPersonIdsRequest;
import com.qcloud.image.request.FaceIdCardCompareRequest;
import com.qcloud.image.request.FaceIdCardLiveDetectFourRequest;
import com.qcloud.image.request.FaceIdentifyRequest;
import com.qcloud.image.request.FaceLiveDetectFourRequest;
import com.qcloud.image.request.FaceLiveDetectPictureRequest;
import com.qcloud.image.request.FaceLiveGetFourRequest;
import com.qcloud.image.request.FaceMultiIdentifyRequest;
import com.qcloud.image.request.FaceNewPersonRequest;
import com.qcloud.image.request.FaceSetInfoRequest;
import com.qcloud.image.request.FaceShapeRequest;
import com.qcloud.image.request.FaceVerifyRequest;
import com.qcloud.image.request.GeneralOcrRequest;
import com.qcloud.image.request.IdcardDetectRequest;
import com.qcloud.image.request.NamecardDetectRequest;
import com.qcloud.image.request.OcrBankCardRequest;
import com.qcloud.image.request.OcrBizLicenseRequest;
import com.qcloud.image.request.OcrDrivingLicenceRequest;
import com.qcloud.image.request.OcrPlateRequest;
import com.qcloud.image.request.PornDetectRequest;
import com.qcloud.image.request.TagDetectRequest;
import com.qcloud.image.sign.Credentials;
import com.qcloud.image.sign.Sign;
import java.io.File;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetectionOp
extends BaseOp {
    private static final Logger LOG = LoggerFactory.getLogger(DetectionOp.class);

    public DetectionOp(ClientConfig config, Credentials cred, AbstractImageHttpClient client) {
        super(config, cred, client);
    }

    public String pornDetect(PornDetectRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getDetectionPorn();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.setMethod(HttpMethod.POST);
        if (request.isUrl()) {
            httpRequest.addParam("url_list", request.getUrlList());
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        } else {
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
            HashMap<String, String> keys = request.getKeyList();
            HashMap<String, File> images = request.getImageList();
            for (String k : keys.keySet()) {
                httpRequest.addFile(keys.get(k), images.get(k));
            }
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String tagDetect(TagDetectRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getDetectionTag();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        if (request.isUrl()) {
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.addParam("url", request.getUrl());
        } else {
            byte[] fileContentByte = null;
            try {
                fileContentByte = CommonFileUtils.getFileContentByte(request.getImage().getAbsolutePath());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String image = CommonCodecUtils.Base64Encode(fileContentByte);
            httpRequest.addParam("image", image);
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String idcardDetect(IdcardDetectRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getDetectionIdcard();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("card_type", String.valueOf(request.getCardType()));
        httpRequest.setMethod(HttpMethod.POST);
        if (request.isUrl()) {
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
            httpRequest.addParam("url_list", request.getUrlList());
        } else {
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
            HashMap<String, String> keys = request.getKeyList();
            HashMap<String, File> images = request.getImageList();
            for (String k : keys.keySet()) {
                httpRequest.addFile(keys.get(k), images.get(k));
            }
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String namecardDetect(NamecardDetectRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudOcrDomain() + this.config.getDetectionNamecard();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("ret_image", String.valueOf(request.getRetImage()));
        if (request.isUrl()) {
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.addParam("url_list", request.getUrlList());
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        } else {
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
            HashMap<String, String> keys = request.getKeyList();
            HashMap<String, File> images = request.getImageList();
            for (String k : keys.keySet()) {
                httpRequest.addFile(keys.get(k), images.get(k));
            }
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String generalOcr(GeneralOcrRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudOcrDomain() + "/ocr/general";
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        if (request.isUrl()) {
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.addParam("url", request.getUrl());
        } else {
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
            httpRequest.addFile("image", request.getImage());
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String ocrDrivingLicence(OcrDrivingLicenceRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudOcrDomain() + "/ocr/drivinglicence";
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("type", request.getType());
        if (request.isUrl()) {
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.addParam("url", request.getUrl());
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        } else {
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
            httpRequest.addFile("image", request.getImage());
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String ocrBizLicense(OcrBizLicenseRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudOcrDomain() + "/ocr/bizlicense";
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        if (request.isUrl()) {
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.addParam("url", request.getUrl());
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        } else {
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
            httpRequest.addFile("image", request.getImage());
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String ocrBankCard(OcrBankCardRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudOcrDomain() + "/ocr/bankcard";
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        if (request.isUrl()) {
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.addParam("url", request.getUrl());
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        } else {
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
            httpRequest.addFile("image", request.getImage());
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String ocrPlate(OcrPlateRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudOcrDomain() + "/ocr/plate";
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        if (request.isUrl()) {
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.addParam("url", request.getUrl());
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        } else {
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
            httpRequest.addFile("image", request.getImage());
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceDetect(FaceDetectRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getDetectionFace();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("mode", request.getMode());
        if (request.isUrl()) {
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.addParam("url", request.getUrl());
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        } else {
            httpRequest.addFile("image", request.getImage());
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceShape(FaceShapeRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceShape();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("mode", request.getMode());
        if (request.isUrl()) {
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.addParam("url", request.getUrl());
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        } else {
            httpRequest.addFile("image", request.getImage());
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceNewPerson(FaceNewPersonRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceNewPerson();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("person_id", request.getPersonId());
        httpRequest.addParam("person_name", request.getPersonName());
        httpRequest.addParam("tag", request.getPersonTag());
        httpRequest.setMethod(HttpMethod.POST);
        if (request.isUrl()) {
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.addParam("url", request.getUrl());
            httpRequest.addParam("group_ids", request.getGroupIds());
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        } else {
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
            String[] groupIds = request.getGroupIds();
            for (int index = 0; index < groupIds.length; ++index) {
                String key = String.format("group_ids[%d]", index);
                String data = groupIds[index];
                httpRequest.addParam(key, data);
            }
            httpRequest.addFile("image", request.getImage());
            AbstractBaseRequest.BytesContent bytesContent = request.getBytesContent();
            if (bytesContent != null) {
                httpRequest.addBytes(bytesContent.getKey(), bytesContent.getContent());
            }
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceDelPerson(FaceDelPersonRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceDelPerson();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("person_id", request.getPersonId());
        httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceAddFace(FaceAddFaceRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceAddFace();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("person_id", String.valueOf(request.getPersonId()));
        httpRequest.addParam("tag", String.valueOf(request.getPersonTag()));
        httpRequest.setMethod(HttpMethod.POST);
        if (request.isUrl()) {
            httpRequest.addParam("urls", request.getUrlList());
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        } else {
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
            HashMap<String, String> keys = request.getKeyList();
            HashMap<String, File> images = request.getImageList();
            for (String k : keys.keySet()) {
                httpRequest.addFile(keys.get(k), images.get(k));
            }
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceDelFace(FaceDelFaceRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceDelFace();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("person_id", request.getPersonId());
        httpRequest.addParam("face_ids", request.getFaceIds());
        httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceSetInfo(FaceSetInfoRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceSetInfo();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("person_id", request.getPersonId());
        httpRequest.addParam("person_name", request.getPersonName());
        httpRequest.addParam("tag", request.getPersonTag());
        httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceGetInfo(FaceGetInfoRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceGetInfo();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("person_id", request.getPersonId());
        httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceGetGroupIds(FaceGetGroupIdsRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceGetGroupIdsInfo();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceAddGroupIds(FaceAddGroupIdsRequest request, boolean useNewDomain) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = useNewDomain ? "http://recognition.image.myqcloud.com/face/addgroupids" : "http://service.image.myqcloud.com/face/addgroupids";
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setUrl(url);
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("person_id", request.getPerson_id());
        httpRequest.addParam("group_ids", request.getGroup_ids());
        String session_id = request.getSession_id();
        if (session_id != null && !session_id.isEmpty()) {
            httpRequest.addParam("session_id", session_id);
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceDelGroupIds(FaceDelGroupIdsRequest request, boolean useNewDomain) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = useNewDomain ? "http://recognition.image.myqcloud.com/face/delgroupids" : "http://service.image.myqcloud.com/face/delgroupids";
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setUrl(url);
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("person_id", request.getPerson_id());
        httpRequest.addParam("group_ids", request.getGrooup_ids());
        String session_id = request.getSession_id();
        if (session_id != null && !session_id.isEmpty()) {
            httpRequest.addParam("session_id", session_id);
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceGetPersonIds(FaceGetPersonIdsRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceGetPersonIdsInfo();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("group_id", request.getGroupId());
        httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceGetFaceIds(FaceGetFaceIdsRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceGetFaceIdsInfo();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("person_id", request.getPersonId());
        httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceGetFaceInfo(FaceGetFaceInfoRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceGetFaceInfo();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("face_id", request.getFaceId());
        httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String faceIdentify(FaceIdentifyRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceIdentify();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.setMethod(HttpMethod.POST);
        String groupId = request.getGroupId();
        String[] groupIds = request.getGroupIds();
        if (request.isUrl()) {
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.addParam("url", request.getUrl());
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
            if (groupId != null && !groupId.isEmpty()) {
                httpRequest.addParam("group_id", groupId);
                return this.httpClient.sendHttpRequest(httpRequest);
            } else {
                if (groupIds == null || groupIds.length <= 0) throw new ParamException("groupId and groupIds both null or empty!!");
                httpRequest.addParam("group_ids", request.getGroupIds());
            }
            return this.httpClient.sendHttpRequest(httpRequest);
        } else {
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
            httpRequest.addFile("image", request.getImage());
            AbstractBaseRequest.BytesContent bytesContent = request.getBytesContent();
            if (bytesContent != null) {
                httpRequest.addBytes(bytesContent.getKey(), bytesContent.getContent());
            }
            if (groupId != null && !groupId.isEmpty()) {
                httpRequest.addParam("group_id", groupId);
                return this.httpClient.sendHttpRequest(httpRequest);
            } else {
                if (groupIds == null || groupIds.length <= 0) throw new ParamException("groupId and groupIds both null or empty!!");
                for (int index = 0; index < groupIds.length; ++index) {
                    String key = String.format("group_ids[%d]", index);
                    String data = groupIds[index];
                    httpRequest.addParam(key, data);
                }
            }
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceVerify(FaceVerifyRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceVerify();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("person_id", request.getPersonId());
        httpRequest.setMethod(HttpMethod.POST);
        if (request.isUrl()) {
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.addParam("url", request.getUrl());
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        } else {
            httpRequest.addFile("image", request.getImage());
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceCompare(FaceCompareRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceCompare();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.setMethod(HttpMethod.POST);
        if (request.isUrl()) {
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.addParam("urlA", request.getUrlA());
            httpRequest.addParam("urlB", request.getUrlB());
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        } else {
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
            HashMap<String, String> keys = request.getKeyList();
            HashMap<String, File> images = request.getImageList();
            for (String k : keys.keySet()) {
                httpRequest.addFile(keys.get(k), images.get(k));
            }
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String faceMultiIdentify(FaceMultiIdentifyRequest request, boolean useNewDomain) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = useNewDomain ? "http://recognition.image.myqcloud.com/face/multidentify" : "http://service.image.myqcloud.com/face/multidentify";
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setMethod(HttpMethod.POST);
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        String session_id = request.getSession_id();
        if (session_id != null && !session_id.isEmpty()) {
            httpRequest.addParam("session_id", session_id);
        }
        if (request.isUrl()) {
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
            httpRequest.addParam("url", request.getImageUrl());
            String[] groupIds = request.getGroup_ids();
            if (groupIds != null && groupIds.length == 1) {
                httpRequest.addParam("group_id", groupIds[0]);
                return this.httpClient.sendHttpRequest(httpRequest);
            } else {
                if (groupIds == null || groupIds.length <= 1) throw new ParamException("group_ids can not be null or empty!!");
                httpRequest.addParam("group_ids", groupIds);
            }
            return this.httpClient.sendHttpRequest(httpRequest);
        } else {
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
            httpRequest.addFile("image", request.getImageFile());
            String[] groupIds = request.getGroup_ids();
            if (groupIds != null && groupIds.length == 1) {
                httpRequest.addParam("group_id", groupIds[0]);
                return this.httpClient.sendHttpRequest(httpRequest);
            } else {
                if (groupIds == null || groupIds.length <= 1) throw new ParamException("group_ids can not be null or empty!!");
                for (int index = 0; index < groupIds.length; ++index) {
                    String key = String.format("group_ids[%d]", index);
                    String data = groupIds[index];
                    httpRequest.addParam(key, data);
                }
            }
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceIdCardCompare(FaceIdCardCompareRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceIdcardCompare();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("idcard_number", request.getIdcardNumber());
        httpRequest.addParam("idcard_name", request.getIdcardName());
        httpRequest.addParam("session_id", request.getSessionId());
        httpRequest.setMethod(HttpMethod.POST);
        if (request.isUrl()) {
            httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
            httpRequest.addParam("url", request.getUrl());
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        } else {
            httpRequest.addFile("image", request.getImage());
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceLiveGetFour(FaceLiveGetFourRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceLiveGetFour();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        if (request.getSeq() != null && request.getSeq().trim().length() != 0) {
            httpRequest.addParam("seq", request.getSeq());
        }
        httpRequest.addHeader("Content-Type", String.valueOf((Object)HttpContentType.APPLICATION_JSON));
        httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceIdCardLiveDetectFour(FaceIdCardLiveDetectFourRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceIdCardLiveDetectFour();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("idcard_number", request.getIdcardNumber());
        httpRequest.addParam("idcard_name", request.getIdcardName());
        httpRequest.addParam("validate_data", request.getValidate());
        if (request.getSeq() != null && request.getSeq().trim().length() != 0) {
            httpRequest.addParam("seq", request.getSeq());
        }
        httpRequest.addFile("video", request.getVideo());
        httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
        httpRequest.setMethod(HttpMethod.POST);
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceLiveDetectFour(FaceLiveDetectFourRequest request) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = "http://" + this.config.getQCloudImageDomain() + this.config.getFaceLiveDetectFour();
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        httpRequest.addParam("bucket", request.getBucketName());
        httpRequest.addParam("validate_data", request.getValidate());
        httpRequest.addParam("compare_flag", request.getCompareFlag());
        if (request.getSeq() != null && request.getSeq().trim().length() != 0) {
            httpRequest.addParam("seq", request.getSeq());
        }
        httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
        HashMap<String, String> keys = request.getKeyList();
        HashMap<String, File> images = request.getImageList();
        for (String k : keys.keySet()) {
            httpRequest.addFile(keys.get(k), images.get(k));
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }

    public String faceLiveDetectPicture(FaceLiveDetectPictureRequest request, boolean useNewDomain) throws AbstractImageException {
        request.check_param();
        String sign = Sign.appSign(this.cred, request.getBucketName(), this.config.getSignExpired());
        String url = useNewDomain ? "http://recognition.image.myqcloud.com/face/livedetectpicture" : "http://service.image.myqcloud.com/face/livedetectpicture";
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(url);
        httpRequest.addHeader("Authorization", sign);
        httpRequest.addHeader("User-Agent", this.config.getUserAgent());
        httpRequest.addParam("appid", String.valueOf(this.cred.getAppId()));
        if (request.isUrl()) {
            httpRequest.setContentType(HttpContentType.APPLICATION_JSON);
            httpRequest.addParam("url", request.getImageUrl());
        } else {
            httpRequest.setContentType(HttpContentType.MULTIPART_FORM_DATA);
            httpRequest.addFile("image", request.getImage());
            AbstractBaseRequest.BytesContent bytesContent = request.getBytesContent();
            if (bytesContent != null) {
                httpRequest.addBytes(bytesContent.getKey(), bytesContent.getContent());
            }
        }
        return this.httpClient.sendHttpRequest(httpRequest);
    }
}

