/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.image.request;

import com.qcloud.image.common_utils.CommonParamCheckUtils;
import com.qcloud.image.exception.ParamException;

public abstract class AbstractBaseRequest {
    private String bucketName;
    private BytesContent mBytesContent;

    public AbstractBaseRequest(String bucketName) {
        this.bucketName = bucketName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    protected String getMemberStringValue(String member) {
        if (member != null) {
            return member;
        }
        return "null";
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("bucketName:").append(this.getMemberStringValue(this.bucketName));
        return sb.toString();
    }

    public void check_param() throws ParamException {
        CommonParamCheckUtils.AssertNotNull("bucketName", this.bucketName);
    }

    void setBytesContent(String key, byte[] content) {
        this.mBytesContent = new BytesContent(key, content);
    }

    public BytesContent getBytesContent() {
        return this.mBytesContent;
    }

    public static class BytesContent {
        String key;
        byte[] content;

        BytesContent(String key, byte[] content) {
            this.key = key;
            this.content = content;
        }

        public String getKey() {
            return this.key;
        }

        public byte[] getContent() {
            return this.content;
        }
    }
}

